/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.jupyter.nbformat.Cell;
import org.apache.zeppelin.jupyter.nbformat.CodeCell;
import org.apache.zeppelin.jupyter.nbformat.DisplayData;
import org.apache.zeppelin.jupyter.nbformat.Error;
import org.apache.zeppelin.jupyter.nbformat.ExecuteResult;
import org.apache.zeppelin.jupyter.nbformat.HeadingCell;
import org.apache.zeppelin.jupyter.nbformat.MarkdownCell;
import org.apache.zeppelin.jupyter.nbformat.Nbformat;
import org.apache.zeppelin.jupyter.nbformat.Output;
import org.apache.zeppelin.jupyter.nbformat.RawCell;
import org.apache.zeppelin.jupyter.nbformat.Stream;
import org.apache.zeppelin.jupyter.parser.MarkdownParser;
import org.apache.zeppelin.jupyter.zformat.Note;
import org.apache.zeppelin.jupyter.zformat.Paragraph;
import org.apache.zeppelin.jupyter.zformat.Result;
import org.apache.zeppelin.jupyter.zformat.TypeData;

public class JupyterUtil {
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();
    private final RuntimeTypeAdapterFactory<Cell> cellTypeFactory = RuntimeTypeAdapterFactory.of(Cell.class, (String)"cell_type").registerSubtype(MarkdownCell.class, "markdown").registerSubtype(CodeCell.class, "code").registerSubtype(RawCell.class, "raw").registerSubtype(HeadingCell.class, "heading");
    private final RuntimeTypeAdapterFactory<Output> outputTypeFactory = RuntimeTypeAdapterFactory.of(Output.class, (String)"output_type").registerSubtype(ExecuteResult.class, "execute_result").registerSubtype(DisplayData.class, "display_data").registerSubtype(Stream.class, "stream").registerSubtype(Error.class, "error");
    private final MarkdownParser markdownParser = new MarkdownParser();

    public Nbformat getNbformat(Reader in) {
        return this.getNbformat(in, new GsonBuilder());
    }

    public Nbformat getNbformat(Reader in, GsonBuilder gsonBuilder) {
        return (Nbformat)this.getGson(gsonBuilder).fromJson(in, Nbformat.class);
    }

    public Note getNote(Reader in, String id, String codeReplaced, String markdownReplaced) {
        return this.getNote(in, id, new GsonBuilder(), codeReplaced, markdownReplaced);
    }

    public Note getNote(Reader in, String id, GsonBuilder gsonBuilder, String codeReplaced, String markdownReplaced) {
        return this.getNote(this.getNbformat(in, gsonBuilder), id, codeReplaced, markdownReplaced);
    }

    public Note getNote(Nbformat nbformat, String id, String codeReplaced, String markdownReplaced) {
        Note note = new Note();
        String name = nbformat.getMetadata().getTitle();
        if (null == name) {
            name = "Note converted from Jupyter_" + id;
        }
        note.setName(name);
        String lineSeparator = System.lineSeparator();
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        for (Cell cell : nbformat.getCells()) {
            String interpreterName;
            String status = "SUCCESS";
            Paragraph paragraph = new Paragraph();
            ArrayList<TypeData> typeDataList = new ArrayList<TypeData>();
            Object cellSource = cell.getSource();
            ArrayList<String> sourceRaws = new ArrayList<String>();
            if (cellSource instanceof String) {
                sourceRaws.add((String)cellSource);
            } else {
                sourceRaws.addAll((List)cellSource);
            }
            List<String> source = Output.verifyEndOfLine(sourceRaws);
            String codeText = StringUtils.join(source, (String)"");
            if (cell instanceof CodeCell) {
                interpreterName = codeReplaced;
                for (Output output : ((CodeCell)cell).getOutputs()) {
                    Stream streamOutput;
                    if (output instanceof Error) {
                        typeDataList.add(output.toZeppelinResult());
                        continue;
                    }
                    typeDataList.add(output.toZeppelinResult());
                    if (!(output instanceof Stream) || !(streamOutput = (Stream)output).isError()) continue;
                    status = "ERROR";
                }
            } else if (cell instanceof MarkdownCell || cell instanceof HeadingCell) {
                interpreterName = markdownReplaced;
                String markdownContent = this.markdownParser.render(codeText);
                typeDataList.add(new TypeData("HTML", markdownContent));
                paragraph.setUpMarkdownConfig(true);
            } else {
                interpreterName = "";
            }
            paragraph.setText(interpreterName + lineSeparator + codeText);
            paragraph.setResults(new Result(status, typeDataList));
            paragraphs.add(paragraph);
        }
        note.setParagraphs(paragraphs);
        return note;
    }

    private Gson getGson(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapterFactory(this.cellTypeFactory).registerTypeAdapterFactory(this.outputTypeFactory).create();
    }

    public String getJson(String input, String id, String codeReplaced, String markdownReplaced) {
        Note note = this.getNote(new StringReader(input), id, codeReplaced, markdownReplaced);
        return new Gson().toJson((Object)note);
    }

    public String getNbformat(String note) {
        Note noteFormat = (Note)this.getGson(new GsonBuilder()).fromJson(note, Note.class);
        JsonObject nbformat = new JsonObject();
        JsonArray cells = new JsonArray();
        Pattern mdPattern = Pattern.compile("%md\\s.*", 32);
        Pattern sqlPattern = Pattern.compile("%sql\\s", 32);
        Pattern unknownMagicPattern = Pattern.compile("%\\w+\\s", 32);
        Pattern htmlPattern = Pattern.compile("%html\\s", 32);
        Pattern sparkPattern = Pattern.compile("%spark\\s", 32);
        int index = 0;
        for (Paragraph paragraph : noteFormat.getParagraphs()) {
            JsonObject metadataJson;
            String code = StringUtils.stripStart((String)paragraph.getText(), (String)" ");
            JsonObject codeJson = new JsonObject();
            if (code == null || code.trim().isEmpty()) continue;
            if (mdPattern.matcher(code).matches()) {
                codeJson.addProperty("cell_type", "markdown");
                codeJson.add("metadata", (JsonElement)new JsonObject());
                codeJson.addProperty("source", StringUtils.stripStart((String)StringUtils.stripStart((String)code, (String)"%md"), (String)"\n"));
            } else if (sqlPattern.matcher(code).matches() || htmlPattern.matcher(code).matches()) {
                codeJson.addProperty("cell_type", "code");
                codeJson.addProperty("execution_count", (Number)index);
                codeJson.add("metadata", (JsonElement)new JsonObject());
                codeJson.add("outputs", (JsonElement)new JsonArray());
                codeJson.addProperty("source", "%" + code);
            } else if (sparkPattern.matcher(code).matches()) {
                codeJson.addProperty("cell_type", "code");
                codeJson.addProperty("execution_count", (Number)index);
                metadataJson = new JsonObject();
                metadataJson.addProperty("autoscroll", "auto");
                codeJson.add("metadata", (JsonElement)metadataJson);
                codeJson.add("outputs", (JsonElement)new JsonArray());
                codeJson.addProperty("source", code);
            } else if (unknownMagicPattern.matcher(code).matches()) {
                codeJson.addProperty("cell_type", "raw");
                metadataJson = new JsonObject();
                metadataJson.addProperty("format", "text/plain");
                codeJson.add("metadata", (JsonElement)metadataJson);
                codeJson.addProperty("source", code);
            } else {
                codeJson.addProperty("cell_type", "code");
                codeJson.addProperty("execution_count", (Number)index);
                metadataJson = new JsonObject();
                metadataJson.addProperty("autoscroll", "auto");
                codeJson.add("metadata", (JsonElement)metadataJson);
                codeJson.add("outputs", (JsonElement)new JsonArray());
                codeJson.addProperty("source", code);
            }
            cells.add((JsonElement)codeJson);
            ++index;
        }
        JsonObject metadataJson = new JsonObject();
        JsonObject kernelspecJson = new JsonObject();
        kernelspecJson.addProperty("language", "scala");
        kernelspecJson.addProperty("name", "spark2-scala");
        JsonObject languageInfoJson = new JsonObject();
        languageInfoJson.addProperty("codemirror_mode", "text/x-scala");
        languageInfoJson.addProperty("file_extension", ".scala");
        languageInfoJson.addProperty("mimetype", "text/x-scala");
        languageInfoJson.addProperty("name", "scala");
        languageInfoJson.addProperty("pygments_lexer", "scala");
        metadataJson.addProperty("name", noteFormat.getName());
        metadataJson.add("kernelspec", (JsonElement)kernelspecJson);
        metadataJson.add("language_info", (JsonElement)languageInfoJson);
        nbformat.add("metadata", (JsonElement)metadataJson);
        nbformat.addProperty("nbformat", (Number)4);
        nbformat.addProperty("nbformat_minor", (Number)2);
        nbformat.add("cells", (JsonElement)cells);
        return PRETTY_GSON.toJson((JsonElement)nbformat);
    }

    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        options.addOption("i", true, "Jupyter notebook file");
        options.addOption("o", true, "Zeppelin note file. Default: note.json");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (!cmd.hasOption("i")) {
            new HelpFormatter().printHelp("java " + JupyterUtil.class.getName(), options);
            System.exit(1);
        }
        Path jupyterPath = Paths.get(cmd.getOptionValue("i"), new String[0]);
        Path zeppelinPath = Paths.get(cmd.hasOption("o") ? cmd.getOptionValue("o") : "note.json", new String[0]);
        try (BufferedReader in = new BufferedReader(new FileReader(jupyterPath.toFile()));
             FileWriter fw = new FileWriter(zeppelinPath.toFile());){
            Note note = new JupyterUtil().getNote(in, "id", "%python", "%md");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)note, (Appendable)fw);
        }
    }
}

