/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.types;

import org.apache.zeppelin.jupyter.types.ZeppelinOutputType;

public enum JupyterOutputType {
    TEXT_PLAIN("text/plain"),
    IMAGE_PNG("image/png"),
    LATEX("text/latex"),
    SVG_XML("image/svg+xml"),
    TEXT_HTML("text/html"),
    APPLICATION_JAVASCRIPT("application/javascript");

    private final String type;

    private JupyterOutputType(String type) {
        this.type = type;
    }

    public ZeppelinOutputType getZeppelinType() {
        return Convertor.ToZeppelin.getType(this.type);
    }

    public static JupyterOutputType getByValue(String value) {
        for (JupyterOutputType type : JupyterOutputType.values()) {
            if (!type.toString().equals(value)) continue;
            return type;
        }
        return TEXT_PLAIN;
    }

    public String toString() {
        return this.type;
    }

    private static enum Convertor {
        ToZeppelin;


        public ZeppelinOutputType getType(String typeValue) {
            JupyterOutputType type = JupyterOutputType.getByValue(typeValue);
            ZeppelinOutputType outputType = TEXT_PLAIN == type ? ZeppelinOutputType.TEXT : ZeppelinOutputType.HTML;
            return outputType;
        }
    }
}

