/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.lib.Importable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class SimpleLibrary<T extends Importable> {
    private Map<String, T> lib = new HashMap<String, T>();
    private Set<String> disabled = new HashSet<String>();

    protected SimpleLibrary(boolean registerDefaults) {
        this(registerDefaults, null);
    }

    protected SimpleLibrary(boolean registerDefaults, Set<String> disabled) {
        if (disabled != null) {
            this.disabled = ImmutableSet.copyOf(disabled);
        }
        if (registerDefaults) {
            this.registerDefaults();
        }
    }

    protected abstract void registerDefaults();

    public T fetch(String item) {
        if (this.disabled.contains(item)) {
            throw new DisabledException(item);
        }
        return (T)((Importable)this.lib.get(item));
    }

    @SafeVarargs
    public final List<T> registerClasses(Class<? extends T> ... itemClass) {
        try {
            ArrayList<Importable> instances = new ArrayList<Importable>();
            for (Class<T> clazz : itemClass) {
                Importable instance = (Importable)clazz.newInstance();
                this.register(instance);
                instances.add(instance);
            }
            return instances;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public void register(T obj) {
        this.register(obj.getName(), obj);
    }

    public void register(String name, T obj) {
        if (!this.disabled.contains(obj.getName())) {
            this.lib.put(name, obj);
        }
    }

    public Collection<T> entries() {
        return this.lib.values().stream().filter(t2 -> !this.disabled.contains(t2.getName())).collect(Collectors.toSet());
    }
}

