/*
 * Decompiled with CFR 0.152.
 */
package jtermios.windows;

import com.sun.jna.Memory;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.windows.WinAPI;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private volatile int m_ErrNo = 0;
    private volatile boolean[] m_PortFDs = new boolean[256];
    private volatile Hashtable<Integer, Port> m_OpenPorts = new Hashtable();

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return this.m_ErrNo;
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        termios2.c_iflag &= ~(JTermios.IGNBRK | JTermios.BRKINT | JTermios.PARMRK | JTermios.ISTRIP | JTermios.INLCR | JTermios.IGNCR | JTermios.ICRNL | JTermios.IXON);
        termios2.c_oflag &= ~JTermios.OPOST;
        termios2.c_lflag &= ~(JTermios.ECHO | JTermios.ECHONL | JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN);
        termios2.c_cflag &= ~(JTermios.CSIZE | JTermios.PARENB);
        termios2.c_cflag |= JTermios.CS8;
    }

    @Override
    public int fcntl(int n, int n2, int n3) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        if (JTermios.F_SETFL != n2) {
            if (JTermios.F_GETFL == n2) {
                return port.m_OpenFlags;
            }
            this.m_ErrNo = JTermios.ENOTSUP;
            return -1;
        }
        port.m_OpenFlags = n3;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tcdrain(int n) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        try {
            Memory memory = port.m_WrBuffer;
            synchronized (memory) {
                if (!WinAPI.FlushFileBuffers(port.m_Comm)) {
                    port.fail();
                }
                return 0;
            }
        }
        catch (Fail fail) {
            return -1;
        }
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return termios2.c_ispeed;
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return termios2.c_ospeed;
    }

    @Override
    public int cfsetispeed(Termios termios2, int n) {
        termios2.c_ispeed = n;
        return 0;
    }

    @Override
    public int cfsetospeed(Termios termios2, int n) {
        termios2.c_ospeed = n;
        return 0;
    }

    @Override
    public int open(String string, int n) {
        Port port = new Port();
        port.m_OpenFlags = n;
        try {
            if (!string.startsWith("\\\\")) {
                string = "\\\\.\\" + string;
            }
            port.m_Comm = WinAPI.CreateFileW(new WString(string), -1073741824, 0, null, 3, 0x40000000, null);
            if (WinAPI.INVALID_HANDLE_VALUE == port.m_Comm) {
                this.m_ErrNo = WinAPI.GetLastError() == 2 ? JTermios.ENOENT : JTermios.EBUSY;
                port.fail();
            }
            if (!WinAPI.SetupComm(port.m_Comm, (int)port.m_RdBuffer.size(), (int)port.m_WrBuffer.size())) {
                port.fail();
            }
            this.cfmakeraw(port.m_Termios);
            this.cfsetispeed(port.m_Termios, JTermios.B9600);
            this.cfsetospeed(port.m_Termios, JTermios.B9600);
            port.m_Termios.c_cc[JTermios.VTIME] = 0;
            port.m_Termios.c_cc[JTermios.VMIN] = 0;
            this.updateFromTermios(port);
            port.m_RdOVL.writeField("hEvent", WinAPI.CreateEventA(null, true, false, null));
            if (port.m_RdOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                port.fail();
            }
            port.m_WrOVL.writeField("hEvent", WinAPI.CreateEventA(null, true, false, null));
            if (port.m_WrOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                port.fail();
            }
            port.m_SelOVL.writeField("hEvent", WinAPI.CreateEventA(null, true, false, null));
            if (port.m_SelOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                port.fail();
            }
            return port.m_FD;
        }
        catch (Exception exception) {
            if (port != null) {
                port.close();
            }
            return -1;
        }
    }

    private static void nanoSleep(long l) throws Fail {
        try {
            Thread.sleep((int)(l / 1000000L), (int)(l % 1000000L));
        }
        catch (InterruptedException interruptedException) {
            throw new Fail();
        }
    }

    private int getCharBits(Termios termios2) {
        int n = 8;
        if ((termios2.c_cflag & JTermios.CSIZE) == JTermios.CS5) {
            n = 5;
        }
        if ((termios2.c_cflag & JTermios.CSIZE) == JTermios.CS6) {
            n = 6;
        }
        if ((termios2.c_cflag & JTermios.CSIZE) == JTermios.CS7) {
            n = 7;
        }
        if ((termios2.c_cflag & JTermios.CSIZE) == JTermios.CS8) {
            n = 8;
        }
        if ((termios2.c_cflag & JTermios.CSTOPB) != 0) {
            ++n;
        }
        if ((termios2.c_cflag & JTermios.PARENB) != 0) {
            ++n;
        }
        return n += 2;
    }

    private static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int n, byte[] byArray, int n2) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_RdBuffer;
        synchronized (memory) {
            try {
                if ((long)n2 > port.m_RdBuffer.size()) {
                    n2 = (int)port.m_RdBuffer.size();
                }
                if (n2 == 0) {
                    return 0;
                }
                if ((port.m_OpenFlags & JTermios.O_NONBLOCK) != 0) {
                    this.clearCommErrors(port);
                    int n3 = port.m_COMSTAT.cbInQue;
                    if (n3 == 0) {
                        this.m_ErrNo = JTermios.EAGAIN;
                        return -1;
                    }
                    n2 = JTermiosImpl.min(n2, n3);
                } else {
                    this.clearCommErrors(port);
                    int n4 = port.m_COMSTAT.cbInQue;
                    int n5 = 0xFF & port.m_Termios.c_cc[JTermios.VTIME];
                    int n6 = 0xFF & port.m_Termios.c_cc[JTermios.VMIN];
                    if (n6 == 0 && n5 == 0) {
                        if (n4 == 0) {
                            return 0;
                        }
                        n2 = JTermiosImpl.min(n2, n4);
                    }
                    if (n6 != 0 || n5 > 0) {
                        // empty if block
                    }
                    if (n6 > 0 && n5 > 0) {
                        n2 = JTermiosImpl.min(JTermiosImpl.max(n6, n4), n2);
                    }
                    if (n6 > 0 && n5 == 0) {
                        n2 = JTermiosImpl.min(JTermiosImpl.max(n6, n4), n2);
                    }
                }
                if (!WinAPI.ResetEvent(port.m_RdOVL.hEvent)) {
                    port.fail();
                }
                if (!WinAPI.ReadFile(port.m_Comm, port.m_RdBuffer, n2, port.m_RdN, port.m_RdOVL)) {
                    if (WinAPI.GetLastError() != 997) {
                        port.fail();
                    }
                    if (WinAPI.WaitForSingleObject(port.m_RdOVL.hEvent, -1) != 0) {
                        port.fail();
                    }
                    if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_RdOVL, port.m_RdN, true)) {
                        port.fail();
                    }
                }
                port.m_RdBuffer.read(0L, byArray, 0, port.m_RdN[0]);
                return port.m_RdN[0];
            }
            catch (Fail fail) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int n, byte[] byArray, int n2) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_WrBuffer;
        synchronized (memory) {
            try {
                int n3;
                if (port.m_WritePending > 0) {
                    while ((n3 = WinAPI.WaitForSingleObject(port.m_WrOVL.hEvent, -1)) == 258) {
                        this.clearCommErrors(port);
                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "write pending, cbInQue %d cbOutQue %d\n", port.m_COMSTAT.cbInQue, port.m_COMSTAT.cbOutQue);
                    }
                    if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_WrOVL, port.m_WrN, false)) {
                        port.fail();
                    }
                    if (port.m_WrN[0] != port.m_WritePending) {
                        new RuntimeException("Windows OVERLAPPED WriteFile failed to write all, tried to write " + port.m_WritePending + " but got " + port.m_WrN[0]);
                    }
                    port.m_WritePending = 0;
                }
                if ((port.m_OpenFlags & JTermios.O_NONBLOCK) != 0) {
                    if (!WinAPI.ClearCommError(port.m_Comm, port.m_WrErr, port.m_WrStat)) {
                        port.fail();
                    }
                    if (n2 > (n3 = (int)port.m_WrBuffer.size() - port.m_WrStat.cbOutQue)) {
                        n2 = n3;
                    }
                }
                if (!WinAPI.ResetEvent(port.m_WrOVL.hEvent)) {
                    port.fail();
                }
                if ((long)n2 > port.m_WrBuffer.size()) {
                    n2 = (int)port.m_WrBuffer.size();
                }
                port.m_WrBuffer.write(0L, byArray, 0, n2);
                boolean bl = WinAPI.WriteFile(port.m_Comm, port.m_WrBuffer, n2, port.m_WrN, port.m_WrOVL);
                if (!bl) {
                    if (WinAPI.GetLastError() != 997) {
                        port.fail();
                    }
                    port.m_WritePending = n2;
                }
                return n2;
            }
            catch (Fail fail) {
                return -1;
            }
        }
    }

    @Override
    public int close(int n) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        port.close();
        return 0;
    }

    @Override
    public int tcflush(int n, int n2) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        try {
            if (n2 == JTermios.TCIFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 2)) {
                    port.fail();
                }
            } else if (n2 == JTermios.TCOFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 1)) {
                    port.fail();
                }
            } else if (n2 == JTermios.TCIOFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 1)) {
                    port.fail();
                }
                if (!WinAPI.PurgeComm(port.m_Comm, 2)) {
                    port.fail();
                }
            } else {
                this.m_ErrNo = JTermios.ENOTSUP;
                return -1;
            }
            return 0;
        }
        catch (Fail fail) {
            return -1;
        }
    }

    @Override
    public int tcgetattr(int n, Termios termios2) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        termios2.set(port.m_Termios);
        return 0;
    }

    @Override
    public int tcsendbreak(int n, int n2) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        try {
            if (!WinAPI.SetCommBreak(port.m_Comm)) {
                port.fail();
            }
            JTermiosImpl.nanoSleep((long)n2 * 250000000L);
            if (!WinAPI.ClearCommBreak(port.m_Comm)) {
                port.fail();
            }
            return 0;
        }
        catch (Fail fail) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tcsetattr(int n, int n2, Termios termios2) {
        Port port;
        if (n2 != JTermios.TCSANOW) {
            JTermios.JTermiosLogging.log(0, "tcsetattr only supports TCSANOW\n", new Object[0]);
        }
        if ((port = this.getPort(n)) == null) {
            return -1;
        }
        Termios termios3 = port.m_Termios;
        synchronized (termios3) {
            try {
                port.m_Termios.set(termios2);
                this.updateFromTermios(port);
                return 0;
            }
            catch (Fail fail) {
                return -1;
            }
        }
    }

    public int updateFromTermios(Port port) throws Fail {
        int n;
        Termios termios2 = port.m_Termios;
        int n2 = termios2.c_ospeed;
        int n3 = termios2.c_cflag;
        int n4 = termios2.c_iflag;
        int n5 = termios2.c_oflag;
        if (n2 != port.m_c_speed || n3 != port.m_c_cflag || n4 != port.m_c_iflag || n5 != port.m_c_oflag) {
            WinAPI.DCB dCB = port.m_DCB;
            if (!WinAPI.GetCommState(port.m_Comm, dCB)) {
                port.fail();
            }
            dCB.DCBlength = dCB.size();
            dCB.BaudRate = n2;
            if (termios2.c_ospeed != termios2.c_ispeed) {
                JTermios.JTermiosLogging.log(0, "c_ospeed (%d) != c_ispeed (%d)\n", termios2.c_ospeed, termios2.c_ispeed);
            }
            n = 0;
            n |= 1;
            if ((n3 & JTermios.PARENB) != 0) {
                n |= 2;
            }
            if ((n4 & JTermios.IXON) != 0) {
                n |= 0x100;
            }
            if ((n4 & JTermios.IXOFF) != 0) {
                n |= 0x200;
            }
            if ((n4 & JTermios.IXANY) != 0) {
                n |= 0x80;
            }
            if ((n4 & JTermios.CRTSCTS) != 0) {
                n |= 0x3000;
                n |= 4;
            }
            dCB.fFlags = n;
            int n6 = 8;
            int n7 = n3 & JTermios.CSIZE;
            if (n7 == JTermios.CS5) {
                n6 = 5;
            }
            if (n7 == JTermios.CS6) {
                n6 = 6;
            }
            if (n7 == JTermios.CS7) {
                n6 = 7;
            }
            if (n7 == JTermios.CS8) {
                n6 = 8;
            }
            dCB.ByteSize = (byte)n6;
            dCB.Parity = (n3 & JTermios.PARENB) != 0 ? ((n3 & JTermios.PARODD) != 0 && (n3 & JTermios.CMSPAR) != 0 ? (byte)3 : ((n3 & JTermios.PARODD) != 0 ? (byte)1 : ((n3 & JTermios.CMSPAR) != 0 ? (byte)4 : (byte)2))) : (byte)0;
            dCB.StopBits = (byte)((n3 & JTermios.CSTOPB) != 0 ? 2 : 0);
            dCB.XonChar = termios2.c_cc[JTermios.VSTART];
            dCB.XoffChar = termios2.c_cc[JTermios.VSTOP];
            dCB.ErrorChar = 0;
            dCB.EvtChar = (byte)10;
            dCB.EofChar = termios2.c_cc[JTermios.VEOF];
            if (!WinAPI.SetCommState(port.m_Comm, dCB)) {
                port.fail();
            }
            port.m_c_speed = n2;
            port.m_c_cflag = n3;
            port.m_c_iflag = n4;
            port.m_c_oflag = n5;
        }
        int n8 = port.m_Termios.c_cc[JTermios.VMIN] & 0xFF;
        n = (port.m_Termios.c_cc[JTermios.VTIME] & 0xFF) * 100;
        if (n8 != port.m_VMIN || n != port.m_VTIME) {
            WinAPI.COMMTIMEOUTS cOMMTIMEOUTS = port.m_Timeouts;
            cOMMTIMEOUTS.WriteTotalTimeoutConstant = 0;
            cOMMTIMEOUTS.WriteTotalTimeoutMultiplier = 0;
            if (n8 == 0 && n == 0) {
                cOMMTIMEOUTS.ReadIntervalTimeout = -1;
                cOMMTIMEOUTS.ReadTotalTimeoutConstant = 0;
                cOMMTIMEOUTS.ReadTotalTimeoutMultiplier = 0;
            }
            if (n8 == 0 && n > 0) {
                cOMMTIMEOUTS.ReadIntervalTimeout = 0;
                cOMMTIMEOUTS.ReadTotalTimeoutConstant = n;
                cOMMTIMEOUTS.ReadTotalTimeoutMultiplier = 0;
            }
            if (n8 > 0 && n > 0) {
                cOMMTIMEOUTS.ReadIntervalTimeout = n;
                cOMMTIMEOUTS.ReadTotalTimeoutConstant = 0;
                cOMMTIMEOUTS.ReadTotalTimeoutMultiplier = 0;
            }
            if (n8 > 0 && n == 0) {
                cOMMTIMEOUTS.ReadIntervalTimeout = 0;
                cOMMTIMEOUTS.ReadTotalTimeoutConstant = 0;
                cOMMTIMEOUTS.ReadTotalTimeoutMultiplier = 0;
            }
            if (!WinAPI.SetCommTimeouts(port.m_Comm, port.m_Timeouts)) {
                port.fail();
            }
            port.m_VMIN = n8;
            port.m_VTIME = n;
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(2, "vmin %d vtime %d ReadIntervalTimeout %d ReadTotalTimeoutConstant %d ReadTotalTimeoutMultiplier %d\n", n8, n, cOMMTIMEOUTS.ReadIntervalTimeout, cOMMTIMEOUTS.ReadTotalTimeoutConstant, cOMMTIMEOUTS.ReadTotalTimeoutMultiplier);
        }
        return 0;
    }

    private int maskToFDSets(Port port, FDSet fDSet, FDSet fDSet2, FDSet fDSet3, int n) throws Fail {
        this.clearCommErrors(port);
        int n2 = port.m_EventFlags.getValue();
        int n3 = port.m_FD;
        if ((n2 & 1) != 0 && port.m_COMSTAT.cbInQue > 0) {
            this.FD_SET(n3, fDSet);
            ++n;
        }
        if ((n2 & 4) != 0 && port.m_COMSTAT.cbOutQue == 0) {
            this.FD_SET(n3, fDSet2);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCommErrors(Port port) throws Fail {
        WinAPI.COMSTAT cOMSTAT = port.m_COMSTAT;
        synchronized (cOMSTAT) {
            if (!WinAPI.ClearCommError(port.m_Comm, port.m_ClearErr, port.m_COMSTAT)) {
                port.fail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(int n, FDSet fDSet, FDSet fDSet2, FDSet fDSet3, TimeVal timeVal) {
        int n2;
        block38: {
            int n3;
            n2 = 0;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            try {
                Object object;
                Object object2;
                int n6;
                LinkedList linkedList2 = new LinkedList();
                for (n3 = 0; n3 < n; ++n3) {
                    int port;
                    n6 = this.FD_ISSET(n3, fDSet);
                    boolean n5 = this.FD_ISSET(n3, fDSet2);
                    this.FD_CLR(n3, fDSet);
                    this.FD_CLR(n3, fDSet2);
                    if (n6 == 0 && !n5) continue;
                    object2 = this.getPort(n3);
                    if (object2 == null) {
                        port = -1;
                        return port;
                    }
                    try {
                        ((Port)object2).lock();
                        linkedList.add(object2);
                        this.clearCommErrors((Port)object2);
                        if (n6 != 0 && ((Port)object2).m_COMSTAT.cbInQue > 0) {
                            this.FD_SET(n3, fDSet);
                            ++n2;
                        }
                        if (n5 && ((Port)object2).m_COMSTAT.cbOutQue == 0) {
                            this.FD_SET(n3, fDSet2);
                            ++n2;
                        }
                        port = 0;
                        if (n6 != 0) {
                            port |= 1;
                        }
                        if (n5) {
                            port |= 4;
                        }
                        if (!WinAPI.GetCommMask(((Port)object2).m_Comm, (int[])(object = (Object)new int[]{0}))) {
                            ((Port)object2).fail();
                        }
                        boolean port2 = true;
                        if (object[0] == port) {
                            WinAPI.GetOverlappedResult(((Port)object2).m_Comm, ((Port)object2).m_SelOVL, ((Port)object2).m_SelN, false);
                            int n4 = WinAPI.GetLastError();
                            port2 = n4 != 996 && n4 != 997;
                        } else if (!WinAPI.SetCommMask(((Port)object2).m_Comm, port)) {
                            ((Port)object2).fail();
                        }
                        if (!port2) continue;
                        if (!WinAPI.ResetEvent(((Port)object2).m_SelOVL.hEvent)) {
                            ((Port)object2).fail();
                        }
                        if (WinAPI.WaitCommEvent(((Port)object2).m_Comm, ((Port)object2).m_EventFlags, ((Port)object2).m_SelOVL)) {
                            if (!WinAPI.GetOverlappedResult(((Port)object2).m_Comm, ((Port)object2).m_SelOVL, ((Port)object2).m_SelN, false)) {
                                ((Port)object2).fail();
                            }
                            n2 = this.maskToFDSets((Port)object2, fDSet, fDSet2, fDSet3, n2);
                            continue;
                        }
                        if (WinAPI.GetLastError() != 997) {
                            ((Port)object2).fail();
                        }
                        linkedList2.add(object2);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        this.m_ErrNo = JTermios.EINTR;
                        int n7 = -1;
                        for (Port port2 : linkedList) {
                            port2.unlock();
                        }
                        return n7;
                    }
                }
                if (n2 != 0) break block38;
                n3 = linkedList2.size();
                if (n3 > 0) {
                    WinAPI.HANDLE[] hANDLEArray = new WinAPI.HANDLE[linkedList2.size() * 2];
                    boolean bl = false;
                    object2 = linkedList2.iterator();
                    while (object2.hasNext()) {
                        Port port = (Port)object2.next();
                        hANDLEArray[var11_17++] = port.m_SelOVL.hEvent;
                        hANDLEArray[var11_17++] = port.m_CancelWaitSema4;
                    }
                    int n8 = timeVal != null ? (int)(timeVal.tv_sec * 1000L + timeVal.tv_usec / 1000L) : -1;
                    port = WinAPI.WaitForMultipleObjects(n3 * 2, hANDLEArray, false, n8);
                    if (port == 258) {
                        object = linkedList2.iterator();
                        while (object.hasNext()) {
                            Port port = (Port)object.next();
                            this.clearCommErrors(port);
                            int[] nArray = new int[]{0};
                            if (!WinAPI.GetCommMask(port.m_Comm, nArray)) {
                                port.fail();
                            }
                            if (port.m_COMSTAT.cbInQue > 0 && (nArray[0] & 1) != 0) {
                                this.FD_SET(port.m_FD, fDSet);
                                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "missed EV_RXCHAR event\n", new Object[0]);
                                int n9 = 1;
                                return n9;
                            }
                            if (port.m_COMSTAT.cbOutQue != 0 || (nArray[0] & 4) == 0) continue;
                            this.FD_SET(port.m_FD, fDSet2);
                            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "missed EV_TXEMPTY event\n", new Object[0]);
                            int n10 = 1;
                            return n10;
                        }
                    }
                    if (port != 258) {
                        int n11 = (port - 0) / 2;
                        if (n11 < 0 || n11 >= n3) {
                            throw new Fail();
                        }
                        object = (Port)linkedList2.get(n11);
                        if (!WinAPI.GetOverlappedResult(((Port)object).m_Comm, ((Port)object).m_SelOVL, ((Port)object).m_SelN, false)) {
                            ((Port)object).fail();
                        }
                        n2 = this.maskToFDSets((Port)object, fDSet, fDSet2, fDSet3, n2);
                    }
                    break block38;
                }
                if (timeVal == null) {
                    this.m_ErrNo = JTermios.EINVAL;
                    n6 = -1;
                    return n6;
                }
                JTermiosImpl.nanoSleep(timeVal.tv_sec * 1000000000L + timeVal.tv_usec * 1000L);
                n6 = 0;
                return n6;
            }
            catch (Fail fail) {
                n3 = -1;
                return n3;
            }
            finally {
                for (Port port : linkedList) {
                    port.unlock();
                }
            }
        }
        return n2;
    }

    @Override
    public int poll(Pollfd[] pollfdArray, int n, int n2) {
        this.m_ErrNo = JTermios.EINVAL;
        return -1;
    }

    @Override
    public int poll(int[] nArray, int n, int n2) {
        this.m_ErrNo = JTermios.EINVAL;
        return -1;
    }

    @Override
    public void perror(String string) {
        if (string != null && string.length() > 0) {
            System.out.print(string + ": ");
        }
        System.out.printf("%d\n", this.m_ErrNo);
    }

    private static int baudToDCB(int n) {
        switch (n) {
            case 110: {
                return 110;
            }
            case 300: {
                return 300;
            }
            case 600: {
                return 600;
            }
            case 1200: {
                return 1200;
            }
            case 2400: {
                return 2400;
            }
            case 4800: {
                return 4800;
            }
            case 9600: {
                return 9600;
            }
            case 14400: {
                return 14400;
            }
            case 19200: {
                return 19200;
            }
            case 38400: {
                return 38400;
            }
            case 57600: {
                return 57600;
            }
            case 115200: {
                return 115200;
            }
            case 128000: {
                return 128000;
            }
            case 256000: {
                return 256000;
            }
        }
        return n;
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public void FD_CLR(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] & ~(1 << n % 32);
    }

    @Override
    public boolean FD_ISSET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return false;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        return (fDSetImpl.bits[n / 32] & 1 << n % 32) != 0;
    }

    @Override
    public void FD_SET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] | 1 << n % 32;
    }

    @Override
    public void FD_ZERO(FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        Arrays.fill(fDSetImpl.bits, 0);
    }

    @Override
    public int ioctl(int n, int n2, int[] nArray) {
        Port port = this.getPort(n);
        if (port == null) {
            return -1;
        }
        try {
            if (n2 == JTermios.FIONREAD) {
                this.clearCommErrors(port);
                nArray[0] = port.m_COMSTAT.cbInQue;
                return 0;
            }
            if (n2 == JTermios.TIOCMSET) {
                int n3 = nArray[0];
                port.MSR = (n3 & JTermios.TIOCM_DTR) != 0 ? (port.MSR |= JTermios.TIOCM_DTR) : (port.MSR &= ~JTermios.TIOCM_DTR);
                if (!WinAPI.EscapeCommFunction(port.m_Comm, (n3 & JTermios.TIOCM_DTR) != 0 ? 5 : 6)) {
                    port.fail();
                }
                port.MSR = (n3 & JTermios.TIOCM_RTS) != 0 ? (port.MSR |= JTermios.TIOCM_RTS) : (port.MSR &= ~JTermios.TIOCM_RTS);
                if (!WinAPI.EscapeCommFunction(port.m_Comm, (n3 & JTermios.TIOCM_RTS) != 0 ? 3 : 4)) {
                    port.fail();
                }
                return 0;
            }
            if (n2 == JTermios.TIOCMGET) {
                int[] nArray2 = new int[]{0};
                if (!WinAPI.GetCommModemStatus(port.m_Comm, nArray2)) {
                    port.fail();
                }
                int n4 = nArray2[0];
                int n5 = nArray[0];
                n5 = (n4 & 0x80) != 0 ? (n5 |= JTermios.TIOCM_CAR) : (n5 &= ~JTermios.TIOCM_CAR);
                n5 = (n4 & 0x40) != 0 ? (n5 |= JTermios.TIOCM_RNG) : (n5 &= ~JTermios.TIOCM_RNG);
                n5 = (n4 & 0x20) != 0 ? (n5 |= JTermios.TIOCM_DSR) : (n5 &= ~JTermios.TIOCM_DSR);
                n5 = (n4 & 0x10) != 0 ? (n5 |= JTermios.TIOCM_CTS) : (n5 &= ~JTermios.TIOCM_CTS);
                n5 = (port.MSR & JTermios.TIOCM_DTR) != 0 ? (n5 |= JTermios.TIOCM_DTR) : (n5 &= ~JTermios.TIOCM_DTR);
                n5 = (port.MSR & JTermios.TIOCM_RTS) != 0 ? (n5 |= JTermios.TIOCM_RTS) : (n5 &= ~JTermios.TIOCM_RTS);
                nArray[0] = n5;
                return 0;
            }
            this.m_ErrNo = JTermios.ENOTSUP;
            return -1;
        }
        catch (Fail fail) {
            return -1;
        }
    }

    private void set_errno(int n) {
        this.m_ErrNo = n;
    }

    private void report(String string) {
        System.err.print(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Port getPort(int n) {
        JTermiosImpl jTermiosImpl = this;
        synchronized (jTermiosImpl) {
            Port port = this.m_OpenPorts.get(n);
            if (port == null) {
                this.m_ErrNo = JTermios.EBADF;
            }
            return port;
        }
    }

    private static String getString(char[] cArray, int n) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = cArray[n++]) != '\u0000') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getPortNamePattern() {
        return "^COM.*";
    }

    @Override
    public List<String> getPortList() {
        Pattern pattern = JTermios.getPortNamePattern(this);
        int n = 0;
        for (n = 16384; n < 262144; n *= 2) {
            char[] cArray = new char[n];
            int n2 = WinAPI.QueryDosDeviceW(null, cArray, cArray.length);
            if (n2 > 0) {
                String string;
                LinkedList<String> linkedList = new LinkedList<String>();
                int n3 = 0;
                while ((string = JTermiosImpl.getString(cArray, n3)).length() > 0) {
                    if (pattern.matcher(string).matches()) {
                        linkedList.add(string);
                    }
                    n3 += string.length() + 1;
                }
                return linkedList;
            }
            int n4 = WinAPI.GetLastError();
            if (n4 == 122) continue;
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "QueryDosDeviceW() failed with GetLastError() = %d\n", n4);
            return null;
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "Repeated QueryDosDeviceW() calls failed up to buffer size %d\n", n);
        return null;
    }

    @Override
    public void shutDown() {
        for (Port port : this.m_OpenPorts.values()) {
            try {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "shutDown() closing port %d\n", port.m_FD);
                port.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int setspeed(int n, Termios termios2, int n2) {
        int n3 = n2;
        switch (n2) {
            case 50: {
                n3 = JTermios.B50;
                break;
            }
            case 75: {
                n3 = JTermios.B75;
                break;
            }
            case 110: {
                n3 = JTermios.B110;
                break;
            }
            case 134: {
                n3 = JTermios.B134;
                break;
            }
            case 150: {
                n3 = JTermios.B150;
                break;
            }
            case 200: {
                n3 = JTermios.B200;
                break;
            }
            case 300: {
                n3 = JTermios.B300;
                break;
            }
            case 600: {
                n3 = JTermios.B600;
                break;
            }
            case 1200: {
                n3 = JTermios.B1200;
                break;
            }
            case 1800: {
                n3 = JTermios.B1800;
                break;
            }
            case 2400: {
                n3 = JTermios.B2400;
                break;
            }
            case 4800: {
                n3 = JTermios.B4800;
                break;
            }
            case 9600: {
                n3 = JTermios.B9600;
                break;
            }
            case 19200: {
                n3 = JTermios.B19200;
                break;
            }
            case 38400: {
                n3 = JTermios.B38400;
                break;
            }
            case 7200: {
                n3 = JTermios.B7200;
                break;
            }
            case 14400: {
                n3 = JTermios.B14400;
                break;
            }
            case 28800: {
                n3 = JTermios.B28800;
                break;
            }
            case 57600: {
                n3 = JTermios.B57600;
                break;
            }
            case 76800: {
                n3 = JTermios.B76800;
                break;
            }
            case 115200: {
                n3 = JTermios.B115200;
                break;
            }
            case 230400: {
                n3 = JTermios.B230400;
            }
        }
        int n4 = this.cfsetispeed(termios2, n3);
        if (n4 != 0) {
            return n4;
        }
        n4 = this.cfsetospeed(termios2, n3);
        if (n4 != 0) {
            return n4;
        }
        n4 = this.tcsetattr(n, JTermios.TCSANOW, termios2);
        if (n4 != 0) {
            return n4;
        }
        return 0;
    }

    @Override
    public int pipe(int[] nArray) {
        this.m_ErrNo = JTermios.EMFILE;
        return -1;
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 256;
        static final int NFBBITS = 32;
        int[] bits = new int[8];

        private FDSetImpl() {
        }
    }

    static class Fail
    extends Exception {
        Fail() {
        }
    }

    private class Port {
        volatile int m_FD = -1;
        volatile boolean m_Locked;
        volatile WinAPI.HANDLE m_Comm;
        volatile int m_OpenFlags;
        volatile WinAPI.DCB m_DCB = new WinAPI.DCB();
        volatile WinAPI.COMMTIMEOUTS m_Timeouts = new WinAPI.COMMTIMEOUTS();
        volatile WinAPI.COMSTAT m_COMSTAT = new WinAPI.COMSTAT();
        volatile int[] m_ClearErr = new int[]{0};
        volatile Memory m_RdBuffer = new Memory(2048L);
        volatile int[] m_RdErr = new int[]{0};
        volatile int[] m_RdN = new int[]{0};
        volatile WinAPI.OVERLAPPED m_RdOVL = new WinAPI.OVERLAPPED();
        volatile Memory m_WrBuffer = new Memory(2048L);
        volatile WinAPI.COMSTAT m_WrStat = new WinAPI.COMSTAT();
        volatile int[] m_WrErr = new int[]{0};
        volatile int[] m_WrN = new int[]{0};
        volatile int m_WritePending;
        volatile WinAPI.OVERLAPPED m_WrOVL = new WinAPI.OVERLAPPED();
        volatile int[] m_SelN = new int[]{0};
        volatile WinAPI.HANDLE m_CancelWaitSema4;
        volatile WinAPI.OVERLAPPED m_SelOVL = new WinAPI.OVERLAPPED();
        volatile IntByReference m_EventFlags = new IntByReference();
        volatile Termios m_Termios = new Termios();
        volatile int MSR;
        volatile int m_VTIME = -1;
        volatile int m_VMIN = -1;
        volatile int m_c_speed = -1;
        volatile int m_c_cflag = -1;
        volatile int m_c_iflag = -1;
        volatile int m_c_oflag = -1;

        public synchronized void fail() throws Fail {
            int n = WinAPI.GetLastError();
            Memory memory = new Memory(2048L);
            int n2 = WinAPI.FormatMessageW(4608, null, n, WinAPI.MAKELANGID(0, 1), memory, (int)memory.size(), null);
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "fail() %s, Windows GetLastError()= %d, %s\n", JTermios.JTermiosLogging.lineno(1), n, memory.getString(0L, true));
            Fail fail = new Fail();
            throw fail;
        }

        public synchronized void lock() throws InterruptedException {
            while (this.m_Locked) {
                this.wait();
            }
            this.m_Locked = true;
        }

        public synchronized void unlock() {
            if (!this.m_Locked) {
                throw new IllegalArgumentException("Port was not locked");
            }
            this.m_Locked = false;
            this.notifyAll();
        }

        public synchronized void waitUnlock() {
            while (this.m_Locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public Port() {
            JTermiosImpl jTermiosImpl2 = JTermiosImpl.this;
            synchronized (jTermiosImpl2) {
                this.m_FD = -1;
                for (int i = 0; i < JTermiosImpl.this.m_PortFDs.length; ++i) {
                    if (JTermiosImpl.this.m_PortFDs[i]) continue;
                    this.m_FD = i;
                    ((JTermiosImpl)JTermiosImpl.this).m_PortFDs[i] = true;
                    JTermiosImpl.this.m_OpenPorts.put(this.m_FD, this);
                    this.m_CancelWaitSema4 = WinAPI.CreateEventA(null, false, false, null);
                    if (this.m_CancelWaitSema4 == null) {
                        throw new RuntimeException("Unexpected failure of CreateEvent() call");
                    }
                    return;
                }
                throw new RuntimeException("Too many ports open");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            JTermiosImpl jTermiosImpl = JTermiosImpl.this;
            synchronized (jTermiosImpl) {
                WinAPI.HANDLE hANDLE;
                if (this.m_FD >= 0) {
                    JTermiosImpl.this.m_OpenPorts.remove(this.m_FD);
                    ((JTermiosImpl)JTermiosImpl.this).m_PortFDs[this.m_FD] = false;
                    this.m_FD = -1;
                }
                if (this.m_CancelWaitSema4 != null) {
                    WinAPI.SetEvent(this.m_CancelWaitSema4);
                }
                if (this.m_Comm != null) {
                    WinAPI.ResetEvent(this.m_SelOVL.hEvent);
                    if (!WinAPI.CancelIo(this.m_Comm)) {
                        boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "CancelIo() failed, GetLastError()= %d, %s\n", WinAPI.GetLastError(), JTermios.JTermiosLogging.lineno(1));
                    }
                    if (!WinAPI.PurgeComm(this.m_Comm, 15)) {
                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "PurgeComm() failed, GetLastError()= %d, %s\n", WinAPI.GetLastError(), JTermios.JTermiosLogging.lineno(1));
                    }
                    WinAPI.GetOverlappedResult(this.m_Comm, this.m_RdOVL, this.m_RdN, true);
                    WinAPI.GetOverlappedResult(this.m_Comm, this.m_WrOVL, this.m_WrN, true);
                    WinAPI.GetOverlappedResult(this.m_Comm, this.m_SelOVL, this.m_SelN, true);
                }
                Memory memory = this.m_RdBuffer;
                synchronized (memory) {
                    hANDLE = (WinAPI.HANDLE)this.m_RdOVL.readField("hEvent");
                    this.m_RdOVL = null;
                    if (hANDLE != null && !hANDLE.equals(WinAPI.NULL) && !hANDLE.equals(WinAPI.INVALID_HANDLE_VALUE)) {
                        WinAPI.CloseHandle(hANDLE);
                    }
                }
                memory = this.m_WrBuffer;
                synchronized (memory) {
                    hANDLE = (WinAPI.HANDLE)this.m_WrOVL.readField("hEvent");
                    this.m_WrOVL = null;
                    if (hANDLE != null && !hANDLE.equals(WinAPI.NULL) && !hANDLE.equals(WinAPI.INVALID_HANDLE_VALUE)) {
                        WinAPI.CloseHandle(hANDLE);
                    }
                }
                this.waitUnlock();
                hANDLE = (WinAPI.HANDLE)this.m_SelOVL.readField("hEvent");
                this.m_SelOVL = null;
                if (hANDLE != null && !hANDLE.equals(WinAPI.NULL) && !hANDLE.equals(WinAPI.INVALID_HANDLE_VALUE)) {
                    WinAPI.CloseHandle(hANDLE);
                }
                if (this.m_Comm != null && this.m_Comm != WinAPI.NULL && this.m_Comm != WinAPI.INVALID_HANDLE_VALUE) {
                    WinAPI.CloseHandle(this.m_Comm);
                }
                this.m_Comm = null;
            }
        }
    }
}

