/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine.job.thread;

import com.google.common.io.Resources;
import com.hubspot.jinjava.Jinjava;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.submarine.commons.SubmarineUI;
import org.apache.zeppelin.submarine.commons.SubmarineUtils;
import org.apache.zeppelin.submarine.job.SubmarineJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorboardRunThread
extends Thread {
    private Logger LOGGER = LoggerFactory.getLogger(TensorboardRunThread.class);
    private SubmarineJob submarineJob;
    private AtomicBoolean running = new AtomicBoolean(false);
    private Lock lockRunning = new ReentrantLock();

    public TensorboardRunThread(SubmarineJob submarineJob) {
        this.submarineJob = submarineJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final SubmarineUI submarineUI = this.submarineJob.getSubmarineUI();
        boolean tryLock = this.lockRunning.tryLock();
        try {
            Properties properties = this.submarineJob.getProperties();
            final String tensorboardName = SubmarineUtils.getTensorboardName(this.submarineJob.getUserName());
            if (this.running.get()) {
                String message = String.format("tensorboard %s already running.", tensorboardName);
                submarineUI.outputLog("WARN", message);
                this.LOGGER.warn(message);
                return;
            }
            this.running.set(true);
            HashMap jinjaParams = SubmarineUtils.propertiesToJinjaParams(properties, this.submarineJob, false);
            jinjaParams.put("JOB_NAME", tensorboardName);
            URL urlTemplate = Resources.getResource("jinja_templates/submarine-tensorboard.jinja");
            String template = Resources.toString(urlTemplate, Charsets.UTF_8);
            Jinjava jinjava = new Jinjava();
            String submarineCmd = jinjava.render(template, jinjaParams);
            int firstLineIsNewline = submarineCmd.indexOf("\n");
            if (firstLineIsNewline == 0) {
                submarineCmd = submarineCmd.replaceFirst("\n", "");
            }
            StringBuffer sbLogs = new StringBuffer(submarineCmd);
            submarineUI.outputLog("Submarine submit command", sbLogs.toString());
            long timeout = Long.valueOf(properties.getProperty("submarine.command.timeout.millisecond", "100000"));
            CommandLine cmdLine = CommandLine.parse(SubmarineJob.shell);
            cmdLine.addArgument(submarineCmd, false);
            DefaultExecutor executor = new DefaultExecutor();
            ExecuteWatchdog watchDog = new ExecuteWatchdog(timeout);
            executor.setWatchdog(watchDog);
            final StringBuffer sbLogOutput = new StringBuffer();
            executor.setStreamHandler(new PumpStreamHandler(new LogOutputStream(){

                @Override
                protected void processLine(String line, int level) {
                    if (!StringUtils.isEmpty(line = line.trim())) {
                        sbLogOutput.append(line + "\n");
                    }
                }
            }));
            if (Boolean.valueOf(properties.getProperty("shell.working.directory.userName.home")).booleanValue()) {
                executor.setWorkingDirectory(new File(System.getProperty("user.home")));
            }
            HashMap<String, String> env = new HashMap<String, String>();
            String launchMode = (String)jinjaParams.get("INTERPRETER_LAUNCH_MODE");
            if (StringUtils.equals(launchMode, "yarn")) {
                String javaHome = (String)jinjaParams.get("DOCKER_JAVA_HOME");
                String hadoopHome = (String)jinjaParams.get("DOCKER_HADOOP_HDFS_HOME");
                String hadoopConf = (String)jinjaParams.get("SUBMARINE_HADOOP_CONF_DIR");
                env.put("JAVA_HOME", javaHome);
                env.put("HADOOP_HOME", hadoopHome);
                env.put("HADOOP_HDFS_HOME", hadoopHome);
                env.put("HADOOP_CONF_DIR", hadoopConf);
                env.put("YARN_CONF_DIR", hadoopConf);
                env.put("CLASSPATH", "`$HADOOP_HDFS_HOME/bin/hadoop classpath --glob`");
            }
            this.LOGGER.info("Execute EVN: {}, Command: {} ", (Object)((Object)env).toString(), (Object)submarineCmd);
            final AtomicBoolean cmdLineRunning = new AtomicBoolean(true);
            executor.execute(cmdLine, env, new DefaultExecuteResultHandler(){

                @Override
                public void onProcessComplete(int exitValue) {
                    String message = String.format("jobName %s ProcessComplete exit value is : %d", tensorboardName, exitValue);
                    TensorboardRunThread.this.LOGGER.info(message);
                    submarineUI.outputLog("TENSORBOARD RUN COMPLETE", message);
                    cmdLineRunning.set(false);
                }

                @Override
                public void onProcessFailed(ExecuteException e) {
                    String message = String.format("jobName %s ProcessFailed exit value is : %d, exception is : %s", tensorboardName, e.getExitValue(), e.getMessage());
                    TensorboardRunThread.this.LOGGER.error(message);
                    submarineUI.outputLog("TENSORBOARD RUN FAILED", message);
                    cmdLineRunning.set(false);
                }
            });
            int loopCount = 100;
            while (loopCount-- > 0 && cmdLineRunning.get() && this.running.get()) {
                Thread.sleep(1000L);
            }
            if (watchDog.isWatching()) {
                watchDog.destroyProcess();
                Thread.sleep(1000L);
            }
            if (watchDog.isWatching()) {
                watchDog.killedProcess();
            }
            Map<String, Object> jobState = this.submarineJob.getJobStateByYarn(tensorboardName);
            loopCount = 50;
            while (loopCount-- > 0 && !jobState.containsKey("state") && this.running.get()) {
                Thread.sleep(3000L);
                jobState = this.submarineJob.getJobStateByYarn(tensorboardName);
            }
            if (!jobState.containsKey("state")) {
                String message = String.format("tensorboard %s was not submitted to YARN!", tensorboardName);
                this.LOGGER.error(message);
                submarineUI.outputLog("JOR RUN FAILED", message);
            }
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), e);
            submarineUI.outputLog("Exception", e.getMessage());
        }
        finally {
            this.running.set(false);
            this.lockRunning.unlock();
        }
    }

    public void stopRunning() {
        try {
            this.running.set(false);
            boolean tryLock = this.lockRunning.tryLock();
            int loop = 0;
            while (!tryLock && loop++ < 100) {
                this.LOGGER.warn("Can not get the TensorboardRunThread lock [{}] !", (Object)loop);
                Thread.sleep(500L);
                tryLock = this.lockRunning.tryLock();
            }
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        finally {
            this.lockRunning.unlock();
        }
    }
}

