/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class ShortDecoder
extends AbstractDecoder
implements Decoder.Text<Short> {
    public static final ShortDecoder INSTANCE = new ShortDecoder();

    @Override
    public Short decode(String s2) throws DecodeException {
        try {
            return Short.parseShort(s2);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s2, "Unable to parse Short", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s2) {
        if (s2 == null) {
            return false;
        }
        try {
            Short.parseShort(s2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

