/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UdtCodec
implements TypeCodec<UdtValue> {
    private final UserDefinedType cqlType;

    public UdtCodec(@NonNull UserDefinedType cqlType) {
        this.cqlType = cqlType;
    }

    @Override
    @NonNull
    public GenericType<UdtValue> getJavaType() {
        return GenericType.UDT_VALUE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof UdtValue && ((UdtValue)value).getType().equals(this.cqlType);
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return UdtValue.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable UdtValue value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        if (!value.getType().equals(this.cqlType)) {
            throw new IllegalArgumentException(String.format("Invalid user defined type, expected %s but got %s", this.cqlType, value.getType()));
        }
        int toAllocate = 0;
        int size = this.cqlType.getFieldTypes().size();
        for (int i = 0; i < size; ++i) {
            ByteBuffer field2 = value.getBytesUnsafe(i);
            toAllocate += 4 + (field2 == null ? 0 : field2.remaining());
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        for (int i = 0; i < value.size(); ++i) {
            ByteBuffer field3 = value.getBytesUnsafe(i);
            if (field3 == null) {
                result2.putInt(-1);
                continue;
            }
            result2.putInt(field3.remaining());
            result2.put(field3.duplicate());
        }
        return (ByteBuffer)result2.flip();
    }

    @Override
    @Nullable
    public UdtValue decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteBuffer input = bytes.duplicate();
            UdtValue value = this.cqlType.newValue();
            int i = 0;
            while (input.hasRemaining()) {
                ByteBuffer element;
                if (i == this.cqlType.getFieldTypes().size()) {
                    throw new IllegalArgumentException(String.format("Too many fields in encoded UDT value, expected %d", this.cqlType.getFieldTypes().size()));
                }
                int elementSize = input.getInt();
                if (elementSize < 0) {
                    element = null;
                } else {
                    element = input.slice();
                    element.limit(elementSize);
                    input.position(input.position() + elementSize);
                }
                value = (UdtValue)value.setBytesUnsafe(i, element);
                ++i;
            }
            return value;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Not enough bytes to deserialize a UDT value", e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable UdtValue value) {
        if (value == null) {
            return "NULL";
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        StringBuilder sb = new StringBuilder("{");
        int size = this.cqlType.getFieldTypes().size();
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            CqlIdentifier elementName = this.cqlType.getFieldNames().get(i);
            sb.append(elementName.asCql(true));
            sb.append(":");
            DataType elementType = this.cqlType.getFieldTypes().get(i);
            TypeCodec<DataType> codec = registry.codecFor(elementType);
            sb.append(codec.format(value.get(i, codec)));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @Nullable
    public UdtValue parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        UdtValue udt = this.cqlType.newValue();
        int length = value.length();
        int position = ParseUtils.skipSpaces(value, 0);
        if (value.charAt(position) != '{') {
            throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\" at character %d: expecting '{' but got '%c'", value, position, Character.valueOf(value.charAt(position))));
        }
        ++position;
        if ((position = ParseUtils.skipSpaces(value, position)) == length) {
            throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\" at character %d: expecting CQL identifier or '}', got EOF", value, position));
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        CqlIdentifier id = null;
        while (position < length) {
            DataType parsed;
            int n;
            if (value.charAt(position) == '}') {
                if ((position = ParseUtils.skipSpaces(value, position + 1)) == length) {
                    return udt;
                }
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting EOF or blank, but got \"%s\"", value, position, value.substring(position)));
            }
            try {
                n = ParseUtils.skipCQLId(value, position);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", cannot parse a CQL identifier at character %d", value, position), e);
            }
            id = CqlIdentifier.fromInternal(value.substring(position, n));
            position = n;
            if (!this.cqlType.contains(id)) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", unknown CQL identifier at character %d: \"%s\"", value, position, id));
            }
            if ((position = ParseUtils.skipSpaces(value, position)) == length) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ':', but got EOF", value, id, position));
            }
            if (value.charAt(position) != ':') {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ':', but got '%c'", value, id, position, Character.valueOf(value.charAt(position))));
            }
            ++position;
            position = ParseUtils.skipSpaces(value, position);
            try {
                n = ParseUtils.skipCQLValue(value, position);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", invalid CQL value at field %s (character %d)", value, id, position), e);
            }
            String fieldValue = value.substring(position, n);
            DataType fieldType = this.cqlType.getFieldTypes().get(this.cqlType.firstIndexOf(id));
            TypeCodec<DataType> codec = registry.codecFor(fieldType);
            try {
                parsed = codec.parse(fieldValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", invalid CQL value at field %s (character %d): %s", value, id, position, e.getMessage()), e);
            }
            udt = (UdtValue)udt.set(id, parsed, codec);
            position = n;
            position = ParseUtils.skipSpaces(value, position);
            if (position == length) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ',' or '}', but got EOF", value, id, position));
            }
            if (value.charAt(position) == '}') continue;
            if (value.charAt(position) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ',' but got '%c'", value, id, position, Character.valueOf(value.charAt(position))));
            }
            ++position;
            position = ParseUtils.skipSpaces(value, position);
        }
        throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\" at field %s (character %d): expecting CQL identifier or '}', got EOF", value, id, position));
    }
}

