/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ObjectListToArrayCodec<ElementT>
extends AbstractListToArrayCodec<ElementT[]> {
    private final TypeCodec<ElementT> elementCodec;

    public ObjectListToArrayCodec(@NonNull TypeCodec<ElementT> elementCodec) {
        super(DataTypes.listOf(Objects.requireNonNull(elementCodec, "elementCodec must not be null").getCqlType()), GenericType.arrayOf(elementCodec.getJavaType()));
        this.elementCodec = elementCodec;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        Class<?> clazz = value.getClass();
        return clazz.isArray() && clazz.getComponentType().equals(this.elementCodec.getJavaType().getRawType());
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable ElementT[] value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] encodedElements = new ByteBuffer[value.length];
        int toAllocate = 4;
        for (ElementT elt : value) {
            ByteBuffer encodedElement;
            if (elt == null) {
                throw new NullPointerException("Collection elements cannot be null");
            }
            try {
                encodedElement = this.elementCodec.encode(elt, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Invalid type for %s element, expecting %s but got %s", this.cqlType, this.elementCodec.getJavaType(), elt.getClass()), e);
            }
            if (encodedElement == null) {
                throw new NullPointerException("Collection elements cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedElement;
            toAllocate += 4 + encodedElement.remaining();
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        result2.putInt(value.length);
        for (ByteBuffer encodedElement : encodedElements) {
            result2.putInt(encodedElement.remaining());
            result2.put(encodedElement);
        }
        result2.flip();
        return result2;
    }

    @Override
    @Nullable
    public ElementT[] decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return this.newInstance(0);
        }
        ByteBuffer input = bytes.duplicate();
        int size = input.getInt();
        ElementT[] result2 = this.newInstance(size);
        for (int i = 0; i < size; ++i) {
            Object element;
            int elementSize = input.getInt();
            if (elementSize < 0) {
                element = null;
            } else {
                ByteBuffer encodedElement = input.slice();
                encodedElement.limit(elementSize);
                element = this.elementCodec.decode(encodedElement, protocolVersion);
                input.position(input.position() + elementSize);
            }
            result2[i] = element;
        }
        return result2;
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull ElementT[] array, int index) {
        output.append(this.elementCodec.format(array[index]));
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull ElementT[] array, int index) {
        array[index] = this.elementCodec.parse(input);
    }

    @Override
    @NonNull
    protected ElementT[] newInstance(int size) {
        return (Object[])Array.newInstance(this.getJavaType().getRawType().getComponentType(), size);
    }
}

