/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.zeppelin.cassandra.BoundValuesParser;
import org.apache.zeppelin.cassandra.CassandraQueryOptions;
import org.apache.zeppelin.cassandra.CqlFormatter;
import org.apache.zeppelin.cassandra.EnhancedSession;
import org.apache.zeppelin.cassandra.EnhancedSession$;
import org.apache.zeppelin.cassandra.InterpreterLogic$;
import org.apache.zeppelin.cassandra.ParagraphParser;
import org.apache.zeppelin.cassandra.ParsingException;
import org.apache.zeppelin.cassandra.TextBlockHierarchy;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$ConsistencyParam$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$FetchSizeParam$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$ParameterBlock$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$PrepareStatementType$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$RemovePrepareStatementType$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$RequestTimeOutParam$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$SerialConsistencyParam$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$StatementBlock$;
import org.apache.zeppelin.cassandra.TextBlockHierarchy$TimestampParam$;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.Parsers;

@ScalaSignature(bytes="\u0006\u0001\r%r!B\u001a5\u0011\u0003id!B 5\u0011\u0003\u0001\u0005\"B$\u0002\t\u0003A\u0005bB%\u0002\u0005\u0004%\tA\u0013\u0005\u0007-\u0006\u0001\u000b\u0011B&\t\u000f]\u000b!\u0019!C\u00011\"1\u0011-\u0001Q\u0001\neCqAY\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004d\u0003\u0001\u0006I!\u0017\u0005\bI\u0006\u0011\r\u0011\"\u0001Y\u0011\u0019)\u0017\u0001)A\u00053\"9a-\u0001b\u0001\n\u00039\u0007BB8\u0002A\u0003%\u0001\u000eC\u0004q\u0003\t\u0007I\u0011A4\t\rE\f\u0001\u0015!\u0003i\u0011\u001d\u0011\u0018A1A\u0005\u0002MDa\u0001`\u0001!\u0002\u0013!\bbB?\u0002\u0005\u0004%\ta\u001d\u0005\u0007}\u0006\u0001\u000b\u0011\u0002;\t\u0011}\f!\u0019!C\u0001\u0003\u0003A\u0001\"a\u000e\u0002A\u0003%\u00111\u0001\u0005\n\u0003s\t!\u0019!C\u0001\u0003wA\u0001\"!\u0013\u0002A\u0003%\u0011Q\b\u0005\n\u0003\u0017\n!\u0019!C\u0001\u0003\u001bB\u0001\"!\u0016\u0002A\u0003%\u0011q\n\u0005\n\u0003/\n!\u0019!C\u0001\u00033B\u0001\"!\u0019\u0002A\u0003%\u00111\f\u0004\u0006\u007fQ\u0002\u00111\r\u0005\u000b\u0003KZ\"Q1A\u0005\u0002\u0005\u001d\u0004BCA97\t\u0005\t\u0015!\u0003\u0002j!Q\u00111O\u000e\u0003\u0006\u0004%\t!!\u001e\t\u0015\u0005\u00055D!A!\u0002\u0013\t9\b\u0003\u0004H7\u0011\u0005\u00111\u0011\u0005\n\u0003\u0017[\"\u0019!C\u0001\u0003\u001bC\u0001\"!&\u001cA\u0003%\u0011q\u0012\u0005\n\u0003/[\"\u0019!C\u0001\u00033C\u0001\"!)\u001cA\u0003%\u00111\u0014\u0005\b\u0003G[B\u0011AAS\u0011\u001d\tYn\u0007C\u0001\u0003;Dq!!@\u001c\t\u0003\ty\u0010C\u0004\u00036m!\tAa\u000e\t\u000f\tm2\u0004\"\u0001\u0003>!9!\u0011K\u000e\u0005\u0002\tM\u0003b\u0002B67\u0011\u0005!Q\u000e\u0005\b\u0005\u0007[B\u0011\u0001BC\u0011\u001d\u0011Il\u0007C\u0001\u0005wCqAa1\u001c\t\u0003\u0011)\rC\u0004\u0003Vn!IAa6\t\u000f\tu8\u0004\"\u0005\u0003\u0000\"911B\u000e\u0005\u0002\r5\u0001bBB\u000e7\u0011\u00051QD\u0001\u0011\u0013:$XM\u001d9sKR,'\u000fT8hS\u000eT!!\u000e\u001c\u0002\u0013\r\f7o]1oIJ\f'BA\u001c9\u0003!QX\r\u001d9fY&t'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002?\u00035\tAG\u0001\tJ]R,'\u000f\u001d:fi\u0016\u0014Hj\\4jGN\u0011\u0011!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0014!E\"I\u001f&\u001bUiU0T\u000bB\u000b%+\u0011+P%V\t1\n\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\u000ek\u0011a\u0014\u0006\u0003!r\na\u0001\u0010:p_Rt\u0014B\u0001*D\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u001b\u0015AE\"I\u001f&\u001bUiU0T\u000bB\u000b%+\u0011+P%\u0002\n\u0001CV!S\u0013\u0006\u0013E*R0Q\u0003R#VI\u0015(\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u00115\fGo\u00195j]\u001eT!AX\"\u0002\tU$\u0018\u000e\\\u0005\u0003An\u0013QAU3hKb\f\u0011CV!S\u0013\u0006\u0013E*R0Q\u0003R#VI\u0015(!\u0003\t\u001a\u0016*\u0014)M\u000b~3\u0016IU%B\u00052+u\fR#G\u0013:KE+S(O?B\u000bE\u000bV#S\u001d\u0006\u00193+S'Q\u0019\u0016{f+\u0011*J\u0003\ncUi\u0018#F\r&s\u0015\nV%P\u001d~\u0003\u0016\t\u0016+F%:\u0003\u0013\u0001L'V\u0019RK\u0005\u000bT#`\u0007\"{\u0015jQ#T?Z\u000b%+S!C\u0019\u0016{F)\u0012$J\u001d&#\u0016j\u0014(`!\u0006#F+\u0012*O\u00035jU\u000b\u0014+J!2+ul\u0011%P\u0013\u000e+5k\u0018,B%&\u000b%\tT#`\t\u00163\u0015JT%U\u0013>su\fU!U)\u0016\u0013f\nI\u0001\u0015'R\u000be\nR!S\t~#\u0015\tV#`\r>\u0013V*\u0011+\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\t1\fgn\u001a\u0006\u0002[\u0006!!.\u0019<b\u0013\t!&.A\u000bT)\u0006sE)\u0011*E?\u0012\u000bE+R0G\u001fJk\u0015\t\u0016\u0011\u0002)\u0005\u001b5)\u0016*B)\u0016{F)\u0011+F?\u001a{%+T!U\u0003U\t5iQ+S\u0003R+u\fR!U\u000b~3uJU'B)\u0002\nqc\u0015+B\u001d\u0012\u000b%\u000bR0E\u0003R+uLR(S\u001b\u0006#F+\u0012*\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\r\u0019|'/\\1u\u0015\tIH.\u0001\u0003uS6,\u0017BA>w\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0019'R\u000be\nR!S\t~#\u0015\tV#`\r>\u0013V*\u0011+U\u000bJ\u0003\u0013aF!D\u0007V\u0013\u0016\tV#`\t\u0006#Vi\u0018$P%6\u000bE\u000bV#S\u0003a\t5iQ+S\u0003R+u\fR!U\u000b~3uJU'B)R+%\u000bI\u0001\u0013aJ,\u0007/\u0019:fIN#\u0018\r^3nK:$8/\u0006\u0002\u0002\u0004A9\u0011QAA\b\u0017\u0006MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000f5,H/\u00192mK*\u0019\u0011QB\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0005\u001d!aA'baB!\u0011QCA\u001a\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011aA2rY*!\u0011QDA\u0010\u0003\u0011\u0019wN]3\u000b\t\u0005\u0005\u00121E\u0001\u0004CBL'\u0002BA\u0013\u0003O\ta\u0001\u001a:jm\u0016\u0014(\u0002BA\u0015\u0003W\t1a\\:t\u0015\u0011\ti#a\f\u0002\u0011\u0011\fG/Y:uCbT!!!\r\u0002\u0007\r|W.\u0003\u0003\u00026\u0005]!!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u0006\u0019\u0002O]3qCJ,Gm\u0015;bi\u0016lWM\u001c;tA\u00051An\\4hKJ,\"!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011;\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\t9%!\u0011\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq\u0002]1sC\u001e\u0014\u0018\r\u001d5QCJ\u001cXM]\u000b\u0003\u0003\u001f\u00022APA)\u0013\r\t\u0019\u0006\u000e\u0002\u0010!\u0006\u0014\u0018m\u001a:ba\"\u0004\u0016M]:fe\u0006\u0001\u0002/\u0019:bOJ\f\u0007\u000f\u001b)beN,'\u000fI\u0001\u0012E>,h\u000e\u001a,bYV,7\u000fU1sg\u0016\u0014XCAA.!\rq\u0014QL\u0005\u0004\u0003?\"$!\u0005\"pk:$g+\u00197vKN\u0004\u0016M]:fe\u0006\u0011\"m\\;oIZ\u000bG.^3t!\u0006\u00148/\u001a:!'\tY\u0012)A\u0004tKN\u001c\u0018n\u001c8\u0016\u0005\u0005%\u0004\u0003BA6\u0003[j!!a\u0007\n\t\u0005=\u00141\u0004\u0002\u000b\u0007Fd7+Z:tS>t\u0017\u0001C:fgNLwN\u001c\u0011\u0002\u0015A\u0014x\u000e]3si&,7/\u0006\u0002\u0002xA!\u0011\u0011PA?\u001b\t\tYH\u0003\u0002_Y&!\u0011qPA>\u0005)\u0001&o\u001c9feRLWm]\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b\u0005\u0006\u0004\u0002\u0006\u0006\u001d\u0015\u0011\u0012\t\u0003}mAq!!\u001a!\u0001\u0004\tI\u0007C\u0004\u0002t\u0001\u0002\r!a\u001e\u0002\u001f\u0015t\u0007.\u00198dK\u0012\u001cVm]:j_:,\"!a$\u0011\u0007y\n\t*C\u0002\u0002\u0014R\u0012q\"\u00128iC:\u001cW\rZ*fgNLwN\\\u0001\u0011K:D\u0017M\\2fIN+7o]5p]\u0002\n\u0011BZ8s[\u0006$H/\u001a:\u0016\u0005\u0005m\u0005c\u0001 \u0002\u001e&\u0019\u0011q\u0014\u001b\u0003\u0019\r\u000bHNR8s[\u0006$H/\u001a:\u0002\u0015\u0019|'/\\1ui\u0016\u0014\b%A\u0005j]R,'\u000f\u001d:fiV!\u0011qUAc)!\tI+!.\u00028\u0006m\u0006\u0003BAV\u0003ck!!!,\u000b\u0007\u0005=f'A\u0006j]R,'\u000f\u001d:fi\u0016\u0014\u0018\u0002BAZ\u0003[\u0013\u0011#\u00138uKJ\u0004(/\u001a;feJ+7/\u001e7u\u0011\u001d\t)'\na\u0001\u0003SBa!!/&\u0001\u0004Y\u0015\u0001E:ue&twm\u0015;bi\u0016lWM\u001c;t\u0011\u001d\ti,\na\u0001\u0003\u007f\u000bqaY8oi\u0016DH\u000f\u0005\u0003\u0002,\u0006\u0005\u0017\u0002BAb\u0003[\u0013!#\u00138uKJ\u0004(/\u001a;fe\u000e{g\u000e^3yi\u00129\u0011qY\u0013C\u0002\u0005%'AC*uCR,W.\u001a8u)F!\u00111ZAi!\r\u0011\u0015QZ\u0005\u0004\u0003\u001f\u001c%a\u0002(pi\"Lgn\u001a\t\u0007\u0003+\t\u0019.a6\n\t\u0005U\u0017q\u0003\u0002\n'R\fG/Z7f]R\u0004B!!7\u0002F2\u0001\u0011\u0001\u00062vS2$'+Z:q_:\u001cX-T3tg\u0006<W-\u0006\u0003\u0002`\u0006MHCBAU\u0003C\fI\u0010C\u0004\u0002d\u001a\u0002\r!!:\u0002\u001b1\f7\u000f\u001e*fgVdGoU3u!\u001d\u0011\u0015q]Av\u0003cL1!!;D\u0005\u0019!V\u000f\u001d7feA!\u0011QCAw\u0013\u0011\ty/a\u0006\u0003\u0013I+7/\u001e7u'\u0016$\b\u0003BAm\u0003g$q!a2'\u0005\u0004\t)0\u0005\u0003\u0002L\u0006]\bCBA\u000b\u0003'\f\t\u0010C\u0004\u0002|\u001a\u0002\r!a'\u0002\u0007\u0019lG/\u0001\u0006qCJ\u001cX-\u00138qkR$BA!\u0001\u00032A1!1\u0001B\u0007\u0005'qAA!\u0002\u0003\n9\u0019aJa\u0002\n\u0003\u0011K1Aa\u0003D\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0004\u0003\u0012\t!A*[:u\u0015\r\u0011Ya\u0011\t\u0005\u0005+\u0011YC\u0004\u0003\u0003\u0018\t\u001db\u0002\u0002B\r\u0005KqAAa\u0007\u0003$9!!Q\u0004B\u0011\u001d\rq%qD\u0005\u0002w%\u0011\u0011HO\u0005\u0003oaJ!!\u000e\u001c\n\u0007\t%B'\u0001\nUKb$(\t\\8dW\"KWM]1sG\"L\u0018\u0002\u0002B\u0017\u0005_\u0011\u0001\"\u00118z\u00052|7m\u001b\u0006\u0004\u0005S!\u0004B\u0002B\u001aO\u0001\u00071*A\u0003j]B,H/\u0001\tfqR\u0014\u0018m\u0019;G_Jl\u0017\r\u001e;feR!\u00111\u0014B\u001d\u0011\u001d\ti\f\u000ba\u0001\u0003\u007f\u000b1#\u001a=ue\u0006\u001cG/U;fef|\u0005\u000f^5p]N$BAa\u0010\u0003FA\u0019aH!\u0011\n\u0007\t\rCGA\u000bDCN\u001c\u0018M\u001c3sCF+XM]=PaRLwN\\:\t\u000f\t\u001d\u0013\u00061\u0001\u0003J\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\r\t\r!Q\u0002B&!\u0011\u0011)B!\u0014\n\t\t=#q\u0006\u0002\u0010#V,'/\u001f)be\u0006lW\r^3sg\u00069r-\u001a8fe\u0006$XmU5na2,7\u000b^1uK6,g\u000e\u001e\u000b\t\u0005+\u0012YF!\u001a\u0003jA!\u0011Q\u0003B,\u0013\u0011\u0011I&a\u0006\u0003\u001fMKW\u000e\u001d7f'R\fG/Z7f]RDqA!\u0018+\u0001\u0004\u0011y&\u0001\u0002tiB!!Q\u0003B1\u0013\u0011\u0011\u0019Ga\f\u0003\u0013MKW\u000e\u001d7f'Rl\u0007b\u0002B4U\u0001\u0007!qH\u0001\b_B$\u0018n\u001c8t\u0011\u001d\tiL\u000ba\u0001\u0003\u007f\u000bacZ3oKJ\fG/\u001a\"pk:$7\u000b^1uK6,g\u000e\u001e\u000b\u000b\u0005_\u0012)Ha\u001e\u0003\u0000\t\u0005\u0005\u0003BA\u000b\u0005cJAAa\u001d\u0002\u0018\tq!i\\;oIN#\u0018\r^3nK:$\bbBA3W\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005;Z\u0003\u0019\u0001B=!\u0011\u0011)Ba\u001f\n\t\tu$q\u0006\u0002\t\u0005>,h\u000eZ*u[\"9!qM\u0016A\u0002\t}\u0002bBA_W\u0001\u0007\u0011qX\u0001\u0017O\u0016tWM]1uK\n\u000bGo\u00195Ti\u0006$X-\\3oiRA!q\u0011BG\u0005/\u0013I\n\u0005\u0003\u0002\u0016\t%\u0015\u0002\u0002BF\u0003/\u0011aBQ1uG\"\u001cF/\u0019;f[\u0016tG\u000fC\u0004\u0003\u00102\u0002\rA!%\u0002\u0013\t\fGo\u00195UsB,\u0007\u0003BA\u000b\u0005'KAA!&\u0002\u0018\tI!)\u0019;dQRK\b/\u001a\u0005\b\u0005Ob\u0003\u0019\u0001B \u0011\u001d\u0011Y\n\fa\u0001\u0005;\u000b!b\u001d;bi\u0016lWM\u001c;t!\u0019\u0011\u0019Aa(\u0003$&!!\u0011\u0015B\t\u0005\r\u0019V-\u001d\u0019\u0005\u0005K\u0013i\u000b\u0005\u0004\u0002\u0016\t\u001d&1V\u0005\u0005\u0005S\u000b9B\u0001\nCCR\u001c\u0007.\u00192mKN#\u0018\r^3nK:$\b\u0003BAm\u0005[#ABa,\u0003\u001a\u0006\u0005\t\u0011!B\u0001\u0005c\u00131a\u0018\u00132#\u0011\tYMa-\u0011\u0007\t\u0013),C\u0002\u00038\u000e\u00131!\u00118z\u0003Ui\u0017-\u001f2f\u000bb$(/Y2u-\u0006\u0014\u0018.\u00192mKN$Ra\u0013B_\u0005\u0003DaAa0.\u0001\u0004Y\u0015!C:uCR,W.\u001a8u\u0011\u001d\ti,\fa\u0001\u0003\u007f\u000b\u0011#\u00199qYf\fV/\u001a:z\u001fB$\u0018n\u001c8t+\u0011\u00119Ma3\u0015\r\t%'\u0011\u001bBj!\u0011\tINa3\u0005\u000f\u0005\u001dgF1\u0001\u0003NF!\u00111\u001aBh!\u0019\t)\"a5\u0003J\"9!q\r\u0018A\u0002\t}\u0002b\u0002B`]\u0001\u0007!\u0011Z\u0001\u0015GJ,\u0017\r^3C_VtGm\u0015;bi\u0016lWM\u001c;\u0015\u0015\t=$\u0011\u001cBy\u0005k\u0014I\u0010C\u0004\u0003\\>\u0002\rA!8\u0002\u001b\r|G-Z2SK\u001eL7\u000f\u001e:z!\u0011\u0011yN!<\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0001B]3hSN$(/\u001f\u0006\u0005\u0005O\u0014I/A\u0003d_\u0012,7M\u0003\u0003\u0003l\u0006m\u0011\u0001\u0002;za\u0016LAAa<\u0003b\ni1i\u001c3fGJ+w-[:uefDaAa=0\u0001\u0004Y\u0015\u0001\u00028b[\u0016DqAa>0\u0001\u0004\t\u0019\"\u0001\u0002qg\"1!1`\u0018A\u0002-\u000baB]1x\u0005>,h\u000e\u001a,bYV,7/\u0001\tqCJ\u001cXMQ8v]\u00124\u0016\r\\;fgR11\u0011AB\u0002\u0007\u000f\u0001RAa\u0001\u0003\u000e-Caa!\u00021\u0001\u0004Y\u0015A\u00029t\u001d\u0006lW\r\u0003\u0004\u0004\nA\u0002\raS\u0001\fE>,h\u000e\u001a,bYV,7/A\u0005qCJ\u001cX\rR1uKR!1qBB\f!\u0011\u0019\tba\u0005\u000e\u0003aL1a!\u0006y\u0005\u001dIen\u001d;b]RDaa!\u00072\u0001\u0004Y\u0015A\u00033bi\u0016\u001cFO]5oO\u0006q\u0001/\u0019:tK\u0016C8-\u001a9uS>tGcA&\u0004 !91\u0011\u0005\u001aA\u0002\r\r\u0012AA3y!\u0011\u0011\u0019a!\n\n\t\r\u001d\"\u0011\u0003\u0002\n\u000bb\u001cW\r\u001d;j_:\u0004")
public class InterpreterLogic {
    private final CqlSession session;
    private final Properties properties;
    private final EnhancedSession enhancedSession;
    private final CqlFormatter formatter;

    public static BoundValuesParser boundValuesParser() {
        return InterpreterLogic$.MODULE$.boundValuesParser();
    }

    public static ParagraphParser paragraphParser() {
        return InterpreterLogic$.MODULE$.paragraphParser();
    }

    public static Logger logger() {
        return InterpreterLogic$.MODULE$.logger();
    }

    public static scala.collection.mutable.Map<String, PreparedStatement> preparedStatements() {
        return InterpreterLogic$.MODULE$.preparedStatements();
    }

    public static DateTimeFormatter ACCURATE_DATE_FORMATTER() {
        return InterpreterLogic$.MODULE$.ACCURATE_DATE_FORMATTER();
    }

    public static DateTimeFormatter STANDARD_DATE_FORMATTER() {
        return InterpreterLogic$.MODULE$.STANDARD_DATE_FORMATTER();
    }

    public static String ACCURATE_DATE_FORMAT() {
        return InterpreterLogic$.MODULE$.ACCURATE_DATE_FORMAT();
    }

    public static String STANDARD_DATE_FORMAT() {
        return InterpreterLogic$.MODULE$.STANDARD_DATE_FORMAT();
    }

    public static Regex MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN() {
        return InterpreterLogic$.MODULE$.MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN();
    }

    public static Regex SIMPLE_VARIABLE_DEFINITION_PATTERN() {
        return InterpreterLogic$.MODULE$.SIMPLE_VARIABLE_DEFINITION_PATTERN();
    }

    public static Regex VARIABLE_PATTERN() {
        return InterpreterLogic$.MODULE$.VARIABLE_PATTERN();
    }

    public static String CHOICES_SEPARATOR() {
        return InterpreterLogic$.MODULE$.CHOICES_SEPARATOR();
    }

    public CqlSession session() {
        return this.session;
    }

    public Properties properties() {
        return this.properties;
    }

    public EnhancedSession enhancedSession() {
        return this.enhancedSession;
    }

    public CqlFormatter formatter() {
        return this.formatter;
    }

    public <StatementT extends Statement<StatementT>> InterpreterResult interpret(CqlSession session, String stringStatements, InterpreterContext context) {
        InterpreterResult interpreterResult;
        block10: {
            InterpreterLogic$.MODULE$.logger().info(new java.lang.StringBuilder(30).append("Executing CQL statements : \n\n").append(stringStatements).append("\n").toString());
            try {
                List<TextBlockHierarchy.AnyBlock> queries = this.parseInput(stringStatements);
                CassandraQueryOptions queryOptions = this.extractQueryOptions(((List)queries.filter((Function1<TextBlockHierarchy.AnyBlock, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$interpret$1(x$1)))).map((Function1<TextBlockHierarchy.AnyBlock, TextBlockHierarchy.QueryParameters> & Serializable & scala.Serializable)x$2 -> (TextBlockHierarchy.QueryParameters)x$2.get(), List$.MODULE$.canBuildFrom()));
                CqlFormatter executionFormatter = this.extractFormatter(context);
                InterpreterLogic$.MODULE$.logger().info(new java.lang.StringBuilder(34).append("Current Cassandra query options = ").append(queryOptions).toString());
                List queryStatements = ((List)queries.filter((Function1<TextBlockHierarchy.AnyBlock, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$interpret$3(x$3)))).map((Function1<TextBlockHierarchy.AnyBlock, TextBlockHierarchy.QueryStatement> & Serializable & scala.Serializable)x$4 -> (TextBlockHierarchy.QueryStatement)x$4.get(), List$.MODULE$.canBuildFrom());
                ((List)queryStatements.filter((Function1<TextBlockHierarchy.QueryStatement, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$interpret$5(x$5)))).map((Function1<TextBlockHierarchy.QueryStatement, TextBlockHierarchy.RemovePrepareStm> & Serializable & scala.Serializable)x$6 -> (TextBlockHierarchy.RemovePrepareStm)x$6.getStatement(), List$.MODULE$.canBuildFrom()).foreach((Function1<TextBlockHierarchy.RemovePrepareStm, Option> & Serializable & scala.Serializable)remove -> {
                    InterpreterLogic$.MODULE$.logger().debug(new java.lang.StringBuilder(30).append("Removing prepared statement '").append(remove.name()).append("'").toString());
                    return InterpreterLogic$.MODULE$.preparedStatements().remove(remove.name());
                });
                ((List)queryStatements.filter((Function1<TextBlockHierarchy.QueryStatement, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$interpret$8(x$7)))).map((Function1<TextBlockHierarchy.QueryStatement, TextBlockHierarchy.PrepareStm> & Serializable & scala.Serializable)x$8 -> (TextBlockHierarchy.PrepareStm)x$8.getStatement(), List$.MODULE$.canBuildFrom()).foreach((Function1<TextBlockHierarchy.PrepareStm, PreparedStatement> & Serializable & scala.Serializable)statement -> {
                    InterpreterLogic$.MODULE$.logger().debug(new java.lang.StringBuilder(30).append("Get or prepare statement '").append(statement.name()).append("' : ").append(statement.query()).toString());
                    return (PreparedStatement)InterpreterLogic$.MODULE$.preparedStatements().getOrElseUpdate(statement.name(), (Function0<PreparedStatement> & Serializable & scala.Serializable)() -> session.prepare(statement.query()));
                });
                Seq statements = ((List)queryStatements.filter((Function1<TextBlockHierarchy.QueryStatement, Object> & Serializable & scala.Serializable)st -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$interpret$12(st)))).map((Function1<TextBlockHierarchy.QueryStatement, Object> & Serializable & scala.Serializable)x0$1 -> {
                    TextBlockHierarchy.QueryStatement queryStatement = x0$1;
                    if (queryStatement instanceof TextBlockHierarchy.SimpleStm) {
                        TextBlockHierarchy.SimpleStm simpleStm = (TextBlockHierarchy.SimpleStm)queryStatement;
                        return this.generateSimpleStatement(simpleStm, queryOptions, context);
                    }
                    if (queryStatement instanceof TextBlockHierarchy.BatchStm) {
                        TextBlockHierarchy.BatchStm batchStm = (TextBlockHierarchy.BatchStm)queryStatement;
                        List<BatchableStatement<?>> builtStatements = batchStm.statements().map((Function1<TextBlockHierarchy.QueryStatement, BatchableStatement> & Serializable & scala.Serializable)x0$2 -> {
                            TextBlockHierarchy.QueryStatement queryStatement = x0$2;
                            if (queryStatement instanceof TextBlockHierarchy.SimpleStm) {
                                TextBlockHierarchy.SimpleStm simpleStm = (TextBlockHierarchy.SimpleStm)queryStatement;
                                return this.generateSimpleStatement(simpleStm, queryOptions, context);
                            }
                            if (queryStatement instanceof TextBlockHierarchy.BoundStm) {
                                TextBlockHierarchy.BoundStm boundStm = (TextBlockHierarchy.BoundStm)queryStatement;
                                return this.generateBoundStatement(session, boundStm, queryOptions, context);
                            }
                            throw new InterpreterException("Unknown statement type");
                        }, List$.MODULE$.canBuildFrom());
                        return this.generateBatchStatement(batchStm.batchType(), queryOptions, builtStatements);
                    }
                    if (queryStatement instanceof TextBlockHierarchy.BoundStm) {
                        TextBlockHierarchy.BoundStm boundStm = (TextBlockHierarchy.BoundStm)queryStatement;
                        return this.generateBoundStatement(session, boundStm, queryOptions, context);
                    }
                    if (queryStatement instanceof TextBlockHierarchy.DescribeCommandStatement) {
                        TextBlockHierarchy.QueryStatement queryStatement2 = queryStatement;
                        return queryStatement2;
                    }
                    if (queryStatement instanceof TextBlockHierarchy.HelpCmd) {
                        TextBlockHierarchy.HelpCmd helpCmd = (TextBlockHierarchy.HelpCmd)queryStatement;
                        return helpCmd;
                    }
                    throw new InterpreterException(new java.lang.StringBuilder(25).append("Unknown statement type : ").append(queryStatement).toString());
                }, List$.MODULE$.canBuildFrom());
                Seq results = statements.map((Function1<Object, Tuple2> & Serializable & scala.Serializable)statement -> new Tuple2<Object, Object>(this.enhancedSession().execute(statement), statement), Seq$.MODULE$.canBuildFrom());
                if (results.nonEmpty()) {
                    Object output;
                    Tuple2 tuple2 = (Tuple2)results.last();
                    if (tuple2 != null) {
                        Object res = tuple2._1();
                        Object st2 = tuple2._2();
                        if (res instanceof ResultSet) {
                            ResultSet resultSet = (ResultSet)res;
                            if (st2 instanceof Statement) {
                                Statement statement2 = (Statement)st2;
                                interpreterResult = this.buildResponseMessage(new Tuple2<ResultSet, Statement>(resultSet, statement2), executionFormatter);
                                break block10;
                            }
                        }
                    }
                    if (tuple2 != null && (output = tuple2._1()) instanceof String) {
                        String string = (String)output;
                        interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS, string);
                        break block10;
                    }
                    throw new InterpreterException(new java.lang.StringBuilder(27).append("Cannot parse result type : ").append(results.last()).toString());
                }
                interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS, this.enhancedSession().displayNoResult());
            }
            catch (DriverException dex) {
                InterpreterLogic$.MODULE$.logger().error(dex.getMessage(), dex);
                interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, this.parseException(dex));
            }
            catch (ParsingException pex) {
                InterpreterLogic$.MODULE$.logger().error(pex.getMessage(), pex);
                interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, pex.getMessage());
            }
            catch (InterpreterException iex) {
                InterpreterLogic$.MODULE$.logger().error(iex.getMessage(), iex);
                interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, iex.getMessage());
            }
            catch (Exception ex) {
                InterpreterLogic$.MODULE$.logger().error(ex.getMessage(), ex);
                interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, this.parseException(ex));
            }
        }
        return interpreterResult;
    }

    public <StatementT extends Statement<StatementT>> InterpreterResult buildResponseMessage(Tuple2<ResultSet, StatementT> lastResultSet, CqlFormatter fmt) {
        Serializable serializable;
        StringBuilder output = new StringBuilder();
        ArrayBuffer rows = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        Iterator iterator = ((java.lang.Iterable)lastResultSet._1()).iterator();
        while (iterator.hasNext()) {
            rows.append(Predef$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)iterator.next()}));
        }
        List<?> columnsDefinitions = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((PagingIterable)lastResultSet._1()).getColumnDefinitions()).asScala()).toList().map((Function1<ColumnDefinition, Tuple2> & Serializable & scala.Serializable)definition -> new Tuple2<String, DataType>(definition.getName().asCql(true), definition.getType()), List$.MODULE$.canBuildFrom());
        if (rows.nonEmpty()) {
            output.append("%table ").append(((TraversableOnce)columnsDefinitions.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String columnName = (String)tuple2._1();
                    return columnName;
                }
                throw new MatchError(tuple2);
            }, List$.MODULE$.canBuildFrom())).mkString("\t")).append("\n");
            rows.foreach((Function1<Row, StringBuilder> & Serializable & scala.Serializable)row -> {
                List data = columnsDefinitions.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        DataType dataType = (DataType)tuple2._2();
                        if (row.isNull(name)) {
                            return null;
                        }
                        return fmt.getValueAsString((Row)row, name, dataType);
                    }
                    throw new MatchError(tuple2);
                }, List$.MODULE$.canBuildFrom());
                return output.append(data.mkString("\t")).append("\n");
            });
            serializable = BoxedUnit.UNIT;
        } else {
            String lastQuery = EnhancedSession$.MODULE$.getCqlStatement((Statement)lastResultSet._2());
            ExecutionInfo executionInfo = ((PagingIterable)lastResultSet._1()).getExecutionInfo();
            serializable = output.append(this.enhancedSession().displayExecutionStatistics(lastQuery, executionInfo));
        }
        String result2 = output.toString();
        InterpreterLogic$.MODULE$.logger().debug(new java.lang.StringBuilder(16).append("CQL result : \n\n").append(result2).append("\n").toString());
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, result2);
    }

    public List<TextBlockHierarchy.AnyBlock> parseInput(String input) {
        Parsers.ParseResult<List<TextBlockHierarchy.AnyBlock>> parsingResult = InterpreterLogic$.MODULE$.paragraphParser().parseAll(InterpreterLogic$.MODULE$.paragraphParser().queries(), input);
        Parsers.ParseResult<List<TextBlockHierarchy.AnyBlock>> parseResult = parsingResult;
        if (parseResult instanceof Parsers.Success && ((Parsers.Success)parseResult).scala$util$parsing$combinator$Parsers$Success$$$outer() == InterpreterLogic$.MODULE$.paragraphParser()) {
            Parsers.Success success = (Parsers.Success)parseResult;
            List blocks = (List)success.result();
            return blocks;
        }
        if (parseResult instanceof Parsers.Failure && ((Parsers.Failure)parseResult).scala$util$parsing$combinator$Parsers$Failure$$$outer() == InterpreterLogic$.MODULE$.paragraphParser()) {
            throw new InterpreterException(new java.lang.StringBuilder(96).append("Error parsing input:\n\t'").append(input).append("'\nDid you forget to add ; (semi-colon) at the end of each CQL statement ?").toString());
        }
        if (parseResult instanceof Parsers.Error && ((Parsers.Error)parseResult).scala$util$parsing$combinator$Parsers$Error$$$outer() == InterpreterLogic$.MODULE$.paragraphParser()) {
            throw new InterpreterException(new java.lang.StringBuilder(96).append("Error parsing input:\n\t'").append(input).append("'\nDid you forget to add ; (semi-colon) at the end of each CQL statement ?").toString());
        }
        throw new InterpreterException(new java.lang.StringBuilder(21).append("Error parsing input: ").append(input).toString());
    }

    public CqlFormatter extractFormatter(InterpreterContext context) {
        if (context == null) {
            return this.formatter();
        }
        Map props = context.getLocalProperties();
        InterpreterLogic$.MODULE$.logger().debug("Extracting query options from {}", new Object[]{props});
        if (props == null || props.isEmpty()) {
            return this.formatter();
        }
        InterpreterLogic$.MODULE$.logger().debug("extracting properties into formatter. default: {}", new Object[]{this.formatter()});
        String locale = props.getOrDefault("locale", this.formatter().localeStr());
        String timezone = props.getOrDefault("timezone", this.formatter().timeZoneId());
        String outputFormat = props.getOrDefault("outputFormat", this.formatter().outputFormat());
        int floatPrecision = new StringOps(Predef$.MODULE$.augmentString(props.getOrDefault("floatPrecision", Integer.toString(this.formatter().floatPrecision())))).toInt();
        int doublePrecision = new StringOps(Predef$.MODULE$.augmentString(props.getOrDefault("doublePrecision", Integer.toString(this.formatter().doublePrecision())))).toInt();
        int decimalPrecision = new StringOps(Predef$.MODULE$.augmentString(props.getOrDefault("decimalPrecision", Integer.toString(this.formatter().decimalPrecision())))).toInt();
        String timestampFormat = props.getOrDefault("timestampFormat", this.formatter().timestampFormat());
        String timeFormat = props.getOrDefault("timeFormat", this.formatter().timeFormat());
        String dateFormat = props.getOrDefault("dateFormat", this.formatter().dateFormat());
        return new CqlFormatter(outputFormat, floatPrecision, doublePrecision, decimalPrecision, timestampFormat, timeFormat, dateFormat, timezone, locale);
    }

    public CassandraQueryOptions extractQueryOptions(List<TextBlockHierarchy.QueryParameters> parameters) {
        Option<ConsistencyLevel> consistency = ((TraversableLike)((List)parameters.filter((Function1<TextBlockHierarchy.QueryParameters, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$extractQueryOptions$1(x$9)))).map((Function1<TextBlockHierarchy.QueryParameters, TextBlockHierarchy.Consistency> & Serializable & scala.Serializable)x$10 -> (TextBlockHierarchy.Consistency)x$10.getParam(), List$.MODULE$.canBuildFrom()).flatMap((Function1<TextBlockHierarchy.Consistency, Iterable> & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x.value())), List$.MODULE$.canBuildFrom())).headOption();
        Option<ConsistencyLevel> serialConsistency = ((TraversableLike)((List)parameters.filter((Function1<TextBlockHierarchy.QueryParameters, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$extractQueryOptions$4(x$11)))).map((Function1<TextBlockHierarchy.QueryParameters, TextBlockHierarchy.SerialConsistency> & Serializable & scala.Serializable)x$12 -> (TextBlockHierarchy.SerialConsistency)x$12.getParam(), List$.MODULE$.canBuildFrom()).flatMap((Function1<TextBlockHierarchy.SerialConsistency, Iterable> & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x.value())), List$.MODULE$.canBuildFrom())).headOption();
        Option<Object> timestamp = ((TraversableLike)((List)parameters.filter((Function1<TextBlockHierarchy.QueryParameters, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$extractQueryOptions$7(x$13)))).map((Function1<TextBlockHierarchy.QueryParameters, TextBlockHierarchy.Timestamp> & Serializable & scala.Serializable)x$14 -> (TextBlockHierarchy.Timestamp)x$14.getParam(), List$.MODULE$.canBuildFrom()).flatMap((Function1<TextBlockHierarchy.Timestamp, Iterable> & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(BoxesRunTime.boxToLong(x.value()))), List$.MODULE$.canBuildFrom())).headOption();
        Option<Object> fetchSize = ((TraversableLike)((List)parameters.filter((Function1<TextBlockHierarchy.QueryParameters, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$extractQueryOptions$10(x$15)))).map((Function1<TextBlockHierarchy.QueryParameters, TextBlockHierarchy.FetchSize> & Serializable & scala.Serializable)x$16 -> (TextBlockHierarchy.FetchSize)x$16.getParam(), List$.MODULE$.canBuildFrom()).flatMap((Function1<TextBlockHierarchy.FetchSize, Iterable> & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(BoxesRunTime.boxToInteger(x.value()))), List$.MODULE$.canBuildFrom())).headOption();
        Option<Object> requestTimeOut = ((TraversableLike)((List)parameters.filter((Function1<TextBlockHierarchy.QueryParameters, Object> & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean(InterpreterLogic.$anonfun$extractQueryOptions$13(x$17)))).map((Function1<TextBlockHierarchy.QueryParameters, TextBlockHierarchy.RequestTimeOut> & Serializable & scala.Serializable)x$18 -> (TextBlockHierarchy.RequestTimeOut)x$18.getParam(), List$.MODULE$.canBuildFrom()).flatMap((Function1<TextBlockHierarchy.RequestTimeOut, Iterable> & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(BoxesRunTime.boxToInteger(x.value()))), List$.MODULE$.canBuildFrom())).headOption();
        return new CassandraQueryOptions(consistency, serialConsistency, timestamp, fetchSize, requestTimeOut);
    }

    public SimpleStatement generateSimpleStatement(TextBlockHierarchy.SimpleStm st, CassandraQueryOptions options, InterpreterContext context) {
        InterpreterLogic$.MODULE$.logger().debug(new java.lang.StringBuilder(32).append("Generating simple statement : '").append(st.text()).append("'").toString());
        SimpleStatement statement = SimpleStatement.newInstance(this.maybeExtractVariables(st.text(), context));
        return this.applyQueryOptions(options, statement);
    }

    public BoundStatement generateBoundStatement(CqlSession session, TextBlockHierarchy.BoundStm st, CassandraQueryOptions options, InterpreterContext context) {
        InterpreterLogic$.MODULE$.logger().debug(new java.lang.StringBuilder(61).append("Generating bound statement with name : '").append(st.name()).append("' and bound values : ").append(st.values()).toString());
        Option option = InterpreterLogic$.MODULE$.preparedStatements().get(st.name());
        if (option instanceof Some) {
            Some some = (Some)option;
            PreparedStatement ps = (PreparedStatement)some.value();
            String boundValues = this.maybeExtractVariables(st.values(), context);
            BoundStatement statement = this.createBoundStatement(session.getContext().getCodecRegistry(), st.name(), ps, boundValues);
            return this.applyQueryOptions(options, statement);
        }
        if (None$.MODULE$.equals(option)) {
            throw new InterpreterException(new java.lang.StringBuilder(94).append("The statement '").append(st.name()).append("' can not be bound to values. ").append("Are you sure you did prepare it with @prepare[").append(st.name()).append("] ?").toString());
        }
        throw new MatchError(option);
    }

    public BatchStatement generateBatchStatement(BatchType batchType, CassandraQueryOptions options, Seq<BatchableStatement<?>> statements) {
        InterpreterLogic$.MODULE$.logger().debug(new java.lang.StringBuilder(42).append("Generating batch statement of type '").append(batchType).append(" for ").append(statements.mkString(",")).append("'").toString());
        BatchStatement batch = BatchStatement.newInstance(batchType).addAll((BatchableStatement[])statements.toArray(ClassTag$.MODULE$.apply(BatchableStatement.class)));
        return this.applyQueryOptions(options, batch);
    }

    public String maybeExtractVariables(String statement2, InterpreterContext context) {
        return InterpreterLogic$.MODULE$.VARIABLE_PATTERN().findAllIn(statement2).foldLeft(statement2, (Function2<String, String, String> & Serializable & scala.Serializable)(statement, exp) -> InterpreterLogic.extractVariableAndDefaultValue$1(statement, exp, context));
    }

    public <StatementT extends Statement<StatementT>> StatementT applyQueryOptions(CassandraQueryOptions options, StatementT statement) {
        StatementT stmt1 = options.consistency().isDefined() ? statement.setConsistencyLevel(options.consistency().get()) : statement;
        StatementT stmt2 = options.serialConsistency().isDefined() ? stmt1.setSerialConsistencyLevel(options.serialConsistency().get()) : stmt1;
        StatementT stmt3 = options.timestamp().isDefined() ? stmt2.setQueryTimestamp(BoxesRunTime.unboxToLong(options.timestamp().get())) : stmt2;
        StatementT stmt4 = options.fetchSize().isDefined() ? stmt3.setPageSize(BoxesRunTime.unboxToInt(options.fetchSize().get())) : stmt3;
        StatementT stmt5 = options.requestTimeOut().isDefined() ? stmt4.setTimeout(Duration.ofSeconds(BoxesRunTime.unboxToInt(options.requestTimeOut().get()))) : stmt4;
        return stmt5;
    }

    private BoundStatement createBoundStatement(CodecRegistry codecRegistry, String name, PreparedStatement ps, String rawBoundValues) {
        Seq dataTypes = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(ps.getVariableDefinitions().iterator()).asScala()).toSeq().map((Function1<ColumnDefinition, DataType> & Serializable & scala.Serializable)cfDef -> cfDef.getType(), Seq$.MODULE$.canBuildFrom());
        List<String> boundValuesAsText = this.parseBoundValues(name, rawBoundValues);
        if (dataTypes.size() != boundValuesAsText.size()) {
            throw new InterpreterException(new java.lang.StringBuilder(124).append("Invalid @bind values for prepared statement '").append(name).append("'. ").append("Prepared parameters has ").append(dataTypes.size()).append(" variables whereas bound values have ").append(boundValuesAsText.size()).append(" parameters ...").toString());
        }
        List convertedValues = boundValuesAsText.zip(dataTypes, List$.MODULE$.canBuildFrom()).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                String value = (String)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                String string = value.trim();
                String string2 = "null";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return null;
                }
                TypeCodec<DataType> codec = codecRegistry.codecFor(dataType);
                DataType dataType2 = dataType;
                DataType dataType3 = DataTypes.ASCII;
                DataType dataType4 = dataType2;
                if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                    bl4 = true;
                } else {
                    DataType dataType5 = DataTypes.TEXT;
                    DataType dataType6 = dataType2;
                    bl4 = !(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null);
                }
                if (bl4) {
                    return value.trim().replaceAll("(?<!')'", "");
                }
                DataType dataType7 = DataTypes.INT;
                DataType dataType8 = dataType2;
                if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                    bl3 = true;
                } else {
                    DataType dataType9 = DataTypes.VARINT;
                    DataType dataType10 = dataType2;
                    bl3 = !(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null);
                }
                if (bl3) {
                    return BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(value.trim())).toInt());
                }
                DataType dataType11 = DataTypes.BIGINT;
                DataType dataType12 = dataType2;
                if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
                    bl2 = true;
                } else {
                    DataType dataType13 = DataTypes.COUNTER;
                    DataType dataType14 = dataType2;
                    bl2 = !(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null);
                }
                if (bl2) {
                    return BoxesRunTime.boxToLong(new StringOps(Predef$.MODULE$.augmentString(value.trim())).toLong());
                }
                DataType dataType15 = DataTypes.BLOB;
                DataType dataType16 = dataType2;
                if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
                    return ByteBuffer.wrap(value.trim().getBytes());
                }
                DataType dataType17 = DataTypes.BOOLEAN;
                DataType dataType18 = dataType2;
                if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
                    return BoxesRunTime.boxToBoolean(new StringOps(Predef$.MODULE$.augmentString(value.trim())).toBoolean());
                }
                DataType dataType19 = DataTypes.DECIMAL;
                DataType dataType20 = dataType2;
                if (!(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null)) {
                    return package$.MODULE$.BigDecimal().apply(value.trim());
                }
                DataType dataType21 = DataTypes.DOUBLE;
                DataType dataType22 = dataType2;
                if (!(dataType21 != null ? !dataType21.equals(dataType22) : dataType22 != null)) {
                    return BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(value.trim())).toDouble());
                }
                DataType dataType23 = DataTypes.FLOAT;
                DataType dataType24 = dataType2;
                if (!(dataType23 != null ? !dataType23.equals(dataType24) : dataType24 != null)) {
                    return BoxesRunTime.boxToFloat(new StringOps(Predef$.MODULE$.augmentString(value.trim())).toFloat());
                }
                DataType dataType25 = DataTypes.INET;
                DataType dataType26 = dataType2;
                if (!(dataType25 != null ? !dataType25.equals(dataType26) : dataType26 != null)) {
                    return InetAddress.getByName(value.trim());
                }
                DataType dataType27 = DataTypes.TIMESTAMP;
                DataType dataType28 = dataType2;
                if (!(dataType27 != null ? !dataType27.equals(dataType28) : dataType28 != null)) {
                    return this.parseDate(value.trim());
                }
                DataType dataType29 = DataTypes.UUID;
                DataType dataType30 = dataType2;
                if (!(dataType29 != null ? !dataType29.equals(dataType30) : dataType30 != null)) {
                    bl = true;
                } else {
                    DataType dataType31 = DataTypes.TIMEUUID;
                    DataType dataType32 = dataType2;
                    bl = !(dataType31 != null ? !dataType31.equals(dataType32) : dataType32 != null);
                }
                if (bl) {
                    return UUID.fromString(value.trim());
                }
                if (dataType2 instanceof ListType) {
                    return codec.parse(InterpreterLogic$.MODULE$.boundValuesParser().parse(InterpreterLogic$.MODULE$.boundValuesParser().list(), value).get());
                }
                if (dataType2 instanceof SetType) {
                    return codec.parse(InterpreterLogic$.MODULE$.boundValuesParser().parse(InterpreterLogic$.MODULE$.boundValuesParser().set(), value).get());
                }
                if (dataType2 instanceof MapType) {
                    return codec.parse(InterpreterLogic$.MODULE$.boundValuesParser().parse(InterpreterLogic$.MODULE$.boundValuesParser().map(), value).get());
                }
                if (dataType2 instanceof UserDefinedType) {
                    return codec.parse(InterpreterLogic$.MODULE$.boundValuesParser().parse(InterpreterLogic$.MODULE$.boundValuesParser().udt(), value).get());
                }
                if (dataType2 instanceof TupleType) {
                    return codec.parse(InterpreterLogic$.MODULE$.boundValuesParser().parse(InterpreterLogic$.MODULE$.boundValuesParser().tuple(), value).get());
                }
                throw new InterpreterException(new java.lang.StringBuilder(28).append("Cannot parse data of type : ").append(dataType.toString()).toString());
            }
            throw new MatchError(tuple2);
        }, List$.MODULE$.canBuildFrom());
        return ps.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public List<String> parseBoundValues(String psName, String boundValues) {
        Parsers.ParseResult<List<String>> result2 = InterpreterLogic$.MODULE$.boundValuesParser().parseAll(InterpreterLogic$.MODULE$.boundValuesParser().values(), boundValues);
        Parsers.ParseResult<List<String>> parseResult = result2;
        if (parseResult instanceof Parsers.Success && ((Parsers.Success)parseResult).scala$util$parsing$combinator$Parsers$Success$$$outer() == InterpreterLogic$.MODULE$.boundValuesParser()) {
            Parsers.Success success = (Parsers.Success)parseResult;
            List list = (List)success.result();
            return list;
        }
        throw new InterpreterException(new java.lang.StringBuilder(107).append("Cannot parse bound values for prepared statement '").append(psName).append("' : ").append(boundValues).append(". Did you forget to wrap text with ' (simple quote) ?").toString());
    }

    public Instant parseDate(String dateString) {
        DateTimeFormatter dateTimeFormatter;
        String string = dateString;
        Option<List<String>> option = InterpreterLogic$.MODULE$.boundValuesParser().STANDARD_DATE_PATTERN().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            dateTimeFormatter = InterpreterLogic$.MODULE$.STANDARD_DATE_FORMATTER();
        } else {
            Option<List<String>> option2 = InterpreterLogic$.MODULE$.boundValuesParser().ACCURATE_DATE_PATTERN().unapplySeq(string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                dateTimeFormatter = InterpreterLogic$.MODULE$.ACCURATE_DATE_FORMATTER();
            } else {
                throw new InterpreterException(new java.lang.StringBuilder(45).append("Cannot parse date '").append(dateString).append("'. ").append("Accepted formats : ").append(InterpreterLogic$.MODULE$.STANDARD_DATE_FORMAT()).append(" OR ").append(InterpreterLogic$.MODULE$.ACCURATE_DATE_FORMAT()).toString());
            }
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return LocalDateTime.parse(dateString, formatter).toInstant(ZoneOffset.UTC);
    }

    public String parseException(Exception ex) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ex.printStackTrace(ps);
        return os.toString("UTF-8");
    }

    public static final /* synthetic */ boolean $anonfun$interpret$1(TextBlockHierarchy.AnyBlock x$1) {
        TextBlockHierarchy.BlockType blockType = x$1.blockType();
        TextBlockHierarchy$ParameterBlock$ textBlockHierarchy$ParameterBlock$ = TextBlockHierarchy$ParameterBlock$.MODULE$;
        return !(blockType != null ? !blockType.equals(textBlockHierarchy$ParameterBlock$) : textBlockHierarchy$ParameterBlock$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$interpret$3(TextBlockHierarchy.AnyBlock x$3) {
        TextBlockHierarchy.BlockType blockType = x$3.blockType();
        TextBlockHierarchy$StatementBlock$ textBlockHierarchy$StatementBlock$ = TextBlockHierarchy$StatementBlock$.MODULE$;
        return !(blockType != null ? !blockType.equals(textBlockHierarchy$StatementBlock$) : textBlockHierarchy$StatementBlock$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$interpret$5(TextBlockHierarchy.QueryStatement x$5) {
        TextBlockHierarchy.StatementType statementType = x$5.statementType();
        TextBlockHierarchy$RemovePrepareStatementType$ textBlockHierarchy$RemovePrepareStatementType$ = TextBlockHierarchy$RemovePrepareStatementType$.MODULE$;
        return !(statementType != null ? !statementType.equals(textBlockHierarchy$RemovePrepareStatementType$) : textBlockHierarchy$RemovePrepareStatementType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$interpret$8(TextBlockHierarchy.QueryStatement x$7) {
        TextBlockHierarchy.StatementType statementType = x$7.statementType();
        TextBlockHierarchy$PrepareStatementType$ textBlockHierarchy$PrepareStatementType$ = TextBlockHierarchy$PrepareStatementType$.MODULE$;
        return !(statementType != null ? !statementType.equals(textBlockHierarchy$PrepareStatementType$) : textBlockHierarchy$PrepareStatementType$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$interpret$12(TextBlockHierarchy.QueryStatement st) {
        TextBlockHierarchy.StatementType statementType = st.statementType();
        TextBlockHierarchy$PrepareStatementType$ textBlockHierarchy$PrepareStatementType$ = TextBlockHierarchy$PrepareStatementType$.MODULE$;
        if (statementType == null) {
            if (textBlockHierarchy$PrepareStatementType$ == null) return false;
        } else if (statementType.equals(textBlockHierarchy$PrepareStatementType$)) return false;
        TextBlockHierarchy.StatementType statementType2 = st.statementType();
        TextBlockHierarchy$RemovePrepareStatementType$ textBlockHierarchy$RemovePrepareStatementType$ = TextBlockHierarchy$RemovePrepareStatementType$.MODULE$;
        if (statementType2 == null) {
            if (textBlockHierarchy$RemovePrepareStatementType$ == null) return false;
            return true;
        } else if (statementType2.equals(textBlockHierarchy$RemovePrepareStatementType$)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$extractQueryOptions$1(TextBlockHierarchy.QueryParameters x$9) {
        TextBlockHierarchy.ParameterType parameterType = x$9.paramType();
        TextBlockHierarchy$ConsistencyParam$ textBlockHierarchy$ConsistencyParam$ = TextBlockHierarchy$ConsistencyParam$.MODULE$;
        return !(parameterType != null ? !parameterType.equals(textBlockHierarchy$ConsistencyParam$) : textBlockHierarchy$ConsistencyParam$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractQueryOptions$4(TextBlockHierarchy.QueryParameters x$11) {
        TextBlockHierarchy.ParameterType parameterType = x$11.paramType();
        TextBlockHierarchy$SerialConsistencyParam$ textBlockHierarchy$SerialConsistencyParam$ = TextBlockHierarchy$SerialConsistencyParam$.MODULE$;
        return !(parameterType != null ? !parameterType.equals(textBlockHierarchy$SerialConsistencyParam$) : textBlockHierarchy$SerialConsistencyParam$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractQueryOptions$7(TextBlockHierarchy.QueryParameters x$13) {
        TextBlockHierarchy.ParameterType parameterType = x$13.paramType();
        TextBlockHierarchy$TimestampParam$ textBlockHierarchy$TimestampParam$ = TextBlockHierarchy$TimestampParam$.MODULE$;
        return !(parameterType != null ? !parameterType.equals(textBlockHierarchy$TimestampParam$) : textBlockHierarchy$TimestampParam$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractQueryOptions$10(TextBlockHierarchy.QueryParameters x$15) {
        TextBlockHierarchy.ParameterType parameterType = x$15.paramType();
        TextBlockHierarchy$FetchSizeParam$ textBlockHierarchy$FetchSizeParam$ = TextBlockHierarchy$FetchSizeParam$.MODULE$;
        return !(parameterType != null ? !parameterType.equals(textBlockHierarchy$FetchSizeParam$) : textBlockHierarchy$FetchSizeParam$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractQueryOptions$13(TextBlockHierarchy.QueryParameters x$17) {
        TextBlockHierarchy.ParameterType parameterType = x$17.paramType();
        TextBlockHierarchy$RequestTimeOutParam$ textBlockHierarchy$RequestTimeOutParam$ = TextBlockHierarchy$RequestTimeOutParam$.MODULE$;
        return !(parameterType != null ? !parameterType.equals(textBlockHierarchy$RequestTimeOutParam$) : textBlockHierarchy$RequestTimeOutParam$ != null);
    }

    private static final Option findInAngularRepository$1(String variable, InterpreterContext context$2) {
        AngularObjectRegistry registry = context$2.getAngularObjectRegistry();
        String noteId = context$2.getNoteId();
        String paragraphId = context$2.getParagraphId();
        Option paragraphScoped = Option$.MODULE$.apply(registry.get(variable, noteId, paragraphId)).map((Function1<AngularObject, Object> & Serializable & scala.Serializable)x$19 -> x$19.get());
        return paragraphScoped;
    }

    private static final String extractVariableAndDefaultValue$1(String statement, String exp, InterpreterContext context$2) {
        String string = exp;
        Option<List<String>> option = InterpreterLogic$.MODULE$.MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String variable = (String)((LinearSeqOptimized)option.get()).apply(0);
            String choices = (String)((LinearSeqOptimized)option.get()).apply(1);
            String escapedExp = exp.replaceAll("\\{", "\\\\{").replaceAll("}", "\\\\}").replaceAll("\\|", "\\\\|");
            Option option2 = InterpreterLogic.findInAngularRepository$1(variable, context$2);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object value = some.value();
                return statement.replaceAll(escapedExp, value.toString());
            }
            if (None$.MODULE$.equals(option2)) {
                List<Object> listChoices = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])choices.trim().split(InterpreterLogic$.MODULE$.CHOICES_SEPARATOR()))).toList();
                List paramOptions = listChoices.map((Function1<String, OptionInput.ParamOption> & Serializable & scala.Serializable)choice -> new OptionInput.ParamOption(choice, choice), List$.MODULE$.canBuildFrom());
                Object selected = context$2.getGui().select(variable, (OptionInput.ParamOption[])paramOptions.toArray(ClassTag$.MODULE$.apply(OptionInput.ParamOption.class)), listChoices.head());
                return statement.replaceAll(escapedExp, selected.toString());
            }
            throw new MatchError(option2);
        }
        Option<List<String>> option3 = InterpreterLogic$.MODULE$.SIMPLE_VARIABLE_DEFINITION_PATTERN().unapplySeq(string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
            String variable = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String defaultVal = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String escapedExp = exp.replaceAll("\\{", "\\\\{").replaceAll("}", "\\\\}");
            Option option4 = InterpreterLogic.findInAngularRepository$1(variable, context$2);
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                Object value = some.value();
                return statement.replaceAll(escapedExp, value.toString());
            }
            if (None$.MODULE$.equals(option4)) {
                Object value = context$2.getGui().textbox(variable, defaultVal);
                return statement.replaceAll(escapedExp, value.toString());
            }
            throw new MatchError(option4);
        }
        throw new ParsingException(new java.lang.StringBuilder(131).append("Invalid bound variable definition for '").append(exp).append("' in '").append(statement).append("'. It should be of form 'variable=defaultValue' or 'variable=value1|value2|...|valueN'").toString());
    }

    public InterpreterLogic(CqlSession session, Properties properties) {
        this.session = session;
        this.properties = properties;
        this.enhancedSession = new EnhancedSession(session);
        this.formatter = new CqlFormatter(properties);
    }
}

