/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.completer;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class StringsCompleter
implements Completer {
    private final SortedSet<String> strings = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    });

    public StringsCompleter() {
    }

    public StringsCompleter(Collection<String> strings) {
        Preconditions.checkNotNull(strings);
        this.getStrings().addAll(strings);
    }

    public Collection<String> getStrings() {
        return this.strings;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        return this.completeCollection(buffer, cursor, candidates);
    }

    public int complete(String buffer, int cursor, Set<CharSequence> candidates) {
        return this.completeCollection(buffer, cursor, candidates);
    }

    private int completeCollection(String buffer, int cursor, Collection<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        if (buffer == null) {
            candidates.addAll(this.strings);
        } else {
            String match;
            String matchTmp;
            String part = buffer.substring(0, cursor);
            String bufferTmp = part.toUpperCase();
            Iterator iterator = this.strings.tailSet(part).iterator();
            while (iterator.hasNext() && (matchTmp = (match = (String)iterator.next()).toUpperCase()).startsWith(bufferTmp)) {
                candidates.add(match);
            }
        }
        return candidates.isEmpty() ? -1 : 0;
    }
}

