/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.tabledata;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TableDataUtils {
    public static String normalizeColumn(String column) {
        if (column == null) {
            return "null";
        }
        return column.replace("\t", " ").replace("\r\n", " ").replace("\n", " ");
    }

    public static String normalizeColumn(Object obj) {
        return TableDataUtils.normalizeColumn(obj == null ? "null" : obj.toString());
    }

    public static List<String> normalizeColumns(List<Object> columns) {
        return columns.stream().map(TableDataUtils::normalizeColumn).collect(Collectors.toList());
    }

    public static List<String> normalizeColumns(Object[] columns) {
        return Arrays.stream(columns).map(TableDataUtils::normalizeColumn).collect(Collectors.toList());
    }
}

