/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.livy;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.livy.APINotFoundException;
import org.apache.zeppelin.livy.BaseLivyInterpreter;
import org.apache.zeppelin.livy.LivyException;
import org.apache.zeppelin.livy.LivyVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivySharedInterpreter
extends BaseLivyInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivySharedInterpreter.class);
    private boolean isSupported = false;

    public LivySharedInterpreter(Properties property) {
        super(property);
    }

    @Override
    public void open() throws InterpreterException {
        try {
            try {
                this.livyVersion = this.getLivyVersion();
                LOGGER.info("Use livy " + this.livyVersion);
            }
            catch (APINotFoundException e) {
                this.livyVersion = new LivyVersion("0.2.0");
                LOGGER.info("Use livy 0.2.0");
            }
            if (this.livyVersion.isSharedSupported()) {
                LOGGER.info("LivySharedInterpreter is supported.");
                this.isSupported = true;
                this.initLivySession();
            } else {
                LOGGER.info("LivySharedInterpreter is not supported.");
                this.isSupported = false;
            }
        }
        catch (LivyException e) {
            String msg = "Fail to create session, please check livy interpreter log and livy server log";
            throw new InterpreterException(msg, (Throwable)((Object)e));
        }
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public InterpreterResult interpret(String st, String codeType, InterpreterContext context) {
        if (StringUtils.isEmpty(st)) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
        }
        try {
            return this.interpret(st, codeType, context.getParagraphId(), this.displayAppInfo, true, true);
        }
        catch (LivyException e) {
            LOGGER.error("Fail to interpret:" + st, (Throwable)((Object)e));
            return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage((Exception)((Object)e)));
        }
    }

    @Override
    public String getSessionKind() {
        return "shared";
    }

    @Override
    protected String extractAppId() throws LivyException {
        return null;
    }

    @Override
    protected String extractWebUIAddress() throws LivyException {
        return null;
    }

    public static void main(String[] args) {
        BaseLivyInterpreter.ExecuteRequest request = new BaseLivyInterpreter.ExecuteRequest("1+1", null);
        System.out.println(request.toJson());
    }
}

