/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.client;

import java.net.URI;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class KerberosRestTemplate
extends RestTemplate {
    private static final Credentials credentials = new NullCredentials();
    private final String keyTabLocation;
    private final String userPrincipal;
    private final Map<String, Object> loginOptions;

    public KerberosRestTemplate() {
        this(null, null, null, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(HttpClient httpClient) {
        this(null, null, null, httpClient);
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal) {
        this(keyTabLocation, userPrincipal, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal, HttpClient httpClient) {
        this(keyTabLocation, userPrincipal, null, httpClient);
    }

    public KerberosRestTemplate(Map<String, Object> loginOptions) {
        this(null, null, loginOptions, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(Map<String, Object> loginOptions, HttpClient httpClient) {
        this(null, null, loginOptions, httpClient);
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal, Map<String, Object> loginOptions) {
        this(keyTabLocation, userPrincipal, loginOptions, KerberosRestTemplate.buildHttpClient());
    }

    private KerberosRestTemplate(String keyTabLocation, String userPrincipal, Map<String, Object> loginOptions, HttpClient httpClient) {
        super(new HttpComponentsClientHttpRequestFactory(httpClient));
        this.keyTabLocation = keyTabLocation;
        this.userPrincipal = userPrincipal;
        this.loginOptions = loginOptions;
    }

    private static HttpClient buildHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        Registry<AuthSchemeProvider> authSchemeRegistry = RegistryBuilder.create().register("negotiate", new SPNegoSchemeFactory(true)).build();
        builder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), credentials);
        builder.setDefaultCredentialsProvider(credentialsProvider);
        CloseableHttpClient httpClient = builder.build();
        return httpClient;
    }

    @Override
    protected final <T> T doExecute(final URI url, final HttpMethod method, final RequestCallback requestCallback, final ResponseExtractor<T> responseExtractor) throws RestClientException {
        try {
            ClientLoginConfig loginConfig = new ClientLoginConfig(this.keyTabLocation, this.userPrincipal, this.loginOptions);
            HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
            princ.add(new KerberosPrincipal(this.userPrincipal));
            Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
            LoginContext lc = new LoginContext("", sub, null, loginConfig);
            lc.login();
            Subject serviceSubject = lc.getSubject();
            return Subject.doAs(serviceSubject, new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return KerberosRestTemplate.this.doExecuteSubject(url, method, requestCallback, responseExtractor);
                }
            });
        }
        catch (Exception e) {
            throw new RestClientException("Error running rest call", e);
        }
    }

    private <T> T doExecuteSubject(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return super.doExecute(url, method, requestCallback, responseExtractor);
    }

    private static class NullCredentials
    implements Credentials {
        private NullCredentials() {
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public String getPassword() {
            return null;
        }
    }

    private static class ClientLoginConfig
    extends Configuration {
        private final String keyTabLocation;
        private final String userPrincipal;
        private final Map<String, Object> loginOptions;

        public ClientLoginConfig(String keyTabLocation, String userPrincipal, Map<String, Object> loginOptions) {
            this.keyTabLocation = keyTabLocation;
            this.userPrincipal = userPrincipal;
            this.loginOptions = loginOptions;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (!StringUtils.hasText(this.keyTabLocation) || !StringUtils.hasText(this.userPrincipal)) {
                options.put("useTicketCache", "true");
            } else {
                options.put("useKeyTab", "true");
                options.put("keyTab", this.keyTabLocation);
                options.put("principal", this.userPrincipal);
                options.put("storeKey", "true");
            }
            options.put("doNotPrompt", "true");
            options.put("isInitiator", "true");
            if (this.loginOptions != null) {
                options.putAll(this.loginOptions);
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

