/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.python.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonInterpreterPandasSql
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonInterpreterPandasSql.class);
    private static String SQL_BOOTSTRAP_FILE_PY = "python/bootstrap_sql.py";
    private PythonInterpreter pythonInterpreter;

    public PythonInterpreterPandasSql(Properties property) {
        super(property);
    }

    public void open() throws InterpreterException {
        LOGGER.info("Open Python SQL interpreter instance: PythonInterpreterPandasSql");
        try {
            LOGGER.info("Bootstrap PythonInterpreterPandasSql interpreter with {}", (Object)SQL_BOOTSTRAP_FILE_PY);
            this.pythonInterpreter = (PythonInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(PythonInterpreter.class));
            this.pythonInterpreter.bootstrapInterpreter(SQL_BOOTSTRAP_FILE_PY);
        }
        catch (IOException e) {
            LOGGER.error("Can't execute " + SQL_BOOTSTRAP_FILE_PY + " to import SQL dependencies", e);
        }
    }

    public void close() throws InterpreterException {
        LOGGER.info("Close Python SQL interpreter instance: {}", (Object)((Object)((Object)this)).toString());
        if (this.pythonInterpreter != null) {
            this.pythonInterpreter.close();
        }
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        LOGGER.info("Running SQL query: '{}' over Pandas DataFrame", (Object)st);
        return this.pythonInterpreter.interpret("z.show(pysqldf('" + st.trim() + "'))", context);
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        this.pythonInterpreter.cancel(context);
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.pythonInterpreter.getProgress(context);
    }
}

