/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxAccessibilityHelper;
import com.openhtmltopdf.pdfboxout.PdfBoxBookmarkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.pdfboxout.quads.KongAlgo;
import com.openhtmltopdf.pdfboxout.quads.Triangle;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.util.XRLog;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.w3c.dom.Element;

public class PdfBoxFastLinkManager {
    private final Map<PDPage, Set<String>> _linkTargetAreas;
    private final SharedContext _sharedContext;
    private final float _dotsPerPoint;
    private final Box _root;
    private final PdfBoxFastOutputDevice _od;
    private final List<LinkDetails> _links;
    private PdfBoxAccessibilityHelper _pdfUa;

    public PdfBoxFastLinkManager(SharedContext ctx, float dotsPerPoint, Box root, PdfBoxFastOutputDevice od) {
        this._sharedContext = ctx;
        this._dotsPerPoint = dotsPerPoint;
        this._root = root;
        this._od = od;
        this._linkTargetAreas = new HashMap<PDPage, Set<String>>();
        this._links = new ArrayList<LinkDetails>();
    }

    private Rectangle2D calcTotalLinkArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform) {
        Box prev;
        if (this._pdfUa != null) {
            return PdfBoxFastLinkManager.createTargetArea(c, box, pageHeight, transform, this._root, this._od);
        }
        Box current = box;
        while ((prev = current.getPreviousSibling()) != null && prev.getElement() == box.getElement()) {
            current = prev;
        }
        Rectangle2D result = PdfBoxFastLinkManager.createTargetArea(c, current, pageHeight, transform, this._root, this._od);
        for (current = current.getNextSibling(); current != null && current.getElement() == box.getElement(); current = current.getNextSibling()) {
            result = this.add(result, PdfBoxFastLinkManager.createTargetArea(c, current, pageHeight, transform, this._root, this._od));
        }
        return result;
    }

    private Rectangle2D add(Rectangle2D r1, Rectangle2D r2) {
        return r1.createUnion(r2);
    }

    private String createRectKey(Rectangle2D rect, Shape linkShape, AffineTransform transform) {
        StringBuilder key = new StringBuilder(rect.getMinX() + ":" + rect.getMaxY() + ":" + rect.getMaxX() + ":" + rect.getMinY());
        if (linkShape != null) {
            PathIterator pathIterator = linkShape.getPathIterator(transform);
            double[] vals = new double[6];
            while (!pathIterator.isDone()) {
                int type = pathIterator.currentSegment(vals);
                switch (type) {
                    case 3: {
                        key.append("C");
                        key.append(vals[0]).append(":").append(vals[1]).append(":").append(vals[2]).append(":").append(vals[3]).append(":").append(vals[4]).append(":").append(vals[5]);
                        break;
                    }
                    case 1: {
                        key.append("L");
                        key.append(vals[0]).append(":").append(vals[1]).append(":");
                        break;
                    }
                    case 0: {
                        key.append("M");
                        key.append(vals[0]).append(":").append(vals[1]).append(":");
                        break;
                    }
                    case 2: {
                        key.append("Q");
                        key.append(vals[0]).append(":").append(vals[1]).append(":").append(vals[2]).append(":").append(vals[3]);
                        break;
                    }
                    case 4: {
                        key.append("cp");
                        break;
                    }
                }
                pathIterator.next();
            }
        }
        return key.toString();
    }

    private Rectangle2D checkLinkArea(PDPage page, RenderingContext c, Box box, float pageHeight, AffineTransform transform, Shape linkShape) {
        Rectangle2D targetArea = this.calcTotalLinkArea(c, box, pageHeight, transform);
        String key = this.createRectKey(targetArea, linkShape, transform);
        Set<String> keys = this._linkTargetAreas.get(page);
        if (keys == null) {
            keys = new HashSet<String>();
            this._linkTargetAreas.put(page, keys);
        }
        if (keys.contains(key)) {
            return null;
        }
        keys.add(key);
        return targetArea;
    }

    private void processLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform) {
        Map<Shape, String> linkMap;
        ReplacedElement element;
        NamespaceHandler handler;
        String uri;
        Element elem = box.getElement();
        if (elem != null && (uri = (handler = this._sharedContext.getNamespaceHandler()).getLinkUri(elem)) != null) {
            this.addUriAsLink(c, box, page, pageHeight, transform, elem, handler, uri, null);
        }
        if (box instanceof BlockBox && (element = ((BlockBox)box).getReplacedElement()) instanceof PdfBoxLinkManager.IPdfBoxElementWithShapedLinks && (linkMap = ((PdfBoxLinkManager.IPdfBoxElementWithShapedLinks)((Object)element)).getLinkMap()) != null) {
            for (Map.Entry<Shape, String> shapeStringEntry : linkMap.entrySet()) {
                Shape shape = shapeStringEntry.getKey();
                String shapeUri = shapeStringEntry.getValue();
                NamespaceHandler handler2 = this._sharedContext.getNamespaceHandler();
                this.addUriAsLink(c, box, page, pageHeight, transform, elem, handler2, shapeUri, shape);
            }
        }
    }

    private static boolean isPointEqual(Point2D.Float p1, Point2D.Float p2) {
        double epsilon = 1.0E-6;
        return (double)Math.abs(p1.x - p2.x) < 1.0E-6 && (double)Math.abs(p1.y - p2.y) < 1.0E-6;
    }

    private static void removeDoublicatePoints(List<Point2D.Float> points) {
        boolean rerun;
        do {
            Point2D.Float p2;
            Point2D.Float p1;
            int i;
            rerun = false;
            for (i = 0; i < points.size() - 1; ++i) {
                p1 = points.get(i);
                if (!PdfBoxFastLinkManager.isPointEqual(p1, p2 = points.get(i + 1))) continue;
                points.remove(i);
                rerun = true;
            }
            for (i = 0; i < points.size() - 2; ++i) {
                p1 = points.get(i);
                if (!PdfBoxFastLinkManager.isPointEqual(p1, p2 = points.get(i + 2))) continue;
                points.remove(i);
                rerun = true;
            }
        } while (rerun);
    }

    private void addUriAsLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform, Element elem, NamespaceHandler handler, String uri, Shape linkShape) {
        if (uri.length() > 1 && uri.charAt(0) == '#') {
            String anchor = uri.substring(1);
            Box target = this._sharedContext.getBoxById(anchor);
            if (target != null) {
                PDAction action;
                PDPageXYZDestination dest = this.createDestination(c, target);
                if (handler.getAttributeValue(elem, "onclick") != null && !"".equals(handler.getAttributeValue(elem, "onclick"))) {
                    action = new PDActionJavaScript(handler.getAttributeValue(elem, "onclick"));
                } else {
                    PDActionGoTo go = new PDActionGoTo();
                    go.setDestination(dest);
                    action = go;
                }
                Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform, linkShape);
                if (targetArea == null) {
                    return;
                }
                PDAnnotationLink annot = new PDAnnotationLink();
                annot.setAction(action);
                if (!this.placeAnnotation(transform, linkShape, targetArea, annot)) {
                    return;
                }
                this.addLinkToPage(page, annot, box, target);
            } else {
                XRLog.general(Level.WARNING, "Could not find valid target for link. Link href = " + uri);
            }
        } else if (uri.contains("://")) {
            PDActionURI uriAct = new PDActionURI();
            uriAct.setURI(uri);
            Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform, linkShape);
            if (targetArea == null) {
                return;
            }
            PDAnnotationLink annot = new PDAnnotationLink();
            annot.setAction(uriAct);
            if (!this.placeAnnotation(transform, linkShape, targetArea, annot)) {
                return;
            }
            this.addLinkToPage(page, annot, box, null);
        }
    }

    private boolean placeAnnotation(AffineTransform transform, Shape linkShape, Rectangle2D targetArea, PDAnnotationLink annot) {
        annot.setRectangle(new PDRectangle((float)targetArea.getMinX(), (float)targetArea.getMinY(), (float)targetArea.getWidth(), (float)targetArea.getHeight()));
        annot.setPrinted(true);
        if (linkShape != null) {
            float[] quadPoints = this.mapShapeToQuadPoints(transform, linkShape, targetArea);
            if (quadPoints.length == 0) {
                return false;
            }
            annot.setQuadPoints(quadPoints);
        }
        return true;
    }

    private float[] mapShapeToQuadPoints(AffineTransform transform, Shape linkShape, Rectangle2D targetArea) {
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        AffineTransform transformForQuads = new AffineTransform();
        transformForQuads.translate(targetArea.getMinX(), targetArea.getMinY());
        transformForQuads.translate(0.0, targetArea.getHeight());
        transformForQuads.scale(1.0, -1.0);
        transformForQuads.concatenate(transform);
        Area area = new Area(linkShape);
        PathIterator pathIterator = area.getPathIterator(transformForQuads, 1.0);
        double[] vals = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(vals);
            switch (type) {
                case 3: {
                    throw new RuntimeException("Invalid State, Area should never give us a curve here!");
                }
                case 1: {
                    points.add(new Point2D.Float((float)vals[0], (float)vals[1]));
                    break;
                }
                case 0: {
                    points.add(new Point2D.Float((float)vals[0], (float)vals[1]));
                    break;
                }
                case 2: {
                    throw new RuntimeException("Invalid State, Area should never give us a curve here!");
                }
                case 4: {
                    break;
                }
            }
            pathIterator.next();
        }
        PdfBoxFastLinkManager.removeDoublicatePoints(points);
        KongAlgo algo = new KongAlgo(points);
        algo.runKong();
        float[] ret = new float[algo.getTriangles().size() * 8];
        int i = 0;
        for (Triangle triangle : algo.getTriangles()) {
            ret[i++] = triangle.a.x;
            ret[i++] = triangle.a.y;
            ret[i++] = triangle.b.x;
            ret[i++] = triangle.b.y;
            ret[i++] = triangle.b.x + (triangle.c.x - triangle.b.x) / 2.0f;
            ret[i++] = triangle.b.y + (triangle.c.y - triangle.b.y) / 2.0f;
            ret[i++] = triangle.c.x;
            ret[i++] = triangle.c.y;
        }
        if (ret.length % 8 != 0) {
            throw new IllegalStateException("Not exact 8xn QuadPoints!");
        }
        while (i < ret.length) {
            if ((double)ret[i] < targetArea.getMinX() || (double)ret[i] > targetArea.getMaxX()) {
                throw new IllegalStateException("Invalid rectangle calculation. Map shape is out of bound.");
            }
            if ((double)ret[i + 1] < targetArea.getMinY() || (double)ret[i + 1] > targetArea.getMaxY()) {
                throw new IllegalStateException("Invalid rectangle calculation. Map shape is out of bound.");
            }
            i += 2;
        }
        return ret;
    }

    private void addLinkToPage(PDPage page, PDAnnotationLink annot, Box anchor, Box target) {
        PDBorderStyleDictionary styleDict = new PDBorderStyleDictionary();
        styleDict.setWidth(0.0f);
        styleDict.setStyle("S");
        annot.setBorderStyle(styleDict);
        try {
            List<PDAnnotation> annots = page.getAnnotations();
            if (annots == null) {
                annots = new ArrayList<PDAnnotation>();
                page.setAnnotations(annots);
            }
            annots.add(annot);
            if (this._pdfUa != null) {
                this._pdfUa.addLink(anchor, target, annot, page);
            }
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("processLink", e);
        }
    }

    private PDPageXYZDestination createDestination(RenderingContext c, Box box) {
        return PdfBoxBookmarkManager.createBoxDestination(c, this._od.getWriter(), this._od, this._dotsPerPoint, this._root, box);
    }

    public static Rectangle2D createTargetArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform, Box _root, PdfBoxOutputDevice _od) {
        Rectangle bounds = PagedBoxCollector.findAdjustedBoundsForContentBox(c, box);
        if (!c.isInPageMargins()) {
            int shadow = c.getShadowPageNumber();
            Rectangle pageBounds = shadow == -1 ? c.getPage().getDocumentCoordinatesContentBounds(c) : c.getPage().getDocumentCoordinatesContentBoundsForInsertedPage(c, shadow);
            bounds = bounds.intersection(pageBounds);
        }
        Point2D.Float pt = new Point2D.Float(bounds.x, (float)bounds.getMaxY());
        Point2D ptTransformed = transform.transform(pt, null);
        return new Rectangle2D.Float((float)ptTransformed.getX(), _od.normalizeY((float)ptTransformed.getY(), pageHeight), _od.getDeviceLength(bounds.width), _od.getDeviceLength(bounds.height));
    }

    public void processLinkLater(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform) {
        if (box instanceof BlockBox && ((BlockBox)box).getReplacedElement() != null || box.getElement() != null && box.getElement().getNodeName().equals("a")) {
            LinkDetails link = new LinkDetails();
            link.c = (RenderingContext)c.clone();
            link.box = box;
            link.page = page;
            link.pageHeight = pageHeight;
            link.transform = (AffineTransform)transform.clone();
            this._links.add(link);
        }
    }

    public void processLinks(PdfBoxAccessibilityHelper pdfUa) {
        this._pdfUa = pdfUa;
        for (LinkDetails link : this._links) {
            this.processLink(link.c, link.box, link.page, link.pageHeight, link.transform);
        }
    }

    private static class LinkDetails {
        RenderingContext c;
        Box box;
        PDPage page;
        float pageHeight;
        AffineTransform transform;

        private LinkDetails() {
        }
    }
}

