/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxImage;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.swing.NaiveUserAgent;
import com.openhtmltopdf.util.ImageUtil;
import com.openhtmltopdf.util.XRLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import java.util.logging.Level;

public class PdfBoxUserAgent
extends NaiveUserAgent {
    private SharedContext _sharedContext;
    private final PdfBoxOutputDevice _outputDevice;

    public PdfBoxUserAgent(PdfBoxOutputDevice outputDevice) {
        this._outputDevice = outputDevice;
    }

    private byte[] readStream(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream(is.available());
        byte[] buf = new byte[10240];
        while ((i = is.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageResource getImageResource(String uriStr) {
        String uriResolved = this.resolveURI(uriStr);
        if (uriResolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading image at (" + uriStr + ")");
            return new ImageResource(uriStr, null);
        }
        ImageResource resource = (ImageResource)this._imageCache.get(uriResolved);
        if (resource != null && resource.getImage() instanceof PdfBoxImage) {
            PdfBoxImage original = (PdfBoxImage)resource.getImage();
            PdfBoxImage copy = new PdfBoxImage(original.getBytes(), original.getUri(), original.getWidth(), original.getHeight(), original.isJpeg(), original.getXObject());
            return new ImageResource(resource.getImageUri(), copy);
        }
        if (ImageUtil.isEmbeddedBase64Image(uriResolved)) {
            resource = this.loadEmbeddedBase64ImageResource(uriResolved);
            this._outputDevice.realizeImage((PdfBoxImage)resource.getImage());
            this._imageCache.put(uriResolved, resource);
        } else {
            InputStream is = this.openStream(uriResolved);
            if (is != null) {
                try {
                    URI uri = new URI(uriStr);
                    if (uri.getPath() == null || !uri.getPath().toLowerCase(Locale.US).endsWith(".pdf")) {
                        byte[] imgBytes = this.readStream(is);
                        PdfBoxImage fsImage = new PdfBoxImage(imgBytes, uriStr);
                        this.scaleToOutputResolution(fsImage);
                        this._outputDevice.realizeImage(fsImage);
                        resource = new ImageResource(uriResolved, fsImage);
                    }
                    this._imageCache.put(uriResolved, resource);
                }
                catch (Exception e) {
                    XRLog.exception("Can't read image file; unexpected problem for URI '" + uriStr + "'", e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            resource = resource != null ? new ImageResource(resource.getImageUri(), resource.getImage()) : new ImageResource(uriStr, null);
        }
        return resource;
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        try {
            byte[] buffer = ImageUtil.getEmbeddedBase64Image(uri);
            PdfBoxImage fsImage = new PdfBoxImage(buffer, uri);
            this.scaleToOutputResolution(fsImage);
            return new ImageResource(null, fsImage);
        }
        catch (Exception e) {
            XRLog.exception("Can't read XHTML embedded image.", e);
            return new ImageResource(null, null);
        }
    }

    private void scaleToOutputResolution(PdfBoxImage image) {
        float factor = this._sharedContext.getDotsPerPixel();
        if (factor != 1.0f) {
            image.scale((int)((float)image.getWidth() * factor), (int)((float)image.getHeight() * factor));
        }
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void setSharedContext(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
    }
}

