/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteFormatOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FootnoteNodeFormatter
extends NodeRepositoryFormatter<FootnoteRepository, FootnoteBlock, Footnote> {
    public static final DataKey<Map<String, String>> FOOTNOTE_TRANSLATION_MAP = new DataKey("FOOTNOTE_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> FOOTNOTE_UNIQUIFICATION_MAP = new DataKey("FOOTNOTE_UNIQUIFICATION_MAP", new HashMap());
    private final FootnoteFormatOptions options;

    public FootnoteNodeFormatter(DataHolder options) {
        super(options, FOOTNOTE_TRANSLATION_MAP, FOOTNOTE_UNIQUIFICATION_MAP);
        this.options = new FootnoteFormatOptions(options);
    }

    @Override
    public FootnoteRepository getRepository(DataHolder options) {
        return FootnoteExtension.FOOTNOTES.get(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.options.footnotePlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.options.footnoteSort;
    }

    @Override
    public void renderReferenceBlock(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        ((MarkdownWriter)markdown.blankLine()).append("[^");
        markdown.append(this.transformReferenceId(node.getText().toString(), context));
        markdown.append("]: ");
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix("    ");
        context.renderChildren(node);
        markdown.popPrefix();
        markdown.blankLine();
    }

    @Override
    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Footnote>(Footnote.class, this::render), new NodeFormattingHandler<FootnoteBlock>(FootnoteBlock.class, this::render)));
    }

    @Override
    @Nullable
    public Set<Class<?>> getNodeClasses() {
        if (this.options.footnotePlacement.isNoChange() || !this.options.footnoteSort.isUnused()) {
            return null;
        }
        return new HashSet(Arrays.asList(Footnote.class));
    }

    private void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append("[^");
        if (context.isTransformingText()) {
            String referenceId = this.transformReferenceId(node.getText().toString(), context);
            context.nonTranslatingSpan((context1, markdown1) -> {
                MarkdownWriter cfr_ignored_0 = (MarkdownWriter)markdown1.append(referenceId);
            });
        } else {
            markdown.append(node.getText());
        }
        markdown.append("]");
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new FootnoteNodeFormatter(options);
        }
    }
}

