/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.exception;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class LdapInvalidAttributeValueException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapInvalidAttributeValueException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapInvalidAttributeValueException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapInvalidAttributeValueException(ResultCodeEnum resultCode, String message, Throwable cause) {
        super(message, cause);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case CONSTRAINT_VIOLATION: 
            case INVALID_ATTRIBUTE_SYNTAX: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04140_UNACCEPTABLE_RESUT_CODE, (Object[])new Object[]{resultCode}));
    }
}

