/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.Cleaner;
import io.atomix.utils.memory.NativeMemory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CleanerJava8
implements Cleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanerJava8.class);
    private static final long CLEANER_FIELD_OFFSET;
    private static final Method CLEAN_METHOD;

    CleanerJava8() {
    }

    static boolean isSupported() {
        return CLEANER_FIELD_OFFSET != -1L;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return;
        }
        try {
            Object cleaner = NativeMemory.UNSAFE.getObject(buffer, CLEANER_FIELD_OFFSET);
            if (cleaner != null) {
                CLEAN_METHOD.invoke(cleaner, new Object[0]);
            }
        }
        catch (Throwable cause) {
            NativeMemory.UNSAFE.throwException(cause);
        }
    }

    static {
        long fieldOffset = -1L;
        Method clean = null;
        Throwable error = null;
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            Field cleanerField = direct.getClass().getDeclaredField("cleaner");
            fieldOffset = NativeMemory.UNSAFE.objectFieldOffset(cleanerField);
            Object cleaner = NativeMemory.UNSAFE.getObject(direct, fieldOffset);
            clean = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
            clean.invoke(cleaner, new Object[0]);
        }
        catch (Throwable t) {
            fieldOffset = -1L;
            clean = null;
            error = t;
        }
        if (error == null) {
            LOGGER.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            LOGGER.debug("java.nio.ByteBuffer.cleaner(): unavailable", error);
        }
        CLEANER_FIELD_OFFSET = fieldOffset;
        CLEAN_METHOD = clean;
    }
}

