/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.Cleaner;
import io.atomix.utils.memory.NativeMemory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CleanerJava9
implements Cleaner {
    private static final Logger LOGGER;
    private static final Method INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        try {
            INVOKE_CLEANER.invoke((Object)NativeMemory.UNSAFE, buffer);
        }
        catch (Throwable cause) {
            NativeMemory.UNSAFE.throwException(cause);
        }
    }

    static {
        Throwable error;
        Method method;
        Object maybeInvokeMethod;
        LOGGER = LoggerFactory.getLogger(CleanerJava9.class);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1);
        try {
            Method m = NativeMemory.UNSAFE.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
            m.invoke((Object)NativeMemory.UNSAFE, buffer);
            maybeInvokeMethod = m;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            maybeInvokeMethod = e;
        }
        if (maybeInvokeMethod instanceof Throwable) {
            method = null;
            error = (Throwable)maybeInvokeMethod;
        } else {
            method = (Method)maybeInvokeMethod;
            error = null;
        }
        if (error == null) {
            LOGGER.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            LOGGER.debug("java.nio.ByteBuffer.cleaner(): unavailable", error);
        }
        INVOKE_CLEANER = method;
    }
}

