/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.TaggedFieldSerializerConfig;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;
    private boolean[] annexed;
    private static final Comparator<FieldSerializer.CachedField> TAGGED_VALUE_COMPARATOR = new Comparator<FieldSerializer.CachedField>(){

        @Override
        public int compare(FieldSerializer.CachedField o1, FieldSerializer.CachedField o2) {
            return o1.getField().getAnnotation(Tag.class).value() - o2.getField().getAnnotation(Tag.class).value();
        }
    };

    public TaggedFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type, null, kryo.getTaggedFieldSerializerConfig().clone());
    }

    public void setSkipUnknownTags(boolean skipUnknownTags) {
        ((TaggedFieldSerializerConfig)this.config).setSkipUnknownTags(skipUnknownTags);
        this.rebuildCachedFields();
    }

    public boolean isSkipUnknownTags() {
        return ((TaggedFieldSerializerConfig)this.config).isSkipUnknownTags();
    }

    @Override
    protected void initializeCachedFields() {
        Field field;
        int i;
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fields.length;
        for (i = 0; i < n; ++i) {
            field = fields[i].getField();
            if (field.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Ignoring field without tag: " + fields[i]));
            }
            super.removeField(fields[i]);
        }
        fields = this.getFields();
        this.tags = new int[fields.length];
        this.deprecated = new boolean[fields.length];
        this.annexed = new boolean[fields.length];
        this.writeFieldCount = fields.length;
        Arrays.sort(fields, TAGGED_VALUE_COMPARATOR);
        n = fields.length;
        for (i = 0; i < n; ++i) {
            field = fields[i].getField();
            this.tags[i] = field.getAnnotation(Tag.class).value();
            if (i > 0 && this.tags[i] == this.tags[i - 1]) {
                throw new KryoException(String.format("The fields [%s] and [%s] both have a Tag value of %d.", field, fields[i - 1].getField(), this.tags[i]));
            }
            if (field.getAnnotation(Deprecated.class) != null) {
                this.deprecated[i] = true;
                --this.writeFieldCount;
            }
            if (!field.getAnnotation(Tag.class).annexed()) continue;
            this.annexed[i] = true;
        }
        this.removedFields.clear();
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        OutputChunked outputChunked = null;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (this.deprecated[i]) continue;
            output.writeVarInt(this.tags[i], true);
            if (this.annexed[i]) {
                if (outputChunked == null) {
                    outputChunked = new OutputChunked(output, 1024);
                }
                fields[i].write(outputChunked, object);
                outputChunked.endChunks();
                continue;
            }
            fields[i].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        int fieldCount = input.readVarInt(true);
        int[] tags = this.tags;
        InputChunked inputChunked = null;
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fieldCount;
        for (int i = 0; i < n; ++i) {
            int tag = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            boolean isAnnexed = false;
            int nn = tags.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (tags[ii] != tag) continue;
                cachedField = fields[ii];
                isAnnexed = this.annexed[ii];
                break;
            }
            if (cachedField == null) {
                if (this.isSkipUnknownTags()) {
                    if (inputChunked == null) {
                        inputChunked = new InputChunked(input, 1024);
                    }
                    inputChunked.nextChunks();
                    if (!Log.TRACE) continue;
                    Log.trace((String)String.format("Unknown field tag: %d (%s) encountered. Assuming a future annexed tag with chunked encoding and skipping.", tag, this.getType().getName()));
                    continue;
                }
                throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
            }
            if (isAnnexed) {
                if (inputChunked == null) {
                    inputChunked = new InputChunked(input, 1024);
                }
                cachedField.read(inputChunked, object);
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(input, object);
        }
        return object;
    }

    @Deprecated
    public void setIgnoreUnknownTags(boolean ignoreUnknownTags) {
    }

    @Deprecated
    public boolean isIgnoreUnkownTags() {
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();

        public boolean annexed() default false;
    }
}

