/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class BarRenderer {
    private final ISkinParam skinParam;
    private final double plotWidth;
    private final double plotHeight;
    private final int categoryCount;
    private final ChartAxis axis;
    private final boolean horizontal;

    public BarRenderer(ISkinParam skinParam, double plotWidth, double plotHeight, int categoryCount, ChartAxis axis) {
        this(skinParam, plotWidth, plotHeight, categoryCount, axis, false);
    }

    public BarRenderer(ISkinParam skinParam, double plotWidth, double plotHeight, int categoryCount, ChartAxis axis, boolean horizontal) {
        this.skinParam = skinParam;
        this.plotWidth = plotWidth;
        this.plotHeight = plotHeight;
        this.categoryCount = categoryCount;
        this.axis = axis;
        this.horizontal = horizontal;
    }

    private StyleSignatureBasic getBarStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.bar);
    }

    private Style getBarStyle(ChartSeries series) {
        StyleSignatureBasic signature = this.getBarStyleSignature();
        if (series != null && series.getStereotype() != null) {
            return signature.withTOBECHANGED(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    public void draw(UGraphic ug, ChartSeries series, HColor color) {
        if (this.horizontal) {
            this.drawHorizontal(ug, series, color);
        } else {
            this.drawVertical(ug, series, color);
        }
    }

    private void drawVertical(UGraphic ug, ChartSeries series, HColor color) {
        if (this.categoryCount == 0) {
            return;
        }
        List<Double> values = series.getValues();
        double categoryWidth = this.plotWidth / (double)this.categoryCount;
        StringBounder stringBounder = ug.getStringBounder();
        Style barStyle = this.getBarStyle(series);
        double barWidthRatio = 0.6;
        try {
            Double styleBarWidth = barStyle.value(PName.BarWidth).asDouble();
            if (styleBarWidth != null && styleBarWidth > 0.0 && styleBarWidth <= 1.0) {
                barWidthRatio = styleBarWidth;
            }
        }
        catch (Exception styleBarWidth) {
            // empty catch block
        }
        double barWidth = categoryWidth * barWidthRatio;
        double barOffset = (categoryWidth - barWidth) / 2.0;
        HColor lineColor = barStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        if (lineColor == null) {
            lineColor = color;
        }
        double lineThickness = barStyle.value(PName.LineThickness).asDouble();
        UStroke stroke = UStroke.withThickness(lineThickness);
        for (int i = 0; i < Math.min(values.size(), this.categoryCount); ++i) {
            double barHeight;
            double y;
            double value = values.get(i);
            double x = (double)i * categoryWidth + barOffset;
            double zeroY = this.plotHeight - (0.0 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            double valueY = this.plotHeight - (value - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            if (value < 0.0) {
                y = zeroY;
                barHeight = valueY - zeroY;
            } else {
                y = valueY;
                barHeight = zeroY - valueY;
            }
            URectangle rect = URectangle.build(barWidth, barHeight);
            ug.apply(lineColor).apply(stroke).apply(color.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(y))).draw(rect);
            if (!series.isShowLabels()) continue;
            double labelY = value < 0.0 ? y + barHeight + 5.0 : y - 5.0;
            this.drawLabel(ug, value, x + barWidth / 2.0, labelY, stringBounder);
        }
    }

    private void drawHorizontal(UGraphic ug, ChartSeries series, HColor color) {
        if (this.categoryCount == 0) {
            return;
        }
        List<Double> values = series.getValues();
        double categoryHeight = this.plotHeight / (double)this.categoryCount;
        Style barStyle = this.getBarStyle(series);
        double barWidthRatio = 0.6;
        try {
            Double styleBarWidth = barStyle.value(PName.BarWidth).asDouble();
            if (styleBarWidth != null && styleBarWidth > 0.0 && styleBarWidth <= 1.0) {
                barWidthRatio = styleBarWidth;
            }
        }
        catch (Exception styleBarWidth) {
            // empty catch block
        }
        double barHeight = categoryHeight * barWidthRatio;
        double barOffset = (categoryHeight - barHeight) / 2.0;
        HColor lineColor = barStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        if (lineColor == null) {
            lineColor = color;
        }
        double lineThickness = barStyle.value(PName.LineThickness).asDouble();
        UStroke stroke = UStroke.withThickness(lineThickness);
        for (int i = 0; i < Math.min(values.size(), this.categoryCount); ++i) {
            double value = values.get(i);
            double y = (double)i * categoryHeight + barOffset;
            double barWidth = Math.abs((value - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotWidth);
            double x = 0.0;
            URectangle rect = URectangle.build(barWidth, barHeight);
            ug.apply(lineColor).apply(stroke).apply(color.bg()).apply(UTranslate.dx(0.0).compose(UTranslate.dy(y))).draw(rect);
            if (!series.isShowLabels()) continue;
            this.drawLabelHorizontal(ug, value, barWidth + 5.0, y + barHeight / 2.0);
        }
    }

    public void drawGrouped(UGraphic ug, List<ChartSeries> barSeries, List<HColor> colors) {
        if (this.categoryCount == 0 || barSeries.isEmpty()) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double categoryWidth = this.plotWidth / (double)this.categoryCount;
        int seriesCount = barSeries.size();
        double groupWidth = categoryWidth * 0.8;
        double barWidth = groupWidth / (double)seriesCount;
        double groupOffset = (categoryWidth - groupWidth) / 2.0;
        Style barStyle = this.getBarStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        double lineThickness = barStyle.value(PName.LineThickness).asDouble();
        UStroke stroke = UStroke.withThickness(lineThickness);
        for (int categoryIndex = 0; categoryIndex < this.categoryCount; ++categoryIndex) {
            for (int seriesIndex = 0; seriesIndex < seriesCount; ++seriesIndex) {
                double barHeight;
                double y;
                ChartSeries series = barSeries.get(seriesIndex);
                HColor color = colors.get(seriesIndex);
                List<Double> values = series.getValues();
                if (categoryIndex >= values.size()) continue;
                double value = values.get(categoryIndex);
                double x = (double)categoryIndex * categoryWidth + groupOffset + (double)seriesIndex * barWidth;
                double zeroY = this.plotHeight - (0.0 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                double valueY = this.plotHeight - (value - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                if (value < 0.0) {
                    y = zeroY;
                    barHeight = valueY - zeroY;
                } else {
                    y = valueY;
                    barHeight = zeroY - valueY;
                }
                HColor lineColor = barStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
                if (lineColor == null) {
                    lineColor = color;
                }
                URectangle rect = URectangle.build(barWidth, barHeight);
                ug.apply(lineColor).apply(stroke).apply(color.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(y))).draw(rect);
                if (!series.isShowLabels()) continue;
                double labelY = value < 0.0 ? y + barHeight + 5.0 : y - 5.0;
                this.drawLabel(ug, value, x + barWidth / 2.0, labelY, stringBounder);
            }
        }
    }

    public void drawStacked(UGraphic ug, List<ChartSeries> barSeries, List<HColor> colors) {
        if (this.categoryCount == 0 || barSeries.isEmpty()) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double categoryWidth = this.plotWidth / (double)this.categoryCount;
        Style barStyle = this.getBarStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        double barWidthRatio = 0.6;
        try {
            Double styleBarWidth = barStyle.value(PName.BarWidth).asDouble();
            if (styleBarWidth != null && styleBarWidth > 0.0 && styleBarWidth <= 1.0) {
                barWidthRatio = styleBarWidth;
            }
        }
        catch (Exception styleBarWidth) {
            // empty catch block
        }
        double barWidth = categoryWidth * barWidthRatio;
        double barOffset = (categoryWidth - barWidth) / 2.0;
        HashMap cumulativeHeights = new HashMap();
        double lineThickness = barStyle.value(PName.LineThickness).asDouble();
        UStroke stroke = UStroke.withThickness(lineThickness);
        for (int categoryIndex = 0; categoryIndex < this.categoryCount; ++categoryIndex) {
            double zeroY;
            double cumulativePositiveY = zeroY = this.plotHeight - (0.0 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            double cumulativeNegativeY = zeroY;
            for (int seriesIndex = 0; seriesIndex < barSeries.size(); ++seriesIndex) {
                double y;
                double barHeight;
                ChartSeries series = barSeries.get(seriesIndex);
                HColor color = colors.get(seriesIndex);
                List<Double> values = series.getValues();
                if (categoryIndex >= values.size()) continue;
                double value = values.get(categoryIndex);
                double x = (double)categoryIndex * categoryWidth + barOffset;
                double valueY = this.plotHeight - (value - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                if (value < 0.0) {
                    barHeight = valueY - zeroY;
                    y = cumulativeNegativeY;
                    cumulativeNegativeY += barHeight;
                } else {
                    barHeight = zeroY - valueY;
                    y = cumulativePositiveY -= barHeight;
                }
                HColor lineColor = barStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
                if (lineColor == null) {
                    lineColor = color;
                }
                URectangle rect = URectangle.build(barWidth, barHeight);
                ug.apply(lineColor).apply(stroke).apply(color.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(y))).draw(rect);
                if (!series.isShowLabels()) continue;
                double labelY = value < 0.0 ? y + barHeight + 5.0 : y - 5.0;
                this.drawLabel(ug, value, x + barWidth / 2.0, labelY, stringBounder);
            }
        }
    }

    private void drawLabel(UGraphic ug, double value, double x, double y, StringBounder stringBounder) {
        try {
            String label = this.formatValue(value);
            UFont font = UFont.sansSerif(10).bold();
            HColor labelColor = this.skinParam.getIHtmlColorSet().getColor("#000000");
            FontConfiguration fontConfig = FontConfiguration.create(font, labelColor, labelColor, null);
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
            XDimension2D textDim = textBlock.calculateDimension(stringBounder);
            double labelX = x - textDim.getWidth() / 2.0;
            double labelY = y - textDim.getHeight() - 2.0;
            textBlock.drawU(ug.apply(UTranslate.dx(labelX).compose(UTranslate.dy(labelY))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawLabelHorizontal(UGraphic ug, double value, double x, double y) {
        try {
            String label = this.formatValue(value);
            UFont font = UFont.sansSerif(10).bold();
            HColor labelColor = this.skinParam.getIHtmlColorSet().getColor("#000000");
            FontConfiguration fontConfig = FontConfiguration.create(font, labelColor, labelColor, null);
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.LEFT, this.skinParam);
            XDimension2D textDim = textBlock.calculateDimension(ug.getStringBounder());
            double labelY = y - textDim.getHeight() / 2.0;
            textBlock.drawU(ug.apply(UTranslate.dx(x).compose(UTranslate.dy(labelY))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatValue(double value) {
        if (Math.abs(value) < 0.01 && value != 0.0) {
            return String.format("%.2e", value);
        }
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format("%.2f", value);
    }
}

