/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.cucadiagram.Elected;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.AbstractPlacementStrategy;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.PlacementStrategyVisibility;
import net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2Center;
import net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2Right;
import net.sourceforge.plantuml.klimt.geom.ULayoutGroup;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockLineBefore;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.TextBlockWithUrl;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.CharHidder;

public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final ISkinParam skinParam;
    private final Display members;
    private final HorizontalAlignment align;
    private final List<EmbeddedDiagram> embeddeds = new ArrayList<EmbeddedDiagram>();
    private final Entity leaf;
    private final Style style;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(this.style.value(PName.LineThickness).asDouble(), TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(Display members, ISkinParam skinParam, Entity leaf, Style style) {
        this(members, skinParam, HorizontalAlignment.LEFT, leaf, style);
    }

    public MethodsOrFieldsArea(Display members, ISkinParam skinParam, HorizontalAlignment align, Entity leaf, Style style) {
        this.style = style;
        this.leaf = leaf;
        this.align = align;
        this.skinParam = skinParam;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            CharSequence cs = (CharSequence)it.next();
            String type = EmbeddedDiagram.getEmbeddedType(StringUtils.trinNoTrace(cs));
            if (type != null) {
                this.embeddeds.add(EmbeddedDiagram.createAndSkip(type, it, skinParam));
                continue;
            }
            result.add(cs);
        }
        this.members = Display.create(result);
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (CharSequence cs : this.members) {
            Member m;
            if (!(cs instanceof Member) || (m = (Member)cs).getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim1 = this.calculateDimensionOnlyMembers(stringBounder);
        double x = dim1.getWidth();
        double y = dim1.getHeight();
        for (EmbeddedDiagram embedded : this.embeddeds) {
            XDimension2D dim = embedded.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new XDimension2D(x, y);
    }

    private XDimension2D calculateDimensionOnlyMembers(StringBounder stringBounder) {
        double smallIcon = 0.0;
        if (this.hasSmallIcon()) {
            smallIcon = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double x = 0.0;
        double y = 0.0;
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            XDimension2D dim = bloc.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
            if (!stringBounder.matchesProperty("TIKZ") || dim.getHeight() != 10.0) continue;
            y += 1.0;
        }
        return new XDimension2D(x += smallIcon, y);
    }

    private Collection<String> sortBySize(Collection<String> all) {
        ArrayList<String> result = new ArrayList<String>(all);
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int diff = s2.length() - s1.length();
                if (diff != 0) {
                    return diff;
                }
                return s1.compareTo(s2);
            }
        });
        return result;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports ports = new Ports();
        double y = 0.0;
        Collection<String> shortNames = this.sortBySize(this.leaf.getPortShortNames());
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            XDimension2D dim = bloc.calculateDimension(stringBounder);
            Elected elected = this.getElected(this.convert(cs), shortNames);
            if (elected != null) {
                ports.add(elected.getShortName(), elected.getScore(), y, dim.getHeight());
            }
            y += dim.getHeight();
        }
        return ports;
    }

    private String convert(CharSequence cs) {
        if (cs instanceof Member) {
            return ((Member)cs).getDisplay(false);
        }
        return cs.toString();
    }

    public Elected getElected(String cs, Collection<String> shortNames) {
        for (String shortName : shortNames) {
            int score = this.getScore(cs, shortName);
            if (score <= 0) continue;
            return new Elected(shortName, score);
        }
        return null;
    }

    private int getScore(String cs, String shortName) {
        if (cs.matches(".*\\b" + shortName + "\\b.*")) {
            return 100;
        }
        if (cs.contains(shortName)) {
            return 50;
        }
        return 0;
    }

    private TextBlock createTextBlock(CharSequence cs) {
        FontConfiguration config = FontConfiguration.create(this.skinParam, this.style, this.leaf.getColors());
        if (cs instanceof Member) {
            Member m = (Member)cs;
            boolean withVisibilityChar = this.skinParam.classAttributeIconSize() == 0;
            String s = m.getDisplay(withVisibilityChar);
            if (withVisibilityChar && s.startsWith("#")) {
                s = CharHidder.addTileAtBegin(s);
            }
            if (m.isAbstract()) {
                config = config.italic();
            }
            if (m.isStatic()) {
                config = config.underline();
            }
            TextBlock bloc = Display.getWithNewlines(this.skinParam.getPragma(), s).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.style.wrapWidth());
            bloc = MethodsOrFieldsArea.fullInnerPosition(bloc, m);
            return new TextBlockTracer(m, bloc);
        }
        return Display.getWithNewlines(this.skinParam.getPragma(), cs.toString()).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.style.wrapWidth());
    }

    private static TextBlock fullInnerPosition(final TextBlock bloc, final Member display) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                bloc.drawU(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return bloc.calculateDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return bloc.getMinMax(stringBounder);
            }

            @Override
            public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
                if (display.toString().equals(member.toString())) {
                    XDimension2D dim = this.calculateDimension(stringBounder);
                    return new XRectangle2D(0.0, 0.0, dim.getWidth(), dim.getHeight());
                }
                return null;
            }

            @Override
            public MagneticBorder getMagneticBorder() {
                return bloc.getMagneticBorder();
            }

            @Override
            public HColor getBackcolor() {
                return bloc.getBackcolor();
            }
        };
    }

    private TextBlock getUBlock(VisibilityModifier modifier, Url url) {
        if (modifier == null) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                }

                @Override
                public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
                    return null;
                }

                @Override
                public XDimension2D calculateDimension(StringBounder stringBounder) {
                    return new XDimension2D(1.0, 1.0);
                }
            };
        }
        Style style = modifier.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        boolean isField = modifier.isField();
        HColor backColor = isField ? null : style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        TextBlock uBlock = modifier.getUBlock(this.skinParam.classAttributeIconSize(), borderColor, backColor, url != null);
        return TextBlockWithUrl.withUrl(uBlock, url);
    }

    public boolean contains(String member) {
        for (CharSequence cs : this.members) {
            Member att = (Member)cs;
            if (!att.getDisplay(false).startsWith(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        ULayoutGroup group = this.getLayout(stringBounder);
        XDimension2D dim = this.calculateDimension(stringBounder);
        return group.getInnerPosition(member, dim.getWidth(), dim.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup group;
        if (this.hasSmallIcon()) {
            group = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                Member att = (Member)cs;
                VisibilityModifier modifier = att.getVisibilityModifier();
                group.add(this.getUBlock(modifier, att.getUrl()));
                group.add(bloc);
            }
        } else {
            AbstractPlacementStrategy placementStrategy = this.align == HorizontalAlignment.LEFT ? new PlacementStrategyY1Y2Left(stringBounder) : (this.align == HorizontalAlignment.CENTER ? new PlacementStrategyY1Y2Center(stringBounder) : new PlacementStrategyY1Y2Right(stringBounder));
            group = new ULayoutGroup(placementStrategy);
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                group.add(bloc);
            }
        }
        return group;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ULayoutGroup group = this.getLayout(stringBounder);
        XDimension2D dim = this.calculateDimensionOnlyMembers(stringBounder);
        group.drawU(ug, dim.getWidth(), dim.getHeight());
        ug = ug.apply(UTranslate.dy(dim.getHeight()));
        for (EmbeddedDiagram embedded : this.embeddeds) {
            embedded.drawU(ug);
            ug = ug.apply(UTranslate.dy(embedded.calculateDimension(stringBounder).getHeight()));
        }
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member m, TextBlock bloc) {
            this.bloc = bloc;
            this.url = m.getUrl();
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.url != null) {
                ug.startUrl(this.url);
            }
            this.bloc.drawU(ug);
            if (this.url != null) {
                ug.closeUrl();
            }
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            XDimension2D dim = this.bloc.calculateDimension(stringBounder);
            return dim;
        }

        @Override
        public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
            return this.bloc.getInnerPosition(member, stringBounder);
        }
    }
}

