/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterElseIf;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterIf;
import net.sourceforge.plantuml.tim.EaterIfdef;
import net.sourceforge.plantuml.tim.EaterIfndef;
import net.sourceforge.plantuml.tim.ExecutionContextIf;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorIf
extends AbstractCodeIterator {
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorIf(CodeIterator source, TContext context, TMemory memory, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.logs = logs;
    }

    @Override
    public StringLocated peek() throws EaterException {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            TLineType type = result.getType();
            if (this.isConditionalDirective(type)) {
                this.logs.add(result);
                this.processConditionalDirective(result, type);
                this.next();
                continue;
            }
            if (!this.shouldSkipLine()) break;
            this.logs.add(result);
            this.next();
        }
        return result;
    }

    private boolean isConditionalDirective(TLineType type) {
        return type == TLineType.IF || type == TLineType.IFDEF || type == TLineType.IFNDEF || type == TLineType.ELSE || type == TLineType.ELSEIF || type == TLineType.ENDIF;
    }

    private void processConditionalDirective(StringLocated line, TLineType type) throws EaterException {
        switch (type) {
            case IF: {
                this.executeIf(line);
                break;
            }
            case IFDEF: {
                this.executeIfdef(line);
                break;
            }
            case IFNDEF: {
                this.executeIfndef(line);
                break;
            }
            case ELSE: {
                this.executeElse(line);
                break;
            }
            case ELSEIF: {
                this.executeElseIf(line);
                break;
            }
            case ENDIF: {
                this.executeEndif(line);
            }
        }
    }

    private boolean shouldSkipLine() throws EaterException {
        return this.memory.peekIf() != null && !this.areAllIfOk();
    }

    private boolean areAllIfOk() throws EaterException {
        return this.memory.areAllIfOk(this.context, this.memory);
    }

    private void executeIf(StringLocated s) throws EaterException {
        boolean isTrue;
        if (this.areAllIfOk()) {
            EaterIf condition = new EaterIf(s);
            condition.analyze(this.context, this.memory);
            isTrue = condition.isTrue();
        } else {
            isTrue = false;
        }
        this.memory.addIf(ExecutionContextIf.fromValue(isTrue));
    }

    private void executeIfdef(StringLocated s) throws EaterException {
        EaterIfdef condition = new EaterIfdef(s);
        condition.analyze(this.context, this.memory);
        boolean isTrue = condition.isTrue(this.context, this.memory);
        this.memory.addIf(ExecutionContextIf.fromValue(isTrue));
    }

    private void executeIfndef(StringLocated s) throws EaterException {
        EaterIfndef condition = new EaterIfndef(s);
        condition.analyze(this.context, this.memory);
        boolean isTrue = condition.isTrue(this.context, this.memory);
        this.memory.addIf(ExecutionContextIf.fromValue(isTrue));
    }

    private void executeElseIf(StringLocated s) throws EaterException {
        ExecutionContextIf poll = this.getRequiredIfContext(s, "elseif");
        poll.enteringElseIf();
        if (!poll.hasBeenBurn()) {
            EaterElseIf condition = new EaterElseIf(s);
            condition.analyze(this.context, this.memory);
            if (condition.isTrue()) {
                poll.nowInSomeElseIf();
            }
        }
    }

    private void executeElse(StringLocated s) throws EaterException {
        ExecutionContextIf poll = this.getRequiredIfContext(s, "else");
        poll.nowInElse();
    }

    private void executeEndif(StringLocated s) throws EaterException {
        ExecutionContextIf poll = this.memory.pollIf();
        if (poll == null) {
            throw new EaterException("No if related to this endif", s);
        }
    }

    private ExecutionContextIf getRequiredIfContext(StringLocated s, String directive) throws EaterException {
        ExecutionContextIf poll = this.memory.peekIf();
        if (poll == null) {
            throw new EaterException("No if related to this " + directive, s);
        }
        return poll;
    }
}

