/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.jsondiagram.JsonDiagram;
import net.sourceforge.plantuml.jsondiagram.StyleExtractor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.yaml.Highlighted;
import net.sourceforge.plantuml.yaml.parser.MonomorphToJson;
import net.sourceforge.plantuml.yaml.parser.YamlParser;

public class YamlDiagramFactory
extends PSystemAbstractFactory {
    public YamlDiagramFactory() {
        super(DiagramType.YAML);
    }

    @Override
    public Diagram createSystem(PathSystem pathSystem, UmlSource source, Previous previous, PreprocessingArtifact preprocessing) {
        ArrayList<Highlighted> highlighted = new ArrayList<Highlighted>();
        JsonValue yaml = null;
        StyleExtractor styleExtractor = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            styleExtractor = new StyleExtractor(source.iterator2());
            Iterator<String> it = styleExtractor.getIterator();
            it.next();
            while (true) {
                String line = it.next();
                if (!it.hasNext()) break;
                if (Highlighted.matchesDefinition(line)) {
                    highlighted.add(Highlighted.build(line));
                    continue;
                }
                list.add(line);
            }
            yaml = MonomorphToJson.convert(new YamlParser().parse(list));
        }
        catch (Exception e) {
            Logme.error(e);
        }
        JsonDiagram result = new JsonDiagram(source, UmlDiagramType.YAML, yaml, highlighted, styleExtractor, preprocessing);
        if (styleExtractor != null) {
            try {
                styleExtractor.applyStyles(result.getSkinParam());
            }
            catch (StyleParsingException e) {
                Logme.error(e);
            }
            String title = styleExtractor.getTitle();
            if (title != null) {
                result.setTitle(DisplayPositioned.single(Display.getWithNewlines(result.getPragma(), title), HorizontalAlignment.CENTER, VerticalAlignment.CENTER));
            }
        }
        return result;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.YAML;
    }
}

