/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class EventSupport {
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;
    protected AbstractNode node;

    public EventSupport(AbstractNode abstractNode) {
        this.node = abstractNode;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        this.addEventListenerNS(null, string, eventListener, bl, null);
    }

    public void addEventListenerNS(String string, String string2, EventListener eventListener, boolean bl, Object object) {
        HashTable hashTable;
        if (bl) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable();
            }
            hashTable = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable();
            }
            hashTable = this.bubblingListeners;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string2);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashTable.put(string2, eventListenerList);
        }
        eventListenerList.addListener(string, object, eventListener);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        this.removeEventListenerNS(null, string, eventListener, bl);
    }

    public void removeEventListenerNS(String string, String string2, EventListener eventListener, boolean bl) {
        HashTable hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string2);
        if (eventListenerList != null) {
            eventListenerList.removeListener(string, eventListener);
            if (eventListenerList.size() == 0) {
                hashTable.remove(string2);
            }
        }
    }

    public void moveEventListeners(EventSupport eventSupport) {
        eventSupport.capturingListeners = this.capturingListeners;
        eventSupport.bubblingListeners = this.bubblingListeners;
        this.capturingListeners = null;
        this.bubblingListeners = null;
    }

    public boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) throws EventException {
        NodeEventTarget nodeEventTarget2;
        int n;
        if (event == null) {
            return false;
        }
        if (!(event instanceof AbstractEvent)) {
            throw this.createEventException((short)9, "unsupported.event", new Object[0]);
        }
        AbstractEvent abstractEvent = (AbstractEvent)event;
        String string = abstractEvent.getType();
        if (string == null || string.length() == 0) {
            throw this.createEventException((short)0, "unspecified.event", new Object[0]);
        }
        abstractEvent.setTarget(nodeEventTarget);
        abstractEvent.stopPropagation(false);
        abstractEvent.stopImmediatePropagation(false);
        abstractEvent.preventDefault(false);
        NodeEventTarget[] nodeEventTargetArray = this.getAncestors(nodeEventTarget);
        abstractEvent.setEventPhase((short)1);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (n = 0; n < nodeEventTargetArray.length; ++n) {
            nodeEventTarget2 = nodeEventTargetArray[n];
            abstractEvent.setCurrentTarget(nodeEventTarget2);
            this.fireEventListeners(nodeEventTarget2, abstractEvent, true, hashSet, hashSet2);
            hashSet.addAll(hashSet2);
            hashSet2.clear();
        }
        abstractEvent.setEventPhase((short)2);
        abstractEvent.setCurrentTarget(nodeEventTarget);
        this.fireEventListeners(nodeEventTarget, abstractEvent, false, hashSet, hashSet2);
        hashSet.addAll(hashSet2);
        hashSet2.clear();
        if (abstractEvent.getBubbles()) {
            abstractEvent.setEventPhase((short)3);
            for (n = nodeEventTargetArray.length - 1; n >= 0; --n) {
                nodeEventTarget2 = nodeEventTargetArray[n];
                abstractEvent.setCurrentTarget(nodeEventTarget2);
                this.fireEventListeners(nodeEventTarget2, abstractEvent, false, hashSet, hashSet2);
                hashSet.addAll(hashSet2);
                hashSet2.clear();
            }
        }
        if (!abstractEvent.getDefaultPrevented()) {
            this.runDefaultActions(abstractEvent);
        }
        return abstractEvent.getDefaultPrevented();
    }

    protected void runDefaultActions(AbstractEvent abstractEvent) {
        List list = abstractEvent.getDefaultActions();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                runnable.run();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, EventListenerList.Entry[] entryArray, HashSet hashSet, HashSet hashSet2) {
        if (entryArray == null) {
            return;
        }
        String string = abstractEvent.getNamespaceURI();
        for (int i = 0; i < entryArray.length; ++i) {
            try {
                String string2 = entryArray[i].getNamespaceURI();
                if (string2 != null && string != null && !string2.equals(string)) continue;
                Object object = entryArray[i].getGroup();
                if (hashSet != null && hashSet.contains(object)) continue;
                entryArray[i].getListener().handleEvent(abstractEvent);
                if (abstractEvent.getStopImmediatePropagation()) {
                    if (hashSet != null) {
                        hashSet.add(object);
                    }
                    abstractEvent.stopImmediatePropagation(false);
                    continue;
                }
                if (!abstractEvent.getStopPropagation()) continue;
                if (hashSet2 != null) {
                    hashSet2.add(object);
                }
                abstractEvent.stopPropagation(false);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, boolean bl, HashSet hashSet, HashSet hashSet2) {
        String string = abstractEvent.getType();
        EventSupport eventSupport = nodeEventTarget.getEventSupport();
        if (eventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = eventSupport.getEventListeners(string, bl);
        if (eventListenerList == null) {
            return;
        }
        EventListenerList.Entry[] entryArray = eventListenerList.getEventListeners();
        this.fireEventListeners(nodeEventTarget, abstractEvent, entryArray, hashSet, hashSet2);
    }

    protected NodeEventTarget[] getAncestors(NodeEventTarget object) {
        object = object.getParentNodeEventTarget();
        int n = 0;
        NodeEventTarget[] nodeEventTargetArray = object;
        while (nodeEventTargetArray != null) {
            nodeEventTargetArray = nodeEventTargetArray.getParentNodeEventTarget();
            ++n;
        }
        nodeEventTargetArray = new NodeEventTarget[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            nodeEventTargetArray[n2] = object;
            --n2;
            object = object.getParentNodeEventTarget();
        }
        return nodeEventTargetArray;
    }

    public boolean hasEventListenerNS(String string, String string2) {
        EventListenerList eventListenerList;
        if (this.capturingListeners != null && (eventListenerList = (EventListenerList)this.capturingListeners.get(string2)) != null && eventListenerList.hasEventListener(string)) {
            return true;
        }
        if (this.bubblingListeners != null && (eventListenerList = (EventListenerList)this.capturingListeners.get(string2)) != null) {
            return eventListenerList.hasEventListener(string);
        }
        return false;
    }

    public EventListenerList getEventListeners(String string, boolean bl) {
        HashTable hashTable;
        HashTable hashTable2 = hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return null;
        }
        return (EventListenerList)hashTable.get(string);
    }

    protected EventException createEventException(short s, String string, Object[] objectArray) {
        try {
            AbstractDocument abstractDocument = (AbstractDocument)this.node.getOwnerDocument();
            return new EventException(s, abstractDocument.formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new EventException(s, string);
        }
    }

    protected void setTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setTarget(nodeEventTarget);
    }

    protected void stopPropagation(AbstractEvent abstractEvent, boolean bl) {
        abstractEvent.stopPropagation(bl);
    }

    protected void stopImmediatePropagation(AbstractEvent abstractEvent, boolean bl) {
        abstractEvent.stopImmediatePropagation(bl);
    }

    protected void preventDefault(AbstractEvent abstractEvent, boolean bl) {
        abstractEvent.preventDefault(bl);
    }

    protected void setCurrentTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setCurrentTarget(nodeEventTarget);
    }

    protected void setEventPhase(AbstractEvent abstractEvent, short s) {
        abstractEvent.setEventPhase(s);
    }

    public static Event getUltimateOriginalEvent(Event event) {
        AbstractEvent abstractEvent;
        AbstractEvent abstractEvent2 = (AbstractEvent)event;
        while ((abstractEvent = (AbstractEvent)abstractEvent2.getOriginalEvent()) != null) {
            abstractEvent2 = abstractEvent;
        }
        return abstractEvent2;
    }
}

