package String::HexConvert; ## Converts ascii strings to hex and reverse




use strict;

use vars qw(@ISA @EXPORT %EXPORT_TAGS $VERSION);
use Exporter; 

our $VERSION='0.02';


@ISA = qw(Exporter);

%EXPORT_TAGS = ( all => [qw(
                      hex_to_ascii
                      ascii_to_hex
                )] ); 

Exporter::export_ok_tags('all'); 


# It is a wrapper around pack and unpack of perl to convert a string of hex digits
# to ascii and other way around.
#
# SYNOPSIS
# ========
# 
#  use String::HexConvert ':all';
#
#  print ascii_to_hex("hello world"); # writes: 68656c6c6f20776f726c64
#
#  print hex_to_ascii("68656c6c6f20776f726c64"); # writes: hello world
# 
#  
#
# SEE ALSO
# ========
# pack, unpack, L<Data::Translate>
#
# LICENSE
# =======   
# You can redistribute it and/or modify it under the conditions of LGPL.
# 
# WHY?
# ====
# In know the comments like "is that realy needed?". IMHO yes, because I forget the 
# exact syntax and possibilities of pack and unpack but hex_to_ascii tells me directly
# what pack "H*" does.
#
# AUTHOR
# ======
# Andreas Hernitscheck  ahernit(AT)cpan.org


# Converts pairs of hex digits to asci
sub hex_to_ascii { # $ascii ($hex)
  my $s = shift;

  return pack 'H*', $s;
}

# Converts a string to pairs of hex digits
sub ascii_to_hex { # $hex ($ascii)
  my $s = shift;

  return unpack("H*",  $s);
}

1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

String::HexConvert - Converts ascii strings to hex and reverse


=head1 SYNOPSIS


 use String::HexConvert ':all';

 print ascii_to_hex("hello world"); # writes: 68656c6c6f20776f726c64

 print hex_to_ascii("68656c6c6f20776f726c64"); # writes: hello world

 



=head1 DESCRIPTION

It is a wrapper around pack and unpack of perl to convert a string of hex digits
to ascii and other way around.



=head1 REQUIRES

L<Exporter> 


=head1 METHODS

=head2 ascii_to_hex

 my $hex = ascii_to_hex($ascii);

Converts a string to pairs of hex digits


=head2 hex_to_ascii

 my $ascii = hex_to_ascii($hex);

Converts pairs of hex digits to asci



=head1 WHY?

In know the comments like "is that realy needed?". IMHO yes, because I forget the 
exact syntax and possibilities of pack and unpack but hex_to_ascii tells me directly
what pack "H*" does.



=head1 SEE ALSO

pack, unpack, L<Data::Translate>



=head1 AUTHOR

Andreas Hernitscheck  ahernit(AT)cpan.org


=head1 LICENSE

You can redistribute it and/or modify it under the conditions of LGPL.



=cut

