# Generated by default/object.tt
package Paws::FMS::SecurityGroupRuleDescription;
  use Moose;
  has FromPort => (is => 'ro', isa => 'Int');
  has IPV4Range => (is => 'ro', isa => 'Str');
  has IPV6Range => (is => 'ro', isa => 'Str');
  has PrefixListId => (is => 'ro', isa => 'Str');
  has Protocol => (is => 'ro', isa => 'Str');
  has ToPort => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::SecurityGroupRuleDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::SecurityGroupRuleDescription object:

  $service_obj->Method(Att1 => { FromPort => $value, ..., ToPort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::SecurityGroupRuleDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->FromPort

=head1 DESCRIPTION

Describes a set of permissions for a security group rule.

=head1 ATTRIBUTES


=head2 FromPort => Int

The start of the port range for the TCP and UDP protocols, or an
ICMP/ICMPv6 type number. A value of C<-1> indicates all ICMP/ICMPv6
types.


=head2 IPV4Range => Str

The IPv4 ranges for the security group rule.


=head2 IPV6Range => Str

The IPv6 ranges for the security group rule.


=head2 PrefixListId => Str

The ID of the prefix list for the security group rule.


=head2 Protocol => Str

The IP protocol name (C<tcp>, C<udp>, C<icmp>, C<icmpv6>) or number.


=head2 ToPort => Int

The end of the port range for the TCP and UDP protocols, or an
ICMP/ICMPv6 code. A value of C<-1> indicates all ICMP/ICMPv6 codes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

