# Generated by default/object.tt
package Paws::FraudDetector::TrainingMetrics;
  use Moose;
  has Auc => (is => 'ro', isa => 'Num', request_name => 'auc', traits => ['NameInRequest']);
  has MetricDataPoints => (is => 'ro', isa => 'ArrayRef[Paws::FraudDetector::MetricDataPoint]', request_name => 'metricDataPoints', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::TrainingMetrics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::TrainingMetrics object:

  $service_obj->Method(Att1 => { Auc => $value, ..., MetricDataPoints => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::TrainingMetrics object:

  $result = $service_obj->Method(...);
  $result->Att1->Auc

=head1 DESCRIPTION

The training metric details.

=head1 ATTRIBUTES


=head2 Auc => Num

The area under the curve. This summarizes true positive rate (TPR) and
false positive rate (FPR) across all possible model score thresholds. A
model with no predictive power has an AUC of 0.5, whereas a perfect
model has a score of 1.0.


=head2 MetricDataPoints => ArrayRef[L<Paws::FraudDetector::MetricDataPoint>]

The data points details.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

