# Generated by default/object.tt
package Paws::Macie2::CustomDataIdentifiers;
  use Moose;
  has Detections => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::CustomDetection]', request_name => 'detections', traits => ['NameInRequest']);
  has TotalCount => (is => 'ro', isa => 'Int', request_name => 'totalCount', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::CustomDataIdentifiers

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::CustomDataIdentifiers object:

  $service_obj->Method(Att1 => { Detections => $value, ..., TotalCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::CustomDataIdentifiers object:

  $result = $service_obj->Method(...);
  $result->Att1->Detections

=head1 DESCRIPTION

Provides information about custom data identifiers that produced a
sensitive data finding, and the number of occurrences of the data that
they detected for the finding.

=head1 ATTRIBUTES


=head2 Detections => ArrayRef[L<Paws::Macie2::CustomDetection>]

The custom data identifiers that detected the data, and the number of
occurrences of the data that each identifier detected.


=head2 TotalCount => Int

The total number of occurrences of the data that was detected by the
custom data identifiers and produced the finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

