package Map::Tube::Rome::Line::MC;

$Map::Tube::Rome::Line::MC::VERSION   = '1.01';
$Map::Tube::Rome::Line::MC::AUTHORITY = 'cpan:GDT';

use 5.010;
use strict;
use warnings;

=head1 NAME

Map::Tube::Rome::Line::MC - Rome Subway Map: Linea C.

=head1 DESCRIPTION

Rome Subway Map: Linea C

    .-----------------------------------------------------------------------.
    | Station Name                | Connected To                            |
    +-----------------------------+-----------------------------------------+
    | Monte Compatri-Pantano      | Graniti                                 |
    | Graniti                     | Monte Compatri-Pantano, Finocchio       |
    | Finocchio                   | Graniti, Bolognetta                     |
    | Bolognetta                  | Finocchio, Borghesiana                  |
    | Borghesiana                 | Bolognetta, Due Leoni - Fontana Candida |
    | Due Leoni - Fontana Candida | Borghesiana, Grotte Celoni              |
    | Grotte Celoni               | Due Leoni - Fontana Candida, Torre Gaia |
    | Torre Gaia                  | Grotte Celoni, Torre Angela             |
    | Torre Angela                | Torre Gaia, Torrenova                   |
    | Torrenova                   | Torre Angela, Giardinetti               |
    | Giardinetti                 | Torrenova, Torre Maura                  |
    | Torre Maura                 | Giardinetti, Torre Spaccata             |
    | Torre Spaccata              | Torre Maura, Alessandrino               |
    | Alessandrino                | Torre Spaccata, Parco di Centocelle     |
    | Parco di Centocelle         | Alessandrino, Mirti                     |
    | Mirti                       | Parco di Centocelle, Gardenie           |
    | Gardenie                    | Mirti, Teano                            |
    | Teano                       | Gardenie, Malatesta                     |
    | Malatesta                   | Teano, Pigneto                          |
    | Pigneto                     | Malatesta, Lodi                         |
    | Lodi                        | Pigneto, San Giovanni                   |
    | San Giovanni                | Re di Roma, Manzoni, Lodi               |
    '-----------------------------+-----------------------------------------'

=head1 NOTE

=over 2

=item * The station "San Giovanni" is also part of
          L<Linea A|Map::Tube::Rome::Line::MA>.

=back

=head1 MAP

Rome Subway Map: L<Linea C|https://raw.githubusercontent.com/giterlizzi/perl-Map-Tube-Rome/main/maps/MC.png>
map generated by plugin L<Map::Tube::Plugin::Graph>.

=begin html

<a href = "https://raw.githubusercontent.com/giterlizzi/perl-Map-Tube-Rome/main/maps/MC.png">
<img src = "https://raw.githubusercontent.com/giterlizzi/perl-Map-Tube-Rome/main/maps/MC.png"
     alt = "Rome Subway Map: Linea C" />
</a>

=end html

=head1 SUPPORT

=head2 Bugs / Feature Requests

Please report any bugs or feature requests through the issue tracker
at L<https://github.com/giterlizzi/perl-Map-Tube-Rome/issues>.
You will be notified automatically of any progress on your issue.

=head2 Source Code

This is open source software.  The code repository is available for
public review and contribution under the terms of the license.

L<https://github.com/giterlizzi/perl-Map-Tube-Rome>

    git clone https://github.com/giterlizzi/perl-Map-Tube-Rome.git

=head1 AUTHOR

Giuseppe Di Terlizzi <gdt@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024-2025 by Giuseppe Di Terlizzi <gdt@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

1;    # End of Map::Tube::Rome::Line::MC
