package Shipment::FedEx::WSDL::TrackTypes::EMailNotificationRecipient;
$Shipment::FedEx::WSDL::TrackTypes::EMailNotificationRecipient::VERSION = '3.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %EMailNotificationRecipientType_of :
      ATTR(:get<EMailNotificationRecipientType>);
    my %EMailAddress_of : ATTR(:get<EMailAddress>);
    my %NotificationEventsRequested_of :
      ATTR(:get<NotificationEventsRequested>);
    my %Format_of : ATTR(:get<Format>);
    my %Localization_of : ATTR(:get<Localization>);

    __PACKAGE__->_factory(
        [   qw(        EMailNotificationRecipientType
              EMailAddress
              NotificationEventsRequested
              Format
              Localization

              )
        ],
        {   'EMailNotificationRecipientType' =>
              \%EMailNotificationRecipientType_of,
            'EMailAddress'                => \%EMailAddress_of,
            'NotificationEventsRequested' => \%NotificationEventsRequested_of,
            'Format'                      => \%Format_of,
            'Localization'                => \%Localization_of,
        },
        {   'EMailNotificationRecipientType' =>
              'Shipment::FedEx::WSDL::TrackTypes::EMailNotificationRecipientType',
            'EMailAddress' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'NotificationEventsRequested' =>
              'Shipment::FedEx::WSDL::TrackTypes::EMailNotificationEventType',
            'Format' =>
              'Shipment::FedEx::WSDL::TrackTypes::EMailNotificationFormatType',
            'Localization' =>
              'Shipment::FedEx::WSDL::TrackTypes::Localization',
        },
        {

            'EMailNotificationRecipientType' =>
              'EMailNotificationRecipientType',
            'EMailAddress'                => 'EMailAddress',
            'NotificationEventsRequested' => 'NotificationEventsRequested',
            'Format'                      => 'Format',
            'Localization'                => 'Localization',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::EMailNotificationRecipient

=head1 VERSION

version 3.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EMailNotificationRecipient from the namespace http://fedex.com/ws/track/v9.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EMailNotificationRecipientType

=item * EMailAddress

=item * NotificationEventsRequested

=item * Format

=item * Localization

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::EMailNotificationRecipient

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::EMailNotificationRecipient
   EMailNotificationRecipientType => $some_value, # EMailNotificationRecipientType
   EMailAddress =>  $some_value, # string
   NotificationEventsRequested => $some_value, # EMailNotificationEventType
   Format => $some_value, # EMailNotificationFormatType
   Localization =>  { # Shipment::FedEx::WSDL::TrackTypes::Localization
     LanguageCode =>  $some_value, # string
     LocaleCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
