package App::Zealc::UsageExtractor;

use 5.014000;
use strict;
use warnings;

our $VERSION = '0.000_001';

use parent qw/Pod::Simple::Methody/;

use Text::Wrap qw/fill/;

sub start_head1 {
	my ($self, $section) = @_;
	$self->{section} = '';
	$self->{insection} = 1;
}

sub end_head1 {
	my ($self) = @_;
	$self->{insection} = 0;
	$self->{firstpara} = 1;
}

sub start_Para {
	my ($self) = @_;
	$self->handle_text("\n\n") unless $self->{firstpara};
	$self->{firstpara} = 0;
}

sub handle_text {
	my ($self, $text) = @_;
	$self->{section}          .= $text if $self->{insection};
	$self->{$self->{section}} .= $text if $self->{section} && !$self->{insection};
}

sub synopsis {
	my ($self) = @_;
	$self->{SYNOPSIS}
}

sub description {
	my ($self) = @_;
	fill '', '', $self->{DESCRIPTION}
}

sub usage {
	my ($self) = @_;
	$self->synopsis . "\n\n" . $self->description . "\n";
}

1;
__END__

=encoding utf-8

=head1 NAME

App::Zealc::UsageExtractor - Extract SYNOPSIS and DESCRIPTION sections from a module

=head1 SYNOPSIS

  use App::Zealc::UsageExtractor;
  my $parser = App::Zealc::UsageExtractor->new;
  $parser->parse_file("path/to/file.pm");

  say $parser->synopsis;    # contents of synopsis section
  say $parser->description; # contents of description, filled
  say $parser->usage; # $parser->synopsis."\n\n".$parser->description."\n"

=head1 DESCRIPTION

App::Zealc::UsageExtractor is a L<Pod::Simple> subclass that extracts
the SYNOPSIS and DESCRIPTION sections from a Pod file.

=over

=item synopsis

The SYNOPSIS section of the file

=item description

The DESCRIPTION section of the file, filled using L<Text::Wrap>

=item usage

Equivalent to C<< $parser->synopsis."\n\n".$parser->description."\n" >>

=back

=head1 SEE ALSO

L<zealc>, L<Zeal>

=head1 AUTHOR

Marius Gavrilescu, E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.20.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
