#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Audio::Signal::Effect::Echos;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Audio::Signal::Effect';
    
    has 'gain_in' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'gain_out' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'decay' => (
        is => 'rw',
        isa => 'ArrayRef',
    );

    has 'delay' => (
        is => 'rw',
        isa => 'ArrayRef',
    );
   
    sub gencmd {
        my $self = shift;
	    my $dd_ret = '';
	    my @delays = @{$self->delay};
	    my @decays = @{$self->decay};

        my $dd_count;

	    $dd_count ||= scalar @delays;
	    $dd_count ||= scalar @decays;

        for my $icount (0 .. $dd_count - 1) {
	        $dd_ret = sprintf("%s %s %s",$dd_ret,$delays[$icount],$decays[$icount]);
	    }

        $dd_ret =~ s/^\s//g;
        $dd_ret =~ s/\s+$//g;

        my $ret = sprintf("%s %s %s %s",$self->fx,$self->gain_in,$self->gain_out,$dd_ret);
        return($ret);
    }
}

1;
