/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/storage/v1"
	storagev1 "k8s.io/client-go/applyconfigurations/storage/v1"
	gentype "k8s.io/client-go/gentype"
	typedstoragev1 "k8s.io/client-go/kubernetes/typed/storage/v1"
)

// fakeStorageClasses implements StorageClassInterface
type fakeStorageClasses struct {
	*gentype.FakeClientWithListAndApply[*v1.StorageClass, *v1.StorageClassList, *storagev1.StorageClassApplyConfiguration]
	Fake *FakeStorageV1
}

func newFakeStorageClasses(fake *FakeStorageV1) typedstoragev1.StorageClassInterface {
	return &fakeStorageClasses{
		gentype.NewFakeClientWithListAndApply[*v1.StorageClass, *v1.StorageClassList, *storagev1.StorageClassApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("storageclasses"),
			v1.SchemeGroupVersion.WithKind("StorageClass"),
			func() *v1.StorageClass { return &v1.StorageClass{} },
			func() *v1.StorageClassList { return &v1.StorageClassList{} },
			func(dst, src *v1.StorageClassList) { dst.ListMeta = src.ListMeta },
			func(list *v1.StorageClassList) []*v1.StorageClass { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.StorageClassList, items []*v1.StorageClass) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
