/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

/* This file is autogenerated from the Unicode 13.0 database. Do not edit */

#include "qunicodetables_p.h"

QT_BEGIN_NAMESPACE

namespace QUnicodeTables {

static const unsigned short uc_property_trie[] = {
    // [0x0..0x11000)

    6256, 6288, 6320, 6352, 6384, 6416, 6448, 6480,
    6512, 6544, 6576, 6608, 6640, 6672, 6704, 6736,
    6768, 6800, 6832, 6864, 6896, 6928, 6960, 6992,
    7024, 7056, 7088, 7120, 7152, 7184, 7216, 7248,
    7280, 7312, 7344, 7376, 7408, 7440, 7472, 7504,
    7536, 7568, 7600, 7632, 7664, 7696, 7728, 7760,
    7792, 7824, 7856, 7888, 7920, 7952, 7984, 8016,
    8048, 8080, 8112, 8144, 8176, 8208, 8240, 8272,
    8304, 8336, 8368, 8400, 8432, 8464, 8496, 8528,
    8560, 8592, 8624, 8656, 8688, 8720, 8752, 8784,
    8816, 8848, 8880, 8912, 8944, 8976, 9008, 9040,
    9072, 9104, 9136, 9168, 9200, 9232, 9264, 9296,
    9328, 9360, 9392, 9424, 9456, 9488, 9520, 9552,
    9584, 9616, 9648, 9680, 9712, 9744, 9776, 9808,
    9840, 9872, 9904, 9936, 9968, 10000, 10032, 9936,
    10064, 10096, 10128, 10160, 10192, 10224, 10256, 9936,

    10288, 10320, 10352, 10384, 10416, 10448, 10480, 10512,
    10544, 10544, 10576, 10608, 10640, 10672, 10704, 10736,
    10768, 10800, 10832, 10800, 10864, 10896, 10928, 10960,
    10992, 10800, 11024, 11056, 11088, 11120, 11152, 11184,
    11216, 11248, 11248, 11248, 11248, 11248, 11248, 11248,
    11248, 11248, 11248, 11248, 11248, 11248, 11248, 11248,
    11248, 11248, 11248, 11280, 11312, 11344, 11344, 11376,
    11408, 11440, 11472, 11504, 11536, 11568, 11600, 11632,
    11664, 11696, 11728, 11760, 11792, 11824, 11856, 11888,
    11920, 11952, 11984, 12016, 12048, 12080, 12112, 12144,
    12176, 12208, 12240, 12272, 12304, 12336, 12368, 9936,
    12400, 12432, 12464, 12496, 12528, 12560, 12592, 12624,
    12656, 12688, 12720, 12752, 12784, 12816, 12848, 12880,
    12912, 12944, 12976, 13008, 13040, 13072, 13104, 13136,
    13168, 13168, 13168, 13168, 13200, 13168, 13168, 13232,
    13264, 13296, 13328, 13360, 13392, 13424, 13456, 13488,

    13520, 13552, 13584, 13616, 13648, 13680, 13712, 13744,
    13776, 13808, 13840, 13872, 13904, 13936, 13968, 14000,
    14032, 14064, 14096, 14128, 14160, 14192, 14224, 14256,
    14288, 14320, 14352, 14384, 14416, 14448, 14480, 14512,
    14544, 14576, 14608, 14640, 14672, 14704, 14736, 14768,
    14544, 14544, 14544, 14544, 14800, 14832, 14864, 14896,
    14928, 14960, 14544, 14992, 15024, 15056, 15088, 15120,
    15152, 15184, 15216, 15248, 15280, 15312, 15344, 15376,
    15408, 15408, 15408, 15408, 15408, 15408, 15408, 15408,
    15440, 15440, 15440, 15440, 15472, 15504, 15536, 15568,
    15600, 15632, 15440, 15664, 15696, 15728, 15760, 15792,
    15824, 15856, 15888, 15920, 15952, 15984, 16016, 16048,
    16080, 16112, 16144, 16176, 16208, 16208, 16208, 16240,
    16272, 16304, 16336, 16368, 16400, 16432, 16432, 16464,
    16496, 16528, 16560, 9936, 16592, 16624, 16624, 16656,
    16688, 16688, 16688, 16688, 16688, 16688, 16720, 16752,

    16784, 16816, 16848, 16880, 16912, 16944, 16976, 17008,
    17040, 17072, 17104, 17104, 17136, 17168, 17200, 17232,
    17264, 17296, 17328, 17360, 17296, 17392, 17424, 17456,
    17488, 17488, 17520, 17552, 17584, 17584, 17616, 17648,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,

    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17680, 17680, 17680,
    17680, 17680, 17680, 17680, 17680, 17712, 17744, 17744,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,

    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,

    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,

    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,

    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,

    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17776, 17776, 17776,
    17776, 17776, 17776, 17776, 17776, 17808, 17840, 17872,

    17904, 17936, 17936, 17936, 17936, 17936, 17936, 17936,
    17936, 17936, 17936, 17936, 17936, 17936, 17936, 17936,
    17936, 17936, 17936, 17936, 17936, 17936, 17936, 17936,
    17936, 17936, 17936, 17936, 17936, 17936, 17936, 17936,
    17936, 17936, 17936, 17936, 17968, 18000, 18032, 18064,
    18096, 18096, 18096, 18096, 18096, 18096, 18096, 18096,
    18128, 18160, 18192, 18224, 18256, 18288, 18288, 18320,
    18352, 18384, 18416, 18448, 18480, 18512, 18544, 18576,
    18608, 18640, 18672, 18704, 18736, 18768, 18800, 18832,
    18864, 18896, 18928, 18960, 18992, 19024, 19056, 19088,
    19120, 19152, 19184, 19216, 19248, 19280, 19312, 19344,
    19376, 19408, 19440, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,
    19664, 19696, 19728, 19760, 19792, 19824, 19632, 19664,
    19696, 19728, 19760, 19792, 19824, 19632, 19664, 19696,
    19728, 19760, 19792, 19824, 19632, 19664, 19696, 19728,

    19760, 19792, 19824, 19632, 19664, 19696, 19728, 19760,
    19792, 19824, 19632, 19664, 19696, 19728, 19760, 19792,
    19824, 19632, 19664, 19696, 19728, 19760, 19792, 19824,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,
    19664, 19696, 19728, 19760, 19792, 19824, 19632, 19664,
    19696, 19728, 19760, 19792, 19824, 19632, 19664, 19696,
    19728, 19760, 19792, 19824, 19632, 19664, 19696, 19728,
    19760, 19792, 19824, 19632, 19664, 19696, 19728, 19760,
    19792, 19824, 19632, 19664, 19696, 19728, 19760, 19792,
    19824, 19632, 19664, 19696, 19728, 19760, 19792, 19824,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,
    19664, 19696, 19728, 19760, 19792, 19824, 19632, 19664,
    19696, 19728, 19760, 19792, 19824, 19632, 19664, 19696,
    19728, 19760, 19792, 19824, 19632, 19664, 19696, 19728,
    19760, 19792, 19824, 19632, 19664, 19696, 19728, 19760,
    19792, 19824, 19632, 19664, 19696, 19728, 19760, 19792,

    19824, 19632, 19664, 19696, 19728, 19760, 19792, 19824,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,
    19664, 19696, 19728, 19760, 19792, 19824, 19632, 19664,
    19696, 19728, 19760, 19792, 19824, 19632, 19664, 19696,
    19728, 19760, 19792, 19824, 19632, 19664, 19696, 19728,
    19760, 19792, 19824, 19632, 19664, 19696, 19728, 19760,
    19792, 19824, 19632, 19664, 19696, 19728, 19760, 19792,
    19824, 19632, 19664, 19696, 19728, 19760, 19792, 19824,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,
    19664, 19696, 19728, 19760, 19792, 19824, 19632, 19664,
    19696, 19728, 19760, 19792, 19824, 19632, 19664, 19696,
    19728, 19760, 19792, 19824, 19632, 19664, 19696, 19728,
    19760, 19792, 19824, 19632, 19664, 19696, 19728, 19760,
    19792, 19824, 19632, 19664, 19696, 19728, 19760, 19792,
    19824, 19632, 19664, 19696, 19728, 19760, 19792, 19824,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,

    19664, 19696, 19728, 19760, 19792, 19824, 19632, 19664,
    19696, 19728, 19760, 19792, 19824, 19632, 19664, 19696,
    19728, 19760, 19792, 19824, 19632, 19664, 19696, 19728,
    19760, 19792, 19824, 19632, 19664, 19696, 19728, 19760,
    19792, 19824, 19632, 19664, 19696, 19728, 19760, 19792,
    19824, 19632, 19664, 19696, 19728, 19760, 19792, 19824,
    19632, 19664, 19696, 19728, 19760, 19792, 19824, 19632,
    19664, 19696, 19728, 19760, 19792, 19856, 19888, 19920,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,
    19952, 19952, 19952, 19952, 19952, 19952, 19952, 19952,

    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,

    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    19984, 19984, 19984, 19984, 19984, 19984, 19984, 19984,
    20016, 20016, 20016, 20016, 20016, 20016, 20016, 20016,
    20048, 20080, 20112, 20144, 20176, 20176, 20208, 20240,
    20272, 20304, 20336, 20368, 20368, 20400, 20432, 20368,
    20368, 20368, 20368, 20368, 20368, 20368, 20368, 20368,
    20368, 20464, 20496, 20368, 20528, 20368, 20560, 20592,
    20624, 20656, 20688, 20720, 20368, 20368, 20368, 20752,
    20784, 20816, 20848, 20880, 20912, 20944, 20976, 21008,

    21040, 21072, 21104, 9936, 21136, 21136, 21136, 21168,
    21200, 21232, 21264, 21296, 21328, 21360, 21392, 21424,
    9936, 9936, 9936, 9936, 21456, 21488, 21520, 21552,
    21584, 21616, 21648, 21680, 21712, 21744, 21776, 9936,
    21808, 21840, 21872, 21904, 21936, 21968, 22000, 22032,
    22064, 22096, 22128, 22160, 9936, 9936, 9936, 9936,
    22192, 22192, 22192, 22192, 22192, 22192, 22192, 22192,
    22192, 22224, 22256, 22288, 9936, 9936, 9936, 9936,
    22320, 22352, 22384, 22416, 22448, 22480, 8432, 22512,
    22544, 22576, 8432, 8432, 22608, 22640, 22672, 22704,
    22736, 22768, 22800, 22832, 22864, 8432, 22896, 22928,
    22960, 22992, 23024, 23056, 23088, 23120, 8432, 8432,
    23152, 23152, 23184, 8432, 23216, 23248, 23280, 23312,
    23344, 23376, 8432, 8432, 8432, 8432, 8432, 8432,
    8432, 8432, 8432, 23408, 23440, 23472, 8432, 8432,
    23504, 23536, 23568, 8432, 8432, 23600, 23632, 23664,

    // [0x11000..0x110000)

    23696, 23952, 24208, 24464, 24720, 24976, 25232, 25488,
    25744, 26000, 26256, 26512, 26768, 27024, 27280, 27536,
    27792, 27792, 27792, 28048, 28304, 28560, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    28816, 28816, 29072, 29328, 29584, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 29840, 30096, 30352, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    30608, 30608, 30864, 31120, 26512, 26512, 31376, 31632,
    31888, 31888, 31888, 31888, 31888, 31888, 31888, 31888,
    31888, 31888, 31888, 31888, 31888, 31888, 31888, 31888,
    31888, 31888, 31888, 31888, 31888, 31888, 31888, 32144,
    31888, 31888, 32400, 32656, 32912, 33168, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    33424, 33680, 33936, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 34192, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    34448, 34704, 34960, 35216, 35472, 35728, 35984, 36240,
    36496, 36496, 36752, 26512, 26512, 26512, 26512, 26512,
    37008, 37264, 37520, 26512, 26512, 26512, 26512, 26512,
    37776, 38032, 38288, 38288, 38544, 38800, 39056, 38288,
    39312, 39568, 39824, 40080, 40336, 40592, 40848, 41104,
    41360, 41616, 41872, 42128, 42384, 42384, 42384, 42640,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,

    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 42896, 42896,
    42896, 42896, 42896, 42896, 42896, 42896, 43152, 43408,
    43408, 43408, 43408, 43408, 43408, 43408, 43408, 43408,
    43408, 43408, 43408, 43408, 43408, 43408, 43408, 43664,
    43920, 44176, 44176, 44176, 44176, 44176, 44176, 44176,
    44176, 44176, 44176, 44176, 44176, 44176, 44176, 44176,
    44176, 44176, 44176, 44176, 44176, 44176, 44432, 44688,
    44688, 44688, 44688, 44688, 44688, 44688, 44688, 44688,
    44688, 44688, 44688, 44688, 44688, 44688, 44688, 44688,
    44688, 44688, 44688, 44688, 44688, 44688, 44688, 44688,
    44688, 44688, 44688, 44944, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    45200, 45200, 45456, 42384, 42384, 42384, 42384, 42640,
    45712, 45712, 45712, 45712, 45712, 45712, 45712, 45712,
    45712, 45712, 45712, 45712, 45712, 45712, 45712, 45712,
    45712, 45712, 45712, 45968, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,

    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42384,
    42384, 42384, 42384, 42384, 42384, 42384, 42384, 42640,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    46480, 46736, 46992, 46992, 46992, 46992, 46992, 46992,
    46992, 46992, 46992, 46992, 46992, 46992, 46992, 46992,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,

    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 26512,
    26512, 26512, 26512, 26512, 26512, 26512, 26512, 46224,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,

    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47504,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,

    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47248,
    47248, 47248, 47248, 47248, 47248, 47248, 47248, 47504,


    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 3, 4, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 6, 6, 7,

    8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 14, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30,
    31, 32, 33, 34, 35, 36, 37, 9,

    14, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 39, 40, 41, 42, 43,

    42, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 39, 45, 46, 36, 0,

    0, 0, 0, 0, 0, 47, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    48, 49, 50, 12, 12, 12, 51, 14,
    52, 51, 53, 54, 36, 55, 51, 52,
    56, 57, 58, 59, 60, 61, 14, 62,
    52, 63, 53, 64, 65, 65, 65, 49,

    66, 66, 66, 66, 66, 66, 38, 66,
    66, 66, 66, 66, 66, 66, 66, 66,
    38, 66, 66, 66, 66, 66, 66, 36,
    38, 66, 66, 66, 66, 66, 38, 67,

    68, 68, 68, 68, 68, 68, 44, 68,
    68, 68, 68, 68, 68, 68, 68, 68,
    44, 68, 68, 68, 68, 68, 68, 36,
    44, 68, 68, 68, 68, 68, 44, 69,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    72, 73, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 72, 73,
    70, 71, 70, 71, 70, 71, 70, 71,
    74, 75, 76, 77, 70, 71, 70, 71,
    78, 70, 71, 70, 71, 70, 71, 76,

    77, 72, 73, 70, 71, 70, 71, 70,
    71, 79, 72, 73, 70, 71, 70, 71,
    70, 71, 72, 73, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 72, 73,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    80, 70, 71, 70, 71, 70, 71, 81,

    82, 83, 72, 73, 72, 73, 84, 72,
    73, 85, 85, 72, 73, 78, 86, 87,
    88, 72, 73, 85, 89, 90, 91, 92,
    72, 73, 93, 78, 91, 94, 95, 96,

    70, 71, 72, 73, 72, 73, 97, 72,
    73, 97, 78, 78, 72, 73, 97, 70,
    71, 98, 98, 72, 73, 72, 73, 99,
    72, 73, 78, 100, 72, 73, 78, 101,

    100, 100, 100, 100, 102, 103, 104, 102,
    103, 104, 102, 103, 104, 70, 71, 70,
    71, 70, 71, 70, 71, 70, 71, 70,
    71, 70, 71, 70, 71, 105, 70, 71,

    70, 71, 70, 71, 72, 73, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    106, 102, 103, 104, 70, 71, 107, 108,
    109, 110, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    109, 110, 109, 110, 111, 112, 109, 110,

    113, 114, 111, 112, 111, 112, 109, 110,
    109, 110, 109, 110, 109, 110, 109, 110,
    109, 110, 109, 110, 114, 114, 114, 115,
    115, 115, 116, 117, 118, 119, 120, 121,

    122, 117, 123, 124, 125, 126, 127, 123,
    127, 123, 127, 123, 127, 123, 127, 123,
    128, 129, 130, 131, 132, 78, 133, 133,
    78, 134, 78, 135, 136, 78, 78, 78,

    133, 137, 78, 138, 78, 139, 140, 78,
    141, 142, 143, 144, 145, 78, 78, 142,
    78, 146, 147, 78, 78, 148, 78, 78,
    78, 78, 78, 78, 78, 149, 78, 78,

    150, 78, 151, 150, 78, 78, 78, 152,
    150, 153, 154, 154, 155, 78, 78, 78,
    78, 78, 156, 78, 100, 78, 78, 78,
    78, 78, 78, 78, 78, 157, 158, 78,

    78, 78, 78, 78, 78, 78, 78, 78,
    78, 159, 159, 159, 159, 159, 114, 114,
    160, 160, 160, 160, 160, 160, 160, 160,
    160, 161, 161, 162, 162, 162, 162, 162,

    163, 163, 164, 164, 164, 164, 161, 161,
    165, 161, 161, 161, 165, 161, 161, 161,
    162, 162, 164, 164, 164, 164, 164, 164,
    52, 52, 52, 52, 52, 52, 164, 166,

    160, 160, 160, 160, 160, 164, 164, 164,
    164, 164, 167, 167, 168, 169, 170, 171,
    171, 171, 171, 171, 171, 171, 171, 171,
    171, 171, 171, 171, 171, 171, 171, 171,

    172, 172, 172, 172, 172, 173, 172, 172,
    172, 172, 172, 172, 172, 173, 173, 172,
    173, 172, 173, 172, 172, 174, 175, 175,
    175, 175, 174, 176, 175, 175, 175, 175,

    175, 177, 177, 178, 178, 178, 178, 179,
    179, 175, 175, 175, 175, 178, 178, 175,
    178, 178, 175, 175, 180, 180, 180, 180,
    181, 175, 175, 175, 175, 173, 173, 173,

    182, 182, 172, 182, 182, 183, 184, 185,
    185, 185, 184, 184, 184, 185, 185, 186,
    187, 187, 187, 188, 188, 188, 188, 187,
    189, 190, 190, 191, 192, 193, 193, 194,

    195, 195, 196, 197, 197, 197, 197, 197,
    197, 197, 197, 197, 197, 197, 197, 197,
    198, 199, 198, 199, 200, 201, 198, 199,
    202, 202, 203, 204, 204, 204, 205, 206,

    202, 202, 202, 202, 207, 208, 209, 210,
    211, 211, 211, 202, 212, 202, 213, 213,
    214, 215, 215, 215, 215, 215, 215, 215,
    215, 215, 215, 215, 215, 215, 215, 215,

    215, 215, 202, 215, 215, 215, 215, 215,
    215, 215, 216, 216, 217, 218, 218, 218,
    219, 220, 220, 220, 220, 220, 220, 220,
    220, 220, 220, 220, 220, 220, 220, 220,

    220, 220, 221, 220, 220, 220, 220, 220,
    220, 220, 222, 222, 223, 224, 224, 225,
    226, 227, 228, 229, 229, 230, 231, 232,
    233, 234, 235, 236, 235, 236, 235, 236,

    235, 236, 237, 238, 237, 238, 237, 238,
    237, 238, 237, 238, 237, 238, 237, 238,
    239, 240, 241, 242, 243, 244, 245, 246,
    247, 248, 246, 247, 249, 250, 250, 250,

    251, 252, 253, 252, 253, 253, 253, 252,
    253, 253, 253, 253, 252, 251, 252, 253,
    254, 254, 254, 254, 254, 254, 254, 254,
    254, 255, 254, 254, 254, 254, 254, 254,

    254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254, 254, 254, 254,
    256, 256, 256, 256, 256, 256, 256, 256,
    256, 257, 256, 256, 256, 256, 256, 256,

    256, 256, 256, 256, 256, 256, 256, 256,
    256, 256, 256, 256, 256, 256, 256, 256,
    258, 259, 260, 259, 260, 260, 260, 259,
    260, 260, 260, 260, 259, 258, 259, 260,

    261, 262, 261, 262, 261, 262, 261, 262,
    261, 262, 261, 262, 261, 262, 261, 262,
    261, 262, 261, 262, 261, 262, 263, 264,
    261, 262, 261, 262, 261, 262, 261, 262,

    261, 262, 265, 266, 266, 173, 173, 267,
    268, 268, 269, 270, 271, 272, 271, 272,
    261, 262, 261, 262, 261, 262, 261, 262,
    261, 262, 261, 262, 261, 262, 261, 262,

    261, 262, 261, 262, 261, 262, 261, 262,
    261, 262, 261, 262, 261, 262, 261, 262,
    261, 262, 261, 262, 261, 262, 261, 262,
    261, 262, 261, 262, 261, 262, 261, 262,

    273, 263, 264, 261, 262, 269, 270, 261,
    262, 269, 270, 261, 262, 269, 270, 274,
    263, 264, 263, 264, 261, 262, 263, 264,
    261, 262, 263, 264, 263, 264, 263, 264,

    261, 262, 263, 264, 263, 264, 263, 264,
    261, 262, 263, 264, 275, 276, 263, 264,
    263, 264, 263, 264, 263, 264, 277, 278,
    263, 264, 279, 280, 279, 280, 279, 280,

    269, 270, 269, 270, 269, 270, 269, 270,
    269, 270, 269, 270, 269, 270, 269, 270,
    279, 280, 279, 280, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 281, 282,

    281, 282, 281, 282, 283, 284, 285, 286,
    287, 288, 287, 288, 287, 288, 287, 288,
    202, 289, 289, 289, 289, 289, 289, 289,
    289, 289, 289, 289, 289, 289, 289, 289,

    289, 289, 289, 289, 289, 289, 289, 289,
    289, 289, 289, 289, 289, 289, 289, 289,
    289, 289, 289, 289, 289, 289, 289, 202,
    202, 290, 291, 291, 291, 292, 291, 293,

    294, 295, 295, 295, 295, 295, 295, 295,
    295, 295, 295, 295, 295, 295, 295, 295,
    295, 295, 295, 295, 295, 295, 295, 295,
    295, 295, 295, 295, 295, 295, 295, 295,

    295, 295, 295, 295, 295, 295, 295, 296,
    294, 297, 298, 202, 202, 299, 299, 300,
    301, 302, 303, 303, 303, 303, 302, 303,
    303, 303, 304, 302, 303, 303, 303, 303,

    303, 303, 305, 302, 302, 302, 302, 302,
    303, 303, 302, 303, 303, 304, 306, 303,
    307, 308, 309, 310, 311, 312, 313, 314,
    315, 316, 317, 318, 319, 320, 321, 322,

    323, 324, 325, 323, 303, 305, 326, 327,
    301, 301, 301, 301, 301, 301, 301, 301,
    328, 328, 328, 328, 328, 328, 328, 328,
    328, 328, 328, 328, 328, 328, 328, 328,

    328, 328, 328, 328, 328, 328, 328, 328,
    328, 328, 328, 301, 301, 301, 301, 329,
    328, 328, 328, 330, 331, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    332, 332, 332, 332, 333, 334, 335, 335,
    336, 337, 337, 338, 19, 339, 340, 340,
    341, 341, 341, 341, 341, 341, 342, 342,
    343, 344, 345, 346, 347, 348, 349, 350,

    351, 352, 353, 353, 353, 353, 354, 355,
    356, 355, 356, 356, 356, 356, 356, 355,
    355, 355, 355, 356, 356, 356, 356, 356,
    356, 356, 356, 357, 357, 357, 357, 357,

    358, 356, 356, 356, 356, 356, 356, 356,
    355, 356, 356, 359, 360, 361, 362, 363,
    364, 365, 366, 367, 367, 368, 369, 341,
    341, 370, 370, 370, 371, 370, 370, 372,

    373, 374, 375, 376, 377, 378, 379, 380,
    381, 382, 383, 384, 385, 386, 387, 387,
    388, 355, 355, 355, 352, 389, 389, 389,
    390, 356, 356, 356, 356, 356, 356, 356,

    356, 356, 356, 356, 356, 356, 356, 356,
    355, 355, 355, 355, 355, 355, 355, 355,
    355, 355, 355, 355, 355, 355, 355, 355,
    355, 355, 356, 356, 356, 356, 356, 356,

    356, 356, 356, 356, 356, 356, 356, 356,
    356, 356, 356, 356, 356, 356, 356, 356,
    356, 356, 356, 356, 356, 356, 356, 356,
    391, 391, 356, 356, 356, 356, 356, 391,

    353, 356, 354, 355, 355, 355, 355, 355,
    355, 355, 355, 355, 356, 355, 356, 392,
    356, 356, 355, 353, 393, 355, 394, 394,
    394, 394, 394, 394, 394, 395, 396, 394,

    394, 394, 394, 397, 394, 398, 398, 394,
    394, 396, 397, 394, 394, 397, 399, 399,
    400, 401, 402, 403, 404, 405, 406, 407,
    408, 409, 391, 391, 391, 410, 410, 411,

    412, 412, 412, 413, 413, 413, 413, 413,
    413, 413, 413, 413, 413, 413, 348, 414,
    415, 416, 417, 417, 417, 415, 415, 415,
    415, 415, 417, 417, 417, 417, 415, 417,

    417, 417, 417, 417, 417, 417, 417, 417,
    415, 417, 415, 417, 415, 418, 418, 419,
    420, 421, 420, 420, 421, 420, 420, 421,
    421, 421, 420, 421, 421, 420, 421, 420,

    420, 420, 421, 420, 421, 420, 421, 420,
    421, 420, 420, 348, 348, 419, 418, 418,
    422, 422, 422, 422, 422, 422, 422, 422,
    422, 423, 423, 423, 422, 422, 422, 422,

    422, 422, 422, 422, 422, 422, 422, 422,
    422, 422, 422, 423, 423, 422, 357, 357,
    357, 424, 357, 424, 424, 357, 357, 357,
    424, 424, 357, 357, 357, 357, 357, 357,

    425, 425, 425, 425, 425, 425, 425, 425,
    425, 425, 425, 425, 425, 425, 425, 425,
    425, 425, 425, 425, 425, 425, 425, 425,
    425, 425, 425, 425, 425, 425, 425, 425,

    425, 425, 425, 425, 425, 425, 426, 426,
    426, 426, 426, 426, 426, 426, 426, 426,
    426, 427, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,

    428, 429, 430, 431, 432, 433, 434, 435,
    436, 437, 438, 438, 438, 438, 438, 438,
    438, 438, 438, 438, 438, 438, 438, 438,
    438, 438, 438, 438, 438, 438, 438, 438,

    438, 438, 438, 438, 438, 438, 438, 438,
    438, 438, 438, 439, 439, 439, 439, 439,
    439, 439, 440, 439, 441, 441, 442, 443,
    444, 445, 446, 301, 301, 447, 448, 448,

    449, 449, 449, 449, 449, 449, 449, 449,
    449, 449, 449, 449, 449, 449, 449, 449,
    449, 449, 449, 449, 449, 449, 450, 450,
    450, 450, 451, 450, 450, 450, 450, 450,

    450, 450, 450, 450, 451, 450, 450, 450,
    451, 450, 450, 450, 450, 450, 301, 301,
    452, 452, 452, 452, 452, 452, 452, 453,
    452, 453, 452, 452, 452, 453, 453, 301,

    454, 455, 455, 455, 455, 455, 454, 454,
    455, 454, 455, 455, 455, 455, 455, 455,
    455, 455, 455, 455, 454, 455, 454, 454,
    454, 456, 456, 456, 301, 301, 457, 301,

    458, 459, 458, 458, 458, 458, 459, 460,
    458, 460, 460, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    461, 462, 461, 461, 461, 461, 461, 461,
    461, 461, 463, 463, 463, 464, 465, 462,
    462, 465, 465, 466, 466, 348, 467, 467,
    467, 468, 467, 467, 467, 467, 469, 469,

    469, 469, 469, 469, 469, 469, 469, 469,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 470, 471, 471, 471, 471,
    471, 471, 471, 471, 471, 471, 471, 471,

    471, 471, 472, 473, 474, 474, 475, 474,
    474, 475, 474, 474, 474, 475, 475, 475,
    476, 477, 478, 474, 474, 474, 475, 474,
    474, 475, 475, 474, 474, 474, 474, 479,

    480, 481, 481, 482, 483, 484, 484, 484,
    484, 484, 484, 484, 484, 484, 484, 484,
    484, 484, 484, 484, 484, 484, 484, 484,
    484, 484, 484, 484, 484, 484, 484, 484,

    484, 484, 484, 484, 484, 484, 484, 484,
    484, 485, 484, 484, 484, 484, 484, 484,
    484, 485, 484, 484, 485, 484, 484, 484,
    484, 484, 486, 487, 488, 484, 482, 482,

    482, 481, 481, 481, 481, 481, 481, 481,
    481, 482, 482, 482, 482, 489, 490, 487,
    484, 173, 175, 173, 173, 480, 486, 486,
    491, 491, 491, 491, 491, 491, 491, 491,

    484, 484, 481, 481, 492, 492, 493, 494,
    495, 496, 497, 498, 499, 500, 501, 502,
    503, 504, 505, 506, 506, 506, 506, 506,
    507, 508, 508, 509, 509, 510, 509, 509,

    511, 512, 513, 513, 202, 514, 514, 514,
    514, 514, 514, 514, 514, 202, 202, 514,
    514, 202, 202, 514, 514, 514, 514, 514,
    514, 514, 514, 514, 514, 514, 514, 514,

    514, 514, 514, 514, 514, 514, 514, 514,
    514, 202, 514, 514, 514, 514, 514, 514,
    514, 202, 514, 202, 202, 202, 514, 514,
    514, 514, 202, 202, 515, 516, 517, 513,

    513, 512, 512, 512, 512, 202, 202, 513,
    513, 202, 202, 518, 518, 519, 520, 202,
    202, 202, 202, 202, 202, 202, 202, 517,
    202, 202, 202, 202, 521, 521, 202, 521,

    514, 514, 512, 512, 202, 202, 522, 523,
    524, 525, 526, 527, 528, 529, 530, 531,
    514, 514, 532, 532, 533, 533, 533, 533,
    533, 534, 535, 536, 537, 538, 539, 202,

    202, 540, 541, 542, 202, 543, 543, 543,
    543, 543, 543, 202, 202, 202, 202, 543,
    543, 202, 202, 543, 543, 543, 543, 543,
    543, 543, 543, 543, 543, 543, 543, 543,

    543, 543, 543, 543, 543, 543, 543, 543,
    543, 202, 543, 543, 543, 543, 543, 543,
    543, 202, 543, 544, 202, 543, 544, 202,
    543, 543, 202, 202, 545, 202, 546, 546,

    546, 541, 541, 202, 202, 202, 202, 541,
    541, 202, 202, 541, 541, 547, 202, 202,
    202, 548, 202, 202, 202, 202, 202, 202,
    202, 544, 544, 544, 543, 202, 544, 202,

    202, 202, 202, 202, 202, 202, 549, 550,
    551, 552, 553, 554, 555, 556, 557, 558,
    541, 541, 543, 543, 543, 548, 559, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 560, 560, 561, 202, 562, 562, 562,
    562, 562, 562, 562, 563, 562, 202, 562,
    562, 562, 202, 562, 562, 562, 562, 562,
    562, 562, 562, 562, 562, 562, 562, 562,

    562, 562, 562, 562, 562, 562, 562, 562,
    562, 202, 562, 562, 562, 562, 562, 562,
    562, 202, 562, 562, 202, 562, 562, 562,
    562, 562, 202, 202, 564, 562, 561, 561,

    561, 560, 560, 560, 560, 560, 202, 560,
    560, 561, 202, 561, 561, 565, 202, 202,
    562, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    562, 563, 566, 566, 202, 202, 567, 568,
    569, 570, 571, 572, 573, 574, 575, 576,
    577, 578, 202, 202, 202, 202, 202, 202,
    202, 579, 580, 580, 580, 580, 580, 580,

    202, 581, 582, 582, 202, 583, 583, 583,
    583, 583, 583, 583, 583, 202, 202, 583,
    583, 202, 202, 583, 583, 583, 583, 583,
    583, 583, 583, 583, 583, 583, 583, 583,

    583, 583, 583, 583, 583, 583, 583, 583,
    583, 202, 583, 583, 583, 583, 583, 583,
    583, 202, 583, 583, 202, 584, 583, 583,
    583, 583, 202, 202, 585, 583, 586, 581,

    582, 581, 581, 581, 587, 202, 202, 582,
    588, 202, 202, 588, 588, 589, 202, 202,
    202, 202, 202, 202, 202, 590, 591, 586,
    202, 202, 202, 202, 592, 592, 202, 583,

    583, 583, 587, 587, 202, 202, 593, 594,
    595, 596, 597, 598, 599, 600, 601, 602,
    603, 584, 604, 604, 604, 604, 604, 604,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 605, 606, 202, 606, 606, 606,
    606, 606, 606, 202, 202, 202, 606, 606,
    606, 202, 606, 606, 607, 606, 202, 202,
    202, 606, 606, 202, 606, 202, 606, 606,

    202, 202, 202, 606, 606, 202, 202, 202,
    606, 606, 606, 202, 202, 202, 606, 606,
    606, 606, 606, 606, 606, 606, 608, 606,
    606, 606, 202, 202, 202, 202, 609, 610,

    605, 610, 610, 202, 202, 202, 610, 610,
    610, 202, 611, 611, 611, 612, 202, 202,
    613, 202, 202, 202, 202, 202, 202, 609,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 614, 615,
    616, 617, 618, 619, 620, 621, 622, 623,
    624, 624, 624, 625, 625, 625, 625, 625,
    625, 626, 625, 202, 202, 202, 202, 202,

    627, 628, 628, 628, 629, 630, 630, 630,
    630, 630, 630, 630, 630, 202, 630, 630,
    630, 202, 630, 630, 630, 630, 630, 630,
    630, 630, 630, 630, 630, 630, 630, 630,

    630, 630, 630, 630, 630, 630, 630, 630,
    630, 202, 630, 630, 630, 630, 630, 630,
    630, 630, 630, 630, 631, 630, 630, 630,
    630, 630, 202, 202, 202, 632, 633, 633,

    633, 628, 628, 628, 628, 202, 633, 633,
    634, 202, 633, 633, 633, 635, 202, 202,
    202, 202, 202, 202, 202, 636, 637, 202,
    632, 632, 638, 202, 202, 202, 202, 202,

    630, 630, 639, 639, 202, 202, 640, 641,
    642, 643, 644, 645, 646, 647, 648, 649,
    202, 202, 202, 202, 202, 202, 202, 650,
    651, 651, 651, 651, 651, 651, 651, 652,

    653, 654, 655, 655, 656, 657, 657, 657,
    657, 657, 657, 657, 657, 202, 657, 657,
    657, 202, 657, 657, 657, 657, 657, 657,
    657, 657, 657, 657, 657, 657, 657, 657,

    657, 657, 657, 657, 657, 657, 657, 657,
    657, 202, 657, 657, 657, 657, 657, 657,
    657, 657, 657, 657, 202, 657, 657, 657,
    657, 657, 202, 202, 658, 659, 655, 660,

    661, 655, 662, 655, 655, 202, 660, 661,
    661, 202, 661, 661, 663, 664, 202, 202,
    202, 202, 202, 202, 202, 662, 662, 202,
    202, 202, 202, 202, 202, 202, 657, 202,

    657, 657, 665, 665, 202, 202, 666, 667,
    668, 669, 670, 671, 672, 673, 674, 675,
    202, 676, 676, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    677, 678, 679, 679, 680, 681, 681, 681,
    681, 681, 681, 681, 681, 202, 681, 681,
    681, 202, 681, 681, 681, 681, 681, 681,
    681, 681, 681, 681, 681, 681, 681, 681,

    681, 681, 681, 681, 681, 681, 681, 681,
    681, 682, 681, 681, 681, 681, 681, 681,
    681, 681, 681, 681, 681, 681, 681, 681,
    681, 681, 682, 683, 683, 684, 685, 679,

    679, 686, 686, 686, 687, 202, 679, 679,
    679, 202, 688, 688, 688, 689, 690, 691,
    202, 202, 202, 202, 692, 692, 692, 685,
    693, 693, 693, 693, 693, 693, 693, 694,

    681, 681, 687, 687, 202, 202, 695, 696,
    697, 698, 699, 700, 701, 702, 703, 704,
    705, 705, 705, 705, 705, 705, 693, 693,
    693, 706, 684, 684, 684, 684, 684, 684,

    202, 707, 708, 708, 202, 709, 709, 709,
    709, 709, 709, 709, 709, 709, 709, 709,
    709, 709, 709, 709, 709, 709, 709, 202,
    202, 202, 709, 709, 709, 709, 709, 709,

    709, 709, 709, 709, 709, 709, 709, 709,
    709, 709, 709, 709, 709, 709, 709, 709,
    709, 709, 202, 709, 709, 709, 709, 709,
    709, 709, 709, 709, 202, 709, 202, 202,

    709, 709, 709, 709, 709, 709, 709, 202,
    202, 202, 710, 202, 202, 202, 202, 711,
    708, 708, 712, 712, 712, 202, 712, 202,
    708, 708, 713, 708, 713, 713, 713, 711,

    202, 202, 202, 202, 202, 202, 714, 715,
    716, 717, 718, 719, 720, 721, 722, 723,
    202, 202, 708, 708, 724, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 725, 725, 725, 725, 725, 725, 725,
    725, 725, 725, 725, 725, 725, 725, 725,
    725, 725, 725, 725, 725, 725, 725, 725,
    725, 725, 725, 725, 725, 725, 725, 725,

    725, 725, 725, 725, 725, 725, 725, 725,
    725, 725, 725, 725, 725, 725, 725, 725,
    725, 726, 725, 727, 726, 726, 726, 726,
    728, 728, 729, 202, 202, 202, 202, 12,

    725, 725, 725, 725, 725, 725, 730, 726,
    731, 731, 731, 731, 726, 726, 726, 732,
    733, 734, 735, 736, 737, 738, 739, 740,
    741, 742, 743, 743, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 744, 744, 202, 744, 202, 745, 744,
    744, 745, 744, 202, 745, 744, 745, 745,
    745, 745, 745, 745, 744, 744, 744, 744,
    745, 744, 744, 744, 744, 744, 744, 744,

    745, 744, 744, 744, 202, 744, 202, 744,
    745, 745, 744, 744, 745, 744, 744, 744,
    744, 746, 744, 747, 746, 746, 746, 746,
    748, 748, 749, 746, 746, 744, 202, 202,

    744, 744, 744, 744, 744, 202, 750, 202,
    751, 751, 751, 751, 746, 746, 202, 202,
    752, 753, 754, 755, 756, 757, 758, 759,
    760, 761, 202, 202, 762, 762, 763, 763,

    764, 765, 765, 765, 766, 767, 766, 766,
    768, 766, 766, 769, 770, 771, 771, 771,
    771, 771, 768, 772, 771, 772, 772, 772,
    773, 773, 772, 772, 772, 772, 772, 772,

    774, 775, 776, 777, 778, 779, 780, 781,
    782, 783, 784, 784, 784, 784, 784, 784,
    784, 784, 784, 784, 785, 773, 772, 773,
    772, 786, 787, 788, 787, 788, 789, 789,

    764, 764, 764, 790, 764, 764, 764, 764,
    202, 764, 764, 764, 764, 790, 764, 764,
    764, 764, 790, 764, 764, 764, 764, 790,
    764, 764, 764, 764, 790, 764, 764, 764,

    764, 764, 764, 764, 764, 764, 764, 764,
    764, 790, 791, 792, 792, 202, 202, 202,
    202, 793, 794, 795, 796, 795, 795, 797,
    795, 797, 794, 794, 794, 794, 798, 799,

    794, 795, 800, 800, 801, 769, 800, 800,
    764, 764, 764, 764, 802, 803, 803, 803,
    798, 798, 798, 795, 798, 798, 804, 798,
    202, 798, 798, 798, 798, 795, 798, 798,

    798, 798, 795, 798, 798, 798, 798, 795,
    798, 798, 798, 798, 795, 798, 804, 804,
    804, 798, 798, 798, 798, 798, 798, 798,
    804, 795, 804, 804, 804, 202, 805, 805,

    806, 806, 806, 806, 806, 806, 807, 806,
    806, 806, 806, 806, 806, 202, 808, 806,
    809, 809, 810, 811, 812, 813, 813, 813,
    813, 814, 814, 202, 202, 202, 202, 202,

    815, 815, 815, 815, 815, 815, 815, 815,
    815, 815, 815, 815, 815, 815, 815, 815,
    815, 815, 815, 815, 815, 815, 815, 815,
    815, 815, 815, 815, 815, 815, 815, 815,

    815, 815, 816, 815, 815, 815, 817, 815,
    816, 815, 815, 818, 819, 820, 821, 820,
    820, 822, 820, 823, 823, 823, 820, 824,
    819, 825, 826, 827, 827, 823, 823, 816,

    828, 829, 830, 831, 832, 833, 834, 835,
    836, 837, 838, 838, 839, 839, 839, 839,
    815, 815, 815, 815, 815, 815, 822, 822,
    820, 820, 816, 816, 816, 816, 823, 823,

    823, 816, 818, 818, 818, 816, 816, 818,
    818, 818, 818, 818, 818, 818, 816, 816,
    816, 823, 823, 823, 823, 816, 816, 816,
    816, 816, 816, 816, 816, 816, 816, 816,

    816, 816, 823, 818, 827, 823, 823, 818,
    818, 818, 818, 818, 818, 840, 816, 818,
    841, 842, 843, 844, 845, 846, 847, 848,
    849, 850, 851, 851, 851, 852, 853, 853,

    854, 854, 854, 854, 854, 854, 854, 854,
    854, 854, 854, 854, 854, 854, 854, 854,
    854, 854, 854, 854, 854, 854, 854, 854,
    854, 854, 854, 854, 854, 854, 854, 854,

    854, 854, 854, 854, 854, 854, 202, 855,
    202, 202, 202, 202, 202, 855, 202, 202,
    856, 856, 856, 856, 856, 856, 856, 856,
    856, 856, 856, 856, 856, 856, 856, 856,

    856, 856, 856, 856, 856, 856, 856, 856,
    856, 856, 856, 856, 856, 856, 856, 856,
    856, 856, 856, 856, 856, 856, 856, 857,
    857, 858, 858, 859, 860, 861, 861, 861,

    862, 862, 862, 862, 862, 862, 862, 862,
    862, 862, 862, 862, 862, 862, 862, 862,
    862, 862, 862, 862, 862, 862, 862, 862,
    862, 862, 862, 862, 862, 862, 862, 862,

    862, 862, 862, 862, 862, 862, 862, 862,
    862, 862, 862, 862, 862, 862, 862, 862,
    862, 862, 862, 862, 862, 862, 862, 862,
    862, 862, 863, 863, 863, 863, 863, 862,

    864, 865, 865, 865, 865, 865, 865, 865,
    865, 865, 865, 865, 865, 865, 865, 865,
    865, 865, 865, 865, 865, 865, 864, 864,
    864, 864, 864, 864, 864, 864, 864, 864,

    864, 864, 864, 864, 864, 864, 864, 864,
    864, 864, 864, 864, 864, 864, 864, 864,
    864, 864, 864, 864, 864, 864, 864, 864,
    864, 864, 864, 864, 864, 864, 864, 864,

    864, 864, 864, 866, 866, 866, 866, 866,
    867, 867, 867, 867, 867, 867, 867, 867,
    867, 867, 867, 867, 867, 867, 867, 867,
    867, 867, 867, 867, 867, 867, 867, 867,

    867, 867, 867, 868, 868, 868, 868, 868,
    868, 868, 868, 868, 868, 868, 868, 868,
    868, 868, 868, 868, 868, 868, 868, 868,
    868, 868, 868, 868, 868, 868, 868, 868,

    868, 868, 868, 868, 868, 868, 868, 868,
    868, 868, 868, 868, 868, 868, 868, 868,
    868, 868, 868, 868, 868, 868, 868, 868,
    868, 868, 869, 869, 869, 869, 869, 869,

    870, 870, 870, 870, 870, 870, 870, 871,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,

    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,

    870, 870, 870, 870, 870, 870, 870, 871,
    870, 202, 870, 870, 870, 870, 202, 202,
    870, 870, 870, 870, 870, 870, 870, 202,
    870, 202, 870, 870, 870, 870, 202, 202,

    870, 870, 870, 870, 870, 870, 870, 871,
    870, 202, 870, 870, 870, 870, 202, 202,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,

    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 871,
    870, 202, 870, 870, 870, 870, 202, 202,
    870, 870, 870, 870, 870, 870, 870, 202,

    870, 202, 870, 870, 870, 870, 202, 202,
    870, 870, 870, 870, 870, 870, 870, 871,
    870, 870, 870, 870, 870, 870, 870, 202,
    870, 870, 870, 870, 870, 870, 870, 870,

    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 871,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,

    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 871,
    870, 202, 870, 870, 870, 870, 202, 202,
    870, 870, 870, 870, 870, 870, 870, 871,

    870, 870, 870, 870, 870, 870, 870, 871,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 202, 202, 872, 872, 873,

    874, 875, 876, 877, 877, 877, 877, 876,
    876, 878, 879, 880, 881, 882, 883, 884,
    885, 886, 887, 887, 887, 887, 887, 887,
    887, 887, 887, 887, 887, 202, 202, 202,

    871, 871, 871, 871, 871, 871, 871, 871,
    871, 871, 871, 871, 871, 871, 871, 871,
    888, 888, 888, 888, 888, 888, 888, 888,
    888, 888, 202, 202, 202, 202, 202, 202,

    889, 890, 891, 892, 893, 894, 895, 896,
    897, 898, 899, 900, 901, 902, 903, 904,
    905, 906, 907, 908, 909, 910, 911, 912,
    913, 914, 915, 916, 917, 918, 919, 920,

    921, 922, 923, 924, 925, 926, 927, 928,
    929, 930, 931, 932, 933, 934, 935, 936,
    937, 938, 939, 940, 941, 942, 943, 944,
    945, 946, 947, 948, 949, 950, 951, 952,

    953, 954, 955, 956, 957, 958, 959, 960,
    961, 962, 963, 964, 965, 966, 967, 968,
    969, 969, 969, 969, 969, 970, 202, 202,
    971, 971, 971, 971, 971, 971, 202, 202,

    972, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 973, 973, 973,

    973, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 973, 973, 973,

    973, 973, 973, 973, 973, 973, 973, 973,
    973, 973, 973, 973, 973, 974, 975, 973,
    973, 973, 973, 973, 973, 973, 973, 976,
    976, 976, 976, 976, 976, 976, 976, 976,

    977, 978, 978, 978, 978, 978, 978, 978,
    978, 978, 978, 978, 978, 978, 978, 978,
    978, 978, 978, 978, 978, 978, 978, 978,
    978, 978, 978, 979, 980, 202, 202, 202,

    981, 981, 981, 981, 981, 981, 981, 981,
    981, 981, 981, 981, 981, 981, 981, 981,
    981, 981, 981, 981, 981, 981, 981, 981,
    981, 981, 981, 981, 981, 981, 981, 981,

    981, 981, 981, 981, 981, 981, 981, 981,
    981, 981, 981, 982, 982, 982, 983, 983,
    983, 984, 984, 984, 984, 984, 984, 984,
    984, 202, 202, 202, 202, 202, 202, 202,

    985, 985, 985, 985, 985, 985, 985, 985,
    985, 985, 985, 985, 985, 202, 985, 985,
    985, 985, 986, 986, 987, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    988, 988, 988, 988, 988, 988, 988, 988,
    988, 988, 988, 988, 988, 988, 988, 988,
    988, 988, 989, 989, 990, 991, 991, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    992, 992, 992, 992, 992, 992, 992, 992,
    992, 992, 992, 992, 992, 992, 992, 992,
    992, 992, 993, 993, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    994, 994, 994, 994, 994, 994, 994, 994,
    994, 994, 994, 994, 994, 202, 994, 994,
    994, 202, 995, 995, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    996, 996, 996, 996, 996, 996, 996, 996,
    996, 996, 996, 996, 996, 996, 996, 996,
    996, 996, 996, 996, 996, 996, 996, 996,
    996, 996, 996, 996, 996, 996, 996, 996,

    996, 996, 996, 996, 996, 996, 996, 996,
    996, 996, 996, 996, 996, 996, 996, 996,
    996, 996, 996, 996, 997, 997, 998, 997,
    997, 997, 997, 997, 997, 997, 998, 998,

    998, 998, 998, 998, 998, 998, 997, 998,
    998, 997, 997, 997, 997, 997, 997, 997,
    997, 997, 999, 997, 1000, 1000, 1001, 1002,
    1000, 1003, 1000, 1004, 996, 1005, 202, 202,

    1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013,
    1014, 1015, 202, 202, 202, 202, 202, 202,
    1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
    1016, 1016, 202, 202, 202, 202, 202, 202,

    1017, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
    1024, 1025, 1026, 1027, 1027, 1027, 1028, 202,
    1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036,
    1037, 1038, 202, 202, 202, 202, 202, 202,

    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,

    1039, 1039, 1039, 1040, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,

    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1041, 202, 202, 202, 202, 202, 202, 202,

    1042, 1042, 1042, 1042, 1042, 1027, 1027, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,

    1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
    1039, 1043, 1044, 202, 202, 202, 202, 202,
    976, 976, 976, 976, 976, 976, 976, 976,
    976, 976, 976, 976, 976, 976, 976, 976,

    976, 976, 976, 976, 976, 976, 976, 976,
    976, 976, 976, 976, 976, 976, 976, 976,
    976, 976, 976, 976, 976, 976, 976, 976,
    976, 976, 976, 976, 976, 976, 976, 976,

    976, 976, 976, 976, 976, 976, 976, 976,
    976, 976, 976, 976, 976, 976, 976, 976,
    976, 976, 976, 976, 976, 976, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1045, 1045, 1045, 1045, 1045, 1045, 1045, 1045,
    1045, 1045, 1045, 1045, 1045, 1045, 1045, 1045,
    1045, 1045, 1045, 1045, 1045, 1045, 1045, 1045,
    1045, 1045, 1045, 1045, 1045, 1046, 1046, 202,

    1047, 1047, 1047, 1048, 1048, 1048, 1048, 1047,
    1047, 1048, 1048, 1048, 202, 202, 202, 202,
    1048, 1048, 1047, 1048, 1048, 1048, 1048, 1048,
    1048, 1049, 1050, 1051, 202, 202, 202, 202,

    1052, 202, 202, 202, 1053, 1053, 1054, 1055,
    1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063,
    1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064,
    1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064,

    1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064,
    1064, 1064, 1064, 1064, 1064, 1064, 202, 202,
    1064, 1064, 1064, 1064, 1064, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,
    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,
    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,
    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,

    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,
    1065, 1065, 1066, 1066, 202, 202, 202, 202,
    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,
    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,

    1065, 1065, 1065, 1065, 1065, 1065, 1065, 1065,
    1065, 1065, 202, 202, 202, 202, 202, 202,
    1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074,
    1075, 1076, 1077, 202, 202, 202, 1078, 1078,

    1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079,
    1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079,
    1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079,
    1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079,

    1080, 1080, 1080, 1080, 1080, 1080, 1080, 1080,
    1080, 1080, 1080, 1080, 1080, 1080, 1080, 1080,
    1080, 1080, 1080, 1080, 1080, 1080, 1080, 1081,
    1082, 1083, 1083, 1084, 202, 202, 1085, 1085,

    1086, 1086, 1086, 1086, 1086, 1086, 1086, 1086,
    1086, 1086, 1086, 1086, 1086, 1086, 1086, 1086,
    1086, 1086, 1086, 1086, 1086, 1086, 1086, 1086,
    1086, 1086, 1086, 1086, 1086, 1086, 1086, 1086,

    1086, 1086, 1086, 1086, 1086, 1086, 1086, 1086,
    1086, 1086, 1086, 1086, 1086, 1086, 1086, 1086,
    1086, 1086, 1086, 1086, 1086, 1087, 1088, 1087,
    1088, 1088, 1088, 1088, 1088, 1088, 1088, 202,

    1089, 1090, 1088, 1090, 1090, 1088, 1088, 1088,
    1088, 1088, 1088, 1088, 1088, 1087, 1087, 1087,
    1087, 1087, 1087, 1088, 1088, 1091, 1091, 1091,
    1091, 1091, 1091, 1091, 1091, 202, 202, 1092,

    1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100,
    1101, 1102, 202, 202, 202, 202, 202, 202,
    1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100,
    1101, 1102, 202, 202, 202, 202, 202, 202,

    1103, 1103, 1103, 1103, 1103, 1103, 1103, 1104,
    1105, 1105, 1105, 1105, 1103, 1103, 202, 202,
    1106, 1106, 1106, 1106, 1106, 1107, 1107, 1107,
    1107, 1107, 1107, 1106, 1106, 1107, 1108, 1109,

    1109, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1110, 1110, 1110, 1110, 1111, 1112, 1113, 1112,
    1113, 1112, 1113, 1112, 1113, 1112, 1113, 1112,
    1112, 1112, 1113, 1112, 1112, 1112, 1112, 1112,
    1112, 1112, 1112, 1112, 1112, 1112, 1112, 1112,

    1112, 1112, 1112, 1112, 1112, 1112, 1112, 1112,
    1112, 1112, 1112, 1112, 1112, 1112, 1112, 1112,
    1112, 1112, 1112, 1112, 1114, 1115, 1110, 1110,
    1110, 1110, 1110, 1116, 1110, 1116, 1111, 1111,

    1116, 1116, 1110, 1116, 1117, 1112, 1112, 1112,
    1112, 1112, 1112, 1112, 202, 202, 202, 202,
    1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125,
    1126, 1127, 1128, 1128, 1129, 1130, 1128, 1128,

    1130, 1131, 1131, 1131, 1131, 1131, 1131, 1131,
    1131, 1131, 1131, 1132, 1133, 1132, 1132, 1132,
    1132, 1132, 1132, 1132, 1131, 1131, 1131, 1131,
    1131, 1131, 1131, 1131, 1131, 202, 202, 202,

    1134, 1134, 1135, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,
    1136, 1136, 1136, 1136, 1136, 1136, 1136, 1136,

    1136, 1135, 1134, 1134, 1134, 1134, 1135, 1135,
    1134, 1134, 1137, 1138, 1139, 1139, 1136, 1136,
    1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147,
    1148, 1149, 1150, 1150, 1150, 1150, 1150, 1150,

    1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
    1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
    1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
    1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151,

    1151, 1151, 1151, 1151, 1151, 1151, 1152, 1153,
    1154, 1154, 1153, 1153, 1153, 1154, 1153, 1154,
    1154, 1154, 1155, 1155, 202, 202, 202, 202,
    202, 202, 202, 202, 1156, 1156, 1156, 1156,

    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
    1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,

    1157, 1157, 1157, 1157, 1158, 1158, 1158, 1158,
    1158, 1158, 1158, 1158, 1159, 1159, 1159, 1159,
    1159, 1159, 1159, 1159, 1158, 1158, 1159, 1160,
    202, 202, 202, 1161, 1161, 1162, 1162, 1162,

    1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170,
    1171, 1172, 202, 202, 202, 1157, 1157, 1157,
    1173, 1174, 1175, 1176, 1177, 1178, 1179, 1180,
    1181, 1182, 1183, 1183, 1183, 1183, 1183, 1183,

    1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183,
    1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183,
    1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183,
    1184, 1184, 1184, 1184, 1184, 1184, 1185, 1185,

    1186, 1187, 1188, 1189, 1189, 1190, 1191, 1192,
    1193, 202, 202, 202, 202, 202, 202, 202,
    1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
    1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,

    1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
    1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
    1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
    1194, 1194, 1194, 202, 202, 1194, 1194, 1194,

    1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
    202, 202, 202, 202, 202, 202, 202, 202,
    1196, 1196, 1196, 1197, 1198, 1199, 1199, 1199,
    1199, 1199, 1196, 1196, 1199, 1199, 1199, 1199,

    1196, 1200, 1198, 1198, 1198, 1198, 1198, 1198,
    1198, 1201, 1201, 1201, 1201, 1199, 1201, 1201,
    1201, 1201, 1201, 1202, 1203, 1202, 1202, 1204,
    1106, 1106, 1205, 202, 202, 202, 202, 202,

    114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114,

    114, 114, 114, 114, 114, 114, 1206, 1206,
    1206, 1206, 1206, 1207, 1208, 1208, 1208, 1209,
    1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208,
    1208, 1208, 1208, 1209, 1208, 1208, 1208, 1208,

    1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208,
    1208, 1208, 1208, 1208, 1208, 1208, 1209, 1208,
    1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208,
    1208, 1208, 1208, 1208, 1208, 1210, 1210, 1210,

    1210, 1210, 1208, 1208, 1208, 1208, 1210, 1210,
    1210, 1210, 1210, 114, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    1211, 1212, 115, 115, 115, 1213, 115, 115,

    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 1214, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 1215, 1215, 1215, 1215, 1215,

    1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
    1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
    1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
    1215, 1215, 1215, 1215, 1215, 1215, 1215, 1216,

    191, 191, 190, 191, 1217, 1217, 1217, 1217,
    1217, 1217, 1218, 1219, 1219, 1220, 1221, 1222,
    1223, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
    1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,

    1219, 1219, 1219, 1219, 1219, 1219, 1219, 1106,
    1106, 1106, 1106, 1106, 1106, 1106, 1106, 1106,
    1106, 1106, 1106, 1106, 1106, 1106, 1224, 1225,
    1225, 1226, 202, 1227, 1228, 1199, 1217, 1218,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 1229, 1230,
    1231, 1232, 1233, 1234, 1235, 1235, 1236, 1235,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 1237, 1238, 1237, 1238, 1237, 1238,

    1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239,
    1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240,
    1239, 1239, 1239, 1239, 1239, 1239, 202, 202,
    1240, 1240, 1240, 1240, 1240, 1240, 202, 202,

    1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239,
    1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240,
    1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239,
    1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240,

    1239, 1239, 1239, 1239, 1239, 1239, 202, 202,
    1240, 1240, 1240, 1240, 1240, 1240, 202, 202,
    1241, 1239, 1242, 1239, 1243, 1239, 1244, 1239,
    202, 1240, 202, 1240, 202, 1240, 202, 1240,

    1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239,
    1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240,
    1245, 1246, 1247, 1248, 1247, 1248, 1249, 1250,
    1251, 1252, 1253, 1254, 1255, 1256, 202, 202,

    1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264,
    1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272,
    1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280,
    1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288,

    1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296,
    1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304,
    1239, 1239, 1305, 1306, 1307, 202, 1308, 1309,
    1240, 1240, 1310, 1311, 1312, 207, 1313, 207,

    207, 1314, 1315, 1316, 1317, 202, 1318, 1319,
    1320, 1321, 1320, 1321, 1322, 1314, 1314, 1314,
    1239, 1239, 1323, 1324, 202, 202, 1325, 1326,
    1240, 1240, 1327, 1328, 202, 1314, 1314, 1314,

    1239, 1239, 1329, 1330, 1331, 1332, 1333, 1334,
    1240, 1240, 1335, 1336, 1337, 1314, 1338, 1338,
    202, 202, 1339, 1340, 1341, 202, 1342, 1343,
    1344, 1345, 1346, 1347, 1348, 1349, 207, 202,

    1350, 1350, 1351, 1351, 1351, 1351, 1351, 1352,
    1351, 1351, 1351, 1353, 1354, 1355, 1356, 1357,
    1358, 1359, 1358, 1360, 1361, 1362, 14, 1363,
    1364, 1365, 1366, 1367, 1367, 1368, 1366, 1367,

    14, 14, 14, 14, 1369, 1370, 1370, 1371,
    1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379,
    13, 13, 13, 1380, 1380, 1381, 1382, 1382,
    14, 1383, 1384, 14, 1385, 1386, 1363, 43,

    43, 14, 14, 14, 1387, 16, 1388, 1389,
    1390, 1390, 1391, 1391, 1391, 1391, 1392, 1392,
    1392, 1392, 1393, 1394, 1395, 1396, 1397, 1398,
    1397, 1397, 1397, 1397, 1396, 1397, 1397, 1399,

    1400, 1401, 1401, 1401, 1402, 1403, 1404, 1405,
    1406, 1407, 1408, 1408, 1408, 1408, 1408, 1408,
    1409, 1410, 202, 202, 1411, 1412, 1413, 1414,
    1415, 1416, 1417, 1417, 1418, 1419, 1420, 160,

    1409, 63, 58, 59, 1411, 1412, 1413, 1414,
    1415, 1416, 1417, 1417, 1418, 1419, 1420, 202,
    1215, 1215, 1215, 1215, 1215, 1421, 1421, 1421,
    1421, 1421, 1421, 1421, 1421, 202, 202, 202,

    12, 12, 12, 12, 12, 12, 12, 50,
    1422, 12, 12, 1423, 1424, 1425, 1425, 1425,
    1426, 1426, 1427, 1427, 1427, 1427, 1428, 1429,
    1429, 1430, 1431, 1432, 1433, 1433, 1434, 1435,

    1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
    1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
    173, 173, 180, 180, 173, 173, 173, 173,
    180, 180, 180, 173, 173, 1437, 1437, 1437,

    1437, 173, 1438, 1438, 1439, 1440, 1440, 197,
    1441, 197, 1440, 1442, 1218, 1218, 1218, 1218,
    1219, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1443, 1443, 1444, 1445, 51, 1443, 1443, 1444,
    51, 1445, 1446, 1444, 1444, 1444, 1446, 1446,
    1444, 1444, 1444, 1446, 51, 1444, 1447, 51,
    36, 1444, 1444, 1444, 1444, 1444, 51, 51,

    1443, 1443, 1443, 51, 1444, 51, 1448, 51,
    1444, 51, 1449, 1450, 1444, 1444, 1451, 1446,
    1444, 1444, 1452, 1444, 1446, 1453, 1453, 1453,
    1453, 1454, 1455, 1456, 1457, 1458, 1459, 1459,

    1460, 1393, 1393, 1393, 1393, 1459, 1458, 1458,
    1458, 1458, 1461, 1393, 1462, 1463, 1464, 1465,
    1466, 1466, 1466, 65, 65, 65, 65, 65,
    65, 65, 65, 65, 65, 65, 65, 65,

    1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
    1467, 1467, 1467, 1467, 1467, 1467, 1467, 1467,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468,

    1469, 1469, 1469, 111, 123, 1470, 1470, 1470,
    1470, 1466, 1471, 1471, 202, 202, 202, 202,
    36, 36, 36, 36, 36, 51, 51, 51,
    51, 51, 1472, 1472, 51, 51, 51, 51,

    36, 51, 51, 36, 51, 51, 36, 51,
    51, 51, 51, 51, 51, 51, 1472, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 1473, 1472, 1472,
    51, 51, 36, 51, 36, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 1455, 1455, 1455, 1455, 1455,
    1455, 1455, 1455, 1455, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    36, 36, 36, 36, 1472, 36, 36, 36,
    1474, 1475, 1474, 1476, 1477, 1476, 36, 36,
    36, 36, 18, 57, 36, 1478, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 1479,

    1480, 1481, 1482, 36, 1483, 36, 1472, 36,
    36, 36, 36, 36, 1418, 1418, 36, 1418,
    1418, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 1484, 1485, 36, 36,

    36, 1472, 36, 1486, 1472, 1487, 36, 1472,
    36, 1472, 36, 36, 1488, 36, 36, 36,
    36, 36, 1484, 1485, 1484, 1485, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36,

    1472, 36, 1472, 36, 1484, 1485, 1484, 1485,
    1484, 1485, 1484, 1485, 36, 1472, 1489, 1490,
    1489, 1490, 1484, 1485, 1489, 1490, 1484, 1485,
    1489, 1490, 1484, 1485, 1484, 1485, 1484, 1485,

    1489, 1490, 1484, 1485, 1489, 1490, 1484, 1485,
    1489, 1490, 1484, 1485, 36, 36, 36, 1484,
    1485, 1484, 1485, 36, 36, 36, 36, 36,
    1491, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 1484, 1485, 36, 36, 1492, 36,
    1493, 1494, 36, 1494, 1472, 1472, 1472, 1472,
    1484, 1485, 1484, 1485, 1484, 1485, 1484, 1485,
    1495, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 36, 36, 36, 36, 36, 36,
    36, 1484, 1485, 1484, 1485, 1496, 36, 36,
    1484, 1485, 36, 36, 36, 36, 1484, 1485,
    1484, 1485, 1484, 1485, 1484, 1485, 1484, 1485,

    1489, 1490, 1489, 1490, 1484, 1485, 1484, 1485,
    1484, 1485, 1489, 1490, 1489, 1490, 36, 1497,
    1484, 1485, 1498, 1498, 1498, 1393, 1499, 1499,
    1393, 1393, 1500, 1500, 1500, 1501, 1501, 1393,

    51, 1455, 51, 51, 51, 51, 51, 51,
    16, 1388, 16, 1388, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 1502, 1502, 51, 51, 51, 51,

    36, 36, 51, 51, 51, 51, 51, 51,
    51, 1503, 1504, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,

    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,

    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1505, 1505, 1505,
    1505, 1505, 1505, 1455, 1393, 1455, 1455, 1455,

    1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455,
    1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455,
    1455, 1455, 1455, 1455, 1455, 1506, 1455, 1455,
    1455, 1455, 1455, 1393, 1393, 1393, 1393, 1393,

    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1461, 1461, 1461, 1461,
    1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,

    1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
    1461, 1461, 1461, 1461, 1461, 1461, 1461, 1507,
    1507, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1508, 1508, 1508, 1508,

    1508, 1508, 1463, 1463, 1463, 1463, 1463, 1463,
    1509, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1511, 1511, 1511, 1511, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1513, 1513, 1513, 1513, 1514,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 1455, 1455, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1515, 1516, 1517, 1518, 1519, 1520, 1521, 1522,
    1523, 65, 65, 65, 65, 65, 65, 65,
    65, 65, 65, 65, 1515, 1516, 1517, 1518,
    1519, 1520, 1521, 1522, 1523, 65, 65, 65,

    65, 65, 65, 65, 65, 65, 65, 65,
    63, 58, 59, 1411, 1412, 1413, 1414, 1415,
    1416, 1524, 1524, 1524, 1524, 1524, 1524, 1524,
    1524, 1524, 1524, 1524, 1525, 1525, 1525, 1525,

    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1526, 1526,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,

    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527,
    1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527,

    1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527,
    1527, 1527, 1528, 1529, 1529, 1529, 1529, 1529,
    1529, 1529, 1529, 1529, 1529, 1530, 1531, 1532,
    1533, 1534, 1535, 1536, 1537, 1538, 1529, 1539,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 1461, 1461,
    1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 36,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 36, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    1502, 1502, 1502, 1502, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 1540, 1540, 1461, 1461,
    1541, 1455, 1502, 1502, 1502, 1542, 1502, 1502,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 1502, 1502, 1502, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    1502, 51, 51, 51, 51, 51, 51, 36,
    1455, 1455, 1461, 1461, 1461, 1461, 1461, 1461,
    1461, 1461, 1461, 1461, 1461, 1461, 1462, 1541,

    1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
    1461, 1461, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1543, 1509, 1509,

    1507, 1507, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1544, 1462, 1462, 1462,
    1462, 1462, 1463, 1543, 1543, 1543, 1543, 1543,
    1543, 1543, 1543, 1543, 1543, 1545, 1545, 1545,

    1546, 1546, 1546, 1546, 1545, 1545, 1545, 1545,
    1545, 1509, 1509, 1509, 1509, 1545, 1510, 1545,
    1545, 1545, 1509, 1545, 1545, 1509, 1509, 1509,
    1545, 1545, 1509, 1509, 1545, 1509, 1509, 1545,

    1545, 1545, 1510, 1509, 1510, 1510, 1510, 1510,
    1509, 1509, 1545, 1509, 1509, 1509, 1509, 1509,
    1509, 1545, 1545, 1545, 1545, 1545, 1509, 1545,
    1545, 1547, 1545, 1509, 1509, 1545, 1545, 1545,

    1548, 1502, 1502, 1502, 1502, 1510, 51, 51,
    1502, 1502, 1549, 1549, 1542, 1542, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    1510, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 1510, 51, 1510, 51,
    51, 51, 51, 1510, 1510, 1510, 51, 1509,
    51, 51, 51, 1550, 1550, 1550, 1550, 1551,

    1551, 51, 1552, 1552, 1502, 51, 51, 51,
    1553, 1554, 1553, 1554, 1553, 1554, 1553, 1554,
    1553, 1554, 1553, 1554, 1553, 1554, 1555, 1556,
    1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564,

    1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562,
    1563, 1564, 1555, 1556, 1557, 1558, 1559, 1560,
    1561, 1562, 1563, 1564, 51, 1510, 1510, 1510,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    1510, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 1510,

    1565, 1565, 1565, 1566, 1567, 1568, 1569, 1508,
    1570, 1571, 1508, 1572, 1573, 1574, 1575, 1575,
    1393, 1393, 1393, 1393, 1393, 1576, 1577, 1393,
    1393, 1393, 1393, 1393, 1578, 1576, 1577, 1393,

    1393, 1393, 1576, 1577, 1576, 1577, 1553, 1554,
    1553, 1554, 1553, 1554, 1579, 1580, 1579, 1580,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,

    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    1393, 1393, 1393, 1553, 1554, 1553, 1554, 1553,
    1554, 1553, 1554, 1553, 1554, 1582, 1583, 1584,
    1585, 1553, 1554, 1553, 1554, 1553, 1554, 1553,
    1554, 1393, 1393, 1586, 1393, 1393, 1393, 1393,

    1587, 1393, 1393, 1588, 1576, 1577, 1393, 1393,
    1576, 1577, 1576, 1577, 1576, 1577, 1576, 1577,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1589, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    1576, 1577, 1393, 1393, 1576, 1577, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1576,
    1577, 1576, 1577, 1393, 1576, 1577, 1393, 1393,
    1553, 1554, 1553, 1554, 1393, 1393, 1393, 1393,

    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1576, 1577, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1590, 1393, 1393,
    1576, 1577, 1393, 1393, 1553, 1554, 1393, 1393,

    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1460, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1576, 1577, 1576, 1577, 1393,
    1393, 1393, 1393, 1393, 1576, 1577, 1393, 1393,
    1393, 1393, 1393, 1393, 1576, 1577, 1393, 1393,

    1393, 1393, 1393, 1393, 1576, 1577, 1393, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
    1393, 1393, 1393, 1393, 1460, 1460, 1460, 1393,
    1393, 1576, 1577, 1576, 1577, 1576, 1577, 1576,

    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,

    1577, 1576, 1577, 1393, 1393, 1393, 1576, 1577,
    1576, 1577, 1576, 1577, 1576, 1577, 1393, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,

    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1576,
    1577, 1576, 1577, 1576, 1577, 1576, 1577, 1393,
    1393, 1393, 1393, 1393, 1591, 1393, 1592, 1393,

    1393, 1393, 1393, 1593, 1594, 1593, 1393, 1393,
    1393, 1393, 1393, 1393, 1576, 1577, 1595, 1393,
    1393, 1393, 1393, 1393, 1393, 1393, 1393, 1576,
    1577, 1576, 1577, 1393, 1393, 1393, 1393, 1393,

    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1462, 1462,
    1462, 1462, 1462, 1462, 1463, 1463, 1463, 1463,
    1463, 1463, 1463, 1543, 1543, 1543, 1543, 1543,

    1463, 1463, 1463, 1463, 1543, 1543, 1543, 1543,
    1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
    1573, 1573, 1573, 1573, 1573, 1573, 1573, 1573,
    1573, 1573, 1573, 1573, 1573, 1573, 1573, 1573,

    1573, 1573, 1573, 1573, 1573, 1543, 1543, 1573,
    1573, 1573, 1573, 1573, 1573, 1512, 1512, 1512,
    1543, 1543, 1543, 1543, 1543, 1509, 1509, 1509,
    1509, 1509, 1512, 1512, 1512, 1512, 1512, 1512,

    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 202, 202, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,

    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 202, 1596,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,

    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1597, 1597, 1597, 1512, 1512, 1512,

    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1598, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1514, 1597, 1597, 1597, 1597, 1597,
    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,

    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
    1597, 1597, 1597, 1597, 1471, 1471, 1471, 1471,
    1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
    1597, 1597, 1597, 1597, 1597, 1597, 1599, 1598,

    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,

    1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
    1600, 1600, 1600, 1600, 1600, 1600, 1600, 202,
    1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,
    1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,

    1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,
    1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,
    1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,
    1601, 1601, 1601, 1601, 1601, 1601, 1601, 202,

    127, 123, 1602, 1603, 1604, 1605, 1606, 127,
    123, 127, 123, 127, 123, 1607, 1608, 1609,
    1610, 1235, 1237, 1238, 1611, 127, 123, 1611,
    1235, 1235, 1235, 1235, 1612, 1612, 1613, 1614,

    1615, 1616, 1615, 1616, 1615, 1616, 1615, 1616,
    1615, 1616, 1615, 1616, 1615, 1616, 1615, 1616,
    1615, 1616, 1615, 1616, 1615, 1616, 1615, 1616,
    1615, 1616, 1615, 1616, 1615, 1616, 1615, 1616,

    1615, 1616, 1615, 1616, 1617, 1618, 1618, 1618,
    1618, 1618, 1618, 1619, 1620, 1619, 1620, 1621,
    1621, 1621, 1622, 1623, 202, 202, 202, 202,
    202, 1624, 1625, 1625, 1625, 1626, 1624, 1625,

    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,

    1627, 1627, 1627, 1627, 1627, 1627, 202, 1628,
    202, 202, 202, 202, 202, 1628, 202, 202,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,

    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,

    1629, 1629, 1629, 1629, 1629, 1629, 1630, 1630,
    202, 202, 202, 202, 202, 202, 202, 1631,
    1632, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 1633,

    871, 871, 871, 871, 871, 871, 871, 871,
    871, 871, 871, 871, 871, 871, 871, 871,
    871, 871, 871, 871, 871, 871, 871, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    871, 871, 871, 871, 871, 871, 871, 202,
    871, 871, 871, 871, 871, 871, 871, 202,
    871, 871, 871, 871, 871, 871, 871, 202,
    871, 871, 871, 871, 871, 871, 871, 202,

    267, 267, 267, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267,

    1634, 1634, 1635, 1636, 1635, 1636, 1634, 1634,
    1634, 1635, 1636, 1634, 1635, 1636, 1397, 1397,
    1397, 1397, 1397, 1397, 1397, 1397, 1396, 1637,
    1638, 1639, 1640, 1641, 1635, 1636, 1641, 1641,

    1642, 1643, 1579, 1580, 1579, 1580, 1579, 1580,
    1579, 1580, 1639, 1639, 1639, 1639, 1644, 1645,
    1639, 1646, 1647, 1648, 1648, 1647, 1647, 1647,
    1647, 1647, 1649, 1649, 1650, 1651, 1651, 1652,

    1653, 1651, 1654, 1655, 1655, 1656, 1656, 1656,
    1656, 1656, 1657, 1658, 1657, 1658, 1657, 1659,
    1596, 1596, 1660, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 202, 1661, 1661, 1661, 1661, 1662,

    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,

    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1661, 1661, 1661, 1661, 1661,
    1661, 1661, 1661, 1662, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
    1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
    1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
    1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,

    1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
    1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
    1662, 1662, 1662, 1662, 1662, 1662, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663,
    1663, 1663, 1663, 1663, 202, 202, 202, 202,

    1351, 1664, 1665, 1666, 1502, 1667, 1668, 1669,
    16, 1388, 16, 1388, 16, 1388, 16, 1388,
    16, 1388, 1502, 1502, 16, 1388, 16, 1388,
    16, 1388, 16, 1388, 1670, 1366, 1671, 1671,

    1502, 1669, 1669, 1669, 1669, 1669, 1669, 1669,
    1669, 1669, 1672, 1673, 174, 1674, 1675, 1675,
    1676, 1677, 1677, 1677, 1677, 1678, 1679, 1502,
    1680, 1680, 1680, 1681, 1682, 1683, 1663, 1502,

    202, 1684, 1685, 1684, 1685, 1684, 1685, 1684,
    1685, 1684, 1685, 1685, 1686, 1685, 1686, 1685,
    1686, 1685, 1686, 1685, 1686, 1685, 1686, 1685,
    1686, 1685, 1686, 1685, 1686, 1685, 1686, 1685,

    1686, 1685, 1686, 1684, 1685, 1686, 1685, 1686,
    1685, 1686, 1685, 1685, 1685, 1685, 1685, 1685,
    1686, 1686, 1685, 1686, 1686, 1685, 1686, 1686,
    1685, 1686, 1686, 1685, 1686, 1686, 1685, 1685,

    1685, 1685, 1685, 1684, 1685, 1684, 1685, 1684,
    1685, 1685, 1685, 1685, 1685, 1685, 1684, 1685,
    1685, 1685, 1685, 1685, 1686, 1687, 1687, 202,
    202, 1688, 1688, 1689, 1689, 1690, 1691, 1692,

    1693, 1694, 1695, 1694, 1695, 1694, 1695, 1694,
    1695, 1694, 1695, 1695, 1696, 1695, 1696, 1695,
    1696, 1695, 1696, 1695, 1696, 1695, 1696, 1695,
    1696, 1695, 1696, 1695, 1696, 1695, 1696, 1695,

    1696, 1695, 1696, 1694, 1695, 1696, 1695, 1696,
    1695, 1696, 1695, 1695, 1695, 1695, 1695, 1695,
    1696, 1696, 1695, 1696, 1696, 1695, 1696, 1696,
    1695, 1696, 1696, 1695, 1696, 1696, 1695, 1695,

    1695, 1695, 1695, 1694, 1695, 1694, 1695, 1694,
    1695, 1695, 1695, 1695, 1695, 1695, 1694, 1695,
    1695, 1695, 1695, 1695, 1696, 1694, 1694, 1696,
    1696, 1696, 1696, 1697, 1698, 1699, 1700, 1701,

    202, 202, 202, 202, 202, 1702, 1702, 1702,
    1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702,
    1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702,
    1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702,

    1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702,
    1702, 1702, 1702, 1702, 1702, 1703, 1704, 1705,
    202, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,

    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,

    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 202,
    1707, 1707, 1708, 1708, 1708, 1708, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,

    1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710,
    1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710,
    1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710,
    1711, 1711, 1711, 1712, 1712, 1712, 1712, 1712,

    1541, 1541, 1541, 1541, 1541, 1541, 1541, 1541,
    1541, 1541, 1541, 1541, 1541, 1541, 1541, 1541,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,

    1546, 1546, 1546, 1546, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    1713, 1713, 1713, 1713, 1713, 1713, 1713, 1713,
    1713, 1713, 1713, 1713, 1713, 1713, 1713, 1713,

    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1714, 1715, 1715, 202,

    1708, 1708, 1708, 1708, 1708, 1708, 1708, 1708,
    1708, 1708, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,

    1709, 1709, 1709, 1709, 1716, 1716, 1716, 1716,
    1717, 1717, 1717, 1717, 1717, 1717, 1717, 1717,
    1718, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
    1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,

    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
    1714, 1714, 1714, 1714, 1715, 1715, 1720, 1707,

    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
    1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,

    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1718, 1718, 1718, 1718,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,

    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1722,

    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,

    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,

    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1718,
    1718, 1718, 1718, 1709, 1709, 1709, 1709, 1709,

    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,

    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1718, 1718,

    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1709,
    1709, 1709, 1709, 1709, 1709, 1709, 1709, 1718,

    1723, 1723, 1723, 1723, 1723, 1723, 1723, 1723,
    1723, 1723, 1723, 1723, 1723, 1723, 1723, 1723,
    1723, 1723, 1723, 1723, 1723, 1723, 1723, 1723,
    1723, 1723, 1723, 1723, 1723, 1723, 1723, 1723,

    1723, 1723, 1723, 1723, 1723, 1723, 1723, 1723,
    1723, 1723, 1723, 1723, 1723, 1723, 1723, 1723,
    1723, 1723, 1723, 1723, 1723, 1723, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,

    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,

    1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725,
    1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725,
    1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725,
    1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725,

    1725, 1725, 1725, 1725, 1725, 1725, 1726, 1726,
    1726, 1726, 1726, 1726, 1726, 1726, 1726, 1726,
    1726, 1726, 1726, 1726, 1726, 1726, 1726, 1726,
    1726, 1726, 1726, 1726, 1727, 1727, 1727, 1727,

    1727, 1727, 1727, 1727, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1729, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,

    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1732, 1732, 1732, 1732, 1732,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1733, 1733, 1733,

    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 1735, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,

    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,

    1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
    1734, 1734, 1734, 1734, 1734, 202, 202, 202,
    1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
    1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,

    1736, 1736, 1737, 1737, 1736, 1736, 1736, 1736,
    1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
    1736, 1736, 1736, 1736, 1737, 1736, 1736, 1736,
    1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,

    1736, 1737, 1736, 1736, 1736, 1737, 1736, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
    1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,

    1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
    1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
    1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
    1739, 1739, 1739, 1739, 1739, 1739, 1740, 1741,

    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,

    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1743, 1744, 1745, 1746,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,

    1747, 1748, 1749, 1750, 1751, 1752, 1753, 1754,
    1755, 1756, 1742, 1742, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    281, 282, 281, 282, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 281, 282,

    285, 286, 281, 282, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 1757, 267,
    1758, 1758, 1758, 1759, 1760, 1760, 1760, 1760,
    1760, 1760, 1760, 1760, 267, 267, 1759, 1761,

    281, 282, 281, 282, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 281, 282,
    281, 282, 281, 282, 281, 282, 281, 282,
    287, 288, 287, 288, 1762, 1762, 1763, 1760,

    1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
    1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
    1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
    1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,

    1764, 1764, 1764, 1764, 1764, 1764, 1765, 1765,
    1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
    1766, 1766, 1767, 1768, 1769, 1769, 1769, 1768,
    202, 202, 202, 202, 202, 202, 202, 202,

    1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770,
    1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771,
    1771, 1771, 1771, 1771, 1771, 1771, 1771, 1772,
    1772, 1772, 1772, 1645, 1645, 1645, 1645, 1645,

    1773, 1773, 1237, 1238, 1237, 1238, 1237, 1238,
    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1235, 1235, 1237, 1238, 1237, 1238, 1237, 1238,
    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,

    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,

    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1612, 1235, 1235, 1235, 1235, 1235, 1235, 1235,
    1235, 1237, 1238, 1237, 1238, 1774, 1237, 1238,

    1237, 1238, 1237, 1238, 1237, 1238, 1237, 1238,
    1645, 1775, 1775, 1237, 1238, 1776, 1777, 1778,
    1779, 1780, 1781, 1782, 1783, 1784, 1785, 1786,
    1785, 1786, 1785, 1786, 1785, 1786, 1785, 1786,

    1779, 1780, 1779, 1780, 1779, 1780, 1779, 1780,
    1779, 1780, 1787, 1788, 1789, 1790, 1791, 1792,
    1793, 1794, 1795, 1796, 1797, 1798, 1797, 1798,
    1799, 1800, 1801, 1802, 1801, 1802, 1801, 1802,

    202, 202, 1801, 1802, 1803, 1804, 1805, 1806,
    1807, 1806, 1807, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 1806, 1807, 1808,
    1809, 1809, 1777, 1810, 1810, 1810, 1810, 1810,

    1811, 1811, 1812, 1811, 1811, 1811, 1813, 1811,
    1811, 1811, 1811, 1812, 1811, 1811, 1811, 1811,
    1811, 1811, 1811, 1811, 1811, 1811, 1811, 1811,
    1811, 1811, 1811, 1811, 1811, 1811, 1811, 1811,

    1811, 1811, 1811, 1814, 1814, 1812, 1812, 1814,
    1815, 1815, 1815, 1815, 1816, 202, 202, 202,
    1717, 1717, 1717, 1717, 1717, 1717, 813, 813,
    1428, 1817, 202, 202, 202, 202, 202, 202,

    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,

    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1819, 1820, 1821, 1821, 1822, 1822,
    202, 202, 202, 202, 202, 202, 202, 202,

    1823, 1823, 1824, 1824, 1824, 1824, 1824, 1824,
    1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
    1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
    1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,

    1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
    1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
    1824, 1824, 1824, 1824, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,

    1823, 1823, 1823, 1823, 1825, 1826, 202, 202,
    202, 202, 202, 202, 202, 202, 1827, 1827,
    1828, 1829, 1830, 1831, 1832, 1833, 1834, 1835,
    1836, 1837, 202, 202, 202, 202, 202, 202,

    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 508, 508, 508, 508, 508, 508,
    1839, 1839, 1839, 508, 1840, 1841, 1842, 1843,

    1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851,
    1852, 1853, 1854, 1854, 1854, 1854, 1854, 1854,
    1854, 1854, 1854, 1854, 1854, 1854, 1854, 1854,
    1854, 1854, 1854, 1854, 1854, 1854, 1854, 1854,

    1854, 1854, 1854, 1854, 1854, 1854, 1855, 1855,
    1855, 1855, 1855, 1856, 1856, 1856, 1857, 1858,
    1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
    1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,

    1859, 1859, 1859, 1859, 1859, 1859, 1859, 1860,
    1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
    1860, 1860, 1861, 1862, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 1863,

    863, 863, 863, 863, 863, 863, 863, 863,
    863, 863, 863, 863, 863, 863, 863, 863,
    863, 863, 863, 863, 863, 863, 863, 863,
    863, 863, 863, 863, 863, 202, 202, 202,

    1864, 1864, 1864, 1865, 1866, 1866, 1866, 1866,
    1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
    1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
    1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,

    1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
    1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
    1866, 1866, 1866, 1867, 1865, 1865, 1864, 1864,
    1864, 1864, 1865, 1865, 1864, 1864, 1865, 1865,

    1868, 1869, 1869, 1869, 1869, 1869, 1869, 1870,
    1871, 1871, 1869, 1869, 1869, 1869, 202, 1872,
    1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880,
    1881, 1882, 202, 202, 202, 202, 1869, 1869,

    1883, 1883, 1883, 1883, 1883, 1884, 1885, 1883,
    1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883,
    1886, 1887, 1888, 1889, 1890, 1891, 1892, 1893,
    1894, 1895, 1883, 1883, 1883, 1883, 1883, 202,

    1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896,
    1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896,
    1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896,
    1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896,

    1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896,
    1896, 1897, 1897, 1897, 1897, 1897, 1897, 1898,
    1898, 1897, 1897, 1898, 1898, 1897, 1897, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1896, 1896, 1896, 1897, 1896, 1896, 1896, 1896,
    1896, 1896, 1896, 1896, 1897, 1898, 202, 202,
    1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906,
    1907, 1908, 202, 202, 1909, 1910, 1910, 1910,

    1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911,
    1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911,
    1912, 1911, 1911, 1911, 1911, 1911, 1911, 1913,
    1913, 1913, 1911, 851, 1884, 1914, 1883, 1883,

    1915, 1915, 1915, 1915, 1915, 1915, 1915, 1915,
    1915, 1915, 1915, 1915, 1915, 1915, 1915, 1915,
    1915, 1915, 1915, 1915, 1915, 1915, 1915, 1915,
    1915, 1915, 1915, 1915, 1915, 1915, 1915, 1915,

    1915, 1915, 1915, 1915, 1915, 1915, 1915, 1915,
    1915, 1915, 1915, 1915, 1915, 1915, 1915, 1915,
    1916, 1915, 1916, 1916, 1917, 1915, 1915, 1916,
    1916, 1915, 1915, 1915, 1915, 1915, 1916, 1916,

    1915, 1916, 1915, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 1915, 1915, 1918, 1919, 1919,

    1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1920, 1920, 1921, 1922, 1922, 1921, 1921,
    1923, 1923, 1920, 1924, 1924, 1921, 1925, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 1926, 1926, 1926, 1926, 1926, 1926, 202,
    202, 1926, 1926, 1926, 1926, 1926, 1926, 202,
    202, 1926, 1926, 1926, 1926, 1926, 1926, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1926, 1926, 1926, 1926, 1926, 1926, 1926, 202,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 202,
    1784, 1784, 1784, 1784, 1784, 1784, 1784, 1784,
    1784, 1784, 1784, 1784, 1784, 1784, 1784, 1784,

    1784, 1784, 1784, 1784, 1784, 1784, 1784, 1784,
    1784, 1784, 1784, 1784, 1784, 1784, 1784, 1784,
    1784, 1784, 1784, 1927, 1784, 1784, 1784, 1784,
    1784, 1784, 1784, 1928, 1929, 1929, 1929, 1929,

    1930, 1930, 1930, 1930, 1784, 1931, 1932, 1932,
    1933, 1934, 1935, 1935, 202, 202, 202, 202,
    1936, 1937, 1938, 1939, 1940, 1941, 1942, 1943,
    1944, 1945, 1946, 1947, 1948, 1949, 1950, 1951,

    1952, 1953, 1954, 1955, 1956, 1957, 1958, 1959,
    1960, 1961, 1962, 1963, 1964, 1965, 1966, 1967,
    1968, 1969, 1970, 1971, 1972, 1973, 1974, 1975,
    1976, 1977, 1978, 1979, 1980, 1981, 1982, 1983,

    1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991,
    1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
    2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
    2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015,

    2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016,
    2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016,
    2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016,
    2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016,

    2016, 2016, 2016, 2017, 2017, 2018, 2017, 2017,
    2018, 2017, 2017, 2019, 2017, 2020, 202, 202,
    2021, 2022, 2023, 2024, 2025, 2026, 2027, 2028,
    2029, 2030, 202, 202, 202, 202, 202, 202,

    2031, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2031, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2031, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2031, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2031, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2031, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2031, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 2031, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,
    2032, 2032, 2032, 2032, 2032, 2032, 2032, 2032,

    2032, 2032, 2032, 2032, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    866, 866, 866, 866, 866, 866, 866, 866,
    866, 866, 866, 866, 866, 866, 866, 866,

    866, 866, 866, 866, 866, 866, 866, 202,
    202, 202, 202, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 869,

    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 869, 202, 202, 202, 202,

    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,

    2034, 2034, 2034, 2034, 2034, 2034, 2034, 2034,
    2034, 2034, 2034, 2034, 2034, 2034, 2034, 2034,
    2034, 2034, 2034, 2034, 2034, 2034, 2034, 2034,
    2034, 2034, 2034, 2034, 2034, 2034, 2034, 2034,

    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,

    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 1725, 1725,
    2035, 1725, 2035, 1725, 1725, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 1725,

    2035, 1725, 2035, 1725, 1725, 2035, 2035, 1725,
    1725, 1725, 2035, 2035, 2035, 2035, 2036, 2036,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,

    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,

    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2038, 2038, 2038, 1733, 1733,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,

    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,

    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 2039, 2039, 2039, 2039, 2039, 2039,
    2039, 2039, 1733, 1733, 1733, 1733, 1733, 1733,

    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    2040, 2041, 2042, 2043, 2044, 2045, 2045, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 2046, 2047, 2048, 2049, 2050,
    202, 202, 202, 202, 202, 2051, 2052, 2053,

    2054, 2054, 2054, 2054, 2054, 2054, 2054, 2054,
    2054, 2055, 2053, 2053, 2053, 2053, 2053, 2053,
    2053, 2053, 2053, 2053, 2053, 2053, 2053, 301,
    2053, 2053, 2053, 2053, 2053, 301, 2053, 301,

    2053, 2053, 301, 2053, 2053, 301, 2053, 2053,
    2053, 2053, 2053, 2053, 2053, 2053, 2053, 2054,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,

    2057, 2057, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 1671, 1366,

    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    348, 348, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    348, 348, 348, 348, 348, 348, 348, 348,
    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,

    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2058, 2058, 2058, 2058, 2058, 2058, 2058, 2058,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2059, 340, 348, 348,

    2060, 2060, 2060, 2060, 2060, 2060, 2060, 2060,
    2060, 2060, 2060, 2060, 2060, 2060, 2060, 2060,
    2061, 2062, 2063, 2064, 2065, 2066, 2066, 2067,
    2068, 2069, 202, 202, 202, 202, 202, 202,

    173, 173, 173, 173, 1219, 1219, 1219, 1107,
    1107, 1107, 1107, 1107, 1107, 1107, 1763, 1763,
    2070, 2071, 2071, 2072, 2072, 2073, 2074, 2073,
    2074, 2073, 2074, 2073, 2074, 2073, 2074, 2073,

    2074, 2073, 2074, 2073, 2074, 1683, 1683, 2075,
    2076, 2070, 2070, 2070, 2070, 2072, 2072, 2072,
    2077, 2078, 2079, 202, 2080, 2081, 2082, 2082,
    2071, 1419, 1420, 1419, 1420, 1419, 1420, 2083,

    2070, 2070, 2084, 2085, 2086, 2087, 2088, 202,
    2070, 1422, 1380, 2070, 202, 202, 202, 202,
    2056, 2056, 2056, 2089, 2056, 348, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 348, 348, 2090,

    202, 2082, 2070, 2083, 1422, 1380, 2070, 2091,
    1419, 1420, 2070, 2084, 2077, 2085, 2079, 2092,
    2093, 2094, 2095, 2096, 2097, 2098, 2099, 2100,
    2101, 2102, 2081, 2080, 2103, 2088, 2104, 2082,

    2070, 2105, 2105, 2105, 2105, 2105, 2105, 2105,
    2105, 2105, 2105, 2105, 2105, 2105, 2105, 2105,
    2105, 2105, 2105, 2105, 2105, 2105, 2105, 2105,
    2105, 2105, 2105, 2106, 2070, 2107, 2108, 2072,

    2108, 2109, 2109, 2109, 2109, 2109, 2109, 2109,
    2109, 2109, 2109, 2109, 2109, 2109, 2109, 2109,
    2109, 2109, 2109, 2109, 2109, 2109, 2109, 2109,
    2109, 2109, 2109, 2106, 2088, 2107, 2088, 2110,

    2111, 2112, 1419, 1420, 2113, 2114, 2115, 2116,
    2116, 2116, 2116, 2116, 2116, 2116, 2116, 2116,
    2117, 2115, 2115, 2115, 2115, 2115, 2115, 2115,
    2115, 2115, 2115, 2115, 2115, 2115, 2115, 2115,

    2115, 2115, 2115, 2115, 2115, 2115, 2115, 2115,
    2115, 2115, 2115, 2115, 2115, 2115, 2115, 2115,
    2115, 2115, 2115, 2115, 2115, 2115, 2115, 2115,
    2115, 2115, 2115, 2115, 2115, 2115, 2118, 2118,

    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 1706,
    1706, 1706, 1706, 1706, 1706, 1706, 1706, 202,

    202, 202, 1706, 1706, 1706, 1706, 1706, 1706,
    202, 202, 1706, 1706, 1706, 1706, 1706, 1706,
    202, 202, 1706, 1706, 1706, 1706, 1706, 1706,
    202, 202, 1706, 1706, 1706, 202, 202, 202,

    2119, 1422, 2088, 2108, 1679, 1422, 1422, 202,
    1443, 1418, 1418, 1418, 1418, 1443, 1443, 202,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 2120, 2120, 2120, 2121, 51, 2122, 2122,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 202, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 202,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 202, 2123, 2123, 202, 2123,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 202, 202,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 202, 202,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 202, 202, 202, 202, 202,

    2124, 2125, 2124, 202, 202, 202, 202, 2126,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,

    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 2126, 2126, 2126, 2126, 2126, 2126, 2126,
    2126, 2126, 2126, 2126, 202, 202, 202, 2127,
    2127, 2127, 2127, 2127, 2127, 2127, 2127, 2127,

    2128, 2128, 2128, 2128, 2128, 2128, 2128, 2128,
    2128, 2128, 2128, 2128, 2128, 2128, 2128, 2128,
    2128, 2128, 2128, 2128, 2128, 2128, 2128, 2128,
    2128, 2128, 2128, 2128, 2128, 2128, 2128, 2128,

    2128, 2128, 2128, 2128, 2128, 2128, 2128, 2128,
    2128, 2128, 2128, 2128, 2128, 2128, 2128, 2128,
    2128, 2128, 2128, 2128, 2128, 2129, 2129, 2129,
    2129, 2130, 2130, 2130, 2130, 2130, 2130, 2130,

    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2129, 2131, 2132, 2133, 2133, 202,
    1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
    1543, 1543, 1543, 1543, 1596, 202, 202, 202,

    2132, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
    1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,

    1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
    1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
    1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
    1465, 1465, 1465, 1465, 1465, 1222, 202, 202,

    2134, 2134, 2134, 2134, 2134, 2134, 2134, 2134,
    2134, 2134, 2134, 2134, 2134, 2134, 2134, 2134,
    2134, 2134, 2134, 2134, 2134, 2134, 2134, 2134,
    2134, 2134, 2134, 2134, 2134, 202, 202, 202,

    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,

    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1107, 2136, 2136, 2136, 2136, 2136, 2136, 2136,
    2136, 2136, 2136, 2136, 2136, 2136, 2136, 2136,
    2136, 2136, 2136, 2136, 2136, 2136, 2136, 2136,
    2136, 2136, 2136, 2136, 202, 202, 202, 202,

    2137, 2137, 2137, 2137, 2137, 2137, 2137, 2137,
    2137, 2137, 2137, 2137, 2137, 2137, 2137, 2137,
    2137, 2137, 2137, 2137, 2137, 2137, 2137, 2137,
    2137, 2137, 2137, 2137, 2137, 2137, 2137, 2138,

    2139, 2139, 2139, 2139, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 2140, 2140, 2140,
    2141, 2141, 2141, 2141, 2141, 2141, 2141, 2141,
    2141, 2141, 2141, 2141, 2141, 2141, 2141, 2141,

    2141, 2142, 2141, 2141, 2141, 2141, 2141, 2141,
    2141, 2141, 2142, 202, 202, 202, 202, 202,
    2143, 2143, 2143, 2143, 2143, 2143, 2143, 2143,
    2143, 2143, 2143, 2143, 2143, 2143, 2143, 2143,

    2143, 2143, 2143, 2143, 2143, 2143, 2143, 2143,
    2143, 2143, 2143, 2143, 2143, 2143, 2143, 2143,
    2143, 2143, 2143, 2143, 2143, 2143, 2144, 2144,
    2144, 2144, 2144, 202, 202, 202, 202, 202,

    2145, 2145, 2145, 2145, 2145, 2145, 2145, 2145,
    2145, 2145, 2145, 2145, 2145, 2145, 2145, 2145,
    2145, 2145, 2145, 2145, 2145, 2145, 2145, 2145,
    2145, 2145, 2145, 2145, 2145, 2145, 202, 2146,

    2147, 2147, 2147, 2147, 2147, 2147, 2147, 2147,
    2147, 2147, 2147, 2147, 2147, 2147, 2147, 2147,
    2147, 2147, 2147, 2147, 2147, 2147, 2147, 2147,
    2147, 2147, 2147, 2147, 2147, 2147, 2147, 2147,

    2147, 2147, 2147, 2147, 202, 202, 202, 202,
    2147, 2147, 2147, 2147, 2147, 2147, 2147, 2147,
    2148, 2149, 2149, 2149, 2149, 2149, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2150, 2150, 2150, 2150, 2150, 2150, 2150, 2150,
    2150, 2150, 2150, 2150, 2150, 2150, 2150, 2150,
    2150, 2150, 2150, 2150, 2150, 2150, 2150, 2150,
    2150, 2150, 2150, 2150, 2150, 2150, 2150, 2150,

    2150, 2150, 2150, 2150, 2150, 2150, 2151, 2151,
    2152, 2152, 2152, 2152, 2152, 2152, 2152, 2152,
    2152, 2152, 2152, 2152, 2152, 2152, 2152, 2152,
    2152, 2152, 2152, 2152, 2152, 2152, 2152, 2152,

    2152, 2152, 2152, 2152, 2152, 2152, 2152, 2152,
    2152, 2152, 2152, 2152, 2152, 2152, 2153, 2153,
    2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,
    2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,

    2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,
    2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,
    2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,
    2154, 2154, 2154, 2154, 2154, 2154, 2154, 2154,

    2155, 2155, 2155, 2155, 2155, 2155, 2155, 2155,
    2155, 2155, 2155, 2155, 2155, 2155, 2155, 2155,
    2155, 2155, 2155, 2155, 2155, 2155, 2155, 2155,
    2155, 2155, 2155, 2155, 2155, 2155, 202, 202,

    2156, 2157, 2158, 2159, 2160, 2161, 2162, 2163,
    2164, 2165, 202, 202, 202, 202, 202, 202,
    2166, 2166, 2166, 2166, 2166, 2166, 2166, 2166,
    2166, 2166, 2166, 2166, 2166, 2166, 2166, 2166,

    2166, 2166, 2166, 2166, 2166, 2166, 2166, 2166,
    2166, 2166, 2166, 2166, 2166, 2166, 2166, 2166,
    2166, 2166, 2166, 2166, 202, 202, 202, 202,
    2167, 2167, 2167, 2167, 2167, 2167, 2167, 2167,

    2167, 2167, 2167, 2167, 2167, 2167, 2167, 2167,
    2167, 2167, 2167, 2167, 2167, 2167, 2167, 2167,
    2167, 2167, 2167, 2167, 2167, 2167, 2167, 2167,
    2167, 2167, 2167, 2167, 202, 202, 202, 202,

    2168, 2168, 2168, 2168, 2168, 2168, 2168, 2168,
    2168, 2168, 2168, 2168, 2168, 2168, 2168, 2168,
    2168, 2168, 2168, 2168, 2168, 2168, 2168, 2168,
    2168, 2168, 2168, 2168, 2168, 2168, 2168, 2168,

    2168, 2168, 2168, 2168, 2168, 2168, 2168, 2168,
    202, 202, 202, 202, 202, 202, 202, 202,
    2169, 2169, 2169, 2169, 2169, 2169, 2169, 2169,
    2169, 2169, 2169, 2169, 2169, 2169, 2169, 2169,

    2169, 2169, 2169, 2169, 2169, 2169, 2169, 2169,
    2169, 2169, 2169, 2169, 2169, 2169, 2169, 2169,
    2169, 2169, 2169, 2169, 2169, 2169, 2169, 2169,
    2169, 2169, 2169, 2169, 2169, 2169, 2169, 2169,

    2169, 2169, 2169, 2169, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 2170,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,

    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 2171, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    2171, 2171, 2171, 2171, 2171, 2171, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2171, 2171, 2171, 2171, 2171, 2171, 2171, 2171,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2172, 2172, 2172, 2172, 2172, 2172, 301, 301,
    2172, 301, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,

    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 2172, 2172, 2172, 2172, 2172, 301, 2172,
    2172, 301, 301, 301, 2172, 301, 301, 2172,

    2173, 2173, 2173, 2173, 2173, 2173, 2173, 2173,
    2173, 2173, 2173, 2173, 2173, 2173, 2173, 2173,
    2173, 2173, 2173, 2173, 2173, 2173, 301, 2174,
    2175, 2175, 2175, 2175, 2175, 2175, 2175, 2175,

    2176, 2176, 2176, 2176, 2176, 2176, 2176, 2176,
    2176, 2176, 2176, 2176, 2176, 2176, 2176, 2176,
    2176, 2176, 2176, 2176, 2176, 2176, 2176, 2177,
    2177, 2178, 2178, 2178, 2178, 2178, 2178, 2178,

    2179, 2179, 2179, 2179, 2179, 2179, 2179, 2179,
    2179, 2179, 2179, 2179, 2179, 2179, 2179, 2179,
    2179, 2179, 2179, 2179, 2179, 2179, 2179, 2179,
    2179, 2179, 2179, 2179, 2179, 2179, 2179, 301,

    301, 301, 301, 301, 301, 301, 301, 2180,
    2180, 2180, 2180, 2180, 2180, 2180, 2180, 2180,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2181, 2181, 2181, 2181, 2181, 2181, 2181, 2181,
    2181, 2181, 2181, 2181, 2181, 2181, 2181, 2181,
    2181, 2181, 2181, 301, 2181, 2181, 301, 301,
    301, 301, 301, 2182, 2182, 2182, 2182, 2182,

    2183, 2183, 2183, 2183, 2183, 2183, 2183, 2183,
    2183, 2183, 2183, 2183, 2183, 2183, 2183, 2183,
    2183, 2183, 2183, 2183, 2183, 2183, 2184, 2184,
    2184, 2184, 2185, 2185, 301, 301, 301, 2186,

    2187, 2187, 2187, 2187, 2187, 2187, 2187, 2187,
    2187, 2187, 2187, 2187, 2187, 2187, 2187, 2187,
    2187, 2187, 2187, 2187, 2187, 2187, 2187, 2187,
    2187, 2187, 301, 301, 301, 301, 301, 2188,

    2189, 2189, 2189, 2189, 2189, 2189, 2189, 2189,
    2189, 2189, 2189, 2189, 2189, 2189, 2189, 2189,
    2189, 2189, 2189, 2189, 2189, 2189, 2189, 2189,
    2189, 2189, 2189, 2189, 2189, 2189, 2189, 2189,

    2190, 2190, 2190, 2190, 2190, 2190, 2190, 2190,
    2190, 2190, 2190, 2190, 2190, 2190, 2190, 2190,
    2190, 2190, 2190, 2190, 2190, 2190, 2190, 2190,
    301, 301, 301, 301, 2191, 2191, 2190, 2190,

    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    301, 301, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,

    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,
    2191, 2191, 2191, 2191, 2191, 2191, 2191, 2191,

    2192, 2193, 2193, 2193, 301, 2193, 2193, 301,
    301, 301, 301, 301, 2193, 2194, 2193, 2195,
    2192, 2192, 2192, 2192, 301, 2192, 2192, 2192,
    301, 2192, 2192, 2192, 2192, 2192, 2192, 2192,

    2192, 2192, 2192, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 2192, 2192, 2192, 2192, 2192, 2192,
    2192, 2192, 2192, 2192, 2196, 2196, 301, 301,
    2195, 2197, 2194, 301, 301, 301, 301, 2198,

    2199, 2200, 2201, 2202, 2203, 2203, 2203, 2203,
    2204, 301, 301, 301, 301, 301, 301, 301,
    2205, 2205, 2205, 2205, 2205, 2205, 2206, 2206,
    2207, 301, 301, 301, 301, 301, 301, 301,

    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2209, 2209, 2210,

    2211, 2211, 2211, 2211, 2211, 2211, 2211, 2211,
    2211, 2211, 2211, 2211, 2211, 2211, 2211, 2211,
    2211, 2211, 2211, 2211, 2211, 2211, 2211, 2211,
    2211, 2211, 2211, 2211, 2211, 2212, 2212, 2212,

    2213, 2213, 2213, 2213, 2213, 2214, 2215, 2214,
    2216, 2214, 2214, 2215, 2215, 2217, 2214, 2214,
    2214, 2214, 2214, 2213, 2213, 2213, 2213, 2217,
    2213, 2213, 2213, 2213, 2213, 2214, 2213, 2213,

    2213, 2214, 2215, 2215, 2214, 2218, 2219, 301,
    301, 301, 301, 2220, 2220, 2220, 2220, 2221,
    2222, 2222, 2222, 2222, 2222, 2222, 2223, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2224, 2224, 2224, 2224, 2224, 2224, 2224, 2224,
    2224, 2224, 2224, 2224, 2224, 2224, 2224, 2224,
    2224, 2224, 2224, 2224, 2224, 2224, 2224, 2224,
    2224, 2224, 2224, 2224, 2224, 2224, 2224, 2224,

    2224, 2224, 2224, 2224, 2224, 2224, 2224, 2224,
    2224, 2224, 2224, 2224, 2224, 2224, 2224, 2224,
    2224, 2224, 2224, 2224, 2224, 2224, 301, 301,
    301, 2225, 2225, 2225, 2225, 2225, 2225, 2225,

    2226, 2226, 2226, 2226, 2226, 2226, 2226, 2226,
    2226, 2226, 2226, 2226, 2226, 2226, 2226, 2226,
    2226, 2226, 2226, 2226, 2226, 2226, 301, 301,
    2227, 2227, 2227, 2227, 2227, 2227, 2227, 2227,

    2228, 2228, 2228, 2228, 2228, 2228, 2228, 2228,
    2228, 2228, 2228, 2228, 2228, 2228, 2228, 2228,
    2228, 2228, 2228, 301, 301, 301, 301, 301,
    2229, 2229, 2229, 2229, 2229, 2229, 2229, 2229,

    2230, 2231, 2230, 2231, 2231, 2231, 2230, 2230,
    2230, 2231, 2230, 2230, 2231, 2230, 2231, 2231,
    2230, 2231, 301, 301, 301, 301, 301, 301,
    301, 2232, 2232, 2232, 2232, 301, 301, 301,

    301, 301, 301, 301, 301, 301, 301, 301,
    301, 2233, 2233, 2233, 2233, 2234, 2234, 2235,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2236, 2236, 2236, 2236, 2236, 2236, 2236, 2236,
    2236, 2236, 2236, 2236, 2236, 2236, 2236, 2236,
    2236, 2236, 2236, 2236, 2236, 2236, 2236, 2236,
    2236, 2236, 2236, 2236, 2236, 2236, 2236, 2236,

    2236, 2236, 2236, 2236, 2236, 2236, 2236, 2236,
    2236, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2237, 2237, 2237, 2237, 2237, 2237, 2237, 2237,
    2237, 2237, 2237, 2237, 2237, 2237, 2237, 2237,
    2237, 2237, 2237, 2237, 2237, 2237, 2237, 2237,
    2237, 2237, 2237, 2237, 2237, 2237, 2237, 2237,

    2237, 2237, 2237, 2237, 2237, 2237, 2237, 2237,
    2237, 2237, 2237, 2237, 2237, 2237, 2237, 2237,
    2237, 2237, 2237, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2238, 2238, 2238, 2238, 2238, 2238, 2238, 2238,
    2238, 2238, 2238, 2238, 2238, 2238, 2238, 2238,
    2238, 2238, 2238, 2238, 2238, 2238, 2238, 2238,
    2238, 2238, 2238, 2238, 2238, 2238, 2238, 2238,

    2238, 2238, 2238, 2238, 2238, 2238, 2238, 2238,
    2238, 2238, 2238, 2238, 2238, 2238, 2238, 2238,
    2238, 2238, 2238, 301, 301, 301, 301, 301,
    301, 301, 2239, 2239, 2239, 2239, 2239, 2239,

    2240, 2241, 2241, 2241, 2241, 2241, 2241, 2241,
    2241, 2241, 2241, 2241, 2241, 2241, 2241, 2241,
    2241, 2241, 2241, 2241, 2241, 2241, 2241, 2241,
    2241, 2241, 2241, 2241, 2241, 2241, 2241, 2241,

    2241, 2241, 2242, 2241, 2243, 2243, 2243, 2243,
    301, 301, 301, 301, 301, 301, 301, 301,
    2244, 2245, 2246, 2247, 2248, 2249, 2250, 2251,
    2252, 2253, 301, 301, 301, 301, 301, 301,

    2254, 2255, 2256, 2257, 2258, 2259, 2260, 2261,
    2262, 2263, 2263, 2263, 2263, 2263, 2263, 2263,
    2263, 2263, 2263, 2263, 2263, 2263, 2263, 2263,
    2263, 2263, 2263, 2263, 2263, 2263, 2263, 301,

    2264, 2264, 2264, 2264, 2264, 2264, 2264, 2264,
    2264, 2264, 2264, 2264, 2264, 2264, 2264, 2264,
    2264, 2264, 2264, 2264, 2264, 2264, 2264, 2264,
    2264, 2264, 2264, 2264, 2264, 2264, 2264, 2264,

    2264, 2264, 2264, 2264, 2264, 2264, 2264, 2264,
    2264, 2264, 301, 2265, 2265, 2266, 301, 301,
    2264, 2264, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2268, 2268, 2268,

    2268, 2268, 2268, 2268, 2268, 2268, 2268, 2267,
    301, 301, 301, 301, 301, 301, 301, 301,
    2269, 2269, 2269, 2270, 2269, 2269, 2269, 2269,
    2269, 2269, 2269, 2269, 2269, 2269, 2269, 2269,

    2269, 2269, 2269, 2269, 2269, 2271, 2272, 2272,
    2273, 2273, 2273, 2272, 2273, 2272, 2272, 2272,
    2272, 2274, 2274, 2274, 2275, 2276, 2276, 2276,
    2276, 2276, 301, 301, 301, 301, 301, 301,

    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    2277, 2278, 2277, 2277, 2279, 2279, 2279, 2278,
    2277, 2279, 2279, 2277, 2277, 2279, 2277, 2277,

    2278, 2277, 2279, 2279, 2277, 2280, 2280, 2280,
    2280, 2281, 2282, 2283, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2284, 2284, 2284, 2284, 2284, 2284, 2284, 2284,
    2284, 2284, 2284, 2284, 2284, 2284, 2284, 2284,
    2284, 2284, 2284, 2284, 2284, 2284, 2284, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2285, 2286, 2285, 2287, 2287, 2287, 2287, 2287,
    2287, 2287, 2287, 2287, 2287, 2287, 2287, 2287,
    2287, 2287, 2287, 2287, 2287, 2287, 2287, 2287,
    2287, 2287, 2287, 2287, 2287, 2287, 2287, 2287,
    2287, 2287, 2287, 2287, 2287, 2287, 2287, 2287,
    2287, 2287, 2287, 2287, 2287, 2287, 2287, 2287,
    2287, 2287, 2287, 2287, 2287, 2287, 2287, 2287,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2288, 2289,
    2289, 2290, 2290, 2290, 2290, 2290, 202, 202,
    202, 202, 2291, 2292, 2293, 2294, 2295, 2296,
    2297, 2298, 2299, 2300, 2300, 2300, 2300, 2300,
    2300, 2300, 2300, 2300, 2300, 2300, 2301, 2302,
    2303, 2304, 2305, 2306, 2307, 2308, 2309, 2310,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 2311,
    2312, 2312, 2313, 2314, 2314, 2314, 2314, 2314,
    2314, 2314, 2314, 2314, 2314, 2314, 2314, 2314,
    2314, 2314, 2314, 2314, 2314, 2314, 2314, 2314,
    2314, 2314, 2315, 2314, 2315, 2314, 2314, 2314,
    2314, 2314, 2314, 2314, 2314, 2314, 2314, 2314,
    2314, 2314, 2314, 2315, 2314, 2314, 2314, 2314,
    2313, 2313, 2313, 2312, 2312, 2312, 2312, 2313,
    2313, 2316, 2317, 2318, 2318, 2319, 2320, 2320,
    2320, 2320, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 2321, 202, 202,
    2322, 2322, 2322, 2322, 2322, 2322, 2322, 2322,
    2322, 2322, 2322, 2322, 2322, 2322, 2322, 2322,
    2322, 2322, 2322, 2322, 2322, 2322, 2322, 2322,
    2322, 202, 202, 202, 202, 202, 202, 202,
    2323, 2324, 2325, 2326, 2327, 2328, 2329, 2330,
    2331, 2332, 202, 202, 202, 202, 202, 202,

    2333, 2333, 2333, 2334, 2334, 2334, 2334, 2334,
    2334, 2334, 2334, 2334, 2334, 2334, 2334, 2334,
    2334, 2334, 2334, 2334, 2334, 2334, 2334, 2334,
    2334, 2334, 2334, 2334, 2334, 2334, 2334, 2334,
    2334, 2334, 2334, 2334, 2334, 2334, 2334, 2335,
    2336, 2336, 2336, 2336, 2337, 2336, 2338, 2338,
    2336, 2336, 2336, 2339, 2339, 202, 2340, 2341,
    2342, 2343, 2344, 2345, 2346, 2347, 2348, 2349,
    2350, 2351, 2351, 2351, 2352, 2353, 2353, 2354,
    202, 202, 202, 202, 202, 202, 202, 202,
    2355, 2355, 2355, 2355, 2355, 2355, 2355, 2355,
    2355, 2355, 2355, 2355, 2355, 2355, 2355, 2355,
    2355, 2355, 2355, 2355, 2355, 2355, 2355, 2355,
    2355, 2355, 2355, 2355, 2355, 2355, 2355, 2355,
    2355, 2355, 2355, 2356, 2357, 2358, 2355, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2359, 2359, 2360, 2361, 2361, 2361, 2361, 2361,
    2361, 2361, 2361, 2361, 2361, 2361, 2361, 2361,
    2361, 2361, 2361, 2361, 2361, 2361, 2361, 2361,
    2361, 2361, 2361, 2361, 2361, 2361, 2361, 2361,
    2361, 2361, 2361, 2361, 2361, 2361, 2361, 2361,
    2361, 2361, 2361, 2361, 2361, 2361, 2361, 2361,
    2361, 2361, 2361, 2360, 2360, 2360, 2359, 2359,
    2359, 2359, 2359, 2359, 2359, 2359, 2359, 2360,
    2362, 2361, 2363, 2363, 2361, 2364, 2364, 2365,
    2366, 2367, 2368, 2367, 2367, 2369, 2370, 2371,
    2372, 2373, 2374, 2375, 2376, 2377, 2378, 2379,
    2380, 2381, 2382, 2383, 2384, 2385, 2386, 2386,
    202, 2387, 2387, 2387, 2387, 2387, 2387, 2387,
    2387, 2387, 2387, 2387, 2387, 2387, 2387, 2387,
    2387, 2387, 2387, 2387, 2387, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2388, 2388, 2388, 2388, 2388, 2388, 2388, 2388,
    2388, 2388, 2388, 2388, 2388, 2388, 2388, 2388,
    2388, 2388, 202, 2388, 2388, 2388, 2388, 2388,
    2388, 2388, 2388, 2388, 2388, 2388, 2388, 2388,
    2388, 2388, 2388, 2388, 2388, 2388, 2388, 2388,
    2388, 2388, 2388, 2388, 2389, 2389, 2389, 2390,
    2390, 2390, 2389, 2389, 2390, 2391, 2392, 2390,
    2393, 2393, 2394, 2393, 2393, 2394, 2395, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 202,
    2396, 202, 2396, 2396, 2396, 2396, 202, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 202, 2396,
    2396, 2396, 2396, 2396, 2396, 2396, 2396, 2396,
    2396, 2397, 202, 202, 202, 202, 202, 202,
    2398, 2398, 2398, 2398, 2398, 2398, 2398, 2398,
    2398, 2398, 2398, 2398, 2398, 2398, 2398, 2398,
    2398, 2398, 2398, 2398, 2398, 2398, 2398, 2398,
    2398, 2398, 2398, 2398, 2398, 2398, 2398, 2398,
    2398, 2398, 2398, 2398, 2398, 2398, 2398, 2398,
    2398, 2398, 2398, 2398, 2398, 2398, 2398, 2399,
    2400, 2400, 2400, 2399, 2399, 2399, 2399, 2399,
    2399, 2401, 2402, 202, 202, 202, 202, 202,
    2403, 2404, 2405, 2406, 2407, 2408, 2409, 2410,
    2411, 2412, 202, 202, 202, 202, 202, 202,

    2413, 2414, 2415, 2415, 202, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 202, 202, 2416,
    2416, 202, 202, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 202, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 202, 2416, 2416, 202, 2416, 2416, 2416,
    2416, 2416, 202, 2417, 2418, 2416, 2419, 2415,
    2414, 2415, 2415, 2415, 2415, 202, 202, 2415,
    2415, 202, 202, 2420, 2420, 2421, 202, 202,
    2422, 202, 202, 202, 202, 202, 202, 2419,
    202, 202, 202, 202, 202, 2416, 2416, 2416,
    2416, 2416, 2415, 2415, 202, 202, 2423, 2423,
    2423, 2423, 2423, 2423, 2423, 202, 202, 202,
    2423, 2423, 2423, 2423, 2423, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2424, 2424, 2424, 2424, 2424, 2424, 2424, 2424,
    2424, 2424, 2424, 2424, 2424, 2424, 2424, 2424,
    2424, 2424, 2424, 2424, 2424, 2424, 2424, 2424,
    2424, 2424, 2424, 2424, 2424, 2424, 2424, 2424,
    2424, 2424, 2424, 2424, 2424, 2424, 2424, 2424,
    2424, 2424, 2424, 2424, 2424, 2424, 2424, 2424,
    2424, 2424, 2424, 2424, 2424, 2425, 2425, 2425,
    2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426,
    2425, 2425, 2427, 2426, 2426, 2425, 2428, 2424,
    2424, 2424, 2424, 2429, 2429, 2430, 2430, 2431,
    2432, 2433, 2434, 2435, 2436, 2437, 2438, 2439,
    2440, 2441, 2442, 2430, 202, 2431, 2443, 2444,
    2445, 2445, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2446, 2446, 2446, 2446, 2446, 2446, 2446, 2446,
    2447, 2448, 2448, 2449, 2449, 2449, 2449, 2449,
    2449, 2448, 2450, 2451, 2451, 2447, 2451, 2449,
    2449, 2448, 2452, 2453, 2446, 2446, 2454, 2446,
    202, 202, 202, 202, 202, 202, 202, 202,
    2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462,
    2463, 2464, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2465, 2465, 2465, 2465, 2465, 2465, 2465, 2465,
    2465, 2465, 2465, 2465, 2465, 2465, 2465, 2465,
    2465, 2465, 2465, 2465, 2465, 2465, 2465, 2465,
    2465, 2465, 2465, 2465, 2465, 2465, 2465, 2465,
    2465, 2465, 2465, 2465, 2465, 2465, 2465, 2465,
    2465, 2465, 2465, 2465, 2465, 2465, 2465, 2466,
    2467, 2467, 2468, 2468, 2468, 2468, 202, 202,
    2467, 2467, 2469, 2469, 2468, 2468, 2467, 2470,
    2471, 2472, 2473, 2473, 2474, 2474, 2475, 2475,
    2475, 2473, 2476, 2476, 2476, 2476, 2476, 2476,
    2476, 2476, 2476, 2476, 2476, 2476, 2476, 2476,
    2477, 2477, 2477, 2477, 2478, 2478, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2479, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2479, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2479, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2479, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2479, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2479, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2480, 2480, 2480, 2481, 2481, 2481, 2481, 2481,
    2481, 2481, 2481, 2480, 2480, 2481, 2480, 2482,
    2481, 2483, 2483, 2484, 2479, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2485, 2486, 2487, 2488, 2489, 2490, 2491, 2492,
    2493, 2494, 202, 202, 202, 202, 202, 202,
    2495, 2495, 2495, 2495, 2495, 2495, 2495, 2495,
    2495, 2495, 2495, 2495, 2495, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2496, 2496, 2496, 2496, 2496, 2496, 2496, 2496,
    2496, 2496, 2496, 2496, 2496, 2496, 2496, 2496,
    2496, 2496, 2496, 2496, 2496, 2496, 2496, 2496,
    2496, 2496, 2496, 2496, 2496, 2496, 2496, 2496,
    2496, 2496, 2496, 2496, 2496, 2496, 2496, 2496,
    2496, 2496, 2496, 2497, 2498, 2497, 2498, 2498,
    2497, 2497, 2497, 2497, 2497, 2497, 2499, 2500,
    2501, 202, 202, 202, 202, 202, 202, 202,
    2502, 2503, 2504, 2505, 2506, 2507, 2508, 2509,
    2510, 2511, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2512, 2512, 2512, 2512, 2512, 2512,
    2512, 2512, 2513, 202, 202, 2514, 2514, 2514,
    2515, 2515, 2514, 2514, 2514, 2514, 2515, 2514,
    2514, 2514, 2514, 2516, 202, 202, 202, 202,
    2517, 2518, 2519, 2520, 2521, 2522, 2523, 2524,
    2525, 2526, 2527, 2527, 2528, 2528, 2528, 2529,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2530, 2530, 2530, 2530, 2530, 2530, 2530, 2530,
    2530, 2530, 2530, 2530, 2530, 2530, 2530, 2530,
    2530, 2530, 2530, 2530, 2530, 2530, 2530, 2530,
    2530, 2530, 2530, 2530, 2530, 2530, 2530, 2530,
    2530, 2530, 2530, 2530, 2530, 2530, 2530, 2530,
    2530, 2530, 2530, 2530, 2531, 2531, 2531, 2532,
    2532, 2532, 2532, 2532, 2532, 2532, 2532, 2532,
    2531, 2533, 2534, 2535, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2536, 2536, 2536, 2536, 2536, 2536, 2536, 2536,
    2537, 2537, 2537, 2537, 2537, 2537, 2537, 2537,
    2537, 2537, 2537, 2537, 2537, 2537, 2537, 2537,
    2537, 2537, 2537, 2537, 2537, 2537, 2537, 2537,
    2537, 2537, 2537, 2537, 2537, 2537, 2537, 2537,
    2538, 2539, 2540, 2541, 2542, 2543, 2544, 2545,
    2546, 2547, 2548, 2548, 2548, 2548, 2548, 2548,
    2548, 2548, 2548, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 2549,

    2550, 2550, 2550, 2550, 2550, 2550, 2550, 202,
    202, 2550, 202, 202, 2550, 2550, 2550, 2550,
    2550, 2550, 2550, 2550, 202, 2550, 2550, 202,
    2550, 2550, 2550, 2550, 2550, 2550, 2550, 2550,
    2550, 2550, 2550, 2550, 2550, 2550, 2550, 2550,
    2550, 2550, 2550, 2550, 2550, 2550, 2550, 2550,
    2551, 2552, 2552, 2552, 2552, 2552, 202, 2552,
    2553, 202, 202, 2554, 2554, 2555, 2556, 2557,
    2552, 2557, 2552, 2558, 2559, 2560, 2559, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2561, 2562, 2563, 2564, 2565, 2566, 2567, 2568,
    2569, 2570, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2571, 2571, 2571, 2571, 2571, 2571, 2571, 2571,
    202, 202, 2571, 2571, 2571, 2571, 2571, 2571,
    2571, 2571, 2571, 2571, 2571, 2571, 2571, 2571,
    2571, 2571, 2571, 2571, 2571, 2571, 2571, 2571,
    2571, 2571, 2571, 2571, 2571, 2571, 2571, 2571,
    2571, 2571, 2571, 2571, 2571, 2571, 2571, 2571,
    2571, 2572, 2572, 2572, 2573, 2573, 2573, 2573,
    202, 202, 2573, 2573, 2572, 2572, 2572, 2572,
    2574, 2571, 2575, 2571, 2572, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2576, 2577, 2577, 2577, 2577, 2577, 2577, 2578,
    2578, 2577, 2577, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2576, 2576, 2576, 2576, 2576,
    2576, 2576, 2576, 2577, 2579, 2577, 2577, 2577,
    2577, 2580, 2581, 2577, 2577, 2577, 2577, 2582,
    2583, 2584, 2585, 2585, 2584, 2582, 2583, 2579,
    202, 202, 202, 202, 202, 202, 202, 202,
    2586, 2587, 2587, 2587, 2587, 2587, 2587, 2588,
    2588, 2587, 2587, 2587, 2586, 2586, 2586, 2586,
    2586, 2586, 2586, 2586, 2586, 2586, 2586, 2586,
    2586, 2586, 2586, 2586, 2586, 2586, 2586, 2586,
    2586, 2586, 2586, 2586, 2586, 2586, 2586, 2586,
    2586, 2586, 2586, 2586, 2586, 2586, 2586, 2586,
    2586, 2586, 2586, 2586, 2589, 2589, 2590, 2590,
    2590, 2590, 2587, 2587, 2587, 2587, 2587, 2587,
    2587, 2587, 2587, 2587, 2587, 2587, 2587, 2588,
    2587, 2591, 2592, 2593, 2593, 2594, 2595, 2595,
    2595, 2592, 2592, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 2596, 2596, 2596, 2596, 2596, 2596, 2596,
    2596, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2597, 2597, 2597, 2597, 2597, 2597, 2597, 2597,
    2597, 202, 2597, 2597, 2597, 2597, 2597, 2597,
    2597, 2597, 2597, 2597, 2597, 2597, 2597, 2597,
    2597, 2597, 2597, 2597, 2597, 2597, 2597, 2597,
    2597, 2597, 2597, 2597, 2597, 2597, 2597, 2597,
    2597, 2597, 2597, 2597, 2597, 2597, 2597, 2598,
    2599, 2599, 2599, 2599, 2599, 2599, 2599, 202,
    2599, 2599, 2599, 2599, 2599, 2599, 2598, 2600,
    2597, 2601, 2601, 2602, 2602, 2602, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2603, 2604, 2605, 2606, 2607, 2608, 2609, 2610,
    2611, 2612, 2613, 2613, 2613, 2613, 2613, 2613,
    2613, 2613, 2613, 2613, 2613, 2613, 2613, 2613,
    2613, 2613, 2613, 2613, 2613, 202, 202, 202,
    2614, 2615, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    2616, 2616, 2616, 2616, 2616, 2616, 2616, 2616,
    202, 202, 2617, 2617, 2617, 2617, 2617, 2617,
    2617, 2617, 2617, 2617, 2617, 2617, 2617, 2617,
    2617, 2617, 2617, 2617, 2617, 2617, 2617, 2617,
    202, 2618, 2617, 2617, 2617, 2617, 2617, 2617,
    2617, 2618, 2617, 2617, 2618, 2617, 2617, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2619, 2619, 2619, 2619, 2619, 2619, 2619, 202,
    2619, 2619, 202, 2619, 2619, 2619, 2619, 2619,
    2619, 2619, 2619, 2619, 2619, 2619, 2619, 2619,
    2619, 2619, 2619, 2619, 2619, 2619, 2619, 2619,
    2619, 2619, 2619, 2619, 2619, 2619, 2619, 2619,
    2619, 2619, 2619, 2619, 2619, 2619, 2619, 2619,
    2619, 2620, 2620, 2620, 2620, 2620, 2620, 202,
    202, 202, 2620, 202, 2620, 2620, 202, 2620,
    2620, 2620, 2621, 2620, 2622, 2622, 2623, 2620,
    202, 202, 202, 202, 202, 202, 202, 202,
    2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631,
    2632, 2633, 202, 202, 202, 202, 202, 202,
    2634, 2634, 2634, 2634, 2634, 2634, 202, 2634,
    2634, 202, 2634, 2634, 2634, 2634, 2634, 2634,
    2634, 2634, 2634, 2634, 2634, 2634, 2634, 2634,
    2634, 2634, 2634, 2634, 2634, 2634, 2634, 2634,
    2634, 2634, 2634, 2634, 2634, 2634, 2634, 2634,
    2634, 2634, 2635, 2635, 2635, 2635, 2635, 202,
    2636, 2636, 202, 2635, 2635, 2636, 2635, 2637,
    2634, 202, 202, 202, 202, 202, 202, 202,
    2638, 2639, 2640, 2641, 2642, 2643, 2644, 2645,
    2646, 2647, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2648, 2648, 2648, 2648, 2648, 2648, 2648, 2648,
    2648, 2648, 2648, 2648, 2648, 2648, 2648, 2648,
    2648, 2648, 2648, 2649, 2649, 2650, 2650, 2651,
    2651, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2652, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2653, 2653, 2653, 2653, 2653, 2653, 2653, 2653,
    2653, 2653, 2653, 2653, 2653, 2653, 2653, 2653,
    2653, 2653, 2653, 2653, 2653, 2654, 2654, 2654,
    2654, 2654, 2654, 2654, 2654, 2655, 2655, 2655,
    2655, 2654, 2654, 2654, 2654, 2654, 2654, 2654,
    2654, 2654, 2654, 2654, 2654, 2654, 2654, 2654,
    2654, 2654, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 2656,

    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,

    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2657,
    2657, 2657, 2657, 2657, 2657, 2657, 2657, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2658, 2658, 2658, 2658, 2658, 2658, 2658,
    2658, 2659, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2660, 2660, 2660, 2660, 2660,
    2660, 2660, 2660, 2661, 2661, 2661, 2661, 2661,
    2661, 2661, 2661, 2661, 2661, 2661, 2661, 202,
    2662, 2662, 2662, 2662, 2663, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,

    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 2659, 2659, 2659, 2659,
    2659, 2659, 2659, 2659, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,

    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2665, 2665, 2665, 2666, 2666, 2666, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2666, 2664, 2664, 2664, 2665, 2666,
    2665, 2666, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,

    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2665, 2666, 2666, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,

    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 2664,
    2664, 2664, 2664, 2664, 2664, 2664, 2664, 202,
    2667, 2667, 2667, 2667, 2667, 2667, 2667, 2668,
    2669, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,

    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2671, 2672,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,

    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 2670,
    2670, 2670, 2670, 2670, 2670, 2670, 2670, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,

    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 2673, 2673, 2673, 2673, 2673, 2673, 2673,
    2673, 202, 202, 202, 202, 202, 202, 202,
    2674, 2674, 2674, 2674, 2674, 2674, 2674, 2674,
    2674, 2674, 2674, 2674, 2674, 2674, 2674, 2674,
    2674, 2674, 2674, 2674, 2674, 2674, 2674, 2674,
    2674, 2674, 2674, 2674, 2674, 2674, 2674, 202,
    2675, 2676, 2677, 2678, 2679, 2680, 2681, 2682,
    2683, 2684, 202, 202, 202, 202, 2685, 2685,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2686, 2686, 2686, 2686, 2686, 2686, 2686, 2686,
    2686, 2686, 2686, 2686, 2686, 2686, 2686, 2686,
    2686, 2686, 2686, 2686, 2686, 2686, 2686, 2686,
    2686, 2686, 2686, 2686, 2686, 2686, 202, 202,
    2687, 2687, 2687, 2687, 2687, 2688, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2690, 2690, 2690, 2690, 2690, 2690, 2690, 2691,
    2691, 2692, 2693, 2693, 2694, 2694, 2694, 2694,
    2695, 2695, 2695, 2695, 2691, 2694, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2696, 2697, 2698, 2699, 2700, 2701, 2702, 2703,
    2704, 2705, 202, 2706, 2706, 2706, 2706, 2706,
    2706, 2706, 202, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    202, 202, 202, 202, 202, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    2689, 2689, 2689, 2689, 2689, 2689, 2689, 2689,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2707, 2707, 2707, 2707, 2707, 2707, 2707, 2707,
    2707, 2707, 2707, 2707, 2707, 2707, 2707, 2707,
    2707, 2707, 2707, 2707, 2707, 2707, 2707, 2707,
    2707, 2707, 2707, 2707, 2707, 2707, 2707, 2707,
    2708, 2708, 2708, 2708, 2708, 2708, 2708, 2708,
    2708, 2708, 2708, 2708, 2708, 2708, 2708, 2708,
    2708, 2708, 2708, 2708, 2708, 2708, 2708, 2708,
    2708, 2708, 2708, 2708, 2708, 2708, 2708, 2708,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2709,
    2709, 2709, 2709, 2709, 2709, 2709, 2709, 2710,
    2711, 2712, 2712, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2713, 2713, 2713,
    2713, 2713, 2713, 2713, 2713, 2714, 2714, 2714,
    2714, 2714, 2714, 202, 202, 202, 202, 2715,
    2713, 2716, 2716, 2716, 2716, 2716, 2716, 2716,
    2716, 2716, 2716, 2716, 2716, 2716, 2716, 2716,
    2716, 2716, 2716, 2716, 2716, 2716, 2716, 2716,
    2716, 2716, 2716, 2716, 2716, 2716, 2716, 2716,
    2716, 2716, 2716, 2716, 2716, 2716, 2716, 2716,
    2716, 2716, 2716, 2716, 2716, 2716, 2716, 2717,
    2717, 2717, 2717, 2717, 2717, 2717, 2717, 2717,
    202, 202, 202, 202, 202, 202, 202, 2718,
    2718, 2718, 2718, 2719, 2719, 2719, 2719, 2719,
    2719, 2719, 2719, 2719, 2719, 2719, 2719, 2719,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2720, 2721, 2722, 2723, 2724, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2725, 2725, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,

    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2727, 2727, 2727,
    2727, 2727, 2728, 2728, 2728, 2728, 2728, 2728,
    202, 202, 202, 202, 202, 202, 202, 202,

    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2726, 2726, 2726, 2726, 2726,
    2726, 2726, 2726, 2729, 2729, 2729, 2729, 2729,
    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2729,

    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,

    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 2730, 2730,
    2730, 2730, 2730, 2730, 2730, 2730, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2729, 2729, 2729, 2729, 2729, 2729, 2729, 2729,
    2729, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2731, 2732, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,

    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 2733,
    2733, 2733, 2733, 2733, 2733, 2733, 2733, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2734, 2734, 2734, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 2735, 2735, 2735, 2735,
    202, 202, 202, 202, 202, 202, 202, 202,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,

    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 2736, 2736, 2736, 2736,
    2736, 2736, 2736, 2736, 202, 202, 202, 202,

    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 202, 202, 202, 202, 202,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 2737, 2737, 2737, 202, 202, 202,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 202, 202, 202, 202, 202, 202, 202,
    2737, 2737, 2737, 2737, 2737, 2737, 2737, 2737,
    2737, 2737, 202, 202, 2738, 2739, 2740, 2741,
    2742, 2742, 2742, 2742, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 202,
    202, 1465, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2744, 2744,
    2744, 2744, 2744, 2744, 2744, 2745, 2746, 2747,
    2747, 2747, 2743, 2743, 2743, 2748, 2745, 2745,
    2745, 2745, 2745, 2749, 2749, 2749, 2749, 2749,
    2749, 2749, 2749, 2750, 2750, 2750, 2750, 2750,
    2750, 2750, 2750, 2743, 2743, 2751, 2751, 2751,
    2751, 2751, 2750, 2750, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2751, 2751, 2751, 2751, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2744, 2744, 2744, 2744, 2744,
    2744, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2743, 2743,
    2743, 2743, 2743, 2743, 2743, 2743, 2752, 2752,
    2752, 2752, 2752, 2752, 2752, 2752, 2752, 2752,
    2752, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2130, 2130, 2130, 2130, 2130, 2130,
    2130, 2130, 2753, 2753, 2753, 2130, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2754, 2754, 2754, 2754, 2754, 2754, 2754, 2754,
    2754, 2754, 2754, 2754, 2754, 2754, 2754, 2754,
    2754, 2754, 2754, 2754, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2755, 2755, 2755, 2755, 2755, 2755, 2755, 2755,
    2755, 2755, 2755, 2755, 2755, 2755, 2755, 2755,
    2755, 2755, 2754, 2754, 2754, 2754, 2754, 2754,
    2754, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 202, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2756, 202, 2756, 2756,
    202, 202, 2756, 202, 202, 2756, 2756, 202,
    202, 2756, 2756, 2756, 2756, 202, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2757, 2757,
    2757, 2757, 202, 2757, 202, 2757, 2757, 2757,
    2757, 2758, 2757, 2757, 202, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,

    2757, 2757, 2757, 2757, 2756, 2756, 202, 2756,
    2756, 2756, 2756, 202, 202, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 202, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 202, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 202, 2756, 2756, 2756, 2756, 202,
    2756, 2756, 2756, 2756, 2756, 202, 2756, 202,
    202, 202, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 202, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,

    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 1457, 1457, 202, 202,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2759, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2760, 2757, 2757, 2757, 2757,
    2757, 2757, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2759, 2757, 2757, 2757, 2757,

    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2760, 2757, 2757,
    2757, 2757, 2757, 2757, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2759, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2760,
    2757, 2757, 2757, 2757, 2757, 2757, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2759,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2760, 2757, 2757, 2757, 2757, 2757, 2757,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2756, 2756, 2756, 2756, 2756, 2756, 2756,
    2756, 2759, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2757, 2757, 2757, 2757, 2757,
    2757, 2757, 2757, 2760, 2757, 2757, 2757, 2757,
    2757, 2757, 2761, 2762, 202, 202, 2763, 2764,
    2765, 2766, 2767, 2768, 2769, 2770, 2771, 2772,
    2763, 2764, 2765, 2766, 2767, 2768, 2769, 2770,
    2771, 2772, 2763, 2764, 2765, 2766, 2767, 2768,
    2769, 2770, 2771, 2772, 2763, 2764, 2765, 2766,
    2767, 2768, 2769, 2770, 2771, 2772, 2763, 2764,
    2765, 2766, 2767, 2768, 2769, 2770, 2771, 2772,

    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,

    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2773,
    2773, 2773, 2773, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2774, 2773, 2773,
    2773, 2773, 2773, 2773, 2773, 2773, 2773, 2773,
    2773, 2773, 2773, 2773, 2774, 2773, 2773, 2775,
    2776, 2775, 2775, 2777, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 2774, 2774, 2774, 2774, 2774,
    202, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    2774, 2774, 2774, 2774, 2774, 2774, 2774, 2774,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2778, 2778, 2778, 2778, 2778, 2778, 2778, 202,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 2778, 2778, 2778, 2778, 2778, 2778,
    2778, 202, 202, 2778, 2778, 2778, 2778, 2778,
    2778, 2778, 202, 2778, 2778, 202, 2778, 2778,
    2778, 2778, 2778, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    2779, 2779, 2779, 2779, 2779, 2779, 2779, 2779,
    2779, 2779, 2779, 2779, 2779, 2779, 2779, 2779,
    2779, 2779, 2779, 2779, 2779, 2779, 2779, 2779,
    2779, 2779, 2779, 2779, 2779, 2779, 2779, 2779,
    2779, 2779, 2779, 2779, 2779, 2779, 2779, 2779,
    2779, 2779, 2779, 2779, 2779, 202, 202, 202,
    2780, 2780, 2780, 2780, 2780, 2780, 2780, 2781,
    2781, 2781, 2781, 2781, 2781, 2781, 202, 202,
    2782, 2783, 2784, 2785, 2786, 2787, 2788, 2789,
    2790, 2791, 202, 202, 202, 202, 2779, 2792,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2793, 2793, 2793, 2793, 2793, 2793, 2793, 2793,
    2793, 2793, 2793, 2793, 2793, 2793, 2793, 2793,
    2793, 2793, 2793, 2793, 2793, 2793, 2793, 2793,
    2793, 2793, 2793, 2793, 2793, 2793, 2793, 2793,
    2793, 2793, 2793, 2793, 2793, 2793, 2793, 2793,
    2793, 2793, 2793, 2793, 2794, 2794, 2794, 2794,
    2795, 2796, 2797, 2798, 2799, 2800, 2801, 2802,
    2803, 2804, 202, 202, 202, 202, 202, 2805,

    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 2806, 2806, 2806,
    2806, 2806, 2806, 2806, 2806, 301, 301, 2807,
    2807, 2807, 2807, 2807, 2807, 2807, 2807, 2807,
    2808, 2808, 2808, 2808, 2808, 2808, 2808, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2809, 2809, 2809, 2809, 2809, 2809, 2809, 2809,
    2809, 2809, 2809, 2809, 2809, 2809, 2809, 2809,
    2809, 2809, 2809, 2809, 2809, 2809, 2809, 2809,
    2809, 2809, 2809, 2809, 2809, 2809, 2809, 2809,
    2809, 2809, 2810, 2810, 2810, 2810, 2810, 2810,
    2810, 2810, 2810, 2810, 2810, 2810, 2810, 2810,
    2810, 2810, 2810, 2810, 2810, 2810, 2810, 2810,
    2810, 2810, 2810, 2810, 2810, 2810, 2810, 2810,
    2810, 2810, 2810, 2810, 2811, 2811, 2811, 2811,
    2811, 2811, 2812, 2813, 301, 301, 301, 301,
    2814, 2815, 2816, 2817, 2818, 2819, 2820, 2821,
    2822, 2823, 301, 301, 301, 301, 2824, 2824,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2825, 2825, 2825, 2825,
    2825, 2825, 2825, 2825, 2826, 2825, 2825, 2825,
    2827, 2825, 2825, 2825, 2825, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    301, 2828, 2828, 2828, 2828, 2828, 2828, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 2828, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 2828, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 2828, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 2828, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 2829, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 2828, 2828,
    2828, 2828, 2828, 2828, 2828, 2828, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,

    2830, 2830, 2830, 2830, 348, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    348, 2830, 2830, 348, 2830, 348, 348, 2830,
    348, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 348, 2830, 2830, 2830, 2830,
    348, 2830, 348, 2830, 348, 348, 348, 348,
    348, 348, 2830, 348, 348, 348, 348, 2830,
    348, 2830, 348, 2830, 348, 2830, 2830, 2830,
    348, 2830, 2830, 348, 2830, 348, 348, 2830,
    348, 2830, 348, 2830, 348, 2830, 348, 2830,
    348, 2830, 2830, 348, 2830, 348, 348, 2830,
    2830, 2830, 2830, 348, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 348, 2830, 2830, 2830, 2830,
    348, 2830, 2830, 2830, 2830, 348, 2830, 348,
    2830, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 348, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 348, 348, 348, 348,
    348, 2830, 2830, 2830, 348, 2830, 2830, 2830,
    2830, 2830, 348, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 2830, 2830, 2830, 2830,
    2830, 2830, 2830, 2830, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,
    2831, 2831, 348, 348, 348, 348, 348, 348,
    348, 348, 348, 348, 348, 348, 348, 348,

    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1733, 1733, 1733, 1733,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1546, 1546,
    1546, 1546, 1546, 1546, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1733,
    1733, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1548,
    1733, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1733, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    2832, 2832, 2833, 2834, 2835, 2836, 2837, 2838,
    2839, 2840, 2841, 2842, 2842, 2843, 2843, 2843,
    2844, 2844, 2844, 2844, 2844, 2844, 2844, 2844,
    2844, 2844, 2844, 2844, 2844, 2844, 2844, 2844,
    2844, 2844, 2844, 2844, 2844, 2844, 2844, 2844,
    2844, 2844, 2844, 2844, 2844, 2844, 2844, 1597,
    2845, 2846, 2845, 2845, 2845, 2845, 2845, 2845,
    2845, 2845, 2845, 2845, 2845, 2846, 2845, 2846,
    2845, 2845, 2846, 2845, 2845, 2845, 2846, 2845,
    2845, 2845, 2844, 2844, 2844, 2844, 2844, 2847,
    2848, 2848, 2848, 2848, 2848, 2848, 2848, 2849,
    2848, 2848, 2848, 2848, 2848, 2848, 2848, 2849,
    2848, 2848, 2848, 2848, 2848, 2848, 2848, 2848,
    2848, 2848, 2850, 2850, 2851, 2843, 2843, 2843,
    2848, 2848, 2848, 2848, 2848, 2848, 2848, 2848,
    2848, 2849, 2848, 2849, 2849, 2848, 2848, 2849,
    2848, 2848, 2848, 2848, 2848, 2848, 2848, 2848,
    2848, 2848, 813, 813, 813, 813, 2852, 2852,
    2844, 2852, 2852, 2852, 2852, 2852, 2852, 2852,
    2852, 2852, 2852, 2853, 2853, 2853, 2853, 2853,
    2853, 2853, 2853, 2853, 2853, 2853, 2853, 2853,
    2853, 2853, 2853, 2853, 2853, 2843, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 2854, 2854,
    2854, 2854, 2854, 2854, 2854, 2854, 2854, 2854,
    2854, 2854, 2854, 2854, 2854, 2854, 2854, 2854,
    2854, 2854, 2854, 2854, 2854, 2854, 2854, 2854,

    2855, 2856, 2856, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 2856, 2856, 2856, 2856, 2856, 2856,
    2856, 2856, 2856, 2857, 1733, 1733, 1733, 1733,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2856, 2856, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2858, 2858, 2858, 2858, 2858, 2858, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 2859, 2859, 2859,
    1511, 1511, 1511, 1511, 1511, 1511, 1548, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1548, 2859, 2859,
    1511, 1511, 1511, 1511, 1511, 1549, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1512, 1512, 1548, 1548,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1510, 1510, 1511,
    1511, 1511, 1511, 1511, 1510, 1511, 1511, 1511,
    1511, 1511, 1549, 1549, 1549, 1548, 1511, 1549,
    1511, 1511, 1549, 2860, 2860, 1548, 1548, 2859,
    2859, 2859, 2859, 2859, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2859, 2859, 2859, 2861, 2861, 2861, 2861, 2861,

    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1548,
    1511, 1548, 1549, 1549, 1511, 1511, 1549, 1549,
    1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
    1549, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1549, 1549,
    1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
    1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
    1549, 1511, 1511, 1511, 1549, 1511, 1511, 1511,
    1511, 1549, 1549, 1549, 1511, 1549, 1549, 1549,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1549,
    1511, 1549, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1510, 1511, 1510, 1511, 1510, 1511, 1511, 1511,
    1511, 1511, 1549, 1511, 1511, 1511, 1511, 1510,
    1511, 1510, 1510, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1548, 1511, 1511, 1511, 1511, 1548, 1548, 2859,

    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1512, 1512,
    2862, 2862, 2862, 2862, 1512, 1512, 1512, 1512,
    1512, 1512, 1548, 2859, 2859, 2859, 2859, 2859,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2860, 2860, 1548, 1548,
    1548, 1548, 2863, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2860, 1548, 1548, 1548, 1548, 2860, 2860, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2864, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1512, 1512, 1512, 1512,
    1512, 1512, 1548, 1511, 1511, 1511, 1511, 1511,

    2865, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 2865, 1511, 1511, 1511, 2865, 1511, 2865,
    1511, 2865, 1511, 2865, 1511, 1511, 1511, 2865,
    1511, 1511, 1511, 1511, 1511, 1511, 2865, 2865,
    1511, 1511, 1511, 1511, 2865, 1511, 2865, 2865,
    1511, 1511, 1511, 1511, 2865, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1548, 1548, 2859, 2859, 1549, 1549, 1549,
    1511, 1511, 1511, 1549, 1549, 1549, 1549, 1549,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 2866, 2866,
    2866, 2867, 2867, 2867, 1512, 1512, 1512, 1512,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1549, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1511, 1511, 1511, 1511, 1549, 1549, 1549, 1511,
    1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
    1549, 1511, 1511, 1511, 1511, 1511, 1548, 1548,
    1548, 1548, 1548, 1548, 2860, 1548, 1548, 1548,
    2859, 2864, 2864, 2858, 2858, 2868, 2843, 2843,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1733, 1733, 1733,
    1548, 1548, 1548, 1548, 2864, 2864, 2864, 2858,
    2858, 2869, 2868, 2843, 2843, 1733, 1733, 1733,

    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1510, 1510, 1510, 1510,
    1510, 1510, 1510, 1510, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 2869, 2869, 2869,
    2869, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2868, 2868, 2868, 2868, 2868, 2868, 2868, 2868,
    2868, 2868, 2868, 2868, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1733, 1733, 1733, 1733,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1733, 1733, 1733, 1733, 1733, 1733,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1512, 1512,
    1512, 1512, 1512, 1512, 1512, 1512, 1733, 1733,
    2843, 2843, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1514, 1514, 1514, 1514, 1514, 1514, 1514, 1514,
    1514, 1514, 1514, 1514, 2870, 2868, 2868, 2871,
    2859, 2859, 2859, 2859, 2859, 2859, 2859, 2859,
    2872, 2863, 2863, 2863, 2863, 2863, 2863, 2873,
    2864, 2864, 2864, 2864, 2864, 2864, 2863, 2864,
    2858, 2858, 2858, 2858, 2858, 2858, 2858, 2858,
    2863, 2873, 2873, 2863, 2863, 2863, 2863, 2863,
    2863, 2863, 2864, 2864, 2863, 2863, 2863, 2868,
    2864, 2864, 2864, 2864, 2864, 2864, 2864, 2864,
    2864, 2864, 2864, 2864, 2858, 2869, 2869, 2869,
    2864, 2864, 2864, 2864, 2864, 2864, 2864, 2864,
    2864, 2864, 2864, 2864, 2864, 2864, 2864, 2858,
    2858, 2858, 2858, 2858, 2858, 2858, 2858, 2858,
    2858, 2858, 2858, 2858, 2869, 2869, 2869, 2869,
    2869, 2868, 2843, 2869, 2869, 2869, 2869, 2870,
    2843, 1733, 2869, 2868, 2869, 2869, 2869, 2869,
    2859, 2859, 2859, 2859, 2859, 2864, 2864, 2864,
    2864, 2864, 2864, 2864, 2864, 2864, 2864, 2864,
    2864, 2864, 2858, 2858, 2858, 2858, 2858, 2858,
    2869, 2869, 2869, 2869, 2869, 2869, 2869, 2869,
    2869, 2869, 2869, 2843, 2843, 2868, 2868, 2868,
    2868, 2868, 2868, 2843, 2843, 2843, 2868, 2868,
    2869, 2869, 2869, 2869, 2869, 2874, 2874, 2869,
    2874, 2874, 2868, 2871, 2868, 2868, 2868, 2868,
    2859, 2869, 2869, 2868, 2868, 2868, 2868, 2868,
    2868, 2868, 2868, 2843, 1733, 2871, 2871, 2871,
    2858, 2873, 2873, 2873, 2873, 2873, 2873, 2873,
    2873, 2873, 2873, 2873, 2873, 2873, 2858, 2858,
    2858, 2858, 2858, 2858, 2858, 2858, 2858, 2869,
    2869, 2869, 2869, 2869, 2869, 2869, 2869, 2869,
    2869, 2869, 2869, 2869, 2869, 2869, 2869, 2869,
    2869, 2869, 2869, 2869, 2869, 2869, 2869, 2869,

    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1598, 1598, 1598, 1598,
    1598, 1598, 1598, 1598, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2869, 2869, 2869, 2869, 2869, 2869, 2869, 2869,
    2869, 2869, 2869, 2869, 2869, 2869, 1733, 1733,
    2868, 2868, 2868, 2868, 2843, 1733, 1733, 1733,
    2868, 2868, 2868, 1733, 1733, 1733, 1733, 1733,
    2868, 2868, 2868, 2843, 2843, 2843, 2843, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2868, 2868, 2868, 2868, 2868, 2868, 2843, 2843,
    2843, 2843, 2843, 2843, 2843, 2843, 2843, 2843,
    2843, 2843, 2843, 2843, 2843, 2843, 2843, 2843,
    2843, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2843, 2843, 2843, 2843, 2843, 2843, 2843, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2843, 2843, 2843, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2843, 2843, 2843, 2843, 2843, 2843, 2843, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 202, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 1596, 1596, 1596, 1596, 1596,
    1596, 1596, 1596, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    2875, 2876, 2877, 2878, 2879, 2880, 2881, 2882,
    2883, 2884, 202, 202, 202, 202, 202, 202,

    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 2885, 2885,

    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,

    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 2886,
    2886, 2886, 2886, 2886, 2886, 2886, 2886, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,

    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1728, 1728, 1728,
    1728, 1728, 1728, 1728, 1728, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,

    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 2887, 2887,
    2887, 2887, 2887, 2887, 2887, 2887, 1733, 1733,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,

    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,

    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,

    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,

    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1731, 1731, 1731, 1731, 1731, 1731, 1731,
    1731, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,

    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 2888, 2888,
    2888, 2888, 2888, 2888, 2888, 2888, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,

    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1724, 1724, 1724,
    1724, 1724, 1724, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,
    1733, 1733, 1733, 1733, 1733, 1733, 1733, 1733,

    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 202, 202, 202, 202, 2885, 2885,

    1403, 2749, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    2889, 2889, 2889, 2889, 2889, 2889, 2889, 2889,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,

    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    2890, 2890, 2890, 2890, 2890, 2890, 2890, 2890,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,

    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403,

    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,

    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2891, 2891,
    2891, 2891, 2891, 2891, 2891, 2891, 2885, 2885
};

#define GET_PROP_INDEX(ucs4) \
       (ucs4 < 0x11000 \
        ? (uc_property_trie[uc_property_trie[ucs4>>5] + (ucs4 & 0x1f)]) \
        : (uc_property_trie[uc_property_trie[((ucs4 - 0x11000)>>8) + 0x880] + (ucs4 & 0xff)]))

#define GET_PROP_INDEX_UCS2(ucs2) \
       (uc_property_trie[uc_property_trie[ucs2>>5] + (ucs2 & 0x1f)])

static const Properties uc_properties[] = {
    { 9, 18, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 0, 21, 0, 2 },
    { 9, 8, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 0, 17, 5, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 2, 2, 37, 2, 2 },
    { 9, 8, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 3, 38, 5, 2 },
    { 9, 9, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 3, 38, 5, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 1, 1, 36, 1, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 0, 21, 0, 2 },
    { 9, 8, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 0, 21, 0, 2 },
    { 6, 9, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 22, 35, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 12, 3, 13, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 11, 3, 13, 2 },
    { 21, 10, 0, 0, -1, 1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 2, 13, 2 },
    { 26, 3, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 11, 2 },
    { 20, 3, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 16, 11, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 10, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 7, 0, 2 },
    { 3, 2, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 8, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 0, 2 },
    { 26, 10, 0, 0, -1, 2, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 3 },
    { 21, 10, 0, 0, -1, 2, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 22, 10, 0, 0, -1, -2, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 2, 13, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 19, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 17, 12, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 26, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 22, 10, 0, 0, -1, -2, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 9, 7, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 3, 38, 3, 2 },
    { 6, 6, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 4, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 23, 10, 0, 0, -1, 16, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 10, 18, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 17, 4, 2 },
    { 29, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 26, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 5, 2, 0, 0, 2, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 3, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 743}, {0, 743}, {0, 775} }, 0, 10, 12, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 12, 0, 2 },
    { 5, 2, 0, 0, 1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 24, 10, 0, 0, -1, -16, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 5, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 418}, {1, 415}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 121}, {0, 121}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {1, 421}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -232}, {0, -232}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 80,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 500}, {1, 500}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -121}, {0, 0}, {0, 0}, {0, -121} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -300}, {0, -300}, {0, -268} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 195}, {0, 195}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 210}, {0, 0}, {0, 0}, {0, 210} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 206}, {0, 0}, {0, 0}, {0, 206} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 205}, {0, 0}, {0, 0}, {0, 205} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 79}, {0, 0}, {0, 0}, {0, 79} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 202}, {0, 0}, {0, 0}, {0, 202} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 203}, {0, 0}, {0, 0}, {0, 203} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 207}, {0, 0}, {0, 0}, {0, 207} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 97}, {0, 97}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 211}, {0, 0}, {0, 0}, {0, 211} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 209}, {0, 0}, {0, 0}, {0, 209} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 163}, {0, 163}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 213}, {0, 0}, {0, 0}, {0, 213} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 130}, {0, 130}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 214}, {0, 0}, {0, 0}, {0, 214} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 218}, {0, 0}, {0, 0}, {0, 218} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 217}, {0, 0}, {0, 0}, {0, 217} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 219}, {0, 0}, {0, 0}, {0, 219} }, 0, 10, 12, 7, 3 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 56}, {0, 56}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 80,  { {0, 2}, {0, 0}, {0, 1}, {0, 2} }, 0, 10, 12, 7, 3 },
    { 16, 0, 0, 0, -1, 0, 1, 80,  { {0, 1}, {0, -1}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -2}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -79}, {0, -79}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 511}, {1, 511}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {0, -97}, {0, 0}, {0, 0}, {0, -97} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {0, -56}, {0, 0}, {0, 0}, {0, -56} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 17,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 4, 17,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 6, 0,  { {0, -130}, {0, 0}, {0, 0}, {0, -130} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {1, 1}, {0, 0}, {0, 0}, {1, 1} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {0, -163}, {0, 0}, {0, 0}, {0, -163} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {1, 3}, {0, 0}, {0, 0}, {1, 3} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {1, 5}, {1, 5}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {1, 7}, {1, 7}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {0, -195}, {0, 0}, {0, 0}, {0, -195} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {0, 69}, {0, 0}, {0, 0}, {0, 69} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {0, 71}, {0, 0}, {0, 0}, {0, 71} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 9}, {1, 9}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 11}, {1, 11}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 13}, {1, 13}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -210}, {0, -210}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -206}, {0, -206}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -205}, {0, -205}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -202}, {0, -202}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -203}, {0, -203}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 15}, {1, 15}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 17}, {1, 17}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -207}, {0, -207}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 19}, {1, 19}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 21}, {1, 21}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -209}, {0, -209}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -211}, {0, -211}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 23}, {1, 23}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 25}, {1, 25}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 27}, {1, 27}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 29}, {1, 29}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -213}, {0, -213}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -214}, {0, -214}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 31}, {1, 31}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -218}, {0, -218}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 33}, {1, 33}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 35}, {1, 35}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -69}, {0, -69}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -217}, {0, -217}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -71}, {0, -71}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -219}, {0, -219}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 37}, {1, 37}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {1, 39}, {1, 39}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 17, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 18, 8, 2 },
    { 28, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 18, 0, 2 },
    { 28, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 36 },
    { 17, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 28, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 28, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 0, 17, 230, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 232, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 216, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 202, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 202, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 1, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 1, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 240, 5, -1, 0, 1, 204,  { {0, 0}, {0, 84}, {0, 84}, {0, 116} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 232, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 17, 10, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 13, 0, 0, 0, -1, 0, 0, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 17, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 130}, {0, 130}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 25, 10, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {0, 116}, {0, 0}, {0, 0}, {0, 116} }, 0, 10, 12, 7, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 81,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 38}, {0, 0}, {0, 0}, {0, 38} }, 0, 10, 12, 7, 4 },
    { 25, 10, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 37}, {0, 0}, {0, 0}, {0, 37} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 64}, {0, 0}, {0, 0}, {0, 64} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 63}, {0, 0}, {0, 0}, {0, 63} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 503}, {1, 503}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -38}, {0, -38}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -37}, {0, -37}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 507}, {1, 507}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -31}, {0, -31}, {0, 1} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -64}, {0, -64}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -63}, {0, -63}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {0, 8}, {0, 0}, {0, 0}, {0, 8} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -62}, {0, -62}, {0, -30} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -57}, {0, -57}, {0, -25} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 81,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -47}, {0, -47}, {0, -15} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -54}, {0, -54}, {0, -22} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, -8}, {0, -8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 6, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 46 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 46 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -86}, {0, -86}, {0, -54} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -80}, {0, -80}, {0, -48} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 7}, {0, 7}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -116}, {0, -116}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 5, 80,  { {0, -60}, {0, 0}, {0, 0}, {0, -60} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 5, 80,  { {0, 0}, {0, -96}, {0, -96}, {0, -64} }, 0, 10, 12, 6, 4 },
    { 26, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 14, 0, 0, 0, -1, 0, 7, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 7, 80,  { {0, -7}, {0, 0}, {0, 0}, {0, -7} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {0, -130}, {0, 0}, {0, 0}, {0, -130} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 4, 17,  { {0, 80}, {0, 0}, {0, 0}, {0, 80} }, 0, 10, 12, 7, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 80}, {0, 0}, {0, 0}, {0, 80} }, 0, 10, 12, 7, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 80}, {0, 0}, {0, 0}, {0, 80} }, 0, 10, 12, 7, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 4, 17,  { {0, 0}, {0, -80}, {0, -80}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -80}, {0, -80}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -80}, {0, -80}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 29, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 5 },
    { 0, 17, 230, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 5 },
    { 0, 17, 230, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 5 },
    { 2, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 5 },
    { 14, 0, 0, 0, -1, 0, 6, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 15}, {0, 0}, {0, 0}, {0, 15} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, -15}, {0, -15}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 4, 17,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 4, 17,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 11, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 12, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 5 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 48}, {0, 0}, {0, 0}, {0, 48} }, 0, 10, 12, 7, 6 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 11, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 12, 0, 6 },
    { 15, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, -48}, {0, -48}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 467}, {1, 464}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 12, 6 },
    { 20, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 17, 0, 6 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 6 },
    { 27, 4, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 6 },
    { 13, 1, 0, 0, -1, 0, 0, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 0, 17, 220, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 230, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 222, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 220, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 228, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 10, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 11, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 12, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 13, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 14, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 15, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 16, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 17, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 18, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 19, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 19, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 20, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 21, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 22, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 20, 1, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 7 },
    { 0, 17, 23, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 25, 1, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 7 },
    { 0, 17, 24, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 0, 17, 25, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 25, 1, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 7 },
    { 0, 17, 18, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 18, 1, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 9, 13, 8, 7 },
    { 18, 1, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 9, 13, 8, 7 },
    { 25, 1, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 7 },
    { 25, 1, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 12, 0, 7 },
    { 10, 5, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 8 },
    { 10, 5, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 8 },
    { 10, 5, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 2 },
    { 26, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 26, 13, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 25, 4, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 8 },
    { 27, 13, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 8 },
    { 25, 13, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 11, 8 },
    { 29, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 0, 17, 230, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 230, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 30, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 31, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 32, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 2 },
    { 10, 13, 0, 5, -1, 0, 15, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 8 },
    { 13, 13, 0, 0, -1, 0, 0, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 25, 13, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 2 },
    { 18, 13, 0, 2, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 17, 13, 0, 1, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 0, 17, 27, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 28, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 29, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 30, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 31, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 32, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 33, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 34, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 4, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 4, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 230, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 220, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 220, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 3, 5, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 5, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 25, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 8 },
    { 25, 5, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 25, 5, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 11, 9, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 18, 13, 0, 2, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 0, 17, 35, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 18, 13, 0, 3, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 25, 13, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 8 },
    { 0, 17, 230, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 10, 5, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 0, 17, 220, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 17, 13, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 3, 2, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 3, 2, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 8 },
    { 29, 13, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 18, 13, 0, 2, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 25, 13, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 9 },
    { 25, 13, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 9 },
    { 10, 13, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 9 },
    { 18, 13, 0, 3, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 0, 17, 36, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 9 },
    { 18, 13, 0, 2, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 18, 13, 0, 2, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 18, 13, 0, 3, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 0, 17, 230, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 9 },
    { 0, 17, 220, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 9 },
    { 18, 13, 0, 2, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 10 },
    { 0, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 10 },
    { 18, 13, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 10 },
    { 3, 1, 0, 0, 0, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 2, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 3, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 4, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 5, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 6, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 7, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 8, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 3, 1, 0, 0, 9, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 66 },
    { 18, 1, 0, 2, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 66 },
    { 0, 17, 230, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 66 },
    { 0, 17, 220, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 66 },
    { 17, 1, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 66 },
    { 29, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 66 },
    { 25, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 66 },
    { 25, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 11, 66 },
    { 25, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 66 },
    { 17, 1, 0, 1, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 66 },
    { 0, 17, 220, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 66 },
    { 27, 1, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 66 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 82 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 82 },
    { 17, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 82 },
    { 25, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 82 },
    { 25, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 82 },
    { 18, 1, 0, 3, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 95 },
    { 18, 1, 0, 2, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 95 },
    { 0, 17, 220, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 95 },
    { 25, 1, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 95 },
    { 18, 13, 0, 2, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 18, 13, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 18, 13, 0, 3, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 9 },
    { 18, 13, 0, 2, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 3, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 18, 13, 0, 2, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 0, 17, 220, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 230, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 10, 5, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 2 },
    { 0, 17, 220, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 230, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 220, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 27, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 28, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 29, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 230, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 8 },
    { 0, 17, 0, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 11 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 0, 17, 0, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 1, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 11 },
    { 0, 17, 7, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 11 },
    { 18, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 2 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 11 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 11 },
    { 17, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 12 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 12 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 12 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 12 },
    { 0, 17, 7, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 12 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 12 },
    { 1, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 12 },
    { 1, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 12 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 12 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 12 },
    { 18, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 12 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 12 },
    { 27, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 12 },
    { 5, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 12 },
    { 5, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 12 },
    { 29, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 12 },
    { 27, 4, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 12 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 12 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 12 },
    { 0, 17, 230, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 12 },
    { 0, 17, 0, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 13 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 13 },
    { 1, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 13 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 13 },
    { 18, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 13 },
    { 0, 17, 7, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 13 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 13 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 13 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 13 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 13 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 13 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 14 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 14 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 14 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 14 },
    { 0, 17, 7, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 14 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 14 },
    { 0, 17, 0, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 14 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 14 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 14 },
    { 27, 4, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 14 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 14 },
    { 0, 17, 0, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 14 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 15 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 15 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 15 },
    { 0, 17, 7, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 1, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 1, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 15 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 0, 17, 0, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 0, 17, 0, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 15 },
    { 18, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 15 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 15 },
    { 29, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 15 },
    { 5, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 15 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 16 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 16 },
    { 18, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 16 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 16 },
    { 1, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 16 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 16 },
    { 1, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 16 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 16 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 16 },
    { 3, 0, 0, 0, 0, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 16 },
    { 5, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 16 },
    { 29, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 16 },
    { 27, 4, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 16 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 17 },
    { 0, 17, 0, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 17 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 17 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 17 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 0, 17, 0, 5, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 0, 17, 84, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 0, 17, 91, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 17 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 17 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 17 },
    { 25, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 17 },
    { 5, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 17 },
    { 29, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 17 },
    { 18, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 18 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 18 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 18 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 18 },
    { 0, 17, 7, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 18 },
    { 0, 0, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 1, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 18 },
    { 1, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 0, 17, 0, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 18 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 18 },
    { 18, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 18 },
    { 0, 17, 0, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 1, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 19 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 19 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 19 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 19 },
    { 0, 17, 9, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 19 },
    { 1, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 1, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 19 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 19 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 19 },
    { 29, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 19 },
    { 18, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 19 },
    { 5, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 19 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 19 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 19 },
    { 5, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 19 },
    { 29, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 19 },
    { 0, 17, 0, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 20 },
    { 1, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 20 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 20 },
    { 0, 17, 9, 5, -1, 0, 4, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 20 },
    { 1, 0, 0, 0, -1, 0, 4, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 20 },
    { 0, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 20 },
    { 1, 0, 0, 0, -1, 0, 4, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 20 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 20 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 20 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 21 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 21 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 0, 33, 8, 21 },
    { 0, 17, 103, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 21 },
    { 0, 17, 9, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 21 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 21 },
    { 0, 17, 107, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 21 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 21 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 21 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 21 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 22 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 22 },
    { 0, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 22 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 0, 33, 8, 22 },
    { 0, 17, 118, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 22 },
    { 0, 17, 9, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 22 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 22 },
    { 0, 17, 122, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 22 },
    { 3, 0, 0, 0, 0, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 3, 0, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 22 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 22 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 22 },
    { 18, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 23 },
    { 29, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 4, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 4, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 23 },
    { 29, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 23 },
    { 0, 17, 220, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 3, 0, 0, 0, 0, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 2, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 3, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 4, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 5, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 6, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 7, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 8, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 3, 0, 0, 0, 9, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 23 },
    { 5, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 23 },
    { 29, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 23 },
    { 0, 17, 216, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 21, 10, 0, 0, -1, 1, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 23 },
    { 22, 10, 0, 0, -1, -1, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 23 },
    { 1, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 23 },
    { 18, 0, 0, 0, -1, 0, 2, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 23 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 23 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 23 },
    { 0, 17, 129, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 130, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 0, 5, -1, 0, 2, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 132, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 0, 5, -1, 0, 2, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 0, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 1, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 17, 4, 23 },
    { 0, 17, 230, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 9, 5, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 23 },
    { 0, 17, 0, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 0, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 29, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 23 },
    { 29, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 23 },
    { 0, 17, 220, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 23 },
    { 29, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 23 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 23 },
    { 29, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 4, 0, 23 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 18, 0, 0, 0, -1, 0, 4, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 4, 33, 4, 24 },
    { 1, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 4, 33, 4, 24 },
    { 0, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 0, 17, 0, 5, -1, 0, 4, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 1, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 33, 4, 24 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 0, 17, 7, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 0, 17, 9, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 0, 17, 9, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 33, 4, 24 },
    { 3, 0, 0, 0, 0, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 2, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 3, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 4, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 5, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 6, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 7, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 8, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 9, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 24 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 24 },
    { 0, 17, 220, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 4, 33, 4, 24 },
    { 0, 17, 0, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 29, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 24 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 7264}, {0, 0}, {0, 0}, {0, 7264} }, 0, 10, 12, 7, 25 },
    { 14, 0, 0, 0, -1, 0, 13, 0,  { {0, 7264}, {0, 0}, {0, 0}, {0, 7264} }, 0, 10, 12, 7, 25 },
    { 15, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 3008}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 25 },
    { 15, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 3008}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 25 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 3008}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 25 },
    { 25, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 25 },
    { 15, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 3008}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 25 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 9, 10, 25, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 9, 10, 25, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 10, 10, 26, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 10, 10, 26, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 10, 10, 26, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 11, 10, 27, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 11, 10, 27, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 11, 10, 27, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 27 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 27 },
    { 0, 17, 230, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 27 },
    { 0, 17, 230, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 27 },
    { 25, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 27 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 27 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 2, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 3, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 4, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 5, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 6, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 7, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 8, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, 9, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 5, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 27 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 41}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 43}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 45}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 47}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 49}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 51}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 53}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 55}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 57}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 59}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 61}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 63}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 65}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 67}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 69}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 71}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 73}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 75}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 77}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 79}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 81}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 83}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 85}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 87}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 89}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 91}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 93}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 95}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 97}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 99}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 101}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 103}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 105}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 107}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 109}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 111}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 113}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 115}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 117}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 119}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 121}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 123}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 125}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 127}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 129}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 131}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 133}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 135}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 137}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 139}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 141}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 143}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 145}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 147}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 149}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 151}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 153}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 155}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 157}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 159}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 161}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 163}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 165}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 167}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 169}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 171}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 173}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 175}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 177}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 179}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 181}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 183}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 185}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 187}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 189}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 191}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 193}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 195}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 197}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {1, 199}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 4, 0,  { {0, 8}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 14, 0, 0, 0, -1, 0, 17, 0,  { {0, 8}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, -8}, {0, -8}, {0, -8} }, 0, 10, 12, 6, 28 },
    { 20, 10, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 29 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 29 },
    { 29, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 29 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 29 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 29 },
    { 6, 9, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 22, 17, 5, 30 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 30 },
    { 21, 10, 0, 0, -1, 1, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 30 },
    { 22, 10, 0, 0, -1, -1, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 30 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 31 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 4, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 31 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 31 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 42 },
    { 0, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 42 },
    { 0, 17, 9, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 42 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 43 },
    { 0, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 43 },
    { 0, 17, 9, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 43 },
    { 25, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 2 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 44 },
    { 0, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 44 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 45 },
    { 0, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 45 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 32 },
    { 0, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 32 },
    { 1, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 33, 4, 32 },
    { 0, 17, 9, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 0, 32 },
    { 17, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 32 },
    { 25, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 32 },
    { 27, 4, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 32 },
    { 0, 17, 230, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 32 },
    { 3, 0, 0, 0, 0, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 2, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 3, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 4, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 5, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 6, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 7, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 8, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 3, 0, 0, 0, 9, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 32 },
    { 5, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 32 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 33 },
    { 25, 10, 0, 2, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 11, 33 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 33 },
    { 25, 10, 0, 1, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 33 },
    { 0, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 33 },
    { 10, 18, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 4, 4, 33 },
    { 3, 0, 0, 0, 0, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 2, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 3, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 4, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 5, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 6, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 7, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 8, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 3, 0, 0, 0, 9, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 33 },
    { 18, 0, 0, 2, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 33 },
    { 17, 0, 0, 2, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 33 },
    { 18, 0, 0, 2, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 33 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 33 },
    { 0, 17, 228, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 33 },
    { 18, 0, 0, 2, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 33 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 47 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 47 },
    { 0, 17, 0, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 47 },
    { 1, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 47 },
    { 0, 17, 222, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 47 },
    { 0, 17, 230, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 47 },
    { 0, 17, 220, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 47 },
    { 29, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 47 },
    { 25, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 47 },
    { 3, 0, 0, 0, 0, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 2, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 3, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 4, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 5, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 6, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 7, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 8, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 3, 0, 0, 0, 9, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 47 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 48 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 56 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 56 },
    { 3, 0, 0, 0, 0, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 2, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 3, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 4, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 5, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 6, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 7, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 8, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 3, 0, 0, 0, 9, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 56 },
    { 5, 0, 0, 0, 1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 56 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 56 },
    { 29, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 32 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 55 },
    { 0, 17, 230, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 55 },
    { 0, 17, 220, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 55 },
    { 1, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 55 },
    { 0, 17, 0, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 55 },
    { 25, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 55 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 78 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 33, 4, 78 },
    { 0, 17, 0, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 78 },
    { 0, 17, 9, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 78 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 4, 33, 4, 78 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 78 },
    { 0, 17, 220, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 78 },
    { 3, 0, 0, 0, 0, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 2, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 3, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 4, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 5, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 6, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 7, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 8, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 3, 0, 0, 0, 9, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 78 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 78 },
    { 17, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 78 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 12, 78 },
    { 0, 17, 230, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 2, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 0, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 62 },
    { 1, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 62 },
    { 18, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 62 },
    { 18, 0, 0, 0, -1, 0, 9, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 62 },
    { 0, 17, 7, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 62 },
    { 1, 0, 0, 0, -1, 0, 9, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 62 },
    { 1, 0, 0, 0, -1, 0, 9, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 62 },
    { 1, 0, 9, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 62 },
    { 3, 0, 0, 0, 0, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 2, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 3, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 4, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 5, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 6, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 7, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 8, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 3, 0, 0, 0, 9, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 62 },
    { 25, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 62 },
    { 25, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 62 },
    { 25, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 62 },
    { 29, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 62 },
    { 0, 17, 230, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 62 },
    { 0, 17, 220, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 62 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 67 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 67 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 67 },
    { 1, 0, 9, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 67 },
    { 0, 17, 9, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 67 },
    { 0, 17, 0, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 67 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 67 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 67 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 93 },
    { 0, 17, 7, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 93 },
    { 1, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 93 },
    { 0, 17, 0, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 93 },
    { 1, 0, 9, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 93 },
    { 25, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 93 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 68 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 68 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 68 },
    { 0, 17, 7, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 68 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 68 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 68 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 68 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 69 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 69 },
    { 17, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 69 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 69 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6254}, {0, -6254}, {0, -6222} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6253}, {0, -6253}, {0, -6221} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6244}, {0, -6244}, {0, -6212} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6242}, {0, -6242}, {0, -6210} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6243}, {0, -6243}, {0, -6211} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6236}, {0, -6236}, {0, -6204} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -6181}, {0, -6181}, {0, -6180} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {1, 201}, {1, 201}, {1, 719} }, 0, 10, 12, 6, 5 },
    { 14, 0, 0, 0, -1, 0, 20, 0,  { {0, -3008}, {0, 0}, {0, 0}, {0, -3008} }, 0, 10, 12, 8, 25 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 67 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 0, 17, 1, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 2 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 0, 17, 230, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 1, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 2 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 15, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 17, 0, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 17, 0, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {1, 203}, {1, 203}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 3814}, {0, 3814}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {1, 205}, {1, 205}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 0, 17, 230, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 214, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 202, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 232, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 228, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 514}, {1, 514}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 517}, {1, 517}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 520}, {1, 520}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 523}, {1, 523}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 526}, {1, 526}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 2, 81,  { {0, 0}, {0, -59}, {0, -59}, {0, -58} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {0, -7615}, {0, 0}, {0, 0}, {0, -7615} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 8}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {0, 0}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 529}, {1, 529}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 532}, {1, 532}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 536}, {1, 536}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 540}, {1, 540}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 74}, {0, 74}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 74}, {0, 74}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 86}, {0, 86}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 86}, {0, 86}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 100}, {0, 100}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 100}, {0, 100}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 128}, {0, 128}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 128}, {0, 128}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 112}, {0, 112}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 112}, {0, 112}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 126}, {0, 126}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 126}, {0, 126}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 578}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 581}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 584}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 587}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 590}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 593}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 596}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 599}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 578}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 581}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 584}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 587}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 590}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 593}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 596}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 599}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 602}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 605}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 608}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 611}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 614}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 617}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 620}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 623}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 602}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 605}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 608}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 611}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 614}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 617}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 620}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 623}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 626}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 629}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 632}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 635}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 638}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 641}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 644}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 647}, {0, 8}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 626}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 629}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 632}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 635}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 638}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 641}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 644}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -8}, {1, 647}, {0, 0}, {0, -8} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 662}, {1, 659}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 650}, {0, 9}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 668}, {1, 665}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 544}, {1, 544}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 699}, {1, 695}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -74}, {0, 0}, {0, 0}, {0, -74} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -74}, {0, 0}, {0, 0}, {0, -74} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -9}, {1, 650}, {0, 0}, {0, -9} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, -7205}, {0, -7205}, {0, -7173} }, 0, 10, 12, 6, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 81,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 674}, {1, 671}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 653}, {0, 9}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 680}, {1, 677}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 547}, {1, 547}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 707}, {1, 703}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -86}, {0, 0}, {0, 0}, {0, -86} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -86}, {0, 0}, {0, 0}, {0, -86} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -9}, {1, 653}, {0, 0}, {0, -9} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 550}, {1, 550}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {1, 503}, {1, 503}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 554}, {1, 554}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 557}, {1, 557}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -100}, {0, 0}, {0, 0}, {0, -100} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -100}, {0, 0}, {0, 0}, {0, -100} }, 0, 10, 12, 7, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 561}, {1, 561}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {1, 507}, {1, 507}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 565}, {1, 565}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 7}, {0, 7}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 568}, {1, 568}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 571}, {1, 571}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -112}, {0, 0}, {0, 0}, {0, -112} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -112}, {0, 0}, {0, 0}, {0, -112} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -7}, {0, 0}, {0, 0}, {0, -7} }, 0, 10, 12, 7, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 686}, {1, 683}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 656}, {0, 9}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 692}, {1, 689}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 575}, {1, 575}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {1, 715}, {1, 711}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -128}, {0, 0}, {0, 0}, {0, -128} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -128}, {0, 0}, {0, 0}, {0, -128} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 17,  { {0, -126}, {0, 0}, {0, 0}, {0, -126} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -126}, {0, 0}, {0, 0}, {0, -126} }, 0, 10, 12, 7, 4 },
    { 16, 0, 0, 0, -1, 0, 1, 17,  { {0, -9}, {1, 656}, {0, 0}, {0, -9} }, 0, 10, 12, 7, 4 },
    { 28, 10, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 4 },
    { 6, 9, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 22, 17, 5, 2 },
    { 6, 9, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 22, 17, 5, 2 },
    { 6, 9, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 4, 5, 2 },
    { 10, 18, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 0, 20, 4, 2 },
    { 10, 18, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 10, 18, 0, 1, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 5, 5, 32, 4, 1 },
    { 10, 0, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 1, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 4, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 11, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 19, 11, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 23, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 13, 3, 13, 2 },
    { 24, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 13, 3, 13, 2 },
    { 21, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 23, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 24, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 13, 15, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 15, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 17, 0, 2 },
    { 7, 9, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 3, 38, 3, 2 },
    { 8, 7, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 3, 38, 3, 2 },
    { 10, 11, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 14, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 16, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 12, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 15, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 6, 6, 0, 0, -1, 0, 4, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 17, 4, 5, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 23, 10, 0, 0, -1, 1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 24, 10, 0, 0, -1, -1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 12, 2 },
    { 26, 6, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 19, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 17, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 6, 9, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 22, 17, 5, 2 },
    { 10, 18, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 22, 4, 2 },
    { 10, 18, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 12, 4, 2 },
    { 10, 18, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 12, 4, 2 },
    { 13, 18, 0, 0, -1, 0, 0, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 0, 12, 0, 0 },
    { 10, 19, 0, 0, -1, 0, 15, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 20, 0, 0, -1, 0, 15, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 21, 0, 0, -1, 0, 15, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 22, 0, 0, -1, 0, 15, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 10, 18, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 5, 2, 0, 0, 0, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 5, 2, 0, 0, 4, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 5, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 6, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 7, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 8, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 9, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 3, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 21, 10, 0, 0, -1, 1, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 17, 0, 0, 0, -1, 0, 12, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 27, 4, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 3, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 14, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 13, 4, 0, 0, -1, 0, 0, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 0 },
    { 2, 17, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 2, 17, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 2, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 1, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 220, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 1, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 29, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {0, -7517}, {0, 0}, {0, 0}, {0, -7517} }, 0, 10, 12, 7, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {1, 207}, {0, 0}, {0, 0}, {1, 207} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 85,  { {1, 209}, {0, 0}, {0, 0}, {1, 209} }, 0, 10, 12, 7, 3 },
    { 29, 4, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 0,  { {0, 28}, {0, 0}, {0, 0}, {0, 28} }, 0, 10, 12, 7, 3 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 15, 0, 0, 0, -1, 0, 4, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 29, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 15, 0, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 14, 0, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 26, 10, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, -28}, {0, -28}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 29, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, -1, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 4, 0, 0, 0, -1, 0, 1, 80,  { {0, 16}, {0, 0}, {0, 0}, {0, 16} }, 0, 10, 12, 7, 3 },
    { 4, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -16}, {0, -16}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 4, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 4, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 29, 10, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 3, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 3, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -3, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -3, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2016, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2527, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1923, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1914, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1918, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2250, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 138, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 7, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -7, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1824, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2104, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2108, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2106, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1316, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -138, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 15, 0, 2 },
    { 26, 10, 0, 0, -1, 8, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 7, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -8, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -7, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 21, 10, 0, 0, -1, 1, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 2, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 3, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 4, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 5, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 6, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 7, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 8, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 9, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80,  { {0, 26}, {0, 0}, {0, 0}, {0, 26} }, 0, 10, 12, 7, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -26}, {0, -26}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 5, 10, 0, 0, 0, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 2, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 3, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 4, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 5, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 6, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 7, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 8, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 9, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 0, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 29, 10, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 2 },
    { 21, 10, 0, 0, -1, 1, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 5, 10, 0, 0, 1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 2, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 3, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 4, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 5, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 6, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 7, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 8, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, 9, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 21, 10, 0, 0, -1, 1, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 26, 10, 0, 0, -1, 1, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 2, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 1, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1316, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 21, 10, 0, 0, -1, 1, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 29, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 54 },
    { 21, 10, 0, 0, -1, 3, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, 1, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 21, 10, 0, 0, -1, -1, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -3, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 26, 10, 0, 0, -1, -1914, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1918, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1923, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -1824, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2016, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 6, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2104, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2106, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2108, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, -2250, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, -2527, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {0, 48}, {0, 0}, {0, 0}, {0, 48} }, 0, 10, 12, 7, 57 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, -48}, {0, -48}, {0, 0} }, 0, 10, 12, 6, 57 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {1, 211}, {0, 0}, {0, 0}, {1, 211} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {0, -3814}, {0, 0}, {0, 0}, {0, -3814} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 9, 0,  { {1, 213}, {0, 0}, {0, 0}, {1, 213} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {1, 215}, {1, 215}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {1, 217}, {1, 217}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {1, 219}, {0, 0}, {0, 0}, {1, 219} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {1, 221}, {0, 0}, {0, 0}, {1, 221} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {1, 223}, {0, 0}, {0, 0}, {1, 223} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 11, 0,  { {1, 225}, {0, 0}, {0, 0}, {1, 225} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 10, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 11, 0,  { {1, 227}, {0, 0}, {0, 0}, {1, 227} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 11, 0,  { {1, 229}, {0, 0}, {0, 0}, {1, 229} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 8, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 46 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 46 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 46 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 46 },
    { 14, 0, 0, 0, -1, 0, 11, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 46 },
    { 15, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 46 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 46 },
    { 14, 0, 0, 0, -1, 0, 13, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 46 },
    { 15, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 46 },
    { 25, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 46 },
    { 25, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 46 },
    { 5, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 46 },
    { 15, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, -7264}, {0, -7264}, {0, 0} }, 0, 10, 12, 6, 25 },
    { 15, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, -7264}, {0, -7264}, {0, 0} }, 0, 10, 12, 6, 25 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 58 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 58 },
    { 17, 0, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 58 },
    { 25, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 58 },
    { 0, 17, 9, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 58 },
    { 25, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 23, 10, 0, 0, -1, 1, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 24, 10, 0, 0, -1, -1, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 20, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 23, 10, 0, 0, -1, 1, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 24, 10, 0, 0, -1, -1, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 2 },
    { 17, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 19, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 21, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 37 },
    { 29, 10, 0, 0, -1, 0, 4, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 37 },
    { 29, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 2 },
    { 4, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 20, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 0, 17, 218, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 228, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 222, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 1, 0, 224, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 26 },
    { 20, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 8, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 21, 8, 2 },
    { 29, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 4, 0, 0, 0, -1, 0, 4, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 17, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 8, 34 },
    { 0, 17, 8, 5, -1, 0, 1, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 28, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 8, 34 },
    { 17, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 34 },
    { 20, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 8, 35 },
    { 25, 10, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 35 },
    { 17, 0, 0, 0, -1, 0, 1, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 26 },
    { 29, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 5, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 36 },
    { 18, 0, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 35 },
    { 29, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 26 },
    { 29, 10, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 26 },
    { 29, 0, 0, 0, -1, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 5, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 5, 10, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 26 },
    { 29, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 0, 35 },
    { 29, 0, 0, 0, -1, 0, 22, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 13, 0, 0, 0, -1, 0, 0, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 0 },
    { 18, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 14, 8, 38 },
    { 17, 0, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 38 },
    { 29, 10, 0, 0, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 38 },
    { 29, 10, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 38 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 83 },
    { 17, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 83 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 83 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 83 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 70 },
    { 17, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 70 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 70 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 70 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 70 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 70 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 5 },
    { 2, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 5 },
    { 25, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 5 },
    { 0, 17, 230, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 5 },
    { 17, 10, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 5 },
    { 17, 0, 0, 0, -1, 0, 16, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 5 },
    { 0, 17, 230, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 5 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 84 },
    { 4, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 84 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 84 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 84 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 84 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 84 },
    { 28, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 28, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 17, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 28, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 10, 0,  { {1, 231}, {0, 0}, {0, 0}, {1, 231} }, 0, 10, 12, 7, 3 },
    { 28, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 12, 0,  { {1, 233}, {0, 0}, {0, 0}, {1, 233} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 14, 0, 0, 0, -1, 0, 12, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 13, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 48}, {0, 48}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 13, 0,  { {1, 235}, {0, 0}, {0, 0}, {1, 235} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {1, 237}, {0, 0}, {0, 0}, {1, 237} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {1, 239}, {0, 0}, {0, 0}, {1, 239} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {1, 241}, {0, 0}, {0, 0}, {1, 241} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 18, 0,  { {1, 243}, {0, 0}, {0, 0}, {1, 243} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {1, 245}, {0, 0}, {0, 0}, {1, 245} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {1, 247}, {0, 0}, {0, 0}, {1, 247} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 17, 0,  { {1, 249}, {0, 0}, {0, 0}, {1, 249} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 17, 0,  { {0, 928}, {0, 0}, {0, 0}, {0, 928} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 17, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 20, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0,  { {0, -48}, {0, 0}, {0, 0}, {0, -48} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0,  { {1, 251}, {0, 0}, {0, 0}, {1, 251} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 21, 0,  { {1, 253}, {0, 0}, {0, 0}, {1, 253} }, 0, 10, 12, 7, 3 },
    { 14, 0, 0, 0, -1, 0, 23, 0,  { {0, 1}, {0, 0}, {0, 0}, {0, 1} }, 0, 10, 12, 7, 3 },
    { 15, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, -1}, {0, -1}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 17, 0, 0, 0, -1, 0, 13, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 59 },
    { 0, 17, 0, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 59 },
    { 0, 17, 9, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 59 },
    { 1, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 59 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 59 },
    { 0, 17, 9, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 59 },
    { 29, 4, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 18, 0, 0, 2, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 65 },
    { 18, 0, 0, 4, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 65 },
    { 18, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 65 },
    { 25, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 65 },
    { 25, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 65 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 71 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 71 },
    { 0, 17, 9, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 71 },
    { 0, 17, 0, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 71 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 71 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 71 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 11 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 11 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 11 },
    { 0, 17, 0, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 11 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 72 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 72 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 72 },
    { 0, 17, 220, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 72 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 72 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 73 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 73 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 73 },
    { 1, 0, 9, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 73 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 73 },
    { 0, 17, 0, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 85 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 85 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 85 },
    { 0, 17, 7, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 85 },
    { 1, 0, 9, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 85 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 85 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 85 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 85 },
    { 17, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 2 },
    { 3, 0, 0, 0, 0, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 2, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 3, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 4, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 5, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 6, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 7, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 8, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 3, 0, 0, 0, 9, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 85 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 24 },
    { 17, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 24 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 77 },
    { 0, 17, 0, 5, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 77 },
    { 1, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 77 },
    { 3, 0, 0, 0, 0, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 2, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 3, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 4, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 5, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 6, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 7, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 8, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 3, 0, 0, 0, 9, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 77 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 77 },
    { 25, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 77 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 17, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 24 },
    { 29, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 24 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 4, 33, 4, 24 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 79 },
    { 0, 17, 230, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 79 },
    { 0, 17, 220, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 79 },
    { 17, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 79 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 79 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 86 },
    { 1, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 86 },
    { 0, 17, 0, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 86 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 86 },
    { 17, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 86 },
    { 0, 17, 9, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 86 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 27 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, -928}, {0, -928}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 28, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 16, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 4 },
    { 15, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 17, 0, 0, 0, -1, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 3 },
    { 28, 10, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 255}, {1, 255}, {1, 255} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 257}, {1, 257}, {1, 257} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 259}, {1, 259}, {1, 259} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 261}, {1, 261}, {1, 261} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 263}, {1, 263}, {1, 263} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 265}, {1, 265}, {1, 265} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 267}, {1, 267}, {1, 267} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 269}, {1, 269}, {1, 269} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 271}, {1, 271}, {1, 271} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 273}, {1, 273}, {1, 273} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 275}, {1, 275}, {1, 275} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 277}, {1, 277}, {1, 277} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 279}, {1, 279}, {1, 279} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 281}, {1, 281}, {1, 281} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 283}, {1, 283}, {1, 283} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 285}, {1, 285}, {1, 285} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 287}, {1, 287}, {1, 287} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 289}, {1, 289}, {1, 289} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 291}, {1, 291}, {1, 291} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 293}, {1, 293}, {1, 293} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 295}, {1, 295}, {1, 295} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 297}, {1, 297}, {1, 297} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 299}, {1, 299}, {1, 299} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 301}, {1, 301}, {1, 301} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 303}, {1, 303}, {1, 303} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 305}, {1, 305}, {1, 305} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 307}, {1, 307}, {1, 307} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 309}, {1, 309}, {1, 309} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 311}, {1, 311}, {1, 311} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 313}, {1, 313}, {1, 313} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 315}, {1, 315}, {1, 315} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 317}, {1, 317}, {1, 317} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 319}, {1, 319}, {1, 319} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 321}, {1, 321}, {1, 321} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 323}, {1, 323}, {1, 323} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 325}, {1, 325}, {1, 325} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 327}, {1, 327}, {1, 327} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 329}, {1, 329}, {1, 329} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 331}, {1, 331}, {1, 331} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 333}, {1, 333}, {1, 333} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 335}, {1, 335}, {1, 335} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 337}, {1, 337}, {1, 337} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 339}, {1, 339}, {1, 339} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 341}, {1, 341}, {1, 341} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 343}, {1, 343}, {1, 343} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 345}, {1, 345}, {1, 345} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 347}, {1, 347}, {1, 347} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 349}, {1, 349}, {1, 349} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 351}, {1, 351}, {1, 351} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 353}, {1, 353}, {1, 353} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 355}, {1, 355}, {1, 355} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 357}, {1, 357}, {1, 357} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 359}, {1, 359}, {1, 359} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 361}, {1, 361}, {1, 361} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 363}, {1, 363}, {1, 363} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 365}, {1, 365}, {1, 365} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 367}, {1, 367}, {1, 367} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 369}, {1, 369}, {1, 369} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 371}, {1, 371}, {1, 371} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 373}, {1, 373}, {1, 373} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 375}, {1, 375}, {1, 375} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 377}, {1, 377}, {1, 377} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 379}, {1, 379}, {1, 379} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 381}, {1, 381}, {1, 381} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 383}, {1, 383}, {1, 383} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 385}, {1, 385}, {1, 385} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 387}, {1, 387}, {1, 387} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 389}, {1, 389}, {1, 389} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 391}, {1, 391}, {1, 391} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 393}, {1, 393}, {1, 393} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 395}, {1, 395}, {1, 395} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 397}, {1, 397}, {1, 397} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 399}, {1, 399}, {1, 399} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 401}, {1, 401}, {1, 401} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 403}, {1, 403}, {1, 403} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 405}, {1, 405}, {1, 405} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 407}, {1, 407}, {1, 407} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 409}, {1, 409}, {1, 409} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 411}, {1, 411}, {1, 411} }, 0, 10, 12, 6, 28 },
    { 15, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {1, 413}, {1, 413}, {1, 413} }, 0, 10, 12, 6, 28 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 86 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 86 },
    { 0, 17, 0, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 86 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 86 },
    { 0, 17, 9, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 86 },
    { 3, 0, 0, 0, 0, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 2, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 3, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 4, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 5, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 6, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 7, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 8, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 3, 0, 0, 0, 9, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 86 },
    { 18, 0, 0, 0, -1, 0, 2, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 12, 10, 23, 8, 26 },
    { 18, 0, 0, 0, -1, 0, 2, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 13, 10, 24, 8, 26 },
    { 11, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 34, 0, 0 },
    { 12, 0, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 18, 0, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 13, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 6, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 11, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 8, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 427}, {1, 424}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 433}, {1, 430}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 439}, {1, 436}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 446}, {1, 442}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 454}, {1, 450}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 461}, {1, 458}, {0, 0} }, 0, 10, 12, 6, 3 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 473}, {1, 470}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 479}, {1, 476}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 485}, {1, 482}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 491}, {1, 488}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {1, 497}, {1, 494}, {0, 0} }, 0, 10, 12, 6, 6 },
    { 18, 1, 0, 0, -1, 0, 4, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 9, 13, 8, 7 },
    { 0, 17, 26, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 7 },
    { 18, 1, 0, 0, -1, 0, 1, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 9, 13, 8, 7 },
    { 18, 1, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 9, 13, 8, 7 },
    { 26, 3, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 7 },
    { 18, 13, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 28, 13, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 13, 18, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 27, 13, 0, 0, -1, 0, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 8 },
    { 0, 17, 0, 5, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 8, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 8, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 2 },
    { 21, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 8, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 15, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 20, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 11, 2 },
    { 19, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 17, 14, 0, 2 },
    { 21, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 21, 10, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 1, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 11, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 13, 1, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 15, 5, 0, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 14, 5, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 12, 2 },
    { 25, 4, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 26, 3, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 20, 3, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 11, 2 },
    { 26, 10, 0, 0, -1, 1, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 26, 10, 0, 0, -1, -1, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 18, 13, 0, 0, -1, 0, 6, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 10, 18, 0, 5, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 22, 4, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 13, 14, 0, 2 },
    { 25, 6, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 3, 2, 0, 0, 0, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 2, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 3, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 4, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 5, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 6, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 7, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 8, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 3, 2, 0, 0, 9, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 14, 9, 2 },
    { 26, 10, 0, 0, -1, 2, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 26, 10, 0, 0, -1, -2, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 80,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 14, 7, 3 },
    { 21, 10, 0, 0, -1, 2, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -2, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 28, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 15, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 14, 6, 3 },
    { 21, 10, 0, 0, -1, 1, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 13, 2 },
    { 22, 10, 0, 0, -1, -1, 6, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 13, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 1, 11, 2 },
    { 25, 10, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 35 },
    { 17, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 2 },
    { 17, 0, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 5, 4, 2 },
    { 27, 4, 0, 0, -1, 0, 1, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 10, 10, 0, 5, -1, 0, 4, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 29, 10, 0, 0, -1, 0, 3, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 29, 0, 2 },
    { 13, 18, 0, 0, -1, 0, 1, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 49 },
    { 25, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 2 },
    { 5, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 4, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 4 },
    { 5, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 29, 10, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 5, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 29, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 4 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 74 },
    { 18, 0, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 75 },
    { 5, 2, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 18, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 39 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 39 },
    { 5, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 39 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 39 },
    { 18, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 40 },
    { 4, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 40 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 120 },
    { 0, 17, 230, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 120 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 50 },
    { 25, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 50 },
    { 18, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 60 },
    { 25, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 60 },
    { 4, 0, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 60 },
    { 14, 0, 0, 0, -1, 0, 5, 0,  { {0, 40}, {0, 0}, {0, 0}, {0, 40} }, 0, 10, 12, 7, 41 },
    { 14, 0, 0, 0, -1, 0, 7, 0,  { {0, 40}, {0, 0}, {0, 0}, {0, 40} }, 0, 10, 12, 7, 41 },
    { 15, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, -40}, {0, -40}, {0, 0} }, 0, 10, 12, 6, 41 },
    { 15, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, -40}, {0, -40}, {0, 0} }, 0, 10, 12, 6, 41 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 51 },
    { 18, 0, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 52 },
    { 3, 0, 0, 0, 0, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 2, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 3, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 4, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 5, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 6, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 7, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 8, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 3, 0, 0, 0, 9, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 52 },
    { 14, 0, 0, 0, -1, 0, 18, 0,  { {0, 40}, {0, 0}, {0, 0}, {0, 40} }, 0, 10, 12, 7, 136 },
    { 15, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, -40}, {0, -40}, {0, 0} }, 0, 10, 12, 6, 136 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 106 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 103 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 103 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 110 },
    { 18, 1, 0, 0, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 53 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 87 },
    { 25, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 87 },
    { 5, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 87 },
    { 18, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 118 },
    { 29, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 118 },
    { 5, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 118 },
    { 18, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 117 },
    { 5, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 117 },
    { 18, 1, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 128 },
    { 5, 1, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 128 },
    { 18, 1, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 64 },
    { 5, 1, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 64 },
    { 5, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 64 },
    { 25, 10, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 64 },
    { 18, 1, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 76 },
    { 25, 1, 0, 0, -1, 0, 10, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 76 },
    { 18, 1, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 98 },
    { 18, 1, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 97 },
    { 5, 1, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 97 },
    { 18, 1, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 61 },
    { 0, 17, 0, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 61 },
    { 0, 17, 220, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 61 },
    { 0, 17, 230, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 61 },
    { 18, 1, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 61 },
    { 0, 17, 1, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 61 },
    { 0, 17, 9, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 61 },
    { 5, 1, 0, 0, 1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 5, 1, 0, 0, 2, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 5, 1, 0, 0, 3, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 5, 1, 0, 0, 4, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 5, 1, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 5, 1, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 25, 1, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 61 },
    { 25, 1, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 61 },
    { 25, 1, 0, 0, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 61 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 88 },
    { 5, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 88 },
    { 25, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 88 },
    { 18, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 116 },
    { 5, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 116 },
    { 18, 1, 0, 2, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 112 },
    { 18, 1, 0, 3, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 112 },
    { 18, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 112 },
    { 29, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 112 },
    { 18, 1, 0, 4, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 112 },
    { 0, 17, 230, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 112 },
    { 0, 17, 220, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 112 },
    { 5, 1, 0, 2, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 112 },
    { 5, 1, 0, 3, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 112 },
    { 25, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 112 },
    { 25, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 15, 0, 112 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 80 },
    { 25, 10, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 80 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 89 },
    { 5, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 89 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 90 },
    { 5, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 90 },
    { 18, 1, 0, 2, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 121 },
    { 18, 1, 0, 3, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 121 },
    { 25, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 121 },
    { 5, 1, 0, 3, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 121 },
    { 5, 1, 0, 2, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 121 },
    { 5, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 121 },
    { 18, 1, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 91 },
    { 14, 1, 0, 0, -1, 0, 17, 0,  { {0, 64}, {0, 0}, {0, 0}, {0, 64} }, 0, 10, 12, 7, 130 },
    { 15, 1, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, -64}, {0, -64}, {0, 0} }, 0, 10, 12, 6, 130 },
    { 5, 1, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 130 },
    { 18, 13, 0, 4, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 144 },
    { 18, 13, 0, 2, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 144 },
    { 18, 13, 0, 3, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 144 },
    { 0, 17, 230, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 144 },
    { 3, 5, 0, 0, 0, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 2, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 3, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 4, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 5, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 6, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 7, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 8, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 3, 5, 0, 0, 9, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 144 },
    { 5, 5, 0, 0, 1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 2, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 3, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 4, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 5, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 6, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 7, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 8, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, 9, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 5, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 18, 1, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 156 },
    { 0, 17, 230, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 156 },
    { 20, 1, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 156 },
    { 18, 1, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 147 },
    { 5, 1, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 147 },
    { 18, 13, 0, 2, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 148 },
    { 18, 13, 0, 3, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 148 },
    { 18, 13, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 148 },
    { 0, 17, 220, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 148 },
    { 0, 17, 230, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 148 },
    { 5, 13, 0, 2, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 148 },
    { 5, 13, 0, 3, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 148 },
    { 25, 13, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 148 },
    { 18, 1, 0, 2, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 153 },
    { 18, 1, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 153 },
    { 18, 1, 0, 3, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 153 },
    { 5, 1, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 153 },
    { 5, 1, 0, 3, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 153 },
    { 5, 1, 0, 2, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 153 },
    { 5, 1, 0, 4, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 153 },
    { 18, 1, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 149 },
    { 1, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 94 },
    { 0, 17, 0, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 94 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 94 },
    { 0, 17, 9, 5, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 94 },
    { 25, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 94 },
    { 25, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 2, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 3, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 4, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 5, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 6, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 7, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 8, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, 9, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 5, 10, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 94 },
    { 3, 0, 0, 0, 0, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 2, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 3, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 4, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 5, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 6, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 7, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 8, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 3, 0, 0, 0, 9, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 94 },
    { 0, 17, 9, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 94 },
    { 0, 17, 0, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 92 },
    { 1, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 92 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 92 },
    { 18, 0, 0, 0, -1, 0, 11, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 92 },
    { 0, 17, 9, 5, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 92 },
    { 0, 17, 7, 5, -1, 0, 11, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 92 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 92 },
    { 10, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 92 },
    { 25, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 92 },
    { 10, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 6, 12, 4, 92 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 101 },
    { 3, 0, 0, 0, 0, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 2, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 3, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 4, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 5, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 6, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 7, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 8, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 3, 0, 0, 0, 9, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 101 },
    { 0, 17, 230, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 96 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 96 },
    { 0, 17, 0, 5, -1, 0, 13, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 96 },
    { 0, 17, 0, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 96 },
    { 1, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 96 },
    { 0, 17, 0, 5, -1, 0, 13, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 96 },
    { 0, 17, 9, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 96 },
    { 3, 0, 0, 0, 0, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 2, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 3, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 4, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 5, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 6, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 7, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 8, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 3, 0, 0, 0, 9, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 96 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 96 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 96 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 96 },
    { 1, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 96 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 96 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 111 },
    { 0, 17, 7, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 111 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 111 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 111 },
    { 0, 17, 0, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 100 },
    { 1, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 100 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 100 },
    { 1, 0, 9, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 100 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 100 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 100 },
    { 25, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 100 },
    { 0, 17, 0, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 100 },
    { 0, 17, 7, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 100 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 100 },
    { 1, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 100 },
    { 0, 17, 0, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 100 },
    { 3, 0, 0, 0, 0, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 2, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 3, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 4, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 5, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 6, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 7, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 8, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 3, 0, 0, 0, 9, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 100 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 100 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 100 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 100 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 100 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 100 },
    { 5, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 20 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 109 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 109 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 109 },
    { 1, 0, 9, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 109 },
    { 0, 17, 7, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 109 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 109 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 109 },
    { 0, 17, 0, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 109 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 129 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 129 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 123 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 123 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 123 },
    { 0, 17, 7, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 123 },
    { 0, 17, 9, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 123 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 123 },
    { 0, 17, 0, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 107 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 107 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 107 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 107 },
    { 0, 17, 7, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 7, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 107 },
    { 1, 0, 0, 0, -1, 0, 16, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 107 },
    { 1, 0, 0, 0, -1, 0, 16, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 107 },
    { 1, 0, 9, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 107 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 107 },
    { 0, 17, 230, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 107 },
    { 18, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 135 },
    { 1, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 135 },
    { 0, 17, 0, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 135 },
    { 0, 17, 9, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 135 },
    { 0, 17, 7, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 135 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 135 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 135 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 135 },
    { 3, 0, 0, 0, 0, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 2, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 3, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 4, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 5, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 6, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 7, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 8, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 3, 0, 0, 0, 9, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 135 },
    { 25, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 135 },
    { 0, 17, 230, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 135 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 135 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 135 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 124 },
    { 1, 0, 0, 0, -1, 0, 16, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 124 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 124 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 124 },
    { 0, 17, 0, 5, -1, 0, 16, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 124 },
    { 1, 0, 0, 0, -1, 0, 16, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 124 },
    { 0, 17, 9, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 124 },
    { 0, 17, 7, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 124 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 124 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 124 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 122 },
    { 1, 0, 0, 0, -1, 0, 16, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 122 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 122 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 122 },
    { 1, 0, 0, 0, -1, 0, 16, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 122 },
    { 0, 17, 9, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 122 },
    { 0, 17, 7, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 122 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 122 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 122 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 122 },
    { 0, 17, 0, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 122 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 114 },
    { 1, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 114 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 114 },
    { 0, 17, 9, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 114 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 114 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 114 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 114 },
    { 25, 10, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 33 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 102 },
    { 0, 17, 0, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 102 },
    { 1, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 102 },
    { 1, 0, 9, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 102 },
    { 0, 17, 7, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 102 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 102 },
    { 3, 0, 0, 0, 0, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 2, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 3, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 4, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 5, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 6, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 7, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 8, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 3, 0, 0, 0, 9, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 102 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 126 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 8, 126 },
    { 0, 17, 0, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 126 },
    { 1, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 33, 4, 126 },
    { 0, 17, 9, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 33, 4, 126 },
    { 3, 0, 0, 0, 0, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 2, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 3, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 4, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 5, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 6, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 7, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 8, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 3, 0, 0, 0, 9, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 126 },
    { 5, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 126 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 126 },
    { 29, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 33, 0, 126 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 142 },
    { 1, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 142 },
    { 0, 17, 0, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 142 },
    { 0, 17, 9, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 142 },
    { 0, 17, 7, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 142 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 142 },
    { 14, 0, 0, 0, -1, 0, 16, 0,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 125 },
    { 15, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 125 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 125 },
    { 5, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 125 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 125 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 154 },
    { 1, 0, 0, 0, -1, 0, 23, 204,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 154 },
    { 1, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 154 },
    { 1, 0, 0, 0, -1, 0, 23, 17,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 154 },
    { 0, 17, 0, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 154 },
    { 1, 0, 9, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 154 },
    { 0, 17, 9, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 154 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 154 },
    { 0, 17, 7, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 154 },
    { 25, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 154 },
    { 25, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 154 },
    { 3, 0, 0, 0, 0, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 2, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 3, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 4, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 5, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 6, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 7, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 8, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 3, 0, 0, 0, 9, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 154 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 150 },
    { 1, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 150 },
    { 0, 17, 0, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 150 },
    { 0, 17, 9, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 150 },
    { 25, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 150 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 141 },
    { 0, 17, 0, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 141 },
    { 0, 0, 0, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 141 },
    { 0, 17, 9, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 141 },
    { 1, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 141 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 141 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 141 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 140 },
    { 0, 17, 0, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 140 },
    { 1, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 140 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 140 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 140 },
    { 0, 17, 9, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 140 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 140 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 140 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 140 },
    { 25, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 140 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 119 },
    { 18, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 133 },
    { 1, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 133 },
    { 0, 17, 0, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 133 },
    { 0, 0, 9, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 133 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 133 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 133 },
    { 3, 0, 0, 0, 0, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 2, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 3, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 4, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 5, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 6, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 7, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 8, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 3, 0, 0, 0, 9, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 133 },
    { 5, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 133 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 18, 0, 134 },
    { 25, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 6, 0, 134 },
    { 18, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 134 },
    { 0, 17, 0, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 134 },
    { 1, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 134 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 138 },
    { 0, 17, 0, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 138 },
    { 0, 17, 7, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 138 },
    { 0, 17, 9, 5, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 138 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 7, 10, 12, 8, 138 },
    { 3, 0, 0, 0, 0, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 2, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 3, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 4, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 5, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 6, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 7, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 8, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 3, 0, 0, 0, 9, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 138 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 143 },
    { 1, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 143 },
    { 0, 17, 0, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 143 },
    { 0, 17, 9, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 143 },
    { 3, 0, 0, 0, 0, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 2, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 3, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 4, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 5, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 6, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 7, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 8, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 3, 0, 0, 0, 9, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 143 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 145 },
    { 0, 17, 0, 5, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 145 },
    { 1, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 145 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 12, 145 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 83 },
    { 5, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 16 },
    { 29, 10, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 16 },
    { 27, 4, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 16 },
    { 25, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 16 },
    { 18, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 63 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 63 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 63 },
    { 4, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 63 },
    { 4, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 63 },
    { 25, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 63 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 63 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 81 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 0, 8, 81 },
    { 18, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 1, 8, 81 },
    { 10, 0, 0, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 4, 4, 81 },
    { 10, 0, 0, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 0, 4, 81 },
    { 10, 0, 0, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 1, 4, 81 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 127 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 0, 8, 127 },
    { 18, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 1, 8, 127 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 84 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 115 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 115 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 115 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 104 },
    { 0, 17, 1, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 104 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 104 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 108 },
    { 0, 17, 230, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 108 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 108 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 108 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 108 },
    { 29, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 108 },
    { 17, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 108 },
    { 3, 0, 0, 0, 0, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 2, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 3, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 4, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 5, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 6, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 7, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 8, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 3, 0, 0, 0, 9, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 108 },
    { 5, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 108 },
    { 14, 0, 0, 0, -1, 0, 20, 0,  { {0, 32}, {0, 0}, {0, 0}, {0, 32} }, 0, 10, 12, 7, 146 },
    { 15, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, -32}, {0, -32}, {0, 0} }, 0, 10, 12, 6, 146 },
    { 5, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 146 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 146 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 146 },
    { 25, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 146 },
    { 18, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 99 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 99 },
    { 0, 17, 0, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 99 },
    { 1, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 99 },
    { 1, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 99 },
    { 0, 17, 0, 5, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 99 },
    { 17, 0, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 99 },
    { 17, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 137 },
    { 17, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 139 },
    { 25, 10, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 0, 2 },
    { 17, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 5, 8, 2 },
    { 0, 17, 0, 5, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 4, 4, 155 },
    { 1, 0, 6, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 37 },
    { 18, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 137 },
    { 18, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 137 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 137 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 137 },
    { 18, 0, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 8, 155 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 14, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 8, 34 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 8, 5, 8, 35 },
    { 18, 0, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 139 },
    { 18, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 105 },
    { 29, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 105 },
    { 0, 17, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 105 },
    { 0, 17, 1, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 105 },
    { 25, 0, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 105 },
    { 10, 18, 0, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 29, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 5, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 1, 0, 216, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 2 },
    { 1, 0, 216, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 2 },
    { 0, 17, 1, 5, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 1, 0, 226, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 8, 4, 21, 4, 2 },
    { 10, 18, 0, 5, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 3, 6, 21, 4, 2 },
    { 0, 17, 220, 5, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 29, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 0, 17, 230, 5, -1, 0, 8, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 4 },
    { 5, 0, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 0, 0, 0, -1, 0, 9, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 15, 0, 0, 0, -1, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 15, 0, 0, 0, -1, 0, 7, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 26, 0, 0, 0, -1, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 26, 10, 0, 0, -1, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 14, 0, 0, 0, -1, 0, 9, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 15, 0, 0, 0, -1, 0, 9, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 6, 2 },
    { 3, 2, 0, 0, 0, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 1, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 2, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 3, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 4, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 5, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 6, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 7, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 8, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 9, 0, 5, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 29, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 131 },
    { 0, 17, 0, 5, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 131 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 0, 131 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 17, 12, 131 },
    { 25, 0, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 131 },
    { 0, 17, 230, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 57 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 151 },
    { 0, 17, 230, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 151 },
    { 17, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 151 },
    { 3, 0, 0, 0, 0, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 2, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 3, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 4, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 5, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 6, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 7, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 8, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 3, 0, 0, 0, 9, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 151 },
    { 29, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 151 },
    { 18, 0, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 152 },
    { 0, 17, 230, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 152 },
    { 3, 0, 0, 0, 0, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 2, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 3, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 4, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 5, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 6, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 7, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 8, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 3, 0, 0, 0, 9, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 152 },
    { 27, 4, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 9, 0, 152 },
    { 18, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 113 },
    { 5, 1, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 113 },
    { 0, 17, 220, 5, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 113 },
    { 14, 1, 0, 2, -1, 0, 18, 0,  { {0, 34}, {0, 0}, {0, 0}, {0, 34} }, 0, 10, 12, 7, 132 },
    { 15, 1, 0, 2, -1, 0, 18, 0,  { {0, 0}, {0, -34}, {0, -34}, {0, 0} }, 0, 10, 12, 6, 132 },
    { 0, 17, 230, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 132 },
    { 0, 17, 7, 5, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 132 },
    { 17, 1, 0, 5, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 132 },
    { 3, 1, 0, 0, 0, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 2, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 3, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 4, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 5, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 6, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 7, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 8, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 3, 1, 0, 0, 9, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 132 },
    { 25, 1, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 0, 0, 132 },
    { 5, 13, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 13, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 27, 13, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 10, 0, 2 },
    { 5, 13, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 13, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 18, 13, 0, 0, -1, 0, 13, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 8, 8 },
    { 26, 10, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 8 },
    { 5, 2, 0, 0, 0, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 1, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 2, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 3, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 4, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 5, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 6, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 7, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 8, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 2, 0, 0, 9, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 5, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 10, 12, 7, 2 },
    { 29, 10, 0, 0, -1, 0, 13, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 6, 7, 28, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 11, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 34 },
    { 29, 0, 0, 0, -1, 0, 12, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 0, 0, 0, -1, 0, 18, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 28, 10, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 31, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 18, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 13, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 3, 13, 2 },
    { 29, 10, 0, 0, -1, 0, 16, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 5, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 23, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 21, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 17, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 19, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 20, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 30, 0, 2 },
    { 3, 2, 0, 0, 0, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 1, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 2, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 3, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 4, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 5, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 6, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 7, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 8, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 3, 2, 0, 0, 9, 0, 23, 80,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 16, 11, 9, 2 },
    { 13, 18, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 },
    { 18, 0, 0, 0, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 12, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 18, 0, 0, 0, -1, 0, 5, 85,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 14, 8, 37 },
    { 10, 18, 0, 5, -1, 0, 5, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 2 },
    { 0, 17, 0, 5, -1, 0, 7, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 4, 4, 21, 4, 1 },
    { 12, 0, 0, 0, -1, 0, 2, 0,  { {0, 0}, {0, 0}, {0, 0}, {0, 0} }, 0, 0, 12, 0, 0 }
};

Q_DECL_CONST_FUNCTION static inline const Properties *qGetProp(uint ucs4) noexcept
{
    return uc_properties + GET_PROP_INDEX(ucs4);
}

Q_DECL_CONST_FUNCTION static inline const Properties *qGetProp(ushort ucs2) noexcept
{
    return uc_properties + GET_PROP_INDEX_UCS2(ucs2);
}

Q_DECL_CONST_FUNCTION Q_CORE_EXPORT const Properties * QT_FASTCALL properties(uint ucs4) noexcept
{
    return qGetProp(ucs4);
}

Q_DECL_CONST_FUNCTION Q_CORE_EXPORT const Properties * QT_FASTCALL properties(ushort ucs2) noexcept
{
    return qGetProp(ucs2);
}

Q_CORE_EXPORT GraphemeBreakClass QT_FASTCALL graphemeBreakClass(uint ucs4) noexcept
{
    return static_cast<GraphemeBreakClass>(qGetProp(ucs4)->graphemeBreakClass);
}

Q_CORE_EXPORT WordBreakClass QT_FASTCALL wordBreakClass(uint ucs4) noexcept
{
    return static_cast<WordBreakClass>(qGetProp(ucs4)->wordBreakClass);
}

Q_CORE_EXPORT SentenceBreakClass QT_FASTCALL sentenceBreakClass(uint ucs4) noexcept
{
    return static_cast<SentenceBreakClass>(qGetProp(ucs4)->sentenceBreakClass);
}

Q_CORE_EXPORT LineBreakClass QT_FASTCALL lineBreakClass(uint ucs4) noexcept
{
    return static_cast<LineBreakClass>(qGetProp(ucs4)->lineBreakClass);
}


static const unsigned short specialCaseMap[] = {
    0x0, // placeholder
    0x1, 0x2c65,
    0x1, 0x2c66,
    0x1, 0x2c7e,
    0x1, 0x2c7f,
    0x1, 0x2c6f,
    0x1, 0x2c6d,
    0x1, 0x2c70,
    0x1, 0xa7ab,
    0x1, 0xa7ac,
    0x1, 0xa78d,
    0x1, 0xa7aa,
    0x1, 0xa7ae,
    0x1, 0x2c62,
    0x1, 0xa7ad,
    0x1, 0x2c6e,
    0x1, 0x2c64,
    0x1, 0xa7c5,
    0x1, 0xa7b1,
    0x1, 0xa7b2,
    0x1, 0xa7b0,
    0x1, 0xab70,
    0x1, 0xab71,
    0x1, 0xab72,
    0x1, 0xab73,
    0x1, 0xab74,
    0x1, 0xab75,
    0x1, 0xab76,
    0x1, 0xab77,
    0x1, 0xab78,
    0x1, 0xab79,
    0x1, 0xab7a,
    0x1, 0xab7b,
    0x1, 0xab7c,
    0x1, 0xab7d,
    0x1, 0xab7e,
    0x1, 0xab7f,
    0x1, 0xab80,
    0x1, 0xab81,
    0x1, 0xab82,
    0x1, 0xab83,
    0x1, 0xab84,
    0x1, 0xab85,
    0x1, 0xab86,
    0x1, 0xab87,
    0x1, 0xab88,
    0x1, 0xab89,
    0x1, 0xab8a,
    0x1, 0xab8b,
    0x1, 0xab8c,
    0x1, 0xab8d,
    0x1, 0xab8e,
    0x1, 0xab8f,
    0x1, 0xab90,
    0x1, 0xab91,
    0x1, 0xab92,
    0x1, 0xab93,
    0x1, 0xab94,
    0x1, 0xab95,
    0x1, 0xab96,
    0x1, 0xab97,
    0x1, 0xab98,
    0x1, 0xab99,
    0x1, 0xab9a,
    0x1, 0xab9b,
    0x1, 0xab9c,
    0x1, 0xab9d,
    0x1, 0xab9e,
    0x1, 0xab9f,
    0x1, 0xaba0,
    0x1, 0xaba1,
    0x1, 0xaba2,
    0x1, 0xaba3,
    0x1, 0xaba4,
    0x1, 0xaba5,
    0x1, 0xaba6,
    0x1, 0xaba7,
    0x1, 0xaba8,
    0x1, 0xaba9,
    0x1, 0xabaa,
    0x1, 0xabab,
    0x1, 0xabac,
    0x1, 0xabad,
    0x1, 0xabae,
    0x1, 0xabaf,
    0x1, 0xabb0,
    0x1, 0xabb1,
    0x1, 0xabb2,
    0x1, 0xabb3,
    0x1, 0xabb4,
    0x1, 0xabb5,
    0x1, 0xabb6,
    0x1, 0xabb7,
    0x1, 0xabb8,
    0x1, 0xabb9,
    0x1, 0xabba,
    0x1, 0xabbb,
    0x1, 0xabbc,
    0x1, 0xabbd,
    0x1, 0xabbe,
    0x1, 0xabbf,
    0x1, 0xa64a,
    0x1, 0xa77d,
    0x1, 0xa7c6,
    0x1, 0x6b,
    0x1, 0xe5,
    0x1, 0x26b,
    0x1, 0x27d,
    0x1, 0x23a,
    0x1, 0x23e,
    0x1, 0x251,
    0x1, 0x271,
    0x1, 0x250,
    0x1, 0x252,
    0x1, 0x23f,
    0x1, 0x240,
    0x1, 0x1d79,
    0x1, 0x265,
    0x1, 0x266,
    0x1, 0x25c,
    0x1, 0x261,
    0x1, 0x26c,
    0x1, 0x26a,
    0x1, 0x29e,
    0x1, 0x287,
    0x1, 0x29d,
    0x1, 0x282,
    0x1, 0x1d8e,
    0x1, 0x13a0,
    0x1, 0x13a1,
    0x1, 0x13a2,
    0x1, 0x13a3,
    0x1, 0x13a4,
    0x1, 0x13a5,
    0x1, 0x13a6,
    0x1, 0x13a7,
    0x1, 0x13a8,
    0x1, 0x13a9,
    0x1, 0x13aa,
    0x1, 0x13ab,
    0x1, 0x13ac,
    0x1, 0x13ad,
    0x1, 0x13ae,
    0x1, 0x13af,
    0x1, 0x13b0,
    0x1, 0x13b1,
    0x1, 0x13b2,
    0x1, 0x13b3,
    0x1, 0x13b4,
    0x1, 0x13b5,
    0x1, 0x13b6,
    0x1, 0x13b7,
    0x1, 0x13b8,
    0x1, 0x13b9,
    0x1, 0x13ba,
    0x1, 0x13bb,
    0x1, 0x13bc,
    0x1, 0x13bd,
    0x1, 0x13be,
    0x1, 0x13bf,
    0x1, 0x13c0,
    0x1, 0x13c1,
    0x1, 0x13c2,
    0x1, 0x13c3,
    0x1, 0x13c4,
    0x1, 0x13c5,
    0x1, 0x13c6,
    0x1, 0x13c7,
    0x1, 0x13c8,
    0x1, 0x13c9,
    0x1, 0x13ca,
    0x1, 0x13cb,
    0x1, 0x13cc,
    0x1, 0x13cd,
    0x1, 0x13ce,
    0x1, 0x13cf,
    0x1, 0x13d0,
    0x1, 0x13d1,
    0x1, 0x13d2,
    0x1, 0x13d3,
    0x1, 0x13d4,
    0x1, 0x13d5,
    0x1, 0x13d6,
    0x1, 0x13d7,
    0x1, 0x13d8,
    0x1, 0x13d9,
    0x1, 0x13da,
    0x1, 0x13db,
    0x1, 0x13dc,
    0x1, 0x13dd,
    0x1, 0x13de,
    0x1, 0x13df,
    0x1, 0x13e0,
    0x1, 0x13e1,
    0x1, 0x13e2,
    0x1, 0x13e3,
    0x1, 0x13e4,
    0x1, 0x13e5,
    0x1, 0x13e6,
    0x1, 0x13e7,
    0x1, 0x13e8,
    0x1, 0x13e9,
    0x1, 0x13ea,
    0x1, 0x13eb,
    0x1, 0x13ec,
    0x1, 0x13ed,
    0x1, 0x13ee,
    0x1, 0x13ef,
    0x2, 0x53, 0x73,
    0x2, 0x53, 0x53,
    0x2, 0x69, 0x307,
    0x2, 0x46, 0x66,
    0x2, 0x46, 0x46,
    0x2, 0x46, 0x69,
    0x2, 0x46, 0x49,
    0x2, 0x46, 0x6c,
    0x2, 0x46, 0x4c,
    0x3, 0x46, 0x66, 0x69,
    0x3, 0x46, 0x46, 0x49,
    0x3, 0x46, 0x66, 0x6c,
    0x3, 0x46, 0x46, 0x4c,
    0x2, 0x53, 0x74,
    0x2, 0x53, 0x54,
    0x2, 0x535, 0x582,
    0x2, 0x535, 0x552,
    0x2, 0x544, 0x576,
    0x2, 0x544, 0x546,
    0x2, 0x544, 0x565,
    0x2, 0x544, 0x535,
    0x2, 0x544, 0x56b,
    0x2, 0x544, 0x53b,
    0x2, 0x54e, 0x576,
    0x2, 0x54e, 0x546,
    0x2, 0x544, 0x56d,
    0x2, 0x544, 0x53d,
    0x2, 0x2bc, 0x4e,
    0x3, 0x399, 0x308, 0x301,
    0x3, 0x3a5, 0x308, 0x301,
    0x2, 0x4a, 0x30c,
    0x2, 0x48, 0x331,
    0x2, 0x54, 0x308,
    0x2, 0x57, 0x30a,
    0x2, 0x59, 0x30a,
    0x2, 0x41, 0x2be,
    0x2, 0x3a5, 0x313,
    0x3, 0x3a5, 0x313, 0x300,
    0x3, 0x3a5, 0x313, 0x301,
    0x3, 0x3a5, 0x313, 0x342,
    0x2, 0x391, 0x342,
    0x2, 0x397, 0x342,
    0x3, 0x399, 0x308, 0x300,
    0x2, 0x399, 0x342,
    0x3, 0x399, 0x308, 0x342,
    0x3, 0x3a5, 0x308, 0x300,
    0x2, 0x3a1, 0x313,
    0x2, 0x3a5, 0x342,
    0x3, 0x3a5, 0x308, 0x342,
    0x2, 0x3a9, 0x342,
    0x2, 0x1f08, 0x399,
    0x2, 0x1f09, 0x399,
    0x2, 0x1f0a, 0x399,
    0x2, 0x1f0b, 0x399,
    0x2, 0x1f0c, 0x399,
    0x2, 0x1f0d, 0x399,
    0x2, 0x1f0e, 0x399,
    0x2, 0x1f0f, 0x399,
    0x2, 0x1f28, 0x399,
    0x2, 0x1f29, 0x399,
    0x2, 0x1f2a, 0x399,
    0x2, 0x1f2b, 0x399,
    0x2, 0x1f2c, 0x399,
    0x2, 0x1f2d, 0x399,
    0x2, 0x1f2e, 0x399,
    0x2, 0x1f2f, 0x399,
    0x2, 0x1f68, 0x399,
    0x2, 0x1f69, 0x399,
    0x2, 0x1f6a, 0x399,
    0x2, 0x1f6b, 0x399,
    0x2, 0x1f6c, 0x399,
    0x2, 0x1f6d, 0x399,
    0x2, 0x1f6e, 0x399,
    0x2, 0x1f6f, 0x399,
    0x2, 0x391, 0x399,
    0x2, 0x397, 0x399,
    0x2, 0x3a9, 0x399,
    0x2, 0x1fba, 0x345,
    0x2, 0x1fba, 0x399,
    0x2, 0x386, 0x345,
    0x2, 0x386, 0x399,
    0x2, 0x1fca, 0x345,
    0x2, 0x1fca, 0x399,
    0x2, 0x389, 0x345,
    0x2, 0x389, 0x399,
    0x2, 0x1ffa, 0x345,
    0x2, 0x1ffa, 0x399,
    0x2, 0x38f, 0x345,
    0x2, 0x38f, 0x399,
    0x3, 0x391, 0x342, 0x345,
    0x3, 0x391, 0x342, 0x399,
    0x3, 0x397, 0x342, 0x345,
    0x3, 0x397, 0x342, 0x399,
    0x3, 0x3a9, 0x342, 0x345,
    0x3, 0x3a9, 0x342, 0x399,
    0x1, 0xa64b
};


static const unsigned short uc_decomposition_trie[] = {
    // 0 - 0x3400

    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1564, 1580, 1596, 1612, 1628, 1644,
    1660, 1676, 1692, 1708, 1724, 1740, 1756, 1772,
    1548, 1548, 1788, 1804, 1820, 1836, 1852, 1868,
    1884, 1900, 1916, 1932, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1948, 1548, 1964, 1980, 1548,
    1548, 1548, 1548, 1548, 1996, 1548, 1548, 2012,
    2028, 2044, 2060, 2076, 2092, 2108, 1548, 2124,
    2140, 2156, 1548, 2172, 1548, 2188, 1548, 2204,
    1548, 1548, 1548, 1548, 2220, 2236, 2252, 2268,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2284, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2300, 1548, 1548, 1548, 1548, 2316,
    1548, 1548, 1548, 1548, 2332, 2348, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2364, 2380, 1548, 2396, 1548, 1548,
    1548, 1548, 1548, 1548, 2412, 2428, 1548, 1548,
    1548, 1548, 1548, 2444, 1548, 2460, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2476, 2492, 1548, 1548,
    1548, 2508, 1548, 1548, 2524, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2540, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2556, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2572, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 2588, 1548, 1548,
    1548, 1548, 1548, 2604, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 2620, 1548, 2636, 1548, 1548,
    2652, 1548, 1548, 1548, 2668, 2684, 2700, 2716,
    2732, 2748, 2764, 2780, 1548, 1548, 1548, 1548,

    1548, 1548, 2796, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 2812,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2828, 2844, 1548, 2860, 2876, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2892, 2908, 2924, 2940, 2956, 2972,
    1548, 2988, 3004, 3020, 1548, 1548, 1548, 1548,
    3036, 3052, 3068, 3084, 3100, 3116, 3132, 3148,
    3164, 3180, 3196, 3212, 3228, 3244, 3260, 3276,
    3292, 3308, 3324, 3340, 3356, 3372, 3388, 3404,
    3420, 3436, 3452, 3468, 3484, 3500, 3516, 3532,

    3548, 3564, 3580, 3596, 3612, 3628, 1548, 3644,
    3660, 3676, 3692, 1548, 1548, 1548, 1548, 1548,
    3708, 3724, 3740, 3756, 3772, 3788, 3804, 3820,
    3836, 3852, 3868, 1548, 3884, 1548, 1548, 1548,
    3900, 1548, 3916, 3932, 3948, 1548, 3964, 3980,
    3996, 1548, 4012, 1548, 1548, 1548, 4028, 1548,
    1548, 1548, 4044, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 4060, 4076,
    4092, 4108, 4124, 4140, 4156, 4172, 4188, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    4204, 1548, 1548, 1548, 1548, 1548, 1548, 4220,
    1548, 1548, 1548, 1548, 1548, 4236, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 4252,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 4268, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 4284, 1548, 1548, 1548, 1548, 1548, 4300,
    4316, 4332, 4348, 4364, 4380, 4396, 4412, 4428,
    4444, 4460, 4476, 4492, 4508, 4524, 1548, 1548,

    4540, 1548, 1548, 4556, 4572, 4588, 4604, 4620,
    1548, 4636, 4652, 4668, 4684, 4700, 1548, 4716,
    1548, 1548, 1548, 4732, 4748, 4764, 4780, 4796,
    4812, 4828, 1548, 1548, 1548, 1548, 1548, 1548,
    4844, 4860, 4876, 4892, 4908, 4924, 4940, 4956,
    4972, 4988, 5004, 5020, 5036, 5052, 5068, 5084,
    5100, 5116, 5132, 5148, 5164, 5180, 5196, 5212,
    5228, 5244, 5260, 5276, 5292, 5308, 5324, 5340,

    // 0x3400 - 0x30000

    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5612, 5868, 5356, 5356, 5356, 6124,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,

    5356, 5356, 5356, 5356, 5356, 6380, 6636, 6892,
    7148, 7404, 7660, 7916, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 8172, 8428, 5356, 8684,
    8940, 9196, 5356, 5356, 5356, 9452, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 9708, 5356, 5356,
    9964, 10220, 10476, 10732, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 10988, 5356, 5356, 11244, 11500, 5356,

    5356, 5356, 5356, 5356, 5356, 5356, 5356, 11756,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,

    5356, 5356, 5356, 5356, 12012, 12268, 12524, 5356,
    5356, 5356, 5356, 5356,


    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2, 0xffff, 0x5, 0xffff, 0xffff, 0xffff, 0xffff, 0x7,

    0xffff, 0xffff, 0xa, 0xc, 0xe, 0x11, 0xffff, 0xffff,
    0x13, 0x16, 0x18, 0xffff, 0x1a, 0x1e, 0x22, 0xffff,

    0x26, 0x29, 0x2c, 0x2f, 0x32, 0x35, 0xffff, 0x38,
    0x3b, 0x3e, 0x41, 0x44, 0x47, 0x4a, 0x4d, 0x50,

    0xffff, 0x53, 0x56, 0x59, 0x5c, 0x5f, 0x62, 0xffff,
    0xffff, 0x65, 0x68, 0x6b, 0x6e, 0x71, 0xffff, 0xffff,

    0x74, 0x77, 0x7a, 0x7d, 0x80, 0x83, 0xffff, 0x86,
    0x89, 0x8c, 0x8f, 0x92, 0x95, 0x98, 0x9b, 0x9e,

    0xffff, 0xa1, 0xa4, 0xa7, 0xaa, 0xad, 0xb0, 0xffff,
    0xffff, 0xb3, 0xb6, 0xb9, 0xbc, 0xbf, 0xffff, 0xc2,

    0xc5, 0xc8, 0xcb, 0xce, 0xd1, 0xd4, 0xd7, 0xda,
    0xdd, 0xe0, 0xe3, 0xe6, 0xe9, 0xec, 0xef, 0xf2,

    0xffff, 0xffff, 0xf5, 0xf8, 0xfb, 0xfe, 0x101, 0x104,
    0x107, 0x10a, 0x10d, 0x110, 0x113, 0x116, 0x119, 0x11c,

    0x11f, 0x122, 0x125, 0x128, 0x12b, 0x12e, 0xffff, 0xffff,
    0x131, 0x134, 0x137, 0x13a, 0x13d, 0x140, 0x143, 0x146,

    0x149, 0xffff, 0x14c, 0x14f, 0x152, 0x155, 0x158, 0x15b,
    0xffff, 0x15e, 0x161, 0x164, 0x167, 0x16a, 0x16d, 0x170,

    0x173, 0xffff, 0xffff, 0x176, 0x179, 0x17c, 0x17f, 0x182,
    0x185, 0x188, 0xffff, 0xffff, 0x18b, 0x18e, 0x191, 0x194,

    0x197, 0x19a, 0xffff, 0xffff, 0x19d, 0x1a0, 0x1a3, 0x1a6,
    0x1a9, 0x1ac, 0x1af, 0x1b2, 0x1b5, 0x1b8, 0x1bb, 0x1be,

    0x1c1, 0x1c4, 0x1c7, 0x1ca, 0x1cd, 0x1d0, 0xffff, 0xffff,
    0x1d3, 0x1d6, 0x1d9, 0x1dc, 0x1df, 0x1e2, 0x1e5, 0x1e8,

    0x1eb, 0x1ee, 0x1f1, 0x1f4, 0x1f7, 0x1fa, 0x1fd, 0x200,
    0x203, 0x206, 0x209, 0x20c, 0x20f, 0x212, 0x215, 0x218,

    0x21a, 0x21d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x220,

    0x223, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x226, 0x229, 0x22c, 0x22f,
    0x232, 0x235, 0x238, 0x23b, 0x23e, 0x241, 0x244, 0x247,

    0x24a, 0x24d, 0x250, 0x253, 0x256, 0x259, 0x25c, 0x25f,
    0x262, 0x265, 0x268, 0x26b, 0x26e, 0xffff, 0x271, 0x274,

    0x277, 0x27a, 0x27d, 0x280, 0xffff, 0xffff, 0x283, 0x286,
    0x289, 0x28c, 0x28f, 0x292, 0x295, 0x298, 0x29b, 0x29e,

    0x2a1, 0x2a4, 0x2a7, 0x2aa, 0x2ad, 0x2b0, 0xffff, 0xffff,
    0x2b3, 0x2b6, 0x2b9, 0x2bc, 0x2bf, 0x2c2, 0x2c5, 0x2c8,

    0x2cb, 0x2ce, 0x2d1, 0x2d4, 0x2d7, 0x2da, 0x2dd, 0x2e0,
    0x2e3, 0x2e6, 0x2e9, 0x2ec, 0x2ef, 0x2f2, 0x2f5, 0x2f8,

    0x2fb, 0x2fe, 0x301, 0x304, 0x307, 0x30a, 0x30d, 0x310,
    0x313, 0x316, 0x319, 0x31c, 0xffff, 0xffff, 0x31f, 0x322,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x325, 0x328,
    0x32b, 0x32e, 0x331, 0x334, 0x337, 0x33a, 0x33d, 0x340,

    0x343, 0x346, 0x349, 0x34c, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x34f, 0x351, 0x353, 0x355, 0x357, 0x359, 0x35b, 0x35d,
    0x35f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x361, 0x364, 0x367, 0x36a, 0x36d, 0x370, 0xffff, 0xffff,

    0x373, 0x375, 0x377, 0x379, 0x37b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x37d, 0x37f, 0xffff, 0x381, 0x383, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x386, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x388, 0xffff, 0xffff, 0xffff, 0x38b, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x38d, 0x390, 0x393, 0x396,
    0x398, 0x39b, 0x39e, 0xffff, 0x3a1, 0xffff, 0x3a4, 0x3a7,

    0x3aa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3ad, 0x3b0, 0x3b3, 0x3b6, 0x3b9, 0x3bc,

    0x3bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3c2, 0x3c5, 0x3c8, 0x3cb, 0x3ce, 0xffff,

    0x3d1, 0x3d3, 0x3d5, 0x3d7, 0x3da, 0x3dd, 0x3df, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3e1, 0x3e3, 0x3e5, 0xffff, 0x3e7, 0x3e9, 0xffff, 0xffff,
    0xffff, 0x3eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3ed, 0x3f0, 0xffff, 0x3f3, 0xffff, 0xffff, 0xffff, 0x3f6,
    0xffff, 0xffff, 0xffff, 0xffff, 0x3f9, 0x3fc, 0x3ff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x402, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x405, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x408, 0x40b, 0xffff, 0x40e, 0xffff, 0xffff, 0xffff, 0x411,
    0xffff, 0xffff, 0xffff, 0xffff, 0x414, 0x417, 0x41a, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x41d, 0x420,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x423, 0x426, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x429, 0x42c, 0x42f, 0x432, 0xffff, 0xffff, 0x435, 0x438,
    0xffff, 0xffff, 0x43b, 0x43e, 0x441, 0x444, 0x447, 0x44a,

    0xffff, 0xffff, 0x44d, 0x450, 0x453, 0x456, 0x459, 0x45c,
    0xffff, 0xffff, 0x45f, 0x462, 0x465, 0x468, 0x46b, 0x46e,

    0x471, 0x474, 0x477, 0x47a, 0x47d, 0x480, 0xffff, 0xffff,
    0x483, 0x486, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x489,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x48c, 0x48f, 0x492, 0x495, 0x498, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x49b, 0x49e, 0x4a1,
    0x4a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x4a7, 0xffff, 0x4aa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x4ad, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4b0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x4b3, 0xffff, 0xffff, 0x4b6, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x4b9, 0x4bc, 0x4bf, 0x4c2, 0x4c5, 0x4c8, 0x4cb, 0x4ce,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x4d1, 0x4d4, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4d7, 0x4da, 0xffff, 0x4dd,

    0xffff, 0xffff, 0xffff, 0x4e0, 0xffff, 0xffff, 0x4e3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4e6, 0x4e9, 0x4ec, 0xffff, 0xffff, 0x4ef, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x4f2, 0xffff, 0xffff, 0x4f5, 0x4f8, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4fb, 0x4fe, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x501, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x504, 0x507, 0x50a, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x50d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x510, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x513,
    0x516, 0xffff, 0x519, 0x51c, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x51f, 0x522, 0x525, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x528, 0xffff, 0x52b, 0x52e, 0x531, 0xffff,

    0xffff, 0xffff, 0xffff, 0x534, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x537, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x53a, 0x53d, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x540, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x542, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x545, 0xffff, 0xffff,

    0xffff, 0xffff, 0x548, 0xffff, 0xffff, 0xffff, 0xffff, 0x54b,
    0xffff, 0xffff, 0xffff, 0xffff, 0x54e, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x551, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x554, 0xffff, 0x557, 0x55a, 0x55d,
    0x560, 0x563, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x566, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x569, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x56c, 0xffff, 0xffff,

    0xffff, 0xffff, 0x56f, 0xffff, 0xffff, 0xffff, 0xffff, 0x572,
    0xffff, 0xffff, 0xffff, 0xffff, 0x575, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x578, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x57b, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x57e, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x580, 0xffff,
    0x583, 0xffff, 0x586, 0xffff, 0x589, 0xffff, 0x58c, 0xffff,

    0xffff, 0xffff, 0x58f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x592, 0xffff, 0x595, 0xffff, 0xffff,

    0x598, 0x59b, 0xffff, 0x59e, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x5a1, 0x5a3, 0x5a5, 0xffff,

    0x5a7, 0x5a9, 0x5ab, 0x5ad, 0x5af, 0x5b1, 0x5b3, 0x5b5,
    0x5b7, 0x5b9, 0x5bb, 0xffff, 0x5bd, 0x5bf, 0x5c1, 0x5c3,

    0x5c5, 0x5c7, 0x5c9, 0x5cb, 0x5cd, 0x5cf, 0x5d1, 0x5d3,
    0x5d5, 0x5d7, 0x5d9, 0x5db, 0x5dd, 0x5df, 0xffff, 0x5e1,

    0x5e3, 0x5e5, 0x5e7, 0x5e9, 0x5eb, 0x5ed, 0x5ef, 0x5f1,
    0x5f3, 0x5f5, 0x5f7, 0x5f9, 0x5fb, 0x5fd, 0x5ff, 0x601,

    0x603, 0x605, 0x607, 0x609, 0x60b, 0x60d, 0x60f, 0x611,
    0x613, 0x615, 0x617, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x619, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x61b, 0x61d, 0x61f, 0x621, 0x623,

    0x625, 0x627, 0x629, 0x62b, 0x62d, 0x62f, 0x631, 0x633,
    0x635, 0x637, 0x639, 0x63b, 0x63d, 0x63f, 0x641, 0x643,

    0x645, 0x647, 0x649, 0x64b, 0x64d, 0x64f, 0x651, 0x653,
    0x655, 0x657, 0x659, 0x65b, 0x65d, 0x65f, 0x661, 0x663,

    0x665, 0x668, 0x66b, 0x66e, 0x671, 0x674, 0x677, 0x67a,
    0x67d, 0x680, 0x683, 0x686, 0x689, 0x68c, 0x68f, 0x692,

    0x695, 0x698, 0x69b, 0x69e, 0x6a1, 0x6a4, 0x6a7, 0x6aa,
    0x6ad, 0x6b0, 0x6b3, 0x6b6, 0x6b9, 0x6bc, 0x6bf, 0x6c2,

    0x6c5, 0x6c8, 0x6cb, 0x6ce, 0x6d1, 0x6d4, 0x6d7, 0x6da,
    0x6dd, 0x6e0, 0x6e3, 0x6e6, 0x6e9, 0x6ec, 0x6ef, 0x6f2,

    0x6f5, 0x6f8, 0x6fb, 0x6fe, 0x701, 0x704, 0x707, 0x70a,
    0x70d, 0x710, 0x713, 0x716, 0x719, 0x71c, 0x71f, 0x722,

    0x725, 0x728, 0x72b, 0x72e, 0x731, 0x734, 0x737, 0x73a,
    0x73d, 0x740, 0x743, 0x746, 0x749, 0x74c, 0x74f, 0x752,

    0x755, 0x758, 0x75b, 0x75e, 0x761, 0x764, 0x767, 0x76a,
    0x76d, 0x770, 0x773, 0x776, 0x779, 0x77c, 0x77f, 0x782,

    0x785, 0x788, 0x78b, 0x78e, 0x791, 0x794, 0x797, 0x79a,
    0x79d, 0x7a0, 0x7a3, 0x7a6, 0x7a9, 0x7ac, 0x7af, 0x7b2,

    0x7b5, 0x7b8, 0x7bb, 0x7be, 0x7c1, 0x7c4, 0x7c7, 0x7ca,
    0x7cd, 0x7d0, 0x7d3, 0x7d6, 0x7d9, 0x7dc, 0x7df, 0x7e2,

    0x7e5, 0x7e8, 0x7eb, 0x7ee, 0x7f1, 0x7f4, 0x7f7, 0x7fa,
    0x7fd, 0x800, 0x803, 0x806, 0x809, 0x80c, 0x80f, 0x812,

    0x815, 0x818, 0x81b, 0x81e, 0x821, 0x824, 0x827, 0x82a,
    0x82d, 0x830, 0x833, 0x836, 0xffff, 0xffff, 0xffff, 0xffff,

    0x839, 0x83c, 0x83f, 0x842, 0x845, 0x848, 0x84b, 0x84e,
    0x851, 0x854, 0x857, 0x85a, 0x85d, 0x860, 0x863, 0x866,

    0x869, 0x86c, 0x86f, 0x872, 0x875, 0x878, 0x87b, 0x87e,
    0x881, 0x884, 0x887, 0x88a, 0x88d, 0x890, 0x893, 0x896,

    0x899, 0x89c, 0x89f, 0x8a2, 0x8a5, 0x8a8, 0x8ab, 0x8ae,
    0x8b1, 0x8b4, 0x8b7, 0x8ba, 0x8bd, 0x8c0, 0x8c3, 0x8c6,

    0x8c9, 0x8cc, 0x8cf, 0x8d2, 0x8d5, 0x8d8, 0x8db, 0x8de,
    0x8e1, 0x8e4, 0x8e7, 0x8ea, 0x8ed, 0x8f0, 0x8f3, 0x8f6,

    0x8f9, 0x8fc, 0x8ff, 0x902, 0x905, 0x908, 0x90b, 0x90e,
    0x911, 0x914, 0x917, 0x91a, 0x91d, 0x920, 0x923, 0x926,

    0x929, 0x92c, 0x92f, 0x932, 0x935, 0x938, 0x93b, 0x93e,
    0x941, 0x944, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x947, 0x94a, 0x94d, 0x950, 0x953, 0x956, 0x959, 0x95c,
    0x95f, 0x962, 0x965, 0x968, 0x96b, 0x96e, 0x971, 0x974,

    0x977, 0x97a, 0x97d, 0x980, 0x983, 0x986, 0xffff, 0xffff,
    0x989, 0x98c, 0x98f, 0x992, 0x995, 0x998, 0xffff, 0xffff,

    0x99b, 0x99e, 0x9a1, 0x9a4, 0x9a7, 0x9aa, 0x9ad, 0x9b0,
    0x9b3, 0x9b6, 0x9b9, 0x9bc, 0x9bf, 0x9c2, 0x9c5, 0x9c8,

    0x9cb, 0x9ce, 0x9d1, 0x9d4, 0x9d7, 0x9da, 0x9dd, 0x9e0,
    0x9e3, 0x9e6, 0x9e9, 0x9ec, 0x9ef, 0x9f2, 0x9f5, 0x9f8,

    0x9fb, 0x9fe, 0xa01, 0xa04, 0xa07, 0xa0a, 0xffff, 0xffff,
    0xa0d, 0xa10, 0xa13, 0xa16, 0xa19, 0xa1c, 0xffff, 0xffff,

    0xa1f, 0xa22, 0xa25, 0xa28, 0xa2b, 0xa2e, 0xa31, 0xa34,
    0xffff, 0xa37, 0xffff, 0xa3a, 0xffff, 0xa3d, 0xffff, 0xa40,

    0xa43, 0xa46, 0xa49, 0xa4c, 0xa4f, 0xa52, 0xa55, 0xa58,
    0xa5b, 0xa5e, 0xa61, 0xa64, 0xa67, 0xa6a, 0xa6d, 0xa70,

    0xa73, 0xa76, 0xa78, 0xa7b, 0xa7d, 0xa80, 0xa82, 0xa85,
    0xa87, 0xa8a, 0xa8c, 0xa8f, 0xa91, 0xa94, 0xffff, 0xffff,

    0xa96, 0xa99, 0xa9c, 0xa9f, 0xaa2, 0xaa5, 0xaa8, 0xaab,
    0xaae, 0xab1, 0xab4, 0xab7, 0xaba, 0xabd, 0xac0, 0xac3,

    0xac6, 0xac9, 0xacc, 0xacf, 0xad2, 0xad5, 0xad8, 0xadb,
    0xade, 0xae1, 0xae4, 0xae7, 0xaea, 0xaed, 0xaf0, 0xaf3,

    0xaf6, 0xaf9, 0xafc, 0xaff, 0xb02, 0xb05, 0xb08, 0xb0b,
    0xb0e, 0xb11, 0xb14, 0xb17, 0xb1a, 0xb1d, 0xb20, 0xb23,

    0xb26, 0xb29, 0xb2c, 0xb2f, 0xb32, 0xffff, 0xb35, 0xb38,
    0xb3b, 0xb3e, 0xb41, 0xb44, 0xb46, 0xb49, 0xb4c, 0xb4e,

    0xb51, 0xb54, 0xb57, 0xb5a, 0xb5d, 0xffff, 0xb60, 0xb63,
    0xb66, 0xb69, 0xb6b, 0xb6e, 0xb70, 0xb73, 0xb76, 0xb79,

    0xb7c, 0xb7f, 0xb82, 0xb85, 0xffff, 0xffff, 0xb87, 0xb8a,
    0xb8d, 0xb90, 0xb93, 0xb96, 0xffff, 0xb98, 0xb9b, 0xb9e,

    0xba1, 0xba4, 0xba7, 0xbaa, 0xbac, 0xbaf, 0xbb2, 0xbb5,
    0xbb8, 0xbbb, 0xbbe, 0xbc1, 0xbc3, 0xbc6, 0xbc9, 0xbcb,

    0xffff, 0xffff, 0xbcd, 0xbd0, 0xbd3, 0xffff, 0xbd6, 0xbd9,
    0xbdc, 0xbdf, 0xbe1, 0xbe4, 0xbe6, 0xbe9, 0xbeb, 0xffff,

    0xbee, 0xbf0, 0xbf2, 0xbf4, 0xbf6, 0xbf8, 0xbfa, 0xbfc,
    0xbfe, 0xc00, 0xc02, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xc04, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc06,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xc09, 0xc0b, 0xc0e, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc12,

    0xffff, 0xffff, 0xffff, 0xc14, 0xc17, 0xffff, 0xc1b, 0xc1e,
    0xffff, 0xffff, 0xffff, 0xffff, 0xc22, 0xffff, 0xc25, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc28,
    0xc2b, 0xc2e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc31,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc36,

    0xc38, 0xc3a, 0xffff, 0xffff, 0xc3c, 0xc3e, 0xc40, 0xc42,
    0xc44, 0xc46, 0xc48, 0xc4a, 0xc4c, 0xc4e, 0xc50, 0xc52,

    0xc54, 0xc56, 0xc58, 0xc5a, 0xc5c, 0xc5e, 0xc60, 0xc62,
    0xc64, 0xc66, 0xc68, 0xc6a, 0xc6c, 0xc6e, 0xc70, 0xffff,

    0xc72, 0xc74, 0xc76, 0xc78, 0xc7a, 0xc7c, 0xc7e, 0xc80,
    0xc82, 0xc84, 0xc86, 0xc88, 0xc8a, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xc8c, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xc8f, 0xc93, 0xc97, 0xc99, 0xffff, 0xc9c, 0xca0, 0xca4,
    0xffff, 0xca6, 0xca9, 0xcab, 0xcad, 0xcaf, 0xcb1, 0xcb3,

    0xcb5, 0xcb7, 0xcb9, 0xcbb, 0xffff, 0xcbd, 0xcbf, 0xffff,
    0xffff, 0xcc2, 0xcc4, 0xcc6, 0xcc8, 0xcca, 0xffff, 0xffff,

    0xccc, 0xccf, 0xcd3, 0xffff, 0xcd6, 0xffff, 0xcd8, 0xffff,
    0xcda, 0xffff, 0xcdc, 0xcde, 0xce0, 0xce2, 0xffff, 0xce4,

    0xce6, 0xce8, 0xffff, 0xcea, 0xcec, 0xcee, 0xcf0, 0xcf2,
    0xcf4, 0xcf6, 0xffff, 0xcf8, 0xcfc, 0xcfe, 0xd00, 0xd02,

    0xd04, 0xffff, 0xffff, 0xffff, 0xffff, 0xd06, 0xd08, 0xd0a,
    0xd0c, 0xd0e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xd10, 0xd14, 0xd18, 0xd1d, 0xd21, 0xd25, 0xd29, 0xd2d,
    0xd31, 0xd35, 0xd39, 0xd3d, 0xd41, 0xd45, 0xd49, 0xd4d,

    0xd50, 0xd52, 0xd55, 0xd59, 0xd5c, 0xd5e, 0xd61, 0xd65,
    0xd6a, 0xd6d, 0xd6f, 0xd72, 0xd76, 0xd78, 0xd7a, 0xd7c,

    0xd7e, 0xd80, 0xd83, 0xd87, 0xd8a, 0xd8c, 0xd8f, 0xd93,
    0xd98, 0xd9b, 0xd9d, 0xda0, 0xda4, 0xda6, 0xda8, 0xdaa,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdac, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xdb0, 0xdb3, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdb6, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdb9, 0xdbc, 0xdbf,

    0xffff, 0xffff, 0xffff, 0xffff, 0xdc2, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdc5, 0xffff, 0xffff, 0xdc8, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xdcb, 0xffff, 0xdce, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xdd1, 0xdd4, 0xffff, 0xdd8,

    0xddb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xddf, 0xffff, 0xffff, 0xde2, 0xffff, 0xffff, 0xde5,
    0xffff, 0xde8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xdeb, 0xffff, 0xdee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdf1, 0xdf4, 0xdf7,

    0xdfa, 0xdfd, 0xffff, 0xffff, 0xe00, 0xe03, 0xffff, 0xffff,
    0xe06, 0xe09, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xe0c, 0xe0f, 0xffff, 0xffff, 0xe12, 0xe15, 0xffff, 0xffff,
    0xe18, 0xe1b, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xe1e, 0xe21, 0xe24, 0xe27,

    0xe2a, 0xe2d, 0xe30, 0xe33, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xe36, 0xe39, 0xe3c, 0xe3f, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xe42, 0xe44, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xe46, 0xe48, 0xe4a, 0xe4c, 0xe4e, 0xe50, 0xe52, 0xe54,
    0xe56, 0xe58, 0xe5b, 0xe5e, 0xe61, 0xe64, 0xe67, 0xe6a,

    0xe6d, 0xe70, 0xe73, 0xe76, 0xe79, 0xe7d, 0xe81, 0xe85,
    0xe89, 0xe8d, 0xe91, 0xe95, 0xe99, 0xe9d, 0xea2, 0xea7,

    0xeac, 0xeb1, 0xeb6, 0xebb, 0xec0, 0xec5, 0xeca, 0xecf,
    0xed4, 0xed7, 0xeda, 0xedd, 0xee0, 0xee3, 0xee6, 0xee9,

    0xeec, 0xeef, 0xef3, 0xef7, 0xefb, 0xeff, 0xf03, 0xf07,
    0xf0b, 0xf0f, 0xf13, 0xf17, 0xf1b, 0xf1f, 0xf23, 0xf27,

    0xf2b, 0xf2f, 0xf33, 0xf37, 0xf3b, 0xf3f, 0xf43, 0xf47,
    0xf4b, 0xf4f, 0xf53, 0xf57, 0xf5b, 0xf5f, 0xf63, 0xf67,

    0xf6b, 0xf6f, 0xf73, 0xf77, 0xf7b, 0xf7f, 0xf83, 0xf85,
    0xf87, 0xf89, 0xf8b, 0xf8d, 0xf8f, 0xf91, 0xf93, 0xf95,

    0xf97, 0xf99, 0xf9b, 0xf9d, 0xf9f, 0xfa1, 0xfa3, 0xfa5,
    0xfa7, 0xfa9, 0xfab, 0xfad, 0xfaf, 0xfb1, 0xfb3, 0xfb5,

    0xfb7, 0xfb9, 0xfbb, 0xfbd, 0xfbf, 0xfc1, 0xfc3, 0xfc5,
    0xfc7, 0xfc9, 0xfcb, 0xfcd, 0xfcf, 0xfd1, 0xfd3, 0xfd5,

    0xfd7, 0xfd9, 0xfdb, 0xfdd, 0xfdf, 0xfe1, 0xfe3, 0xfe5,
    0xfe7, 0xfe9, 0xfeb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xfed, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xff2, 0xff6, 0xff9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffd, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x1000, 0x1002, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1004,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1006,

    0xffff, 0xffff, 0xffff, 0x1008, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x100a, 0x100c, 0x100e, 0x1010, 0x1012, 0x1014, 0x1016, 0x1018,
    0x101a, 0x101c, 0x101e, 0x1020, 0x1022, 0x1024, 0x1026, 0x1028,

    0x102a, 0x102c, 0x102e, 0x1030, 0x1032, 0x1034, 0x1036, 0x1038,
    0x103a, 0x103c, 0x103e, 0x1040, 0x1042, 0x1044, 0x1046, 0x1048,

    0x104a, 0x104c, 0x104e, 0x1050, 0x1052, 0x1054, 0x1056, 0x1058,
    0x105a, 0x105c, 0x105e, 0x1060, 0x1062, 0x1064, 0x1066, 0x1068,

    0x106a, 0x106c, 0x106e, 0x1070, 0x1072, 0x1074, 0x1076, 0x1078,
    0x107a, 0x107c, 0x107e, 0x1080, 0x1082, 0x1084, 0x1086, 0x1088,

    0x108a, 0x108c, 0x108e, 0x1090, 0x1092, 0x1094, 0x1096, 0x1098,
    0x109a, 0x109c, 0x109e, 0x10a0, 0x10a2, 0x10a4, 0x10a6, 0x10a8,

    0x10aa, 0x10ac, 0x10ae, 0x10b0, 0x10b2, 0x10b4, 0x10b6, 0x10b8,
    0x10ba, 0x10bc, 0x10be, 0x10c0, 0x10c2, 0x10c4, 0x10c6, 0x10c8,

    0x10ca, 0x10cc, 0x10ce, 0x10d0, 0x10d2, 0x10d4, 0x10d6, 0x10d8,
    0x10da, 0x10dc, 0x10de, 0x10e0, 0x10e2, 0x10e4, 0x10e6, 0x10e8,

    0x10ea, 0x10ec, 0x10ee, 0x10f0, 0x10f2, 0x10f4, 0x10f6, 0x10f8,
    0x10fa, 0x10fc, 0x10fe, 0x1100, 0x1102, 0x1104, 0x1106, 0x1108,

    0x110a, 0x110c, 0x110e, 0x1110, 0x1112, 0x1114, 0x1116, 0x1118,
    0x111a, 0x111c, 0x111e, 0x1120, 0x1122, 0x1124, 0x1126, 0x1128,

    0x112a, 0x112c, 0x112e, 0x1130, 0x1132, 0x1134, 0x1136, 0x1138,
    0x113a, 0x113c, 0x113e, 0x1140, 0x1142, 0x1144, 0x1146, 0x1148,

    0x114a, 0x114c, 0x114e, 0x1150, 0x1152, 0x1154, 0x1156, 0x1158,
    0x115a, 0x115c, 0x115e, 0x1160, 0x1162, 0x1164, 0x1166, 0x1168,

    0x116a, 0x116c, 0x116e, 0x1170, 0x1172, 0x1174, 0x1176, 0x1178,
    0x117a, 0x117c, 0x117e, 0x1180, 0x1182, 0x1184, 0x1186, 0x1188,

    0x118a, 0x118c, 0x118e, 0x1190, 0x1192, 0x1194, 0x1196, 0x1198,
    0x119a, 0x119c, 0x119e, 0x11a0, 0x11a2, 0x11a4, 0x11a6, 0x11a8,

    0x11aa, 0x11ac, 0x11ae, 0x11b0, 0x11b2, 0x11b4, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x11b6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x11b8, 0xffff,
    0x11ba, 0x11bc, 0x11be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x11c0, 0xffff, 0x11c3, 0xffff,

    0x11c6, 0xffff, 0x11c9, 0xffff, 0x11cc, 0xffff, 0x11cf, 0xffff,
    0x11d2, 0xffff, 0x11d5, 0xffff, 0x11d8, 0xffff, 0x11db, 0xffff,

    0x11de, 0xffff, 0x11e1, 0xffff, 0xffff, 0x11e4, 0xffff, 0x11e7,
    0xffff, 0x11ea, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x11ed, 0x11f0, 0xffff, 0x11f3, 0x11f6, 0xffff, 0x11f9, 0x11fc,
    0xffff, 0x11ff, 0x1202, 0xffff, 0x1205, 0x1208, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x120b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x120e, 0x1211, 0xffff, 0x1214, 0x1217,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x121a, 0xffff, 0x121d, 0xffff,

    0x1220, 0xffff, 0x1223, 0xffff, 0x1226, 0xffff, 0x1229, 0xffff,
    0x122c, 0xffff, 0x122f, 0xffff, 0x1232, 0xffff, 0x1235, 0xffff,

    0x1238, 0xffff, 0x123b, 0xffff, 0xffff, 0x123e, 0xffff, 0x1241,
    0xffff, 0x1244, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1247, 0x124a, 0xffff, 0x124d, 0x1250, 0xffff, 0x1253, 0x1256,
    0xffff, 0x1259, 0x125c, 0xffff, 0x125f, 0x1262, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x1265, 0xffff, 0xffff, 0x1268,
    0x126b, 0x126e, 0x1271, 0xffff, 0xffff, 0xffff, 0x1274, 0x1277,

    0xffff, 0x127a, 0x127c, 0x127e, 0x1280, 0x1282, 0x1284, 0x1286,
    0x1288, 0x128a, 0x128c, 0x128e, 0x1290, 0x1292, 0x1294, 0x1296,

    0x1298, 0x129a, 0x129c, 0x129e, 0x12a0, 0x12a2, 0x12a4, 0x12a6,
    0x12a8, 0x12aa, 0x12ac, 0x12ae, 0x12b0, 0x12b2, 0x12b4, 0x12b6,

    0x12b8, 0x12ba, 0x12bc, 0x12be, 0x12c0, 0x12c2, 0x12c4, 0x12c6,
    0x12c8, 0x12ca, 0x12cc, 0x12ce, 0x12d0, 0x12d2, 0x12d4, 0x12d6,

    0x12d8, 0x12da, 0x12dc, 0x12de, 0x12e0, 0x12e2, 0x12e4, 0x12e6,
    0x12e8, 0x12ea, 0x12ec, 0x12ee, 0x12f0, 0x12f2, 0x12f4, 0x12f6,

    0x12f8, 0x12fa, 0x12fc, 0x12fe, 0x1300, 0x1302, 0x1304, 0x1306,
    0x1308, 0x130a, 0x130c, 0x130e, 0x1310, 0x1312, 0x1314, 0x1316,

    0x1318, 0x131a, 0x131c, 0x131e, 0x1320, 0x1322, 0x1324, 0x1326,
    0x1328, 0x132a, 0x132c, 0x132e, 0x1330, 0x1332, 0x1334, 0xffff,

    0xffff, 0xffff, 0x1336, 0x1338, 0x133a, 0x133c, 0x133e, 0x1340,
    0x1342, 0x1344, 0x1346, 0x1348, 0x134a, 0x134c, 0x134e, 0x1350,

    0x1352, 0x1356, 0x135a, 0x135e, 0x1362, 0x1366, 0x136a, 0x136e,
    0x1372, 0x1376, 0x137a, 0x137e, 0x1382, 0x1386, 0x138a, 0x138f,

    0x1394, 0x1399, 0x139e, 0x13a3, 0x13a8, 0x13ad, 0x13b2, 0x13b7,
    0x13bc, 0x13c1, 0x13c6, 0x13cb, 0x13d0, 0x13d5, 0x13dd, 0xffff,

    0x13e4, 0x13e8, 0x13ec, 0x13f0, 0x13f4, 0x13f8, 0x13fc, 0x1400,
    0x1404, 0x1408, 0x140c, 0x1410, 0x1414, 0x1418, 0x141c, 0x1420,

    0x1424, 0x1428, 0x142c, 0x1430, 0x1434, 0x1438, 0x143c, 0x1440,
    0x1444, 0x1448, 0x144c, 0x1450, 0x1454, 0x1458, 0x145c, 0x1460,

    0x1464, 0x1468, 0x146c, 0x1470, 0x1474, 0x1476, 0x1478, 0x147a,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x147c, 0x1480, 0x1483, 0x1486, 0x1489, 0x148c, 0x148f, 0x1492,
    0x1495, 0x1498, 0x149b, 0x149e, 0x14a1, 0x14a4, 0x14a7, 0x14aa,

    0x14ad, 0x14af, 0x14b1, 0x14b3, 0x14b5, 0x14b7, 0x14b9, 0x14bb,
    0x14bd, 0x14bf, 0x14c1, 0x14c3, 0x14c5, 0x14c7, 0x14c9, 0x14cc,

    0x14cf, 0x14d2, 0x14d5, 0x14d8, 0x14db, 0x14de, 0x14e1, 0x14e4,
    0x14e7, 0x14ea, 0x14ed, 0x14f0, 0x14f3, 0x14f9, 0x14fe, 0xffff,

    0x1501, 0x1503, 0x1505, 0x1507, 0x1509, 0x150b, 0x150d, 0x150f,
    0x1511, 0x1513, 0x1515, 0x1517, 0x1519, 0x151b, 0x151d, 0x151f,

    0x1521, 0x1523, 0x1525, 0x1527, 0x1529, 0x152b, 0x152d, 0x152f,
    0x1531, 0x1533, 0x1535, 0x1537, 0x1539, 0x153b, 0x153d, 0x153f,

    0x1541, 0x1543, 0x1545, 0x1547, 0x1549, 0x154b, 0x154d, 0x154f,
    0x1551, 0x1553, 0x1555, 0x1557, 0x1559, 0x155b, 0x155d, 0x155f,

    0x1561, 0x1563, 0x1566, 0x1569, 0x156c, 0x156f, 0x1572, 0x1575,
    0x1578, 0x157b, 0x157e, 0x1581, 0x1584, 0x1587, 0x158a, 0x158d,

    0x1590, 0x1593, 0x1596, 0x1599, 0x159c, 0x159f, 0x15a2, 0x15a5,
    0x15a8, 0x15ab, 0x15af, 0x15b3, 0x15b7, 0x15ba, 0x15be, 0x15c1,

    0x15c5, 0x15c7, 0x15c9, 0x15cb, 0x15cd, 0x15cf, 0x15d1, 0x15d3,
    0x15d5, 0x15d7, 0x15d9, 0x15db, 0x15dd, 0x15df, 0x15e1, 0x15e3,

    0x15e5, 0x15e7, 0x15e9, 0x15eb, 0x15ed, 0x15ef, 0x15f1, 0x15f3,
    0x15f5, 0x15f7, 0x15f9, 0x15fb, 0x15fd, 0x15ff, 0x1601, 0x1603,

    0x1605, 0x1607, 0x1609, 0x160b, 0x160d, 0x160f, 0x1611, 0x1613,
    0x1615, 0x1617, 0x1619, 0x161b, 0x161d, 0x161f, 0x1621, 0x1623,

    0x1626, 0x162b, 0x1630, 0x1635, 0x1639, 0x163e, 0x1642, 0x1646,
    0x164c, 0x1651, 0x1655, 0x1659, 0x165d, 0x1662, 0x1667, 0x166b,

    0x166f, 0x1672, 0x1676, 0x167b, 0x1680, 0x1683, 0x1689, 0x1690,
    0x1696, 0x169a, 0x16a0, 0x16a6, 0x16ab, 0x16af, 0x16b3, 0x16b7,

    0x16bc, 0x16c2, 0x16c7, 0x16cb, 0x16cf, 0x16d3, 0x16d6, 0x16d9,
    0x16dc, 0x16df, 0x16e3, 0x16e7, 0x16ed, 0x16f1, 0x16f6, 0x16fc,

    0x1700, 0x1703, 0x1706, 0x170c, 0x1711, 0x1717, 0x171b, 0x1721,
    0x1724, 0x1728, 0x172c, 0x1730, 0x1734, 0x1738, 0x173d, 0x1741,

    0x1744, 0x1748, 0x174c, 0x1750, 0x1755, 0x1759, 0x175d, 0x1761,
    0x1767, 0x176c, 0x176f, 0x1775, 0x1778, 0x177d, 0x1782, 0x1786,

    0x178a, 0x178e, 0x1793, 0x1796, 0x179a, 0x179f, 0x17a2, 0x17a8,
    0x17ac, 0x17af, 0x17b2, 0x17b5, 0x17b8, 0x17bb, 0x17be, 0x17c1,

    0x17c4, 0x17c7, 0x17ca, 0x17ce, 0x17d2, 0x17d6, 0x17da, 0x17de,
    0x17e2, 0x17e6, 0x17ea, 0x17ee, 0x17f2, 0x17f6, 0x17fa, 0x17fe,

    0x1802, 0x1806, 0x180a, 0x180d, 0x1810, 0x1814, 0x1817, 0x181a,
    0x181d, 0x1821, 0x1825, 0x1828, 0x182b, 0x182e, 0x1831, 0x1834,

    0x1839, 0x183c, 0x183f, 0x1842, 0x1845, 0x1848, 0x184b, 0x184e,
    0x1851, 0x1855, 0x185a, 0x185d, 0x1860, 0x1863, 0x1866, 0x1869,

    0x186c, 0x186f, 0x1873, 0x1877, 0x187b, 0x187f, 0x1882, 0x1885,
    0x1888, 0x188b, 0x188e, 0x1891, 0x1894, 0x1897, 0x189a, 0x189d,

    0x18a1, 0x18a5, 0x18a8, 0x18ac, 0x18b0, 0x18b4, 0x18b7, 0x18bb,
    0x18bf, 0x18c4, 0x18c7, 0x18cb, 0x18cf, 0x18d3, 0x18d7, 0x18dd,

    0x18e4, 0x18e7, 0x18ea, 0x18ed, 0x18f0, 0x18f3, 0x18f6, 0x18f9,
    0x18fc, 0x18ff, 0x1902, 0x1905, 0x1908, 0x190b, 0x190e, 0x1911,

    0x1914, 0x1917, 0x191a, 0x191f, 0x1922, 0x1925, 0x1928, 0x192d,
    0x1931, 0x1934, 0x1937, 0x193a, 0x193d, 0x1940, 0x1943, 0x1946,

    0x1949, 0x194c, 0x194f, 0x1953, 0x1956, 0x1959, 0x195d, 0x1961,
    0x1964, 0x1969, 0x196d, 0x1970, 0x1973, 0x1976, 0x1979, 0x197d,

    0x1981, 0x1984, 0x1987, 0x198a, 0x198d, 0x1990, 0x1993, 0x1996,
    0x1999, 0x199c, 0x19a0, 0x19a4, 0x19a8, 0x19ac, 0x19b0, 0x19b4,

    0x19b8, 0x19bc, 0x19c0, 0x19c4, 0x19c8, 0x19cc, 0x19d0, 0x19d4,
    0x19d8, 0x19dc, 0x19e0, 0x19e4, 0x19e8, 0x19ec, 0x19f0, 0x19f4,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x19f8, 0x19fa, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x19fc, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x19fe, 0x1a00, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x1a02, 0x1a04, 0x1a06, 0x1a08,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x1a0a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1a0c, 0x1a0e, 0x1a10, 0x1a12, 0x1a14, 0x1a16, 0x1a18, 0x1a1a,
    0x1a1c, 0x1a1e, 0x1a20, 0x1a22, 0x1a24, 0x1a26, 0x1a28, 0x1a2a,
    0x1a2c, 0x1a2e, 0x1a30, 0x1a32, 0x1a34, 0x1a36, 0x1a38, 0x1a3a,
    0x1a3c, 0x1a3e, 0x1a40, 0x1a42, 0x1a44, 0x1a46, 0x1a48, 0x1a4a,
    0x1a4c, 0x1a4e, 0x1a50, 0x1a52, 0x1a54, 0x1a56, 0x1a58, 0x1a5a,
    0x1a5c, 0x1a5e, 0x1a60, 0x1a62, 0x1a64, 0x1a66, 0x1a68, 0x1a6a,
    0x1a6c, 0x1a6e, 0x1a70, 0x1a72, 0x1a74, 0x1a76, 0x1a78, 0x1a7a,
    0x1a7c, 0x1a7e, 0x1a80, 0x1a82, 0x1a84, 0x1a86, 0x1a88, 0x1a8a,
    0x1a8c, 0x1a8e, 0x1a90, 0x1a92, 0x1a94, 0x1a96, 0x1a98, 0x1a9a,
    0x1a9c, 0x1a9e, 0x1aa0, 0x1aa2, 0x1aa4, 0x1aa6, 0x1aa8, 0x1aaa,
    0x1aac, 0x1aae, 0x1ab0, 0x1ab2, 0x1ab4, 0x1ab6, 0x1ab8, 0x1aba,
    0x1abc, 0x1abe, 0x1ac0, 0x1ac2, 0x1ac4, 0x1ac6, 0x1ac8, 0x1aca,
    0x1acc, 0x1ace, 0x1ad0, 0x1ad2, 0x1ad4, 0x1ad6, 0x1ad8, 0x1ada,
    0x1adc, 0x1ade, 0x1ae0, 0x1ae2, 0x1ae4, 0x1ae6, 0x1ae8, 0x1aea,
    0x1aec, 0x1aee, 0x1af0, 0x1af2, 0x1af4, 0x1af6, 0x1af8, 0x1afa,
    0x1afc, 0x1afe, 0x1b00, 0x1b02, 0x1b04, 0x1b06, 0x1b08, 0x1b0a,
    0x1b0c, 0x1b0e, 0x1b10, 0x1b12, 0x1b14, 0x1b16, 0x1b18, 0x1b1a,
    0x1b1c, 0x1b1e, 0x1b20, 0x1b22, 0x1b24, 0x1b26, 0x1b28, 0x1b2a,
    0x1b2c, 0x1b2e, 0x1b30, 0x1b32, 0x1b34, 0x1b36, 0x1b38, 0x1b3a,
    0x1b3c, 0x1b3e, 0x1b40, 0x1b42, 0x1b44, 0x1b46, 0x1b48, 0x1b4a,
    0x1b4c, 0x1b4e, 0x1b50, 0x1b52, 0x1b54, 0x1b56, 0x1b58, 0x1b5a,
    0x1b5c, 0x1b5e, 0x1b60, 0x1b62, 0x1b64, 0x1b66, 0x1b68, 0x1b6a,
    0x1b6c, 0x1b6e, 0x1b70, 0x1b72, 0x1b74, 0x1b76, 0x1b78, 0x1b7a,
    0x1b7c, 0x1b7e, 0x1b80, 0x1b82, 0x1b84, 0x1b86, 0x1b88, 0x1b8a,
    0x1b8c, 0x1b8e, 0x1b90, 0x1b92, 0x1b94, 0x1b96, 0x1b98, 0x1b9a,
    0x1b9c, 0x1b9e, 0x1ba0, 0x1ba2, 0x1ba4, 0x1ba6, 0x1ba8, 0x1baa,
    0x1bac, 0x1bae, 0x1bb0, 0x1bb2, 0x1bb4, 0x1bb6, 0x1bb8, 0x1bba,
    0x1bbc, 0x1bbe, 0x1bc0, 0x1bc2, 0x1bc4, 0x1bc6, 0x1bc8, 0x1bca,
    0x1bcc, 0x1bce, 0x1bd0, 0x1bd2, 0x1bd4, 0x1bd6, 0x1bd8, 0x1bda,
    0x1bdc, 0x1bde, 0x1be0, 0x1be2, 0x1be4, 0x1be6, 0x1be8, 0x1bea,
    0x1bec, 0x1bee, 0x1bf0, 0x1bf2, 0x1bf4, 0x1bf6, 0x1bf8, 0x1bfa,
    0x1bfc, 0x1bfe, 0x1c00, 0x1c02, 0x1c04, 0x1c06, 0x1c08, 0x1c0a,

    0x1c0c, 0x1c0e, 0x1c10, 0x1c12, 0x1c14, 0x1c16, 0x1c18, 0x1c1a,
    0x1c1c, 0x1c1e, 0x1c20, 0x1c22, 0x1c24, 0x1c26, 0xffff, 0xffff,
    0x1c28, 0xffff, 0x1c2a, 0xffff, 0xffff, 0x1c2c, 0x1c2e, 0x1c30,
    0x1c32, 0x1c34, 0x1c36, 0x1c38, 0x1c3a, 0x1c3c, 0x1c3e, 0xffff,
    0x1c40, 0xffff, 0x1c42, 0xffff, 0xffff, 0x1c44, 0x1c46, 0xffff,
    0xffff, 0xffff, 0x1c48, 0x1c4a, 0x1c4c, 0x1c4e, 0x1c50, 0x1c52,
    0x1c54, 0x1c56, 0x1c58, 0x1c5a, 0x1c5c, 0x1c5e, 0x1c60, 0x1c62,
    0x1c64, 0x1c66, 0x1c68, 0x1c6a, 0x1c6c, 0x1c6e, 0x1c70, 0x1c72,
    0x1c74, 0x1c76, 0x1c78, 0x1c7a, 0x1c7c, 0x1c7e, 0x1c80, 0x1c82,
    0x1c84, 0x1c86, 0x1c88, 0x1c8a, 0x1c8c, 0x1c8e, 0x1c90, 0x1c92,
    0x1c94, 0x1c96, 0x1c98, 0x1c9a, 0x1c9c, 0x1c9e, 0x1ca0, 0x1ca2,
    0x1ca4, 0x1ca6, 0x1ca8, 0x1caa, 0x1cac, 0x1cae, 0x1cb0, 0x1cb2,
    0x1cb4, 0x1cb6, 0x1cb8, 0x1cba, 0x1cbc, 0x1cbe, 0x1cc0, 0x1cc2,
    0x1cc4, 0x1cc6, 0x1cc8, 0x1cca, 0x1ccc, 0x1ccf, 0xffff, 0xffff,
    0x1cd1, 0x1cd3, 0x1cd5, 0x1cd7, 0x1cd9, 0x1cdb, 0x1cdd, 0x1cdf,
    0x1ce1, 0x1ce3, 0x1ce5, 0x1ce7, 0x1ce9, 0x1ceb, 0x1ced, 0x1cef,
    0x1cf1, 0x1cf3, 0x1cf5, 0x1cf7, 0x1cf9, 0x1cfb, 0x1cfd, 0x1cff,
    0x1d01, 0x1d03, 0x1d05, 0x1d07, 0x1d09, 0x1d0b, 0x1d0d, 0x1d0f,
    0x1d11, 0x1d13, 0x1d15, 0x1d17, 0x1d19, 0x1d1b, 0x1d1d, 0x1d1f,
    0x1d21, 0x1d23, 0x1d25, 0x1d27, 0x1d29, 0x1d2b, 0x1d2d, 0x1d2f,
    0x1d31, 0x1d33, 0x1d35, 0x1d37, 0x1d39, 0x1d3b, 0x1d3d, 0x1d3f,
    0x1d41, 0x1d43, 0x1d45, 0x1d47, 0x1d49, 0x1d4b, 0x1d4d, 0x1d4f,
    0x1d51, 0x1d53, 0x1d55, 0x1d57, 0x1d59, 0x1d5b, 0x1d5d, 0x1d5f,
    0x1d61, 0x1d63, 0x1d65, 0x1d67, 0x1d69, 0x1d6b, 0x1d6d, 0x1d6f,
    0x1d71, 0x1d73, 0x1d75, 0x1d77, 0x1d79, 0x1d7b, 0x1d7d, 0x1d7f,
    0x1d81, 0x1d83, 0x1d85, 0x1d87, 0x1d89, 0x1d8b, 0x1d8d, 0x1d8f,
    0x1d92, 0x1d95, 0x1d98, 0x1d9a, 0x1d9c, 0x1d9e, 0x1da1, 0x1da4,
    0x1da7, 0x1da9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1dab, 0x1dae, 0x1db1, 0x1db4, 0x1db8, 0x1dbc, 0x1dbf, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x1dc2, 0x1dc5, 0x1dc8, 0x1dcb, 0x1dce,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1dd1, 0xffff, 0x1dd4,
    0x1dd7, 0x1dd9, 0x1ddb, 0x1ddd, 0x1ddf, 0x1de1, 0x1de3, 0x1de5,
    0x1de7, 0x1de9, 0x1deb, 0x1dee, 0x1df1, 0x1df4, 0x1df7, 0x1dfa,
    0x1dfd, 0x1e00, 0x1e03, 0x1e06, 0x1e09, 0x1e0c, 0x1e0f, 0xffff,
    0x1e12, 0x1e15, 0x1e18, 0x1e1b, 0x1e1e, 0xffff, 0x1e21, 0xffff,
    0x1e24, 0x1e27, 0xffff, 0x1e2a, 0x1e2d, 0xffff, 0x1e30, 0x1e33,
    0x1e36, 0x1e39, 0x1e3c, 0x1e3f, 0x1e42, 0x1e45, 0x1e48, 0x1e4b,
    0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c,
    0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 0x1e6a, 0x1e6c,
    0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 0x1e7a, 0x1e7c,
    0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 0x1e8a, 0x1e8c,
    0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e96, 0x1e98, 0x1e9a, 0x1e9c,
    0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac,
    0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc,
    0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc,
    0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc,
    0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 0x1eec,
    0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 0x1efc,
    0x1efe, 0x1f00, 0x1f02, 0x1f04, 0x1f06, 0x1f08, 0x1f0a, 0x1f0c,
    0x1f0e, 0x1f10, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x1f12, 0x1f14, 0x1f16, 0x1f18, 0x1f1a,
    0x1f1c, 0x1f1e, 0x1f20, 0x1f22, 0x1f24, 0x1f26, 0x1f28, 0x1f2a,
    0x1f2c, 0x1f2e, 0x1f30, 0x1f32, 0x1f34, 0x1f36, 0x1f38, 0x1f3a,
    0x1f3c, 0x1f3e, 0x1f40, 0x1f43, 0x1f46, 0x1f49, 0x1f4c, 0x1f4f,
    0x1f52, 0x1f55, 0x1f58, 0x1f5b, 0x1f5e, 0x1f61, 0x1f64, 0x1f67,
    0x1f6a, 0x1f6d, 0x1f70, 0x1f73, 0x1f76, 0x1f78, 0x1f7a, 0x1f7c,

    0x1f7e, 0x1f81, 0x1f84, 0x1f87, 0x1f8a, 0x1f8d, 0x1f90, 0x1f93,
    0x1f96, 0x1f99, 0x1f9c, 0x1f9f, 0x1fa2, 0x1fa5, 0x1fa8, 0x1fab,
    0x1fae, 0x1fb1, 0x1fb4, 0x1fb7, 0x1fba, 0x1fbd, 0x1fc0, 0x1fc3,
    0x1fc6, 0x1fc9, 0x1fcc, 0x1fcf, 0x1fd2, 0x1fd5, 0x1fd8, 0x1fdb,
    0x1fde, 0x1fe1, 0x1fe4, 0x1fe7, 0x1fea, 0x1fed, 0x1ff0, 0x1ff3,
    0x1ff6, 0x1ff9, 0x1ffc, 0x1fff, 0x2002, 0x2005, 0x2008, 0x200b,
    0x200e, 0x2011, 0x2014, 0x2017, 0x201a, 0x201d, 0x2020, 0x2023,
    0x2026, 0x2029, 0x202c, 0x202f, 0x2032, 0x2035, 0x2038, 0x203b,
    0x203e, 0x2041, 0x2044, 0x2047, 0x204a, 0x204d, 0x2050, 0x2053,
    0x2056, 0x2059, 0x205c, 0x205f, 0x2062, 0x2065, 0x2068, 0x206b,
    0x206e, 0x2071, 0x2074, 0x2077, 0x207a, 0x207d, 0x2080, 0x2083,
    0x2086, 0x2089, 0x208c, 0x208f, 0x2092, 0x2095, 0x2098, 0x209c,
    0x20a0, 0x20a4, 0x20a8, 0x20ac, 0x20b0, 0x20b3, 0x20b6, 0x20b9,
    0x20bc, 0x20bf, 0x20c2, 0x20c5, 0x20c8, 0x20cb, 0x20ce, 0x20d1,
    0x20d4, 0x20d7, 0x20da, 0x20dd, 0x20e0, 0x20e3, 0x20e6, 0x20e9,
    0x20ec, 0x20ef, 0x20f2, 0x20f5, 0x20f8, 0x20fb, 0x20fe, 0x2101,
    0x2104, 0x2107, 0x210a, 0x210d, 0x2110, 0x2113, 0x2116, 0x2119,
    0x211c, 0x211f, 0x2122, 0x2125, 0x2128, 0x212b, 0x212e, 0x2131,
    0x2134, 0x2137, 0x213a, 0x213d, 0x2140, 0x2143, 0x2146, 0x2149,
    0x214c, 0x214f, 0x2152, 0x2155, 0x2158, 0x215b, 0x215e, 0x2161,
    0x2164, 0x2167, 0x216a, 0x216d, 0x2170, 0x2173, 0x2176, 0x2179,
    0x217c, 0x217f, 0x2182, 0x2185, 0x2188, 0x218b, 0x218e, 0x2191,
    0x2194, 0x2197, 0x219a, 0x219d, 0x21a0, 0x21a3, 0x21a6, 0x21a9,
    0x21ac, 0x21af, 0x21b2, 0x21b5, 0x21b8, 0x21bb, 0x21be, 0x21c1,
    0x21c4, 0x21c7, 0x21ca, 0x21cd, 0x21d0, 0x21d3, 0x21d6, 0x21d9,
    0x21dc, 0x21df, 0x21e2, 0x21e5, 0x21e8, 0x21eb, 0x21ee, 0x21f1,
    0x21f4, 0x21f7, 0x21fa, 0x21fd, 0x2200, 0x2203, 0x2206, 0x2209,
    0x220c, 0x220f, 0x2212, 0x2215, 0x2218, 0x221b, 0x221e, 0x2221,
    0x2224, 0x2227, 0x222a, 0x222d, 0x2230, 0x2233, 0x2236, 0x2239,
    0x223c, 0x223f, 0x2242, 0x2245, 0x2248, 0x224b, 0x224e, 0x2251,
    0x2254, 0x2257, 0x225a, 0x225e, 0x2262, 0x2266, 0x2269, 0x226c,
    0x226f, 0x2272, 0x2275, 0x2278, 0x227b, 0x227e, 0x2281, 0x2284,

    0x2287, 0x228a, 0x228d, 0x2290, 0x2293, 0x2296, 0x2299, 0x229c,
    0x229f, 0x22a2, 0x22a5, 0x22a8, 0x22ab, 0x22ae, 0x22b1, 0x22b4,
    0x22b7, 0x22ba, 0x22bd, 0x22c0, 0x22c3, 0x22c6, 0x22c9, 0x22cc,
    0x22cf, 0x22d2, 0x22d5, 0x22d8, 0x22db, 0x22de, 0x22e1, 0x22e4,
    0x22e7, 0x22ea, 0x22ed, 0x22f0, 0x22f3, 0x22f6, 0x22f9, 0x22fc,
    0x22ff, 0x2302, 0x2305, 0x2308, 0x230b, 0x230e, 0x2311, 0x2314,
    0x2317, 0x231a, 0x231d, 0x2320, 0x2323, 0x2326, 0x2329, 0x232c,
    0x232f, 0x2332, 0x2335, 0x2338, 0x233b, 0x233e, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2341, 0x2345, 0x2349, 0x234d, 0x2351, 0x2355, 0x2359, 0x235d,
    0x2361, 0x2365, 0x2369, 0x236d, 0x2371, 0x2375, 0x2379, 0x237d,
    0x2381, 0x2385, 0x2389, 0x238d, 0x2391, 0x2395, 0x2399, 0x239d,
    0x23a1, 0x23a5, 0x23a9, 0x23ad, 0x23b1, 0x23b5, 0x23b9, 0x23bd,
    0x23c1, 0x23c5, 0x23c9, 0x23cd, 0x23d1, 0x23d5, 0x23d9, 0x23dd,
    0x23e1, 0x23e5, 0x23e9, 0x23ed, 0x23f1, 0x23f5, 0x23f9, 0x23fd,
    0x2401, 0x2405, 0x2409, 0x240d, 0x2411, 0x2415, 0x2419, 0x241d,
    0x2421, 0x2425, 0x2429, 0x242d, 0x2431, 0x2435, 0x2439, 0x243d,
    0xffff, 0xffff, 0x2441, 0x2445, 0x2449, 0x244d, 0x2451, 0x2455,
    0x2459, 0x245d, 0x2461, 0x2465, 0x2469, 0x246d, 0x2471, 0x2475,
    0x2479, 0x247d, 0x2481, 0x2485, 0x2489, 0x248d, 0x2491, 0x2495,
    0x2499, 0x249d, 0x24a1, 0x24a5, 0x24a9, 0x24ad, 0x24b1, 0x24b5,
    0x24b9, 0x24bd, 0x24c1, 0x24c5, 0x24c9, 0x24cd, 0x24d1, 0x24d5,
    0x24d9, 0x24dd, 0x24e1, 0x24e5, 0x24e9, 0x24ed, 0x24f1, 0x24f5,
    0x24f9, 0x24fd, 0x2501, 0x2505, 0x2509, 0x250d, 0x2511, 0x2515,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2519, 0x251d, 0x2521, 0x2526, 0x252b, 0x2530, 0x2535, 0x253a,
    0x253f, 0x2544, 0x2548, 0x255b, 0x2564, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2569, 0x256b, 0x256d, 0x256f, 0x2571, 0x2573, 0x2575, 0x2577,
    0x2579, 0x257b, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x257d, 0x257f, 0x2581, 0x2583, 0x2585, 0x2587, 0x2589, 0x258b,
    0x258d, 0x258f, 0x2591, 0x2593, 0x2595, 0x2597, 0x2599, 0x259b,
    0x259d, 0x259f, 0x25a1, 0x25a3, 0x25a5, 0xffff, 0xffff, 0x25a7,
    0x25a9, 0x25ab, 0x25ad, 0x25af, 0x25b1, 0x25b3, 0x25b5, 0x25b7,
    0x25b9, 0x25bb, 0x25bd, 0xffff, 0x25bf, 0x25c1, 0x25c3, 0x25c5,
    0x25c7, 0x25c9, 0x25cb, 0x25cd, 0x25cf, 0x25d1, 0x25d3, 0x25d5,
    0x25d7, 0x25d9, 0x25db, 0x25dd, 0x25df, 0x25e1, 0x25e3, 0xffff,
    0x25e5, 0x25e7, 0x25e9, 0x25eb, 0xffff, 0xffff, 0xffff, 0xffff,
    0x25ed, 0x25f0, 0x25f3, 0xffff, 0x25f6, 0xffff, 0x25f9, 0x25fc,
    0x25ff, 0x2602, 0x2605, 0x2608, 0x260b, 0x260e, 0x2611, 0x2614,
    0x2617, 0x2619, 0x261b, 0x261d, 0x261f, 0x2621, 0x2623, 0x2625,
    0x2627, 0x2629, 0x262b, 0x262d, 0x262f, 0x2631, 0x2633, 0x2635,
    0x2637, 0x2639, 0x263b, 0x263d, 0x263f, 0x2641, 0x2643, 0x2645,
    0x2647, 0x2649, 0x264b, 0x264d, 0x264f, 0x2651, 0x2653, 0x2655,
    0x2657, 0x2659, 0x265b, 0x265d, 0x265f, 0x2661, 0x2663, 0x2665,
    0x2667, 0x2669, 0x266b, 0x266d, 0x266f, 0x2671, 0x2673, 0x2675,
    0x2677, 0x2679, 0x267b, 0x267d, 0x267f, 0x2681, 0x2683, 0x2685,
    0x2687, 0x2689, 0x268b, 0x268d, 0x268f, 0x2691, 0x2693, 0x2695,
    0x2697, 0x2699, 0x269b, 0x269d, 0x269f, 0x26a1, 0x26a3, 0x26a5,
    0x26a7, 0x26a9, 0x26ab, 0x26ad, 0x26af, 0x26b1, 0x26b3, 0x26b5,
    0x26b7, 0x26b9, 0x26bb, 0x26bd, 0x26bf, 0x26c1, 0x26c3, 0x26c5,
    0x26c7, 0x26c9, 0x26cb, 0x26cd, 0x26cf, 0x26d1, 0x26d3, 0x26d5,
    0x26d7, 0x26d9, 0x26db, 0x26dd, 0x26df, 0x26e1, 0x26e3, 0x26e5,
    0x26e7, 0x26e9, 0x26eb, 0x26ed, 0x26ef, 0x26f1, 0x26f3, 0x26f5,
    0x26f7, 0x26f9, 0x26fb, 0x26fd, 0x26ff, 0x2701, 0x2704, 0x2707,
    0x270a, 0x270d, 0x2710, 0x2713, 0x2716, 0xffff, 0xffff, 0xffff,

    0xffff, 0x2719, 0x271b, 0x271d, 0x271f, 0x2721, 0x2723, 0x2725,
    0x2727, 0x2729, 0x272b, 0x272d, 0x272f, 0x2731, 0x2733, 0x2735,
    0x2737, 0x2739, 0x273b, 0x273d, 0x273f, 0x2741, 0x2743, 0x2745,
    0x2747, 0x2749, 0x274b, 0x274d, 0x274f, 0x2751, 0x2753, 0x2755,
    0x2757, 0x2759, 0x275b, 0x275d, 0x275f, 0x2761, 0x2763, 0x2765,
    0x2767, 0x2769, 0x276b, 0x276d, 0x276f, 0x2771, 0x2773, 0x2775,
    0x2777, 0x2779, 0x277b, 0x277d, 0x277f, 0x2781, 0x2783, 0x2785,
    0x2787, 0x2789, 0x278b, 0x278d, 0x278f, 0x2791, 0x2793, 0x2795,
    0x2797, 0x2799, 0x279b, 0x279d, 0x279f, 0x27a1, 0x27a3, 0x27a5,
    0x27a7, 0x27a9, 0x27ab, 0x27ad, 0x27af, 0x27b1, 0x27b3, 0x27b5,
    0x27b7, 0x27b9, 0x27bb, 0x27bd, 0x27bf, 0x27c1, 0x27c3, 0x27c5,
    0x27c7, 0x27c9, 0x27cb, 0x27cd, 0x27cf, 0x27d1, 0x27d3, 0x27d5,
    0x27d7, 0x27d9, 0x27db, 0x27dd, 0x27df, 0x27e1, 0x27e3, 0x27e5,
    0x27e7, 0x27e9, 0x27eb, 0x27ed, 0x27ef, 0x27f1, 0x27f3, 0x27f5,
    0x27f7, 0x27f9, 0x27fb, 0x27fd, 0x27ff, 0x2801, 0x2803, 0x2805,
    0x2807, 0x2809, 0x280b, 0x280d, 0x280f, 0x2811, 0x2813, 0x2815,
    0x2817, 0x2819, 0x281b, 0x281d, 0x281f, 0x2821, 0x2823, 0x2825,
    0x2827, 0x2829, 0x282b, 0x282d, 0x282f, 0x2831, 0x2833, 0x2835,
    0x2837, 0x2839, 0x283b, 0x283d, 0x283f, 0x2841, 0x2843, 0x2845,
    0x2847, 0x2849, 0x284b, 0x284d, 0x284f, 0x2851, 0x2853, 0x2855,
    0x2857, 0x2859, 0x285b, 0x285d, 0x285f, 0x2861, 0x2863, 0x2865,
    0x2867, 0x2869, 0x286b, 0x286d, 0x286f, 0x2871, 0x2873, 0x2875,
    0x2877, 0x2879, 0x287b, 0x287d, 0x287f, 0x2881, 0x2883, 0x2885,
    0x2887, 0x2889, 0x288b, 0x288d, 0x288f, 0x2891, 0x2893, 0xffff,
    0xffff, 0xffff, 0x2895, 0x2897, 0x2899, 0x289b, 0x289d, 0x289f,
    0xffff, 0xffff, 0x28a1, 0x28a3, 0x28a5, 0x28a7, 0x28a9, 0x28ab,
    0xffff, 0xffff, 0x28ad, 0x28af, 0x28b1, 0x28b3, 0x28b5, 0x28b7,
    0xffff, 0xffff, 0x28b9, 0x28bb, 0x28bd, 0xffff, 0xffff, 0xffff,
    0x28bf, 0x28c1, 0x28c3, 0x28c5, 0x28c7, 0x28c9, 0x28cb, 0xffff,
    0x28cd, 0x28cf, 0x28d1, 0x28d3, 0x28d5, 0x28d7, 0x28d9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x28db, 0xffff, 0x28e0, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x28e5, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x28ea, 0x28ef,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x28f4, 0x28f9, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x28fe, 0x2903, 0xffff, 0x2908, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x290d, 0x2912, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2917, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x291c, 0x2921,
    0x2926, 0x292b, 0x2930, 0x2935, 0x293a, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x293f, 0x2944, 0x2949, 0x294e, 0x2953,
    0x2958, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x295d, 0x295f, 0x2961, 0x2963, 0x2965, 0x2967, 0x2969, 0x296b,
    0x296d, 0x296f, 0x2971, 0x2973, 0x2975, 0x2977, 0x2979, 0x297b,
    0x297d, 0x297f, 0x2981, 0x2983, 0x2985, 0x2987, 0x2989, 0x298b,
    0x298d, 0x298f, 0x2991, 0x2993, 0x2995, 0x2997, 0x2999, 0x299b,
    0x299d, 0x299f, 0x29a1, 0x29a3, 0x29a5, 0x29a7, 0x29a9, 0x29ab,
    0x29ad, 0x29af, 0x29b1, 0x29b3, 0x29b5, 0x29b7, 0x29b9, 0x29bb,
    0x29bd, 0x29bf, 0x29c1, 0x29c3, 0x29c5, 0x29c7, 0x29c9, 0x29cb,
    0x29cd, 0x29cf, 0x29d1, 0x29d3, 0x29d5, 0x29d7, 0x29d9, 0x29db,
    0x29dd, 0x29df, 0x29e1, 0x29e3, 0x29e5, 0x29e7, 0x29e9, 0x29eb,
    0x29ed, 0x29ef, 0x29f1, 0x29f3, 0x29f5, 0x29f7, 0x29f9, 0x29fb,
    0x29fd, 0x29ff, 0x2a01, 0x2a03, 0x2a05, 0xffff, 0x2a07, 0x2a09,
    0x2a0b, 0x2a0d, 0x2a0f, 0x2a11, 0x2a13, 0x2a15, 0x2a17, 0x2a19,
    0x2a1b, 0x2a1d, 0x2a1f, 0x2a21, 0x2a23, 0x2a25, 0x2a27, 0x2a29,
    0x2a2b, 0x2a2d, 0x2a2f, 0x2a31, 0x2a33, 0x2a35, 0x2a37, 0x2a39,
    0x2a3b, 0x2a3d, 0x2a3f, 0x2a41, 0x2a43, 0x2a45, 0x2a47, 0x2a49,
    0x2a4b, 0x2a4d, 0x2a4f, 0x2a51, 0x2a53, 0x2a55, 0x2a57, 0x2a59,
    0x2a5b, 0x2a5d, 0x2a5f, 0x2a61, 0x2a63, 0x2a65, 0x2a67, 0x2a69,
    0x2a6b, 0x2a6d, 0x2a6f, 0x2a71, 0x2a73, 0x2a75, 0x2a77, 0x2a79,
    0x2a7b, 0x2a7d, 0x2a7f, 0x2a81, 0x2a83, 0x2a85, 0x2a87, 0x2a89,
    0x2a8b, 0x2a8d, 0x2a8f, 0x2a91, 0x2a93, 0xffff, 0x2a95, 0x2a97,
    0xffff, 0xffff, 0x2a99, 0xffff, 0xffff, 0x2a9b, 0x2a9d, 0xffff,
    0xffff, 0x2a9f, 0x2aa1, 0x2aa3, 0x2aa5, 0xffff, 0x2aa7, 0x2aa9,
    0x2aab, 0x2aad, 0x2aaf, 0x2ab1, 0x2ab3, 0x2ab5, 0x2ab7, 0x2ab9,
    0x2abb, 0x2abd, 0xffff, 0x2abf, 0xffff, 0x2ac1, 0x2ac3, 0x2ac5,
    0x2ac7, 0x2ac9, 0x2acb, 0x2acd, 0xffff, 0x2acf, 0x2ad1, 0x2ad3,
    0x2ad5, 0x2ad7, 0x2ad9, 0x2adb, 0x2add, 0x2adf, 0x2ae1, 0x2ae3,
    0x2ae5, 0x2ae7, 0x2ae9, 0x2aeb, 0x2aed, 0x2aef, 0x2af1, 0x2af3,
    0x2af5, 0x2af7, 0x2af9, 0x2afb, 0x2afd, 0x2aff, 0x2b01, 0x2b03,
    0x2b05, 0x2b07, 0x2b09, 0x2b0b, 0x2b0d, 0x2b0f, 0x2b11, 0x2b13,
    0x2b15, 0x2b17, 0x2b19, 0x2b1b, 0x2b1d, 0x2b1f, 0x2b21, 0x2b23,
    0x2b25, 0x2b27, 0x2b29, 0x2b2b, 0x2b2d, 0x2b2f, 0x2b31, 0x2b33,
    0x2b35, 0x2b37, 0x2b39, 0x2b3b, 0x2b3d, 0x2b3f, 0x2b41, 0x2b43,

    0x2b45, 0x2b47, 0x2b49, 0x2b4b, 0x2b4d, 0x2b4f, 0xffff, 0x2b51,
    0x2b53, 0x2b55, 0x2b57, 0xffff, 0xffff, 0x2b59, 0x2b5b, 0x2b5d,
    0x2b5f, 0x2b61, 0x2b63, 0x2b65, 0x2b67, 0xffff, 0x2b69, 0x2b6b,
    0x2b6d, 0x2b6f, 0x2b71, 0x2b73, 0x2b75, 0xffff, 0x2b77, 0x2b79,
    0x2b7b, 0x2b7d, 0x2b7f, 0x2b81, 0x2b83, 0x2b85, 0x2b87, 0x2b89,
    0x2b8b, 0x2b8d, 0x2b8f, 0x2b91, 0x2b93, 0x2b95, 0x2b97, 0x2b99,
    0x2b9b, 0x2b9d, 0x2b9f, 0x2ba1, 0x2ba3, 0x2ba5, 0x2ba7, 0x2ba9,
    0x2bab, 0x2bad, 0xffff, 0x2baf, 0x2bb1, 0x2bb3, 0x2bb5, 0xffff,
    0x2bb7, 0x2bb9, 0x2bbb, 0x2bbd, 0x2bbf, 0xffff, 0x2bc1, 0xffff,
    0xffff, 0xffff, 0x2bc3, 0x2bc5, 0x2bc7, 0x2bc9, 0x2bcb, 0x2bcd,
    0x2bcf, 0xffff, 0x2bd1, 0x2bd3, 0x2bd5, 0x2bd7, 0x2bd9, 0x2bdb,
    0x2bdd, 0x2bdf, 0x2be1, 0x2be3, 0x2be5, 0x2be7, 0x2be9, 0x2beb,
    0x2bed, 0x2bef, 0x2bf1, 0x2bf3, 0x2bf5, 0x2bf7, 0x2bf9, 0x2bfb,
    0x2bfd, 0x2bff, 0x2c01, 0x2c03, 0x2c05, 0x2c07, 0x2c09, 0x2c0b,
    0x2c0d, 0x2c0f, 0x2c11, 0x2c13, 0x2c15, 0x2c17, 0x2c19, 0x2c1b,
    0x2c1d, 0x2c1f, 0x2c21, 0x2c23, 0x2c25, 0x2c27, 0x2c29, 0x2c2b,
    0x2c2d, 0x2c2f, 0x2c31, 0x2c33, 0x2c35, 0x2c37, 0x2c39, 0x2c3b,
    0x2c3d, 0x2c3f, 0x2c41, 0x2c43, 0x2c45, 0x2c47, 0x2c49, 0x2c4b,
    0x2c4d, 0x2c4f, 0x2c51, 0x2c53, 0x2c55, 0x2c57, 0x2c59, 0x2c5b,
    0x2c5d, 0x2c5f, 0x2c61, 0x2c63, 0x2c65, 0x2c67, 0x2c69, 0x2c6b,
    0x2c6d, 0x2c6f, 0x2c71, 0x2c73, 0x2c75, 0x2c77, 0x2c79, 0x2c7b,
    0x2c7d, 0x2c7f, 0x2c81, 0x2c83, 0x2c85, 0x2c87, 0x2c89, 0x2c8b,
    0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 0x2c95, 0x2c97, 0x2c99, 0x2c9b,
    0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 0x2ca5, 0x2ca7, 0x2ca9, 0x2cab,
    0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb,
    0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb,
    0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb,
    0x2cdd, 0x2cdf, 0x2ce1, 0x2ce3, 0x2ce5, 0x2ce7, 0x2ce9, 0x2ceb,
    0x2ced, 0x2cef, 0x2cf1, 0x2cf3, 0x2cf5, 0x2cf7, 0x2cf9, 0x2cfb,
    0x2cfd, 0x2cff, 0x2d01, 0x2d03, 0x2d05, 0x2d07, 0x2d09, 0x2d0b,
    0x2d0d, 0x2d0f, 0x2d11, 0x2d13, 0x2d15, 0x2d17, 0x2d19, 0x2d1b,
    0x2d1d, 0x2d1f, 0x2d21, 0x2d23, 0x2d25, 0x2d27, 0x2d29, 0x2d2b,

    0x2d2d, 0x2d2f, 0x2d31, 0x2d33, 0x2d35, 0x2d37, 0x2d39, 0x2d3b,
    0x2d3d, 0x2d3f, 0x2d41, 0x2d43, 0x2d45, 0x2d47, 0x2d49, 0x2d4b,
    0x2d4d, 0x2d4f, 0x2d51, 0x2d53, 0x2d55, 0x2d57, 0x2d59, 0x2d5b,
    0x2d5d, 0x2d5f, 0x2d61, 0x2d63, 0x2d65, 0x2d67, 0x2d69, 0x2d6b,
    0x2d6d, 0x2d6f, 0x2d71, 0x2d73, 0x2d75, 0x2d77, 0x2d79, 0x2d7b,
    0x2d7d, 0x2d7f, 0x2d81, 0x2d83, 0x2d85, 0x2d87, 0x2d89, 0x2d8b,
    0x2d8d, 0x2d8f, 0x2d91, 0x2d93, 0x2d95, 0x2d97, 0x2d99, 0x2d9b,
    0x2d9d, 0x2d9f, 0x2da1, 0x2da3, 0x2da5, 0x2da7, 0x2da9, 0x2dab,
    0x2dad, 0x2daf, 0x2db1, 0x2db3, 0x2db5, 0x2db7, 0x2db9, 0x2dbb,
    0x2dbd, 0x2dbf, 0x2dc1, 0x2dc3, 0x2dc5, 0x2dc7, 0x2dc9, 0x2dcb,
    0x2dcd, 0x2dcf, 0x2dd1, 0x2dd3, 0x2dd5, 0x2dd7, 0x2dd9, 0x2ddb,
    0x2ddd, 0x2ddf, 0x2de1, 0x2de3, 0x2de5, 0x2de7, 0x2de9, 0x2deb,
    0x2ded, 0x2def, 0x2df1, 0x2df3, 0x2df5, 0x2df7, 0x2df9, 0x2dfb,
    0x2dfd, 0x2dff, 0x2e01, 0x2e03, 0x2e05, 0x2e07, 0x2e09, 0x2e0b,
    0x2e0d, 0x2e0f, 0x2e11, 0x2e13, 0x2e15, 0x2e17, 0x2e19, 0x2e1b,
    0x2e1d, 0x2e1f, 0x2e21, 0x2e23, 0x2e25, 0x2e27, 0x2e29, 0x2e2b,
    0x2e2d, 0x2e2f, 0x2e31, 0x2e33, 0x2e35, 0x2e37, 0x2e39, 0x2e3b,
    0x2e3d, 0x2e3f, 0x2e41, 0x2e43, 0x2e45, 0x2e47, 0x2e49, 0x2e4b,
    0x2e4d, 0x2e4f, 0x2e51, 0x2e53, 0x2e55, 0x2e57, 0x2e59, 0x2e5b,
    0x2e5d, 0x2e5f, 0x2e61, 0x2e63, 0x2e65, 0x2e67, 0x2e69, 0x2e6b,
    0x2e6d, 0x2e6f, 0x2e71, 0x2e73, 0x2e75, 0x2e77, 0xffff, 0xffff,
    0x2e79, 0x2e7b, 0x2e7d, 0x2e7f, 0x2e81, 0x2e83, 0x2e85, 0x2e87,
    0x2e89, 0x2e8b, 0x2e8d, 0x2e8f, 0x2e91, 0x2e93, 0x2e95, 0x2e97,
    0x2e99, 0x2e9b, 0x2e9d, 0x2e9f, 0x2ea1, 0x2ea3, 0x2ea5, 0x2ea7,
    0x2ea9, 0x2eab, 0x2ead, 0x2eaf, 0x2eb1, 0x2eb3, 0x2eb5, 0x2eb7,
    0x2eb9, 0x2ebb, 0x2ebd, 0x2ebf, 0x2ec1, 0x2ec3, 0x2ec5, 0x2ec7,
    0x2ec9, 0x2ecb, 0x2ecd, 0x2ecf, 0x2ed1, 0x2ed3, 0x2ed5, 0x2ed7,
    0x2ed9, 0x2edb, 0x2edd, 0x2edf, 0x2ee1, 0x2ee3, 0x2ee5, 0x2ee7,
    0x2ee9, 0x2eeb, 0x2eed, 0x2eef, 0x2ef1, 0x2ef3, 0x2ef5, 0x2ef7,
    0x2ef9, 0x2efb, 0x2efd, 0x2eff, 0x2f01, 0x2f03, 0x2f05, 0x2f07,
    0x2f09, 0x2f0b, 0x2f0d, 0x2f0f, 0x2f11, 0x2f13, 0x2f15, 0x2f17,
    0x2f19, 0x2f1b, 0x2f1d, 0x2f1f, 0x2f21, 0x2f23, 0x2f25, 0x2f27,

    0x2f29, 0x2f2b, 0x2f2d, 0x2f2f, 0x2f31, 0x2f33, 0x2f35, 0x2f37,
    0x2f39, 0x2f3b, 0x2f3d, 0x2f3f, 0x2f41, 0x2f43, 0x2f45, 0x2f47,
    0x2f49, 0x2f4b, 0x2f4d, 0x2f4f, 0x2f51, 0x2f53, 0x2f55, 0x2f57,
    0x2f59, 0x2f5b, 0x2f5d, 0x2f5f, 0x2f61, 0x2f63, 0x2f65, 0x2f67,
    0x2f69, 0x2f6b, 0x2f6d, 0x2f6f, 0x2f71, 0x2f73, 0x2f75, 0x2f77,
    0x2f79, 0x2f7b, 0x2f7d, 0x2f7f, 0x2f81, 0x2f83, 0x2f85, 0x2f87,
    0x2f89, 0x2f8b, 0x2f8d, 0x2f8f, 0x2f91, 0x2f93, 0x2f95, 0x2f97,
    0x2f99, 0x2f9b, 0x2f9d, 0x2f9f, 0x2fa1, 0x2fa3, 0x2fa5, 0x2fa7,
    0x2fa9, 0x2fab, 0x2fad, 0x2faf, 0x2fb1, 0x2fb3, 0x2fb5, 0x2fb7,
    0x2fb9, 0x2fbb, 0x2fbd, 0x2fbf, 0x2fc1, 0x2fc3, 0x2fc5, 0x2fc7,
    0x2fc9, 0x2fcb, 0x2fcd, 0x2fcf, 0x2fd1, 0x2fd3, 0x2fd5, 0x2fd7,
    0x2fd9, 0x2fdb, 0x2fdd, 0x2fdf, 0x2fe1, 0x2fe3, 0x2fe5, 0x2fe7,
    0x2fe9, 0x2feb, 0x2fed, 0x2fef, 0x2ff1, 0x2ff3, 0x2ff5, 0x2ff7,
    0x2ff9, 0x2ffb, 0x2ffd, 0x2fff, 0x3001, 0x3003, 0x3005, 0x3007,
    0x3009, 0x300b, 0x300d, 0x300f, 0x3011, 0x3013, 0x3015, 0x3017,
    0x3019, 0x301b, 0x301d, 0x301f, 0x3021, 0x3023, 0x3025, 0x3027,
    0x3029, 0x302b, 0x302d, 0x302f, 0x3031, 0x3033, 0x3035, 0x3037,
    0x3039, 0x303b, 0x303d, 0x303f, 0x3041, 0x3043, 0x3045, 0x3047,
    0x3049, 0x304b, 0x304d, 0x304f, 0x3051, 0x3053, 0x3055, 0x3057,
    0x3059, 0x305b, 0x305d, 0x305f, 0x3061, 0x3063, 0x3065, 0x3067,
    0x3069, 0x306b, 0x306d, 0x306f, 0x3071, 0x3073, 0x3075, 0x3077,
    0x3079, 0x307b, 0x307d, 0x307f, 0x3081, 0x3083, 0x3085, 0x3087,
    0x3089, 0x308b, 0x308d, 0x308f, 0x3091, 0x3093, 0x3095, 0x3097,
    0x3099, 0x309b, 0x309d, 0x309f, 0x30a1, 0x30a3, 0x30a5, 0x30a7,
    0x30a9, 0x30ab, 0x30ad, 0x30af, 0x30b1, 0x30b3, 0x30b5, 0x30b7,
    0x30b9, 0x30bb, 0x30bd, 0x30bf, 0xffff, 0xffff, 0x30c1, 0x30c3,
    0x30c5, 0x30c7, 0x30c9, 0x30cb, 0x30cd, 0x30cf, 0x30d1, 0x30d3,
    0x30d5, 0x30d7, 0x30d9, 0x30db, 0x30dd, 0x30df, 0x30e1, 0x30e3,
    0x30e5, 0x30e7, 0x30e9, 0x30eb, 0x30ed, 0x30ef, 0x30f1, 0x30f3,
    0x30f5, 0x30f7, 0x30f9, 0x30fb, 0x30fd, 0x30ff, 0x3101, 0x3103,
    0x3105, 0x3107, 0x3109, 0x310b, 0x310d, 0x310f, 0x3111, 0x3113,
    0x3115, 0x3117, 0x3119, 0x311b, 0x311d, 0x311f, 0x3121, 0x3123,

    0x3125, 0x3127, 0x3129, 0x312b, 0xffff, 0x312d, 0x312f, 0x3131,
    0x3133, 0x3135, 0x3137, 0x3139, 0x313b, 0x313d, 0x313f, 0x3141,
    0x3143, 0x3145, 0x3147, 0x3149, 0x314b, 0x314d, 0x314f, 0x3151,
    0x3153, 0x3155, 0x3157, 0x3159, 0x315b, 0x315d, 0x315f, 0x3161,
    0xffff, 0x3163, 0x3165, 0xffff, 0x3167, 0xffff, 0xffff, 0x3169,
    0xffff, 0x316b, 0x316d, 0x316f, 0x3171, 0x3173, 0x3175, 0x3177,
    0x3179, 0x317b, 0x317d, 0xffff, 0x317f, 0x3181, 0x3183, 0x3185,
    0xffff, 0x3187, 0xffff, 0x3189, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x318b, 0xffff, 0xffff, 0xffff, 0xffff, 0x318d,
    0xffff, 0x318f, 0xffff, 0x3191, 0xffff, 0x3193, 0x3195, 0x3197,
    0xffff, 0x3199, 0x319b, 0xffff, 0x319d, 0xffff, 0xffff, 0x319f,
    0xffff, 0x31a1, 0xffff, 0x31a3, 0xffff, 0x31a5, 0xffff, 0x31a7,
    0xffff, 0x31a9, 0x31ab, 0xffff, 0x31ad, 0xffff, 0xffff, 0x31af,
    0x31b1, 0x31b3, 0x31b5, 0xffff, 0x31b7, 0x31b9, 0x31bb, 0x31bd,
    0x31bf, 0x31c1, 0x31c3, 0xffff, 0x31c5, 0x31c7, 0x31c9, 0x31cb,
    0xffff, 0x31cd, 0x31cf, 0x31d1, 0x31d3, 0xffff, 0x31d5, 0xffff,
    0x31d7, 0x31d9, 0x31db, 0x31dd, 0x31df, 0x31e1, 0x31e3, 0x31e5,
    0x31e7, 0x31e9, 0xffff, 0x31eb, 0x31ed, 0x31ef, 0x31f1, 0x31f3,
    0x31f5, 0x31f7, 0x31f9, 0x31fb, 0x31fd, 0x31ff, 0x3201, 0x3203,
    0x3205, 0x3207, 0x3209, 0x320b, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x320d, 0x320f, 0x3211, 0xffff, 0x3213, 0x3215, 0x3217,
    0x3219, 0x321b, 0xffff, 0x321d, 0x321f, 0x3221, 0x3223, 0x3225,
    0x3227, 0x3229, 0x322b, 0x322d, 0x322f, 0x3231, 0x3233, 0x3235,
    0x3237, 0x3239, 0x323b, 0x323d, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x323f, 0x3242, 0x3245, 0x3248, 0x324b, 0x324e, 0x3251, 0x3254,
    0x3257, 0x325a, 0x325d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3260, 0x3264, 0x3268, 0x326c, 0x3270, 0x3274, 0x3278, 0x327c,
    0x3280, 0x3284, 0x3288, 0x328c, 0x3290, 0x3294, 0x3298, 0x329c,
    0x32a0, 0x32a4, 0x32a8, 0x32ac, 0x32b0, 0x32b4, 0x32b8, 0x32bc,
    0x32c0, 0x32c4, 0x32c8, 0x32cc, 0x32ce, 0x32d0, 0x32d3, 0xffff,
    0x32d6, 0x32d8, 0x32da, 0x32dc, 0x32de, 0x32e0, 0x32e2, 0x32e4,
    0x32e6, 0x32e8, 0x32ea, 0x32ec, 0x32ee, 0x32f0, 0x32f2, 0x32f4,
    0x32f6, 0x32f8, 0x32fa, 0x32fc, 0x32fe, 0x3300, 0x3302, 0x3304,
    0x3306, 0x3308, 0x330a, 0x330d, 0x3310, 0x3313, 0x3316, 0x331a,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x331d, 0x3320, 0x3323, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3326, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3329, 0x332c, 0x332f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3331, 0x3333, 0x3335, 0x3337, 0x3339, 0x333b, 0x333d, 0x333f,
    0x3341, 0x3343, 0x3345, 0x3347, 0x3349, 0x334b, 0x334d, 0x334f,
    0x3351, 0x3353, 0x3355, 0x3357, 0x3359, 0x335b, 0x335d, 0x335f,
    0x3361, 0x3363, 0x3365, 0x3367, 0x3369, 0x336b, 0x336d, 0x336f,
    0x3371, 0x3373, 0x3375, 0x3377, 0x3379, 0x337b, 0x337d, 0x337f,
    0x3381, 0x3383, 0x3385, 0x3387, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3389, 0x338d, 0x3391, 0x3395, 0x3399, 0x339d, 0x33a1, 0x33a5,
    0x33a9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x33ad, 0x33af, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x33b1, 0x33b3, 0x33b5, 0x33b7, 0x33b9, 0x33bb, 0x33bd, 0x33bf,
    0x33c1, 0x33c3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x33c5, 0x33c7, 0x33c9, 0x33cb, 0x33ce, 0x33d0, 0x33d2, 0x33d4,
    0x33d6, 0x33d8, 0x33da, 0x33dc, 0x33de, 0x33e0, 0x33e3, 0x33e5,
    0x33e7, 0x33e9, 0x33eb, 0x33ee, 0x33f0, 0x33f2, 0x33f4, 0x33f7,
    0x33f9, 0x33fb, 0x33fd, 0x33ff, 0x3401, 0x3404, 0x3406, 0x3408,
    0x340a, 0x340c, 0x340e, 0x3410, 0x3412, 0x3414, 0x3416, 0x3418,
    0x341a, 0x341c, 0x341e, 0x3420, 0x3422, 0x3424, 0x3426, 0x3428,
    0x342a, 0x342c, 0x342e, 0x3430, 0x3432, 0x3435, 0x3437, 0x3439,
    0x343b, 0x343e, 0x3440, 0x3442, 0x3444, 0x3446, 0x3448, 0x344a,
    0x344c, 0x344e, 0x3450, 0x3452, 0x3454, 0x3456, 0x3458, 0x345a,
    0x345c, 0x345e, 0x3460, 0x3462, 0x3464, 0x3466, 0x3468, 0x346a,
    0x346c, 0x346e, 0x3470, 0x3472, 0x3474, 0x3476, 0x3478, 0x347a,
    0x347c, 0x347e, 0x3481, 0x3483, 0x3485, 0x3487, 0x3489, 0x348b,
    0x348d, 0x3490, 0x3493, 0x3495, 0x3497, 0x3499, 0x349b, 0x349d,
    0x349f, 0x34a1, 0x34a3, 0x34a5, 0x34a7, 0x34aa, 0x34ac, 0x34ae,
    0x34b0, 0x34b2, 0x34b5, 0x34b7, 0x34b9, 0x34bb, 0x34bd, 0x34bf,
    0x34c1, 0x34c3, 0x34c5, 0x34c7, 0x34ca, 0x34cc, 0x34cf, 0x34d1,
    0x34d3, 0x34d5, 0x34d7, 0x34d9, 0x34db, 0x34dd, 0x34df, 0x34e1,
    0x34e3, 0x34e5, 0x34e8, 0x34ea, 0x34ec, 0x34ee, 0x34f0, 0x34f2,
    0x34f5, 0x34f7, 0x34fa, 0x34fd, 0x34ff, 0x3501, 0x3503, 0x3505,
    0x3508, 0x350b, 0x350d, 0x350f, 0x3511, 0x3513, 0x3515, 0x3517,
    0x3519, 0x351b, 0x351d, 0x351f, 0x3521, 0x3524, 0x3526, 0x3528,
    0x352a, 0x352c, 0x352e, 0x3530, 0x3532, 0x3534, 0x3536, 0x3538,
    0x353a, 0x353c, 0x353e, 0x3540, 0x3542, 0x3544, 0x3546, 0x3548,
    0x354a, 0x354d, 0x354f, 0x3551, 0x3553, 0x3555, 0x3557, 0x355a,
    0x355c, 0x355e, 0x3560, 0x3562, 0x3564, 0x3566, 0x3568, 0x356a,
    0x356c, 0x356e, 0x3570, 0x3573, 0x3575, 0x3577, 0x3579, 0x357b,
    0x357d, 0x357f, 0x3581, 0x3583, 0x3585, 0x3587, 0x3589, 0x358b,
    0x358d, 0x358f, 0x3591, 0x3593, 0x3595, 0x3597, 0x359a, 0x359c,
    0x359e, 0x35a0, 0x35a2, 0x35a4, 0x35a7, 0x35a9, 0x35ab, 0x35ad,
    0x35af, 0x35b1, 0x35b3, 0x35b5, 0x35b7, 0x35ba, 0x35bc, 0x35be,
    0x35c0, 0x35c3, 0x35c5, 0x35c7, 0x35c9, 0x35cb, 0x35cd, 0x35cf,
    0x35d2, 0x35d5, 0x35d8, 0x35da, 0x35dd, 0x35df, 0x35e1, 0x35e3,

    0x35e5, 0x35e7, 0x35e9, 0x35eb, 0x35ed, 0x35ef, 0x35f1, 0x35f4,
    0x35f6, 0x35f8, 0x35fa, 0x35fc, 0x35fe, 0x3600, 0x3603, 0x3605,
    0x3607, 0x360a, 0x360d, 0x360f, 0x3611, 0x3613, 0x3615, 0x3617,
    0x3619, 0x361b, 0x361d, 0x361f, 0x3622, 0x3624, 0x3627, 0x3629,
    0x362c, 0x362e, 0x3630, 0x3632, 0x3635, 0x3637, 0x3639, 0x363c,
    0x363f, 0x3641, 0x3643, 0x3645, 0x3647, 0x3649, 0x364b, 0x364d,
    0x364f, 0x3651, 0x3653, 0x3655, 0x3657, 0x3659, 0x365c, 0x365e,
    0x3661, 0x3663, 0x3666, 0x3668, 0x366b, 0x366e, 0x3671, 0x3673,
    0x3675, 0x3677, 0x367a, 0x367d, 0x3680, 0x3683, 0x3685, 0x3687,
    0x3689, 0x368b, 0x368d, 0x368f, 0x3691, 0x3693, 0x3696, 0x3698,
    0x369a, 0x369c, 0x369e, 0x36a1, 0x36a3, 0x36a6, 0x36a9, 0x36ab,
    0x36ad, 0x36af, 0x36b1, 0x36b3, 0x36b5, 0x36b8, 0x36bb, 0x36be,
    0x36c0, 0x36c2, 0x36c5, 0x36c7, 0x36c9, 0x36cb, 0x36ce, 0x36d0,
    0x36d2, 0x36d4, 0x36d6, 0x36d8, 0x36db, 0x36dd, 0x36df, 0x36e1,
    0x36e3, 0x36e5, 0x36e7, 0x36ea, 0x36ed, 0x36ef, 0x36f2, 0x36f4,
    0x36f7, 0x36f9, 0x36fb, 0x36fd, 0x3700, 0x3703, 0x3705, 0x3708,
    0x370a, 0x370d, 0x370f, 0x3711, 0x3713, 0x3715, 0x3717, 0x3719,
    0x371c, 0x371f, 0x3722, 0x3725, 0x3727, 0x3729, 0x372b, 0x372d,
    0x372f, 0x3731, 0x3733, 0x3735, 0x3737, 0x3739, 0x373b, 0x373d,
    0x3740, 0x3742, 0x3744, 0x3746, 0x3748, 0x374a, 0x374c, 0x374e,
    0x3750, 0x3752, 0x3754, 0x3756, 0x3758, 0x375b, 0x375e, 0x3761,
    0x3763, 0x3765, 0x3767, 0x3769, 0x376c, 0x376e, 0x3771, 0x3773,
    0x3775, 0x3778, 0x377b, 0x377d, 0x377f, 0x3781, 0x3783, 0x3785,
    0x3787, 0x3789, 0x378b, 0x378d, 0x378f, 0x3791, 0x3793, 0x3795,
    0x3797, 0x3799, 0x379b, 0x379d, 0x379f, 0x37a1, 0x37a4, 0x37a6,
    0x37a8, 0x37aa, 0x37ac, 0x37ae, 0x37b1, 0x37b4, 0x37b6, 0x37b8,
    0x37ba, 0x37bc, 0x37be, 0x37c0, 0x37c3, 0x37c5, 0x37c7, 0x37c9,
    0x37cb, 0x37ce, 0x37d1, 0x37d3, 0x37d5, 0x37d7, 0x37da, 0x37dc,
    0x37de, 0x37e1, 0x37e4, 0x37e6, 0x37e8, 0x37ea, 0x37ed, 0x37ef,
    0x37f1, 0x37f3, 0x37f5, 0x37f7, 0x37f9, 0x37fb, 0x37fe, 0x3800,
    0x3802, 0x3804, 0x3807, 0x3809, 0x380b, 0x380d, 0x380f, 0x3812,
    0x3815, 0x3817, 0x3819, 0x381b, 0x381e, 0x3820, 0x3823, 0x3825,

    0x3827, 0x3829, 0x382c, 0x382e, 0x3830, 0x3832, 0x3834, 0x3836,
    0x3838, 0x383a, 0x383d, 0x383f, 0x3841, 0x3843, 0x3845, 0x3847,
    0x3849, 0x384c, 0x384e, 0x3851, 0x3854, 0x3857, 0x3859, 0x385b,
    0x385d, 0x385f, 0x3861, 0x3863, 0x3865, 0x3867, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

#define GET_DECOMPOSITION_INDEX(ucs4) \
       (ucs4 < 0x3400 \
        ? (uc_decomposition_trie[uc_decomposition_trie[ucs4>>4] + (ucs4 & 0xf)]) \
        : (ucs4 < 0x30000 \
           ? uc_decomposition_trie[uc_decomposition_trie[((ucs4 - 0x3400)>>8) + 0x340] + (ucs4 & 0xff)] \
           : 0xffff))

static const unsigned short uc_decomposition_map[] = {
    0x103, 0x20, 0x210, 0x20, 0x308, 0x109, 0x61, 0x210,
    0x20, 0x304, 0x109, 0x32, 0x109, 0x33, 0x210, 0x20,
    0x301, 0x110, 0x3bc, 0x210, 0x20, 0x327, 0x109, 0x31,
    0x109, 0x6f, 0x311, 0x31, 0x2044, 0x34, 0x311, 0x31,
    0x2044, 0x32, 0x311, 0x33, 0x2044, 0x34, 0x201, 0x41,
    0x300, 0x201, 0x41, 0x301, 0x201, 0x41, 0x302, 0x201,
    0x41, 0x303, 0x201, 0x41, 0x308, 0x201, 0x41, 0x30a,
    0x201, 0x43, 0x327, 0x201, 0x45, 0x300, 0x201, 0x45,
    0x301, 0x201, 0x45, 0x302, 0x201, 0x45, 0x308, 0x201,
    0x49, 0x300, 0x201, 0x49, 0x301, 0x201, 0x49, 0x302,
    0x201, 0x49, 0x308, 0x201, 0x4e, 0x303, 0x201, 0x4f,
    0x300, 0x201, 0x4f, 0x301, 0x201, 0x4f, 0x302, 0x201,
    0x4f, 0x303, 0x201, 0x4f, 0x308, 0x201, 0x55, 0x300,
    0x201, 0x55, 0x301, 0x201, 0x55, 0x302, 0x201, 0x55,
    0x308, 0x201, 0x59, 0x301, 0x201, 0x61, 0x300, 0x201,
    0x61, 0x301, 0x201, 0x61, 0x302, 0x201, 0x61, 0x303,
    0x201, 0x61, 0x308, 0x201, 0x61, 0x30a, 0x201, 0x63,
    0x327, 0x201, 0x65, 0x300, 0x201, 0x65, 0x301, 0x201,
    0x65, 0x302, 0x201, 0x65, 0x308, 0x201, 0x69, 0x300,
    0x201, 0x69, 0x301, 0x201, 0x69, 0x302, 0x201, 0x69,
    0x308, 0x201, 0x6e, 0x303, 0x201, 0x6f, 0x300, 0x201,
    0x6f, 0x301, 0x201, 0x6f, 0x302, 0x201, 0x6f, 0x303,
    0x201, 0x6f, 0x308, 0x201, 0x75, 0x300, 0x201, 0x75,
    0x301, 0x201, 0x75, 0x302, 0x201, 0x75, 0x308, 0x201,
    0x79, 0x301, 0x201, 0x79, 0x308, 0x201, 0x41, 0x304,
    0x201, 0x61, 0x304, 0x201, 0x41, 0x306, 0x201, 0x61,
    0x306, 0x201, 0x41, 0x328, 0x201, 0x61, 0x328, 0x201,
    0x43, 0x301, 0x201, 0x63, 0x301, 0x201, 0x43, 0x302,
    0x201, 0x63, 0x302, 0x201, 0x43, 0x307, 0x201, 0x63,
    0x307, 0x201, 0x43, 0x30c, 0x201, 0x63, 0x30c, 0x201,
    0x44, 0x30c, 0x201, 0x64, 0x30c, 0x201, 0x45, 0x304,
    0x201, 0x65, 0x304, 0x201, 0x45, 0x306, 0x201, 0x65,
    0x306, 0x201, 0x45, 0x307, 0x201, 0x65, 0x307, 0x201,
    0x45, 0x328, 0x201, 0x65, 0x328, 0x201, 0x45, 0x30c,
    0x201, 0x65, 0x30c, 0x201, 0x47, 0x302, 0x201, 0x67,
    0x302, 0x201, 0x47, 0x306, 0x201, 0x67, 0x306, 0x201,
    0x47, 0x307, 0x201, 0x67, 0x307, 0x201, 0x47, 0x327,
    0x201, 0x67, 0x327, 0x201, 0x48, 0x302, 0x201, 0x68,
    0x302, 0x201, 0x49, 0x303, 0x201, 0x69, 0x303, 0x201,
    0x49, 0x304, 0x201, 0x69, 0x304, 0x201, 0x49, 0x306,
    0x201, 0x69, 0x306, 0x201, 0x49, 0x328, 0x201, 0x69,
    0x328, 0x201, 0x49, 0x307, 0x210, 0x49, 0x4a, 0x210,
    0x69, 0x6a, 0x201, 0x4a, 0x302, 0x201, 0x6a, 0x302,
    0x201, 0x4b, 0x327, 0x201, 0x6b, 0x327, 0x201, 0x4c,
    0x301, 0x201, 0x6c, 0x301, 0x201, 0x4c, 0x327, 0x201,
    0x6c, 0x327, 0x201, 0x4c, 0x30c, 0x201, 0x6c, 0x30c,
    0x210, 0x4c, 0xb7, 0x210, 0x6c, 0xb7, 0x201, 0x4e,
    0x301, 0x201, 0x6e, 0x301, 0x201, 0x4e, 0x327, 0x201,
    0x6e, 0x327, 0x201, 0x4e, 0x30c, 0x201, 0x6e, 0x30c,
    0x210, 0x2bc, 0x6e, 0x201, 0x4f, 0x304, 0x201, 0x6f,
    0x304, 0x201, 0x4f, 0x306, 0x201, 0x6f, 0x306, 0x201,
    0x4f, 0x30b, 0x201, 0x6f, 0x30b, 0x201, 0x52, 0x301,
    0x201, 0x72, 0x301, 0x201, 0x52, 0x327, 0x201, 0x72,
    0x327, 0x201, 0x52, 0x30c, 0x201, 0x72, 0x30c, 0x201,
    0x53, 0x301, 0x201, 0x73, 0x301, 0x201, 0x53, 0x302,
    0x201, 0x73, 0x302, 0x201, 0x53, 0x327, 0x201, 0x73,
    0x327, 0x201, 0x53, 0x30c, 0x201, 0x73, 0x30c, 0x201,
    0x54, 0x327, 0x201, 0x74, 0x327, 0x201, 0x54, 0x30c,
    0x201, 0x74, 0x30c, 0x201, 0x55, 0x303, 0x201, 0x75,
    0x303, 0x201, 0x55, 0x304, 0x201, 0x75, 0x304, 0x201,
    0x55, 0x306, 0x201, 0x75, 0x306, 0x201, 0x55, 0x30a,
    0x201, 0x75, 0x30a, 0x201, 0x55, 0x30b, 0x201, 0x75,
    0x30b, 0x201, 0x55, 0x328, 0x201, 0x75, 0x328, 0x201,
    0x57, 0x302, 0x201, 0x77, 0x302, 0x201, 0x59, 0x302,
    0x201, 0x79, 0x302, 0x201, 0x59, 0x308, 0x201, 0x5a,
    0x301, 0x201, 0x7a, 0x301, 0x201, 0x5a, 0x307, 0x201,
    0x7a, 0x307, 0x201, 0x5a, 0x30c, 0x201, 0x7a, 0x30c,
    0x110, 0x73, 0x201, 0x4f, 0x31b, 0x201, 0x6f, 0x31b,
    0x201, 0x55, 0x31b, 0x201, 0x75, 0x31b, 0x210, 0x44,
    0x17d, 0x210, 0x44, 0x17e, 0x210, 0x64, 0x17e, 0x210,
    0x4c, 0x4a, 0x210, 0x4c, 0x6a, 0x210, 0x6c, 0x6a,
    0x210, 0x4e, 0x4a, 0x210, 0x4e, 0x6a, 0x210, 0x6e,
    0x6a, 0x201, 0x41, 0x30c, 0x201, 0x61, 0x30c, 0x201,
    0x49, 0x30c, 0x201, 0x69, 0x30c, 0x201, 0x4f, 0x30c,
    0x201, 0x6f, 0x30c, 0x201, 0x55, 0x30c, 0x201, 0x75,
    0x30c, 0x201, 0xdc, 0x304, 0x201, 0xfc, 0x304, 0x201,
    0xdc, 0x301, 0x201, 0xfc, 0x301, 0x201, 0xdc, 0x30c,
    0x201, 0xfc, 0x30c, 0x201, 0xdc, 0x300, 0x201, 0xfc,
    0x300, 0x201, 0xc4, 0x304, 0x201, 0xe4, 0x304, 0x201,
    0x226, 0x304, 0x201, 0x227, 0x304, 0x201, 0xc6, 0x304,
    0x201, 0xe6, 0x304, 0x201, 0x47, 0x30c, 0x201, 0x67,
    0x30c, 0x201, 0x4b, 0x30c, 0x201, 0x6b, 0x30c, 0x201,
    0x4f, 0x328, 0x201, 0x6f, 0x328, 0x201, 0x1ea, 0x304,
    0x201, 0x1eb, 0x304, 0x201, 0x1b7, 0x30c, 0x201, 0x292,
    0x30c, 0x201, 0x6a, 0x30c, 0x210, 0x44, 0x5a, 0x210,
    0x44, 0x7a, 0x210, 0x64, 0x7a, 0x201, 0x47, 0x301,
    0x201, 0x67, 0x301, 0x201, 0x4e, 0x300, 0x201, 0x6e,
    0x300, 0x201, 0xc5, 0x301, 0x201, 0xe5, 0x301, 0x201,
    0xc6, 0x301, 0x201, 0xe6, 0x301, 0x201, 0xd8, 0x301,
    0x201, 0xf8, 0x301, 0x201, 0x41, 0x30f, 0x201, 0x61,
    0x30f, 0x201, 0x41, 0x311, 0x201, 0x61, 0x311, 0x201,
    0x45, 0x30f, 0x201, 0x65, 0x30f, 0x201, 0x45, 0x311,
    0x201, 0x65, 0x311, 0x201, 0x49, 0x30f, 0x201, 0x69,
    0x30f, 0x201, 0x49, 0x311, 0x201, 0x69, 0x311, 0x201,
    0x4f, 0x30f, 0x201, 0x6f, 0x30f, 0x201, 0x4f, 0x311,
    0x201, 0x6f, 0x311, 0x201, 0x52, 0x30f, 0x201, 0x72,
    0x30f, 0x201, 0x52, 0x311, 0x201, 0x72, 0x311, 0x201,
    0x55, 0x30f, 0x201, 0x75, 0x30f, 0x201, 0x55, 0x311,
    0x201, 0x75, 0x311, 0x201, 0x53, 0x326, 0x201, 0x73,
    0x326, 0x201, 0x54, 0x326, 0x201, 0x74, 0x326, 0x201,
    0x48, 0x30c, 0x201, 0x68, 0x30c, 0x201, 0x41, 0x307,
    0x201, 0x61, 0x307, 0x201, 0x45, 0x327, 0x201, 0x65,
    0x327, 0x201, 0xd6, 0x304, 0x201, 0xf6, 0x304, 0x201,
    0xd5, 0x304, 0x201, 0xf5, 0x304, 0x201, 0x4f, 0x307,
    0x201, 0x6f, 0x307, 0x201, 0x22e, 0x304, 0x201, 0x22f,
    0x304, 0x201, 0x59, 0x304, 0x201, 0x79, 0x304, 0x109,
    0x68, 0x109, 0x266, 0x109, 0x6a, 0x109, 0x72, 0x109,
    0x279, 0x109, 0x27b, 0x109, 0x281, 0x109, 0x77, 0x109,
    0x79, 0x210, 0x20, 0x306, 0x210, 0x20, 0x307, 0x210,
    0x20, 0x30a, 0x210, 0x20, 0x328, 0x210, 0x20, 0x303,
    0x210, 0x20, 0x30b, 0x109, 0x263, 0x109, 0x6c, 0x109,
    0x73, 0x109, 0x78, 0x109, 0x295, 0x101, 0x300, 0x101,
    0x301, 0x101, 0x313, 0x201, 0x308, 0x301, 0x101, 0x2b9,
    0x210, 0x20, 0x345, 0x101, 0x3b, 0x210, 0x20, 0x301,
    0x201, 0xa8, 0x301, 0x201, 0x391, 0x301, 0x101, 0xb7,
    0x201, 0x395, 0x301, 0x201, 0x397, 0x301, 0x201, 0x399,
    0x301, 0x201, 0x39f, 0x301, 0x201, 0x3a5, 0x301, 0x201,
    0x3a9, 0x301, 0x201, 0x3ca, 0x301, 0x201, 0x399, 0x308,
    0x201, 0x3a5, 0x308, 0x201, 0x3b1, 0x301, 0x201, 0x3b5,
    0x301, 0x201, 0x3b7, 0x301, 0x201, 0x3b9, 0x301, 0x201,
    0x3cb, 0x301, 0x201, 0x3b9, 0x308, 0x201, 0x3c5, 0x308,
    0x201, 0x3bf, 0x301, 0x201, 0x3c5, 0x301, 0x201, 0x3c9,
    0x301, 0x110, 0x3b2, 0x110, 0x3b8, 0x110, 0x3a5, 0x201,
    0x3d2, 0x301, 0x201, 0x3d2, 0x308, 0x110, 0x3c6, 0x110,
    0x3c0, 0x110, 0x3ba, 0x110, 0x3c1, 0x110, 0x3c2, 0x110,
    0x398, 0x110, 0x3b5, 0x110, 0x3a3, 0x201, 0x415, 0x300,
    0x201, 0x415, 0x308, 0x201, 0x413, 0x301, 0x201, 0x406,
    0x308, 0x201, 0x41a, 0x301, 0x201, 0x418, 0x300, 0x201,
    0x423, 0x306, 0x201, 0x418, 0x306, 0x201, 0x438, 0x306,
    0x201, 0x435, 0x300, 0x201, 0x435, 0x308, 0x201, 0x433,
    0x301, 0x201, 0x456, 0x308, 0x201, 0x43a, 0x301, 0x201,
    0x438, 0x300, 0x201, 0x443, 0x306, 0x201, 0x474, 0x30f,
    0x201, 0x475, 0x30f, 0x201, 0x416, 0x306, 0x201, 0x436,
    0x306, 0x201, 0x410, 0x306, 0x201, 0x430, 0x306, 0x201,
    0x410, 0x308, 0x201, 0x430, 0x308, 0x201, 0x415, 0x306,
    0x201, 0x435, 0x306, 0x201, 0x4d8, 0x308, 0x201, 0x4d9,
    0x308, 0x201, 0x416, 0x308, 0x201, 0x436, 0x308, 0x201,
    0x417, 0x308, 0x201, 0x437, 0x308, 0x201, 0x418, 0x304,
    0x201, 0x438, 0x304, 0x201, 0x418, 0x308, 0x201, 0x438,
    0x308, 0x201, 0x41e, 0x308, 0x201, 0x43e, 0x308, 0x201,
    0x4e8, 0x308, 0x201, 0x4e9, 0x308, 0x201, 0x42d, 0x308,
    0x201, 0x44d, 0x308, 0x201, 0x423, 0x304, 0x201, 0x443,
    0x304, 0x201, 0x423, 0x308, 0x201, 0x443, 0x308, 0x201,
    0x423, 0x30b, 0x201, 0x443, 0x30b, 0x201, 0x427, 0x308,
    0x201, 0x447, 0x308, 0x201, 0x42b, 0x308, 0x201, 0x44b,
    0x308, 0x210, 0x565, 0x582, 0x201, 0x627, 0x653, 0x201,
    0x627, 0x654, 0x201, 0x648, 0x654, 0x201, 0x627, 0x655,
    0x201, 0x64a, 0x654, 0x210, 0x627, 0x674, 0x210, 0x648,
    0x674, 0x210, 0x6c7, 0x674, 0x210, 0x64a, 0x674, 0x201,
    0x6d5, 0x654, 0x201, 0x6c1, 0x654, 0x201, 0x6d2, 0x654,
    0x201, 0x928, 0x93c, 0x201, 0x930, 0x93c, 0x201, 0x933,
    0x93c, 0x201, 0x915, 0x93c, 0x201, 0x916, 0x93c, 0x201,
    0x917, 0x93c, 0x201, 0x91c, 0x93c, 0x201, 0x921, 0x93c,
    0x201, 0x922, 0x93c, 0x201, 0x92b, 0x93c, 0x201, 0x92f,
    0x93c, 0x201, 0x9c7, 0x9be, 0x201, 0x9c7, 0x9d7, 0x201,
    0x9a1, 0x9bc, 0x201, 0x9a2, 0x9bc, 0x201, 0x9af, 0x9bc,
    0x201, 0xa32, 0xa3c, 0x201, 0xa38, 0xa3c, 0x201, 0xa16,
    0xa3c, 0x201, 0xa17, 0xa3c, 0x201, 0xa1c, 0xa3c, 0x201,
    0xa2b, 0xa3c, 0x201, 0xb47, 0xb56, 0x201, 0xb47, 0xb3e,
    0x201, 0xb47, 0xb57, 0x201, 0xb21, 0xb3c, 0x201, 0xb22,
    0xb3c, 0x201, 0xb92, 0xbd7, 0x201, 0xbc6, 0xbbe, 0x201,
    0xbc7, 0xbbe, 0x201, 0xbc6, 0xbd7, 0x201, 0xc46, 0xc56,
    0x201, 0xcbf, 0xcd5, 0x201, 0xcc6, 0xcd5, 0x201, 0xcc6,
    0xcd6, 0x201, 0xcc6, 0xcc2, 0x201, 0xcca, 0xcd5, 0x201,
    0xd46, 0xd3e, 0x201, 0xd47, 0xd3e, 0x201, 0xd46, 0xd57,
    0x201, 0xdd9, 0xdca, 0x201, 0xdd9, 0xdcf, 0x201, 0xddc,
    0xdca, 0x201, 0xdd9, 0xddf, 0x210, 0xe4d, 0xe32, 0x210,
    0xecd, 0xeb2, 0x210, 0xeab, 0xe99, 0x210, 0xeab, 0xea1,
    0x103, 0xf0b, 0x201, 0xf42, 0xfb7, 0x201, 0xf4c, 0xfb7,
    0x201, 0xf51, 0xfb7, 0x201, 0xf56, 0xfb7, 0x201, 0xf5b,
    0xfb7, 0x201, 0xf40, 0xfb5, 0x201, 0xf71, 0xf72, 0x201,
    0xf71, 0xf74, 0x201, 0xfb2, 0xf80, 0x210, 0xfb2, 0xf81,
    0x201, 0xfb3, 0xf80, 0x210, 0xfb3, 0xf81, 0x201, 0xf71,
    0xf80, 0x201, 0xf92, 0xfb7, 0x201, 0xf9c, 0xfb7, 0x201,
    0xfa1, 0xfb7, 0x201, 0xfa6, 0xfb7, 0x201, 0xfab, 0xfb7,
    0x201, 0xf90, 0xfb5, 0x201, 0x1025, 0x102e, 0x109, 0x10dc,
    0x201, 0x1b05, 0x1b35, 0x201, 0x1b07, 0x1b35, 0x201, 0x1b09,
    0x1b35, 0x201, 0x1b0b, 0x1b35, 0x201, 0x1b0d, 0x1b35, 0x201,
    0x1b11, 0x1b35, 0x201, 0x1b3a, 0x1b35, 0x201, 0x1b3c, 0x1b35,
    0x201, 0x1b3e, 0x1b35, 0x201, 0x1b3f, 0x1b35, 0x201, 0x1b42,
    0x1b35, 0x109, 0x41, 0x109, 0xc6, 0x109, 0x42, 0x109,
    0x44, 0x109, 0x45, 0x109, 0x18e, 0x109, 0x47, 0x109,
    0x48, 0x109, 0x49, 0x109, 0x4a, 0x109, 0x4b, 0x109,
    0x4c, 0x109, 0x4d, 0x109, 0x4e, 0x109, 0x4f, 0x109,
    0x222, 0x109, 0x50, 0x109, 0x52, 0x109, 0x54, 0x109,
    0x55, 0x109, 0x57, 0x109, 0x61, 0x109, 0x250, 0x109,
    0x251, 0x109, 0x1d02, 0x109, 0x62, 0x109, 0x64, 0x109,
    0x65, 0x109, 0x259, 0x109, 0x25b, 0x109, 0x25c, 0x109,
    0x67, 0x109, 0x6b, 0x109, 0x6d, 0x109, 0x14b, 0x109,
    0x6f, 0x109, 0x254, 0x109, 0x1d16, 0x109, 0x1d17, 0x109,
    0x70, 0x109, 0x74, 0x109, 0x75, 0x109, 0x1d1d, 0x109,
    0x26f, 0x109, 0x76, 0x109, 0x1d25, 0x109, 0x3b2, 0x109,
    0x3b3, 0x109, 0x3b4, 0x109, 0x3c6, 0x109, 0x3c7, 0x10a,
    0x69, 0x10a, 0x72, 0x10a, 0x75, 0x10a, 0x76, 0x10a,
    0x3b2, 0x10a, 0x3b3, 0x10a, 0x3c1, 0x10a, 0x3c6, 0x10a,
    0x3c7, 0x109, 0x43d, 0x109, 0x252, 0x109, 0x63, 0x109,
    0x255, 0x109, 0xf0, 0x109, 0x25c, 0x109, 0x66, 0x109,
    0x25f, 0x109, 0x261, 0x109, 0x265, 0x109, 0x268, 0x109,
    0x269, 0x109, 0x26a, 0x109, 0x1d7b, 0x109, 0x29d, 0x109,
    0x26d, 0x109, 0x1d85, 0x109, 0x29f, 0x109, 0x271, 0x109,
    0x270, 0x109, 0x272, 0x109, 0x273, 0x109, 0x274, 0x109,
    0x275, 0x109, 0x278, 0x109, 0x282, 0x109, 0x283, 0x109,
    0x1ab, 0x109, 0x289, 0x109, 0x28a, 0x109, 0x1d1c, 0x109,
    0x28b, 0x109, 0x28c, 0x109, 0x7a, 0x109, 0x290, 0x109,
    0x291, 0x109, 0x292, 0x109, 0x3b8, 0x201, 0x41, 0x325,
    0x201, 0x61, 0x325, 0x201, 0x42, 0x307, 0x201, 0x62,
    0x307, 0x201, 0x42, 0x323, 0x201, 0x62, 0x323, 0x201,
    0x42, 0x331, 0x201, 0x62, 0x331, 0x201, 0xc7, 0x301,
    0x201, 0xe7, 0x301, 0x201, 0x44, 0x307, 0x201, 0x64,
    0x307, 0x201, 0x44, 0x323, 0x201, 0x64, 0x323, 0x201,
    0x44, 0x331, 0x201, 0x64, 0x331, 0x201, 0x44, 0x327,
    0x201, 0x64, 0x327, 0x201, 0x44, 0x32d, 0x201, 0x64,
    0x32d, 0x201, 0x112, 0x300, 0x201, 0x113, 0x300, 0x201,
    0x112, 0x301, 0x201, 0x113, 0x301, 0x201, 0x45, 0x32d,
    0x201, 0x65, 0x32d, 0x201, 0x45, 0x330, 0x201, 0x65,
    0x330, 0x201, 0x228, 0x306, 0x201, 0x229, 0x306, 0x201,
    0x46, 0x307, 0x201, 0x66, 0x307, 0x201, 0x47, 0x304,
    0x201, 0x67, 0x304, 0x201, 0x48, 0x307, 0x201, 0x68,
    0x307, 0x201, 0x48, 0x323, 0x201, 0x68, 0x323, 0x201,
    0x48, 0x308, 0x201, 0x68, 0x308, 0x201, 0x48, 0x327,
    0x201, 0x68, 0x327, 0x201, 0x48, 0x32e, 0x201, 0x68,
    0x32e, 0x201, 0x49, 0x330, 0x201, 0x69, 0x330, 0x201,
    0xcf, 0x301, 0x201, 0xef, 0x301, 0x201, 0x4b, 0x301,
    0x201, 0x6b, 0x301, 0x201, 0x4b, 0x323, 0x201, 0x6b,
    0x323, 0x201, 0x4b, 0x331, 0x201, 0x6b, 0x331, 0x201,
    0x4c, 0x323, 0x201, 0x6c, 0x323, 0x201, 0x1e36, 0x304,
    0x201, 0x1e37, 0x304, 0x201, 0x4c, 0x331, 0x201, 0x6c,
    0x331, 0x201, 0x4c, 0x32d, 0x201, 0x6c, 0x32d, 0x201,
    0x4d, 0x301, 0x201, 0x6d, 0x301, 0x201, 0x4d, 0x307,
    0x201, 0x6d, 0x307, 0x201, 0x4d, 0x323, 0x201, 0x6d,
    0x323, 0x201, 0x4e, 0x307, 0x201, 0x6e, 0x307, 0x201,
    0x4e, 0x323, 0x201, 0x6e, 0x323, 0x201, 0x4e, 0x331,
    0x201, 0x6e, 0x331, 0x201, 0x4e, 0x32d, 0x201, 0x6e,
    0x32d, 0x201, 0xd5, 0x301, 0x201, 0xf5, 0x301, 0x201,
    0xd5, 0x308, 0x201, 0xf5, 0x308, 0x201, 0x14c, 0x300,
    0x201, 0x14d, 0x300, 0x201, 0x14c, 0x301, 0x201, 0x14d,
    0x301, 0x201, 0x50, 0x301, 0x201, 0x70, 0x301, 0x201,
    0x50, 0x307, 0x201, 0x70, 0x307, 0x201, 0x52, 0x307,
    0x201, 0x72, 0x307, 0x201, 0x52, 0x323, 0x201, 0x72,
    0x323, 0x201, 0x1e5a, 0x304, 0x201, 0x1e5b, 0x304, 0x201,
    0x52, 0x331, 0x201, 0x72, 0x331, 0x201, 0x53, 0x307,
    0x201, 0x73, 0x307, 0x201, 0x53, 0x323, 0x201, 0x73,
    0x323, 0x201, 0x15a, 0x307, 0x201, 0x15b, 0x307, 0x201,
    0x160, 0x307, 0x201, 0x161, 0x307, 0x201, 0x1e62, 0x307,
    0x201, 0x1e63, 0x307, 0x201, 0x54, 0x307, 0x201, 0x74,
    0x307, 0x201, 0x54, 0x323, 0x201, 0x74, 0x323, 0x201,
    0x54, 0x331, 0x201, 0x74, 0x331, 0x201, 0x54, 0x32d,
    0x201, 0x74, 0x32d, 0x201, 0x55, 0x324, 0x201, 0x75,
    0x324, 0x201, 0x55, 0x330, 0x201, 0x75, 0x330, 0x201,
    0x55, 0x32d, 0x201, 0x75, 0x32d, 0x201, 0x168, 0x301,
    0x201, 0x169, 0x301, 0x201, 0x16a, 0x308, 0x201, 0x16b,
    0x308, 0x201, 0x56, 0x303, 0x201, 0x76, 0x303, 0x201,
    0x56, 0x323, 0x201, 0x76, 0x323, 0x201, 0x57, 0x300,
    0x201, 0x77, 0x300, 0x201, 0x57, 0x301, 0x201, 0x77,
    0x301, 0x201, 0x57, 0x308, 0x201, 0x77, 0x308, 0x201,
    0x57, 0x307, 0x201, 0x77, 0x307, 0x201, 0x57, 0x323,
    0x201, 0x77, 0x323, 0x201, 0x58, 0x307, 0x201, 0x78,
    0x307, 0x201, 0x58, 0x308, 0x201, 0x78, 0x308, 0x201,
    0x59, 0x307, 0x201, 0x79, 0x307, 0x201, 0x5a, 0x302,
    0x201, 0x7a, 0x302, 0x201, 0x5a, 0x323, 0x201, 0x7a,
    0x323, 0x201, 0x5a, 0x331, 0x201, 0x7a, 0x331, 0x201,
    0x68, 0x331, 0x201, 0x74, 0x308, 0x201, 0x77, 0x30a,
    0x201, 0x79, 0x30a, 0x210, 0x61, 0x2be, 0x201, 0x17f,
    0x307, 0x201, 0x41, 0x323, 0x201, 0x61, 0x323, 0x201,
    0x41, 0x309, 0x201, 0x61, 0x309, 0x201, 0xc2, 0x301,
    0x201, 0xe2, 0x301, 0x201, 0xc2, 0x300, 0x201, 0xe2,
    0x300, 0x201, 0xc2, 0x309, 0x201, 0xe2, 0x309, 0x201,
    0xc2, 0x303, 0x201, 0xe2, 0x303, 0x201, 0x1ea0, 0x302,
    0x201, 0x1ea1, 0x302, 0x201, 0x102, 0x301, 0x201, 0x103,
    0x301, 0x201, 0x102, 0x300, 0x201, 0x103, 0x300, 0x201,
    0x102, 0x309, 0x201, 0x103, 0x309, 0x201, 0x102, 0x303,
    0x201, 0x103, 0x303, 0x201, 0x1ea0, 0x306, 0x201, 0x1ea1,
    0x306, 0x201, 0x45, 0x323, 0x201, 0x65, 0x323, 0x201,
    0x45, 0x309, 0x201, 0x65, 0x309, 0x201, 0x45, 0x303,
    0x201, 0x65, 0x303, 0x201, 0xca, 0x301, 0x201, 0xea,
    0x301, 0x201, 0xca, 0x300, 0x201, 0xea, 0x300, 0x201,
    0xca, 0x309, 0x201, 0xea, 0x309, 0x201, 0xca, 0x303,
    0x201, 0xea, 0x303, 0x201, 0x1eb8, 0x302, 0x201, 0x1eb9,
    0x302, 0x201, 0x49, 0x309, 0x201, 0x69, 0x309, 0x201,
    0x49, 0x323, 0x201, 0x69, 0x323, 0x201, 0x4f, 0x323,
    0x201, 0x6f, 0x323, 0x201, 0x4f, 0x309, 0x201, 0x6f,
    0x309, 0x201, 0xd4, 0x301, 0x201, 0xf4, 0x301, 0x201,
    0xd4, 0x300, 0x201, 0xf4, 0x300, 0x201, 0xd4, 0x309,
    0x201, 0xf4, 0x309, 0x201, 0xd4, 0x303, 0x201, 0xf4,
    0x303, 0x201, 0x1ecc, 0x302, 0x201, 0x1ecd, 0x302, 0x201,
    0x1a0, 0x301, 0x201, 0x1a1, 0x301, 0x201, 0x1a0, 0x300,
    0x201, 0x1a1, 0x300, 0x201, 0x1a0, 0x309, 0x201, 0x1a1,
    0x309, 0x201, 0x1a0, 0x303, 0x201, 0x1a1, 0x303, 0x201,
    0x1a0, 0x323, 0x201, 0x1a1, 0x323, 0x201, 0x55, 0x323,
    0x201, 0x75, 0x323, 0x201, 0x55, 0x309, 0x201, 0x75,
    0x309, 0x201, 0x1af, 0x301, 0x201, 0x1b0, 0x301, 0x201,
    0x1af, 0x300, 0x201, 0x1b0, 0x300, 0x201, 0x1af, 0x309,
    0x201, 0x1b0, 0x309, 0x201, 0x1af, 0x303, 0x201, 0x1b0,
    0x303, 0x201, 0x1af, 0x323, 0x201, 0x1b0, 0x323, 0x201,
    0x59, 0x300, 0x201, 0x79, 0x300, 0x201, 0x59, 0x323,
    0x201, 0x79, 0x323, 0x201, 0x59, 0x309, 0x201, 0x79,
    0x309, 0x201, 0x59, 0x303, 0x201, 0x79, 0x303, 0x201,
    0x3b1, 0x313, 0x201, 0x3b1, 0x314, 0x201, 0x1f00, 0x300,
    0x201, 0x1f01, 0x300, 0x201, 0x1f00, 0x301, 0x201, 0x1f01,
    0x301, 0x201, 0x1f00, 0x342, 0x201, 0x1f01, 0x342, 0x201,
    0x391, 0x313, 0x201, 0x391, 0x314, 0x201, 0x1f08, 0x300,
    0x201, 0x1f09, 0x300, 0x201, 0x1f08, 0x301, 0x201, 0x1f09,
    0x301, 0x201, 0x1f08, 0x342, 0x201, 0x1f09, 0x342, 0x201,
    0x3b5, 0x313, 0x201, 0x3b5, 0x314, 0x201, 0x1f10, 0x300,
    0x201, 0x1f11, 0x300, 0x201, 0x1f10, 0x301, 0x201, 0x1f11,
    0x301, 0x201, 0x395, 0x313, 0x201, 0x395, 0x314, 0x201,
    0x1f18, 0x300, 0x201, 0x1f19, 0x300, 0x201, 0x1f18, 0x301,
    0x201, 0x1f19, 0x301, 0x201, 0x3b7, 0x313, 0x201, 0x3b7,
    0x314, 0x201, 0x1f20, 0x300, 0x201, 0x1f21, 0x300, 0x201,
    0x1f20, 0x301, 0x201, 0x1f21, 0x301, 0x201, 0x1f20, 0x342,
    0x201, 0x1f21, 0x342, 0x201, 0x397, 0x313, 0x201, 0x397,
    0x314, 0x201, 0x1f28, 0x300, 0x201, 0x1f29, 0x300, 0x201,
    0x1f28, 0x301, 0x201, 0x1f29, 0x301, 0x201, 0x1f28, 0x342,
    0x201, 0x1f29, 0x342, 0x201, 0x3b9, 0x313, 0x201, 0x3b9,
    0x314, 0x201, 0x1f30, 0x300, 0x201, 0x1f31, 0x300, 0x201,
    0x1f30, 0x301, 0x201, 0x1f31, 0x301, 0x201, 0x1f30, 0x342,
    0x201, 0x1f31, 0x342, 0x201, 0x399, 0x313, 0x201, 0x399,
    0x314, 0x201, 0x1f38, 0x300, 0x201, 0x1f39, 0x300, 0x201,
    0x1f38, 0x301, 0x201, 0x1f39, 0x301, 0x201, 0x1f38, 0x342,
    0x201, 0x1f39, 0x342, 0x201, 0x3bf, 0x313, 0x201, 0x3bf,
    0x314, 0x201, 0x1f40, 0x300, 0x201, 0x1f41, 0x300, 0x201,
    0x1f40, 0x301, 0x201, 0x1f41, 0x301, 0x201, 0x39f, 0x313,
    0x201, 0x39f, 0x314, 0x201, 0x1f48, 0x300, 0x201, 0x1f49,
    0x300, 0x201, 0x1f48, 0x301, 0x201, 0x1f49, 0x301, 0x201,
    0x3c5, 0x313, 0x201, 0x3c5, 0x314, 0x201, 0x1f50, 0x300,
    0x201, 0x1f51, 0x300, 0x201, 0x1f50, 0x301, 0x201, 0x1f51,
    0x301, 0x201, 0x1f50, 0x342, 0x201, 0x1f51, 0x342, 0x201,
    0x3a5, 0x314, 0x201, 0x1f59, 0x300, 0x201, 0x1f59, 0x301,
    0x201, 0x1f59, 0x342, 0x201, 0x3c9, 0x313, 0x201, 0x3c9,
    0x314, 0x201, 0x1f60, 0x300, 0x201, 0x1f61, 0x300, 0x201,
    0x1f60, 0x301, 0x201, 0x1f61, 0x301, 0x201, 0x1f60, 0x342,
    0x201, 0x1f61, 0x342, 0x201, 0x3a9, 0x313, 0x201, 0x3a9,
    0x314, 0x201, 0x1f68, 0x300, 0x201, 0x1f69, 0x300, 0x201,
    0x1f68, 0x301, 0x201, 0x1f69, 0x301, 0x201, 0x1f68, 0x342,
    0x201, 0x1f69, 0x342, 0x201, 0x3b1, 0x300, 0x101, 0x3ac,
    0x201, 0x3b5, 0x300, 0x101, 0x3ad, 0x201, 0x3b7, 0x300,
    0x101, 0x3ae, 0x201, 0x3b9, 0x300, 0x101, 0x3af, 0x201,
    0x3bf, 0x300, 0x101, 0x3cc, 0x201, 0x3c5, 0x300, 0x101,
    0x3cd, 0x201, 0x3c9, 0x300, 0x101, 0x3ce, 0x201, 0x1f00,
    0x345, 0x201, 0x1f01, 0x345, 0x201, 0x1f02, 0x345, 0x201,
    0x1f03, 0x345, 0x201, 0x1f04, 0x345, 0x201, 0x1f05, 0x345,
    0x201, 0x1f06, 0x345, 0x201, 0x1f07, 0x345, 0x201, 0x1f08,
    0x345, 0x201, 0x1f09, 0x345, 0x201, 0x1f0a, 0x345, 0x201,
    0x1f0b, 0x345, 0x201, 0x1f0c, 0x345, 0x201, 0x1f0d, 0x345,
    0x201, 0x1f0e, 0x345, 0x201, 0x1f0f, 0x345, 0x201, 0x1f20,
    0x345, 0x201, 0x1f21, 0x345, 0x201, 0x1f22, 0x345, 0x201,
    0x1f23, 0x345, 0x201, 0x1f24, 0x345, 0x201, 0x1f25, 0x345,
    0x201, 0x1f26, 0x345, 0x201, 0x1f27, 0x345, 0x201, 0x1f28,
    0x345, 0x201, 0x1f29, 0x345, 0x201, 0x1f2a, 0x345, 0x201,
    0x1f2b, 0x345, 0x201, 0x1f2c, 0x345, 0x201, 0x1f2d, 0x345,
    0x201, 0x1f2e, 0x345, 0x201, 0x1f2f, 0x345, 0x201, 0x1f60,
    0x345, 0x201, 0x1f61, 0x345, 0x201, 0x1f62, 0x345, 0x201,
    0x1f63, 0x345, 0x201, 0x1f64, 0x345, 0x201, 0x1f65, 0x345,
    0x201, 0x1f66, 0x345, 0x201, 0x1f67, 0x345, 0x201, 0x1f68,
    0x345, 0x201, 0x1f69, 0x345, 0x201, 0x1f6a, 0x345, 0x201,
    0x1f6b, 0x345, 0x201, 0x1f6c, 0x345, 0x201, 0x1f6d, 0x345,
    0x201, 0x1f6e, 0x345, 0x201, 0x1f6f, 0x345, 0x201, 0x3b1,
    0x306, 0x201, 0x3b1, 0x304, 0x201, 0x1f70, 0x345, 0x201,
    0x3b1, 0x345, 0x201, 0x3ac, 0x345, 0x201, 0x3b1, 0x342,
    0x201, 0x1fb6, 0x345, 0x201, 0x391, 0x306, 0x201, 0x391,
    0x304, 0x201, 0x391, 0x300, 0x101, 0x386, 0x201, 0x391,
    0x345, 0x210, 0x20, 0x313, 0x101, 0x3b9, 0x210, 0x20,
    0x313, 0x210, 0x20, 0x342, 0x201, 0xa8, 0x342, 0x201,
    0x1f74, 0x345, 0x201, 0x3b7, 0x345, 0x201, 0x3ae, 0x345,
    0x201, 0x3b7, 0x342, 0x201, 0x1fc6, 0x345, 0x201, 0x395,
    0x300, 0x101, 0x388, 0x201, 0x397, 0x300, 0x101, 0x389,
    0x201, 0x397, 0x345, 0x201, 0x1fbf, 0x300, 0x201, 0x1fbf,
    0x301, 0x201, 0x1fbf, 0x342, 0x201, 0x3b9, 0x306, 0x201,
    0x3b9, 0x304, 0x201, 0x3ca, 0x300, 0x101, 0x390, 0x201,
    0x3b9, 0x342, 0x201, 0x3ca, 0x342, 0x201, 0x399, 0x306,
    0x201, 0x399, 0x304, 0x201, 0x399, 0x300, 0x101, 0x38a,
    0x201, 0x1ffe, 0x300, 0x201, 0x1ffe, 0x301, 0x201, 0x1ffe,
    0x342, 0x201, 0x3c5, 0x306, 0x201, 0x3c5, 0x304, 0x201,
    0x3cb, 0x300, 0x101, 0x3b0, 0x201, 0x3c1, 0x313, 0x201,
    0x3c1, 0x314, 0x201, 0x3c5, 0x342, 0x201, 0x3cb, 0x342,
    0x201, 0x3a5, 0x306, 0x201, 0x3a5, 0x304, 0x201, 0x3a5,
    0x300, 0x101, 0x38e, 0x201, 0x3a1, 0x314, 0x201, 0xa8,
    0x300, 0x101, 0x385, 0x101, 0x60, 0x201, 0x1f7c, 0x345,
    0x201, 0x3c9, 0x345, 0x201, 0x3ce, 0x345, 0x201, 0x3c9,
    0x342, 0x201, 0x1ff6, 0x345, 0x201, 0x39f, 0x300, 0x101,
    0x38c, 0x201, 0x3a9, 0x300, 0x101, 0x38f, 0x201, 0x3a9,
    0x345, 0x101, 0xb4, 0x210, 0x20, 0x314, 0x101, 0x2002,
    0x101, 0x2003, 0x110, 0x20, 0x110, 0x20, 0x110, 0x20,
    0x110, 0x20, 0x110, 0x20, 0x103, 0x20, 0x110, 0x20,
    0x110, 0x20, 0x110, 0x20, 0x103, 0x2010, 0x210, 0x20,
    0x333, 0x110, 0x2e, 0x210, 0x2e, 0x2e, 0x310, 0x2e,
    0x2e, 0x2e, 0x103, 0x20, 0x210, 0x2032, 0x2032, 0x310,
    0x2032, 0x2032, 0x2032, 0x210, 0x2035, 0x2035, 0x310, 0x2035,
    0x2035, 0x2035, 0x210, 0x21, 0x21, 0x210, 0x20, 0x305,
    0x210, 0x3f, 0x3f, 0x210, 0x3f, 0x21, 0x210, 0x21,
    0x3f, 0x410, 0x2032, 0x2032, 0x2032, 0x2032, 0x110, 0x20,
    0x109, 0x30, 0x109, 0x69, 0x109, 0x34, 0x109, 0x35,
    0x109, 0x36, 0x109, 0x37, 0x109, 0x38, 0x109, 0x39,
    0x109, 0x2b, 0x109, 0x2212, 0x109, 0x3d, 0x109, 0x28,
    0x109, 0x29, 0x109, 0x6e, 0x10a, 0x30, 0x10a, 0x31,
    0x10a, 0x32, 0x10a, 0x33, 0x10a, 0x34, 0x10a, 0x35,
    0x10a, 0x36, 0x10a, 0x37, 0x10a, 0x38, 0x10a, 0x39,
    0x10a, 0x2b, 0x10a, 0x2212, 0x10a, 0x3d, 0x10a, 0x28,
    0x10a, 0x29, 0x10a, 0x61, 0x10a, 0x65, 0x10a, 0x6f,
    0x10a, 0x78, 0x10a, 0x259, 0x10a, 0x68, 0x10a, 0x6b,
    0x10a, 0x6c, 0x10a, 0x6d, 0x10a, 0x6e, 0x10a, 0x70,
    0x10a, 0x73, 0x10a, 0x74, 0x210, 0x52, 0x73, 0x310,
    0x61, 0x2f, 0x63, 0x310, 0x61, 0x2f, 0x73, 0x102,
    0x43, 0x210, 0xb0, 0x43, 0x310, 0x63, 0x2f, 0x6f,
    0x310, 0x63, 0x2f, 0x75, 0x110, 0x190, 0x210, 0xb0,
    0x46, 0x102, 0x67, 0x102, 0x48, 0x102, 0x48, 0x102,
    0x48, 0x102, 0x68, 0x102, 0x127, 0x102, 0x49, 0x102,
    0x49, 0x102, 0x4c, 0x102, 0x6c, 0x102, 0x4e, 0x210,
    0x4e, 0x6f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52,
    0x102, 0x52, 0x102, 0x52, 0x209, 0x53, 0x4d, 0x310,
    0x54, 0x45, 0x4c, 0x209, 0x54, 0x4d, 0x102, 0x5a,
    0x101, 0x3a9, 0x102, 0x5a, 0x101, 0x4b, 0x101, 0xc5,
    0x102, 0x42, 0x102, 0x43, 0x102, 0x65, 0x102, 0x45,
    0x102, 0x46, 0x102, 0x4d, 0x102, 0x6f, 0x110, 0x5d0,
    0x110, 0x5d1, 0x110, 0x5d2, 0x110, 0x5d3, 0x102, 0x69,
    0x310, 0x46, 0x41, 0x58, 0x102, 0x3c0, 0x102, 0x3b3,
    0x102, 0x393, 0x102, 0x3a0, 0x102, 0x2211, 0x102, 0x44,
    0x102, 0x64, 0x102, 0x65, 0x102, 0x69, 0x102, 0x6a,
    0x311, 0x31, 0x2044, 0x37, 0x311, 0x31, 0x2044, 0x39,
    0x411, 0x31, 0x2044, 0x31, 0x30, 0x311, 0x31, 0x2044,
    0x33, 0x311, 0x32, 0x2044, 0x33, 0x311, 0x31, 0x2044,
    0x35, 0x311, 0x32, 0x2044, 0x35, 0x311, 0x33, 0x2044,
    0x35, 0x311, 0x34, 0x2044, 0x35, 0x311, 0x31, 0x2044,
    0x36, 0x311, 0x35, 0x2044, 0x36, 0x311, 0x31, 0x2044,
    0x38, 0x311, 0x33, 0x2044, 0x38, 0x311, 0x35, 0x2044,
    0x38, 0x311, 0x37, 0x2044, 0x38, 0x211, 0x31, 0x2044,
    0x110, 0x49, 0x210, 0x49, 0x49, 0x310, 0x49, 0x49,
    0x49, 0x210, 0x49, 0x56, 0x110, 0x56, 0x210, 0x56,
    0x49, 0x310, 0x56, 0x49, 0x49, 0x410, 0x56, 0x49,
    0x49, 0x49, 0x210, 0x49, 0x58, 0x110, 0x58, 0x210,
    0x58, 0x49, 0x310, 0x58, 0x49, 0x49, 0x110, 0x4c,
    0x110, 0x43, 0x110, 0x44, 0x110, 0x4d, 0x110, 0x69,
    0x210, 0x69, 0x69, 0x310, 0x69, 0x69, 0x69, 0x210,
    0x69, 0x76, 0x110, 0x76, 0x210, 0x76, 0x69, 0x310,
    0x76, 0x69, 0x69, 0x410, 0x76, 0x69, 0x69, 0x69,
    0x210, 0x69, 0x78, 0x110, 0x78, 0x210, 0x78, 0x69,
    0x310, 0x78, 0x69, 0x69, 0x110, 0x6c, 0x110, 0x63,
    0x110, 0x64, 0x110, 0x6d, 0x311, 0x30, 0x2044, 0x33,
    0x201, 0x2190, 0x338, 0x201, 0x2192, 0x338, 0x201, 0x2194,
    0x338, 0x201, 0x21d0, 0x338, 0x201, 0x21d4, 0x338, 0x201,
    0x21d2, 0x338, 0x201, 0x2203, 0x338, 0x201, 0x2208, 0x338,
    0x201, 0x220b, 0x338, 0x201, 0x2223, 0x338, 0x201, 0x2225,
    0x338, 0x210, 0x222b, 0x222b, 0x310, 0x222b, 0x222b, 0x222b,
    0x210, 0x222e, 0x222e, 0x310, 0x222e, 0x222e, 0x222e, 0x201,
    0x223c, 0x338, 0x201, 0x2243, 0x338, 0x201, 0x2245, 0x338,
    0x201, 0x2248, 0x338, 0x201, 0x3d, 0x338, 0x201, 0x2261,
    0x338, 0x201, 0x224d, 0x338, 0x201, 0x3c, 0x338, 0x201,
    0x3e, 0x338, 0x201, 0x2264, 0x338, 0x201, 0x2265, 0x338,
    0x201, 0x2272, 0x338, 0x201, 0x2273, 0x338, 0x201, 0x2276,
    0x338, 0x201, 0x2277, 0x338, 0x201, 0x227a, 0x338, 0x201,
    0x227b, 0x338, 0x201, 0x2282, 0x338, 0x201, 0x2283, 0x338,
    0x201, 0x2286, 0x338, 0x201, 0x2287, 0x338, 0x201, 0x22a2,
    0x338, 0x201, 0x22a8, 0x338, 0x201, 0x22a9, 0x338, 0x201,
    0x22ab, 0x338, 0x201, 0x227c, 0x338, 0x201, 0x227d, 0x338,
    0x201, 0x2291, 0x338, 0x201, 0x2292, 0x338, 0x201, 0x22b2,
    0x338, 0x201, 0x22b3, 0x338, 0x201, 0x22b4, 0x338, 0x201,
    0x22b5, 0x338, 0x101, 0x3008, 0x101, 0x3009, 0x108, 0x31,
    0x108, 0x32, 0x108, 0x33, 0x108, 0x34, 0x108, 0x35,
    0x108, 0x36, 0x108, 0x37, 0x108, 0x38, 0x108, 0x39,
    0x208, 0x31, 0x30, 0x208, 0x31, 0x31, 0x208, 0x31,
    0x32, 0x208, 0x31, 0x33, 0x208, 0x31, 0x34, 0x208,
    0x31, 0x35, 0x208, 0x31, 0x36, 0x208, 0x31, 0x37,
    0x208, 0x31, 0x38, 0x208, 0x31, 0x39, 0x208, 0x32,
    0x30, 0x310, 0x28, 0x31, 0x29, 0x310, 0x28, 0x32,
    0x29, 0x310, 0x28, 0x33, 0x29, 0x310, 0x28, 0x34,
    0x29, 0x310, 0x28, 0x35, 0x29, 0x310, 0x28, 0x36,
    0x29, 0x310, 0x28, 0x37, 0x29, 0x310, 0x28, 0x38,
    0x29, 0x310, 0x28, 0x39, 0x29, 0x410, 0x28, 0x31,
    0x30, 0x29, 0x410, 0x28, 0x31, 0x31, 0x29, 0x410,
    0x28, 0x31, 0x32, 0x29, 0x410, 0x28, 0x31, 0x33,
    0x29, 0x410, 0x28, 0x31, 0x34, 0x29, 0x410, 0x28,
    0x31, 0x35, 0x29, 0x410, 0x28, 0x31, 0x36, 0x29,
    0x410, 0x28, 0x31, 0x37, 0x29, 0x410, 0x28, 0x31,
    0x38, 0x29, 0x410, 0x28, 0x31, 0x39, 0x29, 0x410,
    0x28, 0x32, 0x30, 0x29, 0x210, 0x31, 0x2e, 0x210,
    0x32, 0x2e, 0x210, 0x33, 0x2e, 0x210, 0x34, 0x2e,
    0x210, 0x35, 0x2e, 0x210, 0x36, 0x2e, 0x210, 0x37,
    0x2e, 0x210, 0x38, 0x2e, 0x210, 0x39, 0x2e, 0x310,
    0x31, 0x30, 0x2e, 0x310, 0x31, 0x31, 0x2e, 0x310,
    0x31, 0x32, 0x2e, 0x310, 0x31, 0x33, 0x2e, 0x310,
    0x31, 0x34, 0x2e, 0x310, 0x31, 0x35, 0x2e, 0x310,
    0x31, 0x36, 0x2e, 0x310, 0x31, 0x37, 0x2e, 0x310,
    0x31, 0x38, 0x2e, 0x310, 0x31, 0x39, 0x2e, 0x310,
    0x32, 0x30, 0x2e, 0x310, 0x28, 0x61, 0x29, 0x310,
    0x28, 0x62, 0x29, 0x310, 0x28, 0x63, 0x29, 0x310,
    0x28, 0x64, 0x29, 0x310, 0x28, 0x65, 0x29, 0x310,
    0x28, 0x66, 0x29, 0x310, 0x28, 0x67, 0x29, 0x310,
    0x28, 0x68, 0x29, 0x310, 0x28, 0x69, 0x29, 0x310,
    0x28, 0x6a, 0x29, 0x310, 0x28, 0x6b, 0x29, 0x310,
    0x28, 0x6c, 0x29, 0x310, 0x28, 0x6d, 0x29, 0x310,
    0x28, 0x6e, 0x29, 0x310, 0x28, 0x6f, 0x29, 0x310,
    0x28, 0x70, 0x29, 0x310, 0x28, 0x71, 0x29, 0x310,
    0x28, 0x72, 0x29, 0x310, 0x28, 0x73, 0x29, 0x310,
    0x28, 0x74, 0x29, 0x310, 0x28, 0x75, 0x29, 0x310,
    0x28, 0x76, 0x29, 0x310, 0x28, 0x77, 0x29, 0x310,
    0x28, 0x78, 0x29, 0x310, 0x28, 0x79, 0x29, 0x310,
    0x28, 0x7a, 0x29, 0x108, 0x41, 0x108, 0x42, 0x108,
    0x43, 0x108, 0x44, 0x108, 0x45, 0x108, 0x46, 0x108,
    0x47, 0x108, 0x48, 0x108, 0x49, 0x108, 0x4a, 0x108,
    0x4b, 0x108, 0x4c, 0x108, 0x4d, 0x108, 0x4e, 0x108,
    0x4f, 0x108, 0x50, 0x108, 0x51, 0x108, 0x52, 0x108,
    0x53, 0x108, 0x54, 0x108, 0x55, 0x108, 0x56, 0x108,
    0x57, 0x108, 0x58, 0x108, 0x59, 0x108, 0x5a, 0x108,
    0x61, 0x108, 0x62, 0x108, 0x63, 0x108, 0x64, 0x108,
    0x65, 0x108, 0x66, 0x108, 0x67, 0x108, 0x68, 0x108,
    0x69, 0x108, 0x6a, 0x108, 0x6b, 0x108, 0x6c, 0x108,
    0x6d, 0x108, 0x6e, 0x108, 0x6f, 0x108, 0x70, 0x108,
    0x71, 0x108, 0x72, 0x108, 0x73, 0x108, 0x74, 0x108,
    0x75, 0x108, 0x76, 0x108, 0x77, 0x108, 0x78, 0x108,
    0x79, 0x108, 0x7a, 0x108, 0x30, 0x410, 0x222b, 0x222b,
    0x222b, 0x222b, 0x310, 0x3a, 0x3a, 0x3d, 0x210, 0x3d,
    0x3d, 0x310, 0x3d, 0x3d, 0x3d, 0x201, 0x2add, 0x338,
    0x10a, 0x6a, 0x109, 0x56, 0x109, 0x2d61, 0x110, 0x6bcd,
    0x110, 0x9f9f, 0x110, 0x4e00, 0x110, 0x4e28, 0x110, 0x4e36,
    0x110, 0x4e3f, 0x110, 0x4e59, 0x110, 0x4e85, 0x110, 0x4e8c,
    0x110, 0x4ea0, 0x110, 0x4eba, 0x110, 0x513f, 0x110, 0x5165,
    0x110, 0x516b, 0x110, 0x5182, 0x110, 0x5196, 0x110, 0x51ab,
    0x110, 0x51e0, 0x110, 0x51f5, 0x110, 0x5200, 0x110, 0x529b,
    0x110, 0x52f9, 0x110, 0x5315, 0x110, 0x531a, 0x110, 0x5338,
    0x110, 0x5341, 0x110, 0x535c, 0x110, 0x5369, 0x110, 0x5382,
    0x110, 0x53b6, 0x110, 0x53c8, 0x110, 0x53e3, 0x110, 0x56d7,
    0x110, 0x571f, 0x110, 0x58eb, 0x110, 0x5902, 0x110, 0x590a,
    0x110, 0x5915, 0x110, 0x5927, 0x110, 0x5973, 0x110, 0x5b50,
    0x110, 0x5b80, 0x110, 0x5bf8, 0x110, 0x5c0f, 0x110, 0x5c22,
    0x110, 0x5c38, 0x110, 0x5c6e, 0x110, 0x5c71, 0x110, 0x5ddb,
    0x110, 0x5de5, 0x110, 0x5df1, 0x110, 0x5dfe, 0x110, 0x5e72,
    0x110, 0x5e7a, 0x110, 0x5e7f, 0x110, 0x5ef4, 0x110, 0x5efe,
    0x110, 0x5f0b, 0x110, 0x5f13, 0x110, 0x5f50, 0x110, 0x5f61,
    0x110, 0x5f73, 0x110, 0x5fc3, 0x110, 0x6208, 0x110, 0x6236,
    0x110, 0x624b, 0x110, 0x652f, 0x110, 0x6534, 0x110, 0x6587,
    0x110, 0x6597, 0x110, 0x65a4, 0x110, 0x65b9, 0x110, 0x65e0,
    0x110, 0x65e5, 0x110, 0x66f0, 0x110, 0x6708, 0x110, 0x6728,
    0x110, 0x6b20, 0x110, 0x6b62, 0x110, 0x6b79, 0x110, 0x6bb3,
    0x110, 0x6bcb, 0x110, 0x6bd4, 0x110, 0x6bdb, 0x110, 0x6c0f,
    0x110, 0x6c14, 0x110, 0x6c34, 0x110, 0x706b, 0x110, 0x722a,
    0x110, 0x7236, 0x110, 0x723b, 0x110, 0x723f, 0x110, 0x7247,
    0x110, 0x7259, 0x110, 0x725b, 0x110, 0x72ac, 0x110, 0x7384,
    0x110, 0x7389, 0x110, 0x74dc, 0x110, 0x74e6, 0x110, 0x7518,
    0x110, 0x751f, 0x110, 0x7528, 0x110, 0x7530, 0x110, 0x758b,
    0x110, 0x7592, 0x110, 0x7676, 0x110, 0x767d, 0x110, 0x76ae,
    0x110, 0x76bf, 0x110, 0x76ee, 0x110, 0x77db, 0x110, 0x77e2,
    0x110, 0x77f3, 0x110, 0x793a, 0x110, 0x79b8, 0x110, 0x79be,
    0x110, 0x7a74, 0x110, 0x7acb, 0x110, 0x7af9, 0x110, 0x7c73,
    0x110, 0x7cf8, 0x110, 0x7f36, 0x110, 0x7f51, 0x110, 0x7f8a,
    0x110, 0x7fbd, 0x110, 0x8001, 0x110, 0x800c, 0x110, 0x8012,
    0x110, 0x8033, 0x110, 0x807f, 0x110, 0x8089, 0x110, 0x81e3,
    0x110, 0x81ea, 0x110, 0x81f3, 0x110, 0x81fc, 0x110, 0x820c,
    0x110, 0x821b, 0x110, 0x821f, 0x110, 0x826e, 0x110, 0x8272,
    0x110, 0x8278, 0x110, 0x864d, 0x110, 0x866b, 0x110, 0x8840,
    0x110, 0x884c, 0x110, 0x8863, 0x110, 0x897e, 0x110, 0x898b,
    0x110, 0x89d2, 0x110, 0x8a00, 0x110, 0x8c37, 0x110, 0x8c46,
    0x110, 0x8c55, 0x110, 0x8c78, 0x110, 0x8c9d, 0x110, 0x8d64,
    0x110, 0x8d70, 0x110, 0x8db3, 0x110, 0x8eab, 0x110, 0x8eca,
    0x110, 0x8f9b, 0x110, 0x8fb0, 0x110, 0x8fb5, 0x110, 0x9091,
    0x110, 0x9149, 0x110, 0x91c6, 0x110, 0x91cc, 0x110, 0x91d1,
    0x110, 0x9577, 0x110, 0x9580, 0x110, 0x961c, 0x110, 0x96b6,
    0x110, 0x96b9, 0x110, 0x96e8, 0x110, 0x9751, 0x110, 0x975e,
    0x110, 0x9762, 0x110, 0x9769, 0x110, 0x97cb, 0x110, 0x97ed,
    0x110, 0x97f3, 0x110, 0x9801, 0x110, 0x98a8, 0x110, 0x98db,
    0x110, 0x98df, 0x110, 0x9996, 0x110, 0x9999, 0x110, 0x99ac,
    0x110, 0x9aa8, 0x110, 0x9ad8, 0x110, 0x9adf, 0x110, 0x9b25,
    0x110, 0x9b2f, 0x110, 0x9b32, 0x110, 0x9b3c, 0x110, 0x9b5a,
    0x110, 0x9ce5, 0x110, 0x9e75, 0x110, 0x9e7f, 0x110, 0x9ea5,
    0x110, 0x9ebb, 0x110, 0x9ec3, 0x110, 0x9ecd, 0x110, 0x9ed1,
    0x110, 0x9ef9, 0x110, 0x9efd, 0x110, 0x9f0e, 0x110, 0x9f13,
    0x110, 0x9f20, 0x110, 0x9f3b, 0x110, 0x9f4a, 0x110, 0x9f52,
    0x110, 0x9f8d, 0x110, 0x9f9c, 0x110, 0x9fa0, 0x10c, 0x20,
    0x110, 0x3012, 0x110, 0x5341, 0x110, 0x5344, 0x110, 0x5345,
    0x201, 0x304b, 0x3099, 0x201, 0x304d, 0x3099, 0x201, 0x304f,
    0x3099, 0x201, 0x3051, 0x3099, 0x201, 0x3053, 0x3099, 0x201,
    0x3055, 0x3099, 0x201, 0x3057, 0x3099, 0x201, 0x3059, 0x3099,
    0x201, 0x305b, 0x3099, 0x201, 0x305d, 0x3099, 0x201, 0x305f,
    0x3099, 0x201, 0x3061, 0x3099, 0x201, 0x3064, 0x3099, 0x201,
    0x3066, 0x3099, 0x201, 0x3068, 0x3099, 0x201, 0x306f, 0x3099,
    0x201, 0x306f, 0x309a, 0x201, 0x3072, 0x3099, 0x201, 0x3072,
    0x309a, 0x201, 0x3075, 0x3099, 0x201, 0x3075, 0x309a, 0x201,
    0x3078, 0x3099, 0x201, 0x3078, 0x309a, 0x201, 0x307b, 0x3099,
    0x201, 0x307b, 0x309a, 0x201, 0x3046, 0x3099, 0x210, 0x20,
    0x3099, 0x210, 0x20, 0x309a, 0x201, 0x309d, 0x3099, 0x20b,
    0x3088, 0x308a, 0x201, 0x30ab, 0x3099, 0x201, 0x30ad, 0x3099,
    0x201, 0x30af, 0x3099, 0x201, 0x30b1, 0x3099, 0x201, 0x30b3,
    0x3099, 0x201, 0x30b5, 0x3099, 0x201, 0x30b7, 0x3099, 0x201,
    0x30b9, 0x3099, 0x201, 0x30bb, 0x3099, 0x201, 0x30bd, 0x3099,
    0x201, 0x30bf, 0x3099, 0x201, 0x30c1, 0x3099, 0x201, 0x30c4,
    0x3099, 0x201, 0x30c6, 0x3099, 0x201, 0x30c8, 0x3099, 0x201,
    0x30cf, 0x3099, 0x201, 0x30cf, 0x309a, 0x201, 0x30d2, 0x3099,
    0x201, 0x30d2, 0x309a, 0x201, 0x30d5, 0x3099, 0x201, 0x30d5,
    0x309a, 0x201, 0x30d8, 0x3099, 0x201, 0x30d8, 0x309a, 0x201,
    0x30db, 0x3099, 0x201, 0x30db, 0x309a, 0x201, 0x30a6, 0x3099,
    0x201, 0x30ef, 0x3099, 0x201, 0x30f0, 0x3099, 0x201, 0x30f1,
    0x3099, 0x201, 0x30f2, 0x3099, 0x201, 0x30fd, 0x3099, 0x20b,
    0x30b3, 0x30c8, 0x110, 0x1100, 0x110, 0x1101, 0x110, 0x11aa,
    0x110, 0x1102, 0x110, 0x11ac, 0x110, 0x11ad, 0x110, 0x1103,
    0x110, 0x1104, 0x110, 0x1105, 0x110, 0x11b0, 0x110, 0x11b1,
    0x110, 0x11b2, 0x110, 0x11b3, 0x110, 0x11b4, 0x110, 0x11b5,
    0x110, 0x111a, 0x110, 0x1106, 0x110, 0x1107, 0x110, 0x1108,
    0x110, 0x1121, 0x110, 0x1109, 0x110, 0x110a, 0x110, 0x110b,
    0x110, 0x110c, 0x110, 0x110d, 0x110, 0x110e, 0x110, 0x110f,
    0x110, 0x1110, 0x110, 0x1111, 0x110, 0x1112, 0x110, 0x1161,
    0x110, 0x1162, 0x110, 0x1163, 0x110, 0x1164, 0x110, 0x1165,
    0x110, 0x1166, 0x110, 0x1167, 0x110, 0x1168, 0x110, 0x1169,
    0x110, 0x116a, 0x110, 0x116b, 0x110, 0x116c, 0x110, 0x116d,
    0x110, 0x116e, 0x110, 0x116f, 0x110, 0x1170, 0x110, 0x1171,
    0x110, 0x1172, 0x110, 0x1173, 0x110, 0x1174, 0x110, 0x1175,
    0x110, 0x1160, 0x110, 0x1114, 0x110, 0x1115, 0x110, 0x11c7,
    0x110, 0x11c8, 0x110, 0x11cc, 0x110, 0x11ce, 0x110, 0x11d3,
    0x110, 0x11d7, 0x110, 0x11d9, 0x110, 0x111c, 0x110, 0x11dd,
    0x110, 0x11df, 0x110, 0x111d, 0x110, 0x111e, 0x110, 0x1120,
    0x110, 0x1122, 0x110, 0x1123, 0x110, 0x1127, 0x110, 0x1129,
    0x110, 0x112b, 0x110, 0x112c, 0x110, 0x112d, 0x110, 0x112e,
    0x110, 0x112f, 0x110, 0x1132, 0x110, 0x1136, 0x110, 0x1140,
    0x110, 0x1147, 0x110, 0x114c, 0x110, 0x11f1, 0x110, 0x11f2,
    0x110, 0x1157, 0x110, 0x1158, 0x110, 0x1159, 0x110, 0x1184,
    0x110, 0x1185, 0x110, 0x1188, 0x110, 0x1191, 0x110, 0x1192,
    0x110, 0x1194, 0x110, 0x119e, 0x110, 0x11a1, 0x109, 0x4e00,
    0x109, 0x4e8c, 0x109, 0x4e09, 0x109, 0x56db, 0x109, 0x4e0a,
    0x109, 0x4e2d, 0x109, 0x4e0b, 0x109, 0x7532, 0x109, 0x4e59,
    0x109, 0x4e19, 0x109, 0x4e01, 0x109, 0x5929, 0x109, 0x5730,
    0x109, 0x4eba, 0x310, 0x28, 0x1100, 0x29, 0x310, 0x28,
    0x1102, 0x29, 0x310, 0x28, 0x1103, 0x29, 0x310, 0x28,
    0x1105, 0x29, 0x310, 0x28, 0x1106, 0x29, 0x310, 0x28,
    0x1107, 0x29, 0x310, 0x28, 0x1109, 0x29, 0x310, 0x28,
    0x110b, 0x29, 0x310, 0x28, 0x110c, 0x29, 0x310, 0x28,
    0x110e, 0x29, 0x310, 0x28, 0x110f, 0x29, 0x310, 0x28,
    0x1110, 0x29, 0x310, 0x28, 0x1111, 0x29, 0x310, 0x28,
    0x1112, 0x29, 0x410, 0x28, 0x1100, 0x1161, 0x29, 0x410,
    0x28, 0x1102, 0x1161, 0x29, 0x410, 0x28, 0x1103, 0x1161,
    0x29, 0x410, 0x28, 0x1105, 0x1161, 0x29, 0x410, 0x28,
    0x1106, 0x1161, 0x29, 0x410, 0x28, 0x1107, 0x1161, 0x29,
    0x410, 0x28, 0x1109, 0x1161, 0x29, 0x410, 0x28, 0x110b,
    0x1161, 0x29, 0x410, 0x28, 0x110c, 0x1161, 0x29, 0x410,
    0x28, 0x110e, 0x1161, 0x29, 0x410, 0x28, 0x110f, 0x1161,
    0x29, 0x410, 0x28, 0x1110, 0x1161, 0x29, 0x410, 0x28,
    0x1111, 0x1161, 0x29, 0x410, 0x28, 0x1112, 0x1161, 0x29,
    0x410, 0x28, 0x110c, 0x116e, 0x29, 0x710, 0x28, 0x110b,
    0x1169, 0x110c, 0x1165, 0x11ab, 0x29, 0x610, 0x28, 0x110b,
    0x1169, 0x1112, 0x116e, 0x29, 0x310, 0x28, 0x4e00, 0x29,
    0x310, 0x28, 0x4e8c, 0x29, 0x310, 0x28, 0x4e09, 0x29,
    0x310, 0x28, 0x56db, 0x29, 0x310, 0x28, 0x4e94, 0x29,
    0x310, 0x28, 0x516d, 0x29, 0x310, 0x28, 0x4e03, 0x29,
    0x310, 0x28, 0x516b, 0x29, 0x310, 0x28, 0x4e5d, 0x29,
    0x310, 0x28, 0x5341, 0x29, 0x310, 0x28, 0x6708, 0x29,
    0x310, 0x28, 0x706b, 0x29, 0x310, 0x28, 0x6c34, 0x29,
    0x310, 0x28, 0x6728, 0x29, 0x310, 0x28, 0x91d1, 0x29,
    0x310, 0x28, 0x571f, 0x29, 0x310, 0x28, 0x65e5, 0x29,
    0x310, 0x28, 0x682a, 0x29, 0x310, 0x28, 0x6709, 0x29,
    0x310, 0x28, 0x793e, 0x29, 0x310, 0x28, 0x540d, 0x29,
    0x310, 0x28, 0x7279, 0x29, 0x310, 0x28, 0x8ca1, 0x29,
    0x310, 0x28, 0x795d, 0x29, 0x310, 0x28, 0x52b4, 0x29,
    0x310, 0x28, 0x4ee3, 0x29, 0x310, 0x28, 0x547c, 0x29,
    0x310, 0x28, 0x5b66, 0x29, 0x310, 0x28, 0x76e3, 0x29,
    0x310, 0x28, 0x4f01, 0x29, 0x310, 0x28, 0x8cc7, 0x29,
    0x310, 0x28, 0x5354, 0x29, 0x310, 0x28, 0x796d, 0x29,
    0x310, 0x28, 0x4f11, 0x29, 0x310, 0x28, 0x81ea, 0x29,
    0x310, 0x28, 0x81f3, 0x29, 0x108, 0x554f, 0x108, 0x5e7c,
    0x108, 0x6587, 0x108, 0x7b8f, 0x30f, 0x50, 0x54, 0x45,
    0x208, 0x32, 0x31, 0x208, 0x32, 0x32, 0x208, 0x32,
    0x33, 0x208, 0x32, 0x34, 0x208, 0x32, 0x35, 0x208,
    0x32, 0x36, 0x208, 0x32, 0x37, 0x208, 0x32, 0x38,
    0x208, 0x32, 0x39, 0x208, 0x33, 0x30, 0x208, 0x33,
    0x31, 0x208, 0x33, 0x32, 0x208, 0x33, 0x33, 0x208,
    0x33, 0x34, 0x208, 0x33, 0x35, 0x108, 0x1100, 0x108,
    0x1102, 0x108, 0x1103, 0x108, 0x1105, 0x108, 0x1106, 0x108,
    0x1107, 0x108, 0x1109, 0x108, 0x110b, 0x108, 0x110c, 0x108,
    0x110e, 0x108, 0x110f, 0x108, 0x1110, 0x108, 0x1111, 0x108,
    0x1112, 0x208, 0x1100, 0x1161, 0x208, 0x1102, 0x1161, 0x208,
    0x1103, 0x1161, 0x208, 0x1105, 0x1161, 0x208, 0x1106, 0x1161,
    0x208, 0x1107, 0x1161, 0x208, 0x1109, 0x1161, 0x208, 0x110b,
    0x1161, 0x208, 0x110c, 0x1161, 0x208, 0x110e, 0x1161, 0x208,
    0x110f, 0x1161, 0x208, 0x1110, 0x1161, 0x208, 0x1111, 0x1161,
    0x208, 0x1112, 0x1161, 0x508, 0x110e, 0x1161, 0x11b7, 0x1100,
    0x1169, 0x408, 0x110c, 0x116e, 0x110b, 0x1174, 0x208, 0x110b,
    0x116e, 0x108, 0x4e00, 0x108, 0x4e8c, 0x108, 0x4e09, 0x108,
    0x56db, 0x108, 0x4e94, 0x108, 0x516d, 0x108, 0x4e03, 0x108,
    0x516b, 0x108, 0x4e5d, 0x108, 0x5341, 0x108, 0x6708, 0x108,
    0x706b, 0x108, 0x6c34, 0x108, 0x6728, 0x108, 0x91d1, 0x108,
    0x571f, 0x108, 0x65e5, 0x108, 0x682a, 0x108, 0x6709, 0x108,
    0x793e, 0x108, 0x540d, 0x108, 0x7279, 0x108, 0x8ca1, 0x108,
    0x795d, 0x108, 0x52b4, 0x108, 0x79d8, 0x108, 0x7537, 0x108,
    0x5973, 0x108, 0x9069, 0x108, 0x512a, 0x108, 0x5370, 0x108,
    0x6ce8, 0x108, 0x9805, 0x108, 0x4f11, 0x108, 0x5199, 0x108,
    0x6b63, 0x108, 0x4e0a, 0x108, 0x4e2d, 0x108, 0x4e0b, 0x108,
    0x5de6, 0x108, 0x53f3, 0x108, 0x533b, 0x108, 0x5b97, 0x108,
    0x5b66, 0x108, 0x76e3, 0x108, 0x4f01, 0x108, 0x8cc7, 0x108,
    0x5354, 0x108, 0x591c, 0x208, 0x33, 0x36, 0x208, 0x33,
    0x37, 0x208, 0x33, 0x38, 0x208, 0x33, 0x39, 0x208,
    0x34, 0x30, 0x208, 0x34, 0x31, 0x208, 0x34, 0x32,
    0x208, 0x34, 0x33, 0x208, 0x34, 0x34, 0x208, 0x34,
    0x35, 0x208, 0x34, 0x36, 0x208, 0x34, 0x37, 0x208,
    0x34, 0x38, 0x208, 0x34, 0x39, 0x208, 0x35, 0x30,
    0x210, 0x31, 0x6708, 0x210, 0x32, 0x6708, 0x210, 0x33,
    0x6708, 0x210, 0x34, 0x6708, 0x210, 0x35, 0x6708, 0x210,
    0x36, 0x6708, 0x210, 0x37, 0x6708, 0x210, 0x38, 0x6708,
    0x210, 0x39, 0x6708, 0x310, 0x31, 0x30, 0x6708, 0x310,
    0x31, 0x31, 0x6708, 0x310, 0x31, 0x32, 0x6708, 0x20f,
    0x48, 0x67, 0x30f, 0x65, 0x72, 0x67, 0x20f, 0x65,
    0x56, 0x30f, 0x4c, 0x54, 0x44, 0x108, 0x30a2, 0x108,
    0x30a4, 0x108, 0x30a6, 0x108, 0x30a8, 0x108, 0x30aa, 0x108,
    0x30ab, 0x108, 0x30ad, 0x108, 0x30af, 0x108, 0x30b1, 0x108,
    0x30b3, 0x108, 0x30b5, 0x108, 0x30b7, 0x108, 0x30b9, 0x108,
    0x30bb, 0x108, 0x30bd, 0x108, 0x30bf, 0x108, 0x30c1, 0x108,
    0x30c4, 0x108, 0x30c6, 0x108, 0x30c8, 0x108, 0x30ca, 0x108,
    0x30cb, 0x108, 0x30cc, 0x108, 0x30cd, 0x108, 0x30ce, 0x108,
    0x30cf, 0x108, 0x30d2, 0x108, 0x30d5, 0x108, 0x30d8, 0x108,
    0x30db, 0x108, 0x30de, 0x108, 0x30df, 0x108, 0x30e0, 0x108,
    0x30e1, 0x108, 0x30e2, 0x108, 0x30e4, 0x108, 0x30e6, 0x108,
    0x30e8, 0x108, 0x30e9, 0x108, 0x30ea, 0x108, 0x30eb, 0x108,
    0x30ec, 0x108, 0x30ed, 0x108, 0x30ef, 0x108, 0x30f0, 0x108,
    0x30f1, 0x108, 0x30f2, 0x20f, 0x4ee4, 0x548c, 0x40f, 0x30a2,
    0x30d1, 0x30fc, 0x30c8, 0x40f, 0x30a2, 0x30eb, 0x30d5, 0x30a1,
    0x40f, 0x30a2, 0x30f3, 0x30da, 0x30a2, 0x30f, 0x30a2, 0x30fc,
    0x30eb, 0x40f, 0x30a4, 0x30cb, 0x30f3, 0x30b0, 0x30f, 0x30a4,
    0x30f3, 0x30c1, 0x30f, 0x30a6, 0x30a9, 0x30f3, 0x50f, 0x30a8,
    0x30b9, 0x30af, 0x30fc, 0x30c9, 0x40f, 0x30a8, 0x30fc, 0x30ab,
    0x30fc, 0x30f, 0x30aa, 0x30f3, 0x30b9, 0x30f, 0x30aa, 0x30fc,
    0x30e0, 0x30f, 0x30ab, 0x30a4, 0x30ea, 0x40f, 0x30ab, 0x30e9,
    0x30c3, 0x30c8, 0x40f, 0x30ab, 0x30ed, 0x30ea, 0x30fc, 0x30f,
    0x30ac, 0x30ed, 0x30f3, 0x30f, 0x30ac, 0x30f3, 0x30de, 0x20f,
    0x30ae, 0x30ac, 0x30f, 0x30ae, 0x30cb, 0x30fc, 0x40f, 0x30ad,
    0x30e5, 0x30ea, 0x30fc, 0x40f, 0x30ae, 0x30eb, 0x30c0, 0x30fc,
    0x20f, 0x30ad, 0x30ed, 0x50f, 0x30ad, 0x30ed, 0x30b0, 0x30e9,
    0x30e0, 0x60f, 0x30ad, 0x30ed, 0x30e1, 0x30fc, 0x30c8, 0x30eb,
    0x50f, 0x30ad, 0x30ed, 0x30ef, 0x30c3, 0x30c8, 0x30f, 0x30b0,
    0x30e9, 0x30e0, 0x50f, 0x30b0, 0x30e9, 0x30e0, 0x30c8, 0x30f3,
    0x50f, 0x30af, 0x30eb, 0x30bc, 0x30a4, 0x30ed, 0x40f, 0x30af,
    0x30ed, 0x30fc, 0x30cd, 0x30f, 0x30b1, 0x30fc, 0x30b9, 0x30f,
    0x30b3, 0x30eb, 0x30ca, 0x30f, 0x30b3, 0x30fc, 0x30dd, 0x40f,
    0x30b5, 0x30a4, 0x30af, 0x30eb, 0x50f, 0x30b5, 0x30f3, 0x30c1,
    0x30fc, 0x30e0, 0x40f, 0x30b7, 0x30ea, 0x30f3, 0x30b0, 0x30f,
    0x30bb, 0x30f3, 0x30c1, 0x30f, 0x30bb, 0x30f3, 0x30c8, 0x30f,
    0x30c0, 0x30fc, 0x30b9, 0x20f, 0x30c7, 0x30b7, 0x20f, 0x30c9,
    0x30eb, 0x20f, 0x30c8, 0x30f3, 0x20f, 0x30ca, 0x30ce, 0x30f,
    0x30ce, 0x30c3, 0x30c8, 0x30f, 0x30cf, 0x30a4, 0x30c4, 0x50f,
    0x30d1, 0x30fc, 0x30bb, 0x30f3, 0x30c8, 0x30f, 0x30d1, 0x30fc,
    0x30c4, 0x40f, 0x30d0, 0x30fc, 0x30ec, 0x30eb, 0x50f, 0x30d4,
    0x30a2, 0x30b9, 0x30c8, 0x30eb, 0x30f, 0x30d4, 0x30af, 0x30eb,
    0x20f, 0x30d4, 0x30b3, 0x20f, 0x30d3, 0x30eb, 0x50f, 0x30d5,
    0x30a1, 0x30e9, 0x30c3, 0x30c9, 0x40f, 0x30d5, 0x30a3, 0x30fc,
    0x30c8, 0x50f, 0x30d6, 0x30c3, 0x30b7, 0x30a7, 0x30eb, 0x30f,
    0x30d5, 0x30e9, 0x30f3, 0x50f, 0x30d8, 0x30af, 0x30bf, 0x30fc,
    0x30eb, 0x20f, 0x30da, 0x30bd, 0x30f, 0x30da, 0x30cb, 0x30d2,
    0x30f, 0x30d8, 0x30eb, 0x30c4, 0x30f, 0x30da, 0x30f3, 0x30b9,
    0x30f, 0x30da, 0x30fc, 0x30b8, 0x30f, 0x30d9, 0x30fc, 0x30bf,
    0x40f, 0x30dd, 0x30a4, 0x30f3, 0x30c8, 0x30f, 0x30dc, 0x30eb,
    0x30c8, 0x20f, 0x30db, 0x30f3, 0x30f, 0x30dd, 0x30f3, 0x30c9,
    0x30f, 0x30db, 0x30fc, 0x30eb, 0x30f, 0x30db, 0x30fc, 0x30f3,
    0x40f, 0x30de, 0x30a4, 0x30af, 0x30ed, 0x30f, 0x30de, 0x30a4,
    0x30eb, 0x30f, 0x30de, 0x30c3, 0x30cf, 0x30f, 0x30de, 0x30eb,
    0x30af, 0x50f, 0x30de, 0x30f3, 0x30b7, 0x30e7, 0x30f3, 0x40f,
    0x30df, 0x30af, 0x30ed, 0x30f3, 0x20f, 0x30df, 0x30ea, 0x50f,
    0x30df, 0x30ea, 0x30d0, 0x30fc, 0x30eb, 0x20f, 0x30e1, 0x30ac,
    0x40f, 0x30e1, 0x30ac, 0x30c8, 0x30f3, 0x40f, 0x30e1, 0x30fc,
    0x30c8, 0x30eb, 0x30f, 0x30e4, 0x30fc, 0x30c9, 0x30f, 0x30e4,
    0x30fc, 0x30eb, 0x30f, 0x30e6, 0x30a2, 0x30f3, 0x40f, 0x30ea,
    0x30c3, 0x30c8, 0x30eb, 0x20f, 0x30ea, 0x30e9, 0x30f, 0x30eb,
    0x30d4, 0x30fc, 0x40f, 0x30eb, 0x30fc, 0x30d6, 0x30eb, 0x20f,
    0x30ec, 0x30e0, 0x50f, 0x30ec, 0x30f3, 0x30c8, 0x30b2, 0x30f3,
    0x30f, 0x30ef, 0x30c3, 0x30c8, 0x210, 0x30, 0x70b9, 0x210,
    0x31, 0x70b9, 0x210, 0x32, 0x70b9, 0x210, 0x33, 0x70b9,
    0x210, 0x34, 0x70b9, 0x210, 0x35, 0x70b9, 0x210, 0x36,
    0x70b9, 0x210, 0x37, 0x70b9, 0x210, 0x38, 0x70b9, 0x210,
    0x39, 0x70b9, 0x310, 0x31, 0x30, 0x70b9, 0x310, 0x31,
    0x31, 0x70b9, 0x310, 0x31, 0x32, 0x70b9, 0x310, 0x31,
    0x33, 0x70b9, 0x310, 0x31, 0x34, 0x70b9, 0x310, 0x31,
    0x35, 0x70b9, 0x310, 0x31, 0x36, 0x70b9, 0x310, 0x31,
    0x37, 0x70b9, 0x310, 0x31, 0x38, 0x70b9, 0x310, 0x31,
    0x39, 0x70b9, 0x310, 0x32, 0x30, 0x70b9, 0x310, 0x32,
    0x31, 0x70b9, 0x310, 0x32, 0x32, 0x70b9, 0x310, 0x32,
    0x33, 0x70b9, 0x310, 0x32, 0x34, 0x70b9, 0x30f, 0x68,
    0x50, 0x61, 0x20f, 0x64, 0x61, 0x20f, 0x41, 0x55,
    0x30f, 0x62, 0x61, 0x72, 0x20f, 0x6f, 0x56, 0x20f,
    0x70, 0x63, 0x20f, 0x64, 0x6d, 0x30f, 0x64, 0x6d,
    0xb2, 0x30f, 0x64, 0x6d, 0xb3, 0x20f, 0x49, 0x55,
    0x20f, 0x5e73, 0x6210, 0x20f, 0x662d, 0x548c, 0x20f, 0x5927,
    0x6b63, 0x20f, 0x660e, 0x6cbb, 0x40f, 0x682a, 0x5f0f, 0x4f1a,
    0x793e, 0x20f, 0x70, 0x41, 0x20f, 0x6e, 0x41, 0x20f,
    0x3bc, 0x41, 0x20f, 0x6d, 0x41, 0x20f, 0x6b, 0x41,
    0x20f, 0x4b, 0x42, 0x20f, 0x4d, 0x42, 0x20f, 0x47,
    0x42, 0x30f, 0x63, 0x61, 0x6c, 0x40f, 0x6b, 0x63,
    0x61, 0x6c, 0x20f, 0x70, 0x46, 0x20f, 0x6e, 0x46,
    0x20f, 0x3bc, 0x46, 0x20f, 0x3bc, 0x67, 0x20f, 0x6d,
    0x67, 0x20f, 0x6b, 0x67, 0x20f, 0x48, 0x7a, 0x30f,
    0x6b, 0x48, 0x7a, 0x30f, 0x4d, 0x48, 0x7a, 0x30f,
    0x47, 0x48, 0x7a, 0x30f, 0x54, 0x48, 0x7a, 0x20f,
    0x3bc, 0x2113, 0x20f, 0x6d, 0x2113, 0x20f, 0x64, 0x2113,
    0x20f, 0x6b, 0x2113, 0x20f, 0x66, 0x6d, 0x20f, 0x6e,
    0x6d, 0x20f, 0x3bc, 0x6d, 0x20f, 0x6d, 0x6d, 0x20f,
    0x63, 0x6d, 0x20f, 0x6b, 0x6d, 0x30f, 0x6d, 0x6d,
    0xb2, 0x30f, 0x63, 0x6d, 0xb2, 0x20f, 0x6d, 0xb2,
    0x30f, 0x6b, 0x6d, 0xb2, 0x30f, 0x6d, 0x6d, 0xb3,
    0x30f, 0x63, 0x6d, 0xb3, 0x20f, 0x6d, 0xb3, 0x30f,
    0x6b, 0x6d, 0xb3, 0x30f, 0x6d, 0x2215, 0x73, 0x40f,
    0x6d, 0x2215, 0x73, 0xb2, 0x20f, 0x50, 0x61, 0x30f,
    0x6b, 0x50, 0x61, 0x30f, 0x4d, 0x50, 0x61, 0x30f,
    0x47, 0x50, 0x61, 0x30f, 0x72, 0x61, 0x64, 0x50f,
    0x72, 0x61, 0x64, 0x2215, 0x73, 0x60f, 0x72, 0x61,
    0x64, 0x2215, 0x73, 0xb2, 0x20f, 0x70, 0x73, 0x20f,
    0x6e, 0x73, 0x20f, 0x3bc, 0x73, 0x20f, 0x6d, 0x73,
    0x20f, 0x70, 0x56, 0x20f, 0x6e, 0x56, 0x20f, 0x3bc,
    0x56, 0x20f, 0x6d, 0x56, 0x20f, 0x6b, 0x56, 0x20f,
    0x4d, 0x56, 0x20f, 0x70, 0x57, 0x20f, 0x6e, 0x57,
    0x20f, 0x3bc, 0x57, 0x20f, 0x6d, 0x57, 0x20f, 0x6b,
    0x57, 0x20f, 0x4d, 0x57, 0x20f, 0x6b, 0x3a9, 0x20f,
    0x4d, 0x3a9, 0x40f, 0x61, 0x2e, 0x6d, 0x2e, 0x20f,
    0x42, 0x71, 0x20f, 0x63, 0x63, 0x20f, 0x63, 0x64,
    0x40f, 0x43, 0x2215, 0x6b, 0x67, 0x30f, 0x43, 0x6f,
    0x2e, 0x20f, 0x64, 0x42, 0x20f, 0x47, 0x79, 0x20f,
    0x68, 0x61, 0x20f, 0x48, 0x50, 0x20f, 0x69, 0x6e,
    0x20f, 0x4b, 0x4b, 0x20f, 0x4b, 0x4d, 0x20f, 0x6b,
    0x74, 0x20f, 0x6c, 0x6d, 0x20f, 0x6c, 0x6e, 0x30f,
    0x6c, 0x6f, 0x67, 0x20f, 0x6c, 0x78, 0x20f, 0x6d,
    0x62, 0x30f, 0x6d, 0x69, 0x6c, 0x30f, 0x6d, 0x6f,
    0x6c, 0x20f, 0x50, 0x48, 0x40f, 0x70, 0x2e, 0x6d,
    0x2e, 0x30f, 0x50, 0x50, 0x4d, 0x20f, 0x50, 0x52,
    0x20f, 0x73, 0x72, 0x20f, 0x53, 0x76, 0x20f, 0x57,
    0x62, 0x30f, 0x56, 0x2215, 0x6d, 0x30f, 0x41, 0x2215,
    0x6d, 0x210, 0x31, 0x65e5, 0x210, 0x32, 0x65e5, 0x210,
    0x33, 0x65e5, 0x210, 0x34, 0x65e5, 0x210, 0x35, 0x65e5,
    0x210, 0x36, 0x65e5, 0x210, 0x37, 0x65e5, 0x210, 0x38,
    0x65e5, 0x210, 0x39, 0x65e5, 0x310, 0x31, 0x30, 0x65e5,
    0x310, 0x31, 0x31, 0x65e5, 0x310, 0x31, 0x32, 0x65e5,
    0x310, 0x31, 0x33, 0x65e5, 0x310, 0x31, 0x34, 0x65e5,
    0x310, 0x31, 0x35, 0x65e5, 0x310, 0x31, 0x36, 0x65e5,
    0x310, 0x31, 0x37, 0x65e5, 0x310, 0x31, 0x38, 0x65e5,
    0x310, 0x31, 0x39, 0x65e5, 0x310, 0x32, 0x30, 0x65e5,
    0x310, 0x32, 0x31, 0x65e5, 0x310, 0x32, 0x32, 0x65e5,
    0x310, 0x32, 0x33, 0x65e5, 0x310, 0x32, 0x34, 0x65e5,
    0x310, 0x32, 0x35, 0x65e5, 0x310, 0x32, 0x36, 0x65e5,
    0x310, 0x32, 0x37, 0x65e5, 0x310, 0x32, 0x38, 0x65e5,
    0x310, 0x32, 0x39, 0x65e5, 0x310, 0x33, 0x30, 0x65e5,
    0x310, 0x33, 0x31, 0x65e5, 0x30f, 0x67, 0x61, 0x6c,
    0x109, 0x44a, 0x109, 0x44c, 0x109, 0xa76f, 0x109, 0x126,
    0x109, 0x153, 0x109, 0xa727, 0x109, 0xab37, 0x109, 0x26b,
    0x109, 0xab52, 0x109, 0x28d, 0x101, 0x8c48, 0x101, 0x66f4,
    0x101, 0x8eca, 0x101, 0x8cc8, 0x101, 0x6ed1, 0x101, 0x4e32,
    0x101, 0x53e5, 0x101, 0x9f9c, 0x101, 0x9f9c, 0x101, 0x5951,
    0x101, 0x91d1, 0x101, 0x5587, 0x101, 0x5948, 0x101, 0x61f6,
    0x101, 0x7669, 0x101, 0x7f85, 0x101, 0x863f, 0x101, 0x87ba,
    0x101, 0x88f8, 0x101, 0x908f, 0x101, 0x6a02, 0x101, 0x6d1b,
    0x101, 0x70d9, 0x101, 0x73de, 0x101, 0x843d, 0x101, 0x916a,
    0x101, 0x99f1, 0x101, 0x4e82, 0x101, 0x5375, 0x101, 0x6b04,
    0x101, 0x721b, 0x101, 0x862d, 0x101, 0x9e1e, 0x101, 0x5d50,
    0x101, 0x6feb, 0x101, 0x85cd, 0x101, 0x8964, 0x101, 0x62c9,
    0x101, 0x81d8, 0x101, 0x881f, 0x101, 0x5eca, 0x101, 0x6717,
    0x101, 0x6d6a, 0x101, 0x72fc, 0x101, 0x90ce, 0x101, 0x4f86,
    0x101, 0x51b7, 0x101, 0x52de, 0x101, 0x64c4, 0x101, 0x6ad3,
    0x101, 0x7210, 0x101, 0x76e7, 0x101, 0x8001, 0x101, 0x8606,
    0x101, 0x865c, 0x101, 0x8def, 0x101, 0x9732, 0x101, 0x9b6f,
    0x101, 0x9dfa, 0x101, 0x788c, 0x101, 0x797f, 0x101, 0x7da0,
    0x101, 0x83c9, 0x101, 0x9304, 0x101, 0x9e7f, 0x101, 0x8ad6,
    0x101, 0x58df, 0x101, 0x5f04, 0x101, 0x7c60, 0x101, 0x807e,
    0x101, 0x7262, 0x101, 0x78ca, 0x101, 0x8cc2, 0x101, 0x96f7,
    0x101, 0x58d8, 0x101, 0x5c62, 0x101, 0x6a13, 0x101, 0x6dda,
    0x101, 0x6f0f, 0x101, 0x7d2f, 0x101, 0x7e37, 0x101, 0x964b,
    0x101, 0x52d2, 0x101, 0x808b, 0x101, 0x51dc, 0x101, 0x51cc,
    0x101, 0x7a1c, 0x101, 0x7dbe, 0x101, 0x83f1, 0x101, 0x9675,
    0x101, 0x8b80, 0x101, 0x62cf, 0x101, 0x6a02, 0x101, 0x8afe,
    0x101, 0x4e39, 0x101, 0x5be7, 0x101, 0x6012, 0x101, 0x7387,
    0x101, 0x7570, 0x101, 0x5317, 0x101, 0x78fb, 0x101, 0x4fbf,
    0x101, 0x5fa9, 0x101, 0x4e0d, 0x101, 0x6ccc, 0x101, 0x6578,
    0x101, 0x7d22, 0x101, 0x53c3, 0x101, 0x585e, 0x101, 0x7701,
    0x101, 0x8449, 0x101, 0x8aaa, 0x101, 0x6bba, 0x101, 0x8fb0,
    0x101, 0x6c88, 0x101, 0x62fe, 0x101, 0x82e5, 0x101, 0x63a0,
    0x101, 0x7565, 0x101, 0x4eae, 0x101, 0x5169, 0x101, 0x51c9,
    0x101, 0x6881, 0x101, 0x7ce7, 0x101, 0x826f, 0x101, 0x8ad2,
    0x101, 0x91cf, 0x101, 0x52f5, 0x101, 0x5442, 0x101, 0x5973,
    0x101, 0x5eec, 0x101, 0x65c5, 0x101, 0x6ffe, 0x101, 0x792a,
    0x101, 0x95ad, 0x101, 0x9a6a, 0x101, 0x9e97, 0x101, 0x9ece,
    0x101, 0x529b, 0x101, 0x66c6, 0x101, 0x6b77, 0x101, 0x8f62,
    0x101, 0x5e74, 0x101, 0x6190, 0x101, 0x6200, 0x101, 0x649a,
    0x101, 0x6f23, 0x101, 0x7149, 0x101, 0x7489, 0x101, 0x79ca,
    0x101, 0x7df4, 0x101, 0x806f, 0x101, 0x8f26, 0x101, 0x84ee,
    0x101, 0x9023, 0x101, 0x934a, 0x101, 0x5217, 0x101, 0x52a3,
    0x101, 0x54bd, 0x101, 0x70c8, 0x101, 0x88c2, 0x101, 0x8aaa,
    0x101, 0x5ec9, 0x101, 0x5ff5, 0x101, 0x637b, 0x101, 0x6bae,
    0x101, 0x7c3e, 0x101, 0x7375, 0x101, 0x4ee4, 0x101, 0x56f9,
    0x101, 0x5be7, 0x101, 0x5dba, 0x101, 0x601c, 0x101, 0x73b2,
    0x101, 0x7469, 0x101, 0x7f9a, 0x101, 0x8046, 0x101, 0x9234,
    0x101, 0x96f6, 0x101, 0x9748, 0x101, 0x9818, 0x101, 0x4f8b,
    0x101, 0x79ae, 0x101, 0x91b4, 0x101, 0x96b8, 0x101, 0x60e1,
    0x101, 0x4e86, 0x101, 0x50da, 0x101, 0x5bee, 0x101, 0x5c3f,
    0x101, 0x6599, 0x101, 0x6a02, 0x101, 0x71ce, 0x101, 0x7642,
    0x101, 0x84fc, 0x101, 0x907c, 0x101, 0x9f8d, 0x101, 0x6688,
    0x101, 0x962e, 0x101, 0x5289, 0x101, 0x677b, 0x101, 0x67f3,
    0x101, 0x6d41, 0x101, 0x6e9c, 0x101, 0x7409, 0x101, 0x7559,
    0x101, 0x786b, 0x101, 0x7d10, 0x101, 0x985e, 0x101, 0x516d,
    0x101, 0x622e, 0x101, 0x9678, 0x101, 0x502b, 0x101, 0x5d19,
    0x101, 0x6dea, 0x101, 0x8f2a, 0x101, 0x5f8b, 0x101, 0x6144,
    0x101, 0x6817, 0x101, 0x7387, 0x101, 0x9686, 0x101, 0x5229,
    0x101, 0x540f, 0x101, 0x5c65, 0x101, 0x6613, 0x101, 0x674e,
    0x101, 0x68a8, 0x101, 0x6ce5, 0x101, 0x7406, 0x101, 0x75e2,
    0x101, 0x7f79, 0x101, 0x88cf, 0x101, 0x88e1, 0x101, 0x91cc,
    0x101, 0x96e2, 0x101, 0x533f, 0x101, 0x6eba, 0x101, 0x541d,
    0x101, 0x71d0, 0x101, 0x7498, 0x101, 0x85fa, 0x101, 0x96a3,
    0x101, 0x9c57, 0x101, 0x9e9f, 0x101, 0x6797, 0x101, 0x6dcb,
    0x101, 0x81e8, 0x101, 0x7acb, 0x101, 0x7b20, 0x101, 0x7c92,
    0x101, 0x72c0, 0x101, 0x7099, 0x101, 0x8b58, 0x101, 0x4ec0,
    0x101, 0x8336, 0x101, 0x523a, 0x101, 0x5207, 0x101, 0x5ea6,
    0x101, 0x62d3, 0x101, 0x7cd6, 0x101, 0x5b85, 0x101, 0x6d1e,
    0x101, 0x66b4, 0x101, 0x8f3b, 0x101, 0x884c, 0x101, 0x964d,
    0x101, 0x898b, 0x101, 0x5ed3, 0x101, 0x5140, 0x101, 0x55c0,
    0x101, 0x585a, 0x101, 0x6674, 0x101, 0x51de, 0x101, 0x732a,
    0x101, 0x76ca, 0x101, 0x793c, 0x101, 0x795e, 0x101, 0x7965,
    0x101, 0x798f, 0x101, 0x9756, 0x101, 0x7cbe, 0x101, 0x7fbd,
    0x101, 0x8612, 0x101, 0x8af8, 0x101, 0x9038, 0x101, 0x90fd,
    0x101, 0x98ef, 0x101, 0x98fc, 0x101, 0x9928, 0x101, 0x9db4,
    0x101, 0x90de, 0x101, 0x96b7, 0x101, 0x4fae, 0x101, 0x50e7,
    0x101, 0x514d, 0x101, 0x52c9, 0x101, 0x52e4, 0x101, 0x5351,
    0x101, 0x559d, 0x101, 0x5606, 0x101, 0x5668, 0x101, 0x5840,
    0x101, 0x58a8, 0x101, 0x5c64, 0x101, 0x5c6e, 0x101, 0x6094,
    0x101, 0x6168, 0x101, 0x618e, 0x101, 0x61f2, 0x101, 0x654f,
    0x101, 0x65e2, 0x101, 0x6691, 0x101, 0x6885, 0x101, 0x6d77,
    0x101, 0x6e1a, 0x101, 0x6f22, 0x101, 0x716e, 0x101, 0x722b,
    0x101, 0x7422, 0x101, 0x7891, 0x101, 0x793e, 0x101, 0x7949,
    0x101, 0x7948, 0x101, 0x7950, 0x101, 0x7956, 0x101, 0x795d,
    0x101, 0x798d, 0x101, 0x798e, 0x101, 0x7a40, 0x101, 0x7a81,
    0x101, 0x7bc0, 0x101, 0x7df4, 0x101, 0x7e09, 0x101, 0x7e41,
    0x101, 0x7f72, 0x101, 0x8005, 0x101, 0x81ed, 0x101, 0x8279,
    0x101, 0x8279, 0x101, 0x8457, 0x101, 0x8910, 0x101, 0x8996,
    0x101, 0x8b01, 0x101, 0x8b39, 0x101, 0x8cd3, 0x101, 0x8d08,
    0x101, 0x8fb6, 0x101, 0x9038, 0x101, 0x96e3, 0x101, 0x97ff,
    0x101, 0x983b, 0x101, 0x6075, 0x201, 0xd850, 0xdeee, 0x101,
    0x8218, 0x101, 0x4e26, 0x101, 0x51b5, 0x101, 0x5168, 0x101,
    0x4f80, 0x101, 0x5145, 0x101, 0x5180, 0x101, 0x52c7, 0x101,
    0x52fa, 0x101, 0x559d, 0x101, 0x5555, 0x101, 0x5599, 0x101,
    0x55e2, 0x101, 0x585a, 0x101, 0x58b3, 0x101, 0x5944, 0x101,
    0x5954, 0x101, 0x5a62, 0x101, 0x5b28, 0x101, 0x5ed2, 0x101,
    0x5ed9, 0x101, 0x5f69, 0x101, 0x5fad, 0x101, 0x60d8, 0x101,
    0x614e, 0x101, 0x6108, 0x101, 0x618e, 0x101, 0x6160, 0x101,
    0x61f2, 0x101, 0x6234, 0x101, 0x63c4, 0x101, 0x641c, 0x101,
    0x6452, 0x101, 0x6556, 0x101, 0x6674, 0x101, 0x6717, 0x101,
    0x671b, 0x101, 0x6756, 0x101, 0x6b79, 0x101, 0x6bba, 0x101,
    0x6d41, 0x101, 0x6edb, 0x101, 0x6ecb, 0x101, 0x6f22, 0x101,
    0x701e, 0x101, 0x716e, 0x101, 0x77a7, 0x101, 0x7235, 0x101,
    0x72af, 0x101, 0x732a, 0x101, 0x7471, 0x101, 0x7506, 0x101,
    0x753b, 0x101, 0x761d, 0x101, 0x761f, 0x101, 0x76ca, 0x101,
    0x76db, 0x101, 0x76f4, 0x101, 0x774a, 0x101, 0x7740, 0x101,
    0x78cc, 0x101, 0x7ab1, 0x101, 0x7bc0, 0x101, 0x7c7b, 0x101,
    0x7d5b, 0x101, 0x7df4, 0x101, 0x7f3e, 0x101, 0x8005, 0x101,
    0x8352, 0x101, 0x83ef, 0x101, 0x8779, 0x101, 0x8941, 0x101,
    0x8986, 0x101, 0x8996, 0x101, 0x8abf, 0x101, 0x8af8, 0x101,
    0x8acb, 0x101, 0x8b01, 0x101, 0x8afe, 0x101, 0x8aed, 0x101,
    0x8b39, 0x101, 0x8b8a, 0x101, 0x8d08, 0x101, 0x8f38, 0x101,
    0x9072, 0x101, 0x9199, 0x101, 0x9276, 0x101, 0x967c, 0x101,
    0x96e3, 0x101, 0x9756, 0x101, 0x97db, 0x101, 0x97ff, 0x101,
    0x980b, 0x101, 0x983b, 0x101, 0x9b12, 0x101, 0x9f9c, 0x201,
    0xd84a, 0xdc4a, 0x201, 0xd84a, 0xdc44, 0x201, 0xd84c, 0xdfd5,
    0x101, 0x3b9d, 0x101, 0x4018, 0x101, 0x4039, 0x201, 0xd854,
    0xde49, 0x201, 0xd857, 0xdcd0, 0x201, 0xd85f, 0xded3, 0x101,
    0x9f43, 0x101, 0x9f8e, 0x210, 0x66, 0x66, 0x210, 0x66,
    0x69, 0x210, 0x66, 0x6c, 0x310, 0x66, 0x66, 0x69,
    0x310, 0x66, 0x66, 0x6c, 0x210, 0x17f, 0x74, 0x210,
    0x73, 0x74, 0x210, 0x574, 0x576, 0x210, 0x574, 0x565,
    0x210, 0x574, 0x56b, 0x210, 0x57e, 0x576, 0x210, 0x574,
    0x56d, 0x201, 0x5d9, 0x5b4, 0x201, 0x5f2, 0x5b7, 0x102,
    0x5e2, 0x102, 0x5d0, 0x102, 0x5d3, 0x102, 0x5d4, 0x102,
    0x5db, 0x102, 0x5dc, 0x102, 0x5dd, 0x102, 0x5e8, 0x102,
    0x5ea, 0x102, 0x2b, 0x201, 0x5e9, 0x5c1, 0x201, 0x5e9,
    0x5c2, 0x201, 0xfb49, 0x5c1, 0x201, 0xfb49, 0x5c2, 0x201,
    0x5d0, 0x5b7, 0x201, 0x5d0, 0x5b8, 0x201, 0x5d0, 0x5bc,
    0x201, 0x5d1, 0x5bc, 0x201, 0x5d2, 0x5bc, 0x201, 0x5d3,
    0x5bc, 0x201, 0x5d4, 0x5bc, 0x201, 0x5d5, 0x5bc, 0x201,
    0x5d6, 0x5bc, 0x201, 0x5d8, 0x5bc, 0x201, 0x5d9, 0x5bc,
    0x201, 0x5da, 0x5bc, 0x201, 0x5db, 0x5bc, 0x201, 0x5dc,
    0x5bc, 0x201, 0x5de, 0x5bc, 0x201, 0x5e0, 0x5bc, 0x201,
    0x5e1, 0x5bc, 0x201, 0x5e3, 0x5bc, 0x201, 0x5e4, 0x5bc,
    0x201, 0x5e6, 0x5bc, 0x201, 0x5e7, 0x5bc, 0x201, 0x5e8,
    0x5bc, 0x201, 0x5e9, 0x5bc, 0x201, 0x5ea, 0x5bc, 0x201,
    0x5d5, 0x5b9, 0x201, 0x5d1, 0x5bf, 0x201, 0x5db, 0x5bf,
    0x201, 0x5e4, 0x5bf, 0x210, 0x5d0, 0x5dc, 0x107, 0x671,
    0x106, 0x671, 0x107, 0x67b, 0x106, 0x67b, 0x104, 0x67b,
    0x105, 0x67b, 0x107, 0x67e, 0x106, 0x67e, 0x104, 0x67e,
    0x105, 0x67e, 0x107, 0x680, 0x106, 0x680, 0x104, 0x680,
    0x105, 0x680, 0x107, 0x67a, 0x106, 0x67a, 0x104, 0x67a,
    0x105, 0x67a, 0x107, 0x67f, 0x106, 0x67f, 0x104, 0x67f,
    0x105, 0x67f, 0x107, 0x679, 0x106, 0x679, 0x104, 0x679,
    0x105, 0x679, 0x107, 0x6a4, 0x106, 0x6a4, 0x104, 0x6a4,
    0x105, 0x6a4, 0x107, 0x6a6, 0x106, 0x6a6, 0x104, 0x6a6,
    0x105, 0x6a6, 0x107, 0x684, 0x106, 0x684, 0x104, 0x684,
    0x105, 0x684, 0x107, 0x683, 0x106, 0x683, 0x104, 0x683,
    0x105, 0x683, 0x107, 0x686, 0x106, 0x686, 0x104, 0x686,
    0x105, 0x686, 0x107, 0x687, 0x106, 0x687, 0x104, 0x687,
    0x105, 0x687, 0x107, 0x68d, 0x106, 0x68d, 0x107, 0x68c,
    0x106, 0x68c, 0x107, 0x68e, 0x106, 0x68e, 0x107, 0x688,
    0x106, 0x688, 0x107, 0x698, 0x106, 0x698, 0x107, 0x691,
    0x106, 0x691, 0x107, 0x6a9, 0x106, 0x6a9, 0x104, 0x6a9,
    0x105, 0x6a9, 0x107, 0x6af, 0x106, 0x6af, 0x104, 0x6af,
    0x105, 0x6af, 0x107, 0x6b3, 0x106, 0x6b3, 0x104, 0x6b3,
    0x105, 0x6b3, 0x107, 0x6b1, 0x106, 0x6b1, 0x104, 0x6b1,
    0x105, 0x6b1, 0x107, 0x6ba, 0x106, 0x6ba, 0x107, 0x6bb,
    0x106, 0x6bb, 0x104, 0x6bb, 0x105, 0x6bb, 0x107, 0x6c0,
    0x106, 0x6c0, 0x107, 0x6c1, 0x106, 0x6c1, 0x104, 0x6c1,
    0x105, 0x6c1, 0x107, 0x6be, 0x106, 0x6be, 0x104, 0x6be,
    0x105, 0x6be, 0x107, 0x6d2, 0x106, 0x6d2, 0x107, 0x6d3,
    0x106, 0x6d3, 0x107, 0x6ad, 0x106, 0x6ad, 0x104, 0x6ad,
    0x105, 0x6ad, 0x107, 0x6c7, 0x106, 0x6c7, 0x107, 0x6c6,
    0x106, 0x6c6, 0x107, 0x6c8, 0x106, 0x6c8, 0x107, 0x677,
    0x107, 0x6cb, 0x106, 0x6cb, 0x107, 0x6c5, 0x106, 0x6c5,
    0x107, 0x6c9, 0x106, 0x6c9, 0x107, 0x6d0, 0x106, 0x6d0,
    0x104, 0x6d0, 0x105, 0x6d0, 0x104, 0x649, 0x105, 0x649,
    0x207, 0x626, 0x627, 0x206, 0x626, 0x627, 0x207, 0x626,
    0x6d5, 0x206, 0x626, 0x6d5, 0x207, 0x626, 0x648, 0x206,
    0x626, 0x648, 0x207, 0x626, 0x6c7, 0x206, 0x626, 0x6c7,
    0x207, 0x626, 0x6c6, 0x206, 0x626, 0x6c6, 0x207, 0x626,
    0x6c8, 0x206, 0x626, 0x6c8, 0x207, 0x626, 0x6d0, 0x206,
    0x626, 0x6d0, 0x204, 0x626, 0x6d0, 0x207, 0x626, 0x649,
    0x206, 0x626, 0x649, 0x204, 0x626, 0x649, 0x107, 0x6cc,
    0x106, 0x6cc, 0x104, 0x6cc, 0x105, 0x6cc, 0x207, 0x626,
    0x62c, 0x207, 0x626, 0x62d, 0x207, 0x626, 0x645, 0x207,
    0x626, 0x649, 0x207, 0x626, 0x64a, 0x207, 0x628, 0x62c,
    0x207, 0x628, 0x62d, 0x207, 0x628, 0x62e, 0x207, 0x628,
    0x645, 0x207, 0x628, 0x649, 0x207, 0x628, 0x64a, 0x207,
    0x62a, 0x62c, 0x207, 0x62a, 0x62d, 0x207, 0x62a, 0x62e,
    0x207, 0x62a, 0x645, 0x207, 0x62a, 0x649, 0x207, 0x62a,
    0x64a, 0x207, 0x62b, 0x62c, 0x207, 0x62b, 0x645, 0x207,
    0x62b, 0x649, 0x207, 0x62b, 0x64a, 0x207, 0x62c, 0x62d,
    0x207, 0x62c, 0x645, 0x207, 0x62d, 0x62c, 0x207, 0x62d,
    0x645, 0x207, 0x62e, 0x62c, 0x207, 0x62e, 0x62d, 0x207,
    0x62e, 0x645, 0x207, 0x633, 0x62c, 0x207, 0x633, 0x62d,
    0x207, 0x633, 0x62e, 0x207, 0x633, 0x645, 0x207, 0x635,
    0x62d, 0x207, 0x635, 0x645, 0x207, 0x636, 0x62c, 0x207,
    0x636, 0x62d, 0x207, 0x636, 0x62e, 0x207, 0x636, 0x645,
    0x207, 0x637, 0x62d, 0x207, 0x637, 0x645, 0x207, 0x638,
    0x645, 0x207, 0x639, 0x62c, 0x207, 0x639, 0x645, 0x207,
    0x63a, 0x62c, 0x207, 0x63a, 0x645, 0x207, 0x641, 0x62c,
    0x207, 0x641, 0x62d, 0x207, 0x641, 0x62e, 0x207, 0x641,
    0x645, 0x207, 0x641, 0x649, 0x207, 0x641, 0x64a, 0x207,
    0x642, 0x62d, 0x207, 0x642, 0x645, 0x207, 0x642, 0x649,
    0x207, 0x642, 0x64a, 0x207, 0x643, 0x627, 0x207, 0x643,
    0x62c, 0x207, 0x643, 0x62d, 0x207, 0x643, 0x62e, 0x207,
    0x643, 0x644, 0x207, 0x643, 0x645, 0x207, 0x643, 0x649,
    0x207, 0x643, 0x64a, 0x207, 0x644, 0x62c, 0x207, 0x644,
    0x62d, 0x207, 0x644, 0x62e, 0x207, 0x644, 0x645, 0x207,
    0x644, 0x649, 0x207, 0x644, 0x64a, 0x207, 0x645, 0x62c,
    0x207, 0x645, 0x62d, 0x207, 0x645, 0x62e, 0x207, 0x645,
    0x645, 0x207, 0x645, 0x649, 0x207, 0x645, 0x64a, 0x207,
    0x646, 0x62c, 0x207, 0x646, 0x62d, 0x207, 0x646, 0x62e,
    0x207, 0x646, 0x645, 0x207, 0x646, 0x649, 0x207, 0x646,
    0x64a, 0x207, 0x647, 0x62c, 0x207, 0x647, 0x645, 0x207,
    0x647, 0x649, 0x207, 0x647, 0x64a, 0x207, 0x64a, 0x62c,
    0x207, 0x64a, 0x62d, 0x207, 0x64a, 0x62e, 0x207, 0x64a,
    0x645, 0x207, 0x64a, 0x649, 0x207, 0x64a, 0x64a, 0x207,
    0x630, 0x670, 0x207, 0x631, 0x670, 0x207, 0x649, 0x670,
    0x307, 0x20, 0x64c, 0x651, 0x307, 0x20, 0x64d, 0x651,
    0x307, 0x20, 0x64e, 0x651, 0x307, 0x20, 0x64f, 0x651,
    0x307, 0x20, 0x650, 0x651, 0x307, 0x20, 0x651, 0x670,
    0x206, 0x626, 0x631, 0x206, 0x626, 0x632, 0x206, 0x626,
    0x645, 0x206, 0x626, 0x646, 0x206, 0x626, 0x649, 0x206,
    0x626, 0x64a, 0x206, 0x628, 0x631, 0x206, 0x628, 0x632,
    0x206, 0x628, 0x645, 0x206, 0x628, 0x646, 0x206, 0x628,
    0x649, 0x206, 0x628, 0x64a, 0x206, 0x62a, 0x631, 0x206,
    0x62a, 0x632, 0x206, 0x62a, 0x645, 0x206, 0x62a, 0x646,
    0x206, 0x62a, 0x649, 0x206, 0x62a, 0x64a, 0x206, 0x62b,
    0x631, 0x206, 0x62b, 0x632, 0x206, 0x62b, 0x645, 0x206,
    0x62b, 0x646, 0x206, 0x62b, 0x649, 0x206, 0x62b, 0x64a,
    0x206, 0x641, 0x649, 0x206, 0x641, 0x64a, 0x206, 0x642,
    0x649, 0x206, 0x642, 0x64a, 0x206, 0x643, 0x627, 0x206,
    0x643, 0x644, 0x206, 0x643, 0x645, 0x206, 0x643, 0x649,
    0x206, 0x643, 0x64a, 0x206, 0x644, 0x645, 0x206, 0x644,
    0x649, 0x206, 0x644, 0x64a, 0x206, 0x645, 0x627, 0x206,
    0x645, 0x645, 0x206, 0x646, 0x631, 0x206, 0x646, 0x632,
    0x206, 0x646, 0x645, 0x206, 0x646, 0x646, 0x206, 0x646,
    0x649, 0x206, 0x646, 0x64a, 0x206, 0x649, 0x670, 0x206,
    0x64a, 0x631, 0x206, 0x64a, 0x632, 0x206, 0x64a, 0x645,
    0x206, 0x64a, 0x646, 0x206, 0x64a, 0x649, 0x206, 0x64a,
    0x64a, 0x204, 0x626, 0x62c, 0x204, 0x626, 0x62d, 0x204,
    0x626, 0x62e, 0x204, 0x626, 0x645, 0x204, 0x626, 0x647,
    0x204, 0x628, 0x62c, 0x204, 0x628, 0x62d, 0x204, 0x628,
    0x62e, 0x204, 0x628, 0x645, 0x204, 0x628, 0x647, 0x204,
    0x62a, 0x62c, 0x204, 0x62a, 0x62d, 0x204, 0x62a, 0x62e,
    0x204, 0x62a, 0x645, 0x204, 0x62a, 0x647, 0x204, 0x62b,
    0x645, 0x204, 0x62c, 0x62d, 0x204, 0x62c, 0x645, 0x204,
    0x62d, 0x62c, 0x204, 0x62d, 0x645, 0x204, 0x62e, 0x62c,
    0x204, 0x62e, 0x645, 0x204, 0x633, 0x62c, 0x204, 0x633,
    0x62d, 0x204, 0x633, 0x62e, 0x204, 0x633, 0x645, 0x204,
    0x635, 0x62d, 0x204, 0x635, 0x62e, 0x204, 0x635, 0x645,
    0x204, 0x636, 0x62c, 0x204, 0x636, 0x62d, 0x204, 0x636,
    0x62e, 0x204, 0x636, 0x645, 0x204, 0x637, 0x62d, 0x204,
    0x638, 0x645, 0x204, 0x639, 0x62c, 0x204, 0x639, 0x645,
    0x204, 0x63a, 0x62c, 0x204, 0x63a, 0x645, 0x204, 0x641,
    0x62c, 0x204, 0x641, 0x62d, 0x204, 0x641, 0x62e, 0x204,
    0x641, 0x645, 0x204, 0x642, 0x62d, 0x204, 0x642, 0x645,
    0x204, 0x643, 0x62c, 0x204, 0x643, 0x62d, 0x204, 0x643,
    0x62e, 0x204, 0x643, 0x644, 0x204, 0x643, 0x645, 0x204,
    0x644, 0x62c, 0x204, 0x644, 0x62d, 0x204, 0x644, 0x62e,
    0x204, 0x644, 0x645, 0x204, 0x644, 0x647, 0x204, 0x645,
    0x62c, 0x204, 0x645, 0x62d, 0x204, 0x645, 0x62e, 0x204,
    0x645, 0x645, 0x204, 0x646, 0x62c, 0x204, 0x646, 0x62d,
    0x204, 0x646, 0x62e, 0x204, 0x646, 0x645, 0x204, 0x646,
    0x647, 0x204, 0x647, 0x62c, 0x204, 0x647, 0x645, 0x204,
    0x647, 0x670, 0x204, 0x64a, 0x62c, 0x204, 0x64a, 0x62d,
    0x204, 0x64a, 0x62e, 0x204, 0x64a, 0x645, 0x204, 0x64a,
    0x647, 0x205, 0x626, 0x645, 0x205, 0x626, 0x647, 0x205,
    0x628, 0x645, 0x205, 0x628, 0x647, 0x205, 0x62a, 0x645,
    0x205, 0x62a, 0x647, 0x205, 0x62b, 0x645, 0x205, 0x62b,
    0x647, 0x205, 0x633, 0x645, 0x205, 0x633, 0x647, 0x205,
    0x634, 0x645, 0x205, 0x634, 0x647, 0x205, 0x643, 0x644,
    0x205, 0x643, 0x645, 0x205, 0x644, 0x645, 0x205, 0x646,
    0x645, 0x205, 0x646, 0x647, 0x205, 0x64a, 0x645, 0x205,
    0x64a, 0x647, 0x305, 0x640, 0x64e, 0x651, 0x305, 0x640,
    0x64f, 0x651, 0x305, 0x640, 0x650, 0x651, 0x207, 0x637,
    0x649, 0x207, 0x637, 0x64a, 0x207, 0x639, 0x649, 0x207,
    0x639, 0x64a, 0x207, 0x63a, 0x649, 0x207, 0x63a, 0x64a,
    0x207, 0x633, 0x649, 0x207, 0x633, 0x64a, 0x207, 0x634,
    0x649, 0x207, 0x634, 0x64a, 0x207, 0x62d, 0x649, 0x207,
    0x62d, 0x64a, 0x207, 0x62c, 0x649, 0x207, 0x62c, 0x64a,
    0x207, 0x62e, 0x649, 0x207, 0x62e, 0x64a, 0x207, 0x635,
    0x649, 0x207, 0x635, 0x64a, 0x207, 0x636, 0x649, 0x207,
    0x636, 0x64a, 0x207, 0x634, 0x62c, 0x207, 0x634, 0x62d,
    0x207, 0x634, 0x62e, 0x207, 0x634, 0x645, 0x207, 0x634,
    0x631, 0x207, 0x633, 0x631, 0x207, 0x635, 0x631, 0x207,
    0x636, 0x631, 0x206, 0x637, 0x649, 0x206, 0x637, 0x64a,
    0x206, 0x639, 0x649, 0x206, 0x639, 0x64a, 0x206, 0x63a,
    0x649, 0x206, 0x63a, 0x64a, 0x206, 0x633, 0x649, 0x206,
    0x633, 0x64a, 0x206, 0x634, 0x649, 0x206, 0x634, 0x64a,
    0x206, 0x62d, 0x649, 0x206, 0x62d, 0x64a, 0x206, 0x62c,
    0x649, 0x206, 0x62c, 0x64a, 0x206, 0x62e, 0x649, 0x206,
    0x62e, 0x64a, 0x206, 0x635, 0x649, 0x206, 0x635, 0x64a,
    0x206, 0x636, 0x649, 0x206, 0x636, 0x64a, 0x206, 0x634,
    0x62c, 0x206, 0x634, 0x62d, 0x206, 0x634, 0x62e, 0x206,
    0x634, 0x645, 0x206, 0x634, 0x631, 0x206, 0x633, 0x631,
    0x206, 0x635, 0x631, 0x206, 0x636, 0x631, 0x204, 0x634,
    0x62c, 0x204, 0x634, 0x62d, 0x204, 0x634, 0x62e, 0x204,
    0x634, 0x645, 0x204, 0x633, 0x647, 0x204, 0x634, 0x647,
    0x204, 0x637, 0x645, 0x205, 0x633, 0x62c, 0x205, 0x633,
    0x62d, 0x205, 0x633, 0x62e, 0x205, 0x634, 0x62c, 0x205,
    0x634, 0x62d, 0x205, 0x634, 0x62e, 0x205, 0x637, 0x645,
    0x205, 0x638, 0x645, 0x206, 0x627, 0x64b, 0x207, 0x627,
    0x64b, 0x304, 0x62a, 0x62c, 0x645, 0x306, 0x62a, 0x62d,
    0x62c, 0x304, 0x62a, 0x62d, 0x62c, 0x304, 0x62a, 0x62d,
    0x645, 0x304, 0x62a, 0x62e, 0x645, 0x304, 0x62a, 0x645,
    0x62c, 0x304, 0x62a, 0x645, 0x62d, 0x304, 0x62a, 0x645,
    0x62e, 0x306, 0x62c, 0x645, 0x62d, 0x304, 0x62c, 0x645,
    0x62d, 0x306, 0x62d, 0x645, 0x64a, 0x306, 0x62d, 0x645,
    0x649, 0x304, 0x633, 0x62d, 0x62c, 0x304, 0x633, 0x62c,
    0x62d, 0x306, 0x633, 0x62c, 0x649, 0x306, 0x633, 0x645,
    0x62d, 0x304, 0x633, 0x645, 0x62d, 0x304, 0x633, 0x645,
    0x62c, 0x306, 0x633, 0x645, 0x645, 0x304, 0x633, 0x645,
    0x645, 0x306, 0x635, 0x62d, 0x62d, 0x304, 0x635, 0x62d,
    0x62d, 0x306, 0x635, 0x645, 0x645, 0x306, 0x634, 0x62d,
    0x645, 0x304, 0x634, 0x62d, 0x645, 0x306, 0x634, 0x62c,
    0x64a, 0x306, 0x634, 0x645, 0x62e, 0x304, 0x634, 0x645,
    0x62e, 0x306, 0x634, 0x645, 0x645, 0x304, 0x634, 0x645,
    0x645, 0x306, 0x636, 0x62d, 0x649, 0x306, 0x636, 0x62e,
    0x645, 0x304, 0x636, 0x62e, 0x645, 0x306, 0x637, 0x645,
    0x62d, 0x304, 0x637, 0x645, 0x62d, 0x304, 0x637, 0x645,
    0x645, 0x306, 0x637, 0x645, 0x64a, 0x306, 0x639, 0x62c,
    0x645, 0x306, 0x639, 0x645, 0x645, 0x304, 0x639, 0x645,
    0x645, 0x306, 0x639, 0x645, 0x649, 0x306, 0x63a, 0x645,
    0x645, 0x306, 0x63a, 0x645, 0x64a, 0x306, 0x63a, 0x645,
    0x649, 0x306, 0x641, 0x62e, 0x645, 0x304, 0x641, 0x62e,
    0x645, 0x306, 0x642, 0x645, 0x62d, 0x306, 0x642, 0x645,
    0x645, 0x306, 0x644, 0x62d, 0x645, 0x306, 0x644, 0x62d,
    0x64a, 0x306, 0x644, 0x62d, 0x649, 0x304, 0x644, 0x62c,
    0x62c, 0x306, 0x644, 0x62c, 0x62c, 0x306, 0x644, 0x62e,
    0x645, 0x304, 0x644, 0x62e, 0x645, 0x306, 0x644, 0x645,
    0x62d, 0x304, 0x644, 0x645, 0x62d, 0x304, 0x645, 0x62d,
    0x62c, 0x304, 0x645, 0x62d, 0x645, 0x306, 0x645, 0x62d,
    0x64a, 0x304, 0x645, 0x62c, 0x62d, 0x304, 0x645, 0x62c,
    0x645, 0x304, 0x645, 0x62e, 0x62c, 0x304, 0x645, 0x62e,
    0x645, 0x304, 0x645, 0x62c, 0x62e, 0x304, 0x647, 0x645,
    0x62c, 0x304, 0x647, 0x645, 0x645, 0x304, 0x646, 0x62d,
    0x645, 0x306, 0x646, 0x62d, 0x649, 0x306, 0x646, 0x62c,
    0x645, 0x304, 0x646, 0x62c, 0x645, 0x306, 0x646, 0x62c,
    0x649, 0x306, 0x646, 0x645, 0x64a, 0x306, 0x646, 0x645,
    0x649, 0x306, 0x64a, 0x645, 0x645, 0x304, 0x64a, 0x645,
    0x645, 0x306, 0x628, 0x62e, 0x64a, 0x306, 0x62a, 0x62c,
    0x64a, 0x306, 0x62a, 0x62c, 0x649, 0x306, 0x62a, 0x62e,
    0x64a, 0x306, 0x62a, 0x62e, 0x649, 0x306, 0x62a, 0x645,
    0x64a, 0x306, 0x62a, 0x645, 0x649, 0x306, 0x62c, 0x645,
    0x64a, 0x306, 0x62c, 0x62d, 0x649, 0x306, 0x62c, 0x645,
    0x649, 0x306, 0x633, 0x62e, 0x649, 0x306, 0x635, 0x62d,
    0x64a, 0x306, 0x634, 0x62d, 0x64a, 0x306, 0x636, 0x62d,
    0x64a, 0x306, 0x644, 0x62c, 0x64a, 0x306, 0x644, 0x645,
    0x64a, 0x306, 0x64a, 0x62d, 0x64a, 0x306, 0x64a, 0x62c,
    0x64a, 0x306, 0x64a, 0x645, 0x64a, 0x306, 0x645, 0x645,
    0x64a, 0x306, 0x642, 0x645, 0x64a, 0x306, 0x646, 0x62d,
    0x64a, 0x304, 0x642, 0x645, 0x62d, 0x304, 0x644, 0x62d,
    0x645, 0x306, 0x639, 0x645, 0x64a, 0x306, 0x643, 0x645,
    0x64a, 0x304, 0x646, 0x62c, 0x62d, 0x306, 0x645, 0x62e,
    0x64a, 0x304, 0x644, 0x62c, 0x645, 0x306, 0x643, 0x645,
    0x645, 0x306, 0x644, 0x62c, 0x645, 0x306, 0x646, 0x62c,
    0x62d, 0x306, 0x62c, 0x62d, 0x64a, 0x306, 0x62d, 0x62c,
    0x64a, 0x306, 0x645, 0x62c, 0x64a, 0x306, 0x641, 0x645,
    0x64a, 0x306, 0x628, 0x62d, 0x64a, 0x304, 0x643, 0x645,
    0x645, 0x304, 0x639, 0x62c, 0x645, 0x304, 0x635, 0x645,
    0x645, 0x306, 0x633, 0x62e, 0x64a, 0x306, 0x646, 0x62c,
    0x64a, 0x307, 0x635, 0x644, 0x6d2, 0x307, 0x642, 0x644,
    0x6d2, 0x407, 0x627, 0x644, 0x644, 0x647, 0x407, 0x627,
    0x643, 0x628, 0x631, 0x407, 0x645, 0x62d, 0x645, 0x62f,
    0x407, 0x635, 0x644, 0x639, 0x645, 0x407, 0x631, 0x633,
    0x648, 0x644, 0x407, 0x639, 0x644, 0x64a, 0x647, 0x407,
    0x648, 0x633, 0x644, 0x645, 0x307, 0x635, 0x644, 0x649,
    0x1207, 0x635, 0x644, 0x649, 0x20, 0x627, 0x644, 0x644,
    0x647, 0x20, 0x639, 0x644, 0x64a, 0x647, 0x20, 0x648,
    0x633, 0x644, 0x645, 0x807, 0x62c, 0x644, 0x20, 0x62c,
    0x644, 0x627, 0x644, 0x647, 0x407, 0x631, 0x6cc, 0x627,
    0x644, 0x10b, 0x2c, 0x10b, 0x3001, 0x10b, 0x3002, 0x10b,
    0x3a, 0x10b, 0x3b, 0x10b, 0x21, 0x10b, 0x3f, 0x10b,
    0x3016, 0x10b, 0x3017, 0x10b, 0x2026, 0x10b, 0x2025, 0x10b,
    0x2014, 0x10b, 0x2013, 0x10b, 0x5f, 0x10b, 0x5f, 0x10b,
    0x28, 0x10b, 0x29, 0x10b, 0x7b, 0x10b, 0x7d, 0x10b,
    0x3014, 0x10b, 0x3015, 0x10b, 0x3010, 0x10b, 0x3011, 0x10b,
    0x300a, 0x10b, 0x300b, 0x10b, 0x3008, 0x10b, 0x3009, 0x10b,
    0x300c, 0x10b, 0x300d, 0x10b, 0x300e, 0x10b, 0x300f, 0x10b,
    0x5b, 0x10b, 0x5d, 0x110, 0x203e, 0x110, 0x203e, 0x110,
    0x203e, 0x110, 0x203e, 0x110, 0x5f, 0x110, 0x5f, 0x110,
    0x5f, 0x10e, 0x2c, 0x10e, 0x3001, 0x10e, 0x2e, 0x10e,
    0x3b, 0x10e, 0x3a, 0x10e, 0x3f, 0x10e, 0x21, 0x10e,
    0x2014, 0x10e, 0x28, 0x10e, 0x29, 0x10e, 0x7b, 0x10e,
    0x7d, 0x10e, 0x3014, 0x10e, 0x3015, 0x10e, 0x23, 0x10e,
    0x26, 0x10e, 0x2a, 0x10e, 0x2b, 0x10e, 0x2d, 0x10e,
    0x3c, 0x10e, 0x3e, 0x10e, 0x3d, 0x10e, 0x5c, 0x10e,
    0x24, 0x10e, 0x25, 0x10e, 0x40, 0x207, 0x20, 0x64b,
    0x205, 0x640, 0x64b, 0x207, 0x20, 0x64c, 0x207, 0x20,
    0x64d, 0x207, 0x20, 0x64e, 0x205, 0x640, 0x64e, 0x207,
    0x20, 0x64f, 0x205, 0x640, 0x64f, 0x207, 0x20, 0x650,
    0x205, 0x640, 0x650, 0x207, 0x20, 0x651, 0x205, 0x640,
    0x651, 0x207, 0x20, 0x652, 0x205, 0x640, 0x652, 0x107,
    0x621, 0x107, 0x622, 0x106, 0x622, 0x107, 0x623, 0x106,
    0x623, 0x107, 0x624, 0x106, 0x624, 0x107, 0x625, 0x106,
    0x625, 0x107, 0x626, 0x106, 0x626, 0x104, 0x626, 0x105,
    0x626, 0x107, 0x627, 0x106, 0x627, 0x107, 0x628, 0x106,
    0x628, 0x104, 0x628, 0x105, 0x628, 0x107, 0x629, 0x106,
    0x629, 0x107, 0x62a, 0x106, 0x62a, 0x104, 0x62a, 0x105,
    0x62a, 0x107, 0x62b, 0x106, 0x62b, 0x104, 0x62b, 0x105,
    0x62b, 0x107, 0x62c, 0x106, 0x62c, 0x104, 0x62c, 0x105,
    0x62c, 0x107, 0x62d, 0x106, 0x62d, 0x104, 0x62d, 0x105,
    0x62d, 0x107, 0x62e, 0x106, 0x62e, 0x104, 0x62e, 0x105,
    0x62e, 0x107, 0x62f, 0x106, 0x62f, 0x107, 0x630, 0x106,
    0x630, 0x107, 0x631, 0x106, 0x631, 0x107, 0x632, 0x106,
    0x632, 0x107, 0x633, 0x106, 0x633, 0x104, 0x633, 0x105,
    0x633, 0x107, 0x634, 0x106, 0x634, 0x104, 0x634, 0x105,
    0x634, 0x107, 0x635, 0x106, 0x635, 0x104, 0x635, 0x105,
    0x635, 0x107, 0x636, 0x106, 0x636, 0x104, 0x636, 0x105,
    0x636, 0x107, 0x637, 0x106, 0x637, 0x104, 0x637, 0x105,
    0x637, 0x107, 0x638, 0x106, 0x638, 0x104, 0x638, 0x105,
    0x638, 0x107, 0x639, 0x106, 0x639, 0x104, 0x639, 0x105,
    0x639, 0x107, 0x63a, 0x106, 0x63a, 0x104, 0x63a, 0x105,
    0x63a, 0x107, 0x641, 0x106, 0x641, 0x104, 0x641, 0x105,
    0x641, 0x107, 0x642, 0x106, 0x642, 0x104, 0x642, 0x105,
    0x642, 0x107, 0x643, 0x106, 0x643, 0x104, 0x643, 0x105,
    0x643, 0x107, 0x644, 0x106, 0x644, 0x104, 0x644, 0x105,
    0x644, 0x107, 0x645, 0x106, 0x645, 0x104, 0x645, 0x105,
    0x645, 0x107, 0x646, 0x106, 0x646, 0x104, 0x646, 0x105,
    0x646, 0x107, 0x647, 0x106, 0x647, 0x104, 0x647, 0x105,
    0x647, 0x107, 0x648, 0x106, 0x648, 0x107, 0x649, 0x106,
    0x649, 0x107, 0x64a, 0x106, 0x64a, 0x104, 0x64a, 0x105,
    0x64a, 0x207, 0x644, 0x622, 0x206, 0x644, 0x622, 0x207,
    0x644, 0x623, 0x206, 0x644, 0x623, 0x207, 0x644, 0x625,
    0x206, 0x644, 0x625, 0x207, 0x644, 0x627, 0x206, 0x644,
    0x627, 0x10c, 0x21, 0x10c, 0x22, 0x10c, 0x23, 0x10c,
    0x24, 0x10c, 0x25, 0x10c, 0x26, 0x10c, 0x27, 0x10c,
    0x28, 0x10c, 0x29, 0x10c, 0x2a, 0x10c, 0x2b, 0x10c,
    0x2c, 0x10c, 0x2d, 0x10c, 0x2e, 0x10c, 0x2f, 0x10c,
    0x30, 0x10c, 0x31, 0x10c, 0x32, 0x10c, 0x33, 0x10c,
    0x34, 0x10c, 0x35, 0x10c, 0x36, 0x10c, 0x37, 0x10c,
    0x38, 0x10c, 0x39, 0x10c, 0x3a, 0x10c, 0x3b, 0x10c,
    0x3c, 0x10c, 0x3d, 0x10c, 0x3e, 0x10c, 0x3f, 0x10c,
    0x40, 0x10c, 0x41, 0x10c, 0x42, 0x10c, 0x43, 0x10c,
    0x44, 0x10c, 0x45, 0x10c, 0x46, 0x10c, 0x47, 0x10c,
    0x48, 0x10c, 0x49, 0x10c, 0x4a, 0x10c, 0x4b, 0x10c,
    0x4c, 0x10c, 0x4d, 0x10c, 0x4e, 0x10c, 0x4f, 0x10c,
    0x50, 0x10c, 0x51, 0x10c, 0x52, 0x10c, 0x53, 0x10c,
    0x54, 0x10c, 0x55, 0x10c, 0x56, 0x10c, 0x57, 0x10c,
    0x58, 0x10c, 0x59, 0x10c, 0x5a, 0x10c, 0x5b, 0x10c,
    0x5c, 0x10c, 0x5d, 0x10c, 0x5e, 0x10c, 0x5f, 0x10c,
    0x60, 0x10c, 0x61, 0x10c, 0x62, 0x10c, 0x63, 0x10c,
    0x64, 0x10c, 0x65, 0x10c, 0x66, 0x10c, 0x67, 0x10c,
    0x68, 0x10c, 0x69, 0x10c, 0x6a, 0x10c, 0x6b, 0x10c,
    0x6c, 0x10c, 0x6d, 0x10c, 0x6e, 0x10c, 0x6f, 0x10c,
    0x70, 0x10c, 0x71, 0x10c, 0x72, 0x10c, 0x73, 0x10c,
    0x74, 0x10c, 0x75, 0x10c, 0x76, 0x10c, 0x77, 0x10c,
    0x78, 0x10c, 0x79, 0x10c, 0x7a, 0x10c, 0x7b, 0x10c,
    0x7c, 0x10c, 0x7d, 0x10c, 0x7e, 0x10c, 0x2985, 0x10c,
    0x2986, 0x10d, 0x3002, 0x10d, 0x300c, 0x10d, 0x300d, 0x10d,
    0x3001, 0x10d, 0x30fb, 0x10d, 0x30f2, 0x10d, 0x30a1, 0x10d,
    0x30a3, 0x10d, 0x30a5, 0x10d, 0x30a7, 0x10d, 0x30a9, 0x10d,
    0x30e3, 0x10d, 0x30e5, 0x10d, 0x30e7, 0x10d, 0x30c3, 0x10d,
    0x30fc, 0x10d, 0x30a2, 0x10d, 0x30a4, 0x10d, 0x30a6, 0x10d,
    0x30a8, 0x10d, 0x30aa, 0x10d, 0x30ab, 0x10d, 0x30ad, 0x10d,
    0x30af, 0x10d, 0x30b1, 0x10d, 0x30b3, 0x10d, 0x30b5, 0x10d,
    0x30b7, 0x10d, 0x30b9, 0x10d, 0x30bb, 0x10d, 0x30bd, 0x10d,
    0x30bf, 0x10d, 0x30c1, 0x10d, 0x30c4, 0x10d, 0x30c6, 0x10d,
    0x30c8, 0x10d, 0x30ca, 0x10d, 0x30cb, 0x10d, 0x30cc, 0x10d,
    0x30cd, 0x10d, 0x30ce, 0x10d, 0x30cf, 0x10d, 0x30d2, 0x10d,
    0x30d5, 0x10d, 0x30d8, 0x10d, 0x30db, 0x10d, 0x30de, 0x10d,
    0x30df, 0x10d, 0x30e0, 0x10d, 0x30e1, 0x10d, 0x30e2, 0x10d,
    0x30e4, 0x10d, 0x30e6, 0x10d, 0x30e8, 0x10d, 0x30e9, 0x10d,
    0x30ea, 0x10d, 0x30eb, 0x10d, 0x30ec, 0x10d, 0x30ed, 0x10d,
    0x30ef, 0x10d, 0x30f3, 0x10d, 0x3099, 0x10d, 0x309a, 0x10d,
    0x3164, 0x10d, 0x3131, 0x10d, 0x3132, 0x10d, 0x3133, 0x10d,
    0x3134, 0x10d, 0x3135, 0x10d, 0x3136, 0x10d, 0x3137, 0x10d,
    0x3138, 0x10d, 0x3139, 0x10d, 0x313a, 0x10d, 0x313b, 0x10d,
    0x313c, 0x10d, 0x313d, 0x10d, 0x313e, 0x10d, 0x313f, 0x10d,
    0x3140, 0x10d, 0x3141, 0x10d, 0x3142, 0x10d, 0x3143, 0x10d,
    0x3144, 0x10d, 0x3145, 0x10d, 0x3146, 0x10d, 0x3147, 0x10d,
    0x3148, 0x10d, 0x3149, 0x10d, 0x314a, 0x10d, 0x314b, 0x10d,
    0x314c, 0x10d, 0x314d, 0x10d, 0x314e, 0x10d, 0x314f, 0x10d,
    0x3150, 0x10d, 0x3151, 0x10d, 0x3152, 0x10d, 0x3153, 0x10d,
    0x3154, 0x10d, 0x3155, 0x10d, 0x3156, 0x10d, 0x3157, 0x10d,
    0x3158, 0x10d, 0x3159, 0x10d, 0x315a, 0x10d, 0x315b, 0x10d,
    0x315c, 0x10d, 0x315d, 0x10d, 0x315e, 0x10d, 0x315f, 0x10d,
    0x3160, 0x10d, 0x3161, 0x10d, 0x3162, 0x10d, 0x3163, 0x10c,
    0xa2, 0x10c, 0xa3, 0x10c, 0xac, 0x10c, 0xaf, 0x10c,
    0xa6, 0x10c, 0xa5, 0x10c, 0x20a9, 0x10d, 0x2502, 0x10d,
    0x2190, 0x10d, 0x2191, 0x10d, 0x2192, 0x10d, 0x2193, 0x10d,
    0x25a0, 0x10d, 0x25cb, 0x401, 0xd804, 0xdc99, 0xd804, 0xdcba,
    0x401, 0xd804, 0xdc9b, 0xd804, 0xdcba, 0x401, 0xd804, 0xdca5,
    0xd804, 0xdcba, 0x401, 0xd804, 0xdd31, 0xd804, 0xdd27, 0x401,
    0xd804, 0xdd32, 0xd804, 0xdd27, 0x401, 0xd804, 0xdf47, 0xd804,
    0xdf3e, 0x401, 0xd804, 0xdf47, 0xd804, 0xdf57, 0x401, 0xd805,
    0xdcb9, 0xd805, 0xdcba, 0x401, 0xd805, 0xdcb9, 0xd805, 0xdcb0,
    0x401, 0xd805, 0xdcb9, 0xd805, 0xdcbd, 0x401, 0xd805, 0xddb8,
    0xd805, 0xddaf, 0x401, 0xd805, 0xddb9, 0xd805, 0xddaf, 0x401,
    0xd806, 0xdd35, 0xd806, 0xdd30, 0x401, 0xd834, 0xdd57, 0xd834,
    0xdd65, 0x401, 0xd834, 0xdd58, 0xd834, 0xdd65, 0x401, 0xd834,
    0xdd5f, 0xd834, 0xdd6e, 0x401, 0xd834, 0xdd5f, 0xd834, 0xdd6f,
    0x401, 0xd834, 0xdd5f, 0xd834, 0xdd70, 0x401, 0xd834, 0xdd5f,
    0xd834, 0xdd71, 0x401, 0xd834, 0xdd5f, 0xd834, 0xdd72, 0x401,
    0xd834, 0xddb9, 0xd834, 0xdd65, 0x401, 0xd834, 0xddba, 0xd834,
    0xdd65, 0x401, 0xd834, 0xddbb, 0xd834, 0xdd6e, 0x401, 0xd834,
    0xddbc, 0xd834, 0xdd6e, 0x401, 0xd834, 0xddbb, 0xd834, 0xdd6f,
    0x401, 0xd834, 0xddbc, 0xd834, 0xdd6f, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x43, 0x102,
    0x44, 0x102, 0x47, 0x102, 0x4a, 0x102, 0x4b, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x66, 0x102, 0x68, 0x102, 0x69, 0x102, 0x6a, 0x102,
    0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102,
    0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102,
    0x51, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x44, 0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102,
    0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102,
    0x4d, 0x102, 0x4f, 0x102, 0x53, 0x102, 0x54, 0x102,
    0x55, 0x102, 0x56, 0x102, 0x57, 0x102, 0x58, 0x102,
    0x59, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x41, 0x102,
    0x42, 0x102, 0x43, 0x102, 0x44, 0x102, 0x45, 0x102,
    0x46, 0x102, 0x47, 0x102, 0x48, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x52, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x5a, 0x102, 0x61, 0x102, 0x62, 0x102, 0x63, 0x102,
    0x64, 0x102, 0x65, 0x102, 0x66, 0x102, 0x67, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102,
    0x70, 0x102, 0x71, 0x102, 0x72, 0x102, 0x73, 0x102,
    0x74, 0x102, 0x75, 0x102, 0x76, 0x102, 0x77, 0x102,
    0x78, 0x102, 0x79, 0x102, 0x7a, 0x102, 0x131, 0x102,
    0x237, 0x102, 0x391, 0x102, 0x392, 0x102, 0x393, 0x102,
    0x394, 0x102, 0x395, 0x102, 0x396, 0x102, 0x397, 0x102,
    0x398, 0x102, 0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102,
    0x39c, 0x102, 0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102,
    0x3a0, 0x102, 0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102,
    0x3a4, 0x102, 0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102,
    0x3a8, 0x102, 0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102,
    0x3b2, 0x102, 0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102,
    0x3b6, 0x102, 0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102,
    0x3ba, 0x102, 0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102,
    0x3be, 0x102, 0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102,
    0x3c2, 0x102, 0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102,
    0x3c6, 0x102, 0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102,
    0x2202, 0x102, 0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102,
    0x3d5, 0x102, 0x3f1, 0x102, 0x3d6, 0x102, 0x391, 0x102,
    0x392, 0x102, 0x393, 0x102, 0x394, 0x102, 0x395, 0x102,
    0x396, 0x102, 0x397, 0x102, 0x398, 0x102, 0x399, 0x102,
    0x39a, 0x102, 0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102,
    0x39e, 0x102, 0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102,
    0x3f4, 0x102, 0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102,
    0x3a6, 0x102, 0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102,
    0x2207, 0x102, 0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102,
    0x3b4, 0x102, 0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102,
    0x3b8, 0x102, 0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102,
    0x3bc, 0x102, 0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102,
    0x3c0, 0x102, 0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102,
    0x3c4, 0x102, 0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102,
    0x3c8, 0x102, 0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102,
    0x3d1, 0x102, 0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102,
    0x3d6, 0x102, 0x391, 0x102, 0x392, 0x102, 0x393, 0x102,
    0x394, 0x102, 0x395, 0x102, 0x396, 0x102, 0x397, 0x102,
    0x398, 0x102, 0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102,
    0x39c, 0x102, 0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102,
    0x3a0, 0x102, 0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102,
    0x3a4, 0x102, 0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102,
    0x3a8, 0x102, 0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102,
    0x3b2, 0x102, 0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102,
    0x3b6, 0x102, 0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102,
    0x3ba, 0x102, 0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102,
    0x3be, 0x102, 0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102,
    0x3c2, 0x102, 0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102,
    0x3c6, 0x102, 0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102,
    0x2202, 0x102, 0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102,
    0x3d5, 0x102, 0x3f1, 0x102, 0x3d6, 0x102, 0x391, 0x102,
    0x392, 0x102, 0x393, 0x102, 0x394, 0x102, 0x395, 0x102,
    0x396, 0x102, 0x397, 0x102, 0x398, 0x102, 0x399, 0x102,
    0x39a, 0x102, 0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102,
    0x39e, 0x102, 0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102,
    0x3f4, 0x102, 0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102,
    0x3a6, 0x102, 0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102,
    0x2207, 0x102, 0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102,
    0x3b4, 0x102, 0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102,
    0x3b8, 0x102, 0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102,
    0x3bc, 0x102, 0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102,
    0x3c0, 0x102, 0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102,
    0x3c4, 0x102, 0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102,
    0x3c8, 0x102, 0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102,
    0x3d1, 0x102, 0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102,
    0x3d6, 0x102, 0x391, 0x102, 0x392, 0x102, 0x393, 0x102,
    0x394, 0x102, 0x395, 0x102, 0x396, 0x102, 0x397, 0x102,
    0x398, 0x102, 0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102,
    0x39c, 0x102, 0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102,
    0x3a0, 0x102, 0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102,
    0x3a4, 0x102, 0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102,
    0x3a8, 0x102, 0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102,
    0x3b2, 0x102, 0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102,
    0x3b6, 0x102, 0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102,
    0x3ba, 0x102, 0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102,
    0x3be, 0x102, 0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102,
    0x3c2, 0x102, 0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102,
    0x3c6, 0x102, 0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102,
    0x2202, 0x102, 0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102,
    0x3d5, 0x102, 0x3f1, 0x102, 0x3d6, 0x102, 0x3dc, 0x102,
    0x3dd, 0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102,
    0x33, 0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102,
    0x37, 0x102, 0x38, 0x102, 0x39, 0x102, 0x30, 0x102,
    0x31, 0x102, 0x32, 0x102, 0x33, 0x102, 0x34, 0x102,
    0x35, 0x102, 0x36, 0x102, 0x37, 0x102, 0x38, 0x102,
    0x39, 0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102,
    0x33, 0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102,
    0x37, 0x102, 0x38, 0x102, 0x39, 0x102, 0x30, 0x102,
    0x31, 0x102, 0x32, 0x102, 0x33, 0x102, 0x34, 0x102,
    0x35, 0x102, 0x36, 0x102, 0x37, 0x102, 0x38, 0x102,
    0x39, 0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102,
    0x33, 0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102,
    0x37, 0x102, 0x38, 0x102, 0x39, 0x102, 0x627, 0x102,
    0x628, 0x102, 0x62c, 0x102, 0x62f, 0x102, 0x648, 0x102,
    0x632, 0x102, 0x62d, 0x102, 0x637, 0x102, 0x64a, 0x102,
    0x643, 0x102, 0x644, 0x102, 0x645, 0x102, 0x646, 0x102,
    0x633, 0x102, 0x639, 0x102, 0x641, 0x102, 0x635, 0x102,
    0x642, 0x102, 0x631, 0x102, 0x634, 0x102, 0x62a, 0x102,
    0x62b, 0x102, 0x62e, 0x102, 0x630, 0x102, 0x636, 0x102,
    0x638, 0x102, 0x63a, 0x102, 0x66e, 0x102, 0x6ba, 0x102,
    0x6a1, 0x102, 0x66f, 0x102, 0x628, 0x102, 0x62c, 0x102,
    0x647, 0x102, 0x62d, 0x102, 0x64a, 0x102, 0x643, 0x102,
    0x644, 0x102, 0x645, 0x102, 0x646, 0x102, 0x633, 0x102,
    0x639, 0x102, 0x641, 0x102, 0x635, 0x102, 0x642, 0x102,
    0x634, 0x102, 0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102,
    0x636, 0x102, 0x63a, 0x102, 0x62c, 0x102, 0x62d, 0x102,
    0x64a, 0x102, 0x644, 0x102, 0x646, 0x102, 0x633, 0x102,
    0x639, 0x102, 0x635, 0x102, 0x642, 0x102, 0x634, 0x102,
    0x62e, 0x102, 0x636, 0x102, 0x63a, 0x102, 0x6ba, 0x102,
    0x66f, 0x102, 0x628, 0x102, 0x62c, 0x102, 0x647, 0x102,
    0x62d, 0x102, 0x637, 0x102, 0x64a, 0x102, 0x643, 0x102,
    0x645, 0x102, 0x646, 0x102, 0x633, 0x102, 0x639, 0x102,
    0x641, 0x102, 0x635, 0x102, 0x642, 0x102, 0x634, 0x102,
    0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102, 0x636, 0x102,
    0x638, 0x102, 0x63a, 0x102, 0x66e, 0x102, 0x6a1, 0x102,
    0x627, 0x102, 0x628, 0x102, 0x62c, 0x102, 0x62f, 0x102,
    0x647, 0x102, 0x648, 0x102, 0x632, 0x102, 0x62d, 0x102,
    0x637, 0x102, 0x64a, 0x102, 0x644, 0x102, 0x645, 0x102,
    0x646, 0x102, 0x633, 0x102, 0x639, 0x102, 0x641, 0x102,
    0x635, 0x102, 0x642, 0x102, 0x631, 0x102, 0x634, 0x102,
    0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102, 0x630, 0x102,
    0x636, 0x102, 0x638, 0x102, 0x63a, 0x102, 0x628, 0x102,
    0x62c, 0x102, 0x62f, 0x102, 0x648, 0x102, 0x632, 0x102,
    0x62d, 0x102, 0x637, 0x102, 0x64a, 0x102, 0x644, 0x102,
    0x645, 0x102, 0x646, 0x102, 0x633, 0x102, 0x639, 0x102,
    0x641, 0x102, 0x635, 0x102, 0x642, 0x102, 0x631, 0x102,
    0x634, 0x102, 0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102,
    0x630, 0x102, 0x636, 0x102, 0x638, 0x102, 0x63a, 0x210,
    0x30, 0x2e, 0x210, 0x30, 0x2c, 0x210, 0x31, 0x2c,
    0x210, 0x32, 0x2c, 0x210, 0x33, 0x2c, 0x210, 0x34,
    0x2c, 0x210, 0x35, 0x2c, 0x210, 0x36, 0x2c, 0x210,
    0x37, 0x2c, 0x210, 0x38, 0x2c, 0x210, 0x39, 0x2c,
    0x310, 0x28, 0x41, 0x29, 0x310, 0x28, 0x42, 0x29,
    0x310, 0x28, 0x43, 0x29, 0x310, 0x28, 0x44, 0x29,
    0x310, 0x28, 0x45, 0x29, 0x310, 0x28, 0x46, 0x29,
    0x310, 0x28, 0x47, 0x29, 0x310, 0x28, 0x48, 0x29,
    0x310, 0x28, 0x49, 0x29, 0x310, 0x28, 0x4a, 0x29,
    0x310, 0x28, 0x4b, 0x29, 0x310, 0x28, 0x4c, 0x29,
    0x310, 0x28, 0x4d, 0x29, 0x310, 0x28, 0x4e, 0x29,
    0x310, 0x28, 0x4f, 0x29, 0x310, 0x28, 0x50, 0x29,
    0x310, 0x28, 0x51, 0x29, 0x310, 0x28, 0x52, 0x29,
    0x310, 0x28, 0x53, 0x29, 0x310, 0x28, 0x54, 0x29,
    0x310, 0x28, 0x55, 0x29, 0x310, 0x28, 0x56, 0x29,
    0x310, 0x28, 0x57, 0x29, 0x310, 0x28, 0x58, 0x29,
    0x310, 0x28, 0x59, 0x29, 0x310, 0x28, 0x5a, 0x29,
    0x310, 0x3014, 0x53, 0x3015, 0x108, 0x43, 0x108, 0x52,
    0x208, 0x43, 0x44, 0x208, 0x57, 0x5a, 0x10f, 0x41,
    0x10f, 0x42, 0x10f, 0x43, 0x10f, 0x44, 0x10f, 0x45,
    0x10f, 0x46, 0x10f, 0x47, 0x10f, 0x48, 0x10f, 0x49,
    0x10f, 0x4a, 0x10f, 0x4b, 0x10f, 0x4c, 0x10f, 0x4d,
    0x10f, 0x4e, 0x10f, 0x4f, 0x10f, 0x50, 0x10f, 0x51,
    0x10f, 0x52, 0x10f, 0x53, 0x10f, 0x54, 0x10f, 0x55,
    0x10f, 0x56, 0x10f, 0x57, 0x10f, 0x58, 0x10f, 0x59,
    0x10f, 0x5a, 0x20f, 0x48, 0x56, 0x20f, 0x4d, 0x56,
    0x20f, 0x53, 0x44, 0x20f, 0x53, 0x53, 0x30f, 0x50,
    0x50, 0x56, 0x20f, 0x57, 0x43, 0x209, 0x4d, 0x43,
    0x209, 0x4d, 0x44, 0x209, 0x4d, 0x52, 0x20f, 0x44,
    0x4a, 0x20f, 0x307b, 0x304b, 0x20f, 0x30b3, 0x30b3, 0x10f,
    0x30b5, 0x10f, 0x624b, 0x10f, 0x5b57, 0x10f, 0x53cc, 0x10f,
    0x30c7, 0x10f, 0x4e8c, 0x10f, 0x591a, 0x10f, 0x89e3, 0x10f,
    0x5929, 0x10f, 0x4ea4, 0x10f, 0x6620, 0x10f, 0x7121, 0x10f,
    0x6599, 0x10f, 0x524d, 0x10f, 0x5f8c, 0x10f, 0x518d, 0x10f,
    0x65b0, 0x10f, 0x521d, 0x10f, 0x7d42, 0x10f, 0x751f, 0x10f,
    0x8ca9, 0x10f, 0x58f0, 0x10f, 0x5439, 0x10f, 0x6f14, 0x10f,
    0x6295, 0x10f, 0x6355, 0x10f, 0x4e00, 0x10f, 0x4e09, 0x10f,
    0x904a, 0x10f, 0x5de6, 0x10f, 0x4e2d, 0x10f, 0x53f3, 0x10f,
    0x6307, 0x10f, 0x8d70, 0x10f, 0x6253, 0x10f, 0x7981, 0x10f,
    0x7a7a, 0x10f, 0x5408, 0x10f, 0x6e80, 0x10f, 0x6709, 0x10f,
    0x6708, 0x10f, 0x7533, 0x10f, 0x5272, 0x10f, 0x55b6, 0x10f,
    0x914d, 0x310, 0x3014, 0x672c, 0x3015, 0x310, 0x3014, 0x4e09,
    0x3015, 0x310, 0x3014, 0x4e8c, 0x3015, 0x310, 0x3014, 0x5b89,
    0x3015, 0x310, 0x3014, 0x70b9, 0x3015, 0x310, 0x3014, 0x6253,
    0x3015, 0x310, 0x3014, 0x76d7, 0x3015, 0x310, 0x3014, 0x52dd,
    0x3015, 0x310, 0x3014, 0x6557, 0x3015, 0x108, 0x5f97, 0x108,
    0x53ef, 0x102, 0x30, 0x102, 0x31, 0x102, 0x32, 0x102,
    0x33, 0x102, 0x34, 0x102, 0x35, 0x102, 0x36, 0x102,
    0x37, 0x102, 0x38, 0x102, 0x39, 0x101, 0x4e3d, 0x101,
    0x4e38, 0x101, 0x4e41, 0x201, 0xd840, 0xdd22, 0x101, 0x4f60,
    0x101, 0x4fae, 0x101, 0x4fbb, 0x101, 0x5002, 0x101, 0x507a,
    0x101, 0x5099, 0x101, 0x50e7, 0x101, 0x50cf, 0x101, 0x349e,
    0x201, 0xd841, 0xde3a, 0x101, 0x514d, 0x101, 0x5154, 0x101,
    0x5164, 0x101, 0x5177, 0x201, 0xd841, 0xdd1c, 0x101, 0x34b9,
    0x101, 0x5167, 0x101, 0x518d, 0x201, 0xd841, 0xdd4b, 0x101,
    0x5197, 0x101, 0x51a4, 0x101, 0x4ecc, 0x101, 0x51ac, 0x101,
    0x51b5, 0x201, 0xd864, 0xdddf, 0x101, 0x51f5, 0x101, 0x5203,
    0x101, 0x34df, 0x101, 0x523b, 0x101, 0x5246, 0x101, 0x5272,
    0x101, 0x5277, 0x101, 0x3515, 0x101, 0x52c7, 0x101, 0x52c9,
    0x101, 0x52e4, 0x101, 0x52fa, 0x101, 0x5305, 0x101, 0x5306,
    0x101, 0x5317, 0x101, 0x5349, 0x101, 0x5351, 0x101, 0x535a,
    0x101, 0x5373, 0x101, 0x537d, 0x101, 0x537f, 0x101, 0x537f,
    0x101, 0x537f, 0x201, 0xd842, 0xde2c, 0x101, 0x7070, 0x101,
    0x53ca, 0x101, 0x53df, 0x201, 0xd842, 0xdf63, 0x101, 0x53eb,
    0x101, 0x53f1, 0x101, 0x5406, 0x101, 0x549e, 0x101, 0x5438,
    0x101, 0x5448, 0x101, 0x5468, 0x101, 0x54a2, 0x101, 0x54f6,
    0x101, 0x5510, 0x101, 0x5553, 0x101, 0x5563, 0x101, 0x5584,
    0x101, 0x5584, 0x101, 0x5599, 0x101, 0x55ab, 0x101, 0x55b3,
    0x101, 0x55c2, 0x101, 0x5716, 0x101, 0x5606, 0x101, 0x5717,
    0x101, 0x5651, 0x101, 0x5674, 0x101, 0x5207, 0x101, 0x58ee,
    0x101, 0x57ce, 0x101, 0x57f4, 0x101, 0x580d, 0x101, 0x578b,
    0x101, 0x5832, 0x101, 0x5831, 0x101, 0x58ac, 0x201, 0xd845,
    0xdce4, 0x101, 0x58f2, 0x101, 0x58f7, 0x101, 0x5906, 0x101,
    0x591a, 0x101, 0x5922, 0x101, 0x5962, 0x201, 0xd845, 0xdea8,
    0x201, 0xd845, 0xdeea, 0x101, 0x59ec, 0x101, 0x5a1b, 0x101,
    0x5a27, 0x101, 0x59d8, 0x101, 0x5a66, 0x101, 0x36ee, 0x101,
    0x36fc, 0x101, 0x5b08, 0x101, 0x5b3e, 0x101, 0x5b3e, 0x201,
    0xd846, 0xddc8, 0x101, 0x5bc3, 0x101, 0x5bd8, 0x101, 0x5be7,
    0x101, 0x5bf3, 0x201, 0xd846, 0xdf18, 0x101, 0x5bff, 0x101,
    0x5c06, 0x101, 0x5f53, 0x101, 0x5c22, 0x101, 0x3781, 0x101,
    0x5c60, 0x101, 0x5c6e, 0x101, 0x5cc0, 0x101, 0x5c8d, 0x201,
    0xd847, 0xdde4, 0x101, 0x5d43, 0x201, 0xd847, 0xdde6, 0x101,
    0x5d6e, 0x101, 0x5d6b, 0x101, 0x5d7c, 0x101, 0x5de1, 0x101,
    0x5de2, 0x101, 0x382f, 0x101, 0x5dfd, 0x101, 0x5e28, 0x101,
    0x5e3d, 0x101, 0x5e69, 0x101, 0x3862, 0x201, 0xd848, 0xdd83,
    0x101, 0x387c, 0x101, 0x5eb0, 0x101, 0x5eb3, 0x101, 0x5eb6,
    0x101, 0x5eca, 0x201, 0xd868, 0xdf92, 0x101, 0x5efe, 0x201,
    0xd848, 0xdf31, 0x201, 0xd848, 0xdf31, 0x101, 0x8201, 0x101,
    0x5f22, 0x101, 0x5f22, 0x101, 0x38c7, 0x201, 0xd84c, 0xdeb8,
    0x201, 0xd858, 0xddda, 0x101, 0x5f62, 0x101, 0x5f6b, 0x101,
    0x38e3, 0x101, 0x5f9a, 0x101, 0x5fcd, 0x101, 0x5fd7, 0x101,
    0x5ff9, 0x101, 0x6081, 0x101, 0x393a, 0x101, 0x391c, 0x101,
    0x6094, 0x201, 0xd849, 0xded4, 0x101, 0x60c7, 0x101, 0x6148,
    0x101, 0x614c, 0x101, 0x614e, 0x101, 0x614c, 0x101, 0x617a,
    0x101, 0x618e, 0x101, 0x61b2, 0x101, 0x61a4, 0x101, 0x61af,
    0x101, 0x61de, 0x101, 0x61f2, 0x101, 0x61f6, 0x101, 0x6210,
    0x101, 0x621b, 0x101, 0x625d, 0x101, 0x62b1, 0x101, 0x62d4,
    0x101, 0x6350, 0x201, 0xd84a, 0xdf0c, 0x101, 0x633d, 0x101,
    0x62fc, 0x101, 0x6368, 0x101, 0x6383, 0x101, 0x63e4, 0x201,
    0xd84a, 0xdff1, 0x101, 0x6422, 0x101, 0x63c5, 0x101, 0x63a9,
    0x101, 0x3a2e, 0x101, 0x6469, 0x101, 0x647e, 0x101, 0x649d,
    0x101, 0x6477, 0x101, 0x3a6c, 0x101, 0x654f, 0x101, 0x656c,
    0x201, 0xd84c, 0xdc0a, 0x101, 0x65e3, 0x101, 0x66f8, 0x101,
    0x6649, 0x101, 0x3b19, 0x101, 0x6691, 0x101, 0x3b08, 0x101,
    0x3ae4, 0x101, 0x5192, 0x101, 0x5195, 0x101, 0x6700, 0x101,
    0x669c, 0x101, 0x80ad, 0x101, 0x43d9, 0x101, 0x6717, 0x101,
    0x671b, 0x101, 0x6721, 0x101, 0x675e, 0x101, 0x6753, 0x201,
    0xd84c, 0xdfc3, 0x101, 0x3b49, 0x101, 0x67fa, 0x101, 0x6785,
    0x101, 0x6852, 0x101, 0x6885, 0x201, 0xd84d, 0xdc6d, 0x101,
    0x688e, 0x101, 0x681f, 0x101, 0x6914, 0x101, 0x3b9d, 0x101,
    0x6942, 0x101, 0x69a3, 0x101, 0x69ea, 0x101, 0x6aa8, 0x201,
    0xd84d, 0xdea3, 0x101, 0x6adb, 0x101, 0x3c18, 0x101, 0x6b21,
    0x201, 0xd84e, 0xdca7, 0x101, 0x6b54, 0x101, 0x3c4e, 0x101,
    0x6b72, 0x101, 0x6b9f, 0x101, 0x6bba, 0x101, 0x6bbb, 0x201,
    0xd84e, 0xde8d, 0x201, 0xd847, 0xdd0b, 0x201, 0xd84e, 0xdefa,
    0x101, 0x6c4e, 0x201, 0xd84f, 0xdcbc, 0x101, 0x6cbf, 0x101,
    0x6ccd, 0x101, 0x6c67, 0x101, 0x6d16, 0x101, 0x6d3e, 0x101,
    0x6d77, 0x101, 0x6d41, 0x101, 0x6d69, 0x101, 0x6d78, 0x101,
    0x6d85, 0x201, 0xd84f, 0xdd1e, 0x101, 0x6d34, 0x101, 0x6e2f,
    0x101, 0x6e6e, 0x101, 0x3d33, 0x101, 0x6ecb, 0x101, 0x6ec7,
    0x201, 0xd84f, 0xded1, 0x101, 0x6df9, 0x101, 0x6f6e, 0x201,
    0xd84f, 0xdf5e, 0x201, 0xd84f, 0xdf8e, 0x101, 0x6fc6, 0x101,
    0x7039, 0x101, 0x701e, 0x101, 0x701b, 0x101, 0x3d96, 0x101,
    0x704a, 0x101, 0x707d, 0x101, 0x7077, 0x101, 0x70ad, 0x201,
    0xd841, 0xdd25, 0x101, 0x7145, 0x201, 0xd850, 0xde63, 0x101,
    0x719c, 0x201, 0xd850, 0xdfab, 0x101, 0x7228, 0x101, 0x7235,
    0x101, 0x7250, 0x201, 0xd851, 0xde08, 0x101, 0x7280, 0x101,
    0x7295, 0x201, 0xd851, 0xdf35, 0x201, 0xd852, 0xdc14, 0x101,
    0x737a, 0x101, 0x738b, 0x101, 0x3eac, 0x101, 0x73a5, 0x101,
    0x3eb8, 0x101, 0x3eb8, 0x101, 0x7447, 0x101, 0x745c, 0x101,
    0x7471, 0x101, 0x7485, 0x101, 0x74ca, 0x101, 0x3f1b, 0x101,
    0x7524, 0x201, 0xd853, 0xdc36, 0x101, 0x753e, 0x201, 0xd853,
    0xdc92, 0x101, 0x7570, 0x201, 0xd848, 0xdd9f, 0x101, 0x7610,
    0x201, 0xd853, 0xdfa1, 0x201, 0xd853, 0xdfb8, 0x201, 0xd854,
    0xdc44, 0x101, 0x3ffc, 0x101, 0x4008, 0x101, 0x76f4, 0x201,
    0xd854, 0xdcf3, 0x201, 0xd854, 0xdcf2, 0x201, 0xd854, 0xdd19,
    0x201, 0xd854, 0xdd33, 0x101, 0x771e, 0x101, 0x771f, 0x101,
    0x771f, 0x101, 0x774a, 0x101, 0x4039, 0x101, 0x778b, 0x101,
    0x4046, 0x101, 0x4096, 0x201, 0xd855, 0xdc1d, 0x101, 0x784e,
    0x101, 0x788c, 0x101, 0x78cc, 0x101, 0x40e3, 0x201, 0xd855,
    0xde26, 0x101, 0x7956, 0x201, 0xd855, 0xde9a, 0x201, 0xd855,
    0xdec5, 0x101, 0x798f, 0x101, 0x79eb, 0x101, 0x412f, 0x101,
    0x7a40, 0x101, 0x7a4a, 0x101, 0x7a4f, 0x201, 0xd856, 0xdd7c,
    0x201, 0xd856, 0xdea7, 0x201, 0xd856, 0xdea7, 0x101, 0x7aee,
    0x101, 0x4202, 0x201, 0xd856, 0xdfab, 0x101, 0x7bc6, 0x101,
    0x7bc9, 0x101, 0x4227, 0x201, 0xd857, 0xdc80, 0x101, 0x7cd2,
    0x101, 0x42a0, 0x101, 0x7ce8, 0x101, 0x7ce3, 0x101, 0x7d00,
    0x201, 0xd857, 0xdf86, 0x101, 0x7d63, 0x101, 0x4301, 0x101,
    0x7dc7, 0x101, 0x7e02, 0x101, 0x7e45, 0x101, 0x4334, 0x201,
    0xd858, 0xde28, 0x201, 0xd858, 0xde47, 0x101, 0x4359, 0x201,
    0xd858, 0xded9, 0x101, 0x7f7a, 0x201, 0xd858, 0xdf3e, 0x101,
    0x7f95, 0x101, 0x7ffa, 0x101, 0x8005, 0x201, 0xd859, 0xdcda,
    0x201, 0xd859, 0xdd23, 0x101, 0x8060, 0x201, 0xd859, 0xdda8,
    0x101, 0x8070, 0x201, 0xd84c, 0xdf5f, 0x101, 0x43d5, 0x101,
    0x80b2, 0x101, 0x8103, 0x101, 0x440b, 0x101, 0x813e, 0x101,
    0x5ab5, 0x201, 0xd859, 0xdfa7, 0x201, 0xd859, 0xdfb5, 0x201,
    0xd84c, 0xdf93, 0x201, 0xd84c, 0xdf9c, 0x101, 0x8201, 0x101,
    0x8204, 0x101, 0x8f9e, 0x101, 0x446b, 0x101, 0x8291, 0x101,
    0x828b, 0x101, 0x829d, 0x101, 0x52b3, 0x101, 0x82b1, 0x101,
    0x82b3, 0x101, 0x82bd, 0x101, 0x82e6, 0x201, 0xd85a, 0xdf3c,
    0x101, 0x82e5, 0x101, 0x831d, 0x101, 0x8363, 0x101, 0x83ad,
    0x101, 0x8323, 0x101, 0x83bd, 0x101, 0x83e7, 0x101, 0x8457,
    0x101, 0x8353, 0x101, 0x83ca, 0x101, 0x83cc, 0x101, 0x83dc,
    0x201, 0xd85b, 0xdc36, 0x201, 0xd85b, 0xdd6b, 0x201, 0xd85b,
    0xdcd5, 0x101, 0x452b, 0x101, 0x84f1, 0x101, 0x84f3, 0x101,
    0x8516, 0x201, 0xd85c, 0xdfca, 0x101, 0x8564, 0x201, 0xd85b,
    0xdf2c, 0x101, 0x455d, 0x101, 0x4561, 0x201, 0xd85b, 0xdfb1,
    0x201, 0xd85c, 0xdcd2, 0x101, 0x456b, 0x101, 0x8650, 0x101,
    0x865c, 0x101, 0x8667, 0x101, 0x8669, 0x101, 0x86a9, 0x101,
    0x8688, 0x101, 0x870e, 0x101, 0x86e2, 0x101, 0x8779, 0x101,
    0x8728, 0x101, 0x876b, 0x101, 0x8786, 0x101, 0x45d7, 0x101,
    0x87e1, 0x101, 0x8801, 0x101, 0x45f9, 0x101, 0x8860, 0x101,
    0x8863, 0x201, 0xd85d, 0xde67, 0x101, 0x88d7, 0x101, 0x88de,
    0x101, 0x4635, 0x101, 0x88fa, 0x101, 0x34bb, 0x201, 0xd85e,
    0xdcae, 0x201, 0xd85e, 0xdd66, 0x101, 0x46be, 0x101, 0x46c7,
    0x101, 0x8aa0, 0x101, 0x8aed, 0x101, 0x8b8a, 0x101, 0x8c55,
    0x201, 0xd85f, 0xdca8, 0x101, 0x8cab, 0x101, 0x8cc1, 0x101,
    0x8d1b, 0x101, 0x8d77, 0x201, 0xd85f, 0xdf2f, 0x201, 0xd842,
    0xdc04, 0x101, 0x8dcb, 0x101, 0x8dbc, 0x101, 0x8df0, 0x201,
    0xd842, 0xdcde, 0x101, 0x8ed4, 0x101, 0x8f38, 0x201, 0xd861,
    0xddd2, 0x201, 0xd861, 0xdded, 0x101, 0x9094, 0x101, 0x90f1,
    0x101, 0x9111, 0x201, 0xd861, 0xdf2e, 0x101, 0x911b, 0x101,
    0x9238, 0x101, 0x92d7, 0x101, 0x92d8, 0x101, 0x927c, 0x101,
    0x93f9, 0x101, 0x9415, 0x201, 0xd862, 0xdffa, 0x101, 0x958b,
    0x101, 0x4995, 0x101, 0x95b7, 0x201, 0xd863, 0xdd77, 0x101,
    0x49e6, 0x101, 0x96c3, 0x101, 0x5db2, 0x101, 0x9723, 0x201,
    0xd864, 0xdd45, 0x201, 0xd864, 0xde1a, 0x101, 0x4a6e, 0x101,
    0x4a76, 0x101, 0x97e0, 0x201, 0xd865, 0xdc0a, 0x101, 0x4ab2,
    0x201, 0xd865, 0xdc96, 0x101, 0x980b, 0x101, 0x980b, 0x101,
    0x9829, 0x201, 0xd865, 0xddb6, 0x101, 0x98e2, 0x101, 0x4b33,
    0x101, 0x9929, 0x101, 0x99a7, 0x101, 0x99c2, 0x101, 0x99fe,
    0x101, 0x4bce, 0x201, 0xd866, 0xdf30, 0x101, 0x9b12, 0x101,
    0x9c40, 0x101, 0x9cfd, 0x101, 0x4cce, 0x101, 0x4ced, 0x101,
    0x9d67, 0x201, 0xd868, 0xdcce, 0x101, 0x4cf8, 0x201, 0xd868,
    0xdd05, 0x201, 0xd868, 0xde0e, 0x201, 0xd868, 0xde91, 0x101,
    0x9ebb, 0x101, 0x4d56, 0x101, 0x9ef9, 0x101, 0x9efe, 0x101,
    0x9f05, 0x101, 0x9f0f, 0x101, 0x9f16, 0x101, 0x9f3b, 0x201,
    0xd869, 0xde00
};

static const unsigned short uc_ligature_trie[] = {
    // 0 - 0x3100

    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    663, 695, 727, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 759, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 791, 631, 631, 631, 823, 855, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 887, 919, 631, 631, 951, 983, 631,
    631, 631, 1015, 631, 631, 631, 1047, 631,
    631, 1079, 1111, 631, 631, 631, 1143, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,

    631, 1175, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 1207, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,

    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,

    631, 631, 631, 631, 1239, 631, 631, 631,

    // 0x3100 - 0x12000

    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,

    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1527,
    1783, 1271, 2039, 2295, 2551, 1271, 1271, 1271,
    2807, 1271, 1271, 1271, 1271, 1271, 1271,


    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x0, 0xa9, 0x194, 0x1d5, 0x20e, 0xffff, 0x267, 0x2a8,
    0x305, 0x372, 0x3a3, 0x3b0, 0x3bd, 0xffff, 0xffff, 0x408,
    0xffff, 0x425, 0xffff, 0x43e, 0x45b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x47c, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x485, 0x4da, 0x4df, 0x4e4, 0x4ed,
    0x51a, 0xffff, 0xffff, 0xffff, 0xffff, 0x52f, 0x548, 0xffff,
    0x54d, 0x55a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x57d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x5d6, 0xffff, 0xffff, 0x611, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x690, 0x693, 0x6a0, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x6a3, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6aa, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6ad,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6b0, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6b3, 0x6b6,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6b9, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6be,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6c3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x6c6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6c9, 0x6d0, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6d3, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6d8,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x6db, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e0,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e3,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e6, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e9, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x700, 0x761, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x776, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x783,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x78c, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x791,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x796, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x79b, 0xffff, 0xffff, 0x7a0, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x7a5,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x7ae, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

#define GET_LIGATURE_INDEX(ucs4) \
       (ucs4 < 0x3100 \
        ? (uc_ligature_trie[uc_ligature_trie[ucs4>>5] + (ucs4 & 0x1f)]) \
        : (ucs4 < 0x12000 \
           ? uc_ligature_trie[uc_ligature_trie[((ucs4 - 0x3100)>>8) + 0x188] + (ucs4 & 0xff)] \
           : 0xffff))

static const unsigned short uc_ligature_map[] = {
    0x54, 0x41, 0xc0, 0x45, 0xc8, 0x49, 0xcc, 0x4e,
    0x1f8, 0x4f, 0xd2, 0x55, 0xd9, 0x57, 0x1e80, 0x59,
    0x1ef2, 0x61, 0xe0, 0x65, 0xe8, 0x69, 0xec, 0x6e,
    0x1f9, 0x6f, 0xf2, 0x75, 0xf9, 0x77, 0x1e81, 0x79,
    0x1ef3, 0xa8, 0x1fed, 0xc2, 0x1ea6, 0xca, 0x1ec0, 0xd4,
    0x1ed2, 0xdc, 0x1db, 0xe2, 0x1ea7, 0xea, 0x1ec1, 0xf4,
    0x1ed3, 0xfc, 0x1dc, 0x102, 0x1eb0, 0x103, 0x1eb1, 0x112,
    0x1e14, 0x113, 0x1e15, 0x14c, 0x1e50, 0x14d, 0x1e51, 0x1a0,
    0x1edc, 0x1a1, 0x1edd, 0x1af, 0x1eea, 0x1b0, 0x1eeb, 0x391,
    0x1fba, 0x395, 0x1fc8, 0x397, 0x1fca, 0x399, 0x1fda, 0x39f,
    0x1ff8, 0x3a5, 0x1fea, 0x3a9, 0x1ffa, 0x3b1, 0x1f70, 0x3b5,
    0x1f72, 0x3b7, 0x1f74, 0x3b9, 0x1f76, 0x3bf, 0x1f78, 0x3c5,
    0x1f7a, 0x3c9, 0x1f7c, 0x3ca, 0x1fd2, 0x3cb, 0x1fe2, 0x415,
    0x400, 0x418, 0x40d, 0x435, 0x450, 0x438, 0x45d, 0x1f00,
    0x1f02, 0x1f01, 0x1f03, 0x1f08, 0x1f0a, 0x1f09, 0x1f0b, 0x1f10,
    0x1f12, 0x1f11, 0x1f13, 0x1f18, 0x1f1a, 0x1f19, 0x1f1b, 0x1f20,
    0x1f22, 0x1f21, 0x1f23, 0x1f28, 0x1f2a, 0x1f29, 0x1f2b, 0x1f30,
    0x1f32, 0x1f31, 0x1f33, 0x1f38, 0x1f3a, 0x1f39, 0x1f3b, 0x1f40,
    0x1f42, 0x1f41, 0x1f43, 0x1f48, 0x1f4a, 0x1f49, 0x1f4b, 0x1f50,
    0x1f52, 0x1f51, 0x1f53, 0x1f59, 0x1f5b, 0x1f60, 0x1f62, 0x1f61,
    0x1f63, 0x1f68, 0x1f6a, 0x1f69, 0x1f6b, 0x1fbf, 0x1fcd, 0x1ffe,
    0x1fdd, 0x75, 0x41, 0xc1, 0x43, 0x106, 0x45, 0xc9,
    0x47, 0x1f4, 0x49, 0xcd, 0x4b, 0x1e30, 0x4c, 0x139,
    0x4d, 0x1e3e, 0x4e, 0x143, 0x4f, 0xd3, 0x50, 0x1e54,
    0x52, 0x154, 0x53, 0x15a, 0x55, 0xda, 0x57, 0x1e82,
    0x59, 0xdd, 0x5a, 0x179, 0x61, 0xe1, 0x63, 0x107,
    0x65, 0xe9, 0x67, 0x1f5, 0x69, 0xed, 0x6b, 0x1e31,
    0x6c, 0x13a, 0x6d, 0x1e3f, 0x6e, 0x144, 0x6f, 0xf3,
    0x70, 0x1e55, 0x72, 0x155, 0x73, 0x15b, 0x75, 0xfa,
    0x77, 0x1e83, 0x79, 0xfd, 0x7a, 0x17a, 0xa8, 0x385,
    0xc2, 0x1ea4, 0xc5, 0x1fa, 0xc6, 0x1fc, 0xc7, 0x1e08,
    0xca, 0x1ebe, 0xcf, 0x1e2e, 0xd4, 0x1ed0, 0xd5, 0x1e4c,
    0xd8, 0x1fe, 0xdc, 0x1d7, 0xe2, 0x1ea5, 0xe5, 0x1fb,
    0xe6, 0x1fd, 0xe7, 0x1e09, 0xea, 0x1ebf, 0xef, 0x1e2f,
    0xf4, 0x1ed1, 0xf5, 0x1e4d, 0xf8, 0x1ff, 0xfc, 0x1d8,
    0x102, 0x1eae, 0x103, 0x1eaf, 0x112, 0x1e16, 0x113, 0x1e17,
    0x14c, 0x1e52, 0x14d, 0x1e53, 0x168, 0x1e78, 0x169, 0x1e79,
    0x1a0, 0x1eda, 0x1a1, 0x1edb, 0x1af, 0x1ee8, 0x1b0, 0x1ee9,
    0x391, 0x386, 0x395, 0x388, 0x397, 0x389, 0x399, 0x38a,
    0x39f, 0x38c, 0x3a5, 0x38e, 0x3a9, 0x38f, 0x3b1, 0x3ac,
    0x3b5, 0x3ad, 0x3b7, 0x3ae, 0x3b9, 0x3af, 0x3bf, 0x3cc,
    0x3c5, 0x3cd, 0x3c9, 0x3ce, 0x3ca, 0x390, 0x3cb, 0x3b0,
    0x3d2, 0x3d3, 0x413, 0x403, 0x41a, 0x40c, 0x433, 0x453,
    0x43a, 0x45c, 0x1f00, 0x1f04, 0x1f01, 0x1f05, 0x1f08, 0x1f0c,
    0x1f09, 0x1f0d, 0x1f10, 0x1f14, 0x1f11, 0x1f15, 0x1f18, 0x1f1c,
    0x1f19, 0x1f1d, 0x1f20, 0x1f24, 0x1f21, 0x1f25, 0x1f28, 0x1f2c,
    0x1f29, 0x1f2d, 0x1f30, 0x1f34, 0x1f31, 0x1f35, 0x1f38, 0x1f3c,
    0x1f39, 0x1f3d, 0x1f40, 0x1f44, 0x1f41, 0x1f45, 0x1f48, 0x1f4c,
    0x1f49, 0x1f4d, 0x1f50, 0x1f54, 0x1f51, 0x1f55, 0x1f59, 0x1f5d,
    0x1f60, 0x1f64, 0x1f61, 0x1f65, 0x1f68, 0x1f6c, 0x1f69, 0x1f6d,
    0x1fbf, 0x1fce, 0x1ffe, 0x1fde, 0x20, 0x41, 0xc2, 0x43,
    0x108, 0x45, 0xca, 0x47, 0x11c, 0x48, 0x124, 0x49,
    0xce, 0x4a, 0x134, 0x4f, 0xd4, 0x53, 0x15c, 0x55,
    0xdb, 0x57, 0x174, 0x59, 0x176, 0x5a, 0x1e90, 0x61,
    0xe2, 0x63, 0x109, 0x65, 0xea, 0x67, 0x11d, 0x68,
    0x125, 0x69, 0xee, 0x6a, 0x135, 0x6f, 0xf4, 0x73,
    0x15d, 0x75, 0xfb, 0x77, 0x175, 0x79, 0x177, 0x7a,
    0x1e91, 0x1ea0, 0x1eac, 0x1ea1, 0x1ead, 0x1eb8, 0x1ec6, 0x1eb9,
    0x1ec7, 0x1ecc, 0x1ed8, 0x1ecd, 0x1ed9, 0x1c, 0x41, 0xc3,
    0x45, 0x1ebc, 0x49, 0x128, 0x4e, 0xd1, 0x4f, 0xd5,
    0x55, 0x168, 0x56, 0x1e7c, 0x59, 0x1ef8, 0x61, 0xe3,
    0x65, 0x1ebd, 0x69, 0x129, 0x6e, 0xf1, 0x6f, 0xf5,
    0x75, 0x169, 0x76, 0x1e7d, 0x79, 0x1ef9, 0xc2, 0x1eaa,
    0xca, 0x1ec4, 0xd4, 0x1ed6, 0xe2, 0x1eab, 0xea, 0x1ec5,
    0xf4, 0x1ed7, 0x102, 0x1eb4, 0x103, 0x1eb5, 0x1a0, 0x1ee0,
    0x1a1, 0x1ee1, 0x1af, 0x1eee, 0x1b0, 0x1eef, 0x2c, 0x41,
    0x100, 0x45, 0x112, 0x47, 0x1e20, 0x49, 0x12a, 0x4f,
    0x14c, 0x55, 0x16a, 0x59, 0x232, 0x61, 0x101, 0x65,
    0x113, 0x67, 0x1e21, 0x69, 0x12b, 0x6f, 0x14d, 0x75,
    0x16b, 0x79, 0x233, 0xc4, 0x1de, 0xc6, 0x1e2, 0xd5,
    0x22c, 0xd6, 0x22a, 0xdc, 0x1d5, 0xe4, 0x1df, 0xe6,
    0x1e3, 0xf5, 0x22d, 0xf6, 0x22b, 0xfc, 0x1d6, 0x1ea,
    0x1ec, 0x1eb, 0x1ed, 0x226, 0x1e0, 0x227, 0x1e1, 0x22e,
    0x230, 0x22f, 0x231, 0x391, 0x1fb9, 0x399, 0x1fd9, 0x3a5,
    0x1fe9, 0x3b1, 0x1fb1, 0x3b9, 0x1fd1, 0x3c5, 0x1fe1, 0x418,
    0x4e2, 0x423, 0x4ee, 0x438, 0x4e3, 0x443, 0x4ef, 0x1e36,
    0x1e38, 0x1e37, 0x1e39, 0x1e5a, 0x1e5c, 0x1e5b, 0x1e5d, 0x20,
    0x41, 0x102, 0x45, 0x114, 0x47, 0x11e, 0x49, 0x12c,
    0x4f, 0x14e, 0x55, 0x16c, 0x61, 0x103, 0x65, 0x115,
    0x67, 0x11f, 0x69, 0x12d, 0x6f, 0x14f, 0x75, 0x16d,
    0x228, 0x1e1c, 0x229, 0x1e1d, 0x391, 0x1fb8, 0x399, 0x1fd8,
    0x3a5, 0x1fe8, 0x3b1, 0x1fb0, 0x3b9, 0x1fd0, 0x3c5, 0x1fe0,
    0x410, 0x4d0, 0x415, 0x4d6, 0x416, 0x4c1, 0x418, 0x419,
    0x423, 0x40e, 0x430, 0x4d1, 0x435, 0x4d7, 0x436, 0x4c2,
    0x438, 0x439, 0x443, 0x45e, 0x1ea0, 0x1eb6, 0x1ea1, 0x1eb7,
    0x2e, 0x41, 0x226, 0x42, 0x1e02, 0x43, 0x10a, 0x44,
    0x1e0a, 0x45, 0x116, 0x46, 0x1e1e, 0x47, 0x120, 0x48,
    0x1e22, 0x49, 0x130, 0x4d, 0x1e40, 0x4e, 0x1e44, 0x4f,
    0x22e, 0x50, 0x1e56, 0x52, 0x1e58, 0x53, 0x1e60, 0x54,
    0x1e6a, 0x57, 0x1e86, 0x58, 0x1e8a, 0x59, 0x1e8e, 0x5a,
    0x17b, 0x61, 0x227, 0x62, 0x1e03, 0x63, 0x10b, 0x64,
    0x1e0b, 0x65, 0x117, 0x66, 0x1e1f, 0x67, 0x121, 0x68,
    0x1e23, 0x6d, 0x1e41, 0x6e, 0x1e45, 0x6f, 0x22f, 0x70,
    0x1e57, 0x72, 0x1e59, 0x73, 0x1e61, 0x74, 0x1e6b, 0x77,
    0x1e87, 0x78, 0x1e8b, 0x79, 0x1e8f, 0x7a, 0x17c, 0x15a,
    0x1e64, 0x15b, 0x1e65, 0x160, 0x1e66, 0x161, 0x1e67, 0x17f,
    0x1e9b, 0x1e62, 0x1e68, 0x1e63, 0x1e69, 0x36, 0x41, 0xc4,
    0x45, 0xcb, 0x48, 0x1e26, 0x49, 0xcf, 0x4f, 0xd6,
    0x55, 0xdc, 0x57, 0x1e84, 0x58, 0x1e8c, 0x59, 0x178,
    0x61, 0xe4, 0x65, 0xeb, 0x68, 0x1e27, 0x69, 0xef,
    0x6f, 0xf6, 0x74, 0x1e97, 0x75, 0xfc, 0x77, 0x1e85,
    0x78, 0x1e8d, 0x79, 0xff, 0xd5, 0x1e4e, 0xf5, 0x1e4f,
    0x16a, 0x1e7a, 0x16b, 0x1e7b, 0x399, 0x3aa, 0x3a5, 0x3ab,
    0x3b9, 0x3ca, 0x3c5, 0x3cb, 0x3d2, 0x3d4, 0x406, 0x407,
    0x410, 0x4d2, 0x415, 0x401, 0x416, 0x4dc, 0x417, 0x4de,
    0x418, 0x4e4, 0x41e, 0x4e6, 0x423, 0x4f0, 0x427, 0x4f4,
    0x42b, 0x4f8, 0x42d, 0x4ec, 0x430, 0x4d3, 0x435, 0x451,
    0x436, 0x4dd, 0x437, 0x4df, 0x438, 0x4e5, 0x43e, 0x4e7,
    0x443, 0x4f1, 0x447, 0x4f5, 0x44b, 0x4f9, 0x44d, 0x4ed,
    0x456, 0x457, 0x4d8, 0x4da, 0x4d9, 0x4db, 0x4e8, 0x4ea,
    0x4e9, 0x4eb, 0x18, 0x41, 0x1ea2, 0x45, 0x1eba, 0x49,
    0x1ec8, 0x4f, 0x1ece, 0x55, 0x1ee6, 0x59, 0x1ef6, 0x61,
    0x1ea3, 0x65, 0x1ebb, 0x69, 0x1ec9, 0x6f, 0x1ecf, 0x75,
    0x1ee7, 0x79, 0x1ef7, 0xc2, 0x1ea8, 0xca, 0x1ec2, 0xd4,
    0x1ed4, 0xe2, 0x1ea9, 0xea, 0x1ec3, 0xf4, 0x1ed5, 0x102,
    0x1eb2, 0x103, 0x1eb3, 0x1a0, 0x1ede, 0x1a1, 0x1edf, 0x1af,
    0x1eec, 0x1b0, 0x1eed, 0x6, 0x41, 0xc5, 0x55, 0x16e,
    0x61, 0xe5, 0x75, 0x16f, 0x77, 0x1e98, 0x79, 0x1e99,
    0x6, 0x4f, 0x150, 0x55, 0x170, 0x6f, 0x151, 0x75,
    0x171, 0x423, 0x4f2, 0x443, 0x4f3, 0x25, 0x41, 0x1cd,
    0x43, 0x10c, 0x44, 0x10e, 0x45, 0x11a, 0x47, 0x1e6,
    0x48, 0x21e, 0x49, 0x1cf, 0x4b, 0x1e8, 0x4c, 0x13d,
    0x4e, 0x147, 0x4f, 0x1d1, 0x52, 0x158, 0x53, 0x160,
    0x54, 0x164, 0x55, 0x1d3, 0x5a, 0x17d, 0x61, 0x1ce,
    0x63, 0x10d, 0x64, 0x10f, 0x65, 0x11b, 0x67, 0x1e7,
    0x68, 0x21f, 0x69, 0x1d0, 0x6a, 0x1f0, 0x6b, 0x1e9,
    0x6c, 0x13e, 0x6e, 0x148, 0x6f, 0x1d2, 0x72, 0x159,
    0x73, 0x161, 0x74, 0x165, 0x75, 0x1d4, 0x7a, 0x17e,
    0xdc, 0x1d9, 0xfc, 0x1da, 0x1b7, 0x1ee, 0x292, 0x1ef,
    0xe, 0x41, 0x200, 0x45, 0x204, 0x49, 0x208, 0x4f,
    0x20c, 0x52, 0x210, 0x55, 0x214, 0x61, 0x201, 0x65,
    0x205, 0x69, 0x209, 0x6f, 0x20d, 0x72, 0x211, 0x75,
    0x215, 0x474, 0x476, 0x475, 0x477, 0xc, 0x41, 0x202,
    0x45, 0x206, 0x49, 0x20a, 0x4f, 0x20e, 0x52, 0x212,
    0x55, 0x216, 0x61, 0x203, 0x65, 0x207, 0x69, 0x20b,
    0x6f, 0x20f, 0x72, 0x213, 0x75, 0x217, 0xe, 0x391,
    0x1f08, 0x395, 0x1f18, 0x397, 0x1f28, 0x399, 0x1f38, 0x39f,
    0x1f48, 0x3a9, 0x1f68, 0x3b1, 0x1f00, 0x3b5, 0x1f10, 0x3b7,
    0x1f20, 0x3b9, 0x1f30, 0x3bf, 0x1f40, 0x3c1, 0x1fe4, 0x3c5,
    0x1f50, 0x3c9, 0x1f60, 0x10, 0x391, 0x1f09, 0x395, 0x1f19,
    0x397, 0x1f29, 0x399, 0x1f39, 0x39f, 0x1f49, 0x3a1, 0x1fec,
    0x3a5, 0x1f59, 0x3a9, 0x1f69, 0x3b1, 0x1f01, 0x3b5, 0x1f11,
    0x3b7, 0x1f21, 0x3b9, 0x1f31, 0x3bf, 0x1f41, 0x3c1, 0x1fe5,
    0x3c5, 0x1f51, 0x3c9, 0x1f61, 0x4, 0x4f, 0x1a0, 0x55,
    0x1af, 0x6f, 0x1a1, 0x75, 0x1b0, 0x2a, 0x41, 0x1ea0,
    0x42, 0x1e04, 0x44, 0x1e0c, 0x45, 0x1eb8, 0x48, 0x1e24,
    0x49, 0x1eca, 0x4b, 0x1e32, 0x4c, 0x1e36, 0x4d, 0x1e42,
    0x4e, 0x1e46, 0x4f, 0x1ecc, 0x52, 0x1e5a, 0x53, 0x1e62,
    0x54, 0x1e6c, 0x55, 0x1ee4, 0x56, 0x1e7e, 0x57, 0x1e88,
    0x59, 0x1ef4, 0x5a, 0x1e92, 0x61, 0x1ea1, 0x62, 0x1e05,
    0x64, 0x1e0d, 0x65, 0x1eb9, 0x68, 0x1e25, 0x69, 0x1ecb,
    0x6b, 0x1e33, 0x6c, 0x1e37, 0x6d, 0x1e43, 0x6e, 0x1e47,
    0x6f, 0x1ecd, 0x72, 0x1e5b, 0x73, 0x1e63, 0x74, 0x1e6d,
    0x75, 0x1ee5, 0x76, 0x1e7f, 0x77, 0x1e89, 0x79, 0x1ef5,
    0x7a, 0x1e93, 0x1a0, 0x1ee2, 0x1a1, 0x1ee3, 0x1af, 0x1ef0,
    0x1b0, 0x1ef1, 0x2, 0x55, 0x1e72, 0x75, 0x1e73, 0x2,
    0x41, 0x1e00, 0x61, 0x1e01, 0x4, 0x53, 0x218, 0x54,
    0x21a, 0x73, 0x219, 0x74, 0x21b, 0x16, 0x43, 0xc7,
    0x44, 0x1e10, 0x45, 0x228, 0x47, 0x122, 0x48, 0x1e28,
    0x4b, 0x136, 0x4c, 0x13b, 0x4e, 0x145, 0x52, 0x156,
    0x53, 0x15e, 0x54, 0x162, 0x63, 0xe7, 0x64, 0x1e11,
    0x65, 0x229, 0x67, 0x123, 0x68, 0x1e29, 0x6b, 0x137,
    0x6c, 0x13c, 0x6e, 0x146, 0x72, 0x157, 0x73, 0x15f,
    0x74, 0x163, 0xa, 0x41, 0x104, 0x45, 0x118, 0x49,
    0x12e, 0x4f, 0x1ea, 0x55, 0x172, 0x61, 0x105, 0x65,
    0x119, 0x69, 0x12f, 0x6f, 0x1eb, 0x75, 0x173, 0xc,
    0x44, 0x1e12, 0x45, 0x1e18, 0x4c, 0x1e3c, 0x4e, 0x1e4a,
    0x54, 0x1e70, 0x55, 0x1e76, 0x64, 0x1e13, 0x65, 0x1e19,
    0x6c, 0x1e3d, 0x6e, 0x1e4b, 0x74, 0x1e71, 0x75, 0x1e77,
    0x2, 0x48, 0x1e2a, 0x68, 0x1e2b, 0x6, 0x45, 0x1e1a,
    0x49, 0x1e2c, 0x55, 0x1e74, 0x65, 0x1e1b, 0x69, 0x1e2d,
    0x75, 0x1e75, 0x11, 0x42, 0x1e06, 0x44, 0x1e0e, 0x4b,
    0x1e34, 0x4c, 0x1e3a, 0x4e, 0x1e48, 0x52, 0x1e5e, 0x54,
    0x1e6e, 0x5a, 0x1e94, 0x62, 0x1e07, 0x64, 0x1e0f, 0x68,
    0x1e96, 0x6b, 0x1e35, 0x6c, 0x1e3b, 0x6e, 0x1e49, 0x72,
    0x1e5f, 0x74, 0x1e6f, 0x7a, 0x1e95, 0x2c, 0x3c, 0x226e,
    0x3d, 0x2260, 0x3e, 0x226f, 0x2190, 0x219a, 0x2192, 0x219b,
    0x2194, 0x21ae, 0x21d0, 0x21cd, 0x21d2, 0x21cf, 0x21d4, 0x21ce,
    0x2203, 0x2204, 0x2208, 0x2209, 0x220b, 0x220c, 0x2223, 0x2224,
    0x2225, 0x2226, 0x223c, 0x2241, 0x2243, 0x2244, 0x2245, 0x2247,
    0x2248, 0x2249, 0x224d, 0x226d, 0x2261, 0x2262, 0x2264, 0x2270,
    0x2265, 0x2271, 0x2272, 0x2274, 0x2273, 0x2275, 0x2276, 0x2278,
    0x2277, 0x2279, 0x227a, 0x2280, 0x227b, 0x2281, 0x227c, 0x22e0,
    0x227d, 0x22e1, 0x2282, 0x2284, 0x2283, 0x2285, 0x2286, 0x2288,
    0x2287, 0x2289, 0x2291, 0x22e2, 0x2292, 0x22e3, 0x22a2, 0x22ac,
    0x22a8, 0x22ad, 0x22a9, 0x22ae, 0x22ab, 0x22af, 0x22b2, 0x22ea,
    0x22b3, 0x22eb, 0x22b4, 0x22ec, 0x22b5, 0x22ed, 0x1d, 0xa8,
    0x1fc1, 0x3b1, 0x1fb6, 0x3b7, 0x1fc6, 0x3b9, 0x1fd6, 0x3c5,
    0x1fe6, 0x3c9, 0x1ff6, 0x3ca, 0x1fd7, 0x3cb, 0x1fe7, 0x1f00,
    0x1f06, 0x1f01, 0x1f07, 0x1f08, 0x1f0e, 0x1f09, 0x1f0f, 0x1f20,
    0x1f26, 0x1f21, 0x1f27, 0x1f28, 0x1f2e, 0x1f29, 0x1f2f, 0x1f30,
    0x1f36, 0x1f31, 0x1f37, 0x1f38, 0x1f3e, 0x1f39, 0x1f3f, 0x1f50,
    0x1f56, 0x1f51, 0x1f57, 0x1f59, 0x1f5f, 0x1f60, 0x1f66, 0x1f61,
    0x1f67, 0x1f68, 0x1f6e, 0x1f69, 0x1f6f, 0x1fbf, 0x1fcf, 0x1ffe,
    0x1fdf, 0x3f, 0x391, 0x1fbc, 0x397, 0x1fcc, 0x3a9, 0x1ffc,
    0x3ac, 0x1fb4, 0x3ae, 0x1fc4, 0x3b1, 0x1fb3, 0x3b7, 0x1fc3,
    0x3c9, 0x1ff3, 0x3ce, 0x1ff4, 0x1f00, 0x1f80, 0x1f01, 0x1f81,
    0x1f02, 0x1f82, 0x1f03, 0x1f83, 0x1f04, 0x1f84, 0x1f05, 0x1f85,
    0x1f06, 0x1f86, 0x1f07, 0x1f87, 0x1f08, 0x1f88, 0x1f09, 0x1f89,
    0x1f0a, 0x1f8a, 0x1f0b, 0x1f8b, 0x1f0c, 0x1f8c, 0x1f0d, 0x1f8d,
    0x1f0e, 0x1f8e, 0x1f0f, 0x1f8f, 0x1f20, 0x1f90, 0x1f21, 0x1f91,
    0x1f22, 0x1f92, 0x1f23, 0x1f93, 0x1f24, 0x1f94, 0x1f25, 0x1f95,
    0x1f26, 0x1f96, 0x1f27, 0x1f97, 0x1f28, 0x1f98, 0x1f29, 0x1f99,
    0x1f2a, 0x1f9a, 0x1f2b, 0x1f9b, 0x1f2c, 0x1f9c, 0x1f2d, 0x1f9d,
    0x1f2e, 0x1f9e, 0x1f2f, 0x1f9f, 0x1f60, 0x1fa0, 0x1f61, 0x1fa1,
    0x1f62, 0x1fa2, 0x1f63, 0x1fa3, 0x1f64, 0x1fa4, 0x1f65, 0x1fa5,
    0x1f66, 0x1fa6, 0x1f67, 0x1fa7, 0x1f68, 0x1fa8, 0x1f69, 0x1fa9,
    0x1f6a, 0x1faa, 0x1f6b, 0x1fab, 0x1f6c, 0x1fac, 0x1f6d, 0x1fad,
    0x1f6e, 0x1fae, 0x1f6f, 0x1faf, 0x1f70, 0x1fb2, 0x1f74, 0x1fc2,
    0x1f7c, 0x1ff2, 0x1fb6, 0x1fb7, 0x1fc6, 0x1fc7, 0x1ff6, 0x1ff7,
    0x1, 0x627, 0x622, 0x6, 0x627, 0x623, 0x648, 0x624,
    0x64a, 0x626, 0x6c1, 0x6c2, 0x6d2, 0x6d3, 0x6d5, 0x6c0,
    0x1, 0x627, 0x625, 0x3, 0x928, 0x929, 0x930, 0x931,
    0x933, 0x934, 0x1, 0x9c7, 0x9cb, 0x1, 0x9c7, 0x9cc,
    0x1, 0xb47, 0xb4b, 0x1, 0xb47, 0xb48, 0x1, 0xb47,
    0xb4c, 0x2, 0xbc6, 0xbca, 0xbc7, 0xbcb, 0x2, 0xb92,
    0xb94, 0xbc6, 0xbcc, 0x1, 0xc46, 0xc48, 0x1, 0xcc6,
    0xcca, 0x3, 0xcbf, 0xcc0, 0xcc6, 0xcc7, 0xcca, 0xccb,
    0x1, 0xcc6, 0xcc8, 0x2, 0xd46, 0xd4a, 0xd47, 0xd4b,
    0x1, 0xd46, 0xd4c, 0x2, 0xdd9, 0xdda, 0xddc, 0xddd,
    0x1, 0xdd9, 0xddc, 0x1, 0xdd9, 0xdde, 0x1, 0x1025,
    0x1026, 0xb, 0x1b05, 0x1b06, 0x1b07, 0x1b08, 0x1b09, 0x1b0a,
    0x1b0b, 0x1b0c, 0x1b0d, 0x1b0e, 0x1b11, 0x1b12, 0x1b3a, 0x1b3b,
    0x1b3c, 0x1b3d, 0x1b3e, 0x1b40, 0x1b3f, 0x1b41, 0x1b42, 0x1b43,
    0x30, 0x3046, 0x3094, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f,
    0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057,
    0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f,
    0x3060, 0x3061, 0x3062, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068,
    0x3069, 0x306f, 0x3070, 0x3072, 0x3073, 0x3075, 0x3076, 0x3078,
    0x3079, 0x307b, 0x307c, 0x309d, 0x309e, 0x30a6, 0x30f4, 0x30ab,
    0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0, 0x30b1, 0x30b2, 0x30b3,
    0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8, 0x30b9, 0x30ba, 0x30bb,
    0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0, 0x30c1, 0x30c2, 0x30c4,
    0x30c5, 0x30c6, 0x30c7, 0x30c8, 0x30c9, 0x30cf, 0x30d0, 0x30d2,
    0x30d3, 0x30d5, 0x30d6, 0x30d8, 0x30d9, 0x30db, 0x30dc, 0x30ef,
    0x30f7, 0x30f0, 0x30f8, 0x30f1, 0x30f9, 0x30f2, 0x30fa, 0x30fd,
    0x30fe, 0xa, 0x306f, 0x3071, 0x3072, 0x3074, 0x3075, 0x3077,
    0x3078, 0x307a, 0x307b, 0x307d, 0x30cf, 0x30d1, 0x30d2, 0x30d4,
    0x30d5, 0x30d7, 0x30d8, 0x30da, 0x30db, 0x30dd, 0x3, 0xd804,
    0xdc99, 0xd804, 0xdc9a, 0xd804, 0xdc9b, 0xd804, 0xdc9c, 0xd804,
    0xdca5, 0xd804, 0xdcab, 0x2, 0xd804, 0xdd31, 0xd804, 0xdd2e,
    0xd804, 0xdd32, 0xd804, 0xdd2f, 0x1, 0xd804, 0xdf47, 0xd804,
    0xdf4b, 0x1, 0xd804, 0xdf47, 0xd804, 0xdf4c, 0x1, 0xd805,
    0xdcb9, 0xd805, 0xdcbc, 0x1, 0xd805, 0xdcb9, 0xd805, 0xdcbb,
    0x1, 0xd805, 0xdcb9, 0xd805, 0xdcbe, 0x2, 0xd805, 0xddb8,
    0xd805, 0xddba, 0xd805, 0xddb9, 0xd805, 0xddbb, 0x1, 0xd806,
    0xdd35, 0xd806, 0xdd38
};


struct NormalizationCorrection {
    uint ucs4;
    uint old_mapping;
    int version;
};

static const NormalizationCorrection uc_normalization_corrections[] = {
    { 0xf951, 0x96fb, 6 },
    { 0x2f868, 0x2136a, 7 },
    { 0x2f874, 0x5f33, 7 },
    { 0x2f91f, 0x43ab, 7 },
    { 0x2f95f, 0x7aae, 7 },
    { 0x2f9bf, 0x4d57, 7 }
};

enum { NumNormalizationCorrections = 6 };
enum { NormalizationCorrectionsVersionMax = 7 };

} // namespace QUnicodeTables

using namespace QUnicodeTables;

QT_END_NAMESPACE
