/*
 *  mon_atraps.h - MacOS A-Line trap definitions
 *
 *  cxmon (C) 1997-2004 Christian Bauer, Marc Hellwig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MON_ATRAPS_H
#define MON_ATRAPS_H

struct atrap_info {
	const char *name;
	uint16 word;
};

// A-Traps in ascending order
static const atrap_info atraps[] = {
	{"Open"						, 0xA000},
	{"Close"					, 0xA001},
	{"Read"						, 0xA002},
	{"Write"					, 0xA003},
	{"Control"					, 0xA004},
	{"Status"					, 0xA005},
	{"KillIO"					, 0xA006},
	{"GetVolInfo"				, 0xA007},
	{"Create"					, 0xA008},
	{"Delete"					, 0xA009},
	{"OpenRF"					, 0xA00A},
	{"Rename"					, 0xA00B},
	{"GetFileInfo"				, 0xA00C},
	{"SetFileInfo"				, 0xA00D},
	{"UnmountVol"				, 0xA00E},
	{"MountVol"					, 0xA00F},
	{"Allocate"					, 0xA010},
	{"GetEOF"					, 0xA011},
	{"SetEOF"					, 0xA012},
	{"FlushVol"					, 0xA013},
	{"GetVol"					, 0xA014},
	{"SetVol"					, 0xA015},
	{"FInitQueue"				, 0xA016},
	{"Eject"					, 0xA017},
	{"GetFPos"					, 0xA018},
	{"InitZone"					, 0xA019},
	{"SetZone"					, 0xA01B},
	{"FreeMem"					, 0xA01C},
	{"DisposePtr"				, 0xA01F},
	{"SetPtrSize"				, 0xA020},
	{"GetPtrSize"				, 0xA021},
	{"DisposeHandle"			, 0xA023},
	{"SetHandleSize"			, 0xA024},
	{"GetHandleSize"			, 0xA025},
	{"ReallocHandle"			, 0xA027},
	{"HLock"					, 0xA029},
	{"HUnlock"					, 0xA02A},
	{"EmptyHandle"				, 0xA02B},
	{"InitApplZone"				, 0xA02C},
	{"SetApplLimit"				, 0xA02D},
	{"BlockMove"				, 0xA02E},
	{"PostEvent"				, 0xA02F},
	{"OSEventAvail"				, 0xA030},
	{"GetOSEvent"				, 0xA031},
	{"FlushEvents"				, 0xA032},
	{"VInstall"					, 0xA033},
	{"VRemove"					, 0xA034},
	{"OffLine"					, 0xA035},
	{"MoreMasters"				, 0xA036},
	{"ReadParam"				, 0xA037},
	{"WriteParam"				, 0xA038},
	{"ReadDateTime"				, 0xA039},
	{"SetDateTime"				, 0xA03A},
	{"Delay"					, 0xA03B},
	{"CmpString"				, 0xA03C},
	{"DrvrInstall"				, 0xA03D},
	{"DrvrRemove"				, 0xA03E},
	{"InitUtil"					, 0xA03F},
	{"ResrvMem"					, 0xA040},
	{"SetFilLock"				, 0xA041},
	{"RstFilLock"				, 0xA042},
	{"SetFilType"				, 0xA043},
	{"SetFPos"					, 0xA044},
	{"FlushFile"				, 0xA045},
	{"SetTrapAddress"			, 0xA047},
	{"HPurge"					, 0xA049},
	{"HNoPurge"					, 0xA04A},
	{"SetGrowZone"				, 0xA04B},
	{"CompactMem"				, 0xA04C},
	{"PurgeMem"					, 0xA04D},
	{"AddDrive"					, 0xA04E},
	{"RDrvrInstall"				, 0xA04F},
	{"CompareString"			, 0xA050},
	{"ReadXPRam"				, 0xA051},
	{"WriteXPRam"				, 0xA052},
	{"UprString"				, 0xA054},
	{"StripAddress"				, 0xA055},
	{"LowerText"				, 0xA056},
	{"SetApplBase"				, 0xA057},
	{"InsTime"					, 0xA058},
	{"RmvTime"					, 0xA059},
	{"PrimeTime"				, 0xA05A},
	{"PowerOff"					, 0xA05B},
	{"MemoryDispatch"			, 0xA05C},
	{"SwapMMUMode"				, 0xA05D},
	{"NMInstall"				, 0xA05E},
	{"NMRemove"					, 0xA05F},
	{"FSDispatch"				, 0xA060},
	{"MaxBlock"					, 0xA061},
	{"MaxApplZone"				, 0xA063},
	{"MoveHHi"					, 0xA064},
	{"StackSpace"				, 0xA065},
	{"HSetRBit"					, 0xA067},
	{"HClrRBit"					, 0xA068},
	{"HGetState"				, 0xA069},
	{"HSetState"				, 0xA06A},
	{"TestManager"				, 0xA06B},
	{"InitFS"					, 0xA06C},
	{"InitEvents"				, 0xA06D},
	{"SlotManager"				, 0xA06E},
	{"SlotVInstall"				, 0xA06F},
	{"SlotVRemove"				, 0xA070},
	{"AttachVBL"				, 0xA071},
	{"DoVBLTask"				, 0xA072},
	{"OSReserved"				, 0xA073},
	{"CacheMgr"					, 0xA074},
	{"SIntInstall"				, 0xA075},
	{"SIntRemove"				, 0xA076},
	{"CountADBs"				, 0xA077},
	{"GetIndADB"				, 0xA078},
	{"GetADBInfo"				, 0xA079},
	{"SetADBInfo"				, 0xA07A},
	{"ADBReInit"				, 0xA07B},
	{"ADBOp"					, 0xA07C},
	{"GetDefaultStartup"		, 0xA07D},
	{"SetDefaultStartup"		, 0xA07E},
	{"InternalWait"				, 0xA07F},
	{"GetVideoDefault"			, 0xA080},
	{"SetVideoDefault"			, 0xA081},
	{"DTInstall"				, 0xA082},
	{"SetOSDefault"				, 0xA083},
	{"GetOSDefault"				, 0xA084},
	{"PMgrOp"					, 0xA085},
	{"IOPInfoAccess"			, 0xA086},
	{"IOPMsgRequest"			, 0xA087},
	{"IOPMoveData"				, 0xA088},
	{"SCSIAtomic"				, 0xA089},
	{"Sleep"					, 0xA08A},
	{"CommToolboxDispatch"		, 0xA08B},
	{"Wakeup"					, 0xA08C},
	{"DebugUtil"				, 0xA08D},
	{"BTreeDispatch"			, 0xA08E},
	{"DeferUserFn"				, 0xA08F},
	{"SysEnvirons"				, 0xA090},
	{"Translate24To32"			, 0xA091},
	{"EgretDispatch"			, 0xA092},
	{"Microseconds"				, 0xA093},
	{"ServerDispatch"			, 0xA094},
	{"POGOMPW"					, 0xA095},
	{"SharedLibsMPW"			, 0xA096},
	{"FPPriv"					, 0xA097},
	{"XToolTable"				, 0xA099},
	{"vProcHelper"				, 0xA09A},
	{"Messager"					, 0xA09B},
	{"NewPtrStartup"			, 0xA09C},
	{"MoveHLow"					, 0xA09D},
	{"PowerMgrDispatch"			, 0xA09E},
	{"PowerDispatch"			, 0xA09F},
	{"vMRdAddr"					, 0xA0A0},
	{"vMRdData"					, 0xA0A1},
	{"vMWrData"					, 0xA0A2},
	{"HeapDispatch"				, 0xA0A4},
	{"VisRegionChanged"			, 0xA0A5},
	{"vStdEntry"				, 0xA0A6},
	{"vStdExit"					, 0xA0A7},
	{"FSM"						, 0xA0AC},
	{"vADBProc"					, 0xA0AE},
	{"vMtCheck"					, 0xA0AF},
	{"vCheckReMount"			, 0xA0B0},
	{"vDtrmV2"					, 0xA0B1},
	{"vFindDrive"				, 0xA0B2},
	{"vFClose"					, 0xA0B3},
	{"vFlushMDB"				, 0xA0B4},
	{"vGoDriver"				, 0xA0B5},
	{"vWaitUntil"				, 0xA0B6},
	{"vSyncWait"				, 0xA0B7},
	{"vSoundDead"				, 0xA0B8},
	{"vDisptch"					, 0xA0B9},
	{"vIAZInit"					, 0xA0BA},
	{"vIAZPostInit"				, 0xA0BB},
	{"vLaunchInit"				, 0xA0BC},
	{"vCacheFlush"				, 0xA0BD},
	{"vSysUtil"					, 0xA0BE},
	{"vLg2Phys"					, 0xA0BF},
	{"vFlushCache"				, 0xA0C0},
	{"vGetBlock"				, 0xA0C1},
	{"vMarkBlock"				, 0xA0C2},
	{"vRelBlock"				, 0xA0C3},
	{"vTrashBlocks"				, 0xA0C4},
	{"vTrashVBlks"				, 0xA0C5},
	{"vCacheWrIP"				, 0xA0C6},
	{"vCacheRdIP"				, 0xA0C7},
	{"vBasicIO"					, 0xA0C8},
	{"vRdBlocks"				, 0xA0C9},
	{"vWrBlocks"				, 0xA0CA},
	{"vSetUpTags"				, 0xA0CB},
	{"vBTClose"					, 0xA0CC},
	{"vBTDelete"				, 0xA0CD},
	{"vBTFlush"					, 0xA0CE},
	{"vBTGetRecord"				, 0xA0CF},
	{"vBTInsert"				, 0xA0D0},
	{"vBTOpen"					, 0xA0D1},
	{"vBTSearch"				, 0xA0D2},
	{"vBTUpdate"				, 0xA0D3},
	{"vGetNode"					, 0xA0D4},
	{"vRelNode"					, 0xA0D5},
	{"vAllocNode"				, 0xA0D6},
	{"vFreeNode"				, 0xA0D7},
	{"vExtBTFile"				, 0xA0D8},
	{"vDeallocFile"				, 0xA0D9},
	{"vExtendFile"				, 0xA0DA},
	{"vTruncateFile"			, 0xA0DB},
	{"vCMSetup"					, 0xA0DC},
	{"PPC"						, 0xA0DD},
	{"vDtrmV1"					, 0xA0DE},
	{"vBlkAlloc"				, 0xA0DF},
	{"vBlkDeAlloc"				, 0xA0E0},
	{"vFileOpen"				, 0xA0E1},
	{"vPermssnChk"				, 0xA0E2},
	{"vFndFilName"				, 0xA0E3},
	{"vRfNCall"					, 0xA0E4},
	{"vAdjEOF"					, 0xA0E5},
	{"vPixel2Char"				, 0xA0E6},
	{"vChar2Pixel"				, 0xA0E7},
	{"vHiliteText"				, 0xA0E8},
	{"vFileClose"				, 0xA0E9},
	{"vFileRead"				, 0xA0EA},
	{"vFileWrite"				, 0xA0EB},
	{"DispatchHelper"			, 0xA0EC},
	{"vUpdAltMDB"				, 0xA0ED},
	{"vCkExtFS"					, 0xA0EE},
	{"vDtrmV3"					, 0xA0EF},
	{"vBMChk"					, 0xA0F0},
	{"vTstMod"					, 0xA0F1},
	{"vLocCRec"					, 0xA0F2},
	{"vTreeSearch"				, 0xA0F3},
	{"vMapFBlock"				, 0xA0F4},
	{"vXFSearch"				, 0xA0F5},
	{"vReadBM"					, 0xA0F6},
	{"vDoEject"					, 0xA0F7},
	{"vSegStack"				, 0xA0F8},
	{"vSuperLoad"				, 0xA0F9},
	{"vCmpFrm"					, 0xA0FA},
	{"vNewMap"					, 0xA0FB},
	{"vCheckLoad"				, 0xA0FC},
	{"XTrimMeasure"				, 0xA0FD},
	{"XFindWord"				, 0xA0FE},
	{"XFindLine"				, 0xA0FF},
	{"GetZone"					, 0xA11A},
	{"MaxMem"					, 0xA11D},
	{"NewPtr"					, 0xA11E},
	{"NewHandle"				, 0xA122},
	{"HandleZone"				, 0xA126},
	{"RecoverHandle"			, 0xA128},
	{"PPostEvent"				, 0xA12F},
	{"DrvrInstall"				, 0xA13D},
	{"GetTrapAddress"			, 0xA146},
	{"PtrZone"					, 0xA148},
	{"MemoryDispatch"			, 0xA15C},
	{"PurgeSpace"				, 0xA162},
	{"NewEmptyHandle"			, 0xA166},
	{"Microseconds"				, 0xA193},
	{"HWPriv"					, 0xA198},
	{"Gestalt"					, 0xA1AD},
	{"HOpen"					, 0xA200},
	{"HGetVInfo"				, 0xA207},
	{"HCreate"					, 0xA208},
	{"HDelete"					, 0xA209},
	{"HOpenRF"					, 0xA20A},
	{"HRename"					, 0xA20B},
	{"HGetFileInfo"				, 0xA20C},
	{"HSetFileInfo"				, 0xA20D},
	{"HUnmountVol"				, 0xA20E},
	{"AllocContig"				, 0xA210},
	{"HGetVol"					, 0xA214},
	{"HSetVol"					, 0xA215},
	{"BlockMoveData"			, 0xA22E},
	{"HSetFLock"				, 0xA241},
	{"HRstFLock"				, 0xA242},
	{"SetOSTrapAddress"			, 0xA247},
	{"StripText"				, 0xA256},
	{"HFSDispatch"				, 0xA260},
	{"IdleUpdate"				, 0xA285},
	{"SleepQInstall"			, 0xA28A},
	{"NewPtrClear"				, 0xA31E},
	{"NewHandleClear"			, 0xA322},
	{"GetOSTrapAddress"			, 0xA346},
	{"NewGestalt"				, 0xA3AD},
	{"DrvrInstallRsrvMem"		, 0xA43D},
	{"UpperText"				, 0xA456},
	{"InsXTime"					, 0xA458},
	{"IdleState"				, 0xA485},
	{"SleepQRemove"				, 0xA48A},
	{"NewPtrSys"				, 0xA51E},
	{"NewHandleSys"				, 0xA522},
	{"DrvrInstallRsrvMem"		, 0xA53D},
	{"PurgeSpaceSys"			, 0xA562},
	{"ReplaceGestalt"			, 0xA5AD},
	{"SetToolBoxTrapAddress"	, 0xA647},
	{"StripUpperText"			, 0xA656},
	{"SerialPower"				, 0xA685},
	{"NewPtrSysClear"			, 0xA71E},
	{"NewHandleSysClear"		, 0xA722},
	{"GetToolBoxTrapAddress"	, 0xA746},
	{"GetToolTrapAddress"		, 0xA746},
	{"GetGestaltProcPtr"		, 0xA7AD},
	{"SoundDispatch"			, 0xA800},
	{"SndDisposeChannel"		, 0xA801},
	{"SndAddModifier"			, 0xA802},
	{"SndDoCommand"				, 0xA803},
	{"SndDoImmediate"			, 0xA804},
	{"SndPlay"					, 0xA805},
	{"SndControl"				, 0xA806},
	{"SndNewChannel"			, 0xA807},
	{"InitProcMenu"				, 0xA808},
	{"GetControlVariant"		, 0xA809},
	{"GetWVariant"				, 0xA80A},
	{"PopUpMenuSelect"			, 0xA80B},
	{"RGetResource"				, 0xA80C},
	{"Count1Resources"			, 0xA80D},
	{"Get1IxResource"			, 0xA80E},
	{"Get1IxType"				, 0xA80F},
	{"Unique1ID"				, 0xA810},
	{"TESelView"				, 0xA811},
	{"TEPinScroll"				, 0xA812},
	{"TEAutoView"				, 0xA813},
	{"SetFractEnable"			, 0xA814},
	{"SCSIDispatch"				, 0xA815},
	{"Pack8"					, 0xA816},
	{"CopyMask"					, 0xA817},
	{"FixATan2"					, 0xA818},
	{"XMunger"					, 0xA819},
	{"HOpenResFile"				, 0xA81A},
	{"HCreateResFile"			, 0xA81B},
	{"Count1Types"				, 0xA81C},
	{"InvalMenuBar"				, 0xA81D},
	{"SaveRestoreBits"			, 0xA81E},
	{"Get1Resource"				, 0xA81F},
	{"Get1NamedResource"		, 0xA820},
	{"MaxSizeRsrc"				, 0xA821},
	{"ResourceDispatch"			, 0xA822},
	{"AliasDispatch"			, 0xA823},
	{"FSMgr"					, 0xA824},
	{"MenuDispatch"				, 0xA825},
	{"InsertMenuItem"			, 0xA826},
	{"HideDialogItem"			, 0xA827},
	{"ShowDialogItem"			, 0xA828},
	{"LayerDispatch"			, 0xA829},
	{"ComponentDispatch"		, 0xA82A},
	{"Pack9"					, 0xA82B},
	{"Pack10"					, 0xA82C},
	{"Pack11"					, 0xA82D},
	{"Pack12"					, 0xA82E},
	{"Pack13"					, 0xA82F},
	{"Pack14"					, 0xA830},
	{"Pack15"					, 0xA831},
	{"QuickDrawGX"				, 0xA832},
	{"ScrnBitMap"				, 0xA833},
	{"SetFScaleDisable"			, 0xA834},
	{"FontMetrics"				, 0xA835},
	{"GetMaskTable"				, 0xA836},
	{"MeasureText"				, 0xA837},
	{"CalcMask"					, 0xA838},
	{"SeedFill"					, 0xA839},
	{"ZoomWindow"				, 0xA83A},
	{"TrackBox"					, 0xA83B},
	{"TEGetOffset"				, 0xA83C},
	{"TEDispatch"				, 0xA83D},
	{"TEStyleNew"				, 0xA83E},
	{"Long2Fix"					, 0xA83F},
	{"Fix2Long"					, 0xA840},
	{"Fix2Frac"					, 0xA841},
	{"Frac2Fix"					, 0xA842},
	{"Fix2X"					, 0xA843},
	{"X2Fix"					, 0xA844},
	{"Frac2X"					, 0xA845},
	{"X2Frac"					, 0xA846},
	{"FracCos"					, 0xA847},
	{"FracSin"					, 0xA848},
	{"FracSqrt"					, 0xA849},
	{"FracMul"					, 0xA84A},
	{"FracDiv"					, 0xA84B},
	{"UserDelay"				, 0xA84C},
	{"FixDiv"					, 0xA84D},
	{"GetItemCmd"				, 0xA84E},
	{"SetItemCmd"				, 0xA84F},
	{"InitCursor"				, 0xA850},
	{"SetCursor"				, 0xA851},
	{"HideCursor"				, 0xA852},
	{"ShowCursor"				, 0xA853},
	{"FontDispatch"				, 0xA854},
	{"ShieldCursor"				, 0xA855},
	{"ObscureCursor"			, 0xA856},
	{"SetEntry"					, 0xA857},
	{"BitAnd"					, 0xA858},
	{"BitXOr"					, 0xA859},
	{"BitNot"					, 0xA85A},
	{"BitOr"					, 0xA85B},
	{"BitShift"					, 0xA85C},
	{"BitTst"					, 0xA85D},
	{"BitSet"					, 0xA85E},
	{"BitClr"					, 0xA85F},
	{"WaitNextEvent"			, 0xA860},
	{"Random"					, 0xA861},
	{"ForeColor"				, 0xA862},
	{"BackColor"				, 0xA863},
	{"ColorBit"					, 0xA864},
	{"GetPixel"					, 0xA865},
	{"StuffHex"					, 0xA866},
	{"LongMul"					, 0xA867},
	{"FixMul"					, 0xA868},
	{"FixRatio"					, 0xA869},
	{"HiWord"					, 0xA86A},
	{"LoWord"					, 0xA86B},
	{"FixRound"					, 0xA86C},
	{"InitPort"					, 0xA86D},
	{"InitGraf"					, 0xA86E},
	{"OpenPort"					, 0xA86F},
	{"LocalToGlobal"			, 0xA870},
	{"GlobalToLocal"			, 0xA871},
	{"GrafDevice"				, 0xA872},
	{"SetPort"					, 0xA873},
	{"GetPort"					, 0xA874},
	{"SetPBits"					, 0xA875},
	{"PortSize"					, 0xA876},
	{"MovePortTo"				, 0xA877},
	{"SetOrigin"				, 0xA878},
	{"SetClip"					, 0xA879},
	{"GetClip"					, 0xA87A},
	{"ClipRect"					, 0xA87B},
	{"BackPat"					, 0xA87C},
	{"ClosePort"				, 0xA87D},
	{"AddPt"					, 0xA87E},
	{"SubPt"					, 0xA87F},
	{"SetPt"					, 0xA880},
	{"EqualPt"					, 0xA881},
	{"StdText"					, 0xA882},
	{"DrawChar"					, 0xA883},
	{"DrawString"				, 0xA884},
	{"DrawText"					, 0xA885},
	{"TextWidth"				, 0xA886},
	{"TextFont"					, 0xA887},
	{"TextFace"					, 0xA888},
	{"TextMode"					, 0xA889},
	{"TextSize"					, 0xA88A},
	{"GetFontInfo"				, 0xA88B},
	{"StringWidth"				, 0xA88C},
	{"CharWidth"				, 0xA88D},
	{"SpaceExtra"				, 0xA88E},
	{"OSDispatch"				, 0xA88F},
	{"StdLine"					, 0xA890},
	{"LineTo"					, 0xA891},
	{"Line"						, 0xA892},
	{"MoveTo"					, 0xA893},
	{"Move"						, 0xA894},
	{"ShutDown"					, 0xA895},
	{"HidePen"					, 0xA896},
	{"ShowPen"					, 0xA897},
	{"GetPenState"				, 0xA898},
	{"SetPenState"				, 0xA899},
	{"GetPen"					, 0xA89A},
	{"PenSize"					, 0xA89B},
	{"PenMode"					, 0xA89C},
	{"PenPat"					, 0xA89D},
	{"PenNormal"				, 0xA89E},
	{"Unimplemented"			, 0xA89F},
	{"StdRect"					, 0xA8A0},
	{"FrameRect"				, 0xA8A1},
	{"PaintRect"				, 0xA8A2},
	{"EraseRect"				, 0xA8A3},
	{"InverRect"				, 0xA8A4},
	{"FillRect"					, 0xA8A5},
	{"EqualRect"				, 0xA8A6},
	{"SetRect"					, 0xA8A7},
	{"OffsetRect"				, 0xA8A8},
	{"InsetRect"				, 0xA8A9},
	{"SectRect"					, 0xA8AA},
	{"UnionRect"				, 0xA8AB},
	{"Pt2Rect"					, 0xA8AC},
	{"PtInRect"					, 0xA8AD},
	{"EmptyRect"				, 0xA8AE},
	{"StdRRect"					, 0xA8AF},
	{"FrameRoundRect"			, 0xA8B0},
	{"PaintRoundRect"			, 0xA8B1},
	{"EraseRoundRect"			, 0xA8B2},
	{"InverRoundRect"			, 0xA8B3},
	{"FillRoundRect"			, 0xA8B4},
	{"ScriptUtil"				, 0xA8B5},
	{"StdOval"					, 0xA8B6},
	{"FrameOval"				, 0xA8B7},
	{"PaintOval"				, 0xA8B8},
	{"EraseOval"				, 0xA8B9},
	{"InvertOval"				, 0xA8BA},
	{"FillOval"					, 0xA8BB},
	{"SlopeFromAngle"			, 0xA8BC},
	{"StdArc"					, 0xA8BD},
	{"FrameArc"					, 0xA8BE},
	{"PaintArc"					, 0xA8BF},
	{"EraseArc"					, 0xA8C0},
	{"InvertArc"				, 0xA8C1},
	{"FillArc"					, 0xA8C2},
	{"PtToAngle"				, 0xA8C3},
	{"AngleFromSlope"			, 0xA8C4},
	{"StdPoly"					, 0xA8C5},
	{"FramePoly"				, 0xA8C6},
	{"PaintPoly"				, 0xA8C7},
	{"ErasePoly"				, 0xA8C8},
	{"InvertPoly"				, 0xA8C9},
	{"FillPoly"					, 0xA8CA},
	{"OpenPoly"					, 0xA8CB},
	{"ClosePoly"				, 0xA8CC},
	{"KillPoly"					, 0xA8CD},
	{"OffsetPoly"				, 0xA8CE},
	{"PackBits"					, 0xA8CF},
	{"UnpackBits"				, 0xA8D0},
	{"StdRgn"					, 0xA8D1},
	{"FrameRgn"					, 0xA8D2},
	{"PaintRgn"					, 0xA8D3},
	{"EraseRgn"					, 0xA8D4},
	{"InverRgn"					, 0xA8D5},
	{"FillRgn"					, 0xA8D6},
	{"BitMapToRegion"			, 0xA8D7},
	{"NewRgn"					, 0xA8D8},
	{"DisposeRgn"				, 0xA8D9},
	{"OpenRgn"					, 0xA8DA},
	{"CloseRgn"					, 0xA8DB},
	{"CopyRgn"					, 0xA8DC},
	{"SetEmptyRgn"				, 0xA8DD},
	{"SetRecRgn"				, 0xA8DE},
	{"RectRgn"					, 0xA8DF},
	{"OffsetRgn"				, 0xA8E0},
	{"InsetRgn"					, 0xA8E1},
	{"EmptyRgn"					, 0xA8E2},
	{"EqualRgn"					, 0xA8E3},
	{"SectRgn"					, 0xA8E4},
	{"UnionRgn"					, 0xA8E5},
	{"DiffRgn"					, 0xA8E6},
	{"XOrRgn"					, 0xA8E7},
	{"PtInRgn"					, 0xA8E8},
	{"RectInRgn"				, 0xA8E9},
	{"SetStdProcs"				, 0xA8EA},
	{"StdBits"					, 0xA8EB},
	{"CopyBits"					, 0xA8EC},
	{"StdTxMeas"				, 0xA8ED},
	{"StdGetPic"				, 0xA8EE},
	{"ScrollRect"				, 0xA8EF},
	{"StdPutPic"				, 0xA8F0},
	{"StdComment"				, 0xA8F1},
	{"PicComment"				, 0xA8F2},
	{"OpenPicture"				, 0xA8F3},
	{"ClosePicture"				, 0xA8F4},
	{"KillPicture"				, 0xA8F5},
	{"DrawPicture"				, 0xA8F6},
	{"Layout"					, 0xA8F7},
	{"ScalePt"					, 0xA8F8},
	{"MapPt"					, 0xA8F9},
	{"MapRect"					, 0xA8FA},
	{"MapRgn"					, 0xA8FB},
	{"MapPoly"					, 0xA8FC},
	{"PrGlue"					, 0xA8FD},
	{"InitFonts"				, 0xA8FE},
	{"GetFName"					, 0xA8FF},
	{"GetFNum"					, 0xA900},
	{"FMSwapFont"				, 0xA901},
	{"RealFont"					, 0xA902},
	{"SetFontLock"				, 0xA903},
	{"DrawGrowIcon"				, 0xA904},
	{"DragGrayRgn"				, 0xA905},
	{"NewString"				, 0xA906},
	{"SetString"				, 0xA907},
	{"ShowHide"					, 0xA908},
	{"CalcVis"					, 0xA909},
	{"CalcVBehind"				, 0xA90A},
	{"ClipAbove"				, 0xA90B},
	{"PaintOne"					, 0xA90C},
	{"PaintBehind"				, 0xA90D},
	{"SaveOld"					, 0xA90E},
	{"DrawNew"					, 0xA90F},
	{"GetWMgrPort"				, 0xA910},
	{"CheckUpDate"				, 0xA911},
	{"InitWindows"				, 0xA912},
	{"NewWindow"				, 0xA913},
	{"DisposeWindow"			, 0xA914},
	{"ShowWindow"				, 0xA915},
	{"HideWindow"				, 0xA916},
	{"GetWRefCon"				, 0xA917},
	{"SetWRefCon"				, 0xA918},
	{"GetWTitle"				, 0xA919},
	{"SetWTitle"				, 0xA91A},
	{"MoveWindow"				, 0xA91B},
	{"HiliteWindow"				, 0xA91C},
	{"SizeWindow"				, 0xA91D},
	{"TrackGoAway"				, 0xA91E},
	{"SelectWindow"				, 0xA91F},
	{"BringToFront"				, 0xA920},
	{"SendBehind"				, 0xA921},
	{"BeginUpDate"				, 0xA922},
	{"EndUpDate"				, 0xA923},
	{"FrontWindow"				, 0xA924},
	{"DragWindow"				, 0xA925},
	{"DragTheRgn"				, 0xA926},
	{"InvalRgn"					, 0xA927},
	{"InvalRect"				, 0xA928},
	{"ValidRgn"					, 0xA929},
	{"ValidRect"				, 0xA92A},
	{"GrowWindow"				, 0xA92B},
	{"FindWindow"				, 0xA92C},
	{"CloseWindow"				, 0xA92D},
	{"SetWindowPic"				, 0xA92E},
	{"GetWindowPic"				, 0xA92F},
	{"InitMenus"				, 0xA930},
	{"NewMenu"					, 0xA931},
	{"DisposeMenu"				, 0xA932},
	{"AppendMenu"				, 0xA933},
	{"ClearMenuBar"				, 0xA934},
	{"InsertMenu"				, 0xA935},
	{"DeleteMenu"				, 0xA936},
	{"DrawMenuBar"				, 0xA937},
	{"HiliteMenu"				, 0xA938},
	{"EnableItem"				, 0xA939},
	{"DisableItem"				, 0xA93A},
	{"GetMenuBar"				, 0xA93B},
	{"SetMenuBar"				, 0xA93C},
	{"MenuSelect"				, 0xA93D},
	{"MenuKey"					, 0xA93E},
	{"GetItmIcon"				, 0xA93F},
	{"SetItmIcon"				, 0xA940},
	{"GetItmStyle"				, 0xA941},
	{"SetItmStyle"				, 0xA942},
	{"GetItmMark"				, 0xA943},
	{"SetItmMark"				, 0xA944},
	{"CheckItem"				, 0xA945},
	{"GetMenuItemText"			, 0xA946},
	{"SetMenuItemText"			, 0xA947},
	{"CalcMenuSize"				, 0xA948},
	{"GetMenuHandle"			, 0xA949},
	{"SetMFlash"				, 0xA94A},
	{"PlotIcon"					, 0xA94B},
	{"FlashMenuBar"				, 0xA94C},
	{"AppendResMenu"			, 0xA94D},
	{"PinRect"					, 0xA94E},
	{"DeltaPoint"				, 0xA94F},
	{"CountMItems"				, 0xA950},
	{"InsertResMenu"			, 0xA951},
	{"DeleteMenuItem"			, 0xA952},
	{"UpdtControl"				, 0xA953},
	{"NewControl"				, 0xA954},
	{"DisposeControl"			, 0xA955},
	{"KillControls"				, 0xA956},
	{"ShowControl"				, 0xA957},
	{"HideControl"				, 0xA958},
	{"MoveControl"				, 0xA959},
	{"GetControlReference"		, 0xA95A},
	{"SetControlReference"		, 0xA95B},
	{"SizeControl"				, 0xA95C},
	{"HiliteControl"			, 0xA95D},
	{"GetControlTitle"			, 0xA95E},
	{"SetControlTitle"			, 0xA95F},
	{"GetControlValue"			, 0xA960},
	{"GetControlMinimum"		, 0xA961},
	{"GetControlMaximum"		, 0xA962},
	{"SetControlValue"			, 0xA963},
	{"SetControlMinimum"		, 0xA964},
	{"SetControlMaximum"		, 0xA965},
	{"TestControl"				, 0xA966},
	{"DragControl"				, 0xA967},
	{"TrackControl"				, 0xA968},
	{"DrawControls"				, 0xA969},
	{"GetControlAction"			, 0xA96A},
	{"SetControlAction"			, 0xA96B},
	{"FindControl"				, 0xA96C},
	{"Draw1Control"				, 0xA96D},
	{"Dequeue"					, 0xA96E},
	{"Enqueue"					, 0xA96F},
	{"GetNextEvent"				, 0xA970},
	{"EventAvail"				, 0xA971},
	{"GetMouse"					, 0xA972},
	{"StillDown"				, 0xA973},
	{"Button"					, 0xA974},
	{"TickCount"				, 0xA975},
	{"GetKeys"					, 0xA976},
	{"WaitMouseUp"				, 0xA977},
	{"UpdtDialog"				, 0xA978},
	{"CouldDialog"				, 0xA979},
	{"FreeDialog"				, 0xA97A},
	{"InitDialogs"				, 0xA97B},
	{"GetNewDialog"				, 0xA97C},
	{"NewDialog"				, 0xA97D},
	{"SelectDialogItemText"		, 0xA97E},
	{"IsDialogEvent"			, 0xA97F},
	{"DialogSelect"				, 0xA980},
	{"DrawDialog"				, 0xA981},
	{"CloseDialog"				, 0xA982},
	{"DisposeDialog"			, 0xA983},
	{"FindDialogItem"			, 0xA984},
	{"Alert"					, 0xA985},
	{"StopAlert"				, 0xA986},
	{"NoteAlert"				, 0xA987},
	{"CautionAlert"				, 0xA988},
	{"CouldAlert"				, 0xA989},
	{"FreeAlert"				, 0xA98A},
	{"ParamText"				, 0xA98B},
	{"ErrorSound"				, 0xA98C},
	{"GetDialogItem"			, 0xA98D},
	{"SetDialogItem"			, 0xA98E},
	{"SetDialogItemText"		, 0xA98F},
	{"GetDialogItemText"		, 0xA990},
	{"ModalDialog"				, 0xA991},
	{"DetachResource"			, 0xA992},
	{"SetResPurge"				, 0xA993},
	{"CurResFile"				, 0xA994},
	{"InitResources"			, 0xA995},
	{"RsrcZoneInit"				, 0xA996},
	{"OpenResFile"				, 0xA997},
	{"UseResFile"				, 0xA998},
	{"UpdateResFile"			, 0xA999},
	{"CloseResFile"				, 0xA99A},
	{"SetResLoad"				, 0xA99B},
	{"CountResources"			, 0xA99C},
	{"GetIndResource"			, 0xA99D},
	{"CountTypes"				, 0xA99E},
	{"GetIndType"				, 0xA99F},
	{"GetResource"				, 0xA9A0},
	{"GetNamedResource"			, 0xA9A1},
	{"LoadResource"				, 0xA9A2},
	{"ReleaseResource"			, 0xA9A3},
	{"HomeResFile"				, 0xA9A4},
	{"SizeRsrc"					, 0xA9A5},
	{"GetResAttrs"				, 0xA9A6},
	{"SetResAttrs"				, 0xA9A7},
	{"GetResInfo"				, 0xA9A8},
	{"SetResInfo"				, 0xA9A9},
	{"ChangedResource"			, 0xA9AA},
	{"AddResource"				, 0xA9AB},
	{"AddReference"				, 0xA9AC},
	{"RmveResource"				, 0xA9AD},
	{"RmveReference"			, 0xA9AE},
	{"ResError"					, 0xA9AF},
	{"WriteResource"			, 0xA9B0},
	{"CreateResFile"			, 0xA9B1},
	{"SystemEvent"				, 0xA9B2},
	{"SystemClick"				, 0xA9B3},
	{"SystemTask"				, 0xA9B4},
	{"SystemMenu"				, 0xA9B5},
	{"OpenDeskAcc"				, 0xA9B6},
	{"CloseDeskAcc"				, 0xA9B7},
	{"GetPattern"				, 0xA9B8},
	{"GetCursor"				, 0xA9B9},
	{"GetString"				, 0xA9BA},
	{"GetIcon"					, 0xA9BB},
	{"GetPicture"				, 0xA9BC},
	{"GetNewWindow"				, 0xA9BD},
	{"GetNewControl"			, 0xA9BE},
	{"GetRMenu"					, 0xA9BF},
	{"GetNewMBar"				, 0xA9C0},
	{"UniqueID"					, 0xA9C1},
	{"SysEdit"					, 0xA9C2},
	{"KeyTranslate"				, 0xA9C3},
	{"OpenRFPerm"				, 0xA9C4},
	{"RsrcMapEntry"				, 0xA9C5},
	{"SecondsToDate"			, 0xA9C6},
	{"DateToSeconds"			, 0xA9C7},
	{"SysBeep"					, 0xA9C8},
	{"SysError"					, 0xA9C9},
	{"PutIcon"					, 0xA9CA},
	{"TEGetText"				, 0xA9CB},
	{"TEInit"					, 0xA9CC},
	{"TEDispose"				, 0xA9CD},
	{"TETextBox"				, 0xA9CE},
	{"TESetText"				, 0xA9CF},
	{"TECalText"				, 0xA9D0},
	{"TESetSelect"				, 0xA9D1},
	{"TENew"					, 0xA9D2},
	{"TEUpdate"					, 0xA9D3},
	{"TEClick"					, 0xA9D4},
	{"TECopy"					, 0xA9D5},
	{"TECut"					, 0xA9D6},
	{"TEDelete"					, 0xA9D7},
	{"TEActivate"				, 0xA9D8},
	{"TEDeactivate"				, 0xA9D9},
	{"TEIdle"					, 0xA9DA},
	{"TEPaste"					, 0xA9DB},
	{"TEKey"					, 0xA9DC},
	{"TEScroll"					, 0xA9DD},
	{"TEInsert"					, 0xA9DE},
	{"TESetAlignment"			, 0xA9DF},
	{"Munger"					, 0xA9E0},
	{"HandToHand"				, 0xA9E1},
	{"PtrToXHand"				, 0xA9E2},
	{"PtrToHand"				, 0xA9E3},
	{"HandAndHand"				, 0xA9E4},
	{"InitPack"					, 0xA9E5},
	{"InitAllPacks"				, 0xA9E6},
	{"Pack0"					, 0xA9E7},
	{"Pack1"					, 0xA9E8},
	{"Pack2"					, 0xA9E9},
	{"Pack3"					, 0xA9EA},
	{"FP68K"					, 0xA9EB},
	{"Elems68K"					, 0xA9EC},
	{"Pack6"					, 0xA9ED},
	{"DECSTR68K"				, 0xA9EE},
	{"PtrAndHand"				, 0xA9EF},
	{"LoadSeg"					, 0xA9F0},
	{"UnLoadSeg"				, 0xA9F1},
	{"Launch"					, 0xA9F2},
	{"Chain"					, 0xA9F3},
	{"ExitToShell"				, 0xA9F4},
	{"GetAppParms"				, 0xA9F5},
	{"GetResFileAttrs"			, 0xA9F6},
	{"SetResFileAttrs"			, 0xA9F7},
	{"MethodDispatch"			, 0xA9F8},
	{"InfoScrap"				, 0xA9F9},
	{"UnloadScrap"				, 0xA9FA},
	{"LoadScrap"				, 0xA9FB},
	{"ZeroScrap"				, 0xA9FC},
	{"GetScrap"					, 0xA9FD},
	{"PutScrap"					, 0xA9FE},
	{"Debugger"					, 0xA9FF},
	{"OpenCPort"				, 0xAA00},
	{"InitCPort"				, 0xAA01},
	{"CloseCPort"				, 0xAA02},
	{"NewPixMap"				, 0xAA03},
	{"DisposePixMap"			, 0xAA04},
	{"CopyPixMap"				, 0xAA05},
	{"SetPortPix"				, 0xAA06},
	{"NewPixPat"				, 0xAA07},
	{"DisposePixPat"			, 0xAA08},
	{"CopyPixPat"				, 0xAA09},
	{"PenPixPat"				, 0xAA0A},
	{"BackPixPat"				, 0xAA0B},
	{"GetPixPat"				, 0xAA0C},
	{"MakeRGBPat"				, 0xAA0D},
	{"FillCRect"				, 0xAA0E},
	{"FillCOval"				, 0xAA0F},
	{"FillCRoundRect"			, 0xAA10},
	{"FillCArc"					, 0xAA11},
	{"FillCRgn"					, 0xAA12},
	{"FillCPoly"				, 0xAA13},
	{"RGBForeColor"				, 0xAA14},
	{"RGBBackColor"				, 0xAA15},
	{"SetCPixel"				, 0xAA16},
	{"GetCPixel"				, 0xAA17},
	{"GetCTable"				, 0xAA18},
	{"GetForeColor"				, 0xAA19},
	{"GetBackColor"				, 0xAA1A},
	{"GetCCursor"				, 0xAA1B},
	{"SetCCursor"				, 0xAA1C},
	{"AllocCursor"				, 0xAA1D},
	{"GetCIcon"					, 0xAA1E},
	{"PlotCIcon"				, 0xAA1F},
	{"OpenCPicture"				, 0xAA20},
	{"OpColor"					, 0xAA21},
	{"HiliteColor"				, 0xAA22},
	{"CharExtra"				, 0xAA23},
	{"DisposeCTable"			, 0xAA24},
	{"DisposeCIcon"				, 0xAA25},
	{"DisposeCCursor"			, 0xAA26},
	{"GetMaxDevice"				, 0xAA27},
	{"GetCTSeed"				, 0xAA28},
	{"GetDeviceList"			, 0xAA29},
	{"GetMainDevice"			, 0xAA2A},
	{"GetNextDevice"			, 0xAA2B},
	{"TestDeviceAttribute"		, 0xAA2C},
	{"SetDeviceAttribute"		, 0xAA2D},
	{"InitGDevice"				, 0xAA2E},
	{"NewGDevice"				, 0xAA2F},
	{"DisposeGDevice"			, 0xAA30},
	{"SetGDevice"				, 0xAA31},
	{"GetGDevice"				, 0xAA32},
	{"Color2Index"				, 0xAA33},
	{"Index2Color"				, 0xAA34},
	{"InvertColor"				, 0xAA35},
	{"RealColor"				, 0xAA36},
	{"GetSubTable"				, 0xAA37},
	{"UpdatePixMap"				, 0xAA38},
	{"MakeITable"				, 0xAA39},
	{"AddSearch"				, 0xAA3A},
	{"AddComp"					, 0xAA3B},
	{"SetClientID"				, 0xAA3C},
	{"ProtectEntry"				, 0xAA3D},
	{"ReserveEntry"				, 0xAA3E},
	{"SetEntries"				, 0xAA3F},
	{"QDError"					, 0xAA40},
	{"SetWinColor"				, 0xAA41},
	{"GetAuxWin"				, 0xAA42},
	{"SetControlColor"			, 0xAA43},
	{"GetAuxiliaryControlRecord", 0xAA44},
	{"NewCWindow"				, 0xAA45},
	{"GetNewCWindow"			, 0xAA46},
	{"SetDeskCPat"				, 0xAA47},
	{"GetCWMgrPort"				, 0xAA48},
	{"SaveEntries"				, 0xAA49},
	{"RestoreEntries"			, 0xAA4A},
	{"NewColorDialog"			, 0xAA4B},
	{"DelSearch"				, 0xAA4C},
	{"DelComp"					, 0xAA4D},
	{"SetStdCProcs"				, 0xAA4E},
	{"CalcCMask"				, 0xAA4F},
	{"SeedCFill"				, 0xAA50},
	{"CopyDeepMask"				, 0xAA51},
	{"HighLevelFSDispatch"		, 0xAA52},
	{"DictionaryDispatch"		, 0xAA53},
	{"TextServicesDispatch"		, 0xAA54},
	{"KobeMgr"					, 0xAA55},
	{"SpeechRecognitionDispatch", 0xAA56},
	{"DockingDispatch"			, 0xAA57},
	{"NewKernelDispatch"		, 0xAA58},
	{"MixedModeDispatch"		, 0xAA59},
	{"CodeFragmentDispatch"		, 0xAA5A},
	{"PBRemoteAccess"			, 0xAA5B},
	{"OCEUtils"					, 0xAA5C},
	{"DigitalSignature"			, 0xAA5D},
	{"OCETBDispatch"			, 0xAA5E},
	{"OCEAuthentication"		, 0xAA5F},
	{"DeleteMCEntries"			, 0xAA60},
	{"GetMCInfo"				, 0xAA61},
	{"SetMCInfo"				, 0xAA62},
	{"DisposeMCInfo"			, 0xAA63},
	{"GetMCEntry"				, 0xAA64},
	{"SetMCEntries"				, 0xAA65},
	{"MenuChoice"				, 0xAA66},
	{"ModalDialogMenuSetup"		, 0xAA67},
	{"DialogDispatch"			, 0xAA68},
	{"UserNameNotification"		, 0xAA69},
	{"DeviceMgr"				, 0xAA6A},
	{"PowerPCFuture"			, 0xAA6B},
	{"PenMacMgr"				, 0xAA6C},
	{"LanguageMgr"				, 0xAA6D},
	{"AppleGuideDispatch"		, 0xAA6E},
	{"InitPalettes"				, 0xAA90},
	{"NewPalette"				, 0xAA91},
	{"GetNewPalette"			, 0xAA92},
	{"DisposePalette"			, 0xAA93},
	{"ActivatePalette"			, 0xAA94},
	{"SetPalette"				, 0xAA95},
	{"GetPalette"				, 0xAA96},
	{"PmForeColor"				, 0xAA97},
	{"PmBackColor"				, 0xAA98},
	{"AnimateEntry"				, 0xAA99},
	{"AnimatePalette"			, 0xAA9A},
	{"GetEntryColor"			, 0xAA9B},
	{"SetEntryColor"			, 0xAA9C},
	{"GetEntryUsage"			, 0xAA9D},
	{"SetEntryUsage"			, 0xAA9E},
	{"CTab2Palette"				, 0xAA9F},
	{"Palette2CTab"				, 0xAAA0},
	{"CopyPalette"				, 0xAAA1},
	{"PaletteDispatch"			, 0xAAA2},
	{"CodecDispatch"			, 0xAAA3},
	{"ALMDispatch"				, 0xAAA4},
	{"QuickTimeDispatch"		, 0xAAAA},
	{"CursorDeviceDispatch"		, 0xAADB},
	{"HumanInterfaceUtilsDispatch", 0xAADD},
	{"AppleScript"				, 0xAAEE},
	{"PCCardDispatch"			, 0xAAF0},
	{"ATAMgr"					, 0xAAF1},
	{"ControlStripDispatch"		, 0xAAF2},
	{"ExpansionBusDispatch"		, 0xAAF3},
	{"InterruptMgr"				, 0xAAF4},
	{"InitApplication"			, 0xAAFA},
	{"CleanupApplication"		, 0xAAFB},
	{"MixedModeMagic"			, 0xAAFE},
	{"BitBlt"					, 0xAB00},
	{"BitsToMap"				, 0xAB01},
	{"BitsToPix"				, 0xAB02},
	{"Jackson"					, 0xAB03},
	{"ColorMap"					, 0xAB04},
	{"CopyHandle"				, 0xAB05},
	{"CullPoints"				, 0xAB06},
	{"PutPicByte"				, 0xAB07},
	{"PutPicOp"					, 0xAB08},
	{"DrawArc"					, 0xAB09},
	{"DrawLine"					, 0xAB0A},
	{"DrawSlab"					, 0xAB0B},
	{"FastSlabMode"				, 0xAB0C},
	{"GetSeek"					, 0xAB0D},
	{"MakeScaleTbl"				, 0xAB0E},
	{"CheckPic"					, 0xAB0F},
	{"DoLine"					, 0xAB10},
	{"OldPatToNew"				, 0xAB11},
	{"PackRgn"					, 0xAB12},
	{"PatConvert"				, 0xAB13},
	{"PatDither"				, 0xAB14},
	{"PatExpand"				, 0xAB15},
	{"PInit"					, 0xAB16},
	{"PortToMap"				, 0xAB17},
	{"PushVerb"					, 0xAB18},
	{"PutLine"					, 0xAB19},
	{"PutOval"					, 0xAB1A},
	{"PutRgn"					, 0xAB1B},
	{"NewTempBuffer"			, 0xAB1C},
	{"QDExtensions"				, 0xAB1D},
	{"DisposeTempBuffer"		, 0xAB1E},
	{"RgnBlit"					, 0xAB1F},
	{"RgnOp"					, 0xAB20},
	{"RSect"					, 0xAB21},
	{"SeekRgn"					, 0xAB22},
	{"SetFillPat"				, 0xAB23},
	{"SetUpStretch"				, 0xAB24},
	{"SlabMode"					, 0xAB25},
	{"SortPoints"				, 0xAB26},
	{"StretchBits"				, 0xAB27},
	{"StdDevLoop"				, 0xAB28},
	{"TrimRect"					, 0xAB29},
	{"XorSlab"					, 0xAB2A},
	{"ExTblPtr"					, 0xAB2B},
	{"NewTempHandle"			, 0xAB2D},
	{"PatExTbl"					, 0xAB2E},
	{"bMAIN0"					, 0xAB30},
	{"bMAIN1"					, 0xAB31},
	{"bMAIN2"					, 0xAB32},
	{"bMAIN3"					, 0xAB33},
	{"bSETUP8"					, 0xAB34},
	{"bMAIN9"					, 0xAB35},
	{"bSETUP10"					, 0xAB36},
	{"bMAIN11"					, 0xAB37},
	{"bXMAIN8"					, 0xAB38},
	{"bXMAIN9"					, 0xAB39},
	{"bXMAIN10"					, 0xAB3A},
	{"bXMAIN11"					, 0xAB3B},
	{"bcMain0"					, 0xAB3C},
	{"bcMain1"					, 0xAB3D},
	{"bHilite"					, 0xAB3E},
	{"bcMain3"					, 0xAB3F},
	{"bEND0"					, 0xAB40},
	{"bEND1"					, 0xAB41},
	{"bEND2"					, 0xAB42},
	{"bEND3"					, 0xAB43},
	{"bLONG8"					, 0xAB44},
	{"bEND9"					, 0xAB45},
	{"bEND10"					, 0xAB46},
	{"bEND11"					, 0xAB47},
	{"bXLONG8"					, 0xAB48},
	{"bXEND9"					, 0xAB49},
	{"bXEND10"					, 0xAB4A},
	{"bXEND11"					, 0xAB4B},
	{"bcEnd0"					, 0xAB4C},
	{"bcEnd1"					, 0xAB4D},
	{"bSlowHilite"				, 0xAB4E},
	{"bcEnd"					, 0xAB4F},
	{"bAvg"						, 0xAB50},
	{"bAddPin"					, 0xAB51},
	{"bAddOver"					, 0xAB52},
	{"bSubPin"					, 0xAB53},
	{"bTransparent"				, 0xAB54},
	{"bMax"						, 0xAB55},
	{"bSubOver"					, 0xAB56},
	{"bMin"						, 0xAB57},
	{"bSetup0"					, 0xAB58},
	{"bLeft0"					, 0xAB59},
	{"rMASK0"					, 0xAB5A},
	{"rMASK1"					, 0xAB5B},
	{"rMASK2"					, 0xAB5C},
	{"rMASK3"					, 0xAB5D},
	{"rMASK8"					, 0xAB5E},
	{"rMASK9"					, 0xAB5F},
	{"rMASK10"					, 0xAB60},
	{"rMASK11"					, 0xAB61},
	{"rXMASK8"					, 0xAB62},
	{"rXMASK9"					, 0xAB63},
	{"rXMASK10"					, 0xAB64},
	{"rXMASK11"					, 0xAB65},
	{"rAvg"						, 0xAB66},
	{"rAddPin"					, 0xAB67},
	{"rAddOver"					, 0xAB68},
	{"rSubPin"					, 0xAB69},
	{"rTransparent"				, 0xAB6A},
	{"rMax"						, 0xAB6B},
	{"rSubOver"					, 0xAB6C},
	{"rMin"						, 0xAB6D},
	{"rcMask0"					, 0xAB6E},
	{"rcMask1"					, 0xAB6F},
	{"rSlowHilite"				, 0xAB70},
	{"rcMask3"					, 0xAB71},
	{"rHilite"					, 0xAB72},
	{"stMASK0"					, 0xAB73},
	{"stMASK1"					, 0xAB74},
	{"stMASK2"					, 0xAB75},
	{"stMASK3"					, 0xAB76},
	{"stAvg"					, 0xAB77},
	{"stAddPin"					, 0xAB78},
	{"stAddOver"				, 0xAB79},
	{"stSubPin"					, 0xAB7A},
	{"stTransparent"			, 0xAB7B},
	{"stMax"					, 0xAB7C},
	{"stSubOver"				, 0xAB7D},
	{"stMin"					, 0xAB7E},
	{"stHilite"					, 0xAB7F},
	{"slMASK8"					, 0xAB80},
	{"slMASK9"					, 0xAB81},
	{"slMASK10"					, 0xAB82},
	{"slMASK11"					, 0xAB83},
	{"slXMASK8"					, 0xAB84},
	{"slXMASK9"					, 0xAB85},
	{"slXMASK10"				, 0xAB86},
	{"slXMASK11"				, 0xAB87},
	{"slAvg"					, 0xAB88},
	{"slAddPin"					, 0xAB89},
	{"slAddOver"				, 0xAB8A},
	{"slSubPin"					, 0xAB8B},
	{"slTransparent"			, 0xAB8C},
	{"slMax"					, 0xAB8D},
	{"slSubOver"				, 0xAB8E},
	{"slMin"					, 0xAB8F},
	{"slHilite"					, 0xAB90},
	{"ITabMatch"				, 0xAB91},
	{"ColorThing"				, 0xAB92},
	{"Pollack"					, 0xAB93},
	{"AllocRunBuf"				, 0xAB94},
	{"InitRgn"					, 0xAB95},
	{"ScaleBlt"					, 0xAB96},
	{"stNoStack"				, 0xAB97},
	{"BlitCase"					, 0xAB98},
	{"stScanLoop"				, 0xAB99},
	{"PicItem1"					, 0xAB9A},
	{"MakeGrayITab"				, 0xAB9B},
	{"FastLine"					, 0xAB9C},
	{"FastSlant"				, 0xAB9D},
	{"BitsDevLoop"				, 0xAB9E},
	{"rArith16Tab"				, 0xABA0},
	{"rArith32Tab"				, 0xABA1},
	{"rHiliteTab"				, 0xABA2},
	{"gsRunTbl"					, 0xABA3},
	{"gsExpTbl"					, 0xABA4},
	{"gsSeekTbl"				, 0xABA5},
	{"stArith16Tab"				, 0xABA6},
	{"stArith32Tab"				, 0xABA7},
	{"stColorTab"				, 0xABA8},
	{"stGrayTab"				, 0xABA9},
	{"stSearchTab"				, 0xABAA},
	{"ScaleIndToInd"			, 0xABAB},
	{"scIndTab1"				, 0xABAC},
	{"scIndTab2"				, 0xABAD},
	{"scIndTab4"				, 0xABAE},
	{"scIndTab8"				, 0xABAF},
	{"scIndTab16"				, 0xABB0},
	{"scIndTab32"				, 0xABB1},
	{"scDirTab1"				, 0xABB2},
	{"scDirTab2"				, 0xABB3},
	{"scDirTab4"				, 0xABB4},
	{"scDirTab8"				, 0xABB5},
	{"scDirTab16"				, 0xABB6},
	{"scDirTab32"				, 0xABB7},
	{"bArith16Tab"				, 0xABB8},
	{"bArith32Tab"				, 0xABB9},
	{"bHiliteTab"				, 0xABBA},
	{"bArith16Setup"			, 0xABBB},
	{"bArith32Setup"			, 0xABBC},
	{"slArith16Tab"				, 0xABBD},
	{"slArith32Tab"				, 0xABBE},
	{"32QD"						, 0xABBF},
	{"QDAlphaDispatch"			, 0xABC0},
	{"QDStreamToMask"			, 0xABC1},
	{"QTMatrixMathDispatch"		, 0xABC2},
	{"NQDMisc"					, 0xABC3},
	{"GetPMData"				, 0xABC4},
	{"32QD"						, 0xABC5},
	{"32QD"						, 0xABC6},
	{"32QD"						, 0xABC7},
	{"StdOpcodeProc"			, 0xABC8},
	{"IconDispatch"				, 0xABC9},
	{"DeviceLoop"				, 0xABCA},
	{"PBBlockMove"				, 0xABCC},
	{"SnappingTurk"				, 0xABCD},
	{"UnicodeMgr"				, 0xABCE},
	{"ProcessMgr"				, 0xABCF},
	{"ModemMgr"					, 0xABEA},
	{"DisplayDispatch"			, 0xABEB},
	{"ButtonMgr"				, 0xABEC},
	{"DragDispatch"				, 0xABED},
	{"ColorSync"				, 0xABEE},
	{"TTSMgr"					, 0xABEF},
	{"AROSE"					, 0xABF0},
	{"GestaltValueDispatch"		, 0xABF1},
	{"ThreadDispatch"			, 0xABF2},
	{"EddyTrap"					, 0xABF3},
	{"XTNDMgr"					, 0xABF4},
	{"DSPManager"				, 0xABF5},
	{"CollectionMgr"			, 0xABF6},
	{"SynchIdleTime"			, 0xABF7},
	{"StdOpcodeProc"			, 0xABF8},
	{"AUXDispatch"				, 0xABF9},
	{"AUXSysCall"				, 0xABFA},
	{"MessageMgr"				, 0xABFB},
	{"TranslationDispatch"		, 0xABFC},
	{"TouchStone"				, 0xABFD},
	{"GXPrinting"				, 0xABFE},
	{"DebugStr"					, 0xABFF},
	{""							, 0}
};

#endif
