/*
 * Copyright (c) 2017-2019 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef ARM_COMPUTE_GCACTIVATIONLAYER_H
#define ARM_COMPUTE_GCACTIVATIONLAYER_H

#include "arm_compute/core/Types.h"
#include "arm_compute/runtime/GLES_COMPUTE/IGCSimpleFunction.h"

namespace arm_compute
{
// Forward declarations
class IGCTensor;

/** Basic function to run @ref GCActivationLayerKernel
 *
 * @note The function simulates an activation layer with the specified activation function.
 */
class GCActivationLayer : public IGCSimpleFunction
{
public:
    /** Constructor
     *
     * @param[in, out] ctx Runtime context to be used by the function
     */
    explicit GCActivationLayer(GCRuntimeContext *ctx = nullptr);
    /** Prevent instances of this class from being copied (As this class contains pointers) */
    GCActivationLayer(const GCActivationLayer &) = delete;
    /** Default move constructor */
    GCActivationLayer(GCActivationLayer &&) = default;
    /** Prevent instances of this class from being copied (As this class contains pointers) */
    GCActivationLayer &operator=(const GCActivationLayer &) = delete;
    /** Default move assignment operator */
    GCActivationLayer &operator=(GCActivationLayer &&) = default;
    /** Set the input and output tensor.
     *
     * @note If the output tensor is a nullptr, the activation function will be performed in-place
     *
     * @param[in, out] input    Source tensor. In case of @p output tensor = nullptr, this tensor will store the result
     *                          of the activation function. Data types supported: F16/F32.
     * @param[out]     output   Destination tensor. Data type supported: same as @p input
     * @param[in]      act_info Activation layer parameters.
     */
    void configure(IGCTensor *input, IGCTensor *output, ActivationLayerInfo act_info);
};
} // namespace arm_compute
#endif /* ARM_COMPUTE_GCACTIVATIONLAYER_H */
