/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RGBColor
implements Paint {
    public int red;
    public int green;
    public int blue;

    public static RGBColor read(DataInputStream in) throws IOException {
        RGBColor c = new RGBColor();
        c.red = in.readUnsignedShort();
        c.green = in.readUnsignedShort();
        c.blue = in.readUnsignedShort();
        return c;
    }

    public RGBColor() {
        this.red = 0;
        this.green = 0;
        this.blue = 0;
    }

    public RGBColor(int rgb) {
        this.red = (rgb >>> 16 & 0xFF) * 257;
        this.green = (rgb >>> 8 & 0xFF) * 257;
        this.blue = (rgb & 0xFF) * 257;
    }

    public RGBColor(int r, int g, int b) {
        this.red = r * 257;
        this.green = g * 257;
        this.blue = b * 257;
    }

    public RGBColor(float r, float g, float b) {
        this.red = (int)(r * 65535.0f);
        this.green = (int)(g * 65535.0f);
        this.blue = (int)(b * 65535.0f);
    }

    public RGBColor(Color c) {
        this.red = c.getRed() * 257;
        this.green = c.getGreen() * 257;
        this.blue = c.getBlue() * 257;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.red);
        out.writeShort(this.green);
        out.writeShort(this.blue);
    }

    public Color toColor() {
        return new Color((float)this.red / 65535.0f, (float)this.green / 65535.0f, (float)this.blue / 65535.0f);
    }

    public int toRGB() {
        return 0xFF000000 | this.red / 257 << 16 | this.green / 257 << 8 | this.blue / 257;
    }

    public String toString() {
        return String.valueOf(this.red) + "," + this.green + "," + this.blue;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.toColor().createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return 1;
    }
}

