/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */
	/* ------- GPIO Group GPPC_A ------- */
	/* PCH default for ESPI inter GPPC_A0-A9 */
	PAD_CFG_NF_OWNERSHIP(GPPC_A0, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A1, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A2, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A3, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A4, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A5, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A6, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A7, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A8, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A9, DN_20K, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPPC_A10, 1, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPPC_A11, UP_20K, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_A12, DN_20K, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPPC_A13, 1, DEEP),
	PAD_CFG_GPO(GPPC_A14, 1, DEEP),
	PAD_CFG_GPO(GPPC_A15, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_A17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_A18, 1, DEEP),
	PAD_CFG_GPO(GPPC_A19, 1, DEEP),

	/* ------- GPIO Group GPPC_B ------- */
	PAD_CFG_NF_OWNERSHIP(GPPC_B0, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B1, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B2, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B3, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B4, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B5, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B6, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B9, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B10, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B11, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B12, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B13, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B14, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B15, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B16, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B17, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B18, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B19, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B20, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B21, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B22, NONE, DEEP, NF4, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_B23, NONE, DEEP, NF4, ACPI),

	/* ------- GPIO Community 1 ------- */
	/* ------- GPIO Group GPPC_C ------- */
	PAD_CFG_NF_OWNERSHIP(GPPC_C0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C2, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C4, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C6, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C7, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C9, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C10, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_C11, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_C12, 1, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPPC_C13, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPPC_C14, 1, DEEP),
	PAD_CFG_GPO(GPPC_C15, 1, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPPC_C16, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPPC_C17, 1, PLTRST),
	PAD_CFG_GPO(GPPC_C18, 1, PLTRST),
	PAD_CFG_NF_OWNERSHIP(GPPC_C19, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C20, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPPC_C21, NONE, DEEP, NF1, ACPI),

	/* ------- GPIO Group GPP_D ------- */
	PAD_CFG_NF_OWNERSHIP(GPP_D0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D2, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPP_D2, 1, DEEP),
	PAD_NC(GPP_D3, NONE),
	PAD_NC(GPP_D4, NONE),
	PAD_NC(GPP_D5, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_D6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D9, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D11, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D12, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D13, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D14, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D15, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D16, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D17, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D19, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_D20, 1, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPP_D21, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_D22, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D23, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_E0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E1, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E8, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E9, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E10, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E11, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E12, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E13, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E14, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E15, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_E16, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_E18, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_E19, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_GPO(GPP_I12, 1, DEEP),
	PAD_CFG_GPO(GPP_I13, 1, DEEP),
	PAD_CFG_GPO(GPP_I14, 1, DEEP),
	PAD_CFG_GPO(GPP_I15, 1, DEEP),
	PAD_CFG_GPO(GPP_I16, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_I17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I21, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I22, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I23, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_GPO(GPP_J2, 1, DEEP),
	PAD_CFG_NF_OWNERSHIP(GPP_J3, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J4, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_J8, NONE, DEEP, NF1, ACPI),

	/* ------- GPIO Group GPP_L ------- */
	PAD_CFG_NF_OWNERSHIP(GPP_L0, NONE, DEEP, NF1, ACPI),
	PAD_CFG_NF_OWNERSHIP(GPP_L1, NONE, DEEP, NF1, ACPI),
	PAD_CFG_GPO(GPP_L2, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_L3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_L6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_L7, 1, DEEP),
	PAD_CFG_GPO(GPP_L8, 1, DEEP),

	/* ------- GPIO Group GPP_M ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_M0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M1, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M8, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M11, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M12, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_M17, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Group GPP_N ------- */
	/* GPP_N1 - GPIO */
	PAD_NC(GPP_N1, NONE),
	/* GPP_N4 - GPIO */
	PAD_NC(GPP_N4, NONE),

	/* ------- GPIO Group GPP_O ------- */
	/* GPP_O0 - GPIO */
	PAD_NC(GPP_O0, NONE),
	/* GPP_O7 - GPIO */
	PAD_NC(GPP_O7, NONE),

	/* ------- GPIO Group GPPC_H ------- */
	PAD_CFG_GPI_TRIG_OWN(GPPC_H0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H1, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_H15, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H16, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H18, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_H19, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Group GPPC_S ------- */
	PAD_CFG_GPI_TRIG_OWN(GPPC_S0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_S1, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S2, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S3, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPPC_S7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPPC_S8, 1, DEEP),
	PAD_CFG_GPO(GPPC_S9, 1, DEEP),
	PAD_CFG_GPO(GPPC_S10, 1, DEEP),
	PAD_CFG_GPO(GPPC_S11, 1, DEEP),
};

#endif /* CFG_GPIO_H */
