#!/bin/sh
#
# mkatoms.sh ../ewmh_atoms.in ewmh_atoms EWMH
#
# Generates the files "ewmh_atoms.h" and "ewmh_atoms.c".
#
# The input file must consist of clean lines which are the name of an atom.
#
# Comments, or even any extra whitespace, are not allowed.
# Names must contain only characters that are allowed in C preprocessor
# defines.
#

input="$1"
output="$2"
infix="$3"

make_header() {
	echo '/*'
	echo ' * AUTOGENERATED FILE -- DO NOT EDIT'
	echo ' * This file is generated automatically by tools/mk_atom.sh'
	echo ' * from '${input}
	echo ' * during the build process.'
	echo ' */'
	echo ''

	counter=0
	while read line
	do
		#echo "#define XA_${line}_nr ${counter}"
		echo "#define XA_${line}    X${infix}Atom[${counter}]"
		counter=$((counter + 1))
	done

	num_atoms=$counter

	echo ''
	echo "#define NUM_${infix}_XATOMS ${num_atoms}"
	echo ''
	echo "extern Atom X${infix}Atom[${num_atoms}];"
	echo "extern char *X${infix}AtomNames[${num_atoms}];"

}


make_c() {
	echo '/*'
	echo ' * AUTOGENERATED FILE -- DO NOT EDIT'
	echo ' * This file is generated automatically by tools/mk_atom.sh'
	echo ' * from '${input}
	echo ' * during the build process.'
	echo ' */'
	echo ''
	echo "char *X${infix}AtomNames[${num_atoms}] = {"
	while read line
	do
		echo "    \"${line}\","
	done
	echo '};'
}

make_header < ${input} > ${output}.h
make_c      < ${input} > ${output}.c

