include(CMakeParseArguments)

function(find_packages result)
    cmake_parse_arguments(ARGS "" "" "REQUIRED;OPTIONAL" ${ARGN})
    set(_res "")
    set(_res_libs "")
    foreach(pkg ${ARGS_REQUIRED})
        string(REPLACE ">=" ";" pkg_ ${pkg})
        list(GET pkg_ "0" pkg)
        list(LENGTH pkg_ pkg_has_version)
        if(pkg_has_version GREATER 1)
            list(GET pkg_ "1" pkg_version)
        else()
            if(${pkg}_GLOBAL_VERSION)
                set(pkg_version ${${pkg}_GLOBAL_VERSION})
            else()
                unset(pkg_version)
            endif()
        endif()
        find_package(${pkg} ${pkg_version} REQUIRED)
        list(APPEND _res ${${pkg}_PKG_CONFIG_NAME})
        list(APPEND _res_libs ${${pkg}_LIBRARIES})
        set(${pkg}_VERSION "${${pkg}_VERSION}" PARENT_SCOPE)
    endforeach(pkg)
    foreach(pkg ${ARGS_OPTIONAL})
        string(REPLACE ">=" ";" pkg_ ${pkg})
        list(GET pkg_ "0" pkg)
        list(LENGTH pkg_ pkg_has_version)
        if(pkg_has_version GREATER 1)
            list(GET pkg_ "1" pkg_version)
        else()
            if(${pkg}_GLOBAL_VERSION)
                set(pkg_version ${${pkg}_GLOBAL_VERSION})
            else()
                unset(pkg_version)
            endif()
        endif()
        find_package(${pkg} ${pkg_version})
        if(${pkg}_FOUND)
            list(APPEND _res ${${pkg}_PKG_CONFIG_NAME})
            list(APPEND _res_libs ${${pkg}_LIBRARIES})
            set(${pkg}_VERSION "${${pkg}_VERSION}" PARENT_SCOPE)
        endif()
    endforeach(pkg)
    set(${result} "${_res}" PARENT_SCOPE)
    set(${result}_LIBS "${_res_libs}" PARENT_SCOPE)
endfunction()
