#!/bin/bash

. /etc/rc.conf
. /etc/rc.d/functions

PID=$(pidof -o %PPID /usr/sbin/downtimed)
case "$1" in
  start)
    stat_busy "Starting downtimed"
    [ -z "$PID" ] && /usr/sbin/downtimed
    if [ $? -gt 0 ]; then
      stat_fail
    else
      add_daemon downtimed
      stat_done
    fi
    ;;
  stop)
    stat_busy "Stopping downtimed"
    [ ! -z "$PID" ]  && kill $PID &> /dev/null
    if [ $? -gt 0 ]; then
      stat_fail
    else
      rm_daemon downtimed
      stat_done
    fi
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    echo "usage: $0 {start|stop|restart}"
esac
exit 0
