// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file new_features_4_2PubSubTypes.cpp
 * This header file contains the implementation of the serialization functions.
 *
 * This file was generated by the tool fastcdrgen.
 */


#include <fastcdr/FastBuffer.h>
#include <fastcdr/Cdr.h>

#include "new_features_4_2PubSubTypes.h"

using namespace eprosima::fastrtps;
using namespace eprosima::fastrtps::rtps;

NewAliasesPubSubType::NewAliasesPubSubType()
{
    setName("NewAliases");
    m_typeSize = static_cast<uint32_t>(NewAliases::getMaxCdrSerializedSize()) + 4 /*encapsulation*/;
    m_isGetKeyDefined = NewAliases::isKeyDefined();
    size_t keyLength = NewAliases::getKeyMaxCdrSerializedSize()>16 ? NewAliases::getKeyMaxCdrSerializedSize() : 16;
    m_keyBuffer = reinterpret_cast<unsigned char*>(malloc(keyLength));
    memset(m_keyBuffer, 0, keyLength);
}

NewAliasesPubSubType::~NewAliasesPubSubType()
{
    if(m_keyBuffer!=nullptr)
        free(m_keyBuffer);
}

bool NewAliasesPubSubType::serialize(void *data, SerializedPayload_t *payload)
{
    NewAliases *p_type = static_cast<NewAliases*>(data);
    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->max_size); // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
            eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload->encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
    // Serialize encapsulation
    ser.serialize_encapsulation();

    try
    {
        p_type->serialize(ser); // Serialize the object:
    }
    catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
    {
        return false;
    }

    payload->length = static_cast<uint32_t>(ser.getSerializedDataLength()); //Get the serialized length
    return true;
}

bool NewAliasesPubSubType::deserialize(SerializedPayload_t* payload, void* data)
{
    NewAliases* p_type = static_cast<NewAliases*>(data); //Convert DATA to pointer of your type
    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->length); // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
            eprosima::fastcdr::Cdr::DDS_CDR); // Object that deserializes the data.
    // Deserialize encapsulation.
    deser.read_encapsulation();
    payload->encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

    try
    {
        p_type->deserialize(deser); //Deserialize the object:
    }
    catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
    {
        return false;
    }

    return true;
}

std::function<uint32_t()> NewAliasesPubSubType::getSerializedSizeProvider(void* data)
{
    return [data]() -> uint32_t
    {
        return static_cast<uint32_t>(type::getCdrSerializedSize(*static_cast<NewAliases*>(data))) + 4 /*encapsulation*/;
    };
}

void* NewAliasesPubSubType::createData()
{
    return reinterpret_cast<void*>(new NewAliases());
}

void NewAliasesPubSubType::deleteData(void* data)
{
    delete(reinterpret_cast<NewAliases*>(data));
}

bool NewAliasesPubSubType::getKey(void *data, InstanceHandle_t* handle, bool force_md5)
{
    if(!m_isGetKeyDefined)
        return false;
    NewAliases* p_type = static_cast<NewAliases*>(data);
    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(m_keyBuffer),NewAliases::getKeyMaxCdrSerializedSize());     // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS);     // Object that serializes the data.
    p_type->serializeKey(ser);
    if(force_md5 || NewAliases::getKeyMaxCdrSerializedSize()>16)    {
        m_md5.init();
        m_md5.update(m_keyBuffer, static_cast<unsigned int>(ser.getSerializedDataLength()));
        m_md5.finalize();
        for(uint8_t i = 0;i<16;++i)        {
            handle->value[i] = m_md5.digest[i];
        }
    }
    else    {
        for(uint8_t i = 0;i<16;++i)        {
            handle->value[i] = m_keyBuffer[i];
        }
    }
    return true;
}




namespace bitmodule
{



    BitsetBitmaskPubSubType::BitsetBitmaskPubSubType()
    {
        setName("bitmodule::BitsetBitmask");
        m_typeSize = static_cast<uint32_t>(BitsetBitmask::getMaxCdrSerializedSize()) + 4 /*encapsulation*/;
        m_isGetKeyDefined = BitsetBitmask::isKeyDefined();
        size_t keyLength = BitsetBitmask::getKeyMaxCdrSerializedSize()>16 ? BitsetBitmask::getKeyMaxCdrSerializedSize() : 16;
        m_keyBuffer = reinterpret_cast<unsigned char*>(malloc(keyLength));
        memset(m_keyBuffer, 0, keyLength);
    }

    BitsetBitmaskPubSubType::~BitsetBitmaskPubSubType()
    {
        if(m_keyBuffer!=nullptr)
            free(m_keyBuffer);
    }

    bool BitsetBitmaskPubSubType::serialize(void *data, SerializedPayload_t *payload)
    {
        BitsetBitmask *p_type = static_cast<BitsetBitmask*>(data);
        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->max_size); // Object that manages the raw buffer.
        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
        payload->encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
        // Serialize encapsulation
        ser.serialize_encapsulation();

        try
        {
            p_type->serialize(ser); // Serialize the object:
        }
        catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
        {
            return false;
        }

        payload->length = static_cast<uint32_t>(ser.getSerializedDataLength()); //Get the serialized length
        return true;
    }

    bool BitsetBitmaskPubSubType::deserialize(SerializedPayload_t* payload, void* data)
    {
        BitsetBitmask* p_type = static_cast<BitsetBitmask*>(data); //Convert DATA to pointer of your type
        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->length); // Object that manages the raw buffer.
        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                eprosima::fastcdr::Cdr::DDS_CDR); // Object that deserializes the data.
        // Deserialize encapsulation.
        deser.read_encapsulation();
        payload->encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

        try
        {
            p_type->deserialize(deser); //Deserialize the object:
        }
        catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
        {
            return false;
        }

        return true;
    }

    std::function<uint32_t()> BitsetBitmaskPubSubType::getSerializedSizeProvider(void* data)
    {
        return [data]() -> uint32_t
        {
            return static_cast<uint32_t>(type::getCdrSerializedSize(*static_cast<BitsetBitmask*>(data))) + 4 /*encapsulation*/;
        };
    }

    void* BitsetBitmaskPubSubType::createData()
    {
        return reinterpret_cast<void*>(new BitsetBitmask());
    }

    void BitsetBitmaskPubSubType::deleteData(void* data)
    {
        delete(reinterpret_cast<BitsetBitmask*>(data));
    }

    bool BitsetBitmaskPubSubType::getKey(void *data, InstanceHandle_t* handle, bool force_md5)
    {
        if(!m_isGetKeyDefined)
            return false;
        BitsetBitmask* p_type = static_cast<BitsetBitmask*>(data);
        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(m_keyBuffer),BitsetBitmask::getKeyMaxCdrSerializedSize());     // Object that manages the raw buffer.
        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS);     // Object that serializes the data.
        p_type->serializeKey(ser);
        if(force_md5 || BitsetBitmask::getKeyMaxCdrSerializedSize()>16)    {
            m_md5.init();
            m_md5.update(m_keyBuffer, static_cast<unsigned int>(ser.getSerializedDataLength()));
            m_md5.finalize();
            for(uint8_t i = 0;i<16;++i)        {
                handle->value[i] = m_md5.digest[i];
            }
        }
        else    {
            for(uint8_t i = 0;i<16;++i)        {
                handle->value[i] = m_keyBuffer[i];
            }
        }
        return true;
    }

    BM2PubSubType::BM2PubSubType()
    {
        setName("bitmodule::BM2");
        m_typeSize = static_cast<uint32_t>(BM2::getMaxCdrSerializedSize()) + 4 /*encapsulation*/;
        m_isGetKeyDefined = BM2::isKeyDefined();
        size_t keyLength = BM2::getKeyMaxCdrSerializedSize()>16 ? BM2::getKeyMaxCdrSerializedSize() : 16;
        m_keyBuffer = reinterpret_cast<unsigned char*>(malloc(keyLength));
        memset(m_keyBuffer, 0, keyLength);
    }

    BM2PubSubType::~BM2PubSubType()
    {
        if(m_keyBuffer!=nullptr)
            free(m_keyBuffer);
    }

    bool BM2PubSubType::serialize(void *data, SerializedPayload_t *payload)
    {
        BM2 *p_type = static_cast<BM2*>(data);
        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->max_size); // Object that manages the raw buffer.
        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
        payload->encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
        // Serialize encapsulation
        ser.serialize_encapsulation();

        try
        {
            p_type->serialize(ser); // Serialize the object:
        }
        catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
        {
            return false;
        }

        payload->length = static_cast<uint32_t>(ser.getSerializedDataLength()); //Get the serialized length
        return true;
    }

    bool BM2PubSubType::deserialize(SerializedPayload_t* payload, void* data)
    {
        BM2* p_type = static_cast<BM2*>(data); //Convert DATA to pointer of your type
        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->length); // Object that manages the raw buffer.
        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                eprosima::fastcdr::Cdr::DDS_CDR); // Object that deserializes the data.
        // Deserialize encapsulation.
        deser.read_encapsulation();
        payload->encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

        try
        {
            p_type->deserialize(deser); //Deserialize the object:
        }
        catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
        {
            return false;
        }

        return true;
    }

    std::function<uint32_t()> BM2PubSubType::getSerializedSizeProvider(void* data)
    {
        return [data]() -> uint32_t
        {
            return static_cast<uint32_t>(type::getCdrSerializedSize(*static_cast<BM2*>(data))) + 4 /*encapsulation*/;
        };
    }

    void* BM2PubSubType::createData()
    {
        return reinterpret_cast<void*>(new BM2());
    }

    void BM2PubSubType::deleteData(void* data)
    {
        delete(reinterpret_cast<BM2*>(data));
    }

    bool BM2PubSubType::getKey(void *data, InstanceHandle_t* handle, bool force_md5)
    {
        if(!m_isGetKeyDefined)
            return false;
        BM2* p_type = static_cast<BM2*>(data);
        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(m_keyBuffer),BM2::getKeyMaxCdrSerializedSize());     // Object that manages the raw buffer.
        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS);     // Object that serializes the data.
        p_type->serializeKey(ser);
        if(force_md5 || BM2::getKeyMaxCdrSerializedSize()>16)    {
            m_md5.init();
            m_md5.update(m_keyBuffer, static_cast<unsigned int>(ser.getSerializedDataLength()));
            m_md5.finalize();
            for(uint8_t i = 0;i<16;++i)        {
                handle->value[i] = m_md5.digest[i];
            }
        }
        else    {
            for(uint8_t i = 0;i<16;++i)        {
                handle->value[i] = m_keyBuffer[i];
            }
        }
        return true;
    }


} //End of namespace bitmodule
StructTestPubSubType::StructTestPubSubType()
{
    setName("StructTest");
    m_typeSize = static_cast<uint32_t>(StructTest::getMaxCdrSerializedSize()) + 4 /*encapsulation*/;
    m_isGetKeyDefined = StructTest::isKeyDefined();
    size_t keyLength = StructTest::getKeyMaxCdrSerializedSize()>16 ? StructTest::getKeyMaxCdrSerializedSize() : 16;
    m_keyBuffer = reinterpret_cast<unsigned char*>(malloc(keyLength));
    memset(m_keyBuffer, 0, keyLength);
}

StructTestPubSubType::~StructTestPubSubType()
{
    if(m_keyBuffer!=nullptr)
        free(m_keyBuffer);
}

bool StructTestPubSubType::serialize(void *data, SerializedPayload_t *payload)
{
    StructTest *p_type = static_cast<StructTest*>(data);
    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->max_size); // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
            eprosima::fastcdr::Cdr::DDS_CDR); // Object that serializes the data.
    payload->encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
    // Serialize encapsulation
    ser.serialize_encapsulation();

    try
    {
        p_type->serialize(ser); // Serialize the object:
    }
    catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
    {
        return false;
    }

    payload->length = static_cast<uint32_t>(ser.getSerializedDataLength()); //Get the serialized length
    return true;
}

bool StructTestPubSubType::deserialize(SerializedPayload_t* payload, void* data)
{
    StructTest* p_type = static_cast<StructTest*>(data); //Convert DATA to pointer of your type
    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload->data), payload->length); // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
            eprosima::fastcdr::Cdr::DDS_CDR); // Object that deserializes the data.
    // Deserialize encapsulation.
    deser.read_encapsulation();
    payload->encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

    try
    {
        p_type->deserialize(deser); //Deserialize the object:
    }
    catch(eprosima::fastcdr::exception::NotEnoughMemoryException& /*exception*/)
    {
        return false;
    }

    return true;
}

std::function<uint32_t()> StructTestPubSubType::getSerializedSizeProvider(void* data)
{
    return [data]() -> uint32_t
    {
        return static_cast<uint32_t>(type::getCdrSerializedSize(*static_cast<StructTest*>(data))) + 4 /*encapsulation*/;
    };
}

void* StructTestPubSubType::createData()
{
    return reinterpret_cast<void*>(new StructTest());
}

void StructTestPubSubType::deleteData(void* data)
{
    delete(reinterpret_cast<StructTest*>(data));
}

bool StructTestPubSubType::getKey(void *data, InstanceHandle_t* handle, bool force_md5)
{
    if(!m_isGetKeyDefined)
        return false;
    StructTest* p_type = static_cast<StructTest*>(data);
    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(m_keyBuffer),StructTest::getKeyMaxCdrSerializedSize());     // Object that manages the raw buffer.
    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS);     // Object that serializes the data.
    p_type->serializeKey(ser);
    if(force_md5 || StructTest::getKeyMaxCdrSerializedSize()>16)    {
        m_md5.init();
        m_md5.update(m_keyBuffer, static_cast<unsigned int>(ser.getSerializedDataLength()));
        m_md5.finalize();
        for(uint8_t i = 0;i<16;++i)        {
            handle->value[i] = m_md5.digest[i];
        }
    }
    else    {
        for(uint8_t i = 0;i<16;++i)        {
            handle->value[i] = m_keyBuffer[i];
        }
    }
    return true;
}

