// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file member_idCdrAux.hpp
 * This source file contains some definitions of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__MEMBER_IDCDRAUX_HPP
#define FAST_DDS_GENERATED__MEMBER_IDCDRAUX_HPP

#include "member_id.hpp"

constexpr uint32_t AutoidHash_max_cdr_typesize {80UL};
constexpr uint32_t AutoidHash_max_key_cdr_typesize {0UL};

constexpr uint32_t DerivedAutoidDefault_max_cdr_typesize {160UL};
constexpr uint32_t DerivedAutoidDefault_max_key_cdr_typesize {0UL};

constexpr uint32_t AutoidSequential_max_cdr_typesize {72UL};
constexpr uint32_t AutoidSequential_max_key_cdr_typesize {0UL};

constexpr uint32_t DerivedEmptyAutoidSequential_max_cdr_typesize {72UL};
constexpr uint32_t DerivedEmptyAutoidSequential_max_key_cdr_typesize {0UL};

constexpr uint32_t FixHashidDefault_max_cdr_typesize {72UL};
constexpr uint32_t FixHashidDefault_max_key_cdr_typesize {0UL};

constexpr uint32_t FixMix_max_cdr_typesize {72UL};
constexpr uint32_t FixMix_max_key_cdr_typesize {0UL};

constexpr uint32_t AutoidDefault_max_cdr_typesize {80UL};
constexpr uint32_t AutoidDefault_max_key_cdr_typesize {0UL};

constexpr uint32_t DerivedAutoidHash_max_cdr_typesize {160UL};
constexpr uint32_t DerivedAutoidHash_max_key_cdr_typesize {0UL};

constexpr uint32_t FixHashid_max_cdr_typesize {72UL};
constexpr uint32_t FixHashid_max_key_cdr_typesize {0UL};

constexpr uint32_t FixId_max_cdr_typesize {48UL};
constexpr uint32_t FixId_max_key_cdr_typesize {0UL};

constexpr uint32_t DerivedAutoidSequential_max_cdr_typesize {152UL};
constexpr uint32_t DerivedAutoidSequential_max_key_cdr_typesize {0UL};

constexpr uint32_t FixHexId_max_cdr_typesize {48UL};
constexpr uint32_t FixHexId_max_key_cdr_typesize {0UL};


namespace eprosima {
namespace fastcdr {

class Cdr;
class CdrSizeCalculator;

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixId& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixHexId& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixHashidDefault& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixHashid& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixMix& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidDefault& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidSequential& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidHash& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidDefault& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedEmptyAutoidSequential& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidSequential& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidHash& data);


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__MEMBER_IDCDRAUX_HPP

