#!/bin/sh
#
#       fhist - file history and comparison tools
#       Copyright (C) 1993-1995, 1998, 2003, 2004, 2008 Peter Miller
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 3 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see
#       <http://www.gnu.org/licenses/>.
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
        set +x
        echo 'FAILED test of the "fmerge -c" functionality' 1>&2
        cd $here
        rm -rf $work
        exit 1
}
pass()
{
        set +x
        echo PASSED 1>&2
        cd $here
        rm -rf $work
        exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# build the input files
#
cat > a << 'fubar'
1
2
3
4
5
6
7
8
9
fubar
if test $? -ne 0 ; then fail; fi
cat > b << 'fubar'
1
2
3
5
6
7
8
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > c << 'fubar'
1
2
3
5
five and a half
6
7
8
9
fubar
if test $? -ne 0 ; then fail; fi

#
# make sure it does the right thing
#
$bin/fmerge a b c -o d -c e > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

cat > d.ok << 'fubar'
1
2
3
/-/-/-/-/-/-/-/-/-/ BEGIN CONFLICT  [O4 A4 B4] /-/-/-/-/-/-/-/-/-/-/
/-/-/-/-/-/-/-/-/-/-/-/-/  END CONFLICT   /-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/
5
five and a half
6
7
8
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cmp d d.ok
if test $? -ne 0 ; then fail; fi

cat > e.ok << 'fubar'
T 1 conflict
   1
   2
   3
X  /-/-/-/-/-/-/-/-/-/ BEGIN CONFLICT  [O4 A4 B4] /-/-/-/-/-/-/-/-/-/-/
DA 4
X  /-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/
DB 4
X  /-/-/-/-/-/-/-/-/-/-/-/-/  END CONFLICT   /-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/
   5
IB five and a half
   6
   7
   8
IA nine
IA ten
DA 9
fubar
if test $? -ne 0 ; then fail; fi
cmp e e.ok
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
