# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = Ha ocurriu una error durant una connexión a { $hostname }. { $errorMessage }

# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Codigo d'error: { $error }

psmerr-ssl-disabled = No se puede connectar de traza segura porque s'ha deshabilitau o protocolo SSL.
psmerr-ssl2-disabled = No se puede connectar de traza segura porque o puesto emplega una versión antiga y insegura d'o protocolo SSL.

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Ha recibiu un certificau no valido.  Contacte con l'administrador d'o servidor u con o remitent d'o certificau no valido y de-les a siguient información:
    
    O suyo certificau Contiene o mesmo numero de serie que unatro certificau emeso por l'autoridat de certificación.  Por favor, aconsiga un nuevo certificau que contienga un numero de serie unico.

ssl-error-export-only-server = No se puede comunicar de traza segura. L'atro cabo d'a connexión no admite zifrau d'alto grau.
ssl-error-us-only-server = No se puede establir una comunicación de trazasegura.  L'atro cabo d'a connexión requiere zifrau d'alto grau que no ye implementau.
ssl-error-no-cypher-overlap = No se puede establir una comunicación de forma segura con l'atro cabo d'a connexión: no i hai garra algorismo de zifrau común.
ssl-error-no-certificate = No s'ha trobau o certificau u a clau necesarios ta l'autenticación.
ssl-error-bad-certificate = No se puede comunicar de forma segura con l'atro cabo d'a connexión: s'ha refusau o suyo certificau.
ssl-error-bad-client = O servidor s'ha trobau datos erronios d'o client.
ssl-error-bad-server = O client s'ha trobau datos erronios d'o servidor.
ssl-error-unsupported-certificate-type = No s'accepta ista mena de certificau.
ssl-error-unsupported-version = L'atro cabo d'a connexión fa servir una versión no implementada d'o protocolo de seguranza.
ssl-error-wrong-certificate = L'autenticación d'o client ha fallau: a clau privada en la base de datos de claus no coincide con a clau publica de la base de datos de certificaus.
ssl-error-bad-cert-domain = No s'ha puesto comunicar de traza segura con l'atro cabo d'a connexión: o nombre de dominio solicitau no coincide con o certificau d'o servidor.
ssl-error-post-warning = Codigo d'error SSL desconoixiu.
ssl-error-ssl2-disabled = L'atro cabo d'a connexión nomás puede fer servir a versión 2 de SSL, que ye desactivada localment.
ssl-error-bad-mac-read = SSL ha recibiu un rechistro con un codigo d'autenticación de mensaches incorrecto.
ssl-error-bad-mac-alert = L'atro cabo d'a connexión SSL informa d'un codigo d'autenticación de mensaches incorrecto.
ssl-error-bad-cert-alert = L'atro cabo d'a connexión SSL no puede verificar o suyo certificau.
ssl-error-revoked-cert-alert = L'atro cabo d'a connexión SSL ha refusau o suyo certificau por considerar-lo revocau.
ssl-error-expired-cert-alert = L'atro cabo d'a connexión SSL ha refusau o suyo certificau por considerar-lo venciu.
ssl-error-ssl-disabled = No s'ha puesto connectar: SSL ye desactivau.
ssl-error-fortezza-pqg = No s'ha puesto connectar: l'atro cabo d'a connexión SSL se troba en unatro dominio FORTEZZA.
ssl-error-unknown-cipher-suite = S'ha solicitau un entorno de zifrau SSL desconoixiu.
ssl-error-no-ciphers-supported = No i hai garra entorno de zifrau present y habilitau en iste programa.
ssl-error-bad-block-padding = SSL ha recibiu un rechistro con un repleno de bloque malmeso.
ssl-error-rx-record-too-long = SSL ha recibiu un rechistro que excedía a longaria maxima permitida.
ssl-error-tx-record-too-long = SSL ha intentau ninviar un rechistro que excedía a longaria maxima permitida.
ssl-error-rx-malformed-hello-request = SSL ha recibiu un mensache d'establimiento d'a connexión «Hello Request» mal formau.
ssl-error-rx-malformed-client-hello = SSL ha recibiu un mensache d'establimiento d'a connexión «Client Hello» mal formau.
ssl-error-rx-malformed-server-hello = SSL ha recibiu un mensache d'establimiento d'a connexión «Server Hello» mal formau.
ssl-error-rx-malformed-certificate = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate» mal formau.
ssl-error-rx-malformed-server-key-exch = SSL ha recibiu un mensache d'establimiento d'a connexión «Server Key Exchange» mal formau.
ssl-error-rx-malformed-cert-request = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate Request» mal formau.
ssl-error-rx-malformed-hello-done = SSL ha recibiu un mensache d'establimiento d'a connexión «Server Hello Done» mal formau.
ssl-error-rx-malformed-cert-verify = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate Verify» mal formau.
ssl-error-rx-malformed-client-key-exch = SSL ha recibiu un mensache de d'establimiento d'a connexión «Client Key Exchange» mal formau.
ssl-error-rx-malformed-finished = SSL ha recibiu un mensache d'establimiento d'a connexión «Finished» mal formau.
ssl-error-rx-malformed-change-cipher = SSL ha recibiu un rechistro «Change Cipher Spec» mal formau.
ssl-error-rx-malformed-alert = SSL ha recibiu un rechistro «Alert» mal formau.
ssl-error-rx-malformed-handshake = SSL ha recibiu un rechistro «Handshake» mal formau.
ssl-error-rx-malformed-application-data = SSL ha recibiu un rechistro «Application Data» mal formau.
ssl-error-rx-unexpected-hello-request = SSL ha recibiu un mensache d'establimiento d'a connexión «Hello Request» inasperau.
ssl-error-rx-unexpected-client-hello = SSL ha recibiu un mensache d'establimiento d'a connexión «Client Hello» inasperau.
ssl-error-rx-unexpected-server-hello = SSL ha recibiu un mensache d'establimiento d'a connexión «Server Hello» inasperau.
ssl-error-rx-unexpected-certificate = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate» inasperau.
ssl-error-rx-unexpected-server-key-exch = SSL ha recibiu un mensache d'establimiento d'a connexión «Server Key Exchange» inasperau.
ssl-error-rx-unexpected-cert-request = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate Request» inasperau.
ssl-error-rx-unexpected-hello-done = SSL ha recibiu un mensache d'establimiento d'a connexión «Server Hello Done» inasperau.
ssl-error-rx-unexpected-cert-verify = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate Verify» inasperau.
ssl-error-rx-unexpected-client-key-exch = SSL ha recibiu un mensache d'establimiento d'a connexión «Client Key Exchange» inasperau.
ssl-error-rx-unexpected-finished = SSL ha recibiu un mensache d'establimiento d'a connexión «Finished» inasperau.
ssl-error-rx-unexpected-change-cipher = SSL ha recibiu un rechistro «Change Cipher Spec» inasperau.
ssl-error-rx-unexpected-alert = SSL ha recibiu un rechistro «Alert» inasperau.
ssl-error-rx-unexpected-handshake = SSL ha recibiu un rechistro «Handshake» inasperau.
ssl-error-rx-unexpected-application-data = SSL ha recibiu un rechistro «Application Data» inasperau.
ssl-error-rx-unknown-record-type = SSL ha recibiu un rechistro con una mena de conteniu desconoixiu.
ssl-error-rx-unknown-handshake = SSL ha recibiu un mensache d'establimiento de connexión con una mena de mensache desconoixiu.
ssl-error-rx-unknown-alert = SSL ha recibiu un rechistro d'alerta con una descripción d'alerta desconoixida.
ssl-error-close-notify-alert = L'atro cabo d'a connexión SSL ha zarrau ista connexión.
ssl-error-handshake-unexpected-alert = L'atro cabo d'a connexión SSL ha recibiu un mensache d'establimiento de connexión que no asperaba.
ssl-error-decompression-failure-alert = L'atro cabo d'a connexión SSL no ha puesto descomprimir con exito o rechistro SSL que ha recibiu.
ssl-error-handshake-failure-alert = L'atro cabo d'a connexión SSL no ha puesto negociar un conchunto de parametros de seguranza acceptable.
ssl-error-illegal-parameter-alert = L'atro cabo d'a connexión SSL ha refusau un mensache d'establimiento de connexión por tener un conteniu no acceptable.
ssl-error-unsupported-cert-alert = L'atro cabo d'a connexión SSL no accepta certificaus d'a mena que ha recibiu.
ssl-error-certificate-unknown-alert = L'atro cabo d'a connexión SSL ha experimentau bell problema no especificau con o certificau que ha recibiu.
ssl-error-generate-random-failure = SSL ha experimentau una falla d'o suyo chenerador de numeros aleatorios.
ssl-error-sign-hashes-failure = No s'ha pogut sinyar dichitalment os datos requerius ta verificar o suyo certificau.
ssl-error-extract-public-key-failure = SSL no ha puesto extrayer a clau publica d'o certificau de l'atro cabo d'a connexión.
ssl-error-server-key-exchange-failure = S'ha produciu una falla desconoixida en procesar o establimiento de connexión «SSL Server Key Exchange handshake».
ssl-error-client-key-exchange-failure = S'ha produciu una falla desconoixida en procesar o establimiento de connexión «SSL Client Key Exchange».
ssl-error-encryption-failure = L'algorismo de zifrau de datos masivos ha fallau en a suite de zifrau seleccionada.
ssl-error-decryption-failure = L'algorismo de deszifrado de datos masivos ha fallau en a suite de zifrau seleccionada.
ssl-error-socket-write-failure = Ha fallau un intento d'escribir datos zifraus en o socket subchacent.
ssl-error-md5-digest-failure = A función de resumen MD5 ha falliu.
ssl-error-sha-digest-failure = A función de resumen SHA-1 ha fallau.
ssl-error-mac-computation-failure = O calculo d'a MAC ha fallau.
ssl-error-sym-key-context-failure = S'ha produciu una falla en creyar un contexto de clau simetrica.
ssl-error-sym-key-unwrap-failure = No s'ha puesto desembolicar a clau simetrica en o mensache «Client Key Exchange».
ssl-error-pub-key-size-limit-exceeded = O servidor SSL ha mirau de fer servir una clau publica de ran domestico con una suite de zifrau d'exportación.
ssl-error-iv-param-failure = O codigo PKCS11 no ha puesto traducir un IV en un parametro.
ssl-error-init-cipher-suite-failure = No s'ha puesto inicializar a suite de zifrau seleccionada.
ssl-error-session-key-gen-failure = O client no ha puesto chenerar as claus de sesión t'a sesión SSL.
ssl-error-no-server-key-for-alg = O servidor no tenía garra clau ta l'algorismo d'intercambio de claus que s'ha intentau.
ssl-error-token-insertion-removal = O teste PKCS#11 s'ha ficau u eliminau mientres a operación yera en progreso.
ssl-error-token-slot-not-found = No s'ha puesto trobar garra teste PKCS#11 ta completar a operación requerida.
ssl-error-no-compression-overlap = No se puede comunicar de traza segura con l'atro cabo d'a connexion: no i hai garra algorismo de compresión común.
ssl-error-handshake-not-completed = No se puede encetar unatro establimiento de sesión SSL dica que l'actual no se remate.
ssl-error-bad-handshake-hash-value = S'ha recibiu valors de hash d l'establimiento de connexión incorrectos dende l'atro cabo d'a connexión.
ssl-error-cert-kea-mismatch = O certificau proporcionau no puede emplegar-se con l'algorismo d'intercambio de claus seleccionau.
ssl-error-no-trusted-ssl-client-ca = No se confía en garra entidat certificadera ta l'autenticación d'o client SSL.
ssl-error-session-not-found = No s'ha trobau a ID d'a sesión SSL d'o client en a memoria caché d'as sesions d'o servidor.
ssl-error-decryption-failed-alert = L'atro cabo no ha puesto deszifrar un rechistro SSL que ha recibiu.
ssl-error-record-overflow-alert = L'atro cabo ha recibiu un rechistro SSL mas largo que no a longaria permitida.
ssl-error-unknown-ca-alert = L'atro cabo no reconoixe ni confía en a CA que ha emitiu o suyo certificau.
ssl-error-access-denied-alert = L'atro cabo ha recibiu un certificau valido, pero s'ha denegau l'acceso.
ssl-error-decode-error-alert = L'atro cabo d'a connexión no ha puesto decodificar o mensache d'establimiento de connexión SSL.
ssl-error-decrypt-error-alert = L'atro cabo informa d'una falla en a verificación d'as sinyaturas u eb l'intercambio de claus.
ssl-error-export-restriction-alert = L'atro cabo informa que a negociación no cumple con as regulacions d'exportación.
ssl-error-protocol-version-alert = L'atro cabo informa d'una versión d'o protocolo incompatible u no implementada.
ssl-error-insufficient-security-alert = O servidor requiere zifraus mas segurs que os permitidos por o client.
ssl-error-internal-error-alert = L'atro cabo informa que ha experimentau una error interna.
ssl-error-user-canceled-alert = L'usuario de l'atro cabo d'a connexión ha cancelau o establimiento de connexión.
ssl-error-no-renegotiation-alert = L'atro cabo no permite a renegociación d'os parametros de seguranza SSL.
ssl-error-server-cache-not-configured = A memoria caché d'o servidor SSL no ye configurada ni desactivada en iste socket.
ssl-error-unsupported-extension-alert = L'atro cabo d'a connexión SSL no accepta la extensión «TLS Hello» solicitada.
ssl-error-certificate-unobtainable-alert = L'atro cabo d'a connexión SSL no ha puesto obtener o suyo certificau de l'URL suministrau.
ssl-error-unrecognized-name-alert = L'atro cabo d'a connexión SSL no tiene garra certificau t'o nombre DNS solicitau.
ssl-error-bad-cert-status-response-alert = L'atro cabo d'a connexión SSL no ha puesto obtener una respuesta OCSP t'o suyo certificau.
ssl-error-bad-cert-hash-value-alert = L'atro cabo d'a connexión SSL ha informau d'una valor hash de certificau malmesa.
ssl-error-rx-unexpected-new-session-ticket = O SSL ha recibiu un mensache d'establimiento de connexión de "tiquet de nueva sesión" no asperau.
ssl-error-rx-malformed-new-session-ticket = O SSL ha recibiu un mensache d'establimiento de connexión "tiquet de nueva sesión" mal formau.
ssl-error-decompression-failure = O SSL ha recibiu un rechistro comprimiu que no s'ha puesto descomprimir.
ssl-error-renegotiation-not-allowed = No se permite a renegociación en iste socket SSL.
ssl-error-unsafe-negotiation = L'atro cabo ha mirau de establir una connexión a o estilo antigo (y, por tanto, potencialment vulnerable).
ssl-error-rx-unexpected-uncompressed-record = O SSL ha recibiu un rechistro no comprimiu inasperau.
ssl-error-weak-server-ephemeral-dh-key = O SSL ha recibiu una clave efímera Diffie-Hellman feble en o mensache d'establimiento de connexión «Server Key Exchange».
ssl-error-next-protocol-data-invalid = O SSL ha recibiu una extensión NPN no valida.
ssl-error-feature-not-supported-for-ssl2 = Caracteristica SSL no soportada ta connexions SSL 2.0.
ssl-error-feature-not-supported-for-servers = Caracteristica SSL no soportada ta servidors.
ssl-error-feature-not-supported-for-clients = Caracteristica SSL no soportada ta clients.
ssl-error-invalid-version-range = O rango de versions de SSL no ye valido.
ssl-error-cipher-disallowed-for-version = O par SSL trigó una suite de zifrau no permitida en a versión d'o protocolo trigau.
ssl-error-rx-malformed-hello-verify-request = SSL ha recibiu un mensache d'establimiento d'a connexión «Hello Request» mal formau.
ssl-error-rx-unexpected-hello-verify-request = SSL ha recibiu un mensache d'establimiento d'a connexión «Hello Request» inasperau.
ssl-error-feature-not-supported-for-version = Caracteristica SSL no permitida en ixa versión d'o protocolo.
ssl-error-rx-unexpected-cert-status = SSL ha recibiu un mensache d'establimiento d'a connexión «Certificate Request» inasperau.
ssl-error-unsupported-hash-algorithm = O par TLS ha feito servir un algoritmo de hash no permitiu.
ssl-error-digest-failure = A función de resumen MD5 ha fallau.
ssl-error-incorrect-signature-algorithm = S'ha especificau un algoritmo de sinyatura incorrecto en un elemento sinyau dichitalment.
ssl-error-next-protocol-no-callback = A siguien extensión de negociación d'o protocolo ye activada, pero o callback ya s'heba borrau quan s'amenistaba.
ssl-error-next-protocol-no-protocol = O servidor no permite denguno d'os protocolos que o client anuncia en a extensión ALPN.
ssl-error-inappropriate-fallback-alert = O servidor ha refusau o establimiento de connexión porque o client ha baixau ta una versión TLS mas baixa d'a que o servidor permite.
ssl-error-weak-server-cert-key = O certificau d'o servidor incluye una clau publica que yera masiau feble.
ssl-error-rx-short-dtls-read = No i hai masiau espacio en buffer pa lo rechistro DTLS.
ssl-error-no-supported-signature-algorithm = No s'ha configurau garra algoritmo TLS suportau.
ssl-error-unsupported-signature-algorithm = Lo par ha usau una combinación no soportada de signatura y algoritmo hash.
ssl-error-missing-extended-master-secret = Lo par ha mirau de continar sin una extensión extended_master_secret extension correcta.
ssl-error-unexpected-extended-master-secret = Lo par ha mirau de continar con una extensión inasperada extended_master_secret.
sec-error-io = S'ha produciu una error de I/O entre l'autorización de seguranza.
sec-error-library-failure = ha fallau a biblioteca de seguranza.
sec-error-bad-data = biblioteca de seguranza: s'han recibiu datos incorrectos.
sec-error-output-len = biblioteca de seguranza: s'ha produciu una error en a longaria d'a salida.
sec-error-input-len = a biblioteca de seguranza ha experimentau una error en a longaria d'a dentrada.
sec-error-invalid-args = biblioteca de seguranza: os argumentos no son validos.
sec-error-invalid-algorithm = biblioteca de seguranza: l'algorismo no ye valido.
sec-error-invalid-ava = biblioteca de seguranza: AVA no ye valido.
sec-error-invalid-time = A cadena horaria no tiene un formato adequau.
sec-error-bad-der = biblioteca de seguranza: o mensache codificau con DER no tiene un formato adequau.
sec-error-bad-signature = O certificau de l'atr cabo no tiene una sinyatura valida.
sec-error-expired-certificate = O certificau de l'atro cabo ha venciu.
sec-error-revoked-certificate = O certificau de l'atro cabo ye estau revocau.
sec-error-unknown-issuer = No se reconoixe l'emisor d'o certificau de l'atro cabo.
sec-error-bad-key = A clau publica de l'atro cabo no ye valida.
sec-error-bad-password = A clau de seguranza introducida no ye correcta.
sec-error-retry-password = A nueva clau no s'ha introduciu correctament. Torne a prebar-lo.
sec-error-no-nodelock = biblioteca de seguranza: no i hai garra bloqueo de nodo.
sec-error-bad-database = biblioteca de seguranza: a base de datos ye incorrecta.
sec-error-no-memory = biblioteca de seguranza: s'ha produciu una error en l'asignación de memoria.
sec-error-untrusted-issuer = L'emisor d'o certificau d'iguales ye estau marcau por l'usuario como no confiable.
sec-error-untrusted-cert = O certificau de l'atro cabo ye estau marcau por l'usuario como no confiable.
sec-error-duplicate-cert = O certificau ya existe en a suya base de datos.
sec-error-duplicate-cert-name = O nombre d'o certificau descargau ye igual a unatro que ya se troba en a suya base de datos.
sec-error-adding-cert = S'ha produciu una error en adhibir o certificau a la base de datos.
sec-error-filing-key = S'ha produciu una error en replenar a clau d'o certificau.
sec-error-no-key = A clau privada d'o certificau no se puede trobar en a base de datos de claus
sec-error-cert-valid = Iste certificau ye valido.
sec-error-cert-not-valid = Iste certificau no ye valido.
sec-error-cert-no-response = Biblioteca de certificaus: no i hai respuesta
sec-error-expired-issuer-certificate = O certificau de l'emisor d'o certificau ha venciu.  Comprebe a calendata y a hora d'o suyo sistema.
sec-error-crl-expired = A CRL de l'emisor d'o certificau ha venciu. Esvielle-la u comprebe a calendata y a hora d'o suyo sistema.
sec-error-crl-bad-signature = A CRL de l'emisor d'o certificau no tiene una sinyatura valida.
sec-error-crl-invalid = A nueva CRL no tiene un formato valido.
sec-error-extension-value-invalid = A valor d'a extensión d'o certificau no ye valido.
sec-error-extension-not-found = No s'ha trobau a extensión d'o certificau.
sec-error-ca-cert-invalid = O certificau de l'emisor no ye valido.
sec-error-path-len-constraint-invalid = A restricción d'a longaria d'o camín d'o certificau no ye valida.
sec-error-cert-usages-invalid = O campo d'usos d'o certificau no ye valido.
sec-internal-only = **Modulo NOMÁS interno**
sec-error-invalid-key = A clau no permite a operación solicitada.
sec-error-unknown-critical-extension = O certificau contiene una extensión critica desconoixida.
sec-error-old-crl = A nueva CRL no ye posterior a l'actual.
sec-error-no-email-cert = Sin zifrau u sinyaturas: encara no tiene garra certificau d'adreza de correu electronico.
sec-error-no-recipient-certs-query = Sin zifrau: no tiene ciertificaus ta cadagún d'os destinatarios.
sec-error-not-a-recipient = No se puede deszrifrar: no en ye un destinatario, u bien no s'ha trobau o certificau y a clau privada apropiaus.
sec-error-pkcs7-keyalg-mismatch = No se puede deszifrar: l'algorismo de zifrau d'a clau no corresponde con o suyo certificau.
sec-error-pkcs7-bad-signature = A verificación d'a sinyatura ha fallau: no s'ha trobau garra sinyatura, u se'n ha trobau masiadas, u bien os datos son inadequaus u malmesos.
sec-error-unsupported-keyalg = No se conoixe l'algorismo de clau u bien no ye implementau.
sec-error-decryption-disallowed = No se puede deszifrar: s'ha zifrau fendo servir un algorismo u una grandaria de clau no permitius.
xp-sec-fortezza-bad-card = A tarcheta Fortezza no s'ha inicializau correctament. Extraiga-la y torne-la ta o suyo emisor.
xp-sec-fortezza-no-card = No s'ha trobau garra tarcheta Fortezza
xp-sec-fortezza-none-selected = No s'ha trigau garra tarcheta Fortezza
xp-sec-fortezza-more-info = Trigue una personalidat ta aconseguir-ne mas información
xp-sec-fortezza-person-not-found = No s'ha trobau a personalidat
xp-sec-fortezza-no-more-info = No n'i hai mas información
xp-sec-fortezza-bad-pin = O PIN no ye valido
xp-sec-fortezza-person-error = No s'ha puesto inicializar as personalidatz de Fortezza.
sec-error-no-krl = No s'ha trobau garra KRL t'o certificau d'iste puesto.
sec-error-krl-expired = A KRL d'o certificau d'iste puesto ha venciu.
sec-error-krl-bad-signature = A KRL d'o certificau d'iste puesto no tiene una sinyatura valida.
sec-error-revoked-key = S'ha revocau a clau t'o certificau d'iste puesto.
sec-error-krl-invalid = A nueva KRL no tiene un formato valido.
sec-error-need-random = biblioteca de seguranza: s'amenistan datos aleatorios.
sec-error-no-module = biblioteca de seguranza: no i hai garra modulo de seguranza que pueda executar a operación solicitada.
sec-error-no-token = A tarcheta u o teste de seguranza no existen, cal que s'inicialicen, u bien s'han d'eliminar.
sec-error-read-only = biblioteca de seguranza: base de datos nomás de lectura.
sec-error-no-slot-selected = No s'ha trigau garra ranura u teste.
sec-error-cert-nickname-collision = Ya existe un certificau con a mesma embotada.
sec-error-key-nickname-collision = Ya existe una clau con a mesma embotada.
sec-error-safe-not-created = s'ha produciu una error en creyar l'obchecto seguro
sec-error-baggage-not-created = s'ha produciu una error en creyar l'obchecto de equipache
xp-java-remove-principal-error = No s'ha puesto eliminar o prencipal
xp-java-delete-privilege-error = No s'ha puesto eliminar o privilechio
xp-java-cert-not-exists-error = Iste prencipal no tiene un certificau
sec-error-bad-export-algorithm = No se permite l'algorismo que s'ha solicitau.
sec-error-exporting-certificates = S'ha produciu una error en mirar d'exportar os certificaus.
sec-error-importing-certificates = S'ha produciu una error en mirar d'importar os certificaus.
sec-error-pkcs12-decoding-pfx = No s'ha puesto importar.  S'ha produciu una error de descodificación.  O fichero no ye valido.
sec-error-pkcs12-invalid-mac = No s'ha puesto importar.  A MAC no ye valida.  A clau ye incorrecta u o fichero ye corrupto.
sec-error-pkcs12-unsupported-mac-algorithm = No s'ha puesto importar.  L'algorismo MAC no ye implementau.
sec-error-pkcs12-unsupported-transport-mode = No s'ha puesto importar.  Nomás s'admiten os modos de privacidat y integridat de clau.
sec-error-pkcs12-corrupt-pfx-structure = No s'ha puesto importar.  A estructura d'o fichero ye corrompida.
sec-error-pkcs12-unsupported-pbe-algorithm = No s'ha puesto importar.  L'algorismo de zifrau no ye implementau.
sec-error-pkcs12-unsupported-version = No s'ha puesto importar.  No funciona con a versión d'o fichero.
sec-error-pkcs12-privacy-password-incorrect = No s'ha puesto importar.  A clau de privacidat no ye correcta.
sec-error-pkcs12-cert-collision = No s'ha puesto importar.  Ya existe a mesma embotada en a base de datos.
sec-error-user-cancelled = L'usuario ha pretau Cancelar.
sec-error-pkcs12-duplicate-data = No s'ha importau, ya ye en a base de datos.
sec-error-message-send-aborted = No s'ha ninviau o mensache.
sec-error-inadequate-key-usage = L'uso d'a clau d'o certificau ye inadequada t'a operación que s'ha prebau.
sec-error-inadequate-cert-type = No s'ha aprobau a mena de certificau ta l'aplicación.
sec-error-cert-addr-mismatch = L'adreza en o certificau de sinyatura no coincide con l'adreza d'as cabeceras d'o mensache.
sec-error-pkcs12-unable-to-import-key = No s'ha puesto importar.  S'ha produciu una error en mirar d'importar a clau privada.
sec-error-pkcs12-importing-cert-chain = No s'ha puesto importar.  S'ha produciu una error en mirar d'importar a cadena de certificaus.
sec-error-pkcs12-unable-to-locate-object-by-name = No s'ha puesto exportar.  No s'ha puesto trobar o certificau u a clau fendo servir a embotada como parametro de busca.
sec-error-pkcs12-unable-to-export-key = No s'ha puesto exportar.  A clau privada no s'ha puesto trobar ni exportar.
sec-error-pkcs12-unable-to-write = No s'ha puesto exportar.  No s'ha puesto escribir o fichero d'exportación.
sec-error-pkcs12-unable-to-read = No s'ha puesto importar.  No s'ha puesto leyer o fichero d'importación.
sec-error-pkcs12-key-database-not-initialized = No s'ha puesto exportar.  A base de datos de claus ye malmesa u s'ha eliminau.
sec-error-keygen-fail = No s'ha puesto chenerar o par de claus publica/privada.
sec-error-invalid-password = A clau que s'ha introduciu no ye valida.  Trigue-ne unatra.
sec-error-retry-old-password = A clau antiga no s'ha introduciu correctament.  Prebe-lo de nuevas.
sec-error-bad-nickname = A embotada d'o certificau ya ye en uso.
sec-error-not-fortezza-issuer = A cadena FORTEZZA de l'atro cabo tiene un certificau que no ye de FORTEZZA.
sec-error-cannot-move-sensitive-key = Una clau sensible no puede mover-se a la ranura an s'ameniste.
sec-error-js-invalid-module-name = O nombre d'o modulo no ye valido.
sec-error-js-invalid-dll = O camín u o nombre d'o fichero d'o modulo no ye valido
sec-error-js-add-mod-failure = No s'ha puesto adhibir o modulo
sec-error-js-del-mod-failure = No s'ha puesto eliminar o modulo
sec-error-old-krl = A nueva KRL no ye posterior a l'actual.
sec-error-ckl-conflict = A nueva CKL tiene un emisor diferent que l'actual.  Elimine l'actual.
sec-error-cert-not-in-name-space = L'entidat certificadera d'iste certificau no puede emitir un certificau con este nombre.
sec-error-krl-not-yet-valid = A lista de revocación de claus d'iste certificau no ye encara valida.
sec-error-crl-not-yet-valid = A lista de revocación de certificaus d'iste certificau no ye encara valida.
sec-error-unknown-cert = No s'ha puesto trobar o certificau solicitau.
sec-error-unknown-signer = No s'ha puesto trobar o certificau d'o sinyador.
sec-error-cert-bad-access-location = L'adreza d'o servidor d'estau d'o certificau no tiene un formato valido.
sec-error-ocsp-unknown-response-type = A respuesta OCSP no puede decodificar-se de raso; ye d'una mena desconoixida.
sec-error-ocsp-bad-http-response = O servidor OCSP ha devuelto datos HTTP no asperaus u no validos.
sec-error-ocsp-malformed-request = O servidor OCSP ha trobau que a solicitut yera malmesa u mal formada.
sec-error-ocsp-server-error = O servidor OCSP ha experimentau una error interna.
sec-error-ocsp-try-server-later = O servidor OCSP suchiere que lo intente de nuevas mas entabant.
sec-error-ocsp-request-needs-sig = O servidor OCSP requiere una sinyatura con ista solicitut.
sec-error-ocsp-unauthorized-request = O servidor OCSP ha refusau ista solicitut como no autorizada.
sec-error-ocsp-unknown-response-status = O servidor OCSP ha devuelto un estau no reconoixible.
sec-error-ocsp-unknown-cert = O servidor OCSP no tiene garra estau t'o certificau.
sec-error-ocsp-not-enabled = Ha d'activar OCSP antes d'executar ista operación.
sec-error-ocsp-no-default-responder = Ha d'establir o respondedor OCSP predeterminau antes d'executar ista operación.
sec-error-ocsp-malformed-response = A respuesta d'o servidor OCSP yera malmesa u mal formada.
sec-error-ocsp-unauthorized-response = O sinyador d'a respuesta OCSP no ye autorizau a proporcionar o estau d'iste certificau.
sec-error-ocsp-future-response = A respuesta OCSP no ye encara valida (contiene una calendata d'o futuro).
sec-error-ocsp-old-response = A respuesta OCSP contiene información obsoleta.
sec-error-digest-not-found = No s'ha trobau o CMS u o resumen PKCS #7 en o mensache sinyau.
sec-error-unsupported-message-type = No s'accepta o CMS u a mena de mensache PKCS #7.
sec-error-module-stuck = O modulo PKCS #11 no s'ha puesto eliminar porque ye encara en uso.
sec-error-bad-template = No s'ha puesto decodificar os datos ASN.1. A plantilla especificada no ye valida.
sec-error-crl-not-found = No s'ha trobau garra CRL adequada.
sec-error-reused-issuer-and-serial = Ye mirando d'importar un certificau con o mesmo numero de serie/emisor que un certificau ya existent, pero que no ye o mesmo certificau.
sec-error-busy = No s'ha puesto zarrar o NSS. Os obchectos encara son en uso.
sec-error-extra-input = O mensache codificau con DER conteneba datos suplementarios no emplegaus.
sec-error-unsupported-elliptic-curve = Curva eliptica no implementada.
sec-error-unsupported-ec-point-form = Forma de punto de curva eliptica no implementada.
sec-error-unrecognized-oid = No se reconoixe l'iidentificador d'obchecto.
sec-error-ocsp-invalid-signing-cert = O certificau de sinyatura OCSP no ye valiu en a respuesta OCSP.
sec-error-revoked-certificate-crl = S'ha revocau o certificau en a lista de revocación de certificaus de l'emisor.
sec-error-revoked-certificate-ocsp = O respondedor OCSP de l'emisor informa que o certificau ye revocau.
sec-error-crl-invalid-version = A lista de revocación de certificaus de l'emisor tiene un numero de versión desconoixiu.
sec-error-crl-v1-critical-extension = A lista de revocación de certificaus V1 de l'emisor tiene una extensión critica.
sec-error-crl-unknown-critical-extension = A lista de revocación de certificaus V2 de l'emisor tiene una extensión critica desconoixida.
sec-error-unknown-object-type = S'ha especificau una mena d'obchecto desconoixida.
sec-error-incompatible-pkcs11 = O controlador PKCS #11 viola a especificación d'una traza incompatible.
sec-error-no-event = No i hai garra evento de nueva ranura disponible en iste momento.
sec-error-crl-already-exists = A CRL ya existe.
sec-error-not-initialized = No s'ha incialiciau o NSS.
sec-error-token-not-logged-in = A operación ha fallau porque no s'ha encetau a sesión d'o teste PKCS#11.
sec-error-ocsp-responder-cert-invalid = O certificau de respuesta OCSP configurau no ye valido.
sec-error-ocsp-bad-signature = A respuesta OCSP no tiene una sinyatura valida.
sec-error-out-of-search-limits = A busca de validación d'o certificau ye difuera d'os limites de busca
sec-error-invalid-policy-mapping = A correspondencia de normas d'un certificau contiene a valor inadequada «anypolicy»
sec-error-policy-validation-failed = A cadena de certifición falla en a validación de politicas
sec-error-unknown-aia-location-type = A mena d'ubicación en a extensión de certificau AIA ye desconoixida
sec-error-bad-http-response = O servidor ha devuelto una respuesta HTTP no correcta
sec-error-bad-ldap-response = O servidor ha devuelto una respuesta LDAP no correcta
sec-error-failed-to-encode-data = No s'ha puesto zifrar os datos con o codificador ASN1
sec-error-bad-info-access-location = L'información d'acceso d'a ubicación en a extension de certificau no ye valida
sec-error-libpkix-internal = S'ha produciu una error interna Libpkix entre a validación de certificau.
sec-error-pkcs11-general-error = Un modulo PKCS #11 ha devuelto una error CKR_GENERAL_ERROR, indicando que s'ha produciu una error irrecuperable.
sec-error-pkcs11-function-failed = Un modulo PKCS #11 ha devuelto una falla CKR_FUNCTION_FAILED, indicando que a función solicitada no s'ha puesto executar.  Si preba a mesma operación de nuevas podría tener exito.
sec-error-pkcs11-device-error = Un modulo PKCS #11 ha devuelto una error CKR_DEVICE_ERROR, indicando que s'ha produciu un problema con o teste u a ranura.
sec-error-bad-info-access-method = O metodo d'acceso a la información en a extensión de certificau ye desconoixiu.
sec-error-crl-import-failed = S'ha produciu una error en mirar d'importar una CRL.
sec-error-expired-password = A clau ha caducau.
sec-error-locked-password = A clau s'ha blocau.
sec-error-unknown-pkcs11-error = Error desconoixida PKCS #11.
sec-error-bad-crl-dp-url = URL no valida u no soportada en o punto de distribución CRL.
sec-error-cert-signature-algorithm-disabled = O certificau s'ha sinyau con un algorismo que s'ha inhabilitau porque no ye seguro.
mozilla-pkix-error-key-pinning-failure = O servidor usa key pinning (HPKP) pero s'ha puesto construir garra cadena de certificaus confiables que concuerde con o pinset. As violacions d'o key pinning no se pueden ignorar.
mozilla-pkix-error-ca-cert-used-as-end-entity = O servidor fa servir un certificau con una extensión de restriccions basica, que lo identifica como una autoridat de certificaus. Esto no habría de pasar en un certificau correctament emeso.
mozilla-pkix-error-inadequate-key-size = O servidor presentó un certificado con una mida de clau masiau chicota como ta establir una connexión segura.
mozilla-pkix-error-v1-cert-used-as-ca = S'ha usau un certificau X.509 versión 1 que no ye una ancora de confianza pa emeter o certificau d'o servidor. Os certificaus X.509 versión 1 son obsoletos y no s'habrían d'emplegar pa sinyar atros certificaus.
mozilla-pkix-error-not-yet-valid-certificate = O servidor ha presentau un certificau que encara no ye valido.
mozilla-pkix-error-not-yet-valid-issuer-certificate = En a emisión d'o certificau d'o servidor s'ha usau  un certificau que encara no ye valido.
mozilla-pkix-error-signature-algorithm-mismatch = L'algoritmo de sinaydura d'o campo de sinyadura d'o certificau no coincide con l'algorismo d'o campo «signatureAlgorithm».
mozilla-pkix-error-ocsp-response-for-cert-missing = A rispuesta OCSP no incluye un estau ta lo certificau que ye verificando-se.
mozilla-pkix-error-validity-too-long = O servidor ha presentau un certificau que ye valido pa masiau tiempo.
mozilla-pkix-error-required-tls-feature-missing = Falta una caracteristica TLS necesaria.
mozilla-pkix-error-invalid-integer-encoding = Lo servidor ha presentau un certificau que contién una codificación invalida d'un entero. Las causas mas comuns son numeros de serie negativos, modulos RSA negativos y codificacions que son mas grans d'o que cal.
mozilla-pkix-error-empty-issuer-name = Lo servidor ha presentau un certificau con un nombre d'emisor vuedo.
mozilla-pkix-error-additional-policy-constraint-failed = Una restricción de politica adicional ha fallau quan se validaba este certificau.
mozilla-pkix-error-self-signed-cert = Lo certificau no ye confiable per estar auto-firmau.
