/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_IPC_C 1

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#include "gatos.h"
#include "ipc.h"

static int msgqueue_id; 

/* ------------------------------------------------------------------------ */

int ipc_init_message(void) { 
  key_t key; 
  
  key = ftok(LIBGATOS_PATH, 'm'); 
  if((msgqueue_id = msgget(key, IPC_CREAT|0666)) == -1) { 
    if(VERBOSE) {   
      fprintf(stderr, "Can't create message queue.\n");  
      fflush(stderr);  
      }  
    return(0); 
    } 
  else { 
    if(VERBOSE) { 
      fprintf(stderr, "Message queue created.\n");  
      fflush(stderr); 
      } 
    } 
  return(1); 
  } 

/* ------------------------------------------------------------------------ */

int ipc_send_message(char *message) {
  struct gatosmsgbuf qbuf;

  qbuf.mtype = 1;
  strcpy(qbuf.mtext, message);
  if((msgsnd(msgqueue_id, (struct msgbuf *)&qbuf, 
             strlen(qbuf.mtext)+1, 0)) == -1) {
    return(0);
    }
  return(1);
  }

/* ----------------------------------------------------------------------- */

int ipc_receive_message(char *message) { 
  struct gatosmsgbuf qbuf;
  int retval;

  qbuf.mtype = 1;
  if((retval = msgrcv(msgqueue_id, (struct gatosmsgbuf *)&qbuf, 
                      80, 1, 0)) == -1 ) {
    message = "NOMESSAGE";
    return(0);
    }
  strcpy(message, qbuf.mtext); 
  return(1); 
  }

/* ------------------------------------------------------------------------ */

int ipc_delete_message(void){
  int retval;
  
  if((retval = msgctl(msgqueue_id, IPC_RMID, 0)) == -1) {
    if(VERBOSE) {
      fprintf(stderr, "Can't close message queue.\n");
      fflush(stderr);
      }
    return(0);
    }
  else {
    if(VERBOSE) {
      fprintf(stderr, "Message queue closed.\n");
      fflush(stderr);
      }
    }
  return(1);
  }

/* ------------------------------------------------------------------------ */
