/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.gui.MasterPanel;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIFiomeths;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.StringHandler;
import geotrans3.utility.DATFileFilter;
import geotrans3.utility.Directory;
import geotrans3.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class CreateFileHeaderDlg
extends JDialog {
    private Directory currentDir;
    private MasterPanel headerPanel;
    private JFrame parentFrame;
    private FormatOptions options;
    private JNICoordinateConversionService jniCoordinateConversionService;
    private JPanel createFileHeaderPanel;
    private JPanel buttonsPanel;
    private JButton createButton;
    private JButton cancelButton;

    public CreateFileHeaderDlg(JNICoordinateConversionService jNICoordinateConversionService, JFrame jFrame, boolean bl, Directory directory, FormatOptions formatOptions, StringHandler stringHandler) {
        super((Frame)jFrame, bl);
        this.jniCoordinateConversionService = jNICoordinateConversionService;
        this.currentDir = directory;
        this.options = formatOptions;
        this.parentFrame = jFrame;
        this.initComponents();
        this.headerPanel = new MasterPanel(jNICoordinateConversionService, 2, 1, formatOptions, stringHandler);
        this.createFileHeaderPanel.add((Component)this.headerPanel, "Center");
        this.pack();
        Utility.center(jFrame, this);
    }

    private void initComponents() {
        this.createFileHeaderPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.createButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Create File Header");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CreateFileHeaderDlg.this.closeDialog(windowEvent);
            }
        });
        this.createFileHeaderPanel.setLayout(new BorderLayout());
        this.createFileHeaderPanel.setPreferredSize(new Dimension(467, 185));
        this.createFileHeaderPanel.setBorder(new LineBorder(Color.black));
        this.createFileHeaderPanel.setMinimumSize(new Dimension(467, 185));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().add((Component)this.createFileHeaderPanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setPreferredSize(new Dimension(330, 50));
        this.buttonsPanel.setMinimumSize(new Dimension(330, 50));
        this.createButton.setPreferredSize(new Dimension(80, 21));
        this.createButton.setBorder(new BevelBorder(0));
        this.createButton.setMnemonic(67);
        this.createButton.setMaximumSize(new Dimension(80, 21));
        this.createButton.setText("Create");
        this.createButton.setMinimumSize(new Dimension(80, 21));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFileHeaderDlg.this.createButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 12, 45);
        this.buttonsPanel.add((Component)this.createButton, gridBagConstraints2);
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setMnemonic(65);
        this.cancelButton.setMaximumSize(new Dimension(80, 21));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(80, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFileHeaderDlg.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 12, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
        jFileChooser.setDialogTitle("Save As");
        jFileChooser.addChoosableFileFilter(new DATFileFilter());
        jFileChooser.setSelectedFile(new File("*.dat"));
        int n = jFileChooser.showSaveDialog(this.parentFrame);
        if (n == 0) {
            if (!this.headerPanel.getError()) {
                File file = jFileChooser.getSelectedFile();
                this.currentDir.setDirectory(file.getAbsolutePath());
                if (file != null) {
                    JNIFiomeths jNIFiomeths = null;
                    try {
                        jNIFiomeths = new JNIFiomeths();
                        jNIFiomeths.setUseNSEW(this.options.getUseNSEW());
                        jNIFiomeths.setUseMinutes(this.options.getUseMinutes());
                        jNIFiomeths.setUseSeconds(this.options.getUseSeconds());
                        jNIFiomeths.setLatLongPrecision(this.options.getPrecision());
                        jNIFiomeths.setLeadingZeros(this.options.getLeadingZeros());
                        jNIFiomeths.setSeparator(this.options.getSeparator());
                        jNIFiomeths.setLonRange(this.options.getRange());
                        if (this.headerPanel.getProjectionType() == 10) {
                            jNIFiomeths.setGeodeticCoordinateOrder(this.headerPanel.getCoordinateOrder());
                        }
                        jNIFiomeths.setOutputFilename(file.getPath(), this.headerPanel.getDatumCode(), this.headerPanel.getParameters());
                        jNIFiomeths.writeExampleCoord();
                        JOptionPane.showMessageDialog(this.parentFrame, "File header creation complete.", new StringHandler().getTitle(), -1);
                        this.dispose();
                    }
                    catch (CoordinateConversionException coordinateConversionException) {
                        new StringHandler().displayErrorMsg(this, coordinateConversionException.getMessage());
                    }
                    catch (Exception exception) {
                        new StringHandler().displayErrorMsg(this, exception.getMessage());
                    }
                    finally {
                        try {
                            jNIFiomeths.closeOutputFile();
                        }
                        catch (Exception exception) {
                            new StringHandler().displayErrorMsg(this, exception.getMessage());
                        }
                        if (jNIFiomeths != null) {
                            jNIFiomeths.destroy();
                        }
                    }
                }
            } else {
                this.headerPanel.showErrors(this);
            }
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

