//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GovernanceRulesClient contains the methods for the GovernanceRules group.
// Don't use this type directly, use NewGovernanceRulesClient() instead.
type GovernanceRulesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewGovernanceRulesClient creates a new instance of GovernanceRulesClient with the specified values.
// subscriptionID - Azure subscription ID
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewGovernanceRulesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GovernanceRulesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &GovernanceRulesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or update a security GovernanceRule on the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
// ruleID - The security GovernanceRule key - unique key for the standard GovernanceRule
// governanceRule - GovernanceRule over a subscription scope
// options - GovernanceRulesClientCreateOrUpdateOptions contains the optional parameters for the GovernanceRulesClient.CreateOrUpdate
// method.
func (client *GovernanceRulesClient) CreateOrUpdate(ctx context.Context, ruleID string, governanceRule GovernanceRule, options *GovernanceRulesClientCreateOrUpdateOptions) (GovernanceRulesClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, ruleID, governanceRule, options)
	if err != nil {
		return GovernanceRulesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GovernanceRulesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return GovernanceRulesClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *GovernanceRulesClient) createOrUpdateCreateRequest(ctx context.Context, ruleID string, governanceRule GovernanceRule, options *GovernanceRulesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/governanceRules/{ruleId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, governanceRule)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *GovernanceRulesClient) createOrUpdateHandleResponse(resp *http.Response) (GovernanceRulesClientCreateOrUpdateResponse, error) {
	result := GovernanceRulesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GovernanceRule); err != nil {
		return GovernanceRulesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a GovernanceRule over a given scope
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
// ruleID - The security GovernanceRule key - unique key for the standard GovernanceRule
// options - GovernanceRulesClientDeleteOptions contains the optional parameters for the GovernanceRulesClient.Delete method.
func (client *GovernanceRulesClient) Delete(ctx context.Context, ruleID string, options *GovernanceRulesClientDeleteOptions) (GovernanceRulesClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, ruleID, options)
	if err != nil {
		return GovernanceRulesClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GovernanceRulesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return GovernanceRulesClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return GovernanceRulesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *GovernanceRulesClient) deleteCreateRequest(ctx context.Context, ruleID string, options *GovernanceRulesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/governanceRules/{ruleId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Get a specific governanceRule for the requested scope by ruleId
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
// ruleID - The security GovernanceRule key - unique key for the standard GovernanceRule
// options - GovernanceRulesClientGetOptions contains the optional parameters for the GovernanceRulesClient.Get method.
func (client *GovernanceRulesClient) Get(ctx context.Context, ruleID string, options *GovernanceRulesClientGetOptions) (GovernanceRulesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, ruleID, options)
	if err != nil {
		return GovernanceRulesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GovernanceRulesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GovernanceRulesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *GovernanceRulesClient) getCreateRequest(ctx context.Context, ruleID string, options *GovernanceRulesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/governanceRules/{ruleId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GovernanceRulesClient) getHandleResponse(resp *http.Response) (GovernanceRulesClientGetResponse, error) {
	result := GovernanceRulesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GovernanceRule); err != nil {
		return GovernanceRulesClientGetResponse{}, err
	}
	return result, nil
}

// BeginRuleIDExecuteSingleSecurityConnector - Execute a security GovernanceRule on the given security connector.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
// resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
// securityConnectorName - The security connector name.
// ruleID - The security GovernanceRule key - unique key for the standard GovernanceRule
// options - GovernanceRulesClientBeginRuleIDExecuteSingleSecurityConnectorOptions contains the optional parameters for the
// GovernanceRulesClient.BeginRuleIDExecuteSingleSecurityConnector method.
func (client *GovernanceRulesClient) BeginRuleIDExecuteSingleSecurityConnector(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, options *GovernanceRulesClientBeginRuleIDExecuteSingleSecurityConnectorOptions) (*runtime.Poller[GovernanceRulesClientRuleIDExecuteSingleSecurityConnectorResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.ruleIDExecuteSingleSecurityConnector(ctx, resourceGroupName, securityConnectorName, ruleID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[GovernanceRulesClientRuleIDExecuteSingleSecurityConnectorResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[GovernanceRulesClientRuleIDExecuteSingleSecurityConnectorResponse](options.ResumeToken, client.pl, nil)
	}
}

// RuleIDExecuteSingleSecurityConnector - Execute a security GovernanceRule on the given security connector.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
func (client *GovernanceRulesClient) ruleIDExecuteSingleSecurityConnector(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, options *GovernanceRulesClientBeginRuleIDExecuteSingleSecurityConnectorOptions) (*http.Response, error) {
	req, err := client.ruleIDExecuteSingleSecurityConnectorCreateRequest(ctx, resourceGroupName, securityConnectorName, ruleID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// ruleIDExecuteSingleSecurityConnectorCreateRequest creates the RuleIDExecuteSingleSecurityConnector request.
func (client *GovernanceRulesClient) ruleIDExecuteSingleSecurityConnectorCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, options *GovernanceRulesClientBeginRuleIDExecuteSingleSecurityConnectorOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/providers/Microsoft.Security/governanceRules/{ruleId}/execute"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ExecuteGovernanceRuleParams != nil {
		return req, runtime.MarshalAsJSON(req, *options.ExecuteGovernanceRuleParams)
	}
	return req, nil
}

// BeginRuleIDExecuteSingleSubscription - Execute a security GovernanceRule on the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
// ruleID - The security GovernanceRule key - unique key for the standard GovernanceRule
// options - GovernanceRulesClientBeginRuleIDExecuteSingleSubscriptionOptions contains the optional parameters for the GovernanceRulesClient.BeginRuleIDExecuteSingleSubscription
// method.
func (client *GovernanceRulesClient) BeginRuleIDExecuteSingleSubscription(ctx context.Context, ruleID string, options *GovernanceRulesClientBeginRuleIDExecuteSingleSubscriptionOptions) (*runtime.Poller[GovernanceRulesClientRuleIDExecuteSingleSubscriptionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.ruleIDExecuteSingleSubscription(ctx, ruleID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[GovernanceRulesClientRuleIDExecuteSingleSubscriptionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[GovernanceRulesClientRuleIDExecuteSingleSubscriptionResponse](options.ResumeToken, client.pl, nil)
	}
}

// RuleIDExecuteSingleSubscription - Execute a security GovernanceRule on the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01-preview
func (client *GovernanceRulesClient) ruleIDExecuteSingleSubscription(ctx context.Context, ruleID string, options *GovernanceRulesClientBeginRuleIDExecuteSingleSubscriptionOptions) (*http.Response, error) {
	req, err := client.ruleIDExecuteSingleSubscriptionCreateRequest(ctx, ruleID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// ruleIDExecuteSingleSubscriptionCreateRequest creates the RuleIDExecuteSingleSubscription request.
func (client *GovernanceRulesClient) ruleIDExecuteSingleSubscriptionCreateRequest(ctx context.Context, ruleID string, options *GovernanceRulesClientBeginRuleIDExecuteSingleSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/governanceRules/{ruleId}/execute"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ExecuteGovernanceRuleParams != nil {
		return req, runtime.MarshalAsJSON(req, *options.ExecuteGovernanceRuleParams)
	}
	return req, nil
}
